#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
/*
 * TLogServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/Hash3.h"
#include "flow/UnitTest.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/Notified.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/SpanContextMessage.h"
#include "fdbserver/TLogInterface.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/MutationTracking.h"
#include "flow/ActorCollection.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbserver/IDiskQueue.h"
#include "fdbrpc/sim_validation.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/Stats.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "flow/Histogram.h"
#include "flow/DebugTrace.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct TLogQueueEntryRef {
	UID id;
	Version version;
	Version knownCommittedVersion;
	StringRef messages;
	TLogQueueEntryRef() : version(0), knownCommittedVersion(0) {}
	TLogQueueEntryRef(Arena& a, TLogQueueEntryRef const& from)
	  : id(from.id), version(from.version), knownCommittedVersion(from.knownCommittedVersion),
	    messages(a, from.messages) {}

	// To change this serialization, ProtocolVersion::TLogQueueEntryRef must be updated, and downgrades need to be
	// considered
	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, version, messages, knownCommittedVersion, id);
	}
	size_t expectedSize() const { return messages.expectedSize(); }
};

struct AlternativeTLogQueueEntryRef {
	UID id;
	Version version;
	Version knownCommittedVersion;
	std::vector<TagsAndMessage>* alternativeMessages;

	AlternativeTLogQueueEntryRef() : version(0), knownCommittedVersion(0), alternativeMessages(nullptr) {}

	template <class Ar>
	void serialize(Ar& ar) {
		ASSERT(!ar.isDeserializing && alternativeMessages);
		uint32_t msgSize = expectedSize();
		serializer(ar, version, msgSize);
		for (auto& msg : *alternativeMessages) {
			ar.serializeBytes(msg.message);
		}
		serializer(ar, knownCommittedVersion, id);
	}

	uint32_t expectedSize() const {
		uint32_t msgSize = 0;
		for (auto& msg : *alternativeMessages) {
			msgSize += msg.message.size();
		}
		return msgSize;
	}
};

typedef Standalone<TLogQueueEntryRef> TLogQueueEntry;
struct LogData;
struct TLogData;

struct TLogQueue final : public IClosable {
public:
	TLogQueue(IDiskQueue* queue, UID dbgid) : queue(queue), dbgid(dbgid) {}

	// Each packet in the queue is
	//    uint32_t payloadSize
	//    uint8_t payload[payloadSize]  (begins with uint64_t protocolVersion via IncludeVersion)
	//    uint8_t validFlag

	// TLogQueue is a durable queue of TLogQueueEntry objects with an interface similar to IDiskQueue

	// TLogQueue pushes (but not commits) are atomic - after commit fails to return, a prefix of entire calls to push
	// are durable.  This is
	//    implemented on top of the weaker guarantee of IDiskQueue::commit (that a prefix of bytes is durable) using
	//    validFlag and by padding any incomplete packet with zeros after recovery.

	// Before calling push, pop, or commit, the user must call readNext() until it throws
	//    end_of_stream(). It may not be called again thereafter.
	Future<TLogQueueEntry> readNext(TLogData* tLog) { return readNext(this, tLog); }

	Future<bool> initializeRecovery(IDiskQueue::location recoverAt) { return queue->initializeRecovery(recoverAt); }

	template <class T>
	void push(T const& qe, Reference<LogData> logData);
	void forgetBefore(Version upToVersion, Reference<LogData> logData);
	void pop(IDiskQueue::location upToLocation);
	Future<Void> commit() { return queue->commit(); }

	// Implements IClosable
	Future<Void> getError() const override { return queue->getError(); }
	Future<Void> onClosed() const override { return queue->onClosed(); }
	void dispose() override {
		queue->dispose();
		delete this;
	}
	void close() override {
		queue->close();
		delete this;
	}

private:
	IDiskQueue* queue;
	UID dbgid;

	void updateVersionSizes(const TLogQueueEntry& result,
	                        TLogData* tLog,
	                        IDiskQueue::location start,
	                        IDiskQueue::location end);

																#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
// This generated class is to be used only via readNext()
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class ReadNextActor>
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ReadNextActorState {
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ReadNextActorState(TLogQueue* const& self,TLogData* const& tLog) 
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tLog(tLog),
															#line 153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   result(),
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   zeroFillSize(0)
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readNext", reinterpret_cast<unsigned long>(this));

	}
	~ReadNextActorState() 
	{
		fdb_probe_actor_destroy("readNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (zeroFillSize)
															#line 211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 191 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "Fixing a partial commit at the end of the tlog queue", probe::decoration::rare);
															#line 192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(int i = 0;i < zeroFillSize;i++) {
															#line 193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				self->queue->push(StringRef((const uint8_t*)"", 1));
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		return a_body1Catch1(end_of_stream(), loopDepth);
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		startloc = self->queue->getNextReadLocation();
															#line 158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_0 = self->queue->readNext(sizeof(uint32_t));
															#line 158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 0, Standalone<StringRef> >*>(static_cast<ReadNextActor*>(this)));
															#line 248 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> const& h,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (h.size() != sizeof(uint32_t))
															#line 270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (h.size())
															#line 274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				CODE_PROBE(true, "Zero fill within size field", probe::decoration::rare);
															#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				int payloadSize = 0;
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				memcpy(&payloadSize, h.begin(), h.size());
															#line 164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				zeroFillSize = sizeof(uint32_t) - h.size();
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				zeroFillSize += payloadSize + 1;
															#line 286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		payloadSize = *(uint32_t*)h.begin();
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(payloadSize < (100 << 20));
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = self->queue->readNext(payloadSize + 1);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 298 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 2;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*>(static_cast<ReadNextActor*>(this)));
															#line 303 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> && h,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (h.size() != sizeof(uint32_t))
															#line 312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (h.size())
															#line 316 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				CODE_PROBE(true, "Zero fill within size field", probe::decoration::rare);
															#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				int payloadSize = 0;
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				memcpy(&payloadSize, h.begin(), h.size());
															#line 164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				zeroFillSize = sizeof(uint32_t) - h.size();
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				zeroFillSize += payloadSize + 1;
															#line 328 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		payloadSize = *(uint32_t*)h.begin();
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(payloadSize < (100 << 20));
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = self->queue->readNext(payloadSize + 1);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 340 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 2;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*>(static_cast<ReadNextActor*>(this)));
															#line 345 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> const& h,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(h, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> && h,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(h), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Standalone<StringRef> const& e,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (e.size() != payloadSize + 1)
															#line 429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "Zero fill within payload", probe::decoration::rare);
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			zeroFillSize = payloadSize + 1 - e.size();
															#line 435 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (e[payloadSize])
															#line 440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(e[payloadSize] == 1);
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Arena a = e.arena();
															#line 183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ArenaReader ar(a, e.substr(0, payloadSize), IncludeVersion());
															#line 184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ar >> result;
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			const IDiskQueue::location endloc = self->queue->getNextReadLocation();
															#line 186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->updateVersionSizes(result, tLog, startloc, endloc);
															#line 187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<ReadNextActor*>(this)->SAV<TLogQueueEntry>::futures) { (void)(result); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<ReadNextActor*>(this)->SAV< TLogQueueEntry >::value()) TLogQueueEntry(std::move(result)); // state_var_RVO
			this->~ReadNextActorState();
			static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<StringRef> && e,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (e.size() != payloadSize + 1)
															#line 470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "Zero fill within payload", probe::decoration::rare);
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			zeroFillSize = payloadSize + 1 - e.size();
															#line 476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (e[payloadSize])
															#line 481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(e[payloadSize] == 1);
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Arena a = e.arena();
															#line 183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ArenaReader ar(a, e.substr(0, payloadSize), IncludeVersion());
															#line 184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ar >> result;
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			const IDiskQueue::location endloc = self->queue->getNextReadLocation();
															#line 186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->updateVersionSizes(result, tLog, startloc, endloc);
															#line 187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<ReadNextActor*>(this)->SAV<TLogQueueEntry>::futures) { (void)(result); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 497 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<ReadNextActor*>(this)->SAV< TLogQueueEntry >::value()) TLogQueueEntry(std::move(result)); // state_var_RVO
			this->~ReadNextActorState();
			static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<StringRef> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<StringRef> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogQueue* self;
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* tLog;
															#line 153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogQueueEntry result;
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int zeroFillSize;
															#line 157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	IDiskQueue::location startloc;
															#line 170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	uint32_t payloadSize;
															#line 594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readNext()
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ReadNextActor final : public Actor<TLogQueueEntry>, public ActorCallback< ReadNextActor, 0, Standalone<StringRef> >, public ActorCallback< ReadNextActor, 1, Standalone<StringRef> >, public FastAllocated<ReadNextActor>, public ReadNextActorState<ReadNextActor> {
															#line 599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadNextActor>::operator new;
	using FastAllocated<ReadNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14302774200161459200UL, 1361452680614109952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TLogQueueEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadNextActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< ReadNextActor, 1, Standalone<StringRef> >;
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ReadNextActor(TLogQueue* const& self,TLogData* const& tLog) 
															#line 617 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<TLogQueueEntry>(),
		   ReadNextActorState<ReadNextActor>(self, tLog),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8157539301062630144UL, 4791951039325370368UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadNextActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] static Future<TLogQueueEntry> readNext( TLogQueue* const& self, TLogData* const& tLog ) {
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<TLogQueueEntry>(new ReadNextActor(self, tLog));
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
};

////// Persistence format (for self->persistentData)

// Immutable keys
// persistFormat has been mostly invalidated by TLogVersion, and can probably be removed when
// 4.6's TLog code is removed.
static const KeyValueRef persistFormat("Format"_sr, "FoundationDB/LogServer/3/0"_sr);
static const KeyRangeRef persistFormatReadableRange("FoundationDB/LogServer/3/0"_sr, "FoundationDB/LogServer/4/0"_sr);
static const KeyRangeRef persistProtocolVersionKeys("ProtocolVersion/"_sr, "ProtocolVersion0"_sr);
static const KeyRangeRef persistTLogSpillTypeKeys("TLogSpillType/"_sr, "TLogSpillType0"_sr);
static const KeyRangeRef persistRecoveryCountKeys = KeyRangeRef("DbRecoveryCount/"_sr, "DbRecoveryCount0"_sr);

// Updated on updatePersistentData()
static const KeyRangeRef persistCurrentVersionKeys = KeyRangeRef("version/"_sr, "version0"_sr);
static const KeyRangeRef persistKnownCommittedVersionKeys = KeyRangeRef("knownCommitted/"_sr, "knownCommitted0"_sr);
static const KeyRef persistRecoveryLocationKey = KeyRef("recoveryLocation"_sr);
static const KeyRangeRef persistLocalityKeys = KeyRangeRef("Locality/"_sr, "Locality0"_sr);
static const KeyRangeRef persistLogRouterTagsKeys = KeyRangeRef("LogRouterTags/"_sr, "LogRouterTags0"_sr);
static const KeyRangeRef persistTxsTagsKeys = KeyRangeRef("TxsTags/"_sr, "TxsTags0"_sr);
static const KeyRange persistTagMessagesKeys = prefixRange("TagMsg/"_sr);
static const KeyRange persistTagMessageRefsKeys = prefixRange("TagMsgRef/"_sr);
static const KeyRange persistTagPoppedKeys = prefixRange("TagPop/"_sr);

static const KeyRef persistEncryptionAtRestModeKey = "encryptionAtRestMode"_sr;

static Key persistTagMessagesKey(UID id, Tag tag, Version version) {
	BinaryWriter wr(Unversioned());
	wr.serializeBytes(persistTagMessagesKeys.begin);
	wr << id;
	wr << tag;
	wr << bigEndian64(version);
	return wr.toValue();
}

static Key persistTagMessageRefsKey(UID id, Tag tag, Version version) {
	BinaryWriter wr(Unversioned());
	wr.serializeBytes(persistTagMessageRefsKeys.begin);
	wr << id;
	wr << tag;
	wr << bigEndian64(version);
	return wr.toValue();
}

static Key persistTagPoppedKey(UID id, Tag tag) {
	BinaryWriter wr(Unversioned());
	wr.serializeBytes(persistTagPoppedKeys.begin);
	wr << id;
	wr << tag;
	return wr.toValue();
}

static Value persistTagPoppedValue(Version popped) {
	return BinaryWriter::toValue(popped, Unversioned());
}

static Tag decodeTagPoppedKey(KeyRef id, KeyRef key) {
	Tag s;
	BinaryReader rd(key.removePrefix(persistTagPoppedKeys.begin).removePrefix(id), Unversioned());
	rd >> s;
	return s;
}

static Version decodeTagPoppedValue(ValueRef value) {
	return BinaryReader::fromStringRef<Version>(value, Unversioned());
}

static StringRef stripTagMessagesKey(StringRef key) {
	return key.substr(sizeof(UID) + sizeof(Tag) + persistTagMessagesKeys.begin.size());
}

static Version decodeTagMessagesKey(StringRef key) {
	return bigEndian64(BinaryReader::fromStringRef<Version>(stripTagMessagesKey(key), Unversioned()));
}

struct SpilledData {
	SpilledData() = default;
	SpilledData(Version version, IDiskQueue::location start, uint32_t length, uint32_t mutationBytes)
	  : version(version), start(start), length(length), mutationBytes(mutationBytes) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, version, start, length, mutationBytes);
	}

	Version version = 0;
	IDiskQueue::location start = 0;
	uint32_t length = 0;
	uint32_t mutationBytes = 0;
};

struct TLogData : NonCopyable {
	AsyncTrigger newLogData;
	// A process has only 1 SharedTLog, which holds data for multiple logs, so that it obeys its assigned memory limit.
	// A process has only 1 active log and multiple non-active log from old generations.
	// In the figure below, TLog [1-4] are logs from old generations.
	// Because SS may need to pull data from old generation log, we keep Tlog [1-4].
	//
	//  We always pop the disk queue from the oldest TLog, spill from the oldest TLog that still has
	//  data in memory, and commits to the disk queue come from the most recent TLog.
	//
	//                    SharedTLog
	//  +--------+--------+--------+--------+--------+
	//  | TLog 1 | TLog 2 | TLog 3 | TLog 4 | TLog 5 |
	//  +--------+--------+--------+--------+--------+
	//    ^ popOrder         ^spillOrder         ^committing
	//
	// ^popOrder is the location where SS reads the to-be-read data from tlog.
	// ^committing is the location where the active TLog accepts the pushed data.
	Deque<UID> popOrder;
	Deque<UID> spillOrder;
	std::map<UID, Reference<struct LogData>> id_data;

	UID dbgid;
	UID workerID;

	Optional<EncryptionAtRestMode> encryptionAtRestMode;

	IKeyValueStore* persistentData; // Durable data on disk that were spilled.
	IDiskQueue* rawPersistentQueue; // The physical queue the persistentQueue below stores its data. Ideally, log
	                                // interface should work without directly accessing rawPersistentQueue
	TLogQueue* persistentQueue; // Logical queue the log operates on and persist its data.

	int64_t diskQueueCommitBytes;
	AsyncVar<bool>
	    largeDiskQueueCommitBytes; // becomes true when diskQueueCommitBytes is greater than MAX_QUEUE_COMMIT_BYTES

	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
	Database cx;

	NotifiedVersion queueCommitEnd;
	Version queueCommitBegin;

	int64_t instanceID;
	int64_t bytesInput;
	int64_t bytesDurable;
	int64_t targetVolatileBytes; // The number of bytes of mutations this TLog should hold in memory before spilling.
	int64_t overheadBytesInput;
	int64_t overheadBytesDurable;
	int activePeekStreams = 0;
	WorkerCache<TLogInterface> tlogCache;
	FlowLock peekMemoryLimiter;

	PromiseStream<Future<Void>> sharedActors;
	Promise<Void> terminated;
	FlowLock concurrentLogRouterReads;
	FlowLock persistentDataCommitLock;

	// Beginning of fields used by snapshot based backup and restore
	double ignorePopDeadline; // time until which the ignorePopRequest will be
	                          // honored
	std::string ignorePopUid; // callers that set ignorePopRequest will set this
	                          // extra state, used to validate the ownership of
	                          // the set and for callers that unset will
	                          // be able to match it up
	std::string dataFolder; // folder where data is stored
	// End of fields used by snapshot based backup and restore

	Reference<AsyncVar<bool>> degraded;
	std::vector<TagsAndMessage> tempTagMessages;

	// Distribution of end-to-end server latency of tlog commit requests.
	Reference<Histogram> commitLatencyDist;

	// Distribution of queue wait times, per request.
	// This is the time spent waiting for previous versions.
	//
	// Note: we only wait for previous versions to enter the
	// in-memory DiskQueue commit queue, not until the records are
	// flushed and durable.
	Reference<Histogram> queueWaitLatencyDist;

	// Distribution of just the disk commit times, per request.
	//
	// Time starts as soon as this request is done waiting for previous versions,
	// and ends when the data is flushed and durable.
	Reference<Histogram> timeUntilDurableDist;

	// Controls whether the health monitoring running in this TLog force checking any other processes are degraded.
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;

	TLogData(UID dbgid,
	         UID workerID,
	         IKeyValueStore* persistentData,
	         IDiskQueue* persistentQueue,
	         Reference<AsyncVar<ServerDBInfo> const> dbInfo,
	         Reference<AsyncVar<bool>> degraded,
	         std::string folder,
	         Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck)
	  : dbgid(dbgid), workerID(workerID), persistentData(persistentData), rawPersistentQueue(persistentQueue),
	    persistentQueue(new TLogQueue(persistentQueue, dbgid)), diskQueueCommitBytes(0),
	    largeDiskQueueCommitBytes(false), dbInfo(dbInfo), queueCommitEnd(0), queueCommitBegin(0),
	    instanceID(deterministicRandom()->randomUniqueID().first()), bytesInput(0), bytesDurable(0),
	    targetVolatileBytes(SERVER_KNOBS->TLOG_SPILL_THRESHOLD), overheadBytesInput(0), overheadBytesDurable(0),
	    peekMemoryLimiter(SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_PEEK_MEMORY_BYTES),
	    concurrentLogRouterReads(SERVER_KNOBS->CONCURRENT_LOG_ROUTER_READS), ignorePopDeadline(0), dataFolder(folder),
	    degraded(degraded),
	    commitLatencyDist(Histogram::getHistogram("tLog"_sr, "commit"_sr, Histogram::Unit::milliseconds)),
	    queueWaitLatencyDist(Histogram::getHistogram("tLog"_sr, "QueueWait"_sr, Histogram::Unit::milliseconds)),
	    timeUntilDurableDist(Histogram::getHistogram("tLog"_sr, "TimeUntilDurable"_sr, Histogram::Unit::milliseconds)),
	    enablePrimaryTxnSystemHealthCheck(enablePrimaryTxnSystemHealthCheck) {
		cx = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
	}
};

struct LogData : NonCopyable, public ReferenceCounted<LogData> {
	struct TagData : NonCopyable, public ReferenceCounted<TagData> {
		std::deque<std::pair<Version, LengthPrefixedStringRef>> versionMessages;
		bool
		    nothingPersistent; // true means tag is *known* to have no messages in persistentData.  false means nothing.
		bool poppedRecently; // `popped` has changed since last updatePersistentData
		Version popped; // see popped version tracking contract below
		Version persistentPopped; // The popped version recorded in the btree.
		Version versionForPoppedLocation; // `poppedLocation` was calculated at this popped version
		IDiskQueue::location poppedLocation; // The location of the earliest commit with data for this tag.
		bool unpoppedRecovered;
		Tag tag;

		TagData(Tag tag,
		        Version popped,
		        IDiskQueue::location poppedLocation,
		        bool nothingPersistent,
		        bool poppedRecently,
		        bool unpoppedRecovered)
		  : nothingPersistent(nothingPersistent), poppedRecently(poppedRecently), popped(popped), persistentPopped(0),
		    versionForPoppedLocation(0), poppedLocation(poppedLocation), unpoppedRecovered(unpoppedRecovered),
		    tag(tag) {}

		TagData(TagData&& r) noexcept
		  : versionMessages(std::move(r.versionMessages)), nothingPersistent(r.nothingPersistent),
		    poppedRecently(r.poppedRecently), popped(r.popped), persistentPopped(r.persistentPopped),
		    versionForPoppedLocation(r.versionForPoppedLocation), poppedLocation(r.poppedLocation),
		    unpoppedRecovered(r.unpoppedRecovered), tag(r.tag) {}
		void operator=(TagData&& r) noexcept {
			versionMessages = std::move(r.versionMessages);
			nothingPersistent = r.nothingPersistent;
			poppedRecently = r.poppedRecently;
			popped = r.popped;
			persistentPopped = r.persistentPopped;
			versionForPoppedLocation = r.versionForPoppedLocation;
			poppedLocation = r.poppedLocation;
			tag = r.tag;
			unpoppedRecovered = r.unpoppedRecovered;
		}

		// Erase messages not needed to update *from* versions >= before (thus, messages with toversion <= before)
																	#line 900 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
// This generated class is to be used only via eraseMessagesBefore()
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class EraseMessagesBeforeActor>
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class EraseMessagesBeforeActorState {
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	EraseMessagesBeforeActorState(TagData* const& self,Version const& before,TLogData* const& tlogData,Reference<LogData> const& logData,TaskPriority const& taskID) 
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   before(before),
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tlogData(tlogData),
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   taskID(taskID)
															#line 921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("eraseMessagesBefore", reinterpret_cast<unsigned long>(this));

	}
	~EraseMessagesBeforeActorState() 
	{
		fdb_probe_actor_destroy("eraseMessagesBefore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EraseMessagesBeforeActorState();
		static_cast<EraseMessagesBeforeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<EraseMessagesBeforeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EraseMessagesBeforeActorState(); static_cast<EraseMessagesBeforeActor*>(this)->destroy(); return 0; }
															#line 959 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<EraseMessagesBeforeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EraseMessagesBeforeActorState();
		static_cast<EraseMessagesBeforeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(!self->versionMessages.empty() && self->versionMessages.front().first < before))
															#line 978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Version version = self->versionMessages.front().first;
															#line 450 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		std::pair<int, int>& sizes = logData->version_sizes[version];
															#line 451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int64_t messagesErased = 0;
															#line 453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(;!self->versionMessages.empty() && self->versionMessages.front().first == version;) {
															#line 454 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto const& m = self->versionMessages.front();
															#line 455 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			++messagesErased;
															#line 457 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->tag.locality != tagLocalityTxs && self->tag != txsTag)
															#line 996 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 458 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				sizes.first -= m.second.expectedSize();
															#line 1000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				sizes.second -= m.second.expectedSize();
															#line 1006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->versionMessages.pop_front();
															#line 1010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int64_t bytesErased = messagesErased * SERVER_KNOBS->VERSION_MESSAGES_ENTRY_BYTES_WITH_OVERHEAD;
															#line 467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->bytesDurable += bytesErased;
															#line 468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tlogData->bytesDurable += bytesErased;
															#line 469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tlogData->overheadBytesDurable += bytesErased;
															#line 470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield(taskID);
															#line 470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<EraseMessagesBeforeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<EraseMessagesBeforeActor*>(this)->actor_wait_state = 1;
															#line 470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EraseMessagesBeforeActor, 0, Void >*>(static_cast<EraseMessagesBeforeActor*>(this)));
															#line 1029 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EraseMessagesBeforeActor*>(this)->actor_wait_state > 0) static_cast<EraseMessagesBeforeActor*>(this)->actor_wait_state = 0;
		static_cast<EraseMessagesBeforeActor*>(this)->ActorCallback< EraseMessagesBeforeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EraseMessagesBeforeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EraseMessagesBeforeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EraseMessagesBeforeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EraseMessagesBeforeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EraseMessagesBeforeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EraseMessagesBeforeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TagData* self;
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version before;
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* tlogData;
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TaskPriority taskID;
															#line 1144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via eraseMessagesBefore()
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class EraseMessagesBeforeActor final : public Actor<Void>, public ActorCallback< EraseMessagesBeforeActor, 0, Void >, public FastAllocated<EraseMessagesBeforeActor>, public EraseMessagesBeforeActorState<EraseMessagesBeforeActor> {
															#line 1149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<EraseMessagesBeforeActor>::operator new;
	using FastAllocated<EraseMessagesBeforeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17761058626394893824UL, 11137410164307327232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EraseMessagesBeforeActor, 0, Void >;
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	EraseMessagesBeforeActor(TagData* const& self,Version const& before,TLogData* const& tlogData,Reference<LogData> const& logData,TaskPriority const& taskID) 
															#line 1166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   EraseMessagesBeforeActorState<EraseMessagesBeforeActor>(self, before, tlogData, logData, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1854742738697847296UL, 5219680687026297856UL);
		ActorExecutionContextHelper __helper(static_cast<EraseMessagesBeforeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("eraseMessagesBefore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("eraseMessagesBefore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EraseMessagesBeforeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> eraseMessagesBefore( TagData* const& self, Version const& before, TLogData* const& tlogData, Reference<LogData> const& logData, TaskPriority const& taskID ) {
															#line 443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new EraseMessagesBeforeActor(self, before, tlogData, logData, taskID));
															#line 1198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

		Future<Void> eraseMessagesBefore(Version before,
		                                 TLogData* tlogData,
		                                 Reference<LogData> logData,
		                                 TaskPriority taskID) {
			return eraseMessagesBefore(this, before, tlogData, logData, taskID);
		}
	};

	Map<Version, std::pair<IDiskQueue::location, IDiskQueue::location>>
	    versionLocation; // For the version of each entry that was push()ed, the [start, end) location of the serialized
	                     // bytes

	/*
	Popped version tracking contract needed by log system to implement ILogCursor::popped():

	    - Log server tracks for each (possible) tag a popped_version
	    Impl: TagData::popped (in memory) and persistTagPoppedKeys (in persistentData)
	    - popped_version(tag) is <= the maximum version for which log server (or a predecessor) is ever asked to pop the
	tag Impl: Only increased by tLogPop() in response to either a pop request or recovery from a predecessor
	    - popped_version(tag) is > the maximum version for which log server is unable to peek messages due to previous
	pops (on this server or a predecessor) Impl: Increased by tLogPop() atomically with erasing messages from memory;
	persisted by updatePersistentData() atomically with erasing messages from store; messages are not erased from queue
	where popped_version is not persisted
	    - LockTLogReply returns all tags which either have messages, or which have nonzero popped_versions
	    Impl: tag_data is present for all such tags
	    - peek(tag, v) returns the popped_version for tag if that is greater than v
	    Impl: Check tag_data->popped (after all waits)
	*/

	AsyncTrigger stopCommit;
	bool initialized;
	Promise<Void> stoppedPromise;
	DBRecoveryCount recoveryCount;

	// If persistentDataVersion != persistentDurableDataVersion,
	// then spilling is happening from persistentDurableDataVersion to persistentDataVersion.
	// Data less than persistentDataDurableVersion is spilled on disk (or fully popped from the TLog);
	VersionMetricHandle persistentDataVersion;
	VersionMetricHandle persistentDataDurableVersion; // The last version number in the portion of the log
	                                                  // (written|durable) to persistentData
	NotifiedVersion version;
	NotifiedVersion queueCommittedVersion; // The disk queue has committed up until the queueCommittedVersion version.
	Version queueCommittingVersion;
	Version knownCommittedVersion; // The maximum version that a proxy has told us that is committed (all TLogs have
	                               // ack'd a commit for this version).
	Version durableKnownCommittedVersion;
	Version minKnownCommittedVersion;
	Version queuePoppedVersion; // The disk queue has been popped up until the location which represents this version.
	Version minPoppedTagVersion;
	Tag minPoppedTag; // The tag that makes tLog hold its data and cause tLog's disk queue increasing.

	// For each version above knownCommittedVersion, track:
	// <Version, PrevVersion (that the sequencer provided), TLogs that the version has been sent to (the tLogs
	//  are represented by their corresponding positions in "TagPartitionedLogSystem::tLogs")>
	std::deque<UnknownCommittedVersions> unknownCommittedVersions;

	Deque<std::pair<Version, Standalone<VectorRef<uint8_t>>>> messageBlocks;
	std::vector<std::vector<Reference<TagData>>> tag_data; // tag.locality | tag.id
	int unpoppedRecoveredTagCount;
	std::set<Tag> unpoppedRecoveredTags;
	std::map<Tag, Promise<Void>> waitingTags;
	std::map<Tag, std::vector<Version>> tagUnpoppedOldGenerations;
	AsyncTrigger updateGenerationRecovery;

	Reference<TagData> getTagData(Tag tag) {
		int idx = tag.toTagDataIndex();
		if (idx >= tag_data.size()) {
			tag_data.resize(idx + 1);
		}
		if (tag.id >= tag_data[idx].size()) {
			tag_data[idx].resize(tag.id + 1);
		}
		return tag_data[idx][tag.id];
	}

	// only callable after getTagData returns a null reference
	Reference<TagData> createTagData(Tag tag,
	                                 Version popped,
	                                 bool nothingPersistent,
	                                 bool poppedRecently,
	                                 bool unpoppedRecovered) {
		if (tag.locality != tagLocalityLogRouter && tag.locality != tagLocalityTxs && tag != txsTag && allTags.size() &&
		    !allTags.contains(tag) && popped <= recoveredAt) {
			popped = recoveredAt + 1;
		}
		auto newTagData = makeReference<TagData>(tag, popped, 0, nothingPersistent, poppedRecently, unpoppedRecovered);
		tag_data[tag.toTagDataIndex()][tag.id] = newTagData;
		return newTagData;
	}

	Map<Version, std::pair<int, int>> version_sizes;

	CounterCollection cc;
	Counter bytesInput;
	Counter tagMessageCount;
	Counter bytesDurable;
	Counter blockingPeeks;
	Counter blockingPeekTimeouts;
	Counter emptyPeeks;
	Counter nonEmptyPeeks;
	Counter persistentDataUpdateBatches;
	Counter dirtyTagsProcessed;
	std::map<Tag, LatencySample> blockingPeekLatencies;
	std::map<Tag, LatencySample> peekVersionCounts;

	UID logId;
	ProtocolVersion protocolVersion;
	Version newPersistentDataVersion;
	Future<Void> removed;
	PromiseStream<Future<Void>> addActor;
	TLogData* tLogData;
	Promise<Void> recoveryComplete;
	Promise<Void> committingQueue;
	Version unrecoveredBefore;
	Version recoveredAt;
	Version recoveryTxnVersion;

	struct PeekTrackerData {
		std::map<int, Promise<std::pair<Version, bool>>>
		    sequence_version; // second: Version is peeked begin version. bool is onlySpilled
		double lastUpdate;

		Tag tag;

		double lastLogged;
		int64_t totalPeeks;
		int64_t replyBytes;
		int64_t duplicatePeeks;
		double queueTime;
		double queueMax;
		double blockTime;
		double blockMax;
		double workTime;
		double workMax;

		int64_t unblockedPeeks;
		double idleTime;
		double idleMax;

		PeekTrackerData() : lastUpdate(0) { resetMetrics(); }

		void resetMetrics() {
			lastLogged = now();
			totalPeeks = 0;
			replyBytes = 0;
			duplicatePeeks = 0;
			queueTime = 0;
			queueMax = 0;
			blockTime = 0;
			blockMax = 0;
			workTime = 0;
			workMax = 0;
			unblockedPeeks = 0;
			idleTime = 0;
			idleMax = 0;
		}
	};

	std::map<UID, PeekTrackerData> peekTracker;

	Reference<AsyncVar<Reference<ILogSystem>>> logSystem;
	Tag remoteTag;
	bool isPrimary;
	int logRouterTags;
	Version logRouterPoppedVersion;
	Version logRouterPopToVersion;
	int8_t locality;
	UID recruitmentID;
	TLogSpillType logSpillType;
	std::set<Tag> allTags;
	Future<Void> terminated;
	FlowLock execOpLock;
	bool execOpCommitInProgress;
	int txsTags;

	std::map<Tag, Version> toBePopped; // map of Tag->Version for all the pops
	                                   // that came when ignorePopRequest was set

	explicit LogData(TLogData* tLogData,
	                 TLogInterface interf,
	                 Tag remoteTag,
	                 bool isPrimary,
	                 int logRouterTags,
	                 int txsTags,
	                 UID recruitmentID,
	                 ProtocolVersion protocolVersion,
	                 TLogSpillType logSpillType,
	                 std::vector<Tag> tags,
	                 std::string context)
	  : initialized(false), queueCommittingVersion(0), knownCommittedVersion(0), durableKnownCommittedVersion(0),
	    minKnownCommittedVersion(0), queuePoppedVersion(0), minPoppedTagVersion(0), minPoppedTag(invalidTag),
	    unpoppedRecoveredTagCount(0), cc("TLog", interf.id().toString()), bytesInput("BytesInput", cc),
	    tagMessageCount("tagMessageCount", cc), bytesDurable("BytesDurable", cc), blockingPeeks("BlockingPeeks", cc),
	    blockingPeekTimeouts("BlockingPeekTimeouts", cc), emptyPeeks("EmptyPeeks", cc),
	    nonEmptyPeeks("NonEmptyPeeks", cc), persistentDataUpdateBatches("PersistentDataUpdateBatches", cc),
	    dirtyTagsProcessed("DirtyTagsProcessed", cc), logId(interf.id()), protocolVersion(protocolVersion),
	    newPersistentDataVersion(invalidVersion), tLogData(tLogData), unrecoveredBefore(1), recoveredAt(1),
	    recoveryTxnVersion(1), logSystem(new AsyncVar<Reference<ILogSystem>>()), remoteTag(remoteTag),
	    isPrimary(isPrimary), logRouterTags(logRouterTags), logRouterPoppedVersion(0), logRouterPopToVersion(0),
	    locality(tagLocalityInvalid), recruitmentID(recruitmentID), logSpillType(logSpillType),
	    allTags(tags.begin(), tags.end()), terminated(tLogData->terminated.getFuture()), execOpCommitInProgress(false),
	    txsTags(txsTags) {
		startRole(Role::TRANSACTION_LOG,
		          interf.id(),
		          tLogData->workerID,
		          { { "SharedTLog", tLogData->dbgid.shortString() } },
		          context);
		addActor.send(traceRole(Role::TRANSACTION_LOG, interf.id()));

		persistentDataVersion.init("TLog.PersistentDataVersion"_sr, cc.getId());
		persistentDataDurableVersion.init("TLog.PersistentDataDurableVersion"_sr, cc.getId());
		version.initMetric("TLog.Version"_sr, cc.getId());
		queueCommittedVersion.initMetric("TLog.QueueCommittedVersion"_sr, cc.getId());

		specialCounter(cc, "Version", [this]() { return this->version.get(); });
		specialCounter(cc, "QueueCommittedVersion", [this]() { return this->queueCommittedVersion.get(); });
		specialCounter(cc, "PersistentDataVersion", [this]() { return this->persistentDataVersion; });
		specialCounter(cc, "PersistentDataDurableVersion", [this]() { return this->persistentDataDurableVersion; });
		specialCounter(cc, "KnownCommittedVersion", [this]() { return this->knownCommittedVersion; });
		specialCounter(cc, "QueuePoppedVersion", [this]() { return this->queuePoppedVersion; });
		specialCounter(cc, "MinPoppedTagVersion", [this]() { return this->minPoppedTagVersion; });
		// The locality and id of the tag that is responsible for making the TLog hold onto its oldest piece of data.
		// If disk queues are growing and no one is sure why, then you shall look at this to find the tag responsible
		// for why the TLog thinks it can't throw away data.
		specialCounter(cc, "MinPoppedTagLocality", [this]() { return this->minPoppedTag.locality; });
		specialCounter(cc, "MinPoppedTagId", [this]() { return this->minPoppedTag.id; });
		specialCounter(cc, "SharedBytesInput", [tLogData]() { return tLogData->bytesInput; });
		specialCounter(cc, "SharedBytesDurable", [tLogData]() { return tLogData->bytesDurable; });
		specialCounter(cc, "SharedOverheadBytesInput", [tLogData]() { return tLogData->overheadBytesInput; });
		specialCounter(cc, "SharedOverheadBytesDurable", [tLogData]() { return tLogData->overheadBytesDurable; });
		specialCounter(cc, "PeekMemoryReserved", [tLogData]() { return tLogData->peekMemoryLimiter.activePermits(); });
		specialCounter(cc, "PeekMemoryRequestsStalled", [tLogData]() { return tLogData->peekMemoryLimiter.waiters(); });
		specialCounter(cc, "Generation", [this]() { return this->recoveryCount; });
		specialCounter(cc, "ActivePeekStreams", [tLogData]() { return tLogData->activePeekStreams; });
		specialCounter(cc, "UnknownCommittedVersionCount", [this]() { return this->unknownCommittedVersions.size(); });
	}

	~LogData() {
		endRole(Role::TRANSACTION_LOG, logId, "Error", true);

		if (!terminated.isReady()) {
			tLogData->bytesDurable += bytesInput.getValue() - bytesDurable.getValue();
			TraceEvent("TLogBytesWhenRemoved", logId)
			    .detail("SharedBytesInput", tLogData->bytesInput)
			    .detail("SharedBytesDurable", tLogData->bytesDurable)
			    .detail("LocalBytesInput", bytesInput.getValue())
			    .detail("LocalBytesDurable", bytesDurable.getValue());

			ASSERT_ABORT(tLogData->bytesDurable <= tLogData->bytesInput);

			Key logIdKey = BinaryWriter::toValue(logId, Unversioned());
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistCurrentVersionKeys.begin)));
			tLogData->persistentData->clear(
			    singleKeyRange(logIdKey.withPrefix(persistKnownCommittedVersionKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistLocalityKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistLogRouterTagsKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistTxsTagsKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistRecoveryCountKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistProtocolVersionKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistTLogSpillTypeKeys.begin)));
			tLogData->persistentData->clear(singleKeyRange(logIdKey.withPrefix(persistRecoveryLocationKey)));
			Key msgKey = logIdKey.withPrefix(persistTagMessagesKeys.begin);
			tLogData->persistentData->clear(KeyRangeRef(msgKey, strinc(msgKey)));
			Key msgRefKey = logIdKey.withPrefix(persistTagMessageRefsKeys.begin);
			tLogData->persistentData->clear(KeyRangeRef(msgRefKey, strinc(msgRefKey)));
			Key poppedKey = logIdKey.withPrefix(persistTagPoppedKeys.begin);
			tLogData->persistentData->clear(KeyRangeRef(poppedKey, strinc(poppedKey)));
		}

		for (auto it = peekTracker.begin(); it != peekTracker.end(); ++it) {
			for (auto seq : it->second.sequence_version) {
				if (!seq.second.isSet()) {
					seq.second.sendError(timed_out());
				}
			}
		}
	}

	LogEpoch epoch() const { return recoveryCount; }

	bool shouldSpillByValue(Tag t) const {
		switch (logSpillType) {
		case TLogSpillType::VALUE:
			return true;
		case TLogSpillType::REFERENCE:
			return t.locality == tagLocalityTxs || t == txsTag;
		default:
			ASSERT(false);
			return false;
		}
	}

	bool shouldSpillByReference(Tag t) const { return !shouldSpillByValue(t); }

	void unblockWaitingPeeks() {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
			for (auto& iter : waitingTags) {
				TraceEvent("UnblockWaitingPeeks", tLogData->dbgid)
				    .detail("LogId", logId)
				    .detail("Tag", iter.first.toString());
				iter.second.send(Void());
			}
			waitingTags.clear();
		}
	}

	bool stopped() const { return stoppedPromise.isSet(); }

	void stop() {
		if (stoppedPromise.canBeSet()) {
			TraceEvent(SevDebug, "StoppingTLog", tLogData->dbgid).detail("LogId", logId);
			stoppedPromise.send(Void());
		}
	}
};

template <class T>
void TLogQueue::push(T const& qe, Reference<LogData> logData) {
	BinaryWriter wr(Unversioned()); // outer framing is not versioned
	wr << uint32_t(0);
	IncludeVersion(ProtocolVersion::withTLogQueueEntryRef()).write(wr); // payload is versioned
	wr << qe;
	wr << uint8_t(1);
	*(uint32_t*)wr.getData() = wr.getLength() - sizeof(uint32_t) - sizeof(uint8_t);
	const IDiskQueue::location startloc = queue->getNextPushLocation();
	// FIXME: push shouldn't return anything.  We should call getNextPushLocation() again.
	const IDiskQueue::location endloc = queue->push(wr.toValue());
	//TraceEvent("TLogQueueVersionWritten", dbgid).detail("Size", wr.getLength() - sizeof(uint32_t) - sizeof(uint8_t)).detail("Loc", loc);
	logData->versionLocation[qe.version] = std::make_pair(startloc, endloc);
}

void TLogQueue::forgetBefore(Version upToVersion, Reference<LogData> logData) {
	// Keep only the given and all subsequent version numbers
	// Find the first version >= upTo
	auto v = logData->versionLocation.lower_bound(upToVersion);
	if (v == logData->versionLocation.begin()) {
		return;
	}

	if (v == logData->versionLocation.end()) {
		v = logData->versionLocation.lastItem();
	} else {
		v.decrementNonEnd();
	}

	logData->versionLocation.erase(logData->versionLocation.begin(),
	                               v); // ... and then we erase that previous version and all prior versions
}

void TLogQueue::pop(IDiskQueue::location upToLocation) {
	queue->pop(upToLocation);
}

void TLogQueue::updateVersionSizes(const TLogQueueEntry& result,
                                   TLogData* tLog,
                                   IDiskQueue::location start,
                                   IDiskQueue::location end) {
	auto it = tLog->id_data.find(result.id);
	if (it != tLog->id_data.end()) {
		it->second->versionLocation[result.version] = std::make_pair(start, end);
	}
}

															#line 1566 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogLock()
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogLockActor>
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogLockActorState {
															#line 1573 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogLockActorState(TLogData* const& self,ReplyPromise<TLogLockResult> const& reply,Reference<LogData> const& logData) 
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reply(reply),
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 840 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   stopVersion(logData->version.get())
															#line 1586 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogLock", reinterpret_cast<unsigned long>(this));

	}
	~TLogLockActorState() 
	{
		fdb_probe_actor_destroy("tLogLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 842 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "TLog stopped by recovering cluster-controller");
															#line 843 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(logData->stopped(), "logData already stopped");
															#line 844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(!logData->stopped(), "logData not yet stopped");
															#line 846 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("TLogStop", logData->logId) .detail("Ver", stopVersion) .detail("IsStopped", logData->stopped()) .detail("QueueCommitted", logData->queueCommittedVersion.get());
															#line 851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->stop();
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->unblockWaitingPeeks();
															#line 853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!logData->recoveryComplete.isSet())
															#line 1613 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				logData->recoveryComplete.sendError(end_of_stream());
															#line 1617 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = logData->queueCommittedVersion.whenAtLeast(stopVersion);
															#line 858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogLockActor*>(this)->actor_wait_state = 1;
															#line 858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogLockActor, 0, Void >*>(static_cast<TLogLockActor*>(this)));
															#line 1628 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogLockActorState();
		static_cast<TLogLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 860 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(stopVersion == logData->version.get());
															#line 862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TLogLockResult result;
															#line 863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.end = stopVersion;
															#line 864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.knownCommittedVersion = logData->knownCommittedVersion;
															#line 865 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.id = self->dbgid;
															#line 866 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.logId = logData->logId;
															#line 867 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.unknownCommittedVersions = logData->unknownCommittedVersions;
															#line 869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("TLogStop2", self->dbgid) .detail("LogId", logData->logId) .detail("Ver", stopVersion) .detail("IsStopped", logData->stopped()) .detail("QueueCommitted", logData->queueCommittedVersion.get()) .detail("KnownCommitted", result.knownCommittedVersion);
															#line 876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.send(result);
															#line 877 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogLockActorState(); static_cast<TLogLockActor*>(this)->destroy(); return 0; }
															#line 1669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogLockActorState();
		static_cast<TLogLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 860 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(stopVersion == logData->version.get());
															#line 862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TLogLockResult result;
															#line 863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.end = stopVersion;
															#line 864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.knownCommittedVersion = logData->knownCommittedVersion;
															#line 865 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.id = self->dbgid;
															#line 866 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.logId = logData->logId;
															#line 867 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		result.unknownCommittedVersions = logData->unknownCommittedVersions;
															#line 869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("TLogStop2", self->dbgid) .detail("LogId", logData->logId) .detail("Ver", stopVersion) .detail("IsStopped", logData->stopped()) .detail("QueueCommitted", logData->queueCommittedVersion.get()) .detail("KnownCommitted", result.knownCommittedVersion);
															#line 876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.send(result);
															#line 877 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogLockActorState(); static_cast<TLogLockActor*>(this)->destroy(); return 0; }
															#line 1699 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogLockActorState();
		static_cast<TLogLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogLockActor*>(this)->actor_wait_state > 0) static_cast<TLogLockActor*>(this)->actor_wait_state = 0;
		static_cast<TLogLockActor*>(this)->ActorCallback< TLogLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogLock", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ReplyPromise<TLogLockResult> reply;
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 840 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version stopVersion;
															#line 1790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogLock()
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogLockActor final : public Actor<Void>, public ActorCallback< TLogLockActor, 0, Void >, public FastAllocated<TLogLockActor>, public TLogLockActorState<TLogLockActor> {
															#line 1795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogLockActor>::operator new;
	using FastAllocated<TLogLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16105116469509132032UL, 10382172936239270912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogLockActor, 0, Void >;
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogLockActor(TLogData* const& self,ReplyPromise<TLogLockResult> const& reply,Reference<LogData> const& logData) 
															#line 1812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogLockActorState<TLogLockActor>(self, reply, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10549431519998350080UL, 9066438864109303296UL);
		ActorExecutionContextHelper __helper(static_cast<TLogLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogLockActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogLock( TLogData* const& self, ReplyPromise<TLogLockResult> const& reply, Reference<LogData> const& logData ) {
															#line 839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogLockActor(self, reply, logData));
															#line 1845 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 879 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

void updatePersistentPopped(TLogData* self, Reference<LogData> logData, Reference<LogData::TagData> data) {
	if (!data->poppedRecently) {
		return;
	}
	self->persistentData->set(
	    KeyValueRef(persistTagPoppedKey(logData->logId, data->tag), persistTagPoppedValue(data->popped)));
	data->poppedRecently = false;
	data->persistentPopped = data->popped;

	if (data->nothingPersistent) {
		return;
	}

	if (logData->shouldSpillByValue(data->tag)) {
		self->persistentData->clear(KeyRangeRef(persistTagMessagesKey(logData->logId, data->tag, Version(0)),
		                                        persistTagMessagesKey(logData->logId, data->tag, data->popped)));
	} else {
		self->persistentData->clear(KeyRangeRef(persistTagMessageRefsKey(logData->logId, data->tag, Version(0)),
		                                        persistTagMessageRefsKey(logData->logId, data->tag, data->popped)));
	}

	if (data->popped > logData->persistentDataVersion) {
		data->nothingPersistent = true;
	}
}

															#line 1876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatePoppedLocation()
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class UpdatePoppedLocationActor>
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdatePoppedLocationActorState {
															#line 1883 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdatePoppedLocationActorState(TLogData* const& self,Reference<LogData> const& logData,Reference<LogData::TagData> const& data) 
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   data(data)
															#line 1894 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatePoppedLocation", reinterpret_cast<unsigned long>(this));

	}
	~UpdatePoppedLocationActorState() 
	{
		fdb_probe_actor_destroy("updatePoppedLocation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 908 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (logData->shouldSpillByValue(data->tag))
															#line 1909 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 909 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<UpdatePoppedLocationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdatePoppedLocationActorState(); static_cast<UpdatePoppedLocationActor*>(this)->destroy(); return 0; }
															#line 1913 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<UpdatePoppedLocationActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdatePoppedLocationActorState();
				static_cast<UpdatePoppedLocationActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (data->versionForPoppedLocation >= data->persistentPopped)
															#line 1921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 913 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<UpdatePoppedLocationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdatePoppedLocationActorState(); static_cast<UpdatePoppedLocationActor*>(this)->destroy(); return 0; }
															#line 1925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<UpdatePoppedLocationActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdatePoppedLocationActorState();
				static_cast<UpdatePoppedLocationActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			data->versionForPoppedLocation = data->persistentPopped;
															#line 919 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (data->persistentPopped <= logData->persistentDataVersion)
															#line 1935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = self->persistentData->readRange( KeyRangeRef(persistTagMessageRefsKey(logData->logId, data->tag, data->persistentPopped), persistTagMessageRefsKey(logData->logId, data->tag, logData->persistentDataVersion + 1)), 1);
															#line 921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdatePoppedLocationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1941 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdatePoppedLocationActor*>(this)->actor_wait_state = 1;
															#line 921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >*>(static_cast<UpdatePoppedLocationActor*>(this)));
															#line 1946 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatePoppedLocationActorState();
		static_cast<UpdatePoppedLocationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 944 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (data->persistentPopped >= logData->persistentDataVersion || data->nothingPersistent)
															#line 1974 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 946 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto locationIter = logData->versionLocation.lower_bound(data->persistentPopped);
															#line 947 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (locationIter != logData->versionLocation.end())
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 948 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				data->poppedLocation = locationIter->value.first;
															#line 949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				data->versionForPoppedLocation = locationIter->key;
															#line 1986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
			}
		}
															#line 957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<UpdatePoppedLocationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdatePoppedLocationActorState(); static_cast<UpdatePoppedLocationActor*>(this)->destroy(); return 0; }
															#line 1994 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<UpdatePoppedLocationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdatePoppedLocationActorState();
		static_cast<UpdatePoppedLocationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(RangeResult const& kvrefs,int loopDepth) 
	{
															#line 926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (kvrefs.empty())
															#line 2006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 928 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			data->nothingPersistent = true;
															#line 2010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			VectorRef<SpilledData> spilledData;
															#line 931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			BinaryReader r(kvrefs[0].value, AssumeVersion(logData->protocolVersion));
															#line 932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			r >> spilledData;
															#line 934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for( const SpilledData& sd : spilledData ) {
															#line 935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sd.version >= data->persistentPopped)
															#line 2024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					data->poppedLocation = sd.start;
															#line 937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					data->versionForPoppedLocation = sd.version;
															#line 2030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					break;
				}
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(RangeResult && kvrefs,int loopDepth) 
	{
															#line 926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (kvrefs.empty())
															#line 2043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 928 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			data->nothingPersistent = true;
															#line 2047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			VectorRef<SpilledData> spilledData;
															#line 931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			BinaryReader r(kvrefs[0].value, AssumeVersion(logData->protocolVersion));
															#line 932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			r >> spilledData;
															#line 934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for( const SpilledData& sd : spilledData ) {
															#line 935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sd.version >= data->persistentPopped)
															#line 2061 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					data->poppedLocation = sd.start;
															#line 937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					data->versionForPoppedLocation = sd.version;
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					break;
				}
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& kvrefs,int loopDepth) 
	{
		loopDepth = a_body1cont4(kvrefs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && kvrefs,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(kvrefs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatePoppedLocationActor*>(this)->actor_wait_state > 0) static_cast<UpdatePoppedLocationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePoppedLocationActor*>(this)->ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePoppedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePoppedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePoppedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePoppedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData::TagData> data;
															#line 2157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatePoppedLocation()
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdatePoppedLocationActor final : public Actor<Void>, public ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >, public FastAllocated<UpdatePoppedLocationActor>, public UpdatePoppedLocationActorState<UpdatePoppedLocationActor> {
															#line 2162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatePoppedLocationActor>::operator new;
	using FastAllocated<UpdatePoppedLocationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(49500010429868032UL, 9353600617740457216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >;
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdatePoppedLocationActor(TLogData* const& self,Reference<LogData> const& logData,Reference<LogData::TagData> const& data) 
															#line 2179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatePoppedLocationActorState<UpdatePoppedLocationActor>(self, logData, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatePoppedLocation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13069461939165326080UL, 4865240447146601472UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePoppedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatePoppedLocation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatePoppedLocation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatePoppedLocationActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> updatePoppedLocation( TLogData* const& self, Reference<LogData> const& logData, Reference<LogData::TagData> const& data ) {
															#line 906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new UpdatePoppedLocationActor(self, logData, data));
															#line 2212 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 959 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

// It runs against the oldest TLog instance, calculates the first location in the disk queue that contains un-popped
// data, and then issues a pop to the disk queue at that location so that anything earlier can be
// removed/forgotten/overwritten. In effect, it applies the effect of TLogPop RPCs to disk.
															#line 2220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via popDiskQueue()
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class PopDiskQueueActor>
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class PopDiskQueueActorState {
															#line 2227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	PopDiskQueueActorState(TLogData* const& self,Reference<LogData> const& logData) 
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 2236 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("popDiskQueue", reinterpret_cast<unsigned long>(this));

	}
	~PopDiskQueueActorState() 
	{
		fdb_probe_actor_destroy("popDiskQueue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 964 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!logData->initialized)
															#line 2251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<PopDiskQueueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopDiskQueueActorState(); static_cast<PopDiskQueueActor*>(this)->destroy(); return 0; }
															#line 2255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<PopDiskQueueActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PopDiskQueueActorState();
				static_cast<PopDiskQueueActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 968 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			std::vector<Future<Void>> updates;
															#line 969 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(int tagLocality = 0;tagLocality < logData->tag_data.size();tagLocality++) {
															#line 970 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				for(int tagId = 0;tagId < logData->tag_data[tagLocality].size();tagId++) {
															#line 971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					Reference<LogData::TagData> tagData = logData->tag_data[tagLocality][tagId];
															#line 972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (tagData)
															#line 2271 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 973 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						updates.push_back(updatePoppedLocation(self, logData, tagData));
															#line 2275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
				}
			}
															#line 977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(updates);
															#line 977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<PopDiskQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopDiskQueueActor*>(this)->actor_wait_state = 1;
															#line 977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopDiskQueueActor, 0, Void >*>(static_cast<PopDiskQueueActor*>(this)));
															#line 2288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopDiskQueueActorState();
		static_cast<PopDiskQueueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 979 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		IDiskQueue::location minLocation = 0;
															#line 980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Version minVersion = 0;
															#line 981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto locationIter = logData->versionLocation.lower_bound(logData->persistentDataVersion);
															#line 982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (locationIter != logData->versionLocation.end())
															#line 2317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			minLocation = locationIter->value.first;
															#line 984 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			minVersion = locationIter->key;
															#line 2323 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->minPoppedTagVersion = std::numeric_limits<Version>::max();
															#line 988 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(int tagLocality = 0;tagLocality < logData->tag_data.size();tagLocality++) {
															#line 989 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(int tagId = 0;tagId < logData->tag_data[tagLocality].size();tagId++) {
															#line 990 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				Reference<LogData::TagData> tagData = logData->tag_data[tagLocality][tagId];
															#line 991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (tagData && logData->shouldSpillByReference(tagData->tag))
															#line 2335 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 992 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!tagData->nothingPersistent)
															#line 2339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 993 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						minLocation = std::min(minLocation, tagData->poppedLocation);
															#line 994 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						minVersion = std::min(minVersion, tagData->popped);
															#line 2345 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 996 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if ((!tagData->nothingPersistent || tagData->versionMessages.size()) && tagData->popped < logData->minPoppedTagVersion)
															#line 2349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						logData->minPoppedTagVersion = tagData->popped;
															#line 999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						logData->minPoppedTag = tagData->tag;
															#line 2355 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->queueCommitEnd.get() > 0)
															#line 2362 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Version lastCommittedVersion = logData->queueCommittedVersion.get();
															#line 1007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			IDiskQueue::location lastCommittedLocation = minLocation;
															#line 1008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto locationIter = logData->versionLocation.lower_bound(lastCommittedVersion);
															#line 1009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (locationIter != logData->versionLocation.end())
															#line 2372 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				lastCommittedLocation = locationIter->value.first;
															#line 2376 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentQueue->pop(std::min(minLocation, lastCommittedLocation));
															#line 1013 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->queuePoppedVersion = std::max(logData->queuePoppedVersion, minVersion);
															#line 2382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<PopDiskQueueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopDiskQueueActorState(); static_cast<PopDiskQueueActor*>(this)->destroy(); return 0; }
															#line 2386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<PopDiskQueueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PopDiskQueueActorState();
		static_cast<PopDiskQueueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 979 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		IDiskQueue::location minLocation = 0;
															#line 980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Version minVersion = 0;
															#line 981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto locationIter = logData->versionLocation.lower_bound(logData->persistentDataVersion);
															#line 982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (locationIter != logData->versionLocation.end())
															#line 2404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			minLocation = locationIter->value.first;
															#line 984 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			minVersion = locationIter->key;
															#line 2410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->minPoppedTagVersion = std::numeric_limits<Version>::max();
															#line 988 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(int tagLocality = 0;tagLocality < logData->tag_data.size();tagLocality++) {
															#line 989 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(int tagId = 0;tagId < logData->tag_data[tagLocality].size();tagId++) {
															#line 990 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				Reference<LogData::TagData> tagData = logData->tag_data[tagLocality][tagId];
															#line 991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (tagData && logData->shouldSpillByReference(tagData->tag))
															#line 2422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 992 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!tagData->nothingPersistent)
															#line 2426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 993 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						minLocation = std::min(minLocation, tagData->poppedLocation);
															#line 994 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						minVersion = std::min(minVersion, tagData->popped);
															#line 2432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 996 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if ((!tagData->nothingPersistent || tagData->versionMessages.size()) && tagData->popped < logData->minPoppedTagVersion)
															#line 2436 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						logData->minPoppedTagVersion = tagData->popped;
															#line 999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						logData->minPoppedTag = tagData->tag;
															#line 2442 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->queueCommitEnd.get() > 0)
															#line 2449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Version lastCommittedVersion = logData->queueCommittedVersion.get();
															#line 1007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			IDiskQueue::location lastCommittedLocation = minLocation;
															#line 1008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto locationIter = logData->versionLocation.lower_bound(lastCommittedVersion);
															#line 1009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (locationIter != logData->versionLocation.end())
															#line 2459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				lastCommittedLocation = locationIter->value.first;
															#line 2463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentQueue->pop(std::min(minLocation, lastCommittedLocation));
															#line 1013 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->queuePoppedVersion = std::max(logData->queuePoppedVersion, minVersion);
															#line 2469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<PopDiskQueueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopDiskQueueActorState(); static_cast<PopDiskQueueActor*>(this)->destroy(); return 0; }
															#line 2473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<PopDiskQueueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PopDiskQueueActorState();
		static_cast<PopDiskQueueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopDiskQueueActor*>(this)->actor_wait_state > 0) static_cast<PopDiskQueueActor*>(this)->actor_wait_state = 0;
		static_cast<PopDiskQueueActor*>(this)->ActorCallback< PopDiskQueueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopDiskQueueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopDiskQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopDiskQueueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopDiskQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopDiskQueueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopDiskQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popDiskQueue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2560 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via popDiskQueue()
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class PopDiskQueueActor final : public Actor<Void>, public ActorCallback< PopDiskQueueActor, 0, Void >, public FastAllocated<PopDiskQueueActor>, public PopDiskQueueActorState<PopDiskQueueActor> {
															#line 2565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<PopDiskQueueActor>::operator new;
	using FastAllocated<PopDiskQueueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12490981434250380544UL, 1521650202047491840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopDiskQueueActor, 0, Void >;
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	PopDiskQueueActor(TLogData* const& self,Reference<LogData> const& logData) 
															#line 2582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PopDiskQueueActorState<PopDiskQueueActor>(self, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popDiskQueue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4838247713797008640UL, 105505250068255488UL);
		ActorExecutionContextHelper __helper(static_cast<PopDiskQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popDiskQueue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popDiskQueue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopDiskQueueActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> popDiskQueue( TLogData* const& self, Reference<LogData> const& logData ) {
															#line 963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new PopDiskQueueActor(self, logData));
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1018 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 2620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatePersistentData()
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class UpdatePersistentDataActor>
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdatePersistentDataActorState {
															#line 2627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdatePersistentDataActorState(TLogData* const& self,Reference<LogData> const& logData,Version const& newPersistentDataVersion) 
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   newPersistentDataVersion(newPersistentDataVersion),
															#line 1020 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   wr(Unversioned())
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatePersistentData", reinterpret_cast<unsigned long>(this));

	}
	~UpdatePersistentDataActorState() 
	{
		fdb_probe_actor_destroy("updatePersistentData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(newPersistentDataVersion <= logData->version.get());
															#line 1023 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(newPersistentDataVersion <= logData->queueCommittedVersion.get());
															#line 1024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(newPersistentDataVersion > logData->persistentDataVersion);
															#line 1025 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(logData->persistentDataVersion == logData->persistentDataDurableVersion);
															#line 1026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->newPersistentDataVersion = newPersistentDataVersion;
															#line 1030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			anyData = false;
															#line 1033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->persistentDataUpdateBatches += 1;
															#line 1036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagsProcessedThisBatch = 0;
															#line 1039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagLocality = 0;
															#line 1040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagId = 0;
															#line 1042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagLocality = 0;
															#line 2675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatePersistentDataActorState();
		static_cast<UpdatePersistentDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1135 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->dirtyTagsProcessed += tagsProcessedThisBatch;
															#line 1137 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto locationIter = logData->versionLocation.lower_bound(newPersistentDataVersion);
															#line 1138 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (locationIter != logData->versionLocation.end())
															#line 2702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentData->set( KeyValueRef(persistRecoveryLocationKey, BinaryWriter::toValue(locationIter->value.first, Unversioned())));
															#line 2706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->persistentData->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistCurrentVersionKeys.begin), BinaryWriter::toValue(newPersistentDataVersion, Unversioned())));
															#line 1146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->persistentData->set(KeyValueRef( BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistKnownCommittedVersionKeys.begin), BinaryWriter::toValue(logData->knownCommittedVersion, Unversioned())));
															#line 1149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->persistentDataVersion = newPersistentDataVersion;
															#line 1154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tLogMaxCreateDuration = SERVER_KNOBS->TLOG_MAX_CREATE_DURATION;
															#line 1155 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->isSimulated() && logData->logSpillType == TLogSpillType::VALUE)
															#line 2718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tLogMaxCreateDuration = SERVER_KNOBS->TLOG_MAX_CREATE_DURATION * 2;
															#line 2722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ioTimeoutError(self->persistentData->commit(), tLogMaxCreateDuration, "TLogCommit");
															#line 1160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2728 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 4;
															#line 1160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 3, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 2733 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(tagLocality < logData->tag_data.size()))
															#line 2749 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagId = 0;
															#line 2755 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagLocality++;
															#line 2777 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(tagId < logData->tag_data[tagLocality].size()))
															#line 2793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagData = logData->tag_data[tagLocality][tagId];
															#line 1045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (tagData)
															#line 2801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagDidWork = tagData->poppedRecently;
															#line 1048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tagData->eraseMessagesBefore(tagData->popped, self, logData, TaskPriority::UpdateStorage);
															#line 1048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 1;
															#line 1048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 0, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagId++;
															#line 2841 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		currentVersion = 0;
															#line 1051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		updatePersistentPopped(self, logData, tagData);
															#line 1052 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastVersion = std::numeric_limits<Version>::min();
															#line 1053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		firstLocation = std::numeric_limits<IDiskQueue::location>::max();
															#line 1055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		msg = tagData->versionMessages.begin();
															#line 1057 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		refSpilledTagCount = 0;
															#line 1058 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		wr = BinaryWriter(AssumeVersion(logData->protocolVersion));
															#line 1060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		wr << uint32_t(0);
															#line 1061 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 2866 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		currentVersion = 0;
															#line 1051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		updatePersistentPopped(self, logData, tagData);
															#line 1052 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastVersion = std::numeric_limits<Version>::min();
															#line 1053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		firstLocation = std::numeric_limits<IDiskQueue::location>::max();
															#line 1055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		msg = tagData->versionMessages.begin();
															#line 1057 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		refSpilledTagCount = 0;
															#line 1058 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		wr = BinaryWriter(AssumeVersion(logData->protocolVersion));
															#line 1060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		wr << uint32_t(0);
															#line 1061 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 2891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (refSpilledTagCount > 0)
															#line 2975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			*(uint32_t*)wr.getData() = refSpilledTagCount;
															#line 1119 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentData->set( KeyValueRef(persistTagMessageRefsKey(logData->logId, tagData->tag, lastVersion), wr.toValue()));
															#line 1121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagDidWork = true;
															#line 1122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagData->poppedLocation = std::min(tagData->poppedLocation, firstLocation);
															#line 2985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::UpdateStorage);
															#line 1125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 3;
															#line 1125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 2, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 2996 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 1061 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(msg != tagData->versionMessages.end() && msg->first <= newPersistentDataVersion))
															#line 3012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1062 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		currentVersion = msg->first;
															#line 1063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		anyData = true;
															#line 1064 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagData->nothingPersistent = false;
															#line 1066 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->shouldSpillByValue(tagData->tag))
															#line 3024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			wr = BinaryWriter(Unversioned());
															#line 1068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(;msg != tagData->versionMessages.end() && msg->first == currentVersion;++msg) {
															#line 1069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				wr << msg->second.toStringRef();
															#line 3032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1071 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentData->set(KeyValueRef( persistTagMessagesKey(logData->logId, tagData->tag, currentVersion), wr.toValue()));
															#line 1073 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagDidWork = true;
															#line 3038 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(loopDepth);
		}
		else
		{
															#line 1076 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			const IDiskQueue::location begin = logData->versionLocation[currentVersion].first;
															#line 1077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			const IDiskQueue::location end = logData->versionLocation[currentVersion].second;
															#line 1078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(end > begin && end.lo - begin.lo < std::numeric_limits<uint32_t>::max());
															#line 1079 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			uint32_t length = static_cast<uint32_t>(end.lo - begin.lo);
															#line 1080 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			refSpilledTagCount++;
															#line 1082 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			uint32_t size = 0;
															#line 1083 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(;msg != tagData->versionMessages.end() && msg->first == currentVersion;++msg) {
															#line 1085 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				size += msg->second.expectedSize();
															#line 3059 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1088 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			SpilledData spilledData(currentVersion, begin, length, size);
															#line 1089 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			wr << spilledData;
															#line 1091 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			lastVersion = std::max(currentVersion, lastVersion);
															#line 1092 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			firstLocation = std::min(begin, firstLocation);
															#line 1094 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if ((wr.getLength() + sizeof(SpilledData) > SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BYTES_PER_BATCH))
															#line 3071 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1096 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				*(uint32_t*)wr.getData() = refSpilledTagCount;
															#line 1097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				self->persistentData->set(KeyValueRef( persistTagMessageRefsKey(logData->logId, tagData->tag, lastVersion), wr.toValue()));
															#line 1099 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				tagDidWork = true;
															#line 1100 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				tagData->poppedLocation = std::min(tagData->poppedLocation, firstLocation);
															#line 1101 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				refSpilledTagCount = 0;
															#line 1102 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				wr = BinaryWriter(AssumeVersion(logData->protocolVersion));
															#line 1103 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				wr << uint32_t(0);
															#line 3087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1106 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Future<Void> f = yield(TaskPriority::UpdateStorage);
															#line 1107 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!f.isReady())
															#line 3093 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_1 = f;
															#line 1108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 3099 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1loopBody1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 2;
															#line 1108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 1, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1109 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		msg = std::upper_bound( tagData->versionMessages.begin(), tagData->versionMessages.end(), std::make_pair(currentVersion, LengthPrefixedStringRef()), [](const auto& l, const auto& r) -> bool { return l.first < r.first; });
															#line 3144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1109 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		msg = std::upper_bound( tagData->versionMessages.begin(), tagData->versionMessages.end(), std::make_pair(currentVersion, LengthPrefixedStringRef()), [](const auto& l, const auto& r) -> bool { return l.first < r.first; });
															#line 3153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (tagDidWork)
															#line 3237 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagsProcessedThisBatch++;
															#line 3241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (tagDidWork)
															#line 3251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tagsProcessedThisBatch++;
															#line 3255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0, TaskPriority::UpdateStorage);
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3342 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 5;
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 4, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0, TaskPriority::UpdateStorage);
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3358 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 5;
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 4, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3363 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		CODE_PROBE(anyData, "TLog moved data to persistentData");
															#line 1168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->persistentDataDurableVersion = newPersistentDataVersion;
															#line 1169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagLocality = 0;
															#line 3451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		CODE_PROBE(anyData, "TLog moved data to persistentData");
															#line 1168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->persistentDataDurableVersion = newPersistentDataVersion;
															#line 1169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagLocality = 0;
															#line 3464 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->version_sizes.erase(logData->version_sizes.begin(), logData->version_sizes.lower_bound(logData->persistentDataDurableVersion));
															#line 1182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = yield(TaskPriority::UpdateStorage);
															#line 1182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3552 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6when1(__when_expr_7.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 8;
															#line 1182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 7, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 1169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(tagLocality < logData->tag_data.size()))
															#line 3573 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagId = 0;
															#line 3579 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
															#line 1169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagLocality++;
															#line 3601 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1(int loopDepth) 
	{
															#line 1170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(tagId < logData->tag_data[tagLocality].size()))
															#line 3617 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont5loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->tag_data[tagLocality][tagId])
															#line 3623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = logData->tag_data[tagLocality][tagId]->eraseMessagesBefore( newPersistentDataVersion + 1, self, logData, TaskPriority::UpdateStorage);
															#line 1172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont5loopBody1loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 6;
															#line 1172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 5, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont5loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagId++;
															#line 3661 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont5loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = yield(TaskPriority::UpdateStorage);
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont5loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 7;
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 6, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3677 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = yield(TaskPriority::UpdateStorage);
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont5loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 7;
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 6, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 3693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont5loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 3864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 3873 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 1193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->bytesDurable.getValue() > logData->bytesInput.getValue() || self->bytesDurable > self->bytesInput)
															#line 3957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent(SevError, "BytesDurableTooLarge", logData->logId) .detail("SharedBytesInput", self->bytesInput) .detail("SharedBytesDurable", self->bytesDurable) .detail("LocalBytesInput", logData->bytesInput.getValue()) .detail("LocalBytesDurable", logData->bytesDurable.getValue());
															#line 3961 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(logData->bytesDurable.getValue() <= logData->bytesInput.getValue());
															#line 1202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(self->bytesDurable <= self->bytesInput);
															#line 1204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->queueCommitEnd.get() > 0)
															#line 3969 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1206 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Version minVersion = std::numeric_limits<Version>::max();
															#line 1207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(tagLocality = 0;tagLocality < logData->tag_data.size();tagLocality++) {
															#line 1208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				for(tagId = 0;tagId < logData->tag_data[tagLocality].size();tagId++) {
															#line 1209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					Reference<LogData::TagData> tagData = logData->tag_data[tagLocality][tagId];
															#line 1210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (tagData)
															#line 3981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (logData->shouldSpillByValue(tagData->tag))
															#line 3985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1212 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							minVersion = std::min(minVersion, newPersistentDataVersion);
															#line 3989 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							minVersion = std::min(minVersion, tagData->popped);
															#line 3995 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
					}
				}
			}
															#line 1219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (minVersion != std::numeric_limits<Version>::max())
															#line 4002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				self->persistentQueue->forgetBefore( newPersistentDataVersion, logData);
															#line 4006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 1226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->newPersistentDataVersion = invalidVersion;
															#line 1228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<UpdatePersistentDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdatePersistentDataActorState(); static_cast<UpdatePersistentDataActor*>(this)->destroy(); return 0; }
															#line 4013 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<UpdatePersistentDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdatePersistentDataActorState();
		static_cast<UpdatePersistentDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 1184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(!logData->messageBlocks.empty() && logData->messageBlocks.front().first <= newPersistentDataVersion))
															#line 4032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int64_t bytesErased = int64_t(logData->messageBlocks.front().second.size()) * SERVER_KNOBS->TLOG_MESSAGE_BLOCK_OVERHEAD_FACTOR;
															#line 1187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->bytesDurable += bytesErased;
															#line 1188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->bytesDurable += bytesErased;
															#line 1189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->messageBlocks.pop_front();
															#line 1190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_8 = yield(TaskPriority::UpdateStorage);
															#line 1190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 9;
															#line 1190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< UpdatePersistentDataActor, 8, Void >*>(static_cast<UpdatePersistentDataActor*>(this)));
															#line 4053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state > 0) static_cast<UpdatePersistentDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatePersistentDataActor*>(this)->ActorCallback< UpdatePersistentDataActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< UpdatePersistentDataActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< UpdatePersistentDataActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version newPersistentDataVersion;
															#line 1020 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	BinaryWriter wr;
															#line 1030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool anyData;
															#line 1036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int64_t tagsProcessedThisBatch;
															#line 1039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int tagLocality;
															#line 1040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int tagId;
															#line 1044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData::TagData> tagData;
															#line 1047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool tagDidWork;
															#line 1049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version currentVersion;
															#line 1052 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version lastVersion;
															#line 1053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	IDiskQueue::location firstLocation;
															#line 1055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::deque<std::pair<Version, LengthPrefixedStringRef>>::iterator msg;
															#line 1057 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int refSpilledTagCount;
															#line 1154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double tLogMaxCreateDuration;
															#line 4190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatePersistentData()
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdatePersistentDataActor final : public Actor<Void>, public ActorCallback< UpdatePersistentDataActor, 0, Void >, public ActorCallback< UpdatePersistentDataActor, 1, Void >, public ActorCallback< UpdatePersistentDataActor, 2, Void >, public ActorCallback< UpdatePersistentDataActor, 3, Void >, public ActorCallback< UpdatePersistentDataActor, 4, Void >, public ActorCallback< UpdatePersistentDataActor, 5, Void >, public ActorCallback< UpdatePersistentDataActor, 6, Void >, public ActorCallback< UpdatePersistentDataActor, 7, Void >, public ActorCallback< UpdatePersistentDataActor, 8, Void >, public FastAllocated<UpdatePersistentDataActor>, public UpdatePersistentDataActorState<UpdatePersistentDataActor> {
															#line 4195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatePersistentDataActor>::operator new;
	using FastAllocated<UpdatePersistentDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5326619756855625728UL, 4109117454162642176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatePersistentDataActor, 0, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 1, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 2, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 3, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 4, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 5, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 6, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 7, Void >;
friend struct ActorCallback< UpdatePersistentDataActor, 8, Void >;
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdatePersistentDataActor(TLogData* const& self,Reference<LogData> const& logData,Version const& newPersistentDataVersion) 
															#line 4220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatePersistentDataActorState<UpdatePersistentDataActor>(self, logData, newPersistentDataVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatePersistentData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2889149440903129088UL, 11716763810056457984UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatePersistentDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatePersistentData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatePersistentData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< UpdatePersistentDataActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> updatePersistentData( TLogData* const& self, Reference<LogData> const& logData, Version const& newPersistentDataVersion ) {
															#line 1019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new UpdatePersistentDataActor(self, logData, newPersistentDataVersion));
															#line 4261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 4266 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogPopCore()
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogPopCoreActor>
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPopCoreActorState {
															#line 4273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPopCoreActorState(TLogData* const& self,Tag const& inputTag,Version const& to,Reference<LogData> const& logData) 
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   inputTag(inputTag),
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   to(to),
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 1232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   upTo(to)
															#line 4288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogPopCore", reinterpret_cast<unsigned long>(this));

	}
	~TLogPopCoreActorState() 
	{
		fdb_probe_actor_destroy("tLogPopCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1233 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			int8_t tagLocality = inputTag.locality;
															#line 1234 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (isPseudoLocality(tagLocality))
															#line 4305 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (logData->logSystem->get().isValid())
															#line 4309 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1238 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (isPseudoLocality(inputTag.locality) && logData->logSystem->get()->hasPseudoLocality(inputTag.locality))
															#line 4313 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1240 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						upTo = logData->logSystem->get()->popPseudoLocalityTag(inputTag, to);
															#line 1241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						tagLocality = tagLocalityLogRouter;
															#line 4319 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						ASSERT_WE_THINK(tagLocality == tagLocalityLogRouterMapped);
															#line 1244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						TraceEvent(SevWarn, "TLogPopNoPseudoLocality", self->dbgid) .detail("Locality", tagLocality) .detail("Version", upTo);
															#line 1247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (!static_cast<TLogPopCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPopCoreActorState(); static_cast<TLogPopCoreActor*>(this)->destroy(); return 0; }
															#line 4329 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						new (&static_cast<TLogPopCoreActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~TLogPopCoreActorState();
						static_cast<TLogPopCoreActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 1250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					TraceEvent(SevWarn, "TLogPopNoLogSystem", self->dbgid) .detail("Locality", tagLocality) .detail("Version", upTo);
															#line 1253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!static_cast<TLogPopCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPopCoreActorState(); static_cast<TLogPopCoreActor*>(this)->destroy(); return 0; }
															#line 4342 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					new (&static_cast<TLogPopCoreActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~TLogPopCoreActorState();
					static_cast<TLogPopCoreActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			tag = Tag(tagLocality, inputTag.id);
															#line 1257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto tagData = logData->getTagData(tag);
															#line 1258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!tagData)
															#line 4355 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				tagData = logData->createTagData(tag, upTo, true, true, false);
															#line 4359 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (upTo > tagData->popped)
															#line 4366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					tagData->popped = upTo;
															#line 1262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					tagData->poppedRecently = true;
															#line 1264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (tagData->unpoppedRecovered)
															#line 4374 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						bool poppedGen = false;
															#line 1270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (logData->tagUnpoppedOldGenerations.find(tag) != logData->tagUnpoppedOldGenerations.end())
															#line 4380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1271 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							std::vector<Version>* unpoppedGen = &(logData->tagUnpoppedOldGenerations[tag]);
															#line 1272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							for(;unpoppedGen->size() > 1 && ((*unpoppedGen)[unpoppedGen->size() - 2] < upTo);) {
															#line 1273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
								unpoppedGen->pop_back();
															#line 1274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
								poppedGen = true;
															#line 4390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
							}
						}
															#line 1277 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (poppedGen)
															#line 4395 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1278 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							logData->updateGenerationRecovery.trigger();
															#line 4399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
															#line 1280 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (upTo > logData->recoveredAt)
															#line 4403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1281 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							tagData->unpoppedRecovered = false;
															#line 1282 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							logData->unpoppedRecoveredTagCount--;
															#line 1283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							logData->unpoppedRecoveredTags.erase(tag);
															#line 1284 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							TraceEvent("TLogPoppedTag", logData->logId) .detail("Tags", logData->unpoppedRecoveredTagCount) .detail("Tag", tag.toString()) .detail("DurableKCVer", logData->durableKnownCommittedVersion) .detail("RecoveredAt", logData->recoveredAt) .detail("UnpoppedTags", describe(logData->unpoppedRecoveredTags));
															#line 1290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							if (logData->unpoppedRecoveredTagCount == 0 && logData->durableKnownCommittedVersion >= logData->recoveredAt && logData->recoveryComplete.canBeSet())
															#line 4415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
							{
															#line 1293 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
								TraceEvent("TLogRecoveryComplete", logData->logId) .detail("Tags", logData->unpoppedRecoveredTagCount) .detail("DurableKCVer", logData->durableKnownCommittedVersion) .detail("RecoveredAt", logData->recoveredAt);
															#line 1297 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
								logData->recoveryComplete.send(Void());
															#line 4421 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
							}
						}
					}
															#line 1302 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					uint64_t PoppedVersionLag = logData->persistentDataDurableVersion - logData->queuePoppedVersion;
															#line 1303 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (SERVER_KNOBS->ENABLE_DETAILED_TLOG_POP_TRACE && (logData->queuePoppedVersion > 0) && (tagData->unpoppedRecovered || PoppedVersionLag >= SERVER_KNOBS->TLOG_POPPED_VER_LAG_THRESHOLD_FOR_TLOGPOP_TRACE))
															#line 4429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						TraceEvent("TLogPopDetails", logData->logId) .detail("Tag", tagData->tag.toString()) .detail("UpTo", upTo) .detail("PoppedVersionLag", PoppedVersionLag) .detail("MinPoppedTag", logData->minPoppedTag.toString()) .detail("QueuePoppedVersion", logData->queuePoppedVersion) .detail("UnpoppedRecovered", tagData->unpoppedRecovered ? "True" : "False") .detail("NothingPersistent", tagData->nothingPersistent ? "True" : "False");
															#line 4433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (upTo > logData->persistentDataDurableVersion)
															#line 4437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						StrictFuture<Void> __when_expr_0 = tagData->eraseMessagesBefore(upTo, self, logData, TaskPriority::TLogPop);
															#line 1318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (static_cast<TLogPopCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<TLogPopCoreActor*>(this)->actor_wait_state = 1;
															#line 1318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogPopCoreActor, 0, Void >*>(static_cast<TLogPopCoreActor*>(this)));
															#line 4448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont9(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont8(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogPopCoreActorState();
		static_cast<TLogPopCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogPopCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPopCoreActorState(); static_cast<TLogPopCoreActor*>(this)->destroy(); return 0; }
															#line 4482 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogPopCoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogPopCoreActorState();
		static_cast<TLogPopCoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogPopCoreActor*>(this)->actor_wait_state > 0) static_cast<TLogPopCoreActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPopCoreActor*>(this)->ActorCallback< TLogPopCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPopCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogPopCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogPopCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPopCore", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Tag inputTag;
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version to;
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 1232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version upTo;
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Tag tag;
															#line 4601 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogPopCore()
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPopCoreActor final : public Actor<Void>, public ActorCallback< TLogPopCoreActor, 0, Void >, public FastAllocated<TLogPopCoreActor>, public TLogPopCoreActorState<TLogPopCoreActor> {
															#line 4606 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogPopCoreActor>::operator new;
	using FastAllocated<TLogPopCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5572760238494539264UL, 12093248884042696704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogPopCoreActor, 0, Void >;
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPopCoreActor(TLogData* const& self,Tag const& inputTag,Version const& to,Reference<LogData> const& logData) 
															#line 4623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogPopCoreActorState<TLogPopCoreActor>(self, inputTag, to, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogPopCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10138513405789512960UL, 11610575650440401664UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogPopCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogPopCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogPopCoreActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogPopCore( TLogData* const& self, Tag const& inputTag, Version const& to, Reference<LogData> const& logData ) {
															#line 1231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogPopCoreActor(self, inputTag, to, logData));
															#line 4656 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1323 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 4661 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via processPopRequests()
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class ProcessPopRequestsActor>
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ProcessPopRequestsActorState {
															#line 4668 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ProcessPopRequestsActorState(TLogData* const& self,Reference<LogData> const& logData) 
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 1325 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   ignoredPops(),
															#line 1326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   it(),
															#line 1327 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   ignoredPopsPlayed(0),
															#line 1328 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   toBePopped()
															#line 4685 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processPopRequests", reinterpret_cast<unsigned long>(this));

	}
	~ProcessPopRequestsActorState() 
	{
		fdb_probe_actor_destroy("processPopRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 4700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessPopRequestsActorState();
		static_cast<ProcessPopRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1334 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		toBePopped = std::move(logData->toBePopped);
															#line 1335 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->toBePopped.clear();
															#line 1336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->ignorePopUid = "";
															#line 1337 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		it = toBePopped.cbegin();
															#line 4729 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(now() < self->ignorePopDeadline))
															#line 4745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayUntil(self->ignorePopDeadline + 0.0001);
															#line 1331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4753 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 1;
															#line 1331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessPopRequestsActor, 0, Void >*>(static_cast<ProcessPopRequestsActor*>(this)));
															#line 4758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state > 0) static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessPopRequestsActor*>(this)->ActorCallback< ProcessPopRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessPopRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(ignoredPops);
															#line 1346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 3;
															#line 1346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessPopRequestsActor, 2, Void >*>(static_cast<ProcessPopRequestsActor*>(this)));
															#line 4874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1337 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(it != toBePopped.cend()))
															#line 4890 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1338 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const auto& [tag, version] = *it;
															#line 1339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("PlayIgnoredPop", logData->logId).detail("Tag", tag.toString()).detail("Version", version);
															#line 1340 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ignoredPops.push_back(tLogPopCore(self, tag, version, logData));
															#line 1341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (++ignoredPopsPlayed % SERVER_KNOBS->TLOG_POP_BATCH_SIZE == 0)
															#line 4902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1342 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "Yielding while processing pop requests", probe::decoration::rare);
															#line 1343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = yield();
															#line 1343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4910 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 2;
															#line 1343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessPopRequestsActor, 1, Void >*>(static_cast<ProcessPopRequestsActor*>(this)));
															#line 4915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1337 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		++it;
															#line 4942 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state > 0) static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessPopRequestsActor*>(this)->ActorCallback< ProcessPopRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessPopRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("ResetIgnorePopRequest", logData->logId).detail("IgnorePopDeadline", self->ignorePopDeadline);
															#line 1348 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<ProcessPopRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessPopRequestsActorState(); static_cast<ProcessPopRequestsActor*>(this)->destroy(); return 0; }
															#line 5040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessPopRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessPopRequestsActorState();
		static_cast<ProcessPopRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("ResetIgnorePopRequest", logData->logId).detail("IgnorePopDeadline", self->ignorePopDeadline);
															#line 1348 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<ProcessPopRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessPopRequestsActorState(); static_cast<ProcessPopRequestsActor*>(this)->destroy(); return 0; }
															#line 5054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessPopRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessPopRequestsActorState();
		static_cast<ProcessPopRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state > 0) static_cast<ProcessPopRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessPopRequestsActor*>(this)->ActorCallback< ProcessPopRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessPopRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessPopRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 1325 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<Future<Void>> ignoredPops;
															#line 1326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::map<Tag, Version>::const_iterator it;
															#line 1327 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int ignoredPopsPlayed;
															#line 1328 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::map<Tag, Version> toBePopped;
															#line 5149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processPopRequests()
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ProcessPopRequestsActor final : public Actor<Void>, public ActorCallback< ProcessPopRequestsActor, 0, Void >, public ActorCallback< ProcessPopRequestsActor, 1, Void >, public ActorCallback< ProcessPopRequestsActor, 2, Void >, public FastAllocated<ProcessPopRequestsActor>, public ProcessPopRequestsActorState<ProcessPopRequestsActor> {
															#line 5154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessPopRequestsActor>::operator new;
	using FastAllocated<ProcessPopRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5719138447408129792UL, 6747080321891852288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessPopRequestsActor, 0, Void >;
friend struct ActorCallback< ProcessPopRequestsActor, 1, Void >;
friend struct ActorCallback< ProcessPopRequestsActor, 2, Void >;
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ProcessPopRequestsActor(TLogData* const& self,Reference<LogData> const& logData) 
															#line 5173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProcessPopRequestsActorState<ProcessPopRequestsActor>(self, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processPopRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16644083025108613632UL, 16342246520475828480UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessPopRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processPopRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processPopRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessPopRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessPopRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessPopRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> processPopRequests( TLogData* const& self, Reference<LogData> const& logData ) {
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new ProcessPopRequestsActor(self, logData));
															#line 5208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1350 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 5213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogPop()
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogPopActor>
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPopActorState {
															#line 5220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPopActorState(TLogData* const& self,TLogPopRequest const& req,Reference<LogData> const& logData) 
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   req(req),
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 5231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogPop", reinterpret_cast<unsigned long>(this));

	}
	~TLogPopActorState() 
	{
		fdb_probe_actor_destroy("tLogPop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1352 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (now() < self->ignorePopDeadline)
															#line 5246 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1353 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent(SevDebug, "IgnoringPopRequest", logData->logId).detail("IgnorePopDeadline", self->ignorePopDeadline);
															#line 1355 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (logData->toBePopped.empty())
															#line 5252 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1356 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					logData->addActor.send(processPopRequests(self, logData));
															#line 5256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
															#line 1359 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				auto& v = logData->toBePopped[req.tag];
															#line 1360 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				v = std::max(v, req.to);
															#line 1362 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent(SevDebug, "IgnoringPopRequest", logData->logId) .detail("IgnorePopDeadline", self->ignorePopDeadline) .detail("Tag", req.tag.toString()) .detail("Version", req.to);
															#line 5264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1367 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tLogPopCore(self, req.tag, req.to, logData);
															#line 1367 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<TLogPopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TLogPopActor*>(this)->actor_wait_state = 1;
															#line 1367 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogPopActor, 0, Void >*>(static_cast<TLogPopActor*>(this)));
															#line 5278 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogPopActorState();
		static_cast<TLogPopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1369 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req.reply.send(Void());
															#line 1370 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogPopActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPopActorState(); static_cast<TLogPopActor*>(this)->destroy(); return 0; }
															#line 5304 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogPopActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogPopActorState();
		static_cast<TLogPopActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogPopActor*>(this)->actor_wait_state > 0) static_cast<TLogPopActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPopActor*>(this)->ActorCallback< TLogPopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogPopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogPopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPop", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPopRequest req;
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 5405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogPop()
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPopActor final : public Actor<Void>, public ActorCallback< TLogPopActor, 0, Void >, public FastAllocated<TLogPopActor>, public TLogPopActorState<TLogPopActor> {
															#line 5410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogPopActor>::operator new;
	using FastAllocated<TLogPopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5702934379777658624UL, 16542350849333108736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogPopActor, 0, Void >;
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPopActor(TLogData* const& self,TLogPopRequest const& req,Reference<LogData> const& logData) 
															#line 5427 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogPopActorState<TLogPopActor>(self, req, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogPop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6918075887650476800UL, 2672580132554723328UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogPop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogPop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogPopActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogPop( TLogData* const& self, TLogPopRequest const& req, Reference<LogData> const& logData ) {
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogPopActor(self, req, logData));
															#line 5460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1372 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

// This function (and updatePersistentData, which is called by this function) run at a low priority and can soak up all
// CPU resources. For this reason, they employ aggressive use of yields to avoid causing slow tasks that could introduce
// latencies for more important work (e.g. commits).
// This actor is just a loop that calls updatePersistentData and popDiskQueue whenever
// (a) there's data to be spilled or (b) we should update metadata after some commits have been fully popped.
															#line 5470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateStorage()
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class UpdateStorageActor>
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdateStorageActorState {
															#line 5477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdateStorageActorState(TLogData* const& self) 
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self)
															#line 5484 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateStorage", reinterpret_cast<unsigned long>(this));

	}
	~UpdateStorageActorState() 
	{
		fdb_probe_actor_destroy("updateStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1379 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for(;self->spillOrder.size() && !self->id_data.contains(self->spillOrder.front());) {
															#line 1380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				self->spillOrder.pop_front();
															#line 5501 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1383 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!self->spillOrder.size())
															#line 5505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateStorageActor*>(this)->actor_wait_state = 1;
															#line 1384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 0, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateStorageActorState();
		static_cast<UpdateStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData = self->id_data[self->spillOrder.front()];
															#line 1391 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		nextVersion = 0;
															#line 1392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		totalSize = 0;
															#line 1394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser();
															#line 1396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->stopped())
															#line 5552 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1397 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->bytesInput - self->bytesDurable >= self->targetVolatileBytes)
															#line 5556 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				;
															#line 5560 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopHead1(loopDepth);
			}
			else
			{
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5569 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1when1(__when_expr_8.get(), loopDepth); };
				static_cast<UpdateStorageActor*>(this)->actor_wait_state = 9;
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 8, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5574 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
															#line 1445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (logData->initialized)
															#line 5582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1446 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				ASSERT(self->spillOrder.size() == 1);
															#line 1447 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (logData->version_sizes.empty())
															#line 5588 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					nextVersion = logData->version.get();
															#line 5592 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					ASSERT_WE_THINK(self->targetVolatileBytes == SERVER_KNOBS->TLOG_SPILL_THRESHOLD);
															#line 1452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					Map<Version, std::pair<int, int>>::iterator sizeItr = logData->version_sizes.begin();
															#line 1453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					for(;totalSize < SERVER_KNOBS->REFERENCE_SPILL_UPDATE_STORAGE_BYTE_LIMIT && sizeItr != logData->version_sizes.end() && (logData->bytesInput.getValue() - logData->bytesDurable.getValue() - totalSize >= self->targetVolatileBytes || sizeItr->value.first == 0);) {
															#line 1458 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						totalSize += sizeItr->value.first + sizeItr->value.second;
															#line 1459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						++sizeItr;
															#line 1460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						nextVersion = sizeItr == logData->version_sizes.end() ? logData->version.get() : sizeItr->key;
															#line 5608 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
				}
															#line 1466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_9 = logData->queueCommittedVersion.whenAtLeast(nextVersion);
															#line 1466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1when2(__when_expr_9.get(), loopDepth); };
				static_cast<UpdateStorageActor*>(this)->actor_wait_state = 10;
															#line 1466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 9, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_16 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont1when3(__when_expr_16.get(), loopDepth); };
				static_cast<UpdateStorageActor*>(this)->actor_wait_state = 17;
															#line 1492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 16, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 5645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateStorageActorState();
		static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 5657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateStorageActorState();
		static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 5744 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateStorageActorState();
		static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1436 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->persistentDataDurableVersion == logData->version.get())
															#line 5762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->spillOrder.pop_front();
															#line 5766 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1439 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(0.0, TaskPriority::UpdateStorage);
															#line 1439 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 8;
															#line 1439 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 7, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5777 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(logData->persistentDataDurableVersion != logData->version.get()))
															#line 5793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		totalSize = 0;
															#line 1400 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Map<Version, std::pair<int, int>>::iterator sizeItr = logData->version_sizes.begin();
															#line 1401 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		nextVersion = logData->version.get();
															#line 1402 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(;totalSize < SERVER_KNOBS->REFERENCE_SPILL_UPDATE_STORAGE_BYTE_LIMIT && sizeItr != logData->version_sizes.end();) {
															#line 1404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			totalSize += sizeItr->value.first + sizeItr->value.second;
															#line 1405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			++sizeItr;
															#line 1406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			nextVersion = sizeItr == logData->version_sizes.end() ? logData->version.get() : sizeItr->key;
															#line 5811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 1409 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = logData->queueCommittedVersion.whenAtLeast(nextVersion);
															#line 1409 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 2;
															#line 1409 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 1, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5822 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 5844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 5848 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateStorageActorState();
			static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0, TaskPriority::UpdateStorage);
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 3;
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 2, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 5872 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 5876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateStorageActorState();
			static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0, TaskPriority::UpdateStorage);
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5886 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 3;
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 2, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (nextVersion > logData->persistentDataVersion)
															#line 5975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->persistentDataCommitLock.take();
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 4;
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 3, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 5986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5995 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when2(__when_expr_6.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 7;
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 6, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (nextVersion > logData->persistentDataVersion)
															#line 6010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->persistentDataCommitLock.take();
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 4;
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 3, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6021 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when2(__when_expr_6.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 7;
															#line 1426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 6, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6035 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 1431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->removed.isReady())
															#line 6120 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1418 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updatePersistentData(self, logData, nextVersion);
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 5;
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 4, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1418 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updatePersistentData(self, logData, nextVersion);
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 5;
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 4, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1421 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->popOrder.size())
															#line 6243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = popDiskQueue(self, self->id_data[self->popOrder.front()]);
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 6;
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 5, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6254 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1421 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->popOrder.size())
															#line 6268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = popDiskQueue(self, self->id_data[self->popOrder.front()]);
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 6;
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 5, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
															#line 1424 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser.release();
															#line 6368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 1467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 6731 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 6735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateStorageActorState();
			static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(0, TaskPriority::UpdateStorage);
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 11;
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 10, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 1467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 6759 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<UpdateStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageActorState(); static_cast<UpdateStorageActor*>(this)->destroy(); return 0; }
															#line 6763 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<UpdateStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateStorageActorState();
			static_cast<UpdateStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(0, TaskPriority::UpdateStorage);
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 11;
															#line 1470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 10, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 1472 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (nextVersion > logData->persistentDataVersion)
															#line 6862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_11 = self->persistentDataCommitLock.take();
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6868 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 12;
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 11, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6873 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 1472 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (nextVersion > logData->persistentDataVersion)
															#line 6887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_11 = self->persistentDataCommitLock.take();
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 12;
															#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 11, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 1482 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (totalSize < SERVER_KNOBS->REFERENCE_SPILL_UPDATE_STORAGE_BYTE_LIMIT)
															#line 6987 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_14 = delay(BUGGIFY ? SERVER_KNOBS->BUGGIFY_TLOG_STORAGE_MIN_UPDATE_INTERVAL : SERVER_KNOBS->TLOG_STORAGE_MIN_UPDATE_INTERVAL, TaskPriority::UpdateStorage);
															#line 1483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6993 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_14.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 15;
															#line 1483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 14, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 6998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 1489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_15 = delay(0.0, TaskPriority::UpdateStorage);
															#line 1489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont12cont3when2(__when_expr_15.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 16;
															#line 1489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 15, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 7012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_12 = updatePersistentData(self, logData, nextVersion);
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 13;
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 12, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 7031 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_12 = updatePersistentData(self, logData, nextVersion);
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<UpdateStorageActor*>(this)->actor_wait_state = 13;
															#line 1475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 12, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 7049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont5(Void const& _,int loopDepth) 
	{
															#line 1476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->popOrder.size())
															#line 7133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_13 = popDiskQueue(self, self->id_data[self->popOrder.front()]);
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont5when1(__when_expr_13.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 14;
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 13, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 7144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont5(Void && _,int loopDepth) 
	{
															#line 1476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->popOrder.size())
															#line 7158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_13 = popDiskQueue(self, self->id_data[self->popOrder.front()]);
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont5when1(__when_expr_13.get(), loopDepth); };
			static_cast<UpdateStorageActor*>(this)->actor_wait_state = 14;
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageActor, 13, Void >*>(static_cast<UpdateStorageActor*>(this)));
															#line 7169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont6(int loopDepth) 
	{
															#line 1479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser.release();
															#line 7258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont12cont9(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont12cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<UpdateStorageActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageActor*>(this)->ActorCallback< UpdateStorageActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< UpdateStorageActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< UpdateStorageActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 1391 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version nextVersion;
															#line 1392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int totalSize;
															#line 1394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	FlowLock::Releaser commitLockReleaser;
															#line 7627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateStorage()
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdateStorageActor final : public Actor<Void>, public ActorCallback< UpdateStorageActor, 0, Void >, public ActorCallback< UpdateStorageActor, 1, Void >, public ActorCallback< UpdateStorageActor, 2, Void >, public ActorCallback< UpdateStorageActor, 3, Void >, public ActorCallback< UpdateStorageActor, 4, Void >, public ActorCallback< UpdateStorageActor, 5, Void >, public ActorCallback< UpdateStorageActor, 6, Void >, public ActorCallback< UpdateStorageActor, 7, Void >, public ActorCallback< UpdateStorageActor, 8, Void >, public ActorCallback< UpdateStorageActor, 9, Void >, public ActorCallback< UpdateStorageActor, 10, Void >, public ActorCallback< UpdateStorageActor, 11, Void >, public ActorCallback< UpdateStorageActor, 12, Void >, public ActorCallback< UpdateStorageActor, 13, Void >, public ActorCallback< UpdateStorageActor, 14, Void >, public ActorCallback< UpdateStorageActor, 15, Void >, public ActorCallback< UpdateStorageActor, 16, Void >, public FastAllocated<UpdateStorageActor>, public UpdateStorageActorState<UpdateStorageActor> {
															#line 7632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateStorageActor>::operator new;
	using FastAllocated<UpdateStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7423482689815419648UL, 13087860302319243264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateStorageActor, 0, Void >;
friend struct ActorCallback< UpdateStorageActor, 1, Void >;
friend struct ActorCallback< UpdateStorageActor, 2, Void >;
friend struct ActorCallback< UpdateStorageActor, 3, Void >;
friend struct ActorCallback< UpdateStorageActor, 4, Void >;
friend struct ActorCallback< UpdateStorageActor, 5, Void >;
friend struct ActorCallback< UpdateStorageActor, 6, Void >;
friend struct ActorCallback< UpdateStorageActor, 7, Void >;
friend struct ActorCallback< UpdateStorageActor, 8, Void >;
friend struct ActorCallback< UpdateStorageActor, 9, Void >;
friend struct ActorCallback< UpdateStorageActor, 10, Void >;
friend struct ActorCallback< UpdateStorageActor, 11, Void >;
friend struct ActorCallback< UpdateStorageActor, 12, Void >;
friend struct ActorCallback< UpdateStorageActor, 13, Void >;
friend struct ActorCallback< UpdateStorageActor, 14, Void >;
friend struct ActorCallback< UpdateStorageActor, 15, Void >;
friend struct ActorCallback< UpdateStorageActor, 16, Void >;
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdateStorageActor(TLogData* const& self) 
															#line 7665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateStorageActorState<UpdateStorageActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4324716052992080640UL, 10929706573311253760UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateStorageActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateStorageActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateStorageActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< UpdateStorageActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< UpdateStorageActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< UpdateStorageActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< UpdateStorageActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< UpdateStorageActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< UpdateStorageActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< UpdateStorageActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< UpdateStorageActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< UpdateStorageActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< UpdateStorageActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< UpdateStorageActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< UpdateStorageActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< UpdateStorageActor, 16, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> updateStorage( TLogData* const& self ) {
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new UpdateStorageActor(self));
															#line 7714 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 7719 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateStorageLoop()
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class UpdateStorageLoopActor>
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdateStorageLoopActorState {
															#line 7726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdateStorageLoopActorState(TLogData* const& self) 
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self)
															#line 7733 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateStorageLoop", reinterpret_cast<unsigned long>(this));

	}
	~UpdateStorageLoopActorState() 
	{
		fdb_probe_actor_destroy("updateStorageLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::UpdateStorage);
															#line 1500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state = 1;
															#line 1500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageLoopActor, 0, Void >*>(static_cast<UpdateStorageLoopActor*>(this)));
															#line 7755 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateStorageLoopActorState();
		static_cast<UpdateStorageLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 7778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 7787 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageLoopActor*>(this)->ActorCallback< UpdateStorageLoopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateStorageLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateStorageLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = updateStorage(self);
															#line 1503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state = 2;
															#line 1503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageLoopActor, 1, Void >*>(static_cast<UpdateStorageLoopActor*>(this)));
															#line 7885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageLoopActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageLoopActor*>(this)->ActorCallback< UpdateStorageLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateStorageLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateStorageLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 7979 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateStorageLoop()
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class UpdateStorageLoopActor final : public Actor<Void>, public ActorCallback< UpdateStorageLoopActor, 0, Void >, public ActorCallback< UpdateStorageLoopActor, 1, Void >, public FastAllocated<UpdateStorageLoopActor>, public UpdateStorageLoopActorState<UpdateStorageLoopActor> {
															#line 7984 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateStorageLoopActor>::operator new;
	using FastAllocated<UpdateStorageLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15988231812071071744UL, 16356542596788507136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateStorageLoopActor, 0, Void >;
friend struct ActorCallback< UpdateStorageLoopActor, 1, Void >;
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UpdateStorageLoopActor(TLogData* const& self) 
															#line 8002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateStorageLoopActorState<UpdateStorageLoopActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateStorageLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5026737847561234944UL, 10913404656748779520UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateStorageLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateStorageLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateStorageLoopActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateStorageLoopActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> updateStorageLoop( TLogData* const& self ) {
															#line 1499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new UpdateStorageLoopActor(self));
															#line 8036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

void commitMessages(TLogData* self,
                    Reference<LogData> logData,
                    Version version,
                    const std::vector<TagsAndMessage>& taggedMessages) {
	// SOMEDAY: This method of copying messages is reasonably memory efficient, but it's still a lot of bytes copied.
	// Find a way to do the memory allocation right as we receive the messages in the network layer.

	int64_t addedBytes = 0;
	int64_t overheadBytes = 0;
	int expectedBytes = 0;
	int txsBytes = 0;

	if (!taggedMessages.size()) {
		return;
	}
	logData->tagMessageCount += taggedMessages.size();

	int msgSize = 0;
	for (auto& i : taggedMessages) {
		msgSize += i.message.size();
	}

	// Grab the last block in the blocks list so we can share its arena
	// We pop all of the elements of it to create a "fresh" vector that starts at the end of the previous vector
	Standalone<VectorRef<uint8_t>> block;
	if (logData->messageBlocks.empty()) {
		block = Standalone<VectorRef<uint8_t>>();
		block.reserve(block.arena(), std::max<int64_t>(SERVER_KNOBS->TLOG_MESSAGE_BLOCK_BYTES, msgSize));
	} else {
		block = logData->messageBlocks.back().second;
	}

	block.pop_front(block.size());

	for (auto& msg : taggedMessages) {
		if (msg.message.size() > block.capacity() - block.size()) {
			logData->messageBlocks.emplace_back(version, block);
			addedBytes += int64_t(block.size()) * SERVER_KNOBS->TLOG_MESSAGE_BLOCK_OVERHEAD_FACTOR;
			block = Standalone<VectorRef<uint8_t>>();
			block.reserve(block.arena(), std::max<int64_t>(SERVER_KNOBS->TLOG_MESSAGE_BLOCK_BYTES, msgSize));
		}

		DEBUG_TAGS_AND_MESSAGE("TLogCommitMessages", version, msg.getRawMessage(), logData->logId)
		    .detail("DebugID", self->dbgid);
		block.append(block.arena(), msg.message.begin(), msg.message.size());
		for (auto tag : msg.tags) {
			if (logData->locality == tagLocalitySatellite) {
				if (!(tag.locality == tagLocalityTxs || tag.locality == tagLocalityLogRouter || tag == txsTag)) {
					continue;
				}
			} else if (!(logData->locality == tagLocalitySpecial || logData->locality == tag.locality ||
			             tag.locality < 0)) {
				continue;
			}

			if (tag.locality == tagLocalityLogRouter) {
				if (!logData->logRouterTags) {
					continue;
				}
				tag.id = tag.id % logData->logRouterTags;
			}
			if (tag.locality == tagLocalityTxs) {
				if (logData->txsTags > 0) {
					tag.id = tag.id % logData->txsTags;
				} else {
					tag = txsTag;
				}
			}
			Reference<LogData::TagData> tagData = logData->getTagData(tag);
			if (!tagData) {
				tagData = logData->createTagData(tag, 0, true, true, false);
			}

			if (version >= tagData->popped) {
				tagData->versionMessages.emplace_back(
				    version, LengthPrefixedStringRef((uint32_t*)(block.end() - msg.message.size())));
				if (tagData->versionMessages.back().second.expectedSize() > SERVER_KNOBS->MAX_MESSAGE_SIZE) {
					TraceEvent(SevWarnAlways, "LargeMessage")
					    .detail("Size", tagData->versionMessages.back().second.expectedSize());
				}
				if (tag.locality != tagLocalityTxs && tag != txsTag) {
					expectedBytes += tagData->versionMessages.back().second.expectedSize();
				} else {
					txsBytes += tagData->versionMessages.back().second.expectedSize();
				}
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
					auto iter = logData->waitingTags.find(tag);
					if (iter != logData->waitingTags.end()) {
						auto promise = iter->second;
						logData->waitingTags.erase(iter);
						promise.send(Void());
					}
				}

				// The factor of VERSION_MESSAGES_OVERHEAD is intended to be an overestimate of the actual memory used
				// to store this data in a std::deque. In practice, this number is probably something like 528/512
				// ~= 1.03, but this could vary based on the implementation. There will also be a fixed overhead per
				// std::deque, but its size should be trivial relative to the size of the TLog queue and can be thought
				// of as increasing the capacity of the queue slightly.
				overheadBytes += SERVER_KNOBS->VERSION_MESSAGES_ENTRY_BYTES_WITH_OVERHEAD;
			}
		}

		msgSize -= msg.message.size();
	}
	logData->messageBlocks.emplace_back(version, block);
	addedBytes += int64_t(block.size()) * SERVER_KNOBS->TLOG_MESSAGE_BLOCK_OVERHEAD_FACTOR;
	addedBytes += overheadBytes;

	logData->version_sizes[version] = std::make_pair(expectedBytes, txsBytes);
	logData->bytesInput += addedBytes;
	self->bytesInput += addedBytes;
	self->overheadBytesInput += overheadBytes;

	//TraceEvent("TLogPushed", self->dbgid).detail("Bytes", addedBytes).detail("MessageBytes", messages.size()).detail("Tags", tags.size()).detail("ExpectedBytes", expectedBytes).detail("MCount", mCount).detail("TCount", tCount);
}

void commitMessages(TLogData* self, Reference<LogData> logData, Version version, Arena arena, StringRef messages) {
	ArenaReader rd(arena, messages, Unversioned());
	self->tempTagMessages.clear();
	if (SERVER_KNOBS->ENABLE_TLOG_TEMP_TAG_MESSAGES_RESERVE) {
		// Estimate message count to reserve capacity and avoid reallocations
		size_t estimatedMsgCount = std::max(size_t(messages.size() / 150), size_t(10));
		estimatedMsgCount = std::min(estimatedMsgCount, size_t(5000));
		self->tempTagMessages.reserve(estimatedMsgCount);
	}

	while (!rd.empty()) {
		TagsAndMessage tagsAndMsg;
		tagsAndMsg.loadFromArena(&rd, nullptr);
		self->tempTagMessages.push_back(std::move(tagsAndMsg));
	}
	commitMessages(self, logData, version, self->tempTagMessages);
}

Version poppedVersion(Reference<LogData> self, Tag tag) {
	auto tagData = self->getTagData(tag);
	if (!tagData) {
		if (tag == txsTag || tag.locality == tagLocalityTxs || tag.locality == tagLocalityLogRouter) {
			return 0;
		}
		return std::max(self->recoveredAt + 1, self->recoveryTxnVersion);
	}
	return tagData->popped;
}

std::deque<std::pair<Version, LengthPrefixedStringRef>>& getVersionMessages(Reference<LogData> self, Tag tag) {
	auto tagData = self->getTagData(tag);
	if (!tagData) {
		static std::deque<std::pair<Version, LengthPrefixedStringRef>> empty;
		return empty;
	}
	return tagData->versionMessages;
};

															#line 8196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForMessagesForTag()
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class WaitForMessagesForTagActor>
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class WaitForMessagesForTagActorState {
															#line 8203 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	WaitForMessagesForTagActorState(Reference<LogData> const& self,Tag const& reqTag,Version const& reqBegin,double const& timeout) 
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqTag(reqTag),
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqBegin(reqBegin),
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   timeout(timeout)
															#line 8216 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForMessagesForTag", reinterpret_cast<unsigned long>(this));

	}
	~WaitForMessagesForTagActorState() 
	{
		fdb_probe_actor_destroy("waitForMessagesForTag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->blockingPeeks += 1;
															#line 1664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto tagData = self->getTagData(reqTag);
															#line 1665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (tagData.isValid() && !tagData->versionMessages.empty() && tagData->versionMessages.back().first >= reqBegin)
															#line 8235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<WaitForMessagesForTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForMessagesForTagActorState(); static_cast<WaitForMessagesForTagActor*>(this)->destroy(); return 0; }
															#line 8239 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<WaitForMessagesForTagActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitForMessagesForTagActorState();
				static_cast<WaitForMessagesForTagActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->waitingTags[reqTag].getFuture();
															#line 1668 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(timeout);
															#line 8253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state = 1;
															#line 1669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForMessagesForTagActor, 0, Void >*>(static_cast<WaitForMessagesForTagActor*>(this)));
															#line 1673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForMessagesForTagActor, 1, Void >*>(static_cast<WaitForMessagesForTagActor*>(this)));
															#line 8260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForMessagesForTagActorState();
		static_cast<WaitForMessagesForTagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1677 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<WaitForMessagesForTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForMessagesForTagActorState(); static_cast<WaitForMessagesForTagActor*>(this)->destroy(); return 0; }
															#line 8283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<WaitForMessagesForTagActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForMessagesForTagActorState();
		static_cast<WaitForMessagesForTagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.0);
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8297 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state = 2;
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForMessagesForTagActor, 2, Void >*>(static_cast<WaitForMessagesForTagActor*>(this)));
															#line 8302 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.0);
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8313 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state = 2;
															#line 1671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForMessagesForTagActor, 2, Void >*>(static_cast<WaitForMessagesForTagActor*>(this)));
															#line 8318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->blockingPeekTimeouts += 1;
															#line 8327 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->blockingPeekTimeouts += 1;
															#line 8336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state > 0) static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForMessagesForTagActor*>(this)->ActorCallback< WaitForMessagesForTagActor, 0, Void >::remove();
		static_cast<WaitForMessagesForTagActor*>(this)->ActorCallback< WaitForMessagesForTagActor, 1, Void >::remove();

	}
	int a_body1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state > 0) static_cast<WaitForMessagesForTagActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForMessagesForTagActor*>(this)->ActorCallback< WaitForMessagesForTagActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForMessagesForTagActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForMessagesForTagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForMessagesForTagActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForMessagesForTagActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> self;
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Tag reqTag;
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version reqBegin;
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double timeout;
															#line 8557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForMessagesForTag()
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class WaitForMessagesForTagActor final : public Actor<Void>, public ActorCallback< WaitForMessagesForTagActor, 0, Void >, public ActorCallback< WaitForMessagesForTagActor, 2, Void >, public ActorCallback< WaitForMessagesForTagActor, 1, Void >, public FastAllocated<WaitForMessagesForTagActor>, public WaitForMessagesForTagActorState<WaitForMessagesForTagActor> {
															#line 8562 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForMessagesForTagActor>::operator new;
	using FastAllocated<WaitForMessagesForTagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13508965847251248896UL, 3863438555690552064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForMessagesForTagActor, 0, Void >;
friend struct ActorCallback< WaitForMessagesForTagActor, 2, Void >;
friend struct ActorCallback< WaitForMessagesForTagActor, 1, Void >;
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	WaitForMessagesForTagActor(Reference<LogData> const& self,Tag const& reqTag,Version const& reqBegin,double const& timeout) 
															#line 8581 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitForMessagesForTagActorState<WaitForMessagesForTagActor>(self, reqTag, reqBegin, timeout),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4035618405337699328UL, 16262309913307844352UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForMessagesForTag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForMessagesForTag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForMessagesForTagActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForMessagesForTagActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> waitForMessagesForTag( Reference<LogData> const& self, Tag const& reqTag, Version const& reqBegin, double const& timeout ) {
															#line 1662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new WaitForMessagesForTagActor(self, reqTag, reqBegin, timeout));
															#line 8615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1679 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

void peekMessagesFromMemory(Reference<LogData> self,
                            Tag tag,
                            Version begin,
                            BinaryWriter& messages,
                            Version& endVersion) {
	ASSERT(!messages.getLength());

	int versionCount = 0;
	auto& deque = getVersionMessages(self, tag);
	//TraceEvent("TLogPeekMem", self->dbgid).detail("Tag", req.tag1).detail("PDS", self->persistentDataSequence).detail("PDDS", self->persistentDataDurableSequence).detail("Oldest", map1.empty() ? 0 : map1.begin()->key ).detail("OldestMsgCount", map1.empty() ? 0 : map1.begin()->value.size());

	begin = std::max(begin, self->persistentDataDurableVersion + 1);
	auto it = std::lower_bound(deque.begin(),
	                           deque.end(),
	                           std::make_pair(begin, LengthPrefixedStringRef()),
	                           [](const auto& l, const auto& r) -> bool { return l.first < r.first; });

	Version currentVersion = -1;
	for (; it != deque.end(); ++it) {
		if (it->first != currentVersion) {
			if (messages.getLength() >= SERVER_KNOBS->DESIRED_TOTAL_BYTES) {
				endVersion = currentVersion + 1;
				//TraceEvent("TLogPeekMessagesReached2", self->dbgid);
				break;
			}

			currentVersion = it->first;
			messages << VERSION_HEADER << currentVersion;
		}

		// We need the 4 byte length prefix to be a TagsAndMessage format, but that prefix is added as part of StringRef
		// serialization.
		int offset = messages.getLength();
		messages << it->second.toStringRef();
		void* data = messages.getData();
		DEBUG_TAGS_AND_MESSAGE(
		    "TLogPeek", currentVersion, StringRef((uint8_t*)data + offset, messages.getLength() - offset), self->logId)
		    .detail("PeekTag", tag);
		versionCount++;
	}

	if (versionCount == 0) {
		++self->emptyPeeks;
	} else {
		++self->nonEmptyPeeks;
		auto [it, _] = self->peekVersionCounts.try_emplace(tag,
		                                                   "PeekVersionCounts " + tag.toString(),
		                                                   deterministicRandom()->randomUniqueID(),
		                                                   SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                   SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		LatencySample& sample = it->second;
		sample.addMeasurement(versionCount);
	}
}

															#line 8675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via parseMessagesForTag()
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class ParseMessagesForTagActor>
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ParseMessagesForTagActorState {
															#line 8682 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ParseMessagesForTagActorState(StringRef const& commitBlob,Tag const& tag,int const& logRouters) 
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : commitBlob(commitBlob),
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tag(tag),
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logRouters(logRouters),
															#line 1737 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   relevantMessages(),
															#line 1738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   rd(commitBlob, AssumeVersion(g_network->protocolVersion()))
															#line 8697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("parseMessagesForTag", reinterpret_cast<unsigned long>(this));

	}
	~ParseMessagesForTagActorState() 
	{
		fdb_probe_actor_destroy("parseMessagesForTag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 8712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ParseMessagesForTagActorState();
		static_cast<ParseMessagesForTagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<ParseMessagesForTagActor*>(this)->SAV<std::vector<StringRef>>::futures) { (void)(relevantMessages); this->~ParseMessagesForTagActorState(); static_cast<ParseMessagesForTagActor*>(this)->destroy(); return 0; }
															#line 8735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<ParseMessagesForTagActor*>(this)->SAV< std::vector<StringRef> >::value()) std::vector<StringRef>(std::move(relevantMessages)); // state_var_RVO
		this->~ParseMessagesForTagActorState();
		static_cast<ParseMessagesForTagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(!rd.empty()))
															#line 8754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1740 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TagsAndMessage tagsAndMessage;
															#line 1741 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		tagsAndMessage.loadFromArena(&rd, nullptr);
															#line 1742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( Tag t : tagsAndMessage.tags ) {
															#line 1743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (t == tag || (tag.locality == tagLocalityLogRouter && t.locality == tagLocalityLogRouter && t.id % logRouters == tag.id))
															#line 8766 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				relevantMessages.push_back(tagsAndMessage.getRawMessage());
															#line 8770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 1752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ParseMessagesForTagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ParseMessagesForTagActor*>(this)->actor_wait_state = 1;
															#line 1752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ParseMessagesForTagActor, 0, Void >*>(static_cast<ParseMessagesForTagActor*>(this)));
															#line 8783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ParseMessagesForTagActor*>(this)->actor_wait_state > 0) static_cast<ParseMessagesForTagActor*>(this)->actor_wait_state = 0;
		static_cast<ParseMessagesForTagActor*>(this)->ActorCallback< ParseMessagesForTagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParseMessagesForTagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ParseMessagesForTagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ParseMessagesForTagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParseMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseMessagesForTag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	StringRef commitBlob;
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Tag tag;
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int logRouters;
															#line 1737 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<StringRef> relevantMessages;
															#line 1738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	BinaryReader rd;
															#line 8898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via parseMessagesForTag()
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ParseMessagesForTagActor final : public Actor<std::vector<StringRef>>, public ActorCallback< ParseMessagesForTagActor, 0, Void >, public FastAllocated<ParseMessagesForTagActor>, public ParseMessagesForTagActorState<ParseMessagesForTagActor> {
															#line 8903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ParseMessagesForTagActor>::operator new;
	using FastAllocated<ParseMessagesForTagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3187364445297896960UL, 16350224487920035072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ParseMessagesForTagActor, 0, Void >;
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ParseMessagesForTagActor(StringRef const& commitBlob,Tag const& tag,int const& logRouters) 
															#line 8920 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<std::vector<StringRef>>(),
		   ParseMessagesForTagActorState<ParseMessagesForTagActor>(commitBlob, tag, logRouters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("parseMessagesForTag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4839197729461866496UL, 8337017776554396416UL);
		ActorExecutionContextHelper __helper(static_cast<ParseMessagesForTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("parseMessagesForTag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("parseMessagesForTag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ParseMessagesForTagActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<std::vector<StringRef>> parseMessagesForTag( StringRef const& commitBlob, Tag const& tag, int const& logRouters ) {
															#line 1735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<std::vector<StringRef>>(new ParseMessagesForTagActor(commitBlob, tag, logRouters));
															#line 8953 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 1756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

// Common logics to peek TLog and create TLogPeekReply that serves both streaming peek or normal peek request
															#line 8959 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogPeekMessages()
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <typename PromiseType, class TLogPeekMessagesActor>
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPeekMessagesActorState {
															#line 8966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekMessagesActorState(PromiseType const& replyPromise,TLogData* const& self,Reference<LogData> const& logData,Version const& reqBegin,Tag const& reqTag,bool const& reqReturnIfBlocked = false,bool const& reqOnlySpilled = false,Optional<std::pair<UID, int>> const& reqSequence = Optional<std::pair<UID, int>>(),Optional<Version> const& reqEnd = Optional<Version>(),Optional<bool> const& reqReturnEmptyIfStopped = Optional<bool>()) 
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : replyPromise(replyPromise),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   self(self),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqBegin(reqBegin),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqTag(reqTag),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqReturnIfBlocked(reqReturnIfBlocked),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqOnlySpilled(reqOnlySpilled),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqSequence(reqSequence),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqEnd(reqEnd),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   reqReturnEmptyIfStopped(reqReturnEmptyIfStopped),
															#line 1769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   messages(Unversioned()),
															#line 1770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   messages2(Unversioned()),
															#line 1771 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   sequence(-1),
															#line 1772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   peekId(),
															#line 1773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   queueStart(now())
															#line 9001 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogPeekMessages", reinterpret_cast<unsigned long>(this));

	}
	~TLogPeekMessagesActorState() 
	{
		fdb_probe_actor_destroy("tLogPeekMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (reqTag.locality == tagLocalityTxs && reqTag.id >= logData->txsTags && logData->txsTags > 0)
															#line 9016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1776 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				reqTag.id = reqTag.id % logData->txsTags;
															#line 9020 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (reqSequence.present())
															#line 9024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
				try {
															#line 1781 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					peekId = reqSequence.get().first;
															#line 1782 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					sequence = reqSequence.get().second;
															#line 1783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					auto [trackerIt, trackerInserted] = logData->peekTracker.try_emplace(peekId);
															#line 1784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (sequence >= SERVER_KNOBS->PARALLEL_GET_MORE_REQUESTS && trackerInserted)
															#line 9035 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						logData->peekTracker.erase(trackerIt);
															#line 1790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						return a_body1Catch2(operation_obsolete(), loopDepth);
															#line 9041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1792 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					auto& trackerData = trackerIt->second;
															#line 1793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (sequence == 0)
															#line 9047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						auto [seqIt, seqInserted] = trackerData.sequence_version.try_emplace(0);
															#line 1795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (seqInserted)
															#line 9053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							trackerData.tag = reqTag;
															#line 1797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							seqIt->second.send(std::make_pair(reqBegin, reqOnlySpilled));
															#line 9059 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
					}
															#line 1800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					auto seqBegin = trackerData.sequence_version.begin();
															#line 1802 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					for(;trackerData.sequence_version.size() && seqBegin->first <= sequence - SERVER_KNOBS->PARALLEL_GET_MORE_REQUESTS;) {
															#line 1804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (seqBegin->second.canBeSet())
															#line 9068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1805 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							seqBegin->second.sendError(operation_obsolete());
															#line 9072 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
															#line 1807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						trackerData.sequence_version.erase(seqBegin);
															#line 1808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						seqBegin = trackerData.sequence_version.begin();
															#line 9078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (trackerData.sequence_version.size() && sequence < seqBegin->first)
															#line 9082 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						return a_body1Catch2(operation_obsolete(), loopDepth);
															#line 9086 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					Future<std::pair<Version, bool>> fPrevPeekData = trackerData.sequence_version[sequence].getFuture();
															#line 1816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (fPrevPeekData.isReady())
															#line 9092 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						trackerData.unblockedPeeks++;
															#line 1818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						double t = now() - trackerData.lastUpdate;
															#line 1819 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (t > trackerData.idleMax)
															#line 9100 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1820 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							trackerData.idleMax = t;
															#line 9104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
															#line 1821 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						trackerData.idleTime += t;
															#line 9108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1823 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					trackerData.lastUpdate = now();
															#line 1824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					StrictFuture<std::pair<Version, bool>> __when_expr_0 = fPrevPeekData;
															#line 1824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 1;
															#line 1824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 0, std::pair<Version, bool> >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogPeekMessagesActorState();
		static_cast<TLogPeekMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		blockStart = now();
															#line 1850 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		replyWithRecoveryVersion = Optional<Version>();
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR_REPLY_RECOVERY || SERVER_KNOBS->ENABLE_VERSION_VECTOR);
															#line 1852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->version.get() < reqBegin)
															#line 9161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_REPLY_RECOVERY && SERVER_KNOBS->ENABLE_VERSION_VECTOR && logData->stopped() && reqEnd.present() && reqEnd.get() != std::numeric_limits<Version>::max() && reqReturnEmptyIfStopped.present() && reqReturnEmptyIfStopped.get())
															#line 9165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				ASSERT(SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST);
															#line 1857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				replyWithRecoveryVersion = reqEnd;
															#line 9171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (reqReturnIfBlocked)
															#line 9177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					replyPromise.sendError(end_of_stream());
															#line 1860 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (reqSequence.present())
															#line 9183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1861 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						auto& trackerData = logData->peekTracker[peekId];
															#line 1862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						auto& sequenceData = trackerData.sequence_version[sequence + 1];
															#line 1863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						trackerData.lastUpdate = now();
															#line 1864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (!sequenceData.isSet())
															#line 9193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						{
															#line 1865 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
							sequenceData.send(std::make_pair(reqBegin, reqOnlySpilled));
															#line 9197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						}
					}
															#line 1868 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 9202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~TLogPeekMessagesActorState();
					static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1872 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		DebugLogTraceEvent("TLogPeekMessages0", self->dbgid) .detail("LogId", logData->logId) .detail("Tag", reqTag.toString()) .detail("ReqBegin", reqBegin) .detail("Version", logData->version.get()) .detail("RecoveredAt", logData->recoveredAt) .detail("ClusterRecovery", replyWithRecoveryVersion.present() ? replyWithRecoveryVersion.get() : -1);
															#line 1880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!replyWithRecoveryVersion.present() && logData->version.get() < reqBegin)
															#line 9214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = logData->version.whenAtLeast(reqBegin);
															#line 1881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 3;
															#line 1881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 2, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9225 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont14(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (e.code() == error_code_timed_out || e.code() == error_code_operation_obsolete)
															#line 9246 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				replyPromise.sendError(e);
															#line 1831 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 9252 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TLogPeekMessagesActorState();
				static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(std::pair<Version, bool> const& prevPeekData,int loopDepth) 
	{
															#line 1825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reqBegin = std::max(prevPeekData.first, reqBegin);
															#line 1826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reqOnlySpilled = prevPeekData.second;
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 2;
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 1, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(std::pair<Version, bool> && prevPeekData,int loopDepth) 
	{
															#line 1825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reqBegin = std::max(prevPeekData.first, reqBegin);
															#line 1826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reqOnlySpilled = prevPeekData.second;
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9303 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 2;
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 1, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::pair<Version, bool> const& prevPeekData,int loopDepth) 
	{
		loopDepth = a_body1cont4(prevPeekData, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Version, bool> && prevPeekData,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(prevPeekData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 0, std::pair<Version, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 0, std::pair<Version, bool> >*,std::pair<Version, bool> const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 0, std::pair<Version, bool> >*,std::pair<Version, bool> && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 0, std::pair<Version, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 1884 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!logData->stopped() && reqTag.locality != tagLocalityTxs && reqTag != txsTag && logData->version.get() < logData->recoveryTxnVersion)
															#line 9492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1886 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			DebugLogTraceEvent("TLogPeekMessages1", self->dbgid) .detail("LogId", logData->logId) .detail("Tag", reqTag.toString()) .detail("ReqBegin", reqBegin) .detail("Version", logData->version.get()) .detail("RecoveryTxnVersion", logData->recoveryTxnVersion) .detail("RecoveredAt", logData->recoveredAt);
															#line 1897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_4 = logData->version.whenAtLeast(logData->recoveryTxnVersion) || logData->stoppedPromise.getFuture();
															#line 1897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont14when1(__when_expr_4.get(), loopDepth); };
			static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 5;
															#line 1897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 4, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont14cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont21(Void const& _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->TLOG_PEEK_DELAY, g_network->getCurrentTask());
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9521 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont21when1(__when_expr_3.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 4;
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 3, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9526 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont21(Void && _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->TLOG_PEEK_DELAY, g_network->getCurrentTask());
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont21when1(__when_expr_3.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 4;
															#line 1882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 3, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont21cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont21cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont21when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont21when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont21when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont21when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont14cont1(int loopDepth) 
	{
															#line 1900 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->locality != tagLocalitySatellite && reqTag.locality == tagLocalityLogRouter)
															#line 9713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = self->concurrentLogRouterReads.take();
															#line 1901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9719 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont14cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 6;
															#line 1901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 5, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont14cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont14cont3(int loopDepth) 
	{
															#line 1906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (reqBegin <= logData->persistentDataDurableVersion && reqTag.locality != tagLocalityTxs && reqTag != txsTag)
															#line 9825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(0, TaskPriority::TLogSpilledPeekReply);
															#line 1912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9831 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont14cont3when1(__when_expr_7.get(), loopDepth); };
			static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 8;
															#line 1912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 7, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9836 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont14cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont4(Void const& _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		globalReleaser = FlowLock::Releaser(self->concurrentLogRouterReads);
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0.0, TaskPriority::Low);
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont14cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 7;
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 6, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont4(Void && _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		globalReleaser = FlowLock::Releaser(self->concurrentLogRouterReads);
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0.0, TaskPriority::Low);
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9872 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont14cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 7;
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 6, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 9877 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont14cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont14cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont14cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont14cont6(int loopDepth) 
	{
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		workStart = now();
															#line 1916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		poppedVer = Version();
															#line 1917 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		endVersion = Version();
															#line 1918 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		onlySpilled = bool();
															#line 1922 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 10056 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont14cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont14cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont14cont8(int loopDepth) 
	{
															#line 2148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TLogPeekReply reply;
															#line 2149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.maxKnownVersion = logData->version.get();
															#line 2150 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.minKnownCommittedVersion = logData->minKnownCommittedVersion;
															#line 2151 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto messagesValue = messages.toValue();
															#line 2152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.arena.dependsOn(messagesValue.arena());
															#line 2153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.messages = messagesValue;
															#line 2154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.end = endVersion;
															#line 2155 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (replyWithRecoveryVersion.present())
															#line 10166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			reply.end = replyWithRecoveryVersion.get();
															#line 10170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.onlySpilled = onlySpilled;
															#line 2160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		DebugLogTraceEvent("TLogPeekMessages4", self->dbgid) .detail("LogId", logData->logId) .detail("Tag", reqTag.toString()) .detail("ReqBegin", reqBegin) .detail("EndVer", reply.end) .detail("MsgBytes", reply.messages.expectedSize());
															#line 2167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (reqSequence.present())
															#line 10178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto& trackerData = logData->peekTracker[peekId];
															#line 2169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.lastUpdate = now();
															#line 2171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			double queueT = blockStart - queueStart;
															#line 2172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			double blockT = workStart - blockStart;
															#line 2173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			double workT = now() - workStart;
															#line 2175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.totalPeeks++;
															#line 2176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.replyBytes += reply.messages.size();
															#line 2178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (queueT > trackerData.queueMax)
															#line 10196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				trackerData.queueMax = queueT;
															#line 10200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (blockT > trackerData.blockMax)
															#line 10204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				trackerData.blockMax = blockT;
															#line 10208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (workT > trackerData.workMax)
															#line 10212 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				trackerData.workMax = workT;
															#line 10216 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.queueTime += queueT;
															#line 2186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.blockTime += blockT;
															#line 2187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			trackerData.workTime += workT;
															#line 2189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto& sequenceData = trackerData.sequence_version[sequence + 1];
															#line 2190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (trackerData.sequence_version.size() && sequence + 1 < trackerData.sequence_version.begin()->first)
															#line 10228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2191 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				replyPromise.sendError(operation_obsolete());
															#line 2192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!sequenceData.isSet())
															#line 10234 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					sequenceData.sendError(operation_obsolete());
															#line 10238 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
															#line 2199 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TLogPeekMessagesActorState();
				static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (sequenceData.isSet())
															#line 10250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				trackerData.duplicatePeeks++;
															#line 2203 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sequenceData.getFuture().get().first != reply.end)
															#line 10256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					CODE_PROBE(true, "tlog peek second attempt ended at a different version (2)");
															#line 2205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					replyPromise.sendError(operation_obsolete());
															#line 2206 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~TLogPeekMessagesActorState();
					static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 2209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				sequenceData.send(std::make_pair(reply.end, reply.onlySpilled));
															#line 10275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			reply.begin = reqBegin;
															#line 10279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		replyPromise.send(reply);
															#line 2215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10285 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogPeekMessagesActorState();
		static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1(int loopDepth) 
	{
															#line 1923 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		poppedVer = poppedVersion(logData, reqTag);
															#line 1925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto tagData = logData->getTagData(reqTag);
															#line 1926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		bool tagRecovered = tagData && !tagData->unpoppedRecovered;
															#line 1927 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && poppedVer <= reqBegin && reqBegin > logData->persistentDataDurableVersion && !reqOnlySpilled && reqTag.locality >= 0 && !reqReturnIfBlocked && tagRecovered)
															#line 10310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			startTime = now();
															#line 1931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_8 = waitForMessagesForTag(logData, reqTag, reqBegin, SERVER_KNOBS->BLOCKING_PEEK_TIMEOUT);
															#line 1931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 9;
															#line 1931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 8, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10323 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont14cont6loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont1(int loopDepth) 
	{
															#line 1944 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		DebugLogTraceEvent("TLogPeekMessages2", self->dbgid) .detail("LogId", logData->logId) .detail("Tag", reqTag.toString()) .detail("ReqBegin", reqBegin) .detail("PoppedVer", poppedVer);
															#line 1949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (poppedVer > reqBegin)
															#line 10352 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 1950 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TLogPeekReply rep;
															#line 1951 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			rep.maxKnownVersion = logData->version.get();
															#line 1952 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			rep.minKnownCommittedVersion = logData->minKnownCommittedVersion;
															#line 1953 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			rep.popped = poppedVer;
															#line 1954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			rep.end = poppedVer;
															#line 1955 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			rep.onlySpilled = false;
															#line 1957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (reqSequence.present())
															#line 10368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 1958 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				auto [trackerIt, _] = logData->peekTracker.try_emplace(peekId);
															#line 1959 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				auto& trackerData = trackerIt->second;
															#line 1960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				auto [seqIt, seqInserted] = trackerData.sequence_version.try_emplace(sequence + 1);
															#line 1961 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				auto& sequenceData = seqIt->second;
															#line 1962 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				trackerData.lastUpdate = now();
															#line 1963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (trackerData.sequence_version.size() && sequence + 1 < trackerData.sequence_version.begin()->first)
															#line 10382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1964 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					replyPromise.sendError(operation_obsolete());
															#line 1965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!sequenceData.isSet())
															#line 10388 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						sequenceData.sendError(operation_obsolete());
															#line 10392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
															#line 1967 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~TLogPeekMessagesActorState();
					static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1969 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sequenceData.isSet())
															#line 10404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 1970 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (sequenceData.getFuture().get().first != rep.end)
															#line 10408 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 1971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						CODE_PROBE( true, "tlog peek second attempt ended at a different version", probe::decoration::rare);
															#line 1973 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						replyPromise.sendError(operation_obsolete());
															#line 1974 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
						new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~TLogPeekMessagesActorState();
						static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 1977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					sequenceData.send(std::make_pair(rep.end, rep.onlySpilled));
															#line 10427 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
															#line 1979 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				rep.begin = reqBegin;
															#line 10431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			replyPromise.send(rep);
															#line 1983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<TLogPeekMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekMessagesActorState(); static_cast<TLogPeekMessagesActor*>(this)->destroy(); return 0; }
															#line 10437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<TLogPeekMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TLogPeekMessagesActorState();
			static_cast<TLogPeekMessagesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(reqBegin >= poppedVersion(logData, reqTag));
															#line 1988 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		endVersion = logData->version.get() + 1;
															#line 1989 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		onlySpilled = false;
															#line 1992 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		DebugLogTraceEvent("TLogPeekMessages3", self->dbgid) .detail("ReqBegin", reqBegin) .detail("Tag", reqTag.toString());
															#line 1995 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (reqBegin <= logData->persistentDataDurableVersion)
															#line 10453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (reqOnlySpilled)
															#line 10457 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				endVersion = logData->persistentDataDurableVersion + 1;
															#line 10461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				peekMessagesFromMemory(logData, reqTag, reqBegin, messages2, endVersion);
															#line 10467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (logData->shouldSpillByValue(reqTag))
															#line 10471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<RangeResult> __when_expr_9 = self->persistentData->readRange( KeyRangeRef( persistTagMessagesKey(logData->logId, reqTag, reqBegin), persistTagMessagesKey(logData->logId, reqTag, logData->persistentDataDurableVersion + 1)), SERVER_KNOBS->DESIRED_TOTAL_BYTES, SERVER_KNOBS->DESIRED_TOTAL_BYTES);
															#line 2009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
				static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 10;
															#line 2009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 9, RangeResult >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10482 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<RangeResult> __when_expr_10 = self->persistentData->readRange( KeyRangeRef( persistTagMessageRefsKey(logData->logId, reqTag, reqBegin), persistTagMessageRefsKey(logData->logId, reqTag, logData->persistentDataDurableVersion + 1)), SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BATCHES_PER_PEEK + 1);
															#line 2030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10491 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont1when2(__when_expr_10.get(), loopDepth); };
				static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 11;
															#line 2030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 10, RangeResult >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
															#line 2118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (reqOnlySpilled)
															#line 10504 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2119 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				endVersion = logData->persistentDataDurableVersion + 1;
															#line 10508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				peekMessagesFromMemory(logData, reqTag, reqBegin, messages, endVersion);
															#line 10514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont14cont6loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		double latency = now() - startTime;
															#line 1933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto [it, inserted] = logData->blockingPeekLatencies.try_emplace(reqTag, "BlockingPeekLatencies-" + reqTag.toString(), nondeterministicRandom()->randomUniqueID(), SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL, SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
															#line 1939 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		LatencySample& sample = it->second;
															#line 1940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		sample.addMeasurement(latency);
															#line 1941 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		poppedVer = poppedVersion(logData, reqTag);
															#line 10533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		double latency = now() - startTime;
															#line 1933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto [it, inserted] = logData->blockingPeekLatencies.try_emplace(reqTag, "BlockingPeekLatencies-" + reqTag.toString(), nondeterministicRandom()->randomUniqueID(), SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL, SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
															#line 1939 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		LatencySample& sample = it->second;
															#line 1940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		sample.addMeasurement(latency);
															#line 1941 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		poppedVer = poppedVersion(logData, reqTag);
															#line 10550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont14cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont14cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont14cont6loopBody1cont4(int loopDepth) 
	{
															#line 2131 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (messages.getLength() > 0 || !SERVER_KNOBS->PEEK_BATCHING_EMPTY_MSG || (now() - blockStart > SERVER_KNOBS->PEEK_BATCHING_EMPTY_MSG_INTERVAL))
															#line 10634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont14cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		waitUntilVersion = logData->version.get() + 1;
															#line 2140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_14 = logData->version.whenAtLeast(waitUntilVersion) || delay(SERVER_KNOBS->PEEK_BATCHING_EMPTY_MSG_INTERVAL - (now() - blockStart));
															#line 2140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10644 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 15;
															#line 2140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 14, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont15(RangeResult const& kvs,int loopDepth) 
	{
															#line 2016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto& kv : kvs ) {
															#line 2017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto ver = decodeTagMessagesKey(kv.key);
															#line 2018 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages << VERSION_HEADER << ver;
															#line 2019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(kv.value);
															#line 10670 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (kvs.expectedSize() >= SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 10674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2023 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			endVersion = decodeTagMessagesKey(kvs.end()[-1].key) + 1;
															#line 2024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			onlySpilled = true;
															#line 10680 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(messages2.toValue());
															#line 10686 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont14cont6loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont15(RangeResult && kvs,int loopDepth) 
	{
															#line 2016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto& kv : kvs ) {
															#line 2017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto ver = decodeTagMessagesKey(kv.key);
															#line 2018 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages << VERSION_HEADER << ver;
															#line 2019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(kv.value);
															#line 10702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (kvs.expectedSize() >= SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 10706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2023 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			endVersion = decodeTagMessagesKey(kvs.end()[-1].key) + 1;
															#line 2024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			onlySpilled = true;
															#line 10712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(messages2.toValue());
															#line 10718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont14cont6loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont1when1(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont15(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont1when1(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont15(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 9, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 9, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont14cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 9, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont14cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 9, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont14cont6loopBody1cont16(RangeResult const& kvrefs,int loopDepth) 
	{
															#line 2038 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLocations = std::vector<std::pair<IDiskQueue::location, IDiskQueue::location>>();
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		earlyEnd = false;
															#line 2040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		uint32_t mutationBytes = 0;
															#line 2041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitBytes = 0;
															#line 2042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		firstVersion = std::numeric_limits<Version>::max();
															#line 2043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(int i = 0;i < kvrefs.size() && i < SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BATCHES_PER_PEEK;i++) {
															#line 2044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto& kv = kvrefs[i];
															#line 2045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			VectorRef<SpilledData> spilledData;
															#line 2046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			BinaryReader r(kv.value, AssumeVersion(logData->protocolVersion));
															#line 2047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			r >> spilledData;
															#line 2048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for( const SpilledData& sd : spilledData ) {
															#line 2049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (mutationBytes >= SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 10825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2050 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					earlyEnd = true;
															#line 10829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					break;
				}
															#line 2053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sd.version >= reqBegin)
															#line 10834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					firstVersion = std::min(firstVersion, sd.version);
															#line 2055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					const IDiskQueue::location end = sd.start.lo + sd.length;
															#line 2056 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					commitLocations.emplace_back(sd.start, end);
															#line 2059 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					commitBytes += sd.length;
															#line 2060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					mutationBytes += sd.mutationBytes;
															#line 10846 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
			}
															#line 2063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (earlyEnd)
															#line 10851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 2066 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		earlyEnd = earlyEnd || (kvrefs.size() >= SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BATCHES_PER_PEEK + 1);
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->peekMemoryLimiter.take(TaskPriority::TLogSpilledPeekReply, commitBytes);
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont16when1(__when_expr_11.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 12;
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 11, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10867 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16(RangeResult && kvrefs,int loopDepth) 
	{
															#line 2038 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLocations = std::vector<std::pair<IDiskQueue::location, IDiskQueue::location>>();
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		earlyEnd = false;
															#line 2040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		uint32_t mutationBytes = 0;
															#line 2041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitBytes = 0;
															#line 2042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		firstVersion = std::numeric_limits<Version>::max();
															#line 2043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(int i = 0;i < kvrefs.size() && i < SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BATCHES_PER_PEEK;i++) {
															#line 2044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			auto& kv = kvrefs[i];
															#line 2045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			VectorRef<SpilledData> spilledData;
															#line 2046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			BinaryReader r(kv.value, AssumeVersion(logData->protocolVersion));
															#line 2047 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			r >> spilledData;
															#line 2048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for( const SpilledData& sd : spilledData ) {
															#line 2049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (mutationBytes >= SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 10898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2050 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					earlyEnd = true;
															#line 10902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					break;
				}
															#line 2053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (sd.version >= reqBegin)
															#line 10907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					firstVersion = std::min(firstVersion, sd.version);
															#line 2055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					const IDiskQueue::location end = sd.start.lo + sd.length;
															#line 2056 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					commitLocations.emplace_back(sd.start, end);
															#line 2059 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					commitBytes += sd.length;
															#line 2060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					mutationBytes += sd.mutationBytes;
															#line 10919 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
			}
															#line 2063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (earlyEnd)
															#line 10924 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 2066 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		earlyEnd = earlyEnd || (kvrefs.size() >= SERVER_KNOBS->TLOG_SPILL_REFERENCE_MAX_BATCHES_PER_PEEK + 1);
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->peekMemoryLimiter.take(TaskPriority::TLogSpilledPeekReply, commitBytes);
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont16when1(__when_expr_11.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 12;
															#line 2067 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 11, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 10940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont1when2(RangeResult const& kvrefs,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16(kvrefs, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont1when2(RangeResult && kvrefs,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16(std::move(kvrefs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 10, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 10, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont14cont6loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 10, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont14cont6loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 10, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont14cont6loopBody1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 2068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		memoryReservation = FlowLock::Releaser(self->peekMemoryLimiter, commitBytes);
															#line 2069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messageReads = std::vector<Future<Standalone<StringRef>>>();
															#line 2070 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messageReads.reserve(commitLocations.size());
															#line 2071 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( const auto& pair : commitLocations ) {
															#line 2072 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messageReads.push_back(self->rawPersistentQueue->read(pair.first, pair.second, CheckHashes::True));
															#line 11032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2074 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLocations.clear();
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_12 = waitForAll(messageReads);
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont16cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 13;
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 12, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 11045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont1(Void && _,int loopDepth) 
	{
															#line 2068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		memoryReservation = FlowLock::Releaser(self->peekMemoryLimiter, commitBytes);
															#line 2069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messageReads = std::vector<Future<Standalone<StringRef>>>();
															#line 2070 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messageReads.reserve(commitLocations.size());
															#line 2071 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( const auto& pair : commitLocations ) {
															#line 2072 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messageReads.push_back(self->rawPersistentQueue->read(pair.first, pair.second, CheckHashes::True));
															#line 11062 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2074 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLocations.clear();
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_12 = waitForAll(messageReads);
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11070 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont6loopBody1cont16cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 13;
															#line 2075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 12, Void >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 11075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont14cont6loopBody1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont14cont6loopBody1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont14cont6loopBody1cont16cont7(Void const& _,int loopDepth) 
	{
															#line 2077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastRefMessageVersion = 0;
															#line 2078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		index = 0;
															#line 2079 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 11163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14cont6loopBody1cont16cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7(Void && _,int loopDepth) 
	{
															#line 2077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastRefMessageVersion = 0;
															#line 2078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		index = 0;
															#line 2079 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 11176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14cont6loopBody1cont16cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont14cont6loopBody1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont14cont6loopBody1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont14cont6loopBody1cont16cont9(int loopDepth) 
	{
															#line 2107 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messageReads.clear();
															#line 2108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		memoryReservation.release();
															#line 2110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (earlyEnd)
															#line 11264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			endVersion = lastRefMessageVersion + 1;
															#line 2112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			onlySpilled = true;
															#line 11270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(messages2.toValue());
															#line 11276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont14cont6loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont6loopBody1cont16cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopBody1(int loopDepth) 
	{
															#line 2080 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (index >= messageReads.size())
															#line 11293 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont14cont6loopBody1cont16cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2082 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Standalone<StringRef> queueEntryData = messageReads[index].get();
															#line 2083 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		uint8_t valid;
															#line 2084 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const uint32_t length = *(uint32_t*)queueEntryData.begin();
															#line 2085 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		queueEntryData = queueEntryData.substr(4, queueEntryData.size() - 4);
															#line 2086 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		BinaryReader rd(queueEntryData, IncludeVersion());
															#line 2087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		entry = TLogQueueEntry();
															#line 2088 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		rd >> entry >> valid;
															#line 2089 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(valid == 0x01);
															#line 2090 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(length + sizeof(valid) == queueEntryData.size());
															#line 2092 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		messages << VERSION_HEADER << entry.version;
															#line 2094 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<std::vector<StringRef>> __when_expr_13 = parseMessagesForTag(entry.messages, reqTag, logData->logRouterTags);
															#line 2094 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1cont14cont6loopBody1cont16cont7loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 14;
															#line 2094 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TLogPeekMessagesActor, 13, std::vector<StringRef> >*>(static_cast<TLogPeekMessagesActor*>(this)));
															#line 11326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont6loopBody1cont16cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopBody1cont1(std::vector<StringRef> const& rawMessages,int loopDepth) 
	{
															#line 2096 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( const StringRef& msg : rawMessages ) {
															#line 2097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(msg);
															#line 2098 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			DEBUG_TAGS_AND_MESSAGE("TLogPeekFromDisk", entry.version, msg, logData->logId) .detail("DebugID", self->dbgid) .detail("PeekTag", reqTag);
															#line 11352 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2103 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastRefMessageVersion = entry.version;
															#line 2104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		index++;
															#line 11358 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont14cont6loopBody1cont16cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopBody1cont1(std::vector<StringRef> && rawMessages,int loopDepth) 
	{
															#line 2096 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( const StringRef& msg : rawMessages ) {
															#line 2097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			messages.serializeBytes(msg);
															#line 2098 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			DEBUG_TAGS_AND_MESSAGE("TLogPeekFromDisk", entry.version, msg, logData->logId) .detail("DebugID", self->dbgid) .detail("PeekTag", reqTag);
															#line 11371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2103 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		lastRefMessageVersion = entry.version;
															#line 2104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		index++;
															#line 11377 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont14cont6loopBody1cont16cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopBody1when1(std::vector<StringRef> const& rawMessages,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont7loopBody1cont1(rawMessages, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont16cont7loopBody1when1(std::vector<StringRef> && rawMessages,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont16cont7loopBody1cont1(std::move(rawMessages), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 13, std::vector<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 13, std::vector<StringRef> >*,std::vector<StringRef> const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont14cont6loopBody1cont16cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 13, std::vector<StringRef> >*,std::vector<StringRef> && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont14cont6loopBody1cont16cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 13, std::vector<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont14cont6loopBody1cont20(Void const& _,int loopDepth) 
	{
															#line 2142 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->version.get() < waitUntilVersion)
															#line 11461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont14cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont14cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont20(Void && _,int loopDepth) 
	{
															#line 2142 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->version.get() < waitUntilVersion)
															#line 11473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont14cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont14cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont20(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6loopBody1cont20(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekMessagesActor*>(this)->ActorCallback< TLogPeekMessagesActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont14cont6loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TLogPeekMessagesActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont14cont6loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TLogPeekMessagesActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	PromiseType replyPromise;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version reqBegin;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Tag reqTag;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool reqReturnIfBlocked;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool reqOnlySpilled;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Optional<std::pair<UID, int>> reqSequence;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Optional<Version> reqEnd;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Optional<bool> reqReturnEmptyIfStopped;
															#line 1769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	BinaryWriter messages;
															#line 1770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	BinaryWriter messages2;
															#line 1771 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int sequence;
															#line 1772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	UID peekId;
															#line 1773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double queueStart;
															#line 1838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double blockStart;
															#line 1850 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Optional<Version> replyWithRecoveryVersion;
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	FlowLock::Releaser globalReleaser;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double workStart;
															#line 1916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version poppedVer;
															#line 1917 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version endVersion;
															#line 1918 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool onlySpilled;
															#line 1930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double startTime;
															#line 2038 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<std::pair<IDiskQueue::location, IDiskQueue::location>> commitLocations;
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool earlyEnd;
															#line 2041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	uint64_t commitBytes;
															#line 2042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version firstVersion;
															#line 2068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	FlowLock::Releaser memoryReservation;
															#line 2069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<Future<Standalone<StringRef>>> messageReads;
															#line 2077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version lastRefMessageVersion;
															#line 2078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	int index;
															#line 2087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogQueueEntry entry;
															#line 2136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version waitUntilVersion;
															#line 11622 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogPeekMessages()
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <typename PromiseType>
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPeekMessagesActor final : public Actor<Void>, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 0, std::pair<Version, bool> >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 1, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 2, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 3, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 4, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 5, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 6, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 7, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 8, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 9, RangeResult >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 10, RangeResult >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 11, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 12, Void >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 13, std::vector<StringRef> >, public ActorCallback< TLogPeekMessagesActor<PromiseType>, 14, Void >, public FastAllocated<TLogPeekMessagesActor<PromiseType>>, public TLogPeekMessagesActorState<PromiseType, TLogPeekMessagesActor<PromiseType>> {
															#line 11629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogPeekMessagesActor<PromiseType>>::operator new;
	using FastAllocated<TLogPeekMessagesActor<PromiseType>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10865688845724672UL, 10051656016725558528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 0, std::pair<Version, bool> >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 1, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 2, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 3, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 4, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 5, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 6, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 7, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 8, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 9, RangeResult >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 10, RangeResult >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 11, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 12, Void >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 13, std::vector<StringRef> >;
friend struct ActorCallback< TLogPeekMessagesActor<PromiseType>, 14, Void >;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekMessagesActor(PromiseType const& replyPromise,TLogData* const& self,Reference<LogData> const& logData,Version const& reqBegin,Tag const& reqTag,bool const& reqReturnIfBlocked = false,bool const& reqOnlySpilled = false,Optional<std::pair<UID, int>> const& reqSequence = Optional<std::pair<UID, int>>(),Optional<Version> const& reqEnd = Optional<Version>(),Optional<bool> const& reqReturnEmptyIfStopped = Optional<bool>()) 
															#line 11660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogPeekMessagesActorState<PromiseType, TLogPeekMessagesActor<PromiseType>>(replyPromise, self, logData, reqBegin, reqTag, reqReturnIfBlocked, reqOnlySpilled, reqSequence, reqEnd, reqReturnEmptyIfStopped),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogPeekMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15121293329905765888UL, 8355693002735882240UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogPeekMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogPeekMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 0, std::pair<Version, bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 9, RangeResult >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 10, RangeResult >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 13, std::vector<StringRef> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< TLogPeekMessagesActor<PromiseType>, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <typename PromiseType>
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogPeekMessages( PromiseType const& replyPromise, TLogData* const& self, Reference<LogData> const& logData, Version const& reqBegin, Tag const& reqTag, bool const& reqReturnIfBlocked = false, bool const& reqOnlySpilled = false, Optional<std::pair<UID, int>> const& reqSequence = Optional<std::pair<UID, int>>(), Optional<Version> const& reqEnd = Optional<Version>(), Optional<bool> const& reqReturnEmptyIfStopped = Optional<bool>() ) {
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogPeekMessagesActor<PromiseType>(replyPromise, self, logData, reqBegin, reqTag, reqReturnIfBlocked, reqOnlySpilled, reqSequence, reqEnd, reqReturnEmptyIfStopped));
															#line 11709 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2217 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

// This actor keep pushing TLogPeekStreamReply until it's removed from the cluster or should recover
															#line 11715 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogPeekStream()
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogPeekStreamActor>
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPeekStreamActorState {
															#line 11722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekStreamActorState(TLogData* const& self,TLogPeekStreamRequest const& req,Reference<LogData> const& logData) 
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   req(req),
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 11733 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogPeekStream", reinterpret_cast<unsigned long>(this));

	}
	~TLogPeekStreamActorState() 
	{
		fdb_probe_actor_destroy("tLogPeekStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->activePeekStreams++;
															#line 2222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			begin = req.begin;
															#line 2223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			onlySpilled = false;
															#line 2224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.setByteLimit(std::min(SERVER_KNOBS->MAXIMUM_PEEK_BYTES, req.limitBytes));
															#line 2225 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 11756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogPeekStreamActorState();
		static_cast<TLogPeekStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply = TLogPeekStreamReply();
															#line 2227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		promise = Promise<TLogPeekReply>();
															#line 2228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		future = Future<TLogPeekReply>(promise.getFuture());
															#line 11790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		try {
															#line 2230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = req.reply.onReady() && store(reply.rep, future) && tLogPeekMessages(promise, self, logData, begin, req.tag, req.returnIfBlocked, onlySpilled, Optional<std::pair<UID, int>>(), req.end, req.returnEmptyIfStopped);
															#line 2230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 1;
															#line 2230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogPeekStreamActor, 0, Void >*>(static_cast<TLogPeekStreamActor*>(this)));
															#line 11801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2252 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->activePeekStreams--;
															#line 2253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent(SevDebug, "TLogPeekStreamEnd", logData->logId) .errorUnsuppressed(e) .detail("Tag", req.tag) .detail("PeerAddr", req.reply.getEndpoint().getPrimaryAddress()) .detail("PeerAddress", req.reply.getEndpoint().getPrimaryAddress());
															#line 2259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (e.code() == error_code_end_of_stream || e.code() == error_code_operation_obsolete)
															#line 11827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				req.reply.sendError(e);
															#line 2261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<TLogPeekStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogPeekStreamActorState(); static_cast<TLogPeekStreamActor*>(this)->destroy(); return 0; }
															#line 11833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<TLogPeekStreamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TLogPeekStreamActorState();
				static_cast<TLogPeekStreamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 11843 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.rep.begin = begin;
															#line 2243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req.reply.send(reply);
															#line 2244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		begin = reply.rep.end;
															#line 2245 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		onlySpilled = reply.rep.onlySpilled;
															#line 2246 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (reply.rep.end > logData->version.get())
															#line 11866 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->TLOG_PEEK_DELAY, g_network->getCurrentTask());
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11872 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 2;
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogPeekStreamActor, 1, Void >*>(static_cast<TLogPeekStreamActor*>(this)));
															#line 11877 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(0, g_network->getCurrentTask());
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11886 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 3;
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogPeekStreamActor, 2, Void >*>(static_cast<TLogPeekStreamActor*>(this)));
															#line 11891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		reply.rep.begin = begin;
															#line 2243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req.reply.send(reply);
															#line 2244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		begin = reply.rep.end;
															#line 2245 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		onlySpilled = reply.rep.onlySpilled;
															#line 2246 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (reply.rep.end > logData->version.get())
															#line 11909 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->TLOG_PEEK_DELAY, g_network->getCurrentTask());
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 2;
															#line 2247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogPeekStreamActor, 1, Void >*>(static_cast<TLogPeekStreamActor*>(this)));
															#line 11920 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(0, g_network->getCurrentTask());
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11929 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 3;
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogPeekStreamActor, 2, Void >*>(static_cast<TLogPeekStreamActor*>(this)));
															#line 11934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekStreamActor*>(this)->ActorCallback< TLogPeekStreamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogPeekStreamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekStreamActor*>(this)->ActorCallback< TLogPeekStreamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogPeekStreamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TLogPeekStreamActor*>(this)->actor_wait_state > 0) static_cast<TLogPeekStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TLogPeekStreamActor*>(this)->ActorCallback< TLogPeekStreamActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TLogPeekStreamActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TLogPeekStreamActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekStreamRequest req;
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version begin;
															#line 2223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool onlySpilled;
															#line 2226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekStreamReply reply;
															#line 2227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Promise<TLogPeekReply> promise;
															#line 2228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Future<TLogPeekReply> future;
															#line 12224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogPeekStream()
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogPeekStreamActor final : public Actor<Void>, public ActorCallback< TLogPeekStreamActor, 0, Void >, public ActorCallback< TLogPeekStreamActor, 1, Void >, public ActorCallback< TLogPeekStreamActor, 2, Void >, public FastAllocated<TLogPeekStreamActor>, public TLogPeekStreamActorState<TLogPeekStreamActor> {
															#line 12229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogPeekStreamActor>::operator new;
	using FastAllocated<TLogPeekStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17434792748441403904UL, 12133702762212482304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogPeekStreamActor, 0, Void >;
friend struct ActorCallback< TLogPeekStreamActor, 1, Void >;
friend struct ActorCallback< TLogPeekStreamActor, 2, Void >;
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogPeekStreamActor(TLogData* const& self,TLogPeekStreamRequest const& req,Reference<LogData> const& logData) 
															#line 12248 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogPeekStreamActorState<TLogPeekStreamActor>(self, req, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogPeekStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17708243781319506432UL, 13506663737295720704UL);
		ActorExecutionContextHelper __helper(static_cast<TLogPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogPeekStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogPeekStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogPeekStreamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogPeekStreamActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TLogPeekStreamActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogPeekStream( TLogData* const& self, TLogPeekStreamRequest const& req, Reference<LogData> const& logData ) {
															#line 2219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogPeekStreamActor(self, req, logData));
															#line 12283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 12288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doQueueCommit()
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class DoQueueCommitActor>
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class DoQueueCommitActorState {
															#line 12295 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	DoQueueCommitActorState(TLogData* const& self,Reference<LogData> const& logData,std::vector<Reference<LogData>> const& missingFinalCommit) 
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   missingFinalCommit(missingFinalCommit),
															#line 2272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   ver(logData->version.get()),
															#line 2273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   commitNumber(self->queueCommitBegin + 1),
															#line 2274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   knownCommittedVersion(logData->knownCommittedVersion)
															#line 12312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doQueueCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoQueueCommitActorState() 
	{
		fdb_probe_actor_destroy("doQueueCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->queueCommitBegin = commitNumber;
															#line 2276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->queueCommittingVersion = ver;
															#line 2278 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			g_network->setCurrentTask(TaskPriority::TLogCommitReply);
															#line 2279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			Future<Void> c = self->persistentQueue->commit();
															#line 2280 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->diskQueueCommitBytes = 0;
															#line 2281 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->largeDiskQueueCommitBytes.set(false);
															#line 2283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ioDegradedOrTimeoutError( c, SERVER_KNOBS->MAX_STORAGE_COMMIT_TIME, self->degraded, SERVER_KNOBS->TLOG_DEGRADED_DURATION, "TLogCommit");
															#line 2283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 1;
															#line 2283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 0, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoQueueCommitActorState();
		static_cast<DoQueueCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2285 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001))
															#line 12369 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(6.0);
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12375 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 2;
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 1, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2285 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001))
															#line 12394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(6.0);
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12400 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 2;
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 1, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state > 0) static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoQueueCommitActor*>(this)->ActorCallback< DoQueueCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoQueueCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->queueCommitEnd.whenAtLeast(commitNumber - 1);
															#line 2288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 3;
															#line 2288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 2, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12501 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state > 0) static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoQueueCommitActor*>(this)->ActorCallback< DoQueueCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoQueueCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 12597 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0, g_network->getCurrentTask());
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12603 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 4;
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 3, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12608 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 12622 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0, g_network->getCurrentTask());
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12628 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 4;
															#line 2292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoQueueCommitActor, 3, Void >*>(static_cast<DoQueueCommitActor*>(this)));
															#line 12633 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state > 0) static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoQueueCommitActor*>(this)->ActorCallback< DoQueueCommitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoQueueCommitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2295 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(ver > logData->queueCommittedVersion.get());
															#line 2297 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->durableKnownCommittedVersion = knownCommittedVersion;
															#line 2298 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->unpoppedRecoveredTagCount == 0 && knownCommittedVersion >= logData->recoveredAt && logData->recoveryComplete.canBeSet())
															#line 12726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("TLogRecoveryComplete", logData->logId) .detail("Tags", logData->unpoppedRecoveredTagCount) .detail("DurableKCVer", logData->durableKnownCommittedVersion) .detail("RecoveredAt", logData->recoveredAt);
															#line 2304 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->recoveryComplete.send(Void());
															#line 12732 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->logSystem->get() && (!logData->isPrimary || logData->logRouterPoppedVersion < logData->logRouterPopToVersion))
															#line 12736 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->logRouterPoppedVersion = ver;
															#line 2311 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			DebugLogTraceEvent("LogPop", self->dbgid) .detail("Tag", logData->remoteTag.toString()) .detail("Version", knownCommittedVersion);
															#line 2314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->logSystem->get()->pop(ver, logData->remoteTag, knownCommittedVersion, logData->locality);
															#line 12744 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->queueCommittedVersion.set(ver);
															#line 2318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->queueCommitEnd.set(commitNumber);
															#line 2320 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto& it : missingFinalCommit ) {
															#line 2321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("TLogCommitMissingFinalCommit", self->dbgid) .detail("LogId", logData->logId) .detail("Version", it->version.get()) .detail("QueueVer", it->queueCommittedVersion.get());
															#line 2325 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			CODE_PROBE(true, "A TLog was replaced before having a chance to commit its queue", probe::decoration::rare);
															#line 2326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			it->queueCommittedVersion.set(it->version.get());
															#line 12758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2328 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<DoQueueCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoQueueCommitActorState(); static_cast<DoQueueCommitActor*>(this)->destroy(); return 0; }
															#line 12762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<DoQueueCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoQueueCommitActorState();
		static_cast<DoQueueCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoQueueCommitActor*>(this)->actor_wait_state > 0) static_cast<DoQueueCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoQueueCommitActor*>(this)->ActorCallback< DoQueueCommitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoQueueCommitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoQueueCommitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<Reference<LogData>> missingFinalCommit;
															#line 2272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version ver;
															#line 2273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version commitNumber;
															#line 2274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Version knownCommittedVersion;
															#line 12869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doQueueCommit()
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class DoQueueCommitActor final : public Actor<Void>, public ActorCallback< DoQueueCommitActor, 0, Void >, public ActorCallback< DoQueueCommitActor, 1, Void >, public ActorCallback< DoQueueCommitActor, 2, Void >, public ActorCallback< DoQueueCommitActor, 3, Void >, public FastAllocated<DoQueueCommitActor>, public DoQueueCommitActorState<DoQueueCommitActor> {
															#line 12874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoQueueCommitActor>::operator new;
	using FastAllocated<DoQueueCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15841981254061459712UL, 15129784605577588992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoQueueCommitActor, 0, Void >;
friend struct ActorCallback< DoQueueCommitActor, 1, Void >;
friend struct ActorCallback< DoQueueCommitActor, 2, Void >;
friend struct ActorCallback< DoQueueCommitActor, 3, Void >;
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	DoQueueCommitActor(TLogData* const& self,Reference<LogData> const& logData,std::vector<Reference<LogData>> const& missingFinalCommit) 
															#line 12894 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoQueueCommitActorState<DoQueueCommitActor>(self, logData, missingFinalCommit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doQueueCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17187421877276248576UL, 17832542488354917376UL);
		ActorExecutionContextHelper __helper(static_cast<DoQueueCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doQueueCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doQueueCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoQueueCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoQueueCommitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoQueueCommitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoQueueCommitActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> doQueueCommit( TLogData* const& self, Reference<LogData> const& logData, std::vector<Reference<LogData>> const& missingFinalCommit ) {
															#line 2269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new DoQueueCommitActor(self, logData, missingFinalCommit));
															#line 12930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 12935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitQueue()
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class CommitQueueActor>
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CommitQueueActorState {
															#line 12942 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CommitQueueActorState(TLogData* const& self) 
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2332 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(),
															#line 2333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   missingFinalCommit()
															#line 12953 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitQueue", reinterpret_cast<unsigned long>(this));

	}
	~CommitQueueActorState() 
	{
		fdb_probe_actor_destroy("commitQueue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2335 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 12968 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitQueueActorState();
		static_cast<CommitQueueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int foundCount = 0;
															#line 2337 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto it : self->id_data ) {
															#line 2338 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!it.second->stopped())
															#line 13002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				logData = it.second;
															#line 2340 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				foundCount++;
															#line 13008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (it.second->version.get() > std::max(it.second->queueCommittingVersion, it.second->queueCommittedVersion.get()))
															#line 13014 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				{
															#line 2343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					missingFinalCommit.push_back(it.second);
															#line 13018 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		ASSERT(foundCount < 2);
															#line 2348 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!foundCount)
															#line 13026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newLogData.onTrigger();
															#line 2349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CommitQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitQueueActor*>(this)->actor_wait_state = 1;
															#line 2349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 0, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 13037 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2353 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("CommitQueueNewLog", self->dbgid) .detail("LogId", logData->logId) .detail("Version", logData->version.get()) .detail("Committing", logData->queueCommittingVersion) .detail("Committed", logData->queueCommittedVersion.get());
															#line 2358 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->committingQueue.canBeSet())
															#line 13053 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2359 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->committingQueue.send(Void());
															#line 13057 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2362 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 13061 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state > 0) static_cast<CommitQueueActor*>(this)->actor_wait_state = 0;
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2365 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (BUGGIFY_WITH_PROB(0.0001) && !g_simulator->speedUpSimulation)
															#line 13170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 2366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CommitQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CommitQueueActor*>(this)->actor_wait_state = 2;
															#line 2366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 1, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 13181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2369 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->stopped() && logData->version.get() == std::max(logData->queueCommittingVersion, logData->queueCommittedVersion.get()))
															#line 13208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = logData->queueCommittedVersion.whenAtLeast(logData->version.get());
															#line 2371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CommitQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CommitQueueActor*>(this)->actor_wait_state = 3;
															#line 2371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 2, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 13219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state > 0) static_cast<CommitQueueActor*>(this)->actor_wait_state = 0;
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(int loopDepth) 
	{
															#line 2375 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 13320 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = logData->version.whenAtLeast( std::max(logData->queueCommittingVersion, logData->queueCommittedVersion.get()) + 1);
															#line 2379 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13328 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
															#line 2393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->newLogData.onTrigger();
															#line 13332 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont3when2(__when_expr_4.get(), loopDepth); };
		static_cast<CommitQueueActor*>(this)->actor_wait_state = 4;
															#line 2380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 3, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 2393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 4, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 13339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state > 0) static_cast<CommitQueueActor*>(this)->actor_wait_state = 0;
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
															#line 2382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 13441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont3when1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
															#line 2382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 13450 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont3when1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state > 0) static_cast<CommitQueueActor*>(this)->actor_wait_state = 0;
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 3, Void >::remove();
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 4, Void >::remove();

	}
	int a_body1loopBody1cont1loopBody1cont3when1cont1(int loopDepth) 
	{
															#line 2387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->queueCommittedVersion.get() == std::numeric_limits<Version>::max())
															#line 13478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->sharedActors.send(doQueueCommit(self, logData, missingFinalCommit));
															#line 2391 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		missingFinalCommit.clear();
															#line 13486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont3when1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopBody1(int loopDepth) 
	{
															#line 2382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(self->queueCommitBegin != self->queueCommitEnd.get() && !self->largeDiskQueueCommitBytes.get()))
															#line 13502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1loopBody1cont3when1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->queueCommitEnd.whenAtLeast(self->queueCommitBegin) || self->largeDiskQueueCommitBytes.onChange();
															#line 2384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 13510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont1loopBody1cont3when1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitQueueActor*>(this)->actor_wait_state = 5;
															#line 2384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitQueueActor, 5, Void >*>(static_cast<CommitQueueActor*>(this)));
															#line 13515 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont3when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont3when1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont3when1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3when1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3when1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CommitQueueActor*>(this)->actor_wait_state > 0) static_cast<CommitQueueActor*>(this)->actor_wait_state = 0;
		static_cast<CommitQueueActor*>(this)->ActorCallback< CommitQueueActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont3when1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont3when1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CommitQueueActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CommitQueueActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2332 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	std::vector<Reference<LogData>> missingFinalCommit;
															#line 13740 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitQueue()
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CommitQueueActor final : public Actor<Void>, public ActorCallback< CommitQueueActor, 0, Void >, public ActorCallback< CommitQueueActor, 1, Void >, public ActorCallback< CommitQueueActor, 2, Void >, public ActorCallback< CommitQueueActor, 3, Void >, public ActorCallback< CommitQueueActor, 5, Void >, public ActorCallback< CommitQueueActor, 4, Void >, public FastAllocated<CommitQueueActor>, public CommitQueueActorState<CommitQueueActor> {
															#line 13745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitQueueActor>::operator new;
	using FastAllocated<CommitQueueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(797295373188773888UL, 15066190387116073728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitQueueActor, 0, Void >;
friend struct ActorCallback< CommitQueueActor, 1, Void >;
friend struct ActorCallback< CommitQueueActor, 2, Void >;
friend struct ActorCallback< CommitQueueActor, 3, Void >;
friend struct ActorCallback< CommitQueueActor, 5, Void >;
friend struct ActorCallback< CommitQueueActor, 4, Void >;
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CommitQueueActor(TLogData* const& self) 
															#line 13767 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitQueueActorState<CommitQueueActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitQueue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1468126001889752320UL, 3183609537202577664UL);
		ActorExecutionContextHelper __helper(static_cast<CommitQueueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitQueue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitQueue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitQueueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitQueueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitQueueActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CommitQueueActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CommitQueueActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> commitQueue( TLogData* const& self ) {
															#line 2331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new CommitQueueActor(self));
															#line 13804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 13809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogCommit()
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogCommitActor>
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogCommitActorState {
															#line 13816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogCommitActorState(TLogData* const& self,TLogCommitRequest const& req,Reference<LogData> const& logData,PromiseStream<Void> const& warningCollectorInput) 
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   req(req),
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   warningCollectorInput(warningCollectorInput),
															#line 2403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   span("TLog:tLogCommit"_loc, req.spanContext),
															#line 2404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tlogDebugID()
															#line 13833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogCommit", reinterpret_cast<unsigned long>(this));

	}
	~TLogCommitActorState() 
	{
		fdb_probe_actor_destroy("tLogCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (req.debugID.present())
															#line 13848 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				tlogDebugID = nondeterministicRandom()->randomUniqueID();
															#line 2407 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				g_traceBatch.addAttach("CommitAttachID", req.debugID.get().first(), tlogDebugID.get().first());
															#line 2408 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", tlogDebugID.get().first(), "TLog.tLogCommit.BeforeWaitForVersion");
															#line 13856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->minKnownCommittedVersion = std::max(logData->minKnownCommittedVersion, req.minKnownCommittedVersion);
															#line 2413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = logData->version.whenAtLeast(req.prevVersion);
															#line 2413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogCommitActor*>(this)->actor_wait_state = 1;
															#line 2413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogCommitActor, 0, Void >*>(static_cast<TLogCommitActor*>(this)));
															#line 13869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogCommitActorState();
		static_cast<TLogCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		queueWaitEndTime = g_network->timer();
															#line 2416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->queueWaitLatencyDist->sampleSeconds(queueWaitEndTime - req.requestTime());
															#line 2419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 13896 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0, g_network->getCurrentTask());
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogCommitActor*>(this)->actor_wait_state = 2;
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogCommitActor, 1, Void >*>(static_cast<TLogCommitActor*>(this)));
															#line 13907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		queueWaitEndTime = g_network->timer();
															#line 2416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->queueWaitLatencyDist->sampleSeconds(queueWaitEndTime - req.requestTime());
															#line 2419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 13925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0, g_network->getCurrentTask());
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogCommitActor*>(this)->actor_wait_state = 2;
															#line 2420 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogCommitActor, 1, Void >*>(static_cast<TLogCommitActor*>(this)));
															#line 13936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state > 0) static_cast<TLogCommitActor*>(this)->actor_wait_state = 0;
		static_cast<TLogCommitActor*>(this)->ActorCallback< TLogCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		waitStartT = 0;
															#line 2424 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 14027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state > 0) static_cast<TLogCommitActor*>(this)->actor_wait_state = 0;
		static_cast<TLogCommitActor*>(this)->ActorCallback< TLogCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2435 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->stopped())
															#line 14123 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2436 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.sendError(tlog_stopped());
															#line 2437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<TLogCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogCommitActorState(); static_cast<TLogCommitActor*>(this)->destroy(); return 0; }
															#line 14129 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<TLogCommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TLogCommitActorState();
			static_cast<TLogCommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		isNotDuplicate = (logData->version.get() == req.prevVersion);
															#line 2442 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (isNotDuplicate)
															#line 14139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (req.debugID.present())
															#line 14143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", tlogDebugID.get().first(), "TLog.tLogCommit.Before");
															#line 14147 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2447 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			commitMessages(self, logData, req.version, req.arena, req.messages);
															#line 2449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->knownCommittedVersion = std::max(logData->knownCommittedVersion, req.knownCommittedVersion);
															#line 2451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TLogQueueEntryRef qe;
															#line 2453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			qe.version = req.version;
															#line 2454 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			qe.knownCommittedVersion = logData->knownCommittedVersion;
															#line 2455 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			qe.messages = req.messages;
															#line 2456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			qe.id = logData->logId;
															#line 2457 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->persistentQueue->push(qe, logData);
															#line 2459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->diskQueueCommitBytes += qe.expectedSize();
															#line 2460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->diskQueueCommitBytes > SERVER_KNOBS->MAX_QUEUE_COMMIT_BYTES)
															#line 14169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				self->largeDiskQueueCommitBytes.set(true);
															#line 14173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2464 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->version.set(req.version);
															#line 2465 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 14179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				logData->unknownCommittedVersions.emplace_front(req.version, req.seqPrevVersion, req.tLogLocIds);
															#line 2467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				for(;!logData->unknownCommittedVersions.empty() && logData->unknownCommittedVersions.back().version <= req.knownCommittedVersion;) {
															#line 2469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					logData->unknownCommittedVersions.pop_back();
															#line 14187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2472 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				ASSERT(req.prevVersion == req.seqPrevVersion);
															#line 14194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (req.debugID.present())
															#line 14198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", tlogDebugID.get().first(), "TLog.tLogCommit.AfterTLogCommit");
															#line 14202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 2479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		stopped = logData->stopCommit.onTrigger();
															#line 2480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeoutWarning(logData->queueCommittedVersion.whenAtLeast(req.version) || stopped, 0.1, warningCollectorInput);
															#line 2480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TLogCommitActor*>(this)->actor_wait_state = 4;
															#line 2480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TLogCommitActor, 3, Void >*>(static_cast<TLogCommitActor*>(this)));
															#line 14216 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 2424 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(self->bytesInput - self->bytesDurable >= SERVER_KNOBS->TLOG_HARD_LIMIT_BYTES && !logData->stopped()))
															#line 14232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2425 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (now() - waitStartT >= 1)
															#line 14238 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent(SevWarn, "TLogUpdateLag", logData->logId) .detail("Version", logData->version.get()) .detail("PersistentDataVersion", logData->persistentDataVersion) .detail("PersistentDataDurableVersion", logData->persistentDataDurableVersion);
															#line 2430 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			waitStartT = now();
															#line 14244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delayJittered(.005, TaskPriority::TLogCommit);
															#line 2432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TLogCommitActor*>(this)->actor_wait_state = 3;
															#line 2432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogCommitActor, 2, Void >*>(static_cast<TLogCommitActor*>(this)));
															#line 14255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state > 0) static_cast<TLogCommitActor*>(this)->actor_wait_state = 0;
		static_cast<TLogCommitActor*>(this)->ActorCallback< TLogCommitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TLogCommitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2484 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const double durableTime = g_network->timer();
															#line 2486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (stopped.isReady())
															#line 14366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2487 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(logData->stopped());
															#line 2488 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.sendError(tlog_stopped());
															#line 2489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<TLogCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogCommitActorState(); static_cast<TLogCommitActor*>(this)->destroy(); return 0; }
															#line 14374 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<TLogCommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TLogCommitActorState();
			static_cast<TLogCommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (req.debugID.present())
															#line 14382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2493 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", tlogDebugID.get().first(), "TLog.tLogCommit.After");
															#line 14386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2495 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req.reply.send(logData->durableKnownCommittedVersion);
															#line 2499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const double endTime = g_network->timer();
															#line 2501 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (isNotDuplicate)
															#line 14394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->timeUntilDurableDist->sampleSeconds(durableTime - queueWaitEndTime);
															#line 2503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->commitLatencyDist->sampleSeconds(endTime - req.requestTime());
															#line 14400 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogCommitActorState(); static_cast<TLogCommitActor*>(this)->destroy(); return 0; }
															#line 14404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogCommitActorState();
		static_cast<TLogCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2484 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const double durableTime = g_network->timer();
															#line 2486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (stopped.isReady())
															#line 14418 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2487 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(logData->stopped());
															#line 2488 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.sendError(tlog_stopped());
															#line 2489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<TLogCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogCommitActorState(); static_cast<TLogCommitActor*>(this)->destroy(); return 0; }
															#line 14426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<TLogCommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TLogCommitActorState();
			static_cast<TLogCommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (req.debugID.present())
															#line 14434 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2493 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", tlogDebugID.get().first(), "TLog.tLogCommit.After");
															#line 14438 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2495 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req.reply.send(logData->durableKnownCommittedVersion);
															#line 2499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		const double endTime = g_network->timer();
															#line 2501 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (isNotDuplicate)
															#line 14446 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->timeUntilDurableDist->sampleSeconds(durableTime - queueWaitEndTime);
															#line 2503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->commitLatencyDist->sampleSeconds(endTime - req.requestTime());
															#line 14452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogCommitActorState(); static_cast<TLogCommitActor*>(this)->destroy(); return 0; }
															#line 14456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogCommitActorState();
		static_cast<TLogCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TLogCommitActor*>(this)->actor_wait_state > 0) static_cast<TLogCommitActor*>(this)->actor_wait_state = 0;
		static_cast<TLogCommitActor*>(this)->ActorCallback< TLogCommitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TLogCommitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TLogCommitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogCommitRequest req;
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	PromiseStream<Void> warningCollectorInput;
															#line 2403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Span span;
															#line 2404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Optional<UID> tlogDebugID;
															#line 2415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double queueWaitEndTime;
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	double waitStartT;
															#line 2441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool isNotDuplicate;
															#line 2479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Future<Void> stopped;
															#line 14559 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogCommit()
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogCommitActor final : public Actor<Void>, public ActorCallback< TLogCommitActor, 0, Void >, public ActorCallback< TLogCommitActor, 1, Void >, public ActorCallback< TLogCommitActor, 2, Void >, public ActorCallback< TLogCommitActor, 3, Void >, public FastAllocated<TLogCommitActor>, public TLogCommitActorState<TLogCommitActor> {
															#line 14564 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogCommitActor>::operator new;
	using FastAllocated<TLogCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6279131954825554688UL, 18300453905933400064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogCommitActor, 0, Void >;
friend struct ActorCallback< TLogCommitActor, 1, Void >;
friend struct ActorCallback< TLogCommitActor, 2, Void >;
friend struct ActorCallback< TLogCommitActor, 3, Void >;
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogCommitActor(TLogData* const& self,TLogCommitRequest const& req,Reference<LogData> const& logData,PromiseStream<Void> const& warningCollectorInput) 
															#line 14584 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogCommitActorState<TLogCommitActor>(self, req, logData, warningCollectorInput),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4638155415330856192UL, 11969980916777817600UL);
		ActorExecutionContextHelper __helper(static_cast<TLogCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogCommitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TLogCommitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TLogCommitActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogCommit( TLogData* const& self, TLogCommitRequest const& req, Reference<LogData> const& logData, PromiseStream<Void> const& warningCollectorInput ) {
															#line 2399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogCommitActor(self, req, logData, warningCollectorInput));
															#line 14620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 14625 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initPersistentState()
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class InitPersistentStateActor>
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class InitPersistentStateActorState {
															#line 14632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	InitPersistentStateActorState(TLogData* const& self,Reference<LogData> const& logData) 
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 14641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initPersistentState", reinterpret_cast<unsigned long>(this));

	}
	~InitPersistentStateActorState() 
	{
		fdb_probe_actor_destroy("initPersistentState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->persistentDataCommitLock.take();
															#line 2510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<InitPersistentStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14658 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitPersistentStateActor*>(this)->actor_wait_state = 1;
															#line 2510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitPersistentStateActor, 0, Void >*>(static_cast<InitPersistentStateActor*>(this)));
															#line 14663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitPersistentStateActorState();
		static_cast<InitPersistentStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 2513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage = self->persistentData;
															#line 2514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistCurrentVersionKeys.begin), BinaryWriter::toValue(logData->version.get(), Unversioned())));
															#line 2517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef( BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistKnownCommittedVersionKeys.begin), BinaryWriter::toValue(logData->knownCommittedVersion, Unversioned())));
															#line 2520 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistLocalityKeys.begin), BinaryWriter::toValue(logData->locality, Unversioned())));
															#line 2522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistLogRouterTagsKeys.begin), BinaryWriter::toValue(logData->logRouterTags, Unversioned())));
															#line 2525 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistTxsTagsKeys.begin), BinaryWriter::toValue(logData->txsTags, Unversioned())));
															#line 2527 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistRecoveryCountKeys.begin), BinaryWriter::toValue(logData->recoveryCount, Unversioned())));
															#line 2530 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistProtocolVersionKeys.begin), BinaryWriter::toValue(logData->protocolVersion, Unversioned())));
															#line 2533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistTLogSpillTypeKeys.begin), BinaryWriter::toValue(logData->logSpillType, AssumeVersion(logData->protocolVersion))));
															#line 2537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto tag : logData->allTags ) {
															#line 2538 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(!logData->getTagData(tag));
															#line 2539 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->createTagData(tag, 0, true, true, true);
															#line 2540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			updatePersistentPopped(self, logData, logData->getTagData(tag));
															#line 14712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("TLogInitCommit", logData->logId);
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->persistentData->commit();
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<InitPersistentStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitPersistentStateActor*>(this)->actor_wait_state = 2;
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitPersistentStateActor, 1, Void >*>(static_cast<InitPersistentStateActor*>(this)));
															#line 14725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 2513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage = self->persistentData;
															#line 2514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistCurrentVersionKeys.begin), BinaryWriter::toValue(logData->version.get(), Unversioned())));
															#line 2517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef( BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistKnownCommittedVersionKeys.begin), BinaryWriter::toValue(logData->knownCommittedVersion, Unversioned())));
															#line 2520 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistLocalityKeys.begin), BinaryWriter::toValue(logData->locality, Unversioned())));
															#line 2522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistLogRouterTagsKeys.begin), BinaryWriter::toValue(logData->logRouterTags, Unversioned())));
															#line 2525 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set(KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistTxsTagsKeys.begin), BinaryWriter::toValue(logData->txsTags, Unversioned())));
															#line 2527 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistRecoveryCountKeys.begin), BinaryWriter::toValue(logData->recoveryCount, Unversioned())));
															#line 2530 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistProtocolVersionKeys.begin), BinaryWriter::toValue(logData->protocolVersion, Unversioned())));
															#line 2533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		storage->set( KeyValueRef(BinaryWriter::toValue(logData->logId, Unversioned()).withPrefix(persistTLogSpillTypeKeys.begin), BinaryWriter::toValue(logData->logSpillType, AssumeVersion(logData->protocolVersion))));
															#line 2537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto tag : logData->allTags ) {
															#line 2538 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(!logData->getTagData(tag));
															#line 2539 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logData->createTagData(tag, 0, true, true, true);
															#line 2540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			updatePersistentPopped(self, logData, logData->getTagData(tag));
															#line 14760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("TLogInitCommit", logData->logId);
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->persistentData->commit();
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<InitPersistentStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitPersistentStateActor*>(this)->actor_wait_state = 2;
															#line 2544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitPersistentStateActor, 1, Void >*>(static_cast<InitPersistentStateActor*>(this)));
															#line 14773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitPersistentStateActor*>(this)->actor_wait_state > 0) static_cast<InitPersistentStateActor*>(this)->actor_wait_state = 0;
		static_cast<InitPersistentStateActor*>(this)->ActorCallback< InitPersistentStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitPersistentStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitPersistentStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitPersistentStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<InitPersistentStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitPersistentStateActorState(); static_cast<InitPersistentStateActor*>(this)->destroy(); return 0; }
															#line 14857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<InitPersistentStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitPersistentStateActorState();
		static_cast<InitPersistentStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<InitPersistentStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitPersistentStateActorState(); static_cast<InitPersistentStateActor*>(this)->destroy(); return 0; }
															#line 14869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<InitPersistentStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitPersistentStateActorState();
		static_cast<InitPersistentStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitPersistentStateActor*>(this)->actor_wait_state > 0) static_cast<InitPersistentStateActor*>(this)->actor_wait_state = 0;
		static_cast<InitPersistentStateActor*>(this)->ActorCallback< InitPersistentStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitPersistentStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitPersistentStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitPersistentStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	FlowLock::Releaser commitLockReleaser;
															#line 2513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	IKeyValueStore* storage;
															#line 14960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initPersistentState()
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class InitPersistentStateActor final : public Actor<Void>, public ActorCallback< InitPersistentStateActor, 0, Void >, public ActorCallback< InitPersistentStateActor, 1, Void >, public FastAllocated<InitPersistentStateActor>, public InitPersistentStateActorState<InitPersistentStateActor> {
															#line 14965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitPersistentStateActor>::operator new;
	using FastAllocated<InitPersistentStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7091848841449362176UL, 14020590430082106112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitPersistentStateActor, 0, Void >;
friend struct ActorCallback< InitPersistentStateActor, 1, Void >;
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	InitPersistentStateActor(TLogData* const& self,Reference<LogData> const& logData) 
															#line 14983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InitPersistentStateActorState<InitPersistentStateActor>(self, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initPersistentState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14947371379546206976UL, 4091959633316567808UL);
		ActorExecutionContextHelper __helper(static_cast<InitPersistentStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initPersistentState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initPersistentState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitPersistentStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitPersistentStateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> initPersistentState( TLogData* const& self, Reference<LogData> const& logData ) {
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new InitPersistentStateActor(self, logData));
															#line 15017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 15022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getEncryptionAtRestMode()
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class GetEncryptionAtRestModeActor>
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class GetEncryptionAtRestModeActorState {
															#line 15029 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	GetEncryptionAtRestModeActorState(TLogData* const& self) 
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self)
															#line 15036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this));

	}
	~GetEncryptionAtRestModeActorState() 
	{
		fdb_probe_actor_destroy("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2549 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 15051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetEncryptionAtRestModeActorState();
		static_cast<GetEncryptionAtRestModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		req = GetEncryptionAtRestModeRequest(self->dbgid);
															#line 15081 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		try {
															#line 2553 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 2552 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<GetEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<GetEncryptionAtRestModeResponse> __when_expr_1 = brokenPromiseToNever( self->dbInfo->get().clusterInterface.getEncryptionAtRestMode.getReply(req));
															#line 15091 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<GetEncryptionAtRestModeActor*>(this)->actor_wait_state = 1;
															#line 2553 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetEncryptionAtRestModeActor, 0, Void >*>(static_cast<GetEncryptionAtRestModeActor*>(this)));
															#line 2554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >*>(static_cast<GetEncryptionAtRestModeActor*>(this)));
															#line 15098 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2561 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("GetEncryptionAtRestError", self->dbgid).error(e);
															#line 2562 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 15122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetEncryptionAtRestModeResponse const& resp,int loopDepth) 
	{
															#line 2556 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("GetEncryptionAtRestMode", self->dbgid).detail("Mode", resp.mode);
															#line 2557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<GetEncryptionAtRestModeActor*>(this)->SAV<EncryptionAtRestMode>::futures) { (void)((EncryptionAtRestMode::Mode)resp.mode); this->~GetEncryptionAtRestModeActorState(); static_cast<GetEncryptionAtRestModeActor*>(this)->destroy(); return 0; }
															#line 15156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<GetEncryptionAtRestModeActor*>(this)->SAV< EncryptionAtRestMode >::value()) EncryptionAtRestMode((EncryptionAtRestMode::Mode)resp.mode);
		this->~GetEncryptionAtRestModeActorState();
		static_cast<GetEncryptionAtRestModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetEncryptionAtRestModeResponse && resp,int loopDepth) 
	{
															#line 2556 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("GetEncryptionAtRestMode", self->dbgid).detail("Mode", resp.mode);
															#line 2557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<GetEncryptionAtRestModeActor*>(this)->SAV<EncryptionAtRestMode>::futures) { (void)((EncryptionAtRestMode::Mode)resp.mode); this->~GetEncryptionAtRestModeActorState(); static_cast<GetEncryptionAtRestModeActor*>(this)->destroy(); return 0; }
															#line 15170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<GetEncryptionAtRestModeActor*>(this)->SAV< EncryptionAtRestMode >::value()) EncryptionAtRestMode((EncryptionAtRestMode::Mode)resp.mode);
		this->~GetEncryptionAtRestModeActorState();
		static_cast<GetEncryptionAtRestModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetEncryptionAtRestModeActor*>(this)->actor_wait_state > 0) static_cast<GetEncryptionAtRestModeActor*>(this)->actor_wait_state = 0;
		static_cast<GetEncryptionAtRestModeActor*>(this)->ActorCallback< GetEncryptionAtRestModeActor, 0, Void >::remove();
		static_cast<GetEncryptionAtRestModeActor*>(this)->ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >::remove();

	}
	void a_callback_fire(ActorCallback< GetEncryptionAtRestModeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetEncryptionAtRestModeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetEncryptionAtRestModeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >*,GetEncryptionAtRestModeResponse const& value) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >*,GetEncryptionAtRestModeResponse && value) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >*,Error err) 
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	GetEncryptionAtRestModeRequest req;
															#line 15316 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getEncryptionAtRestMode()
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class GetEncryptionAtRestModeActor final : public Actor<EncryptionAtRestMode>, public ActorCallback< GetEncryptionAtRestModeActor, 0, Void >, public ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >, public FastAllocated<GetEncryptionAtRestModeActor>, public GetEncryptionAtRestModeActorState<GetEncryptionAtRestModeActor> {
															#line 15321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetEncryptionAtRestModeActor>::operator new;
	using FastAllocated<GetEncryptionAtRestModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8977547736780434432UL, 6474763434484395008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<EncryptionAtRestMode>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetEncryptionAtRestModeActor, 0, Void >;
friend struct ActorCallback< GetEncryptionAtRestModeActor, 1, GetEncryptionAtRestModeResponse >;
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	GetEncryptionAtRestModeActor(TLogData* const& self) 
															#line 15339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<EncryptionAtRestMode>(),
		   GetEncryptionAtRestModeActorState<GetEncryptionAtRestModeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9276277243716020480UL, 3601871372723632896UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getEncryptionAtRestMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetEncryptionAtRestModeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<EncryptionAtRestMode> getEncryptionAtRestMode( TLogData* const& self ) {
															#line 2548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<EncryptionAtRestMode>(new GetEncryptionAtRestModeActor(self));
															#line 15372 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2566 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

// send stopped promise instead of LogData* to avoid reference cycles
															#line 15378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rejoinClusterController()
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class RejoinClusterControllerActor>
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RejoinClusterControllerActorState {
															#line 15385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RejoinClusterControllerActorState(TLogData* const& self,TLogInterface const& tli,DBRecoveryCount const& recoveryCount,Promise<Void> const& stoppedPromise,Future<Void> const& registerWithCC,bool const& isPrimary) 
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tli(tli),
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   stoppedPromise(stoppedPromise),
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   registerWithCC(registerWithCC),
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   isPrimary(isPrimary),
															#line 2574 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   lastMasterLifetime()
															#line 15404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rejoinClusterController", reinterpret_cast<unsigned long>(this));

	}
	~RejoinClusterControllerActorState() 
	{
		fdb_probe_actor_destroy("rejoinClusterController", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2575 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 15419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinClusterControllerActorState();
		static_cast<RejoinClusterControllerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2576 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto const& inf = self->dbInfo->get();
															#line 2577 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		bool isDisplaced = std::find(inf.priorCommittedLogServers.begin(), inf.priorCommittedLogServers.end(), tli.id()) == inf.priorCommittedLogServers.end();
															#line 2580 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (isPrimary)
															#line 15453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2581 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			isDisplaced = isDisplaced && inf.recoveryCount >= recoveryCount && inf.recoveryState != RecoveryState::UNINITIALIZED;
															#line 15457 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2584 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			isDisplaced = isDisplaced && ((inf.recoveryCount > recoveryCount && inf.recoveryState != RecoveryState::UNINITIALIZED) || (inf.recoveryCount == recoveryCount && inf.recoveryState == RecoveryState::FULLY_RECOVERED));
															#line 15463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2588 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		isDisplaced = isDisplaced && !inf.logSystemConfig.hasTLog(tli.id());
															#line 2589 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (isDisplaced)
															#line 15469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2590 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("TLogDisplaced", tli.id()) .detail("Reason", "DBInfoDoesNotContain") .detail("RecoveryCount", recoveryCount) .detail("InfRecoveryCount", inf.recoveryCount) .detail("RecoveryState", (int)inf.recoveryState) .detail("LogSysConf", describe(inf.logSystemConfig.tLogs)) .detail("PriorLogs", describe(inf.priorCommittedLogServers)) .detail("OldLogGens", inf.logSystemConfig.oldTLogs.size());
															#line 2598 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (BUGGIFY)
															#line 15475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BUGGIFY_WORKER_REMOVED_MAX_LAG * deterministicRandom()->random01());
															#line 2599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 1;
															#line 2599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RejoinClusterControllerActor, 0, Void >*>(static_cast<RejoinClusterControllerActor*>(this)));
															#line 15486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont4(loopDepth);
			}
		}
		else
		{
															#line 2601 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (inf.recoveryCount > recoveryCount && stoppedPromise.canBeSet())
															#line 15498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2602 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				CODE_PROBE(true, "Stopping tlog because new dbinfo has a higher recovery count");
															#line 2603 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent("StoppingTLog", self->dbgid) .detail("LogId", tli.id()) .detail("NewRecoveryCount", inf.recoveryCount) .detail("MyRecoveryCount", recoveryCount);
															#line 2607 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				stoppedPromise.send(Void());
															#line 15506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2610 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->terminated.isSet())
															#line 15517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2611 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!static_cast<RejoinClusterControllerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RejoinClusterControllerActorState(); static_cast<RejoinClusterControllerActor*>(this)->destroy(); return 0; }
															#line 15521 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			new (&static_cast<RejoinClusterControllerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RejoinClusterControllerActorState();
			static_cast<RejoinClusterControllerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2614 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (registerWithCC.isReady())
															#line 15529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (!lastMasterLifetime.isEqual(self->dbInfo->get().masterLifetime))
															#line 15533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2618 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TLogRejoinRequest req(tli);
															#line 2619 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent("TLogRejoining", tli.id()) .detail("ClusterController", self->dbInfo->get().clusterInterface.id()) .detail("DbInfoMasterLifeTime", self->dbInfo->get().masterLifetime.toString()) .detail("LastMasterLifeTime", lastMasterLifetime.toString());
															#line 2624 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<TLogRejoinReply> __when_expr_1 = brokenPromiseToNever(self->dbInfo->get().clusterInterface.tlogRejoin.getReply(req));
															#line 2623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 2629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->dbInfo->onChange();
															#line 15547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 2;
															#line 2624 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >*>(static_cast<RejoinClusterControllerActor*>(this)));
															#line 2629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RejoinClusterControllerActor, 2, Void >*>(static_cast<RejoinClusterControllerActor*>(this)));
															#line 15554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_3 = self->dbInfo->onChange();
															#line 2632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15563 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
				static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 3;
															#line 2632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RejoinClusterControllerActor, 3, Void >*>(static_cast<RejoinClusterControllerActor*>(this)));
															#line 15568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
															#line 2635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_4 = registerWithCC || self->dbInfo->onChange();
															#line 2635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
			static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 4;
															#line 2635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RejoinClusterControllerActor, 4, Void >*>(static_cast<RejoinClusterControllerActor*>(this)));
															#line 15583 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 2600 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 15593 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state > 0) static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinClusterControllerActor*>(this)->ActorCallback< RejoinClusterControllerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RejoinClusterControllerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(TLogRejoinReply const& rep,int loopDepth) 
	{
															#line 2626 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (rep.masterIsRecovered)
															#line 15706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			lastMasterLifetime = self->dbInfo->get().masterLifetime;
															#line 15710 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(TLogRejoinReply && rep,int loopDepth) 
	{
															#line 2626 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (rep.masterIsRecovered)
															#line 15720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			lastMasterLifetime = self->dbInfo->get().masterLifetime;
															#line 15724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state > 0) static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinClusterControllerActor*>(this)->ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >::remove();
		static_cast<RejoinClusterControllerActor*>(this)->ActorCallback< RejoinClusterControllerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >*,TLogRejoinReply const& value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >*,TLogRejoinReply && value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RejoinClusterControllerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state > 0) static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinClusterControllerActor*>(this)->ActorCallback< RejoinClusterControllerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RejoinClusterControllerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state > 0) static_cast<RejoinClusterControllerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinClusterControllerActor*>(this)->ActorCallback< RejoinClusterControllerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RejoinClusterControllerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RejoinClusterControllerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogInterface tli;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	DBRecoveryCount recoveryCount;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Promise<Void> stoppedPromise;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Future<Void> registerWithCC;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool isPrimary;
															#line 2574 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	LifetimeToken lastMasterLifetime;
															#line 16051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rejoinClusterController()
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RejoinClusterControllerActor final : public Actor<Void>, public ActorCallback< RejoinClusterControllerActor, 0, Void >, public ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >, public ActorCallback< RejoinClusterControllerActor, 2, Void >, public ActorCallback< RejoinClusterControllerActor, 3, Void >, public ActorCallback< RejoinClusterControllerActor, 4, Void >, public FastAllocated<RejoinClusterControllerActor>, public RejoinClusterControllerActorState<RejoinClusterControllerActor> {
															#line 16056 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RejoinClusterControllerActor>::operator new;
	using FastAllocated<RejoinClusterControllerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13177989718022654464UL, 11136366061534706944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RejoinClusterControllerActor, 0, Void >;
friend struct ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >;
friend struct ActorCallback< RejoinClusterControllerActor, 2, Void >;
friend struct ActorCallback< RejoinClusterControllerActor, 3, Void >;
friend struct ActorCallback< RejoinClusterControllerActor, 4, Void >;
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RejoinClusterControllerActor(TLogData* const& self,TLogInterface const& tli,DBRecoveryCount const& recoveryCount,Promise<Void> const& stoppedPromise,Future<Void> const& registerWithCC,bool const& isPrimary) 
															#line 16077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RejoinClusterControllerActorState<RejoinClusterControllerActor>(self, tli, recoveryCount, stoppedPromise, registerWithCC, isPrimary),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinClusterController", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15788012666361529344UL, 10725245824343429120UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinClusterControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinClusterController");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinClusterController", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RejoinClusterControllerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RejoinClusterControllerActor, 1, TLogRejoinReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RejoinClusterControllerActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RejoinClusterControllerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> rejoinClusterController( TLogData* const& self, TLogInterface const& tli, DBRecoveryCount const& recoveryCount, Promise<Void> const& stoppedPromise, Future<Void> const& registerWithCC, bool const& isPrimary ) {
															#line 2568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new RejoinClusterControllerActor(self, tli, recoveryCount, stoppedPromise, registerWithCC, isPrimary));
															#line 16113 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2639 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 16118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via respondToRecovered()
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class RespondToRecoveredActor>
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RespondToRecoveredActorState {
															#line 16125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RespondToRecoveredActorState(TLogInterface const& tli,Promise<Void> const& recoveryComplete) 
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : tli(tli),
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   recoveryComplete(recoveryComplete),
															#line 2641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   finishedRecovery(true)
															#line 16136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("respondToRecovered", reinterpret_cast<unsigned long>(this));

	}
	~RespondToRecoveredActorState() 
	{
		fdb_probe_actor_destroy("respondToRecovered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = recoveryComplete.getFuture();
															#line 2643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 1;
															#line 2643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RespondToRecoveredActor, 0, Void >*>(static_cast<RespondToRecoveredActor*>(this)));
															#line 16159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RespondToRecoveredActorState();
		static_cast<RespondToRecoveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2653 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 16188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 16198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2648 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			finishedRecovery = false;
															#line 16206 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state > 0) static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<RespondToRecoveredActor*>(this)->ActorCallback< RespondToRecoveredActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RespondToRecoveredActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RespondToRecoveredActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RespondToRecoveredActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2658 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("TLogRespondToRecovered", tli.id()).detail("Finished", finishedRecovery);
															#line 2659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		;
															#line 16323 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2653 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!(g_network->isSimulated() && g_simulator->disableTLogRecoveryFinish))
															#line 16339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("WaitingToBeUnblocked", tli.id());
															#line 2655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(10);
															#line 2655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 2;
															#line 2655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RespondToRecoveredActor, 1, Void >*>(static_cast<RespondToRecoveredActor*>(this)));
															#line 16354 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state > 0) static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<RespondToRecoveredActor*>(this)->ActorCallback< RespondToRecoveredActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RespondToRecoveredActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RespondToRecoveredActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RespondToRecoveredActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_2 = tli.recoveryFinished.getFuture();
															#line 16470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<TLogRecoveryFinishedRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<TLogRecoveryFinishedRequest>>::value, "invalid type");
															#line 2660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.pop(), loopDepth); };
		static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 3;
															#line 2660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >*>(static_cast<RespondToRecoveredActor*>(this)));
															#line 16479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(TLogRecoveryFinishedRequest const& req,int loopDepth) 
	{
															#line 2661 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (finishedRecovery)
															#line 16488 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.send(Void());
															#line 16492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.send(Never());
															#line 16498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(TLogRecoveryFinishedRequest && req,int loopDepth) 
	{
															#line 2661 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (finishedRecovery)
															#line 16508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.send(Void());
															#line 16512 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.send(Never());
															#line 16518 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(TLogRecoveryFinishedRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(TLogRecoveryFinishedRequest && req,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RespondToRecoveredActor*>(this)->actor_wait_state > 0) static_cast<RespondToRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<RespondToRecoveredActor*>(this)->ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >*,TLogRecoveryFinishedRequest const& value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >*,TLogRecoveryFinishedRequest && value) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >*,Error err) 
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogInterface tli;
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Promise<Void> recoveryComplete;
															#line 2641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	bool finishedRecovery;
															#line 16605 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via respondToRecovered()
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RespondToRecoveredActor final : public Actor<Void>, public ActorCallback< RespondToRecoveredActor, 0, Void >, public ActorCallback< RespondToRecoveredActor, 1, Void >, public ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >, public FastAllocated<RespondToRecoveredActor>, public RespondToRecoveredActorState<RespondToRecoveredActor> {
															#line 16610 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RespondToRecoveredActor>::operator new;
	using FastAllocated<RespondToRecoveredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16631737083024662784UL, 13447554778646459136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RespondToRecoveredActor, 0, Void >;
friend struct ActorCallback< RespondToRecoveredActor, 1, Void >;
friend struct ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >;
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RespondToRecoveredActor(TLogInterface const& tli,Promise<Void> const& recoveryComplete) 
															#line 16629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RespondToRecoveredActorState<RespondToRecoveredActor>(tli, recoveryComplete),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("respondToRecovered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11360873923103108608UL, 13679922376016571904UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("respondToRecovered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("respondToRecovered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RespondToRecoveredActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RespondToRecoveredActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< RespondToRecoveredActor, 2, TLogRecoveryFinishedRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> respondToRecovered( TLogInterface const& tli, Promise<Void> const& recoveryComplete ) {
															#line 2640 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new RespondToRecoveredActor(tli, recoveryComplete));
															#line 16664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2668 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 16669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackRecoveryReq()
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TrackRecoveryReqActor>
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TrackRecoveryReqActorState {
															#line 16676 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TrackRecoveryReqActorState(TLogInterface const& tli,TrackTLogRecoveryRequest const& req,Reference<LogData> const& logData) 
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : tli(tli),
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   req(req),
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 16687 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackRecoveryReq", reinterpret_cast<unsigned long>(this));

	}
	~TrackRecoveryReqActorState() 
	{
		fdb_probe_actor_destroy("trackRecoveryReq", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2670 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 16702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackRecoveryReqActorState();
		static_cast<TrackRecoveryReqActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TrackRecoveryReqActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackRecoveryReqActorState(); static_cast<TrackRecoveryReqActor*>(this)->destroy(); return 0; }
															#line 16725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TrackRecoveryReqActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TrackRecoveryReqActorState();
		static_cast<TrackRecoveryReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		Version oldestGenerationRecoverAtVersion = invalidVersion;
															#line 2672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( const auto& [tag, genVersions] : logData->tagUnpoppedOldGenerations ) {
															#line 2673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			ASSERT(!genVersions.empty());
															#line 2674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (oldestGenerationRecoverAtVersion == invalidVersion)
															#line 16750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				oldestGenerationRecoverAtVersion = genVersions.back();
															#line 16754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2677 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				oldestGenerationRecoverAtVersion = std::min(genVersions.back(), oldestGenerationRecoverAtVersion);
															#line 16760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 2681 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (req.oldestGenRecoverAtVersion < oldestGenerationRecoverAtVersion)
															#line 16765 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2682 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("TLogRespondRecoveredVersion", tli.id()) .detail("KnownOldestGenRecoverAtVersion", req.oldestGenRecoverAtVersion) .detail("RecoveredVersion", oldestGenerationRecoverAtVersion);
															#line 2685 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			req.reply.send(TrackTLogRecoveryReply(oldestGenerationRecoverAtVersion));
															#line 16771 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2689 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = logData->updateGenerationRecovery.onTrigger();
															#line 2689 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<TrackRecoveryReqActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TrackRecoveryReqActor*>(this)->actor_wait_state = 1;
															#line 2689 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackRecoveryReqActor, 0, Void >*>(static_cast<TrackRecoveryReqActor*>(this)));
															#line 16783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackRecoveryReqActor*>(this)->actor_wait_state > 0) static_cast<TrackRecoveryReqActor*>(this)->actor_wait_state = 0;
		static_cast<TrackRecoveryReqActor*>(this)->ActorCallback< TrackRecoveryReqActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackRecoveryReqActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackRecoveryReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackRecoveryReqActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackRecoveryReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackRecoveryReqActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackRecoveryReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRecoveryReq", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogInterface tli;
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TrackTLogRecoveryRequest req;
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 16894 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackRecoveryReq()
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TrackRecoveryReqActor final : public Actor<Void>, public ActorCallback< TrackRecoveryReqActor, 0, Void >, public FastAllocated<TrackRecoveryReqActor>, public TrackRecoveryReqActorState<TrackRecoveryReqActor> {
															#line 16899 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackRecoveryReqActor>::operator new;
	using FastAllocated<TrackRecoveryReqActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2668448494915005440UL, 4916761500910796288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackRecoveryReqActor, 0, Void >;
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TrackRecoveryReqActor(TLogInterface const& tli,TrackTLogRecoveryRequest const& req,Reference<LogData> const& logData) 
															#line 16916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TrackRecoveryReqActorState<TrackRecoveryReqActor>(tli, req, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackRecoveryReq", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18152812005323145472UL, 3033754466634147840UL);
		ActorExecutionContextHelper __helper(static_cast<TrackRecoveryReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackRecoveryReq");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackRecoveryReq", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackRecoveryReqActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> trackRecoveryReq( TLogInterface const& tli, TrackTLogRecoveryRequest const& req, Reference<LogData> const& logData ) {
															#line 2669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TrackRecoveryReqActor(tli, req, logData));
															#line 16949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 16954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via respondToTrackRecovery()
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class RespondToTrackRecoveryActor>
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RespondToTrackRecoveryActorState {
															#line 16961 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RespondToTrackRecoveryActorState(TLogInterface const& tli,Reference<LogData> const& logData) 
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : tli(tli),
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 16970 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("respondToTrackRecovery", reinterpret_cast<unsigned long>(this));

	}
	~RespondToTrackRecoveryActorState() 
	{
		fdb_probe_actor_destroy("respondToTrackRecovery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2695 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 16985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RespondToTrackRecoveryActorState();
		static_cast<RespondToTrackRecoveryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_0 = tli.trackRecovery.getFuture();
															#line 17015 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TrackTLogRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TrackTLogRecoveryRequest>>::value, "invalid type");
															#line 2696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<RespondToTrackRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<RespondToTrackRecoveryActor*>(this)->actor_wait_state = 1;
															#line 2696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >*>(static_cast<RespondToTrackRecoveryActor*>(this)));
															#line 17024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TrackTLogRecoveryRequest const& req,int loopDepth) 
	{
															#line 2697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->addActor.send(trackRecoveryReq(tli, req, logData));
															#line 17033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TrackTLogRecoveryRequest && req,int loopDepth) 
	{
															#line 2697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		logData->addActor.send(trackRecoveryReq(tli, req, logData));
															#line 17042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TrackTLogRecoveryRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TrackTLogRecoveryRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RespondToTrackRecoveryActor*>(this)->actor_wait_state > 0) static_cast<RespondToTrackRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<RespondToTrackRecoveryActor*>(this)->ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >*,TrackTLogRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToTrackRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >*,TrackTLogRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToTrackRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToTrackRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogInterface tli;
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 17126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via respondToTrackRecovery()
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class RespondToTrackRecoveryActor final : public Actor<Void>, public ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >, public FastAllocated<RespondToTrackRecoveryActor>, public RespondToTrackRecoveryActorState<RespondToTrackRecoveryActor> {
															#line 17131 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RespondToTrackRecoveryActor>::operator new;
	using FastAllocated<RespondToTrackRecoveryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12948728805402360576UL, 12947366736907243776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >;
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	RespondToTrackRecoveryActor(TLogInterface const& tli,Reference<LogData> const& logData) 
															#line 17148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RespondToTrackRecoveryActorState<RespondToTrackRecoveryActor>(tli, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14031411195901234432UL, 2244251280574969856UL);
		ActorExecutionContextHelper __helper(static_cast<RespondToTrackRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("respondToTrackRecovery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("respondToTrackRecovery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RespondToTrackRecoveryActor, 0, TrackTLogRecoveryRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> respondToTrackRecovery( TLogInterface const& tli, Reference<LogData> const& logData ) {
															#line 2694 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new RespondToTrackRecoveryActor(tli, logData));
															#line 17181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 17186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cleanupPeekTrackers()
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class CleanupPeekTrackersActor>
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CleanupPeekTrackersActorState {
															#line 17193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CleanupPeekTrackersActorState(LogData* const& logData) 
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : logData(logData)
															#line 17200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this));

	}
	~CleanupPeekTrackersActorState() 
	{
		fdb_probe_actor_destroy("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 17215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupPeekTrackersActorState();
		static_cast<CleanupPeekTrackersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2703 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		double minTimeUntilExpiration = SERVER_KNOBS->PEEK_TRACKER_EXPIRATION_TIME;
															#line 2704 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto it = logData->peekTracker.begin();
															#line 2705 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for(;it != logData->peekTracker.end();) {
															#line 2706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			double timeUntilExpiration = it->second.lastUpdate + SERVER_KNOBS->PEEK_TRACKER_EXPIRATION_TIME - now();
															#line 2707 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (timeUntilExpiration < 1.0e-6)
															#line 17253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				for( auto seq : it->second.sequence_version ) {
															#line 2709 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
					if (!seq.second.isSet())
															#line 17259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					{
															#line 2710 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
						seq.second.sendError(timed_out());
															#line 17263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
					}
				}
															#line 2713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				it = logData->peekTracker.erase(it);
															#line 17268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2715 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				minTimeUntilExpiration = std::min(minTimeUntilExpiration, timeUntilExpiration);
															#line 2716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				++it;
															#line 17276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 2720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(minTimeUntilExpiration);
															#line 2720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<CleanupPeekTrackersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CleanupPeekTrackersActor*>(this)->actor_wait_state = 1;
															#line 2720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupPeekTrackersActor, 0, Void >*>(static_cast<CleanupPeekTrackersActor*>(this)));
															#line 17288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupPeekTrackersActor*>(this)->actor_wait_state > 0) static_cast<CleanupPeekTrackersActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupPeekTrackersActor*>(this)->ActorCallback< CleanupPeekTrackersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupPeekTrackersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupPeekTrackersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupPeekTrackersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	LogData* logData;
															#line 17382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cleanupPeekTrackers()
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CleanupPeekTrackersActor final : public Actor<Void>, public ActorCallback< CleanupPeekTrackersActor, 0, Void >, public FastAllocated<CleanupPeekTrackersActor>, public CleanupPeekTrackersActorState<CleanupPeekTrackersActor> {
															#line 17387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CleanupPeekTrackersActor>::operator new;
	using FastAllocated<CleanupPeekTrackersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7825837905713314816UL, 8542789585974022400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupPeekTrackersActor, 0, Void >;
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CleanupPeekTrackersActor(LogData* const& logData) 
															#line 17404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CleanupPeekTrackersActorState<CleanupPeekTrackersActor>(logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6154996212262413312UL, 16050162665397718016UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupPeekTrackers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupPeekTrackers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupPeekTrackersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> cleanupPeekTrackers( LogData* const& logData ) {
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new CleanupPeekTrackersActor(logData));
															#line 17437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2723 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 17442 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via logPeekTrackers()
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class LogPeekTrackersActor>
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class LogPeekTrackersActorState {
															#line 17449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	LogPeekTrackersActorState(LogData* const& logData) 
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : logData(logData)
															#line 17456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logPeekTrackers", reinterpret_cast<unsigned long>(this));

	}
	~LogPeekTrackersActorState() 
	{
		fdb_probe_actor_destroy("logPeekTrackers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 17471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogPeekTrackersActorState();
		static_cast<LogPeekTrackersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int64_t logThreshold = 1;
															#line 2727 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (logData->peekTracker.size() > SERVER_KNOBS->PEEK_LOGGING_AMOUNT)
															#line 17503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2728 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			std::vector<int64_t> peekCounts;
															#line 2729 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			peekCounts.reserve(logData->peekTracker.size());
															#line 2730 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			for( auto& it : logData->peekTracker ) {
															#line 2731 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				peekCounts.push_back(it.second.totalPeeks);
															#line 17513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
															#line 2733 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			size_t pivot = peekCounts.size() - SERVER_KNOBS->PEEK_LOGGING_AMOUNT;
															#line 2734 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			std::nth_element(peekCounts.begin(), peekCounts.begin() + pivot, peekCounts.end());
															#line 2735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			logThreshold = std::max<int64_t>(1, peekCounts[pivot]);
															#line 17521 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		}
															#line 2737 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		int logCount = 0;
															#line 2738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		for( auto& it : logData->peekTracker ) {
															#line 2739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (it.second.totalPeeks >= logThreshold)
															#line 17529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2740 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				logCount++;
															#line 2741 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent("PeekMetrics", logData->logId) .detail("Tag", it.second.tag.toString()) .detail("Elapsed", now() - it.second.lastLogged) .detail("MeanReplyBytes", it.second.replyBytes / it.second.totalPeeks) .detail("TotalPeeks", it.second.totalPeeks) .detail("UnblockedPeeks", it.second.unblockedPeeks) .detail("DuplicatePeeks", it.second.duplicatePeeks) .detail("Sequence", it.second.sequence_version.size() ? it.second.sequence_version.begin()->first : -1) .detail("IdleSeconds", it.second.idleTime) .detail("IdleMax", it.second.idleMax) .detail("QueueSeconds", it.second.queueTime) .detail("QueueMax", it.second.queueMax) .detail("BlockSeconds", it.second.blockTime) .detail("BlockMax", it.second.blockMax) .detail("WorkSeconds", it.second.workTime) .detail("WorkMax", it.second.workMax);
															#line 2758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				it.second.resetMetrics();
															#line 17537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
		}
															#line 2762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->PEEK_LOGGING_DELAY * std::max(1, logCount));
															#line 2762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<LogPeekTrackersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogPeekTrackersActor*>(this)->actor_wait_state = 1;
															#line 2762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogPeekTrackersActor, 0, Void >*>(static_cast<LogPeekTrackersActor*>(this)));
															#line 17549 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogPeekTrackersActor*>(this)->actor_wait_state > 0) static_cast<LogPeekTrackersActor*>(this)->actor_wait_state = 0;
		static_cast<LogPeekTrackersActor*>(this)->ActorCallback< LogPeekTrackersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogPeekTrackersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogPeekTrackersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogPeekTrackersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logPeekTrackers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	LogData* logData;
															#line 17643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logPeekTrackers()
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class LogPeekTrackersActor final : public Actor<Void>, public ActorCallback< LogPeekTrackersActor, 0, Void >, public FastAllocated<LogPeekTrackersActor>, public LogPeekTrackersActorState<LogPeekTrackersActor> {
															#line 17648 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogPeekTrackersActor>::operator new;
	using FastAllocated<LogPeekTrackersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12706662222111657472UL, 11517790986789220096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogPeekTrackersActor, 0, Void >;
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	LogPeekTrackersActor(LogData* const& logData) 
															#line 17665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogPeekTrackersActorState<LogPeekTrackersActor>(logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logPeekTrackers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7407995286248178176UL, 3859601965374418432UL);
		ActorExecutionContextHelper __helper(static_cast<LogPeekTrackersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logPeekTrackers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logPeekTrackers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogPeekTrackersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> logPeekTrackers( LogData* const& logData ) {
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new LogPeekTrackersActor(logData));
															#line 17698 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2765 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

void getQueuingMetrics(TLogData* self, Reference<LogData> logData, TLogQueuingMetricsRequest const& req) {
	TLogQueuingMetricsReply reply;
	reply.localTime = now();
	reply.instanceID = self->instanceID;
	reply.bytesInput = self->bytesInput;
	reply.bytesDurable = self->bytesDurable;
	reply.storageBytes = self->persistentData->getStorageBytes();
	// FIXME: Add the knownCommittedVersion to this message and change ratekeeper to use that version.
	reply.v = logData->durableKnownCommittedVersion;
	req.reply.send(reply);
}

															#line 17715 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tLogEnablePopReq()
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class TLogEnablePopReqActor>
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogEnablePopReqActorState {
															#line 17722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogEnablePopReqActorState(TLogEnablePopRequest const& enablePopReq,TLogData* const& self,Reference<LogData> const& logData) 
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : enablePopReq(enablePopReq),
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   self(self),
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData)
															#line 17733 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tLogEnablePopReq", reinterpret_cast<unsigned long>(this));

	}
	~TLogEnablePopReqActorState() 
	{
		fdb_probe_actor_destroy("tLogEnablePopReq", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->ignorePopUid != enablePopReq.snapUID.toString())
															#line 17748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2780 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent(SevWarn, "TLogPopDisableEnableUidMismatch") .detail("IgnorePopUid", self->ignorePopUid) .detail("UidStr", enablePopReq.snapUID.toString());
															#line 2783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				enablePopReq.reply.sendError(operation_failed());
															#line 2784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				if (!static_cast<TLogEnablePopReqActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogEnablePopReqActorState(); static_cast<TLogEnablePopReqActor*>(this)->destroy(); return 0; }
															#line 17756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
				new (&static_cast<TLogEnablePopReqActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TLogEnablePopReqActorState();
				static_cast<TLogEnablePopReqActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2786 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			TraceEvent("EnableTLogPlayAllIgnoredPops2", logData->logId) .detail("UidStr", enablePopReq.snapUID.toString()) .detail("IgnorePopUid", self->ignorePopUid) .detail("IgnorePopDeadline", self->ignorePopDeadline) .detail("PersistentDataVersion", logData->persistentDataVersion) .detail("PersistentDataDurableVersion", logData->persistentDataDurableVersion) .detail("QueueCommittedVersion", logData->queueCommittedVersion.get()) .detail("Version", logData->version.get());
															#line 2794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->ignorePopDeadline = 0;
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = processPopRequests(self, logData);
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<TLogEnablePopReqActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogEnablePopReqActor*>(this)->actor_wait_state = 1;
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogEnablePopReqActor, 0, Void >*>(static_cast<TLogEnablePopReqActor*>(this)));
															#line 17775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogEnablePopReqActorState();
		static_cast<TLogEnablePopReqActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		enablePopReq.reply.send(Void());
															#line 2797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogEnablePopReqActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogEnablePopReqActorState(); static_cast<TLogEnablePopReqActor*>(this)->destroy(); return 0; }
															#line 17800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogEnablePopReqActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogEnablePopReqActorState();
		static_cast<TLogEnablePopReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		enablePopReq.reply.send(Void());
															#line 2797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<TLogEnablePopReqActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogEnablePopReqActorState(); static_cast<TLogEnablePopReqActor*>(this)->destroy(); return 0; }
															#line 17814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<TLogEnablePopReqActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogEnablePopReqActorState();
		static_cast<TLogEnablePopReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogEnablePopReqActor*>(this)->actor_wait_state > 0) static_cast<TLogEnablePopReqActor*>(this)->actor_wait_state = 0;
		static_cast<TLogEnablePopReqActor*>(this)->ActorCallback< TLogEnablePopReqActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogEnablePopReqActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogEnablePopReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogEnablePopReqActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogEnablePopReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogEnablePopReqActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogEnablePopReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogEnablePopRequest enablePopReq;
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	Reference<LogData> logData;
															#line 17903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tLogEnablePopReq()
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class TLogEnablePopReqActor final : public Actor<Void>, public ActorCallback< TLogEnablePopReqActor, 0, Void >, public FastAllocated<TLogEnablePopReqActor>, public TLogEnablePopReqActorState<TLogEnablePopReqActor> {
															#line 17908 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TLogEnablePopReqActor>::operator new;
	using FastAllocated<TLogEnablePopReqActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15743211430251821312UL, 17518625699102024960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogEnablePopReqActor, 0, Void >;
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogEnablePopReqActor(TLogEnablePopRequest const& enablePopReq,TLogData* const& self,Reference<LogData> const& logData) 
															#line 17925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TLogEnablePopReqActorState<TLogEnablePopReqActor>(enablePopReq, self, logData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7681836689659528960UL, 14585940585039124992UL);
		ActorExecutionContextHelper __helper(static_cast<TLogEnablePopReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tLogEnablePopReq");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tLogEnablePopReq", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogEnablePopReqActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> tLogEnablePopReq( TLogEnablePopRequest const& enablePopReq, TLogData* const& self, Reference<LogData> const& logData ) {
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new TLogEnablePopReqActor(enablePopReq, self, logData));
															#line 17958 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2799 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 17963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkUpdateEncryptionAtRestMode()
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class CheckUpdateEncryptionAtRestModeActor>
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CheckUpdateEncryptionAtRestModeActorState {
															#line 17970 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CheckUpdateEncryptionAtRestModeActorState(TLogData* const& self) 
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self)
															#line 17977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this));

	}
	~CheckUpdateEncryptionAtRestModeActorState() 
	{
		fdb_probe_actor_destroy("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<EncryptionAtRestMode> __when_expr_0 = getEncryptionAtRestMode(self);
															#line 2801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17994 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 1;
															#line 2801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >*>(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)));
															#line 17999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckUpdateEncryptionAtRestModeActorState();
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EncryptionAtRestMode const& encryptionAtRestMode,int loopDepth) 
	{
															#line 2803 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->encryptionAtRestMode.present())
															#line 18022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2806 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->encryptionAtRestMode.get() != encryptionAtRestMode)
															#line 18026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent("EncryptionAtRestMismatch", self->dbgid) .detail("Expected", encryptionAtRestMode.toString()) .detail("Present", self->encryptionAtRestMode.get().toString());
															#line 2810 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				ASSERT(false);
															#line 18032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 2813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->encryptionAtRestMode = Optional<EncryptionAtRestMode>(encryptionAtRestMode);
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->persistentDataCommitLock.take();
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 2;
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*>(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)));
															#line 18049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(EncryptionAtRestMode && encryptionAtRestMode,int loopDepth) 
	{
															#line 2803 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (self->encryptionAtRestMode.present())
															#line 18059 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		{
															#line 2806 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (self->encryptionAtRestMode.get() != encryptionAtRestMode)
															#line 18063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			{
															#line 2807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				TraceEvent("EncryptionAtRestMismatch", self->dbgid) .detail("Expected", encryptionAtRestMode.toString()) .detail("Present", self->encryptionAtRestMode.get().toString());
															#line 2810 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
				ASSERT(false);
															#line 18069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 2813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			self->encryptionAtRestMode = Optional<EncryptionAtRestMode>(encryptionAtRestMode);
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->persistentDataCommitLock.take();
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18081 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 2;
															#line 2814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*>(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)));
															#line 18086 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode const& encryptionAtRestMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(encryptionAtRestMode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode && encryptionAtRestMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(encryptionAtRestMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state > 0) static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode const& value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode && value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >*,Error err) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2823 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (!static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckUpdateEncryptionAtRestModeActorState(); static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->destroy(); return 0; }
															#line 18171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		new (&static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckUpdateEncryptionAtRestModeActorState();
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 2816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->persistentData->set( KeyValueRef(persistEncryptionAtRestModeKey, self->encryptionAtRestMode.get().toValue()));
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->persistentData->commit();
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 3;
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*>(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)));
															#line 18194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		commitLockReleaser = FlowLock::Releaser(self->persistentDataCommitLock);
															#line 2816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		self->persistentData->set( KeyValueRef(persistEncryptionAtRestModeKey, self->encryptionAtRestMode.get().toValue()));
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->persistentData->commit();
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 3;
															#line 2818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*>(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)));
															#line 18214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state > 0) static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2819 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("PersistEncryptionAtRestMode", self->dbgid) .detail("Mode", self->encryptionAtRestMode.get().toString());
															#line 18298 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2819 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		TraceEvent("PersistEncryptionAtRestMode", self->dbgid) .detail("Mode", self->encryptionAtRestMode.get().toString());
															#line 18307 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state > 0) static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	TLogData* self;
															#line 2815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	FlowLock::Releaser commitLockReleaser;
															#line 18391 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkUpdateEncryptionAtRestMode()
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class CheckUpdateEncryptionAtRestModeActor final : public Actor<Void>, public ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >, public ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >, public ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >, public FastAllocated<CheckUpdateEncryptionAtRestModeActor>, public CheckUpdateEncryptionAtRestModeActorState<CheckUpdateEncryptionAtRestModeActor> {
															#line 18396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckUpdateEncryptionAtRestModeActor>::operator new;
	using FastAllocated<CheckUpdateEncryptionAtRestModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13036797843619989760UL, 3357413991096002816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >;
friend struct ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >;
friend struct ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >;
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	CheckUpdateEncryptionAtRestModeActor(TLogData* const& self) 
															#line 18415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckUpdateEncryptionAtRestModeActorState<CheckUpdateEncryptionAtRestModeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10199053209113371392UL, 10143801598784956672UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUpdateEncryptionAtRestModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkUpdateEncryptionAtRestMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkUpdateEncryptionAtRestMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckUpdateEncryptionAtRestModeActor, 0, EncryptionAtRestMode >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckUpdateEncryptionAtRestModeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckUpdateEncryptionAtRestModeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
[[nodiscard]] Future<Void> checkUpdateEncryptionAtRestMode( TLogData* const& self ) {
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	return Future<Void>(new CheckUpdateEncryptionAtRestModeActor(self));
															#line 18450 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
}

#line 2825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"

															#line 18455 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via serveTLogInterface()
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
template <class ServeTLogInterfaceActor>
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
class ServeTLogInterfaceActorState {
															#line 18462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
public:
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
	ServeTLogInterfaceActorState(TLogData* const& self,TLogInterface const& tli,Reference<LogData> const& logData,PromiseStream<Void> const& warningCollectorInput) 
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		 : self(self),
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   tli(tli),
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   logData(logData),
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   warningCollectorInput(warningCollectorInput),
															#line 2830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		   dbInfoChange(Void())
															#line 18477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serveTLogInterface", reinterpret_cast<unsigned long>(this));

	}
	~ServeTLogInterfaceActorState() 
	{
		fdb_probe_actor_destroy("serveTLogInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
			;
															#line 18492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeTLogInterfaceActorState();
		static_cast<ServeTLogInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbInfoChange;
															#line 2832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		if (static_cast<ServeTLogInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18524 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2861 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_1 = tli.peekStreamMessages.getFuture();
															#line 18528 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<TLogPeekStreamRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<TLogPeekStreamRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 2866 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_2 = tli.peekMessages.getFuture();
															#line 18533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<TLogPeekRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<TLogPeekRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 2878 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_3 = tli.popMessages.getFuture();
															#line 18538 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<TLogPopRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<TLogPopRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 2881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_4 = tli.commit.getFuture();
															#line 18543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<TLogCommitRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<TLogCommitRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 2890 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_5 = tli.lock.getFuture();
															#line 18548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ReplyPromise<TLogLockResult>>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ReplyPromise<TLogLockResult>>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
															#line 2893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/TLogServer.actor.cpp"
		auto __when_expr_6 = tli.getQueuingMetrics.getFuture();
															#line 18553 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/TLogServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<TLogQueuingMetricsRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<TLogQueuingMetricsRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.pop(), loopDepth); };
															#line 2896 "/codebuild/output/src3091928138/src/github.com/app