#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
/*
 * RestoreRoleCommon.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"

#include "fdbserver/RestoreUtil.h"
#include "fdbserver/RestoreRoleCommon.actor.h"
#include "fdbserver/RestoreLoader.actor.h"
#include "fdbserver/RestoreApplier.actor.h"
#include "fdbserver/RestoreController.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

class Database;
struct RestoreWorkerData;

// id is the id of the worker to be monitored
// This actor is used for both restore loader and restore applier
															#line 41 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleHeartbeat()
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class HandleHeartbeatActor>
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class HandleHeartbeatActorState {
															#line 48 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	HandleHeartbeatActorState(RestoreSimpleRequest const& req,UID const& id) 
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : req(req),
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   id(id)
															#line 57 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleHeartbeat", reinterpret_cast<unsigned long>(this));

	}
	~HandleHeartbeatActorState() 
	{
		fdb_probe_actor_destroy("handleHeartbeat", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(5.0);
															#line 40 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (static_cast<HandleHeartbeatActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleHeartbeatActor*>(this)->actor_wait_state = 1;
															#line 40 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleHeartbeatActor, 0, Void >*>(static_cast<HandleHeartbeatActor*>(this)));
															#line 79 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleHeartbeatActorState();
		static_cast<HandleHeartbeatActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		req.reply.send(RestoreCommonReply(id));
															#line 42 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (!static_cast<HandleHeartbeatActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleHeartbeatActorState(); static_cast<HandleHeartbeatActor*>(this)->destroy(); return 0; }
															#line 104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		new (&static_cast<HandleHeartbeatActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleHeartbeatActorState();
		static_cast<HandleHeartbeatActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		req.reply.send(RestoreCommonReply(id));
															#line 42 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (!static_cast<HandleHeartbeatActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleHeartbeatActorState(); static_cast<HandleHeartbeatActor*>(this)->destroy(); return 0; }
															#line 118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		new (&static_cast<HandleHeartbeatActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleHeartbeatActorState();
		static_cast<HandleHeartbeatActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleHeartbeatActor*>(this)->actor_wait_state > 0) static_cast<HandleHeartbeatActor*>(this)->actor_wait_state = 0;
		static_cast<HandleHeartbeatActor*>(this)->ActorCallback< HandleHeartbeatActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleHeartbeatActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleHeartbeatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleHeartbeatActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleHeartbeatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleHeartbeatActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleHeartbeatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleHeartbeat", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	RestoreSimpleRequest req;
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	UID id;
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleHeartbeat()
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class HandleHeartbeatActor final : public Actor<Void>, public ActorCallback< HandleHeartbeatActor, 0, Void >, public FastAllocated<HandleHeartbeatActor>, public HandleHeartbeatActorState<HandleHeartbeatActor> {
															#line 210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleHeartbeatActor>::operator new;
	using FastAllocated<HandleHeartbeatActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5110822608741997056UL, 10479255168823256576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleHeartbeatActor, 0, Void >;
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	HandleHeartbeatActor(RestoreSimpleRequest const& req,UID const& id) 
															#line 227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleHeartbeatActorState<HandleHeartbeatActor>(req, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleHeartbeat", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1219228828789025792UL, 1854644353329517056UL);
		ActorExecutionContextHelper __helper(static_cast<HandleHeartbeatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleHeartbeat");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleHeartbeat", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleHeartbeatActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> handleHeartbeat( RestoreSimpleRequest const& req, UID const& id ) {
															#line 39 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new HandleHeartbeatActor(req, id));
															#line 260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 44 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

void handleFinishRestoreRequest(const RestoreFinishRequest& req, Reference<RestoreRoleData> self) {
	self->resetPerRestoreRequest();
	TraceEvent("FastRestoreRolePhaseFinishRestoreRequest", self->id())
	    .detail("FinishRestoreRequest", req.terminate)
	    .detail("Role", getRoleStr(self->role));

	req.reply.send(RestoreCommonReply(self->id()));
}

// Multiple version batches may execute in parallel and init their version batches
															#line 275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleInitVersionBatchRequest()
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class HandleInitVersionBatchRequestActor>
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class HandleInitVersionBatchRequestActorState {
															#line 282 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	HandleInitVersionBatchRequestActorState(RestoreVersionBatchRequest const& req,Reference<RestoreRoleData> const& self) 
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : req(req),
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   self(self)
															#line 291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleInitVersionBatchRequestActorState() 
	{
		fdb_probe_actor_destroy("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			TraceEvent("FastRestoreRolePhaseInitVersionBatch", self->id()) .detail("BatchIndex", req.batchIndex) .detail("Role", getRoleStr(self->role)) .detail("VersionBatchNotifiedVersion", self->versionBatchId.get());
															#line 61 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			ASSERT(self->finishedBatch.get() < req.batchIndex);
															#line 64 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->versionBatchId.whenAtLeast(req.batchIndex - 1);
															#line 64 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (static_cast<HandleInitVersionBatchRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleInitVersionBatchRequestActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >*>(static_cast<HandleInitVersionBatchRequestActor*>(this)));
															#line 317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleInitVersionBatchRequestActorState();
		static_cast<HandleInitVersionBatchRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (self->versionBatchId.get() == req.batchIndex - 1)
															#line 340 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		{
															#line 67 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->initVersionBatch(req.batchIndex);
															#line 68 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->setVersionBatchState(req.batchIndex, ApplierVersionBatchState::INIT);
															#line 69 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			TraceEvent("FastRestoreInitVersionBatch") .detail("BatchIndex", req.batchIndex) .detail("Role", getRoleStr(self->role)) .detail("Node", self->id());
															#line 73 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->versionBatchId.set(req.batchIndex);
															#line 350 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		}
															#line 76 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id()));
															#line 77 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (!static_cast<HandleInitVersionBatchRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleInitVersionBatchRequestActorState(); static_cast<HandleInitVersionBatchRequestActor*>(this)->destroy(); return 0; }
															#line 356 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		new (&static_cast<HandleInitVersionBatchRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleInitVersionBatchRequestActorState();
		static_cast<HandleInitVersionBatchRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (self->versionBatchId.get() == req.batchIndex - 1)
															#line 368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		{
															#line 67 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->initVersionBatch(req.batchIndex);
															#line 68 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->setVersionBatchState(req.batchIndex, ApplierVersionBatchState::INIT);
															#line 69 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			TraceEvent("FastRestoreInitVersionBatch") .detail("BatchIndex", req.batchIndex) .detail("Role", getRoleStr(self->role)) .detail("Node", self->id());
															#line 73 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->versionBatchId.set(req.batchIndex);
															#line 378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		}
															#line 76 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id()));
															#line 77 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (!static_cast<HandleInitVersionBatchRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleInitVersionBatchRequestActorState(); static_cast<HandleInitVersionBatchRequestActor*>(this)->destroy(); return 0; }
															#line 384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		new (&static_cast<HandleInitVersionBatchRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleInitVersionBatchRequestActorState();
		static_cast<HandleInitVersionBatchRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleInitVersionBatchRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleInitVersionBatchRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleInitVersionBatchRequestActor*>(this)->ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleInitVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleInitVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleInitVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	RestoreVersionBatchRequest req;
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	Reference<RestoreRoleData> self;
															#line 471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleInitVersionBatchRequest()
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class HandleInitVersionBatchRequestActor final : public Actor<Void>, public ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >, public FastAllocated<HandleInitVersionBatchRequestActor>, public HandleInitVersionBatchRequestActorState<HandleInitVersionBatchRequestActor> {
															#line 476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleInitVersionBatchRequestActor>::operator new;
	using FastAllocated<HandleInitVersionBatchRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14170999746993814016UL, 4325725839856580864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >;
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	HandleInitVersionBatchRequestActor(RestoreVersionBatchRequest const& req,Reference<RestoreRoleData> const& self) 
															#line 493 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleInitVersionBatchRequestActorState<HandleInitVersionBatchRequestActor>(req, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2180265706645645824UL, 17599094059955815680UL);
		ActorExecutionContextHelper __helper(static_cast<HandleInitVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleInitVersionBatchRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleInitVersionBatchRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleInitVersionBatchRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> handleInitVersionBatchRequest( RestoreVersionBatchRequest const& req, Reference<RestoreRoleData> const& self ) {
															#line 55 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new HandleInitVersionBatchRequestActor(req, self));
															#line 526 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 79 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

void updateProcessStats(Reference<RestoreRoleData> self) {
	if (g_network->isSimulated()) {
		// memUsage and cpuUsage are not relevant in the simulator,
		// and relying on the actual values could break seed determinism
		if (deterministicRandom()->random01() < 0.2) { // not fully utilized cpu
			self->cpuUsage = deterministicRandom()->random01() * SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT;
		} else if (deterministicRandom()->random01() < 0.6) { // achieved target cpu but cpu is not busy
			self->cpuUsage = SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT +
			                 deterministicRandom()->random01() * (SERVER_KNOBS->FASTRESTORE_SCHED_MAX_CPU_PERCENT -
			                                                      SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT);
		} else { // reach desired max cpu usage; use max cpu as 200 to simulate incorrect cpu profiling
			self->cpuUsage =
			    SERVER_KNOBS->FASTRESTORE_SCHED_MAX_CPU_PERCENT +
			    deterministicRandom()->random01() * (200 - SERVER_KNOBS->FASTRESTORE_SCHED_MAX_CPU_PERCENT);
		}
		self->memory = 100.0;
		self->residentMemory = 100.0;
		return;
	}

	SystemStatistics sysStats = getSystemStatistics();
	if (sysStats.initialized) {
		self->cpuUsage = 100 * sysStats.processCPUSeconds / sysStats.elapsed;
		self->memory = sysStats.processMemory;
		self->residentMemory = sysStats.processResidentMemory;
	}
}

// An actor is schedulable to run if the current worker has enough resources, i.e.,
// the worker's memory usage is below the threshold;
// Exception: If the actor is working on the current version batch, we have to schedule
// the actor to run to avoid dead-lock.
// Future: When we release the actors that are blocked by memory usage, we should release them
// in increasing order of their version batch.
															#line 565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via isSchedulable()
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class IsSchedulableActor>
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class IsSchedulableActorState {
															#line 572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	IsSchedulableActorState(Reference<RestoreRoleData> const& self,int const& actorBatchIndex,std::string const& name) 
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : self(self),
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   actorBatchIndex(actorBatchIndex),
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   name(name)
															#line 583 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("isSchedulable", reinterpret_cast<unsigned long>(this));

	}
	~IsSchedulableActorState() 
	{
		fdb_probe_actor_destroy("isSchedulable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->delayedActors++;
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			memoryThresholdBytes = SERVER_KNOBS->FASTRESTORE_MEMORY_THRESHOLD_MB_SOFT * 1024 * 1024;
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			;
															#line 602 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsSchedulableActorState();
		static_cast<IsSchedulableActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (!static_cast<IsSchedulableActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IsSchedulableActorState(); static_cast<IsSchedulableActor*>(this)->destroy(); return 0; }
															#line 625 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		new (&static_cast<IsSchedulableActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IsSchedulableActorState();
		static_cast<IsSchedulableActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		double memory = getSystemStatistics().processMemory;
															#line 119 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (g_network->isSimulated() && BUGGIFY)
															#line 646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		{
															#line 122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (deterministicRandom()->random01() < 0.4)
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			{
															#line 123 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
				memory = SERVER_KNOBS->FASTRESTORE_MEMORY_THRESHOLD_MB_SOFT * deterministicRandom()->random01();
															#line 654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			}
			else
			{
															#line 125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
				memory = SERVER_KNOBS->FASTRESTORE_MEMORY_THRESHOLD_MB_SOFT + deterministicRandom()->random01() * SERVER_KNOBS->FASTRESTORE_MEMORY_THRESHOLD_MB_SOFT;
															#line 660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			}
		}
															#line 129 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (memory < memoryThresholdBytes || self->finishedBatch.get() + 1 == actorBatchIndex)
															#line 665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		{
															#line 130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (memory >= memoryThresholdBytes)
															#line 669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			{
															#line 131 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreMemoryUsageAboveThreshold", self->id()) .suppressFor(5.0) .detail("Role", getRoleStr(self->role)) .detail("BatchIndex", actorBatchIndex) .detail("FinishedBatch", self->finishedBatch.get()) .detail("Actor", name) .detail("Memory", memory);
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			}
															#line 139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			self->delayedActors--;
															#line 677 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 142 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreMemoryUsageAboveThresholdWait", self->id()) .suppressFor(5.0) .detail("Role", getRoleStr(self->role)) .detail("BatchIndex", actorBatchIndex) .detail("Actor", name) .detail("CurrentMemory", memory);
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_WAIT_FOR_MEMORY_LATENCY) || self->checkMemory.onTrigger();
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (static_cast<IsSchedulableActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsSchedulableActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsSchedulableActor, 0, Void >*>(static_cast<IsSchedulableActor*>(this)));
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsSchedulableActor*>(this)->actor_wait_state > 0) static_cast<IsSchedulableActor*>(this)->actor_wait_state = 0;
		static_cast<IsSchedulableActor*>(this)->ActorCallback< IsSchedulableActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IsSchedulableActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("isSchedulable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsSchedulableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSchedulable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsSchedulableActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("isSchedulable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsSchedulableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSchedulable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsSchedulableActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("isSchedulable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsSchedulableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSchedulable", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	Reference<RestoreRoleData> self;
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	int actorBatchIndex;
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	std::string name;
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	double memoryThresholdBytes;
															#line 813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via isSchedulable()
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class IsSchedulableActor final : public Actor<Void>, public ActorCallback< IsSchedulableActor, 0, Void >, public FastAllocated<IsSchedulableActor>, public IsSchedulableActorState<IsSchedulableActor> {
															#line 818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<IsSchedulableActor>::operator new;
	using FastAllocated<IsSchedulableActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1072517647197073664UL, 7133453721713720064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsSchedulableActor, 0, Void >;
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	IsSchedulableActor(Reference<RestoreRoleData> const& self,int const& actorBatchIndex,std::string const& name) 
															#line 835 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   IsSchedulableActorState<IsSchedulableActor>(self, actorBatchIndex, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isSchedulable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17336439903958232576UL, 14879548103097562368UL);
		ActorExecutionContextHelper __helper(static_cast<IsSchedulableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isSchedulable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isSchedulable", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsSchedulableActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> isSchedulable( Reference<RestoreRoleData> const& self, int const& actorBatchIndex, std::string const& name ) {
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new IsSchedulableActor(self, actorBatchIndex, name));
															#line 868 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

// Updated process metrics will be used by scheduler for throttling as well
															#line 874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateProcessMetrics()
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class UpdateProcessMetricsActor>
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class UpdateProcessMetricsActorState {
															#line 881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	UpdateProcessMetricsActorState(Reference<RestoreRoleData> const& self) 
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : self(self)
															#line 888 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateProcessMetrics", reinterpret_cast<unsigned long>(this));

	}
	~UpdateProcessMetricsActorState() 
	{
		fdb_probe_actor_destroy("updateProcessMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			;
															#line 903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateProcessMetricsActorState();
		static_cast<UpdateProcessMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		updateProcessStats(self);
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_UPDATE_PROCESS_STATS_INTERVAL);
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (static_cast<UpdateProcessMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateProcessMetricsActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateProcessMetricsActor, 0, Void >*>(static_cast<UpdateProcessMetricsActor*>(this)));
															#line 942 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateProcessMetricsActor*>(this)->actor_wait_state > 0) static_cast<UpdateProcessMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateProcessMetricsActor*>(this)->ActorCallback< UpdateProcessMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateProcessMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateProcessMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateProcessMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	Reference<RestoreRoleData> self;
															#line 1036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateProcessMetrics()
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class UpdateProcessMetricsActor final : public Actor<Void>, public ActorCallback< UpdateProcessMetricsActor, 0, Void >, public FastAllocated<UpdateProcessMetricsActor>, public UpdateProcessMetricsActorState<UpdateProcessMetricsActor> {
															#line 1041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateProcessMetricsActor>::operator new;
	using FastAllocated<UpdateProcessMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16973817517155787776UL, 14107816537724194816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateProcessMetricsActor, 0, Void >;
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	UpdateProcessMetricsActor(Reference<RestoreRoleData> const& self) 
															#line 1058 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateProcessMetricsActorState<UpdateProcessMetricsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateProcessMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13631998849507059968UL, 18341812359761123840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateProcessMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateProcessMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateProcessMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> updateProcessMetrics( Reference<RestoreRoleData> const& self ) {
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new UpdateProcessMetricsActor(self));
															#line 1091 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

															#line 1096 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via traceProcessMetrics()
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class TraceProcessMetricsActor>
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class TraceProcessMetricsActorState {
															#line 1103 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	TraceProcessMetricsActorState(Reference<RestoreRoleData> const& self,std::string const& role) 
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : self(self),
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   role(role)
															#line 1112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("traceProcessMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TraceProcessMetricsActorState() 
	{
		fdb_probe_actor_destroy("traceProcessMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			;
															#line 1127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceProcessMetricsActorState();
		static_cast<TraceProcessMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		TraceEvent("FastRestoreTraceProcessMetrics", self->nodeID) .detail("Role", role) .detail("PipelinedMaxVersionBatchIndex", self->versionBatchId.get()) .detail("FinishedVersionBatchIndex", self->finishedBatch.get()) .detail("CurrentVersionBatchPhase", self->getVersionBatchState(self->finishedBatch.get() + 1)) .detail("CpuUsage", self->cpuUsage) .detail("UsedMemory", self->memory) .detail("ResidentMemory", self->residentMemory);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_ROLE_LOGGING_DELAY);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (static_cast<TraceProcessMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceProcessMetricsActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceProcessMetricsActor, 0, Void >*>(static_cast<TraceProcessMetricsActor*>(this)));
															#line 1166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceProcessMetricsActor*>(this)->actor_wait_state > 0) static_cast<TraceProcessMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TraceProcessMetricsActor*>(this)->ActorCallback< TraceProcessMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceProcessMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceProcessMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceProcessMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceProcessMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	Reference<RestoreRoleData> self;
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	std::string role;
															#line 1262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via traceProcessMetrics()
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class TraceProcessMetricsActor final : public Actor<Void>, public ActorCallback< TraceProcessMetricsActor, 0, Void >, public FastAllocated<TraceProcessMetricsActor>, public TraceProcessMetricsActorState<TraceProcessMetricsActor> {
															#line 1267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<TraceProcessMetricsActor>::operator new;
	using FastAllocated<TraceProcessMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14986409086039505920UL, 13161270823523354880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceProcessMetricsActor, 0, Void >;
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	TraceProcessMetricsActor(Reference<RestoreRoleData> const& self,std::string const& role) 
															#line 1284 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TraceProcessMetricsActorState<TraceProcessMetricsActor>(self, role),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceProcessMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13553875956170538752UL, 16624057158262941184UL);
		ActorExecutionContextHelper __helper(static_cast<TraceProcessMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceProcessMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceProcessMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceProcessMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> traceProcessMetrics( Reference<RestoreRoleData> const& self, std::string const& role ) {
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new TraceProcessMetricsActor(self, role));
															#line 1317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

															#line 1322 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via traceRoleVersionBatchProgress()
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
template <class TraceRoleVersionBatchProgressActor>
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class TraceRoleVersionBatchProgressActorState {
															#line 1329 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	TraceRoleVersionBatchProgressActorState(Reference<RestoreRoleData> const& self,std::string const& role) 
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		 : self(self),
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		   role(role)
															#line 1338 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this));

	}
	~TraceRoleVersionBatchProgressActorState() 
	{
		fdb_probe_actor_destroy("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			;
															#line 1353 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRoleVersionBatchProgressActorState();
		static_cast<TraceRoleVersionBatchProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		int batchIndex = self->finishedBatch.get();
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		int maxBatchIndex = self->versionBatchId.get();
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		int maxPrintBatchIndex = batchIndex + SERVER_KNOBS->FASTRESTORE_VB_PARALLELISM;
															#line 183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		TraceEvent ev("FastRestoreVersionBatchProgressState", self->nodeID);
															#line 184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		ev.detail("Role", role) .detail("Node", self->nodeID) .detail("FinishedBatch", batchIndex) .detail("InitializedBatch", maxBatchIndex);
															#line 188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		for(;batchIndex <= maxBatchIndex;) {
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			if (batchIndex > maxPrintBatchIndex)
															#line 1395 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
			{
															#line 190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
				ev.detail("SkipVersionBatches", maxBatchIndex - batchIndex + 1);
															#line 1399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
				break;
			}
															#line 193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			std::stringstream typeName;
															#line 194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			typeName << "VersionBatch" << batchIndex;
															#line 195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			ev.detail(typeName.str(), self->getVersionBatchState(batchIndex));
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
			batchIndex++;
															#line 1410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		}
															#line 199 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_ROLE_LOGGING_DELAY);
															#line 199 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		if (static_cast<TraceRoleVersionBatchProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRoleVersionBatchProgressActor*>(this)->actor_wait_state = 1;
															#line 199 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >*>(static_cast<TraceRoleVersionBatchProgressActor*>(this)));
															#line 1421 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRoleVersionBatchProgressActor*>(this)->actor_wait_state > 0) static_cast<TraceRoleVersionBatchProgressActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRoleVersionBatchProgressActor*>(this)->ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleVersionBatchProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleVersionBatchProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleVersionBatchProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	Reference<RestoreRoleData> self;
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	std::string role;
															#line 1517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
};
// This generated class is to be used only via traceRoleVersionBatchProgress()
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
class TraceRoleVersionBatchProgressActor final : public Actor<Void>, public ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >, public FastAllocated<TraceRoleVersionBatchProgressActor>, public TraceRoleVersionBatchProgressActorState<TraceRoleVersionBatchProgressActor> {
															#line 1522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
public:
	using FastAllocated<TraceRoleVersionBatchProgressActor>::operator new;
	using FastAllocated<TraceRoleVersionBatchProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14861051300733689344UL, 18302543553876316672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >;
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	TraceRoleVersionBatchProgressActor(Reference<RestoreRoleData> const& self,std::string const& role) 
															#line 1539 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TraceRoleVersionBatchProgressActorState<TraceRoleVersionBatchProgressActor>(self, role),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3789461373070654464UL, 8872327679213157376UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleVersionBatchProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRoleVersionBatchProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRoleVersionBatchProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRoleVersionBatchProgressActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
[[nodiscard]] Future<Void> traceRoleVersionBatchProgress( Reference<RestoreRoleData> const& self, std::string const& role ) {
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"
	return Future<Void>(new TraceRoleVersionBatchProgressActor(self, role));
															#line 1572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreRoleCommon.actor.g.cpp.py_gen"
}

#line 202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/RestoreRoleCommon.actor.cpp"

//-------Helper functions
std::string getHexString(StringRef input) {
	std::stringstream ss;
	for (int i = 0; i < input.size(); i++) {
		if (i % 4 == 0)
			ss << " ";
		if (i == 12) { // The end of 12bytes, which is the version size for value
			ss << "|";
		}
		if (i == (12 + 12)) { // The end of version + header
			ss << "@";
		}
		ss << std::setfill('0') << std::setw(2) << std::hex
		   << (int)input[i]; // [] operator moves the pointer in step of unit8
	}
	return ss.str();
}
