/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class ArrayUtilTest {
    ArrayUtilTest() {
    }

    @Test
    void testJoinByteArrayListOfbyte() {
        byte[] byArray = new byte[]{97, 98, 99};
        byte[] byArray2 = new byte[]{100, 101, 102};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[0]);
        byte[] byArray3 = new byte[]{97, 98, 99, 122, 100, 101, 102, 122};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(byArray);
        arrayList.add(byArray2);
        byArray3 = new byte[]{122, 97, 98, 99, 122, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(byArray);
        arrayList.add(byArray2);
        byArray3 = new byte[]{122, 122, 97, 98, 99, 122, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(byArray);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(byArray2);
        byArray3 = new byte[]{97, 98, 99, 122, 122, 122, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[]{98});
        byArray3 = new byte[]{97, 98, 99, 122, 100, 101, 102, 122, 98};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        byArray3 = new byte[]{122, 122};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[])new byte[]{122}, arrayList));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        byArray3 = new byte[]{};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join(null, arrayList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testJoinByteArrayArray() {
        byte[] byArray = new byte[]{97, 98, 99};
        byte[] byArray2 = new byte[]{100, 101, 102};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[0]);
        byte[] byArray3 = new byte[]{97, 98, 99, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[][])((byte[][])arrayList.toArray((T[])new byte[0][]))));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(byArray);
        arrayList.add(byArray2);
        byArray3 = new byte[]{97, 98, 99, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[][])((byte[][])arrayList.toArray((T[])new byte[0][]))));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[]{98});
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        arrayList.add(new byte[0]);
        byArray3 = new byte[]{97, 98, 99, 100, 101, 102, 98};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[][])((byte[][])arrayList.toArray((T[])new byte[0][]))));
        arrayList = new ArrayList();
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[]{98});
        byArray3 = new byte[]{97, 98, 99, 100, 101, 102, 98};
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])ByteArrayUtil.join((byte[][])((byte[][])arrayList.toArray((T[])new byte[0][]))));
        arrayList = new ArrayList();
        arrayList.add(new byte[0]);
        arrayList.add(byArray);
        arrayList.add(byArray2);
        arrayList.add(new byte[0]);
        Assertions.assertArrayEquals((byte[])ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2}), (byte[])ByteArrayUtil.join((byte[][])((byte[][])arrayList.toArray((T[])new byte[0][]))));
        boolean bl = false;
        try {
            ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, null});
        }
        catch (Exception exception) {
            bl = true;
        }
        finally {
            Assertions.assertTrue((boolean)bl);
        }
    }

    @Test
    void testRegionEquals() {
        byte[] byArray = new byte[]{97, 12, -1, 110, 109, 122, 107};
        Assertions.assertTrue((boolean)ByteArrayUtil.regionEquals((byte[])byArray, (int)3, (byte[])new byte[]{110, 109}));
        Assertions.assertFalse((boolean)ByteArrayUtil.regionEquals((byte[])byArray, (int)2, (byte[])new byte[]{110, 109}));
        Assertions.assertTrue((boolean)ByteArrayUtil.regionEquals(null, (int)0, null));
        Assertions.assertFalse((boolean)ByteArrayUtil.regionEquals((byte[])byArray, (int)0, null));
    }

    @Test
    void testReplace() {
        byte[] byArray = new byte[]{97, 98, 99};
        byte[] byArray2 = new byte[]{100, 101, 102};
        byte[] byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2});
        byte[] byArray4 = new byte[]{122, 100, 101, 102, 122, 100, 101, 102};
        Assertions.assertArrayEquals((byte[])byArray4, (byte[])ByteArrayUtil.replace((byte[])byArray3, (byte[])byArray, (byte[])new byte[]{122}));
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2});
        Assertions.assertArrayEquals((byte[])ByteArrayUtil.join((byte[][])new byte[][]{byArray2, byArray2}), (byte[])ByteArrayUtil.replace((byte[])byArray3, (byte[])byArray, (byte[])new byte[0]));
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2});
        Assertions.assertArrayEquals((byte[])ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray}), (byte[])ByteArrayUtil.replace((byte[])byArray3, (byte[])byArray2, (byte[])new byte[0]));
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray, byArray});
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])ByteArrayUtil.replace((byte[])byArray3, (byte[])byArray, (byte[])new byte[0]));
    }

    @Test
    void testSplit() {
        Object object2;
        byte[] byArray = new byte[]{97, 98, 99};
        byte[] byArray2 = new byte[]{100, 101, 102};
        byte[] byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2, byArray});
        List list = ByteArrayUtil.split((byte[])byArray3, (byte[])byArray2);
        Assertions.assertEquals((int)list.size(), (int)3);
        for (Object object2 : list) {
            Assertions.assertArrayEquals((byte[])byArray, (byte[])object2);
        }
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray2, byArray, byArray2, byArray, byArray2, byArray});
        list = ByteArrayUtil.split((byte[])byArray3, (byte[])byArray2);
        Assertions.assertEquals((int)list.size(), (int)4);
        int n = 0;
        object2 = list.iterator();
        while (object2.hasNext()) {
            byte[] byArray4 = (byte[])object2.next();
            if (n++ == 0) {
                Assertions.assertArrayEquals((byte[])new byte[0], (byte[])byArray4);
                continue;
            }
            Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray4);
        }
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2, byArray, byArray2});
        list = ByteArrayUtil.split((byte[])byArray3, (byte[])byArray2);
        Assertions.assertEquals((int)list.size(), (int)4);
        n = 0;
        for (byte[] byArray4 : list) {
            if (n++ < 3) {
                Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray4);
                continue;
            }
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])byArray4);
        }
        byArray3 = ByteArrayUtil.join((byte[][])new byte[][]{byArray, byArray2, byArray, byArray2, byArray, byArray2, byArray2, byArray2});
        list = ByteArrayUtil.split((byte[])byArray3, (byte[])byArray2);
        Assertions.assertEquals((int)list.size(), (int)6);
        n = 0;
        for (byte[] byArray4 : list) {
            if (n++ < 3) {
                Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray4);
                continue;
            }
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])byArray4);
        }
    }

    @Test
    @Disabled(value="not implemented")
    void testBisectLeft() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testCompare() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testFindNext() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testFindTerminator() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testCopyOfRange() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testStrinc() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    @Disabled(value="not implemented")
    void testPrintable() {
        Assertions.fail((String)"Not yet implemented");
    }

    @Test
    void cannotReplaceNullBytes() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> ByteArrayUtil.replace(null, (int)0, (int)1, (byte[])new byte[]{0}, (byte[])new byte[]{0, -1}));
    }

    @Test
    void cannotReplaceWithNegativeOffset() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArrayUtil.replace((byte[])new byte[]{0, 1}, (int)-1, (int)2, (byte[])new byte[]{0}, (byte[])new byte[]{0, -1}));
    }

    @Test
    void cannotReplaceWithNegativeLength() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArrayUtil.replace((byte[])new byte[]{0, 1}, (int)1, (int)-1, (byte[])new byte[]{0}, (byte[])new byte[]{0, -1}));
    }

    @Test
    void cannotReplaceWithOffsetAfterEndOfArray() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArrayUtil.replace((byte[])new byte[]{0, 1}, (int)3, (int)2, (byte[])new byte[]{0}, (byte[])new byte[]{0, -1}));
    }

    @Test
    void cannotReplaceWithLengthAfterEndOfArray() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArrayUtil.replace((byte[])new byte[]{0, 1}, (int)1, (int)2, (byte[])new byte[]{0}, (byte[])new byte[]{0, -1}));
    }

    @Test
    void replaceWorks() throws Exception {
        List list = Arrays.asList({1, 2, 1, 2}, {1, 2}, {3, 4}, {3, 4, 3, 4}, {1, 2, 1, 2}, {1, 2}, {3}, {3, 3}, {1, 2, 1, 2}, {1, 2}, {3, 4, 5}, {3, 4, 5, 3, 4, 5}, {0, 1, 2, 0, 1, 2, 0}, {1, 2}, {3, 4, 5}, {0, 3, 4, 5, 0, 3, 4, 5, 0}, {1, 1, 1, 1}, {1, 2}, {3, 4}, {1, 1, 1, 1}, {1, 1, 1, 1}, {1, 2}, {3}, {1, 1, 1, 1}, {1, 1, 1, 1}, {1, 2}, {3, 4, 5}, {1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1}, {3, 4, 5}, {3, 4, 5, 3, 4, 5, 1}, {1, 1, 1, 1, 1}, {1, 1}, {3, 4}, {3, 4, 3, 4, 1}, {1, 1, 1, 1, 1}, {1, 1}, {3}, {3, 3, 1}, {1, 2, 1, 2}, {1, 2}, null, new byte[0], {1, 2, 1, 2}, {1, 2}, new byte[0], new byte[0], {1, 2, 1, 2}, null, {4}, {1, 2, 1, 2}, {1, 2, 1, 2}, new byte[0], {4}, {1, 2, 1, 2}, null, {1, 2}, {4}, null);
        for (int i = 0; i < list.size(); i += 4) {
            byte[] byArray = (byte[])list.get(i);
            byte[] byArray2 = (byte[])list.get(i + 1);
            byte[] byArray3 = (byte[])list.get(i + 2);
            byte[] byArray4 = (byte[])list.get(i + 3);
            byte[] byArray5 = ByteArrayUtil.replace((byte[])byArray, (byte[])byArray2, (byte[])byArray3);
            String string = String.format("results <%s> did not match expected results <%s> when replaceing <%s> with <%s> in <%s>", ByteArrayUtil.printable((byte[])byArray5), ByteArrayUtil.printable((byte[])byArray4), ByteArrayUtil.printable((byte[])byArray2), ByteArrayUtil.printable((byte[])byArray3), ByteArrayUtil.printable((byte[])byArray));
            Assertions.assertArrayEquals((byte[])byArray4, (byte[])byArray5, (String)string);
            if (byArray == null) continue;
            Assertions.assertTrue((byArray != byArray5 ? 1 : 0) != 0, (String)String.format("src and results array are pointer-equal when replacing <%s> with <%s> in <%s>", ByteArrayUtil.printable((byte[])byArray2), ByteArrayUtil.printable((byte[])byArray3), ByteArrayUtil.printable((byte[])byArray)));
        }
    }
}

