#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
/*
 * TenantLock.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace {

struct TenantLock : TestWorkload {
	static constexpr auto NAME = "TenantLock";
	Value tenant1;
	Value tenant2;

	enum class LockAwareTx { NO, READ, READ_WRITE };

	TenantLock(WorkloadContext const& wcx) : TestWorkload(wcx) {
		tenant1 = getOption(options, "tenant1"_sr, ""_sr);
		tenant2 = getOption(options, "tenant2"_sr, ""_sr);
		// Both tenants should be created using the CreateTenant workload and then passed to this workload in the
		// toml file
		ASSERT(!tenant1.empty() && !tenant2.empty());
	}

																#line 46 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
// This generated class is to be used only via probeTx()
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
template <class ProbeTxActor>
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class ProbeTxActorState {
															#line 52 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ProbeTxActorState(Database const& db,TenantName const& name,Optional<UID> const& expectedVal,bool const& readOnly = false,LockAwareTx const& lA = LockAwareTx::NO) 
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		 : db(db),
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   name(name),
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   expectedVal(expectedVal),
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   readOnly(readOnly),
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   lA(lA),
															#line 49 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   tr(db, makeReference<Tenant>(db, name)),
															#line 50 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   result(deterministicRandom()->randomUniqueID()),
															#line 51 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   resultValue(BinaryWriter::toValue(result, IncludeVersion()))
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
	{
		fdb_probe_actor_create("probeTx", reinterpret_cast<unsigned long>(this));

	}
	~ProbeTxActorState() 
	{
		fdb_probe_actor_destroy("probeTx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			;
															#line 88 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProbeTxActorState();
		static_cast<ProbeTxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 54 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			switch (lA) { case LockAwareTx::NO: break; case LockAwareTx::READ: tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE); break; case LockAwareTx::READ_WRITE: tr.setOption(FDBTransactionOptions::LOCK_AWARE); };
															#line 63 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get("foo"_sr);
															#line 63 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (static_cast<ProbeTxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 123 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProbeTxActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProbeTxActor, 0, Optional<Value> >*>(static_cast<ProbeTxActor*>(this)));
															#line 128 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			TraceEvent("ProbeTxError").error(e);
															#line 77 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 77 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (static_cast<ProbeTxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 154 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ProbeTxActor*>(this)->actor_wait_state = 3;
															#line 77 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProbeTxActor, 2, Void >*>(static_cast<ProbeTxActor*>(this)));
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 64 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (val != resultValue)
															#line 174 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		{
															#line 65 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			ASSERT(expectedVal.present() == val.present());
															#line 66 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			ASSERT(!val.present() || BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion()) == expectedVal.get());
															#line 180 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		}
															#line 69 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (readOnly)
															#line 184 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (!static_cast<ProbeTxActor*>(this)->SAV<Optional<UID>>::futures) { (void)(BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion())); this->~ProbeTxActorState(); static_cast<ProbeTxActor*>(this)->destroy(); return 0; }
															#line 188 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			new (&static_cast<ProbeTxActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion()));
			this->~ProbeTxActorState();
			static_cast<ProbeTxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 72 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		tr.set("foo"_sr, resultValue);
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ProbeTxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 200 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProbeTxActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProbeTxActor, 1, Void >*>(static_cast<ProbeTxActor*>(this)));
															#line 205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 64 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (val != resultValue)
															#line 214 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		{
															#line 65 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			ASSERT(expectedVal.present() == val.present());
															#line 66 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			ASSERT(!val.present() || BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion()) == expectedVal.get());
															#line 220 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		}
															#line 69 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (readOnly)
															#line 224 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (!static_cast<ProbeTxActor*>(this)->SAV<Optional<UID>>::futures) { (void)(BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion())); this->~ProbeTxActorState(); static_cast<ProbeTxActor*>(this)->destroy(); return 0; }
															#line 228 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			new (&static_cast<ProbeTxActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(BinaryReader::fromStringRef<UID>(val.get(), IncludeVersion()));
			this->~ProbeTxActorState();
			static_cast<ProbeTxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 72 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		tr.set("foo"_sr, resultValue);
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ProbeTxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProbeTxActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProbeTxActor, 1, Void >*>(static_cast<ProbeTxActor*>(this)));
															#line 245 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProbeTxActor*>(this)->actor_wait_state > 0) static_cast<ProbeTxActor*>(this)->actor_wait_state = 0;
		static_cast<ProbeTxActor*>(this)->ActorCallback< ProbeTxActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProbeTxActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<ProbeTxActor*>(this)->SAV<Optional<UID>>::futures) { (void)(result); this->~ProbeTxActorState(); static_cast<ProbeTxActor*>(this)->destroy(); return 0; }
															#line 329 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<ProbeTxActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(std::move(result)); // state_var_RVO
		this->~ProbeTxActorState();
		static_cast<ProbeTxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<ProbeTxActor*>(this)->SAV<Optional<UID>>::futures) { (void)(result); this->~ProbeTxActorState(); static_cast<ProbeTxActor*>(this)->destroy(); return 0; }
															#line 341 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<ProbeTxActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(std::move(result)); // state_var_RVO
		this->~ProbeTxActorState();
		static_cast<ProbeTxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProbeTxActor*>(this)->actor_wait_state > 0) static_cast<ProbeTxActor*>(this)->actor_wait_state = 0;
		static_cast<ProbeTxActor*>(this)->ActorCallback< ProbeTxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProbeTxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProbeTxActor*>(this)->actor_wait_state > 0) static_cast<ProbeTxActor*>(this)->actor_wait_state = 0;
		static_cast<ProbeTxActor*>(this)->ActorCallback< ProbeTxActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProbeTxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProbeTxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Database db;
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	TenantName name;
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Optional<UID> expectedVal;
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	bool readOnly;
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	LockAwareTx lA;
															#line 49 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 50 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	UID result;
															#line 51 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Value resultValue;
															#line 527 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
};
// This generated class is to be used only via probeTx()
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class ProbeTxActor final : public Actor<Optional<UID>>, public ActorCallback< ProbeTxActor, 0, Optional<Value> >, public ActorCallback< ProbeTxActor, 1, Void >, public ActorCallback< ProbeTxActor, 2, Void >, public FastAllocated<ProbeTxActor>, public ProbeTxActorState<ProbeTxActor> {
															#line 532 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
	using FastAllocated<ProbeTxActor>::operator new;
	using FastAllocated<ProbeTxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18275882443035064832UL, 3169104395559571712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProbeTxActor, 0, Optional<Value> >;
friend struct ActorCallback< ProbeTxActor, 1, Void >;
friend struct ActorCallback< ProbeTxActor, 2, Void >;
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ProbeTxActor(Database const& db,TenantName const& name,Optional<UID> const& expectedVal,bool const& readOnly = false,LockAwareTx const& lA = LockAwareTx::NO) 
															#line 551 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		 : Actor<Optional<UID>>(),
		   ProbeTxActorState<ProbeTxActor>(db, name, expectedVal, readOnly, lA),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("probeTx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14914083893457202688UL, 6734071075510906624UL);
		ActorExecutionContextHelper __helper(static_cast<ProbeTxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("probeTx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("probeTx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProbeTxActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProbeTxActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProbeTxActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
[[nodiscard]] static Future<Optional<UID>> probeTx( Database const& db, TenantName const& name, Optional<UID> const& expectedVal, bool const& readOnly = false, LockAwareTx const& lA = LockAwareTx::NO ) {
															#line 44 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	return Future<Optional<UID>>(new ProbeTxActor(db, name, expectedVal, readOnly, lA));
															#line 585 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
}

#line 81 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"

																#line 590 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
// This generated class is to be used only via changeLockState()
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
template <class ChangeLockStateActor>
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class ChangeLockStateActorState {
															#line 596 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ChangeLockStateActorState(Database const& db,TenantName const& name,TenantAPI::TenantLockState const& desiredState,UID const& lockID) 
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		 : db(db),
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   name(name),
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   desiredState(desiredState),
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   lockID(lockID),
															#line 86 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   tenant(makeReference<Tenant>(db, name)),
															#line 87 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   tr(db)
															#line 613 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
	{
		fdb_probe_actor_create("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	~ChangeLockStateActorState() 
	{
		fdb_probe_actor_destroy("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			;
															#line 628 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 90 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 91 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tenant->ready();
															#line 91 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 663 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 0, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 668 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 96 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 692 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 4;
															#line 96 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 3, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 697 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = TenantAPI::changeLockState(&tr, tenant->id(), desiredState, lockID);
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 714 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 1, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 719 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = TenantAPI::changeLockState(&tr, tenant->id(), desiredState, lockID);
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 730 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 1, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 735 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 821 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 2, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 826 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 837 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 2, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 842 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<ChangeLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateActorState(); static_cast<ChangeLockStateActor*>(this)->destroy(); return 0; }
															#line 926 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<ChangeLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<ChangeLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateActorState(); static_cast<ChangeLockStateActor*>(this)->destroy(); return 0; }
															#line 938 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<ChangeLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Database db;
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	TenantName name;
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	TenantAPI::TenantLockState desiredState;
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	UID lockID;
															#line 86 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Reference<Tenant> tenant;
															#line 87 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1120 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
};
// This generated class is to be used only via changeLockState()
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class ChangeLockStateActor final : public Actor<Void>, public ActorCallback< ChangeLockStateActor, 0, Void >, public ActorCallback< ChangeLockStateActor, 1, Void >, public ActorCallback< ChangeLockStateActor, 2, Void >, public ActorCallback< ChangeLockStateActor, 3, Void >, public FastAllocated<ChangeLockStateActor>, public ChangeLockStateActorState<ChangeLockStateActor> {
															#line 1125 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
	using FastAllocated<ChangeLockStateActor>::operator new;
	using FastAllocated<ChangeLockStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13283434729006656256UL, 7944599717800549632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeLockStateActor, 0, Void >;
friend struct ActorCallback< ChangeLockStateActor, 1, Void >;
friend struct ActorCallback< ChangeLockStateActor, 2, Void >;
friend struct ActorCallback< ChangeLockStateActor, 3, Void >;
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	ChangeLockStateActor(Database const& db,TenantName const& name,TenantAPI::TenantLockState const& desiredState,UID const& lockID) 
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeLockStateActorState<ChangeLockStateActor>(db, name, desiredState, lockID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11357216008526473216UL, 16339221266547417344UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeLockState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeLockStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeLockStateActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeLockStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeLockStateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
[[nodiscard]] static Future<Void> changeLockState( Database const& db, TenantName const& name, TenantAPI::TenantLockState const& desiredState, UID const& lockID ) {
															#line 82 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	return Future<Void>(new ChangeLockStateActor(db, name, desiredState, lockID));
															#line 1180 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
}

#line 100 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"

																#line 1185 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
template <class _startActor>
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class _startActorState {
															#line 1191 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	_startActorState(TenantLock* const& self,Database const& db) 
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		 : self(self),
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   db(db),
															#line 102 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   currentValue1(),
															#line 103 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   currentValue2(),
															#line 104 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   lockID1(deterministicRandom()->randomUniqueID()),
															#line 105 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		   lockID2(deterministicRandom()->randomUniqueID())
															#line 1208 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			TraceEvent("TenantLockProgress").detail("Phase", "First Tx against unlocked tenant").log();
															#line 107 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(currentValue1, probeTx(db, self->tenant1, currentValue1));
															#line 107 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1227 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1232 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(currentValue2, probeTx(db, self->tenant2, currentValue2));
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1257 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(currentValue2, probeTx(db, self->tenant2, currentValue2));
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1273 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1278 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress") .detail("Phase", "Lock Both tenants") .detail("LockID1", lockID1) .detail("LockID2", lockID2) .log();
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changeLockState(db, self->tenant1, TenantAPI::TenantLockState::LOCKED, lockID1);
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1366 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1371 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress") .detail("Phase", "Lock Both tenants") .detail("LockID1", lockID1) .detail("LockID2", lockID2) .log();
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changeLockState(db, self->tenant1, TenantAPI::TenantLockState::LOCKED, lockID1);
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1384 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1389 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = changeLockState(db, self->tenant2, TenantAPI::TenantLockState::LOCKED, lockID2);
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1475 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1480 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = changeLockState(db, self->tenant2, TenantAPI::TenantLockState::LOCKED, lockID2);
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1491 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1496 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against locked tenant").log();
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testExpectedError(success(probeTx(db, self->tenant1, currentValue1)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1584 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1589 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against locked tenant").log();
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testExpectedError(success(probeTx(db, self->tenant1, currentValue1)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1602 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1607 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Read-only Tx against locked tenant").log();
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_5 = testExpectedError(success(probeTx(db, self->tenant2, currentValue2, true)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1695 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1700 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Read-only Tx against locked tenant").log();
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_5 = testExpectedError(success(probeTx(db, self->tenant2, currentValue2, true)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1713 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1718 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress") .detail("Phase", "Read-only Tx against locked tenant with read-lock-aware") .log();
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(probeTx(db, self->tenant1, currentValue1, true, LockAwareTx::READ));
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1806 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1811 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress") .detail("Phase", "Read-only Tx against locked tenant with read-lock-aware") .log();
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(probeTx(db, self->tenant1, currentValue1, true, LockAwareTx::READ));
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1824 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1829 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Read-write Tx against locked tenant with lock-aware").log();
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(currentValue2, probeTx(db, self->tenant2, currentValue2, false, LockAwareTx::READ_WRITE));
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1917 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1922 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Read-write Tx against locked tenant with lock-aware").log();
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(currentValue2, probeTx(db, self->tenant2, currentValue2, false, LockAwareTx::READ_WRITE));
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1935 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1940 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant1").log();
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_8 = changeLockState(db, self->tenant1, TenantAPI::TenantLockState::UNLOCKED, lockID1);
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2028 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2033 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant1").log();
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_8 = changeLockState(db, self->tenant1, TenantAPI::TenantLockState::UNLOCKED, lockID1);
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2046 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2051 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against unlocked tenant1").log();
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_9 = store(currentValue1, probeTx(db, self->tenant1, currentValue1));
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2144 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against unlocked tenant1").log();
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_9 = store(currentValue1, probeTx(db, self->tenant1, currentValue1));
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2162 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against locked tenant2").log();
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_10 = testExpectedError(success(probeTx(db, self->tenant2, currentValue2, true)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2250 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2255 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Tx against locked tenant2").log();
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_10 = testExpectedError(success(probeTx(db, self->tenant2, currentValue2, true)), "AccessLockedTenant", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2268 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2273 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant2 with wrong lockID").log();
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_11 = testExpectedError(changeLockState(db, self->tenant2, TenantAPI::TenantLockState::UNLOCKED, lockID1), "UnlockWithWrongID", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2361 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 2366 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant2 with wrong lockID").log();
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_11 = testExpectedError(changeLockState(db, self->tenant2, TenantAPI::TenantLockState::UNLOCKED, lockID1), "UnlockWithWrongID", tenant_locked(), Optional<bool*>(), {}, Error::fromCode(error_code_internal_error));
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2379 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 2384 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant2").log();
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_12 = changeLockState(db, self->tenant2, TenantAPI::TenantLockState::UNLOCKED, lockID2);
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2472 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 2477 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Unlock tenant2").log();
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_12 = changeLockState(db, self->tenant2, TenantAPI::TenantLockState::UNLOCKED, lockID2);
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2490 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 2495 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Second Tx against both unlocked tenants").log();
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_13 = store(currentValue1, probeTx(db, self->tenant1, currentValue1));
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2583 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 2588 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		TraceEvent("TenantLockProgress").detail("Phase", "Second Tx against both unlocked tenants").log();
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_13 = store(currentValue1, probeTx(db, self->tenant1, currentValue1));
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2601 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 2606 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_14 = store(currentValue2, probeTx(db, self->tenant2, currentValue2));
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2692 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 2697 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		StrictFuture<Void> __when_expr_14 = store(currentValue2, probeTx(db, self->tenant2, currentValue2));
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2708 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 2713 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2797 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2809 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	TenantLock* self;
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Database db;
															#line 102 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Optional<UID> currentValue1;
															#line 103 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	Optional<UID> currentValue2;
															#line 104 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	UID lockID1;
															#line 105 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	UID lockID2;
															#line 2904 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2909 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(188983413913407744UL, 8237629746525528320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, Void >;
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	_startActor(TenantLock* const& self,Database const& db) 
															#line 2940 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
[[nodiscard]] static Future<Void> _start( TenantLock* const& self, Database const& db ) {
															#line 101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"
	return Future<Void>(new _startActor(self, db));
															#line 2986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantLock.actor.g.cpp"
}

#line 163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/workloads/TenantLock.actor.cpp"

	Future<Void> start(const Database& cx) override {
		if (clientId == 0) {
			return _start(this, cx);
		}
		return Void();
	}
	Future<bool> check(const Database& cx) override { return true; }

private:
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

} // namespace

WorkloadFactory<TenantLock> TenantLockFactory;