#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
/*
 * MockS3Server.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/MockS3Server.h"

#include "fdbrpc/HTTP.h"
#include "fdbrpc/simulator.h"
#include "flow/Trace.h"
#include "flow/ActorCollection.h"
#include "flow/IRandom.h"
#include "flow/serialize.h"

#include <string>
#include <map>
#include <unordered_map>
#include <sstream>
#include <iomanip>
#include <regex>
#include <utility>
#include <iostream>

#include "flow/actorcompiler.h" // This must be the last #include.

// Global storage for MockS3 (shared across all simulated processes)
struct MockS3GlobalStorage {
	struct ObjectData {
		std::string content;
		HTTP::Headers headers;
		std::map<std::string, std::string> tags;
		std::string etag;
		double lastModified;

		ObjectData() : lastModified(now()) {}
		ObjectData(const std::string& data) : content(data), lastModified(now()) { etag = generateETag(data); }

		static std::string generateETag(const std::string& content) {
			return "\"" + HTTP::computeMD5Sum(content) + "\"";
		}
	};

	struct MultipartUpload {
		std::string uploadId;
		std::string bucket;
		std::string object;
		std::map<int, std::pair<std::string, std::string>> parts; // partNum -> {etag, content}
		HTTP::Headers metadata;
		double initiated;

		MultipartUpload() = default;
		MultipartUpload(const std::string& b, const std::string& o) : bucket(b), object(o), initiated(now()) {
			uploadId = deterministicRandom()->randomUniqueID().toString();
		}
	};

	std::map<std::string, std::map<std::string, ObjectData>> buckets;
	std::map<std::string, MultipartUpload> multipartUploads;

	// Note: In FDB simulation, function-local statics are SHARED across all simulated processes
	// because they all run on the same OS thread. This is exactly what we want for MockS3 storage.
	MockS3GlobalStorage() { TraceEvent("MockS3GlobalStorageCreated").detail("Address", format("%p", this)); }

	// Clear all stored data - called at the start of each simulation test to prevent
	// data accumulation across multiple tests
	void clearStorage() {
		buckets.clear();
		multipartUploads.clear();
		TraceEvent("MockS3GlobalStorageCleared").detail("Address", format("%p", this));
	}
};

// Accessor function - uses function-local static for lazy initialization
// In simulation, this static is shared across all simulated processes (same OS thread)
static MockS3GlobalStorage& getGlobalStorage() {
	static MockS3GlobalStorage storage;
	return storage;
}

// Mock S3 Server Implementation for deterministic testing
class MockS3ServerImpl {
public:
	using ObjectData = MockS3GlobalStorage::ObjectData;
	using MultipartUpload = MockS3GlobalStorage::MultipartUpload;

	MockS3ServerImpl() { TraceEvent("MockS3ServerImpl_Constructor").detail("Address", format("%p", this)); }

	~MockS3ServerImpl() { TraceEvent("MockS3ServerImpl_Destructor").detail("Address", format("%p", this)); }

	// S3 Operation Handlers
																#line 108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
// This generated class is to be used only via handleRequest()
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class HandleRequestActor>
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class HandleRequestActorState {
															#line 114 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	HandleRequestActorState(MockS3ServerImpl* const& self,Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : self(self),
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		   req(req),
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		   response(response)
															#line 125 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleRequestActorState() 
	{
		fdb_probe_actor_destroy("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent("MockS3Request") .detail("Method", req->verb) .detail("Resource", req->resource) .detail("ContentLength", req->data.contentLen) .detail("Headers", req->data.headers.size()) .detail("UserAgent", req->data.headers.find("User-Agent") != req->data.headers.end() ? req->data.headers.at("User-Agent") : "N/A") .detail("Host", req->data.headers.find("Host") != req->data.headers.end() ? req->data.headers.at("Host") : "N/A");
															#line 140 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			try {
															#line 123 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				std::string bucket, object;
															#line 124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				std::map<std::string, std::string> queryParams;
															#line 125 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				self->parseS3Request(req->resource, bucket, object, queryParams);
															#line 127 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				TraceEvent("MockS3ParsedRequest") .detail("Bucket", bucket) .detail("Object", object) .detail("QueryParamCount", queryParams.size());
															#line 133 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				if (queryParams.count("uploads"))
															#line 152 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				{
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->handleMultipartStart(self, req, response, bucket, object);
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
					if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 158 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<HandleRequestActor*>(this)->actor_wait_state = 1;
															#line 134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 0, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 135 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
					if (queryParams.count("uploadId"))
															#line 170 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
					{
															#line 136 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
						if (queryParams.count("partNumber"))
															#line 174 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
						{
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							StrictFuture<Void> __when_expr_1 = self->handleUploadPart(self, req, response, bucket, object, queryParams);
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 180 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<HandleRequestActor*>(this)->actor_wait_state = 2;
															#line 137 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 1, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 185 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 138 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							if (req->verb == "POST")
															#line 192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
							{
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								StrictFuture<Void> __when_expr_2 = self->handleMultipartComplete(self, req, response, bucket, object, queryParams);
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 198 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
								static_cast<HandleRequestActor*>(this)->actor_wait_state = 3;
															#line 139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 2, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 203 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 140 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (req->verb == "DELETE")
															#line 210 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								{
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									StrictFuture<Void> __when_expr_3 = self->handleMultipartAbort(self, req, response, bucket, object, queryParams);
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 216 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
									static_cast<HandleRequestActor*>(this)->actor_wait_state = 4;
															#line 141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 3, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 221 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 143 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									self->sendError( response, HTTP::HTTP_STATUS_CODE_BAD_GATEWAY, "InvalidRequest", "Unknown multipart operation");
															#line 228 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									loopDepth = a_body1cont9(loopDepth);
								}
							}
						}
					}
					else
					{
															#line 146 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
						if (queryParams.count("tagging"))
															#line 238 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
						{
															#line 147 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							if (req->verb == "PUT")
															#line 242 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
							{
															#line 148 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								StrictFuture<Void> __when_expr_4 = self->handlePutObjectTags(self, req, response, bucket, object);
															#line 148 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 248 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
								static_cast<HandleRequestActor*>(this)->actor_wait_state = 5;
															#line 148 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 4, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 253 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 149 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (req->verb == "GET")
															#line 260 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								{
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									StrictFuture<Void> __when_expr_5 = self->handleGetObjectTags(self, req, response, bucket, object);
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 266 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1when6(__when_expr_5.get(), loopDepth); };
									static_cast<HandleRequestActor*>(this)->actor_wait_state = 6;
															#line 150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 5, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 271 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 152 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									self->sendError(response, HTTP::HTTP_STATUS_CODE_BAD_GATEWAY, "MethodNotAllowed", "Method not allowed for tagging");
															#line 278 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									loopDepth = a_body1cont15(loopDepth);
								}
							}
						}
						else
						{
															#line 157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
							if (queryParams.count("list-type") || (req->verb == "GET" && object.empty()))
															#line 287 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
							{
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								StrictFuture<Void> __when_expr_6 = self->handleListObjects(self, req, response, bucket, queryParams);
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 293 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1when7(__when_expr_6.get(), loopDepth); };
								static_cast<HandleRequestActor*>(this)->actor_wait_state = 7;
															#line 159 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 6, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 298 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
								if (object.empty())
															#line 305 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
								{
															#line 162 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									if (req->verb == "HEAD")
															#line 309 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									{
															#line 163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										StrictFuture<Void> __when_expr_7 = self->handleHeadBucket(self, req, response, bucket);
															#line 163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 315 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1when8(__when_expr_7.get(), loopDepth); };
										static_cast<HandleRequestActor*>(this)->actor_wait_state = 8;
															#line 163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 7, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 320 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 164 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										if (req->verb == "PUT")
															#line 327 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										{
															#line 165 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											StrictFuture<Void> __when_expr_8 = self->handlePutBucket(self, req, response, bucket);
															#line 165 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 333 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1when9(__when_expr_8.get(), loopDepth); };
											static_cast<HandleRequestActor*>(this)->actor_wait_state = 9;
															#line 165 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 8, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 338 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 167 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											self->sendError(response, HTTP::HTTP_STATUS_CODE_BAD_GATEWAY, "MethodNotAllowed", "Bucket operation not supported");
															#line 345 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											loopDepth = a_body1cont23(loopDepth);
										}
									}
								}
								else
								{
															#line 174 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
									if (req->verb == "PUT")
															#line 354 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
									{
															#line 175 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										StrictFuture<Void> __when_expr_9 = self->handlePutObject(self, req, response, bucket, object);
															#line 175 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 360 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1when10(__when_expr_9.get(), loopDepth); };
										static_cast<HandleRequestActor*>(this)->actor_wait_state = 10;
															#line 175 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 9, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 365 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 176 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
										if (req->verb == "GET")
															#line 372 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
										{
															#line 177 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											StrictFuture<Void> __when_expr_10 = self->handleGetObject(self, req, response, bucket, object);
															#line 177 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 378 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1when11(__when_expr_10.get(), loopDepth); };
											static_cast<HandleRequestActor*>(this)->actor_wait_state = 11;
															#line 177 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 10, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 383 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 178 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
											if (req->verb == "DELETE")
															#line 390 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
											{
															#line 179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
												StrictFuture<Void> __when_expr_11 = self->handleDeleteObject(self, req, response, bucket, object);
															#line 179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
												if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 396 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
												if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1when12(__when_expr_11.get(), loopDepth); };
												static_cast<HandleRequestActor*>(this)->actor_wait_state = 12;
															#line 179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
												__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 11, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 401 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
												loopDepth = 0;
											}
											else
											{
															#line 180 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
												if (req->verb == "HEAD")
															#line 408 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
												{
															#line 181 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
													StrictFuture<Void> __when_expr_12 = self->handleHeadObject(self, req, response, bucket, object);
															#line 181 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
													if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 414 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
													if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1when13(__when_expr_12.get(), loopDepth); };
													static_cast<HandleRequestActor*>(this)->actor_wait_state = 13;
															#line 181 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
													__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 12, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 419 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
													loopDepth = 0;
												}
												else
												{
															#line 183 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
													self->sendError( response, HTTP::HTTP_STATUS_CODE_BAD_GATEWAY, "MethodNotAllowed", "Method not supported");
															#line 426 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
													loopDepth = a_body1cont32(loopDepth);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 193 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		if (!static_cast<HandleRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleRequestActorState(); static_cast<HandleRequestActor*>(this)->destroy(); return 0; }
															#line 464 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		new (&static_cast<HandleRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent(SevError, "MockS3RequestError").error(e).detail("Resource", req->resource);
															#line 190 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			self->sendError(response, 500, "InternalError", "Internal server error");
															#line 479 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont35(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont18(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont20(int loopDepth) 
	{
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont21(int loopDepth) 
	{
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont23(int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont24(_, loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont24(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont26(int loopDepth) 
	{
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont27(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1cont27(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont28(int loopDepth) 
	{
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1cont29(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1cont29(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1when11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont29(_, loopDepth);

		return loopDepth;
	}
	int a_body1when11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont29(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont30(int loopDepth) 
	{
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1cont31(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1cont31(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1when12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont31(_, loopDepth);

		return loopDepth;
	}
	int a_body1when12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont31(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont32(int loopDepth) 
	{
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1cont33(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont32(loopDepth);

		return loopDepth;
	}
	int a_body1cont33(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont32(loopDepth);

		return loopDepth;
	}
	int a_body1when13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont33(_, loopDepth);

		return loopDepth;
	}
	int a_body1when13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont33(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when13(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont35(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	MockS3ServerImpl* self;
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 1736 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via handleRequest()
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class HandleRequestActor final : public Actor<Void>, public ActorCallback< HandleRequestActor, 0, Void >, public ActorCallback< HandleRequestActor, 1, Void >, public ActorCallback< HandleRequestActor, 2, Void >, public ActorCallback< HandleRequestActor, 3, Void >, public ActorCallback< HandleRequestActor, 4, Void >, public ActorCallback< HandleRequestActor, 5, Void >, public ActorCallback< HandleRequestActor, 6, Void >, public ActorCallback< HandleRequestActor, 7, Void >, public ActorCallback< HandleRequestActor, 8, Void >, public ActorCallback< HandleRequestActor, 9, Void >, public ActorCallback< HandleRequestActor, 10, Void >, public ActorCallback< HandleRequestActor, 11, Void >, public ActorCallback< HandleRequestActor, 12, Void >, public FastAllocated<HandleRequestActor>, public HandleRequestActorState<HandleRequestActor> {
															#line 1741 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<HandleRequestActor>::operator new;
	using FastAllocated<HandleRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15372434905812115968UL, 5164039093708282112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleRequestActor, 0, Void >;
friend struct ActorCallback< HandleRequestActor, 1, Void >;
friend struct ActorCallback< HandleRequestActor, 2, Void >;
friend struct ActorCallback< HandleRequestActor, 3, Void >;
friend struct ActorCallback< HandleRequestActor, 4, Void >;
friend struct ActorCallback< HandleRequestActor, 5, Void >;
friend struct ActorCallback< HandleRequestActor, 6, Void >;
friend struct ActorCallback< HandleRequestActor, 7, Void >;
friend struct ActorCallback< HandleRequestActor, 8, Void >;
friend struct ActorCallback< HandleRequestActor, 9, Void >;
friend struct ActorCallback< HandleRequestActor, 10, Void >;
friend struct ActorCallback< HandleRequestActor, 11, Void >;
friend struct ActorCallback< HandleRequestActor, 12, Void >;
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	HandleRequestActor(MockS3ServerImpl* const& self,Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 1770 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   HandleRequestActorState<HandleRequestActor>(self, req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3085149730912622080UL, 127431907239638784UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleRequestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< HandleRequestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< HandleRequestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< HandleRequestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< HandleRequestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< HandleRequestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< HandleRequestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< HandleRequestActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< HandleRequestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< HandleRequestActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< HandleRequestActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
[[nodiscard]] static Future<Void> handleRequest( MockS3ServerImpl* const& self, Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new HandleRequestActor(self, req, response));
															#line 1814 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}

#line 195 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

	void parseS3Request(const std::string& resource,
	                    std::string& bucket,
	                    std::string& object,
	                    std::map<std::string, std::string>& queryParams) {

		// Split resource into path and query string
		size_t queryPos = resource.find('?');
		std::string path = (queryPos != std::string::npos) ? resource.substr(0, queryPos) : resource;
		std::string query = (queryPos != std::string::npos) ? resource.substr(queryPos + 1) : "";

		// Parse path: /bucket/object (like real S3)
		if (path.size() > 1) {
			path = path.substr(1); // Remove leading /
			size_t slashPos = path.find('/');
			if (slashPos != std::string::npos) {
				bucket = path.substr(0, slashPos);
				object = path.substr(slashPos + 1);
			} else {
				bucket = path;
				object = "";
			}
		}

		// Parse query parameters
		if (!query.empty()) {
			std::regex paramRegex("([^&=]+)=?([^&]*)");
			std::sregex_iterator iter(query.begin(), query.end(), paramRegex);
			std::sregex_iterator end;

			for (; iter != end; ++iter) {
				std::string key = iter->str(1);
				std::string value = iter->str(2);
				// URL decode the parameter value
				queryParams[key] = HTTP::urlDecode(value);
			}
		}

		// MockS3Server handles S3 HTTP requests where bucket is always the first path component
		// For bucket operations: HEAD /bucket_name
		// For object operations: HEAD /bucket_name/object_path
		if (bucket.empty()) {
			TraceEvent(SevWarn, "MockS3MissingBucketInPath").detail("Resource", resource).detail("QueryString", query);
			throw backup_invalid_url();
		}

		TraceEvent("MockS3ParsedPath")
		    .detail("OriginalResource", resource)
		    .detail("Bucket", bucket)
		    .detail("Object", object)
		    .detail("QueryString", query);
	}

	// Parse HTTP Range header: "bytes=start-end"
	// Returns true if parsing succeeded, false otherwise
	// Sets rangeStart and rangeEnd to the parsed values
	static bool parseRangeHeader(const std::string& rangeHeader, int64_t& rangeStart, int64_t& rangeEnd) {
		if (rangeHeader.empty()) {
			return false;
		}

		// Check for "bytes=" prefix
		if (rangeHeader.substr(0, 6) != "bytes=") {
			return false;
		}

		std::string range = rangeHeader.substr(6);
		size_t dashPos = range.find('-');
		if (dashPos == std::string::npos) {
			return false;
		}

		try {
			rangeStart = std::stoll(range.substr(0, dashPos));
			std::string endStr = range.substr(dashPos + 1);
			if (endStr.empty()) {
				// Open-ended range (e.g., "bytes=100-")
				rangeEnd = -1; // Indicates open-ended
			} else {
				rangeEnd = std::stoll(endStr);
			}
			return true;
		} catch (...) {
			return false;
		}
	}

	// Multipart Upload Operations
	static Future<Void> handleMultipartStart(MockS3ServerImpl* self,
	                                         Reference<HTTP::IncomingRequest> req,
	                                         Reference<HTTP::OutgoingResponse> response,
	                                         std::string bucket,
	                                         std::string object) {

		TraceEvent("MockS3MultipartStart").detail("Bucket", bucket).detail("Object", object);

		// Create multipart upload
		MultipartUpload upload(bucket, object);
		std::string uploadId = upload.uploadId;
		getGlobalStorage().multipartUploads[uploadId] = std::move(upload);

		// Generate XML response
		std::string xml = format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
		                         "<InitiateMultipartUploadResult>\n"
		                         "  <Bucket>%s</Bucket>\n"
		                         "  <Key>%s</Key>\n"
		                         "  <UploadId>%s</UploadId>\n"
		                         "</InitiateMultipartUploadResult>",
		                         bucket.c_str(),
		                         object.c_str(),
		                         uploadId.c_str());

		self->sendXMLResponse(response, 200, xml);

		TraceEvent("MockS3MultipartStarted").detail("UploadId", uploadId);

		return Void();
	}

	static Future<Void> handleUploadPart(MockS3ServerImpl* self,
	                                     Reference<HTTP::IncomingRequest> req,
	                                     Reference<HTTP::OutgoingResponse> response,
	                                     std::string bucket,
	                                     std::string object,
	                                     std::map<std::string, std::string> queryParams) {

		std::string uploadId = queryParams.at("uploadId");
		int partNumber = std::stoi(queryParams.at("partNumber"));

		TraceEvent("MockS3UploadPart")
		    .detail("UploadId", uploadId)
		    .detail("PartNumber", partNumber)
		    .detail("ContentLength", req->data.contentLen)
		    .detail("ActualContentSize", req->data.content.size())
		    .detail("ContentPreview",
		            req->data.content.size() > 0
		                ? req->data.content.substr(0, std::min((size_t)20, req->data.content.size()))
		                : "EMPTY");

		auto uploadIter = getGlobalStorage().multipartUploads.find(uploadId);
		if (uploadIter == getGlobalStorage().multipartUploads.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchUpload", "Upload not found");
			return Void();
		}

		// Store part data
		std::string etag = ObjectData::generateETag(req->data.content);
		uploadIter->second.parts[partNumber] = { etag, req->data.content };

		// Return ETag in response
		response->code = 200;
		response->data.headers["ETag"] = etag;
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3PartUploaded")
		    .detail("UploadId", uploadId)
		    .detail("PartNumber", partNumber)
		    .detail("ETag", etag);

		return Void();
	}

	static Future<Void> handleMultipartComplete(MockS3ServerImpl* self,
	                                            Reference<HTTP::IncomingRequest> req,
	                                            Reference<HTTP::OutgoingResponse> response,
	                                            std::string bucket,
	                                            std::string object,
	                                            std::map<std::string, std::string> queryParams) {

		std::string uploadId = queryParams.at("uploadId");

		TraceEvent("MockS3MultipartComplete").detail("UploadId", uploadId);

		auto uploadIter = getGlobalStorage().multipartUploads.find(uploadId);
		if (uploadIter == getGlobalStorage().multipartUploads.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchUpload", "Upload not found");
			return Void();
		}

		// Combine all parts in order
		std::string combinedContent;
		for (auto& part : uploadIter->second.parts) {
			combinedContent += part.second.second;
		}

		TraceEvent("MockS3MultipartDebug")
		    .detail("UploadId", uploadId)
		    .detail("PartsCount", uploadIter->second.parts.size())
		    .detail("CombinedSize", combinedContent.size())
		    .detail("CombinedPreview",
		            combinedContent.size() > 0 ? combinedContent.substr(0, std::min((size_t)20, combinedContent.size()))
		                                       : "EMPTY");

		// Create final object
		ObjectData obj(combinedContent);
		getGlobalStorage().buckets[bucket][object] = std::move(obj);

		TraceEvent("MockS3MultipartFinalObject")
		    .detail("UploadId", uploadId)
		    .detail("StoredSize", getGlobalStorage().buckets[bucket][object].content.size())
		    .detail("StoredPreview",
		            getGlobalStorage().buckets[bucket][object].content.size() > 0
		                ? getGlobalStorage().buckets[bucket][object].content.substr(
		                      0, std::min((size_t)20, getGlobalStorage().buckets[bucket][object].content.size()))
		                : "EMPTY");

		// Clean up multipart upload
		getGlobalStorage().multipartUploads.erase(uploadId);

		// Generate completion XML response
		std::string xml = format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
		                         "<CompleteMultipartUploadResult>\n"
		                         "  <Bucket>%s</Bucket>\n"
		                         "  <Key>%s</Key>\n"
		                         "  <ETag>%s</ETag>\n"
		                         "</CompleteMultipartUploadResult>",
		                         bucket.c_str(),
		                         object.c_str(),
		                         getGlobalStorage().buckets[bucket][object].etag.c_str());

		self->sendXMLResponse(response, 200, xml);

		TraceEvent("MockS3MultipartCompleted").detail("UploadId", uploadId).detail("FinalSize", combinedContent.size());

		return Void();
	}

	static Future<Void> handleMultipartAbort(MockS3ServerImpl* self,
	                                         Reference<HTTP::IncomingRequest> req,
	                                         Reference<HTTP::OutgoingResponse> response,
	                                         std::string bucket,
	                                         std::string object,
	                                         std::map<std::string, std::string> queryParams) {

		std::string uploadId = queryParams.at("uploadId");

		TraceEvent("MockS3MultipartAbort").detail("UploadId", uploadId);

		auto uploadIter = getGlobalStorage().multipartUploads.find(uploadId);
		if (uploadIter == getGlobalStorage().multipartUploads.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchUpload", "Upload not found");
			return Void();
		}

		// Remove multipart upload
		getGlobalStorage().multipartUploads.erase(uploadId);

		response->code = 204; // No Content
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3MultipartAborted").detail("UploadId", uploadId);

		return Void();
	}

	// Object Tagging Operations
	static Future<Void> handlePutObjectTags(MockS3ServerImpl* self,
	                                        Reference<HTTP::IncomingRequest> req,
	                                        Reference<HTTP::OutgoingResponse> response,
	                                        std::string bucket,
	                                        std::string object) {

		TraceEvent("MockS3PutObjectTags")
		    .detail("Bucket", bucket)
		    .detail("Object", object)
		    .detail("TagsXML", req->data.content);

		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter == getGlobalStorage().buckets.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchBucket", "Bucket not found");
			return Void();
		}

		auto objectIter = bucketIter->second.find(object);
		if (objectIter == bucketIter->second.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchKey", "Object not found");
			return Void();
		}

		// Parse tags XML (simplified parser)
		std::map<std::string, std::string> tags = self->parseTagsXML(req->data.content);
		objectIter->second.tags = tags;

		response->code = 200;
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3ObjectTagsSet")
		    .detail("Bucket", bucket)
		    .detail("Object", object)
		    .detail("TagCount", tags.size());

		return Void();
	}

	static Future<Void> handleGetObjectTags(MockS3ServerImpl* self,
	                                        Reference<HTTP::IncomingRequest> req,
	                                        Reference<HTTP::OutgoingResponse> response,
	                                        std::string bucket,
	                                        std::string object) {

		TraceEvent("MockS3GetObjectTags").detail("Bucket", bucket).detail("Object", object);

		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter == getGlobalStorage().buckets.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchBucket", "Bucket not found");
			return Void();
		}

		auto objectIter = bucketIter->second.find(object);
		if (objectIter == bucketIter->second.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchKey", "Object not found");
			return Void();
		}

		// Generate tags XML response
		std::string xml = self->generateTagsXML(objectIter->second.tags);
		self->sendXMLResponse(response, 200, xml);

		TraceEvent("MockS3ObjectTagsRetrieved")
		    .detail("Bucket", bucket)
		    .detail("Object", object)
		    .detail("TagCount", objectIter->second.tags.size());

		return Void();
	}

	// Basic Object Operations
	static Future<Void> handlePutObject(MockS3ServerImpl* self,
	                                    Reference<HTTP::IncomingRequest> req,
	                                    Reference<HTTP::OutgoingResponse> response,
	                                    std::string bucket,
	                                    std::string object) {

		ObjectData obj(req->data.content);
		std::string etag = obj.etag;
		getGlobalStorage().buckets[bucket][object] = std::move(obj);

		response->code = 200;
		response->data.headers["ETag"] = etag;
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		return Void();
	}

	static Future<Void> handleGetObject(MockS3ServerImpl* self,
	                                    Reference<HTTP::IncomingRequest> req,
	                                    Reference<HTTP::OutgoingResponse> response,
	                                    std::string bucket,
	                                    std::string object) {

		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter == getGlobalStorage().buckets.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchBucket", "Bucket not found");
			return Void();
		}

		auto objectIter = bucketIter->second.find(object);
		if (objectIter == bucketIter->second.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchKey", "Object not found");
			return Void();
		}

		std::string content = objectIter->second.content;
		std::string etag = objectIter->second.etag;
		std::string contentMD5 = HTTP::computeMD5Sum(content);

		// Handle HTTP Range header for partial content requests
		// This is essential for AsyncFileEncrypted to read encrypted blocks correctly
		int64_t rangeStart = 0;
		int64_t rangeEnd = static_cast<int64_t>(content.size() - 1);
		bool isRangeRequest = false;

		auto rangeHeader = req->data.headers.find("Range");
		if (rangeHeader != req->data.headers.end()) {
			int64_t parsedStart, parsedEnd;
			if (parseRangeHeader(rangeHeader->second, parsedStart, parsedEnd)) {
				rangeStart = parsedStart;
				if (parsedEnd == -1) {
					// Open-ended range (e.g., "bytes=100-")
					rangeEnd = static_cast<int64_t>(content.size() - 1);
				} else {
					rangeEnd = parsedEnd;
				}
				// Clamp range to actual content size
				int64_t contentSize = static_cast<int64_t>(content.size() - 1);
				rangeEnd = std::min(rangeEnd, contentSize);
				rangeStart = std::min(rangeStart, contentSize);
				if (rangeStart <= rangeEnd) {
					isRangeRequest = true;
				}
			}
		}

		// Extract the requested range
		std::string responseContent;
		if (isRangeRequest && rangeStart <= rangeEnd) {
			responseContent =
			    content.substr(static_cast<size_t>(rangeStart), static_cast<size_t>(rangeEnd - rangeStart + 1));
			response->code = 206; // Partial Content
			response->data.headers["Content-Range"] =
			    format("bytes %lld-%lld/%zu", rangeStart, rangeEnd, content.size());
			// For range requests, calculate MD5 of the partial content, not full content
			contentMD5 = HTTP::computeMD5Sum(responseContent);
		} else {
			responseContent = content;
			response->code = 200;
		}

		response->data.headers["ETag"] = etag;
		response->data.headers["Content-Type"] = "binary/octet-stream";
		response->data.headers["Content-MD5"] = contentMD5;

		// Write content to response
		response->data.contentLen = responseContent.size();
		response->data.headers["Content-Length"] = std::to_string(responseContent.size());
		response->data.content = new UnsentPacketQueue();

		if (!responseContent.empty()) {
			// Allocate extra byte for safety and ensure proper termination
			size_t bufferSize = responseContent.size() + 1; // Extra byte for safety
			PacketBuffer* buffer = PacketBuffer::create(bufferSize);

			// Copy content with explicit size check
			ASSERT(responseContent.size() <= buffer->size());
			memcpy(buffer->data(), responseContent.data(), responseContent.size());

			// Explicitly set the written bytes to exact content size (no extra byte)
			buffer->bytes_written = responseContent.size();

			// Zero out any remaining buffer space for safety
			if (buffer->size() > responseContent.size()) {
				memset(buffer->data() + responseContent.size(), 0, buffer->size() - responseContent.size());
			}

			// Add the buffer to the queue
			response->data.content->prependWriteBuffer(buffer, buffer);
		}

		return Void();
	}

	static Future<Void> handleDeleteObject(MockS3ServerImpl* self,
	                                       Reference<HTTP::IncomingRequest> req,
	                                       Reference<HTTP::OutgoingResponse> response,
	                                       std::string bucket,
	                                       std::string object) {

		TraceEvent("MockS3DeleteObject").detail("Bucket", bucket).detail("Object", object);

		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter != getGlobalStorage().buckets.end()) {
			bucketIter->second.erase(object);
		}

		response->code = 204; // No Content
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3ObjectDeleted").detail("Bucket", bucket).detail("Object", object);

		return Void();
	}

	static Future<Void> handleHeadObject(MockS3ServerImpl* self,
	                                     Reference<HTTP::IncomingRequest> req,
	                                     Reference<HTTP::OutgoingResponse> response,
	                                     std::string bucket,
	                                     std::string object) {

		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter == getGlobalStorage().buckets.end()) {
			TraceEvent("MockS3HeadObjectNoBucket")
			    .detail("Bucket", bucket)
			    .detail("Object", object)
			    .detail("AvailableBuckets", getGlobalStorage().buckets.size());
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchBucket", "Bucket not found");
			return Void();
		}

		auto objectIter = bucketIter->second.find(object);
		if (objectIter == bucketIter->second.end()) {
			TraceEvent("MockS3HeadObjectNoObject")
			    .detail("Bucket", bucket)
			    .detail("Object", object)
			    .detail("ObjectsInBucket", bucketIter->second.size());
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchKey", "Object not found");
			return Void();
		}

		const ObjectData& obj = objectIter->second;
		std::string etag = obj.etag;
		size_t contentSize = obj.content.size();
		std::string preview = contentSize > 0 ? obj.content.substr(0, std::min((size_t)20, contentSize)) : "EMPTY";

		TraceEvent("MockS3HeadObjectFound")
		    .detail("Bucket", bucket)
		    .detail("Object", object)
		    .detail("Size", contentSize)
		    .detail("Preview", preview);

		response->code = 200;
		response->data.headers["ETag"] = etag;
		response->data.headers["Content-Length"] = std::to_string(contentSize);
		response->data.headers["Content-Type"] = "binary/octet-stream";
		// HEAD requests need contentLen set to actual size for headers
		response->data.contentLen = contentSize; // This controls ResponseContentSize in HTTP logs

		return Void();
	}

	// S3 ListObjects Operation
	static Future<Void> handleListObjects(MockS3ServerImpl* self,
	                                      Reference<HTTP::IncomingRequest> req,
	                                      Reference<HTTP::OutgoingResponse> response,
	                                      std::string bucket,
	                                      std::map<std::string, std::string> queryParams) {

		TraceEvent("MockS3ListObjects").detail("Bucket", bucket).detail("QueryParamCount", queryParams.size());

		// Get query parameters for listing
		std::string prefix = queryParams.count("prefix") ? queryParams.at("prefix") : "";
		std::string delimiter = queryParams.count("delimiter") ? queryParams.at("delimiter") : "";
		int maxKeys = queryParams.count("max-keys") ? std::stoi(queryParams.at("max-keys")) : 1000;

		TraceEvent("MockS3ListObjectsDebug")
		    .detail("Bucket", bucket)
		    .detail("Prefix", prefix)
		    .detail("Delimiter", delimiter)
		    .detail("MaxKeys", maxKeys);

		// Find bucket
		auto bucketIter = getGlobalStorage().buckets.find(bucket);
		if (bucketIter == getGlobalStorage().buckets.end()) {
			self->sendError(response, HTTP::HTTP_STATUS_CODE_NOT_FOUND, "NoSuchBucket", "Bucket not found");
			return Void();
		}

		// Build list of matching objects
		std::string xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListBucketResult>\n";
		xml += "<Name>" + bucket + "</Name>\n";
		xml += "<Prefix>" + prefix + "</Prefix>\n";
		xml += "<MaxKeys>" + std::to_string(maxKeys) + "</MaxKeys>\n";
		xml += "<IsTruncated>false</IsTruncated>\n";

		int count = 0;
		for (const auto& objectPair : bucketIter->second) {
			const std::string& objectName = objectPair.first;
			const ObjectData& objectData = objectPair.second;

			// Apply prefix filter
			if (!prefix.empty() && objectName.find(prefix) != 0) {
				continue;
			}

			// Apply max-keys limit
			if (count >= maxKeys) {
				break;
			}

			xml += "<Contents>\n";
			xml += "<Key>" + objectName + "</Key>\n";
			xml += "<LastModified>" + std::to_string((int64_t)objectData.lastModified) + "</LastModified>\n";
			xml += "<ETag>" + objectData.etag + "</ETag>\n";
			xml += "<Size>" + std::to_string(objectData.content.size()) + "</Size>\n";
			xml += "<StorageClass>STANDARD</StorageClass>\n";
			xml += "</Contents>\n";

			count++;
		}

		xml += "</ListBucketResult>";

		self->sendXMLResponse(response, 200, xml);

		TraceEvent("MockS3ListObjectsCompleted")
		    .detail("Bucket", bucket)
		    .detail("Prefix", prefix)
		    .detail("ObjectCount", count);

		return Void();
	}

	// S3 Bucket Operations
	static Future<Void> handleHeadBucket(MockS3ServerImpl* self,
	                                     Reference<HTTP::IncomingRequest> req,
	                                     Reference<HTTP::OutgoingResponse> response,
	                                     std::string bucket) {

		TraceEvent("MockS3HeadBucket").detail("Bucket", bucket);

		// Ensure bucket exists in our storage (implicit creation like real S3)
		if (getGlobalStorage().buckets.find(bucket) == getGlobalStorage().buckets.end()) {
			getGlobalStorage().buckets[bucket] = std::map<std::string, ObjectData>();
		}

		response->code = 200;
		response->data.headers["Content-Type"] = "application/xml";
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3BucketHead").detail("Bucket", bucket);

		return Void();
	}

	static Future<Void> handlePutBucket(MockS3ServerImpl* self,
	                                    Reference<HTTP::IncomingRequest> req,
	                                    Reference<HTTP::OutgoingResponse> response,
	                                    std::string bucket) {

		TraceEvent("MockS3PutBucket").detail("Bucket", bucket);

		// Ensure bucket exists in our storage (implicit creation)
		if (getGlobalStorage().buckets.find(bucket) == getGlobalStorage().buckets.end()) {
			getGlobalStorage().buckets[bucket] = std::map<std::string, ObjectData>();
		}

		response->code = 200;
		response->data.headers["Content-Type"] = "application/xml";
		response->data.contentLen = 0;
		response->data.content = new UnsentPacketQueue(); // Required for HTTP header transmission

		TraceEvent("MockS3BucketCreated").detail("Bucket", bucket);

		return Void();
	}

	// Utility Methods

	void sendError(Reference<HTTP::OutgoingResponse> response,
	               int code,
	               const std::string& errorCode,
	               const std::string& message) {

		TraceEvent("MockS3Error").detail("Code", code).detail("ErrorCode", errorCode).detail("Message", message);

		std::string xml = format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
		                         "<Error>\n"
		                         "  <Code>%s</Code>\n"
		                         "  <Message>%s</Message>\n"
		                         "</Error>",
		                         errorCode.c_str(),
		                         message.c_str());

		sendXMLResponse(response, code, xml);
	}

	void sendXMLResponse(Reference<HTTP::OutgoingResponse> response, int code, const std::string& xml) {
		TraceEvent("MockS3SendXMLResponse_Start")
		    .detail("Code", code)
		    .detail("XMLSize", xml.size())
		    .detail("XMLPreview", xml.size() > 0 ? xml.substr(0, std::min((size_t)50, xml.size())) : "EMPTY");

		response->code = code;
		response->data.headers["Content-Type"] = "application/xml";
		response->data.headers["Content-Length"] = std::to_string(xml.size());
		response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(xml);

		// Actually put the XML content into the response
		if (xml.empty()) {
			response->data.contentLen = 0;
			TraceEvent("MockS3SendXMLResponse_Empty").detail("ResponseCode", response->code);
		} else {
			// Use PacketWriter to properly populate the content
			// The previous approach created an empty UnsentPacketQueue, causing memory corruption
			size_t contentSize = xml.size();

			response->data.content = new UnsentPacketQueue();
			response->data.contentLen = contentSize;

			PacketBuffer* buffer = response->data.content->getWriteBuffer(contentSize);
			PacketWriter pw(buffer, nullptr, Unversioned());
			pw.serializeBytes(xml);
			pw.finish();
		}

		TraceEvent("MockS3SendXMLResponse_Complete")
		    .detail("FinalCode", response->code)
		    .detail("FinalContentLen", response->data.contentLen)
		    .detail("XMLSize", xml.size());
	}

	std::map<std::string, std::string> parseTagsXML(const std::string& xml) {
		std::map<std::string, std::string> tags;

		// Simplified XML parsing for tags - this would need a proper XML parser in production
		std::regex tagRegex("<Tag><Key>([^<]+)</Key><Value>([^<]*)</Value></Tag>");
		std::sregex_iterator iter(xml.begin(), xml.end(), tagRegex);
		std::sregex_iterator end;

		for (; iter != end; ++iter) {
			std::string key = iter->str(1);
			std::string value = iter->str(2);
			tags[key] = value;

			TraceEvent("MockS3ParsedTag").detail("Key", key).detail("Value", value);
		}

		return tags;
	}

	std::string generateTagsXML(const std::map<std::string, std::string>& tags) {
		std::string xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Tagging><TagSet>";

		for (const auto& tag : tags) {
			xml += "<Tag><Key>" + tag.first + "</Key><Value>" + tag.second + "</Value></Tag>";
		}

		xml += "</TagSet></Tagging>";
		return xml;
	}
};

// Global registry to track registered servers and avoid conflicts
static std::map<std::string, bool> registeredServers;

// Clear global storage state for clean test runs
static void clearSingletonState() {
	getGlobalStorage().buckets.clear();
	getGlobalStorage().multipartUploads.clear();
	TraceEvent("MockS3ServerImpl_StateCleared");
}

// Request Handler Implementation - Each handler instance works with global storage
Future<Void> MockS3RequestHandler::handleRequest(Reference<HTTP::IncomingRequest> req,
                                                 Reference<HTTP::OutgoingResponse> response) {
	// Create a temporary instance just to use its static handleRequest method
	// All actual storage is in g_mockS3Storage which is truly global
	static MockS3ServerImpl serverInstance;
	return MockS3ServerImpl::handleRequest(&serverInstance, req, response);
}

Reference<HTTP::IRequestHandler> MockS3RequestHandler::clone() {
	// Prevent cloning during destruction to avoid "Pure virtual function called!" errors
	if (destructing) {
		TraceEvent(SevWarn, "MockS3RequestHandlerCloneDuringDestruction");
		return Reference<HTTP::IRequestHandler>();
	}
	return makeReference<MockS3RequestHandler>();
}

// Safe server registration that prevents conflicts
															#line 2564 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via registerMockS3Server()
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class RegisterMockS3ServerActor>
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class RegisterMockS3ServerActorState {
															#line 2571 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	RegisterMockS3ServerActorState(std::string const& ip,std::string const& port) 
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : ip(ip),
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		   port(port),
															#line 942 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		   serverKey(ip + ":" + port)
															#line 2582 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("registerMockS3Server", reinterpret_cast<unsigned long>(this));

	}
	~RegisterMockS3ServerActorState() 
	{
		fdb_probe_actor_destroy("registerMockS3Server", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 945 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent("MockS3ServerDiagnostic") .detail("Phase", "Registration Start") .detail("IP", ip) .detail("Port", port) .detail("ServerKey", serverKey) .detail("IsSimulated", g_network->isSimulated()) .detail("AlreadyRegistered", registeredServers.count(serverKey) > 0);
															#line 954 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (registeredServers.count(serverKey))
															#line 2599 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			{
															#line 955 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				TraceEvent(SevWarn, "MockS3ServerAlreadyRegistered").detail("Address", serverKey);
															#line 956 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				if (!static_cast<RegisterMockS3ServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterMockS3ServerActorState(); static_cast<RegisterMockS3ServerActor*>(this)->destroy(); return 0; }
															#line 2605 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				new (&static_cast<RegisterMockS3ServerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RegisterMockS3ServerActorState();
				static_cast<RegisterMockS3ServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 960 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				TraceEvent("MockS3ServerDiagnostic") .detail("Phase", "Calling registerSimHTTPServer") .detail("Address", serverKey);
															#line 964 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer(ip, port, makeReference<MockS3RequestHandler>());
															#line 964 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				if (static_cast<RegisterMockS3ServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2618 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RegisterMockS3ServerActor*>(this)->actor_wait_state = 1;
															#line 964 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterMockS3ServerActor, 0, Void >*>(static_cast<RegisterMockS3ServerActor*>(this)));
															#line 2623 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterMockS3ServerActorState();
		static_cast<RegisterMockS3ServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 982 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		if (!static_cast<RegisterMockS3ServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterMockS3ServerActorState(); static_cast<RegisterMockS3ServerActor*>(this)->destroy(); return 0; }
															#line 2652 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		new (&static_cast<RegisterMockS3ServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterMockS3ServerActorState();
		static_cast<RegisterMockS3ServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 974 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent(SevError, "MockS3ServerRegistrationFailed") .error(e) .detail("Address", serverKey) .detail("ErrorCode", e.code()) .detail("ErrorName", e.name());
															#line 979 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2667 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 965 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		registeredServers[serverKey] = true;
															#line 967 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerRegistered").detail("Address", serverKey).detail("Success", true);
															#line 969 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerDiagnostic") .detail("Phase", "Registration Complete") .detail("Address", serverKey) .detail("TotalRegistered", registeredServers.size());
															#line 2685 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 965 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		registeredServers[serverKey] = true;
															#line 967 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerRegistered").detail("Address", serverKey).detail("Success", true);
															#line 969 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerDiagnostic") .detail("Phase", "Registration Complete") .detail("Address", serverKey) .detail("TotalRegistered", registeredServers.size());
															#line 2698 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterMockS3ServerActor*>(this)->actor_wait_state > 0) static_cast<RegisterMockS3ServerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterMockS3ServerActor*>(this)->ActorCallback< RegisterMockS3ServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterMockS3ServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	std::string ip;
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	std::string port;
															#line 942 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	std::string serverKey;
															#line 2797 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via registerMockS3Server()
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class RegisterMockS3ServerActor final : public Actor<Void>, public ActorCallback< RegisterMockS3ServerActor, 0, Void >, public FastAllocated<RegisterMockS3ServerActor>, public RegisterMockS3ServerActorState<RegisterMockS3ServerActor> {
															#line 2802 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<RegisterMockS3ServerActor>::operator new;
	using FastAllocated<RegisterMockS3ServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7397898522927197184UL, 1469171628254068992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterMockS3ServerActor, 0, Void >;
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	RegisterMockS3ServerActor(std::string const& ip,std::string const& port) 
															#line 2819 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterMockS3ServerActorState<RegisterMockS3ServerActor>(ip, port),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerMockS3Server", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(136438951835161344UL, 9243222537172547840UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerMockS3Server");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerMockS3Server", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterMockS3ServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
[[nodiscard]] Future<Void> registerMockS3Server( std::string const& ip, std::string const& port ) {
															#line 941 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new RegisterMockS3ServerActor(ip, port));
															#line 2852 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}

#line 984 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

// Public Interface Implementation
															#line 2858 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via startMockS3Server()
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class StartMockS3ServerActor>
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class StartMockS3ServerActorState {
															#line 2865 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	StartMockS3ServerActorState(NetworkAddress const& listenAddress) 
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : listenAddress(listenAddress)
															#line 2872 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("startMockS3Server", reinterpret_cast<unsigned long>(this));

	}
	~StartMockS3ServerActorState() 
	{
		fdb_probe_actor_destroy("startMockS3Server", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 987 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent("MockS3ServerStarting").detail("ListenAddress", listenAddress.toString());
															#line 2887 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			try {
															#line 990 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				TraceEvent("MockS3ServerRegistering") .detail("IP", listenAddress.ip.toString()) .detail("Port", std::to_string(listenAddress.port)) .detail("IsSimulated", g_network->isSimulated());
															#line 995 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				StrictFuture<Void> __when_expr_0 = registerMockS3Server(listenAddress.ip.toString(), std::to_string(listenAddress.port));
															#line 995 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				if (static_cast<StartMockS3ServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2895 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StartMockS3ServerActor*>(this)->actor_wait_state = 1;
															#line 995 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMockS3ServerActor, 0, Void >*>(static_cast<StartMockS3ServerActor*>(this)));
															#line 2900 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMockS3ServerActorState();
		static_cast<StartMockS3ServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1006 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		if (!static_cast<StartMockS3ServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMockS3ServerActorState(); static_cast<StartMockS3ServerActor*>(this)->destroy(); return 0; }
															#line 2929 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		new (&static_cast<StartMockS3ServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMockS3ServerActorState();
		static_cast<StartMockS3ServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1002 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			TraceEvent(SevError, "MockS3ServerStartError").error(e).detail("ListenAddress", listenAddress.toString());
															#line 1003 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2944 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 997 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerStarted") .detail("ListenAddress", listenAddress.toString()) .detail("HandlerCreated", true);
															#line 2958 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 997 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		TraceEvent("MockS3ServerStarted") .detail("ListenAddress", listenAddress.toString()) .detail("HandlerCreated", true);
															#line 2967 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMockS3ServerActor*>(this)->actor_wait_state > 0) static_cast<StartMockS3ServerActor*>(this)->actor_wait_state = 0;
		static_cast<StartMockS3ServerActor*>(this)->ActorCallback< StartMockS3ServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMockS3ServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMockS3ServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMockS3ServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3Server", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	NetworkAddress listenAddress;
															#line 3062 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via startMockS3Server()
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class StartMockS3ServerActor final : public Actor<Void>, public ActorCallback< StartMockS3ServerActor, 0, Void >, public FastAllocated<StartMockS3ServerActor>, public StartMockS3ServerActorState<StartMockS3ServerActor> {
															#line 3067 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<StartMockS3ServerActor>::operator new;
	using FastAllocated<StartMockS3ServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8385566710444229888UL, 2361634579559451904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMockS3ServerActor, 0, Void >;
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	StartMockS3ServerActor(NetworkAddress const& listenAddress) 
															#line 3084 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   StartMockS3ServerActorState<StartMockS3ServerActor>(listenAddress),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMockS3Server", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16442790091880884736UL, 12597676879247326208UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMockS3Server");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMockS3Server", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMockS3ServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
[[nodiscard]] Future<Void> startMockS3Server( NetworkAddress const& listenAddress ) {
															#line 986 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new StartMockS3ServerActor(listenAddress));
															#line 3117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}

#line 1008 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

// Clear all MockS3 global storage - called at the start of each simulation test
void clearMockS3Storage() {
	getGlobalStorage().clearStorage();
}

// Unit Tests for MockS3Server
															#line 3128 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1015()
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1015Actor>
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1015ActorState {
															#line 3135 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1015ActorState(UnitTestParameters const& params) 
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3142 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1015", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1015ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1015", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1017 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1018 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?region=us-east-1";
															#line 1019 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1020 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1022 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1024 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1025 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(object == "");
															#line 1026 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1028 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1015Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1015ActorState(); static_cast<FlowTestCase1015Actor*>(this)->destroy(); return 0; }
															#line 3173 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1015Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1015ActorState();
			static_cast<FlowTestCase1015Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1015ActorState();
		static_cast<FlowTestCase1015Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3197 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1015()
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1015Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1015Actor>, public FlowTestCase1015ActorState<FlowTestCase1015Actor> {
															#line 3202 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1015Actor>::operator new;
	using FastAllocated<FlowTestCase1015Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3877503335838447360UL, 2703672985368366336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1015Actor(UnitTestParameters const& params) 
															#line 3218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1015ActorState<FlowTestCase1015Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1015", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3812477932913287168UL, 7090766821766077184UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1015Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1015");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1015", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1015( UnitTestParameters const& params ) {
															#line 1015 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1015Actor(params));
															#line 3250 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1015, "/MockS3Server/parseS3Request/ValidBucketParameter")

#line 1030 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3256 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1031()
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1031Actor>
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1031ActorState {
															#line 3263 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1031ActorState(UnitTestParameters const& params) 
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3270 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1031", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1031ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1031", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1033 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1034 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/?region=us-east-1";
															#line 1035 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1036 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 3291 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			try {
															#line 1039 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				server.parseS3Request(resource, bucket, object, queryParams);
															#line 1040 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				ASSERT(false);
															#line 3297 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1031ActorState();
		static_cast<FlowTestCase1031Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1045 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		if (!static_cast<FlowTestCase1031Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1031ActorState(); static_cast<FlowTestCase1031Actor*>(this)->destroy(); return 0; }
															#line 3326 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		new (&static_cast<FlowTestCase1031Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1031ActorState();
		static_cast<FlowTestCase1031Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1042 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(e.code() == error_code_backup_invalid_url);
															#line 3339 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3365 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1031()
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1031Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1031Actor>, public FlowTestCase1031ActorState<FlowTestCase1031Actor> {
															#line 3370 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1031Actor>::operator new;
	using FastAllocated<FlowTestCase1031Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3519293026333635328UL, 8089641847222075904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1031Actor(UnitTestParameters const& params) 
															#line 3386 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1031ActorState<FlowTestCase1031Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1031", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(825080800175505664UL, 970603457421494272UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1031Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1031");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1031", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1031( UnitTestParameters const& params ) {
															#line 1031 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1031Actor(params));
															#line 3418 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1031, "/MockS3Server/parseS3Request/MissingBucketParameter")

#line 1047 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3424 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1048()
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1048Actor>
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1048ActorState {
															#line 3431 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1048ActorState(UnitTestParameters const& params) 
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3438 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1048", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1048ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1048", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1050 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1051 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/";
															#line 1052 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1053 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 3459 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			try {
															#line 1056 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				server.parseS3Request(resource, bucket, object, queryParams);
															#line 1057 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
				ASSERT(false);
															#line 3465 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1048ActorState();
		static_cast<FlowTestCase1048Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1062 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		if (!static_cast<FlowTestCase1048Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1048ActorState(); static_cast<FlowTestCase1048Actor*>(this)->destroy(); return 0; }
															#line 3494 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		new (&static_cast<FlowTestCase1048Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1048ActorState();
		static_cast<FlowTestCase1048Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1059 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(e.code() == error_code_backup_invalid_url);
															#line 3507 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3533 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1048()
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1048Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1048Actor>, public FlowTestCase1048ActorState<FlowTestCase1048Actor> {
															#line 3538 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1048Actor>::operator new;
	using FastAllocated<FlowTestCase1048Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16498136524404557824UL, 11616820629017592576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1048Actor(UnitTestParameters const& params) 
															#line 3554 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1048ActorState<FlowTestCase1048Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1048", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15207665966182469376UL, 737070286398641408UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1048Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1048");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1048", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1048( UnitTestParameters const& params ) {
															#line 1048 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1048Actor(params));
															#line 3586 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1048, "/MockS3Server/parseS3Request/EmptyQueryString")

#line 1064 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3592 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1065()
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1065Actor>
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1065ActorState {
															#line 3599 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1065ActorState(UnitTestParameters const& params) 
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3606 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1065", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1065ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1065", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1067 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1068 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket/testobject?region=us-east-1";
															#line 1069 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1070 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1072 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1074 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1075 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(object == "testobject");
															#line 1076 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1078 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1065Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1065ActorState(); static_cast<FlowTestCase1065Actor*>(this)->destroy(); return 0; }
															#line 3637 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1065Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1065ActorState();
			static_cast<FlowTestCase1065Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1065ActorState();
		static_cast<FlowTestCase1065Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3661 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1065()
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1065Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1065Actor>, public FlowTestCase1065ActorState<FlowTestCase1065Actor> {
															#line 3666 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1065Actor>::operator new;
	using FastAllocated<FlowTestCase1065Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6355427122203591680UL, 18442468953643758336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1065Actor(UnitTestParameters const& params) 
															#line 3682 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1065ActorState<FlowTestCase1065Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1065", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17581527275094042880UL, 7420188085661979392UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1065Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1065");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1065", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1065( UnitTestParameters const& params ) {
															#line 1065 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1065Actor(params));
															#line 3714 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1065, "/MockS3Server/parseS3Request/BucketParameterOverride")

#line 1080 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3720 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1081()
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1081Actor>
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1081ActorState {
															#line 3727 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1081ActorState(UnitTestParameters const& params) 
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3734 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1081", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1081ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1081", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1083 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1084 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket/folder/subfolder/file.txt?region=us-east-1";
															#line 1085 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1086 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1088 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1090 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1091 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(object == "folder/subfolder/file.txt");
															#line 1092 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1094 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1081Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1081ActorState(); static_cast<FlowTestCase1081Actor*>(this)->destroy(); return 0; }
															#line 3765 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1081Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1081ActorState();
			static_cast<FlowTestCase1081Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1081ActorState();
		static_cast<FlowTestCase1081Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3789 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1081()
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1081Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1081Actor>, public FlowTestCase1081ActorState<FlowTestCase1081Actor> {
															#line 3794 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1081Actor>::operator new;
	using FastAllocated<FlowTestCase1081Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9525860488893729792UL, 16574408805449275648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1081Actor(UnitTestParameters const& params) 
															#line 3810 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1081ActorState<FlowTestCase1081Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1081", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7515603536340593664UL, 3485025767169992192UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1081Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1081");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1081", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1081( UnitTestParameters const& params ) {
															#line 1081 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1081Actor(params));
															#line 3842 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1081, "/MockS3Server/parseS3Request/ComplexPath")

#line 1096 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3848 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1097()
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1097Actor>
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1097ActorState {
															#line 3855 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1097ActorState(UnitTestParameters const& params) 
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3862 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1097", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1097ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1097", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1099 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1100 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?region=us-east-1&param=value%3Dtest";
															#line 1101 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1102 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1104 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1106 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1107 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1108 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["param"] == "value=test");
															#line 1110 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1097Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1097ActorState(); static_cast<FlowTestCase1097Actor*>(this)->destroy(); return 0; }
															#line 3893 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1097Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1097ActorState();
			static_cast<FlowTestCase1097Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1097ActorState();
		static_cast<FlowTestCase1097Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 3917 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1097()
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1097Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1097Actor>, public FlowTestCase1097ActorState<FlowTestCase1097Actor> {
															#line 3922 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1097Actor>::operator new;
	using FastAllocated<FlowTestCase1097Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14820385722799510528UL, 14430002958124823552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1097Actor(UnitTestParameters const& params) 
															#line 3938 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1097ActorState<FlowTestCase1097Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1097", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2213854916378189824UL, 3074970101658865664UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1097Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1097");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1097", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1097( UnitTestParameters const& params ) {
															#line 1097 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1097Actor(params));
															#line 3970 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1097, "/MockS3Server/parseS3Request/URLEncodedParameters")

#line 1112 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 3976 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1113()
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1113Actor>
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1113ActorState {
															#line 3983 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1113ActorState(UnitTestParameters const& params) 
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 3990 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1113", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1113ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1113", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1115 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1116 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?region=us-east-1";
															#line 1117 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1118 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1120 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1122 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1123 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(object == "");
															#line 1124 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1126 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1113Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1113ActorState(); static_cast<FlowTestCase1113Actor*>(this)->destroy(); return 0; }
															#line 4021 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1113Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1113ActorState();
			static_cast<FlowTestCase1113Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1113ActorState();
		static_cast<FlowTestCase1113Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4045 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1113()
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1113Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1113Actor>, public FlowTestCase1113ActorState<FlowTestCase1113Actor> {
															#line 4050 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1113Actor>::operator new;
	using FastAllocated<FlowTestCase1113Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(384278925820255488UL, 209171832323109376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1113Actor(UnitTestParameters const& params) 
															#line 4066 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1113ActorState<FlowTestCase1113Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1113", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18346601158508310528UL, 11007129436963234048UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1113Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1113");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1113", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1113( UnitTestParameters const& params ) {
															#line 1113 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1113Actor(params));
															#line 4098 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1113, "/MockS3Server/parseS3Request/EmptyPath")

#line 1128 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4104 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1129()
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1129Actor>
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1129ActorState {
															#line 4111 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1129ActorState(UnitTestParameters const& params) 
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4118 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1129", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1129ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1129", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1131 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1132 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?region=us-east-1";
															#line 1133 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1134 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1136 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1138 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1139 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(object == "");
															#line 1140 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1142 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1129Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1129ActorState(); static_cast<FlowTestCase1129Actor*>(this)->destroy(); return 0; }
															#line 4149 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1129Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1129ActorState();
			static_cast<FlowTestCase1129Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1129ActorState();
		static_cast<FlowTestCase1129Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4173 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1129()
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1129Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1129Actor>, public FlowTestCase1129ActorState<FlowTestCase1129Actor> {
															#line 4178 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1129Actor>::operator new;
	using FastAllocated<FlowTestCase1129Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14934230730369463296UL, 821581104518392064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1129Actor(UnitTestParameters const& params) 
															#line 4194 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1129ActorState<FlowTestCase1129Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1129", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6368029775182043392UL, 936202929277614848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1129Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1129");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1129", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1129( UnitTestParameters const& params ) {
															#line 1129 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1129Actor(params));
															#line 4226 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1129, "/MockS3Server/parseS3Request/OnlyBucketInPath")

#line 1144 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4232 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1145()
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1145Actor>
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1145ActorState {
															#line 4239 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1145ActorState(UnitTestParameters const& params) 
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4246 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1145", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1145ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1145", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1147 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1148 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?region=us-east-1&version=1&encoding=utf8";
															#line 1149 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1150 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1152 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1154 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1155 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1156 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["version"] == "1");
															#line 1157 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["encoding"] == "utf8");
															#line 1158 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams.size() == 3);
															#line 1160 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1145Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1145ActorState(); static_cast<FlowTestCase1145Actor*>(this)->destroy(); return 0; }
															#line 4281 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1145Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1145ActorState();
			static_cast<FlowTestCase1145Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1145ActorState();
		static_cast<FlowTestCase1145Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4305 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1145()
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1145Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1145Actor>, public FlowTestCase1145ActorState<FlowTestCase1145Actor> {
															#line 4310 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1145Actor>::operator new;
	using FastAllocated<FlowTestCase1145Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12033355530775517184UL, 8626252279276581376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1145Actor(UnitTestParameters const& params) 
															#line 4326 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1145ActorState<FlowTestCase1145Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1145", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1859802730249122816UL, 4820753984493874688UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1145Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1145");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1145", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1145( UnitTestParameters const& params ) {
															#line 1145 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1145Actor(params));
															#line 4358 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1145, "/MockS3Server/parseS3Request/MultipleParameters")

#line 1162 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4364 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1163()
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1163Actor>
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1163ActorState {
															#line 4371 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1163ActorState(UnitTestParameters const& params) 
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4378 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1163", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1163ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1163", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1165 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			MockS3ServerImpl server;
															#line 1166 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string resource = "/testbucket?flag&region=us-east-1";
															#line 1167 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string bucket, object;
															#line 1168 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::map<std::string, std::string> queryParams;
															#line 1170 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			server.parseS3Request(resource, bucket, object, queryParams);
															#line 1172 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(bucket == "testbucket");
															#line 1173 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["flag"] == "");
															#line 1174 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(queryParams["region"] == "us-east-1");
															#line 1176 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1163ActorState(); static_cast<FlowTestCase1163Actor*>(this)->destroy(); return 0; }
															#line 4409 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1163Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1163ActorState();
			static_cast<FlowTestCase1163Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1163ActorState();
		static_cast<FlowTestCase1163Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4433 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1163()
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1163Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1163Actor>, public FlowTestCase1163ActorState<FlowTestCase1163Actor> {
															#line 4438 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1163Actor>::operator new;
	using FastAllocated<FlowTestCase1163Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15301578210844026624UL, 5474588509747114240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1163Actor(UnitTestParameters const& params) 
															#line 4454 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1163ActorState<FlowTestCase1163Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1163", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15274873081752066560UL, 7647282446148918528UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1163Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1163");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1163", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1163( UnitTestParameters const& params ) {
															#line 1163 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1163Actor(params));
															#line 4486 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1163, "/MockS3Server/parseS3Request/ParametersWithoutValues")

#line 1178 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4492 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1179()
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1179Actor>
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1179ActorState {
															#line 4499 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1179ActorState(UnitTestParameters const& params) 
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4506 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1179", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1179ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1179", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1180 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=0-99";
															#line 1181 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1183 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1185 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == true);
															#line 1186 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeStart == 0);
															#line 1187 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeEnd == 99);
															#line 1189 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1179Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1179ActorState(); static_cast<FlowTestCase1179Actor*>(this)->destroy(); return 0; }
															#line 4533 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1179Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1179ActorState();
			static_cast<FlowTestCase1179Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1179ActorState();
		static_cast<FlowTestCase1179Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4557 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1179()
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1179Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1179Actor>, public FlowTestCase1179ActorState<FlowTestCase1179Actor> {
															#line 4562 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1179Actor>::operator new;
	using FastAllocated<FlowTestCase1179Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3015591742385059072UL, 14129415317436519168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1179Actor(UnitTestParameters const& params) 
															#line 4578 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1179ActorState<FlowTestCase1179Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1179", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15336174766491171328UL, 16214064274901972992UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1179Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1179");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1179", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1179( UnitTestParameters const& params ) {
															#line 1179 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1179Actor(params));
															#line 4610 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1179, "/MockS3Server/RangeHeader/SimpleByteRange")

#line 1191 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4616 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1192()
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1192Actor>
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1192ActorState {
															#line 4623 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1192ActorState(UnitTestParameters const& params) 
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4630 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1192", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1192ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1192", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1193 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=100-199";
															#line 1194 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1196 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1198 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == true);
															#line 1199 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeStart == 100);
															#line 1200 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeEnd == 199);
															#line 1202 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1192Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1192ActorState(); static_cast<FlowTestCase1192Actor*>(this)->destroy(); return 0; }
															#line 4657 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1192Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1192ActorState();
			static_cast<FlowTestCase1192Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1192ActorState();
		static_cast<FlowTestCase1192Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4681 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1192()
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1192Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1192Actor>, public FlowTestCase1192ActorState<FlowTestCase1192Actor> {
															#line 4686 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1192Actor>::operator new;
	using FastAllocated<FlowTestCase1192Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10120946613311992576UL, 8815672972884569600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1192Actor(UnitTestParameters const& params) 
															#line 4702 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1192ActorState<FlowTestCase1192Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1192", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(366317847513759744UL, 16757491572153918976UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1192Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1192");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1192", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1192( UnitTestParameters const& params ) {
															#line 1192 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1192Actor(params));
															#line 4734 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1192, "/MockS3Server/RangeHeader/MiddleRange")

#line 1204 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4740 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1205()
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1205Actor>
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1205ActorState {
															#line 4747 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1205ActorState(UnitTestParameters const& params) 
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4754 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1205", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1205ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1205", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1206 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=1000000-1999999";
															#line 1207 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1209 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1211 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == true);
															#line 1212 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeStart == 1000000);
															#line 1213 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeEnd == 1999999);
															#line 1215 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1205Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1205ActorState(); static_cast<FlowTestCase1205Actor*>(this)->destroy(); return 0; }
															#line 4781 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1205Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1205ActorState();
			static_cast<FlowTestCase1205Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1205ActorState();
		static_cast<FlowTestCase1205Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4805 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1205()
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1205Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1205Actor>, public FlowTestCase1205ActorState<FlowTestCase1205Actor> {
															#line 4810 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1205Actor>::operator new;
	using FastAllocated<FlowTestCase1205Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4473461002178301184UL, 12362554304617341440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1205Actor(UnitTestParameters const& params) 
															#line 4826 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1205ActorState<FlowTestCase1205Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1205", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17821004892837753344UL, 17836952484667602432UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1205Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1205");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1205", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1205( UnitTestParameters const& params ) {
															#line 1205 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1205Actor(params));
															#line 4858 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1205, "/MockS3Server/RangeHeader/LargeOffsets")

#line 1217 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4864 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1218()
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1218Actor>
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1218ActorState {
															#line 4871 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1218ActorState(UnitTestParameters const& params) 
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4878 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1218", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1218ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1218", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1219 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "invalid-range";
															#line 1220 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1222 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1224 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == false);
															#line 1226 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1218Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1218ActorState(); static_cast<FlowTestCase1218Actor*>(this)->destroy(); return 0; }
															#line 4901 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1218Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1218ActorState();
			static_cast<FlowTestCase1218Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1218ActorState();
		static_cast<FlowTestCase1218Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 4925 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1218()
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1218Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1218Actor>, public FlowTestCase1218ActorState<FlowTestCase1218Actor> {
															#line 4930 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1218Actor>::operator new;
	using FastAllocated<FlowTestCase1218Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5967266297262931456UL, 11515167001969193984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1218Actor(UnitTestParameters const& params) 
															#line 4946 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1218ActorState<FlowTestCase1218Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1218", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11494602577093891584UL, 15288306069414558720UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1218Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1218");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1218", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1218( UnitTestParameters const& params ) {
															#line 1218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1218Actor(params));
															#line 4978 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1218, "/MockS3Server/RangeHeader/InvalidFormat")

#line 1228 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 4984 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1229()
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1229Actor>
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1229ActorState {
															#line 4991 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1229ActorState(UnitTestParameters const& params) 
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 4998 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1229", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1229ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1229", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1230 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "0-99";
															#line 1231 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1233 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1235 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == false);
															#line 1237 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1229Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1229ActorState(); static_cast<FlowTestCase1229Actor*>(this)->destroy(); return 0; }
															#line 5021 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1229Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1229ActorState();
			static_cast<FlowTestCase1229Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1229ActorState();
		static_cast<FlowTestCase1229Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 5045 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1229()
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1229Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1229Actor>, public FlowTestCase1229ActorState<FlowTestCase1229Actor> {
															#line 5050 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1229Actor>::operator new;
	using FastAllocated<FlowTestCase1229Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11682391896286724352UL, 7903551183516952576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1229Actor(UnitTestParameters const& params) 
															#line 5066 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1229ActorState<FlowTestCase1229Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1229", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2321683565732570880UL, 17492162973512935936UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1229Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1229");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1229", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1229( UnitTestParameters const& params ) {
															#line 1229 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1229Actor(params));
															#line 5098 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1229, "/MockS3Server/RangeHeader/MissingBytesPrefix")

#line 1239 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 5104 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1240()
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1240Actor>
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1240ActorState {
															#line 5111 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1240ActorState(UnitTestParameters const& params) 
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 5118 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1240", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1240ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1240", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1241 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=0";
															#line 1242 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1244 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1246 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == false);
															#line 1248 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1240Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1240ActorState(); static_cast<FlowTestCase1240Actor*>(this)->destroy(); return 0; }
															#line 5141 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1240Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1240ActorState();
			static_cast<FlowTestCase1240Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1240ActorState();
		static_cast<FlowTestCase1240Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 5165 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1240()
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1240Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1240Actor>, public FlowTestCase1240ActorState<FlowTestCase1240Actor> {
															#line 5170 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1240Actor>::operator new;
	using FastAllocated<FlowTestCase1240Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1116485069497942272UL, 15681660180032687360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1240Actor(UnitTestParameters const& params) 
															#line 5186 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1240ActorState<FlowTestCase1240Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1240", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7143370043820086016UL, 12927993156012013568UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1240Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1240");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1240", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1240( UnitTestParameters const& params ) {
															#line 1240 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1240Actor(params));
															#line 5218 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1240, "/MockS3Server/RangeHeader/MissingDash")

#line 1250 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 5224 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1251()
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1251Actor>
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1251ActorState {
															#line 5231 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1251ActorState(UnitTestParameters const& params) 
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 5238 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1251", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1251ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1251", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1252 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "";
															#line 1253 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1255 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1257 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == false);
															#line 1259 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1251Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1251ActorState(); static_cast<FlowTestCase1251Actor*>(this)->destroy(); return 0; }
															#line 5261 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1251Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1251ActorState();
			static_cast<FlowTestCase1251Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1251ActorState();
		static_cast<FlowTestCase1251Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 5285 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1251()
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1251Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1251Actor>, public FlowTestCase1251ActorState<FlowTestCase1251Actor> {
															#line 5290 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1251Actor>::operator new;
	using FastAllocated<FlowTestCase1251Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(434157594269863168UL, 6489737666799399168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1251Actor(UnitTestParameters const& params) 
															#line 5306 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1251ActorState<FlowTestCase1251Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1251", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7962348396629079296UL, 6145596010919706624UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1251Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1251");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1251", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1251( UnitTestParameters const& params ) {
															#line 1251 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1251Actor(params));
															#line 5338 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1251, "/MockS3Server/RangeHeader/EmptyString")

#line 1261 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 5344 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1262()
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1262Actor>
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1262ActorState {
															#line 5351 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1262ActorState(UnitTestParameters const& params) 
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 5358 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1262", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1262ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1262", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1263 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=-100-200";
															#line 1264 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1266 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1269 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == false);
															#line 1271 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1262Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1262ActorState(); static_cast<FlowTestCase1262Actor*>(this)->destroy(); return 0; }
															#line 5381 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1262Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1262ActorState();
			static_cast<FlowTestCase1262Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1262ActorState();
		static_cast<FlowTestCase1262Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 5405 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1262()
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1262Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1262Actor>, public FlowTestCase1262ActorState<FlowTestCase1262Actor> {
															#line 5410 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1262Actor>::operator new;
	using FastAllocated<FlowTestCase1262Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17454284733207963904UL, 17988035565918769920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1262Actor(UnitTestParameters const& params) 
															#line 5426 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1262ActorState<FlowTestCase1262Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1262", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1455921668778819584UL, 14961196141099579392UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1262Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1262");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1262", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1262( UnitTestParameters const& params ) {
															#line 1262 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1262Actor(params));
															#line 5458 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1262, "/MockS3Server/RangeHeader/NegativeStart")

#line 1273 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"

															#line 5464 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1274()
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
template <class FlowTestCase1274Actor>
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1274ActorState {
															#line 5471 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1274ActorState(UnitTestParameters const& params) 
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
		 : params(params)
															#line 5478 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1274", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1274ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1274", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1275 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			std::string rangeHeader = "bytes=200-100";
															#line 1276 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			int64_t rangeStart, rangeEnd;
															#line 1278 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			bool result = MockS3ServerImpl::parseRangeHeader(rangeHeader, rangeStart, rangeEnd);
															#line 1281 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(result == true);
															#line 1282 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeStart == 200);
															#line 1283 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			ASSERT(rangeEnd == 100);
															#line 1285 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
			if (!static_cast<FlowTestCase1274Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1274ActorState(); static_cast<FlowTestCase1274Actor*>(this)->destroy(); return 0; }
															#line 5505 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
			new (&static_cast<FlowTestCase1274Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1274ActorState();
			static_cast<FlowTestCase1274Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1274ActorState();
		static_cast<FlowTestCase1274Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	UnitTestParameters params;
															#line 5529 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1274()
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
class FlowTestCase1274Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1274Actor>, public FlowTestCase1274ActorState<FlowTestCase1274Actor> {
															#line 5534 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1274Actor>::operator new;
	using FastAllocated<FlowTestCase1274Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7312314187059482880UL, 2026744038091668480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	FlowTestCase1274Actor(UnitTestParameters const& params) 
															#line 5550 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1274ActorState<FlowTestCase1274Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1274", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3576904710435139328UL, 8985613899637480960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1274");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1274", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
static Future<Void> flowTestCase1274( UnitTestParameters const& params ) {
															#line 1274 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
	return Future<Void>(new FlowTestCase1274Actor(params));
															#line 5582 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3Server.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1274, "/MockS3Server/RangeHeader/StartGreaterThanEnd")

#line 1287 "/codebuild/output/src121764822/src/github.com/apple/foundationdb/fdbserver/MockS3Server.actor.cpp"
