#include "fdbclient/FDBOptions.g.h"

FDBOptionInfoMap<FDBNetworkOptions> FDBNetworkOptions::optionInfo;

void FDBNetworkOptions::init() {
	ADD_OPTION_INFO(FDBNetworkOptions, LOCAL_ADDRESS, "LOCAL_ADDRESS", "Deprecated", "(String) IP:PORT", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, CLUSTER_FILE, "CLUSTER_FILE", "Deprecated", "(String) path to cluster file", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_ENABLE, "TRACE_ENABLE", "Enables trace output to a file in a directory of the clients choosing", "(String) path to output directory (or NULL for current working directory)", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_ROLL_SIZE, "TRACE_ROLL_SIZE", "Sets the maximum size in bytes of a single trace output file. This value should be in the range ``[0, INT64_MAX]``. If the value is set to 0, there is no limit on individual file size. The default is a maximum size of 10,485,760 bytes.", "(Int) max size of a single trace output file", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_MAX_LOGS_SIZE, "TRACE_MAX_LOGS_SIZE", "Sets the maximum size of all the trace output files put together. This value should be in the range ``[0, INT64_MAX]``. If the value is set to 0, there is no limit on the total size of the files. The default is a maximum size of 104,857,600 bytes. If the default roll size is used, this means that a maximum of 10 trace files will be written at a time.", "(Int) max total size of trace files", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_LOG_GROUP, "TRACE_LOG_GROUP", "Sets the 'LogGroup' attribute with the specified value for all events in the trace output files. The default log group is 'default'.", "(String) value of the LogGroup attribute", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_FORMAT, "TRACE_FORMAT", "Select the format of the log files. xml (the default) and json are supported.", "(String) Format of trace files", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_CLOCK_SOURCE, "TRACE_CLOCK_SOURCE", "Select clock source for trace files. now (the default) or realtime are supported.", "(String) Trace clock source", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_FILE_IDENTIFIER, "TRACE_FILE_IDENTIFIER", "Once provided, this string will be used to replace the port/PID in the log file names.", "(String) The identifier that will be part of all trace file names", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_SHARE_AMONG_CLIENT_THREADS, "TRACE_SHARE_AMONG_CLIENT_THREADS", "Use the same base trace file name for all client threads as it did before version 7.2. The current default behavior is to use distinct trace file names for client threads by including their version and thread index.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_INITIALIZE_ON_SETUP, "TRACE_INITIALIZE_ON_SETUP", "Initialize trace files on network setup, determine the local IP later. Otherwise tracing is initialized when opening the first database.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, TRACE_PARTIAL_FILE_SUFFIX, "TRACE_PARTIAL_FILE_SUFFIX", "Set file suffix for partially written log files.", "(String) Append this suffix to partially written log files. When a log file is complete, it is renamed to remove the suffix. No separator is added between the file and the suffix. If you want to add a file extension, you should include the separator - e.g. '.tmp' instead of 'tmp' to add the 'tmp' extension.", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, KNOB, "KNOB", "Set internal tuning or debugging knobs", "(String) knob_name=knob_value", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_PLUGIN, "TLS_PLUGIN", "Deprecated", "(String) file path or linker-resolved name", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_CERT_BYTES, "TLS_CERT_BYTES", "Set the certificate chain", "(Bytes) certificates", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_CERT_PATH, "TLS_CERT_PATH", "Set the file from which to load the certificate chain", "(String) file path", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_KEY_BYTES, "TLS_KEY_BYTES", "Set the private key corresponding to your own certificate", "(Bytes) key", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_KEY_PATH, "TLS_KEY_PATH", "Set the file from which to load the private key corresponding to your own certificate", "(String) file path", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_VERIFY_PEERS, "TLS_VERIFY_PEERS", "Set the peer certificate field verification criteria", "(Bytes) verification pattern", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBNetworkOptions, BUGGIFY_ENABLE, "BUGGIFY_ENABLE", "", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, BUGGIFY_DISABLE, "BUGGIFY_DISABLE", "", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, BUGGIFY_SECTION_ACTIVATED_PROBABILITY, "BUGGIFY_SECTION_ACTIVATED_PROBABILITY", "Set the probability of a BUGGIFY section being active for the current execution.  Only applies to code paths first traversed AFTER this option is changed.", "(Int) probability expressed as a percentage between 0 and 100", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, BUGGIFY_SECTION_FIRED_PROBABILITY, "BUGGIFY_SECTION_FIRED_PROBABILITY", "Set the probability of an active BUGGIFY section being fired", "(Int) probability expressed as a percentage between 0 and 100", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_CA_BYTES, "TLS_CA_BYTES", "Set the ca bundle", "(Bytes) ca bundle", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_CA_PATH, "TLS_CA_PATH", "Set the file from which to load the certificate authority bundle", "(String) file path", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_PASSWORD, "TLS_PASSWORD", "Set the passphrase for encrypted private key. Password should be set before setting the key for the password to be used.", "(String) key passphrase", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, TLS_DISABLE_PLAINTEXT_CONNECTION, "TLS_DISABLE_PLAINTEXT_CONNECTION", "Prevent client from connecting to a non-TLS endpoint by throwing network connection failed error.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, DISABLE_MULTI_VERSION_CLIENT_API, "DISABLE_MULTI_VERSION_CLIENT_API", "Disables the multi-version client API and instead uses the local client directly. Must be set before setting up the network.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, CALLBACKS_ON_EXTERNAL_THREADS, "CALLBACKS_ON_EXTERNAL_THREADS", "If set, callbacks from external client libraries can be called from threads created by the FoundationDB client library. Otherwise, callbacks will be called from either the thread used to add the callback or the network thread. Setting this option can improve performance when connected using an external client, but may not be safe to use in all environments. Must be set before setting up the network. WARNING: This feature is considered experimental at this time.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, EXTERNAL_CLIENT_LIBRARY, "EXTERNAL_CLIENT_LIBRARY", "Adds an external client library for use by the multi-version client API. Must be set before setting up the network.", "(String) path to client library", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, EXTERNAL_CLIENT_DIRECTORY, "EXTERNAL_CLIENT_DIRECTORY", "Searches the specified path for dynamic libraries and adds them to the list of client libraries for use by the multi-version client API. Must be set before setting up the network.", "(String) path to directory containing client libraries", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, DISABLE_LOCAL_CLIENT, "DISABLE_LOCAL_CLIENT", "Prevents connections through the local client, allowing only connections through externally loaded client libraries.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_THREADS_PER_VERSION, "CLIENT_THREADS_PER_VERSION", "Spawns multiple worker threads for each version of the client that is loaded.  Setting this to a number greater than one implies disable_local_client.", "(Int) Number of client threads to be spawned.  Each cluster will be serviced by a single client thread.", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, FUTURE_VERSION_CLIENT_LIBRARY, "FUTURE_VERSION_CLIENT_LIBRARY", "Adds an external client library to be used with a future version protocol. This option can be used testing purposes only!", "(String) path to client library", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, RETAIN_CLIENT_LIBRARY_COPIES, "RETAIN_CLIENT_LIBRARY_COPIES", "Retain temporary external client library copies that are created for enabling multi-threading.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, IGNORE_EXTERNAL_CLIENT_FAILURES, "IGNORE_EXTERNAL_CLIENT_FAILURES", "Ignore the failure to initialize some of the external clients", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, FAIL_INCOMPATIBLE_CLIENT, "FAIL_INCOMPATIBLE_CLIENT", "Fail with an error if there is no client matching the server version the client is connecting to", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, DISABLE_CLIENT_STATISTICS_LOGGING, "DISABLE_CLIENT_STATISTICS_LOGGING", "Disables logging of client statistics, such as sampled transaction activity.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, ENABLE_SLOW_TASK_PROFILING, "ENABLE_SLOW_TASK_PROFILING", "Deprecated", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, ENABLE_RUN_LOOP_PROFILING, "ENABLE_RUN_LOOP_PROFILING", "Enables debugging feature to perform run loop profiling. Requires trace logging to be enabled. WARNING: this feature is not recommended for use in production.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, DISABLE_CLIENT_BYPASS, "DISABLE_CLIENT_BYPASS", "Prevents the multi-version client API from being disabled, even if no external clients are configured. This option is required to use GRV caching.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_BUGGIFY_ENABLE, "CLIENT_BUGGIFY_ENABLE", "Enable client buggify - will make requests randomly fail (intended for client testing)", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_BUGGIFY_DISABLE, "CLIENT_BUGGIFY_DISABLE", "Disable client buggify", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_BUGGIFY_SECTION_ACTIVATED_PROBABILITY, "CLIENT_BUGGIFY_SECTION_ACTIVATED_PROBABILITY", "Set the probability of a CLIENT_BUGGIFY section being active for the current execution.", "(Int) probability expressed as a percentage between 0 and 100", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_BUGGIFY_SECTION_FIRED_PROBABILITY, "CLIENT_BUGGIFY_SECTION_FIRED_PROBABILITY", "Set the probability of an active CLIENT_BUGGIFY section being fired. A section will only fire if it was activated", "(Int) probability expressed as a percentage between 0 and 100", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBNetworkOptions, DISTRIBUTED_CLIENT_TRACER, "DISTRIBUTED_CLIENT_TRACER", "Set a tracer to run on the client. Should be set to the same value as the tracer set on the server.", "(String) Distributed tracer type. Choose from none, log_file, or network_lossy", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, CLIENT_TMP_DIR, "CLIENT_TMP_DIR", "Sets the directory for storing temporary files created by FDB client, such as temporary copies of client libraries. Defaults to /tmp", "(String) Client directory for temporary files. ", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, SUPPORTED_CLIENT_VERSIONS, "SUPPORTED_CLIENT_VERSIONS", "This option is set automatically to communicate the list of supported clients to the active client.", "(String) [release version],[source version],[protocol version];...", true, true, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBNetworkOptions, EXTERNAL_CLIENT, "EXTERNAL_CLIENT", "This option is set automatically on all clients loaded externally using the multi-version API.", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBNetworkOptions, EXTERNAL_CLIENT_TRANSPORT_ID, "EXTERNAL_CLIENT_TRANSPORT_ID", "This option tells a child on a multiversion client what transport ID to use.", "(Int) Transport ID for the child connection", true, true, false, false, -1, FDBOptionInfo::ParamType::Int)
}

FDBOptionInfoMap<FDBDatabaseOptions> FDBDatabaseOptions::optionInfo;

void FDBDatabaseOptions::init() {
	ADD_OPTION_INFO(FDBDatabaseOptions, LOCATION_CACHE_SIZE, "LOCATION_CACHE_SIZE", "Set the size of the client location cache. Raising this value can boost performance in very large databases where clients access data in a near-random pattern. Defaults to 100000.", "(Int) Max location cache entries", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, MAX_WATCHES, "MAX_WATCHES", "Set the maximum number of watches allowed to be outstanding on a database connection. Increasing this number could result in increased resource usage. Reducing this number will not cancel any outstanding watches. Defaults to 10000 and cannot be larger than 1000000.", "(Int) Max outstanding watches", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, MACHINE_ID, "MACHINE_ID", "Specify the machine ID that was passed to fdbserver processes running on the same machine as this client, for better location-aware load balancing.", "(String) Hexadecimal ID", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBDatabaseOptions, DATACENTER_ID, "DATACENTER_ID", "Specify the datacenter ID that was passed to fdbserver processes running in the same datacenter as this client, for better location-aware load balancing.", "(String) A string identifier for the datacenter", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBDatabaseOptions, SNAPSHOT_RYW_ENABLE, "SNAPSHOT_RYW_ENABLE", "Snapshot read operations will see the results of writes done in the same transaction. This is the default behavior.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, SNAPSHOT_RYW_DISABLE, "SNAPSHOT_RYW_DISABLE", "Snapshot read operations will not see the results of writes done in the same transaction. This was the default behavior prior to API version 300.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_LOGGING_MAX_FIELD_LENGTH, "TRANSACTION_LOGGING_MAX_FIELD_LENGTH", "Sets the maximum escaped length of key and value fields to be logged to the trace file via the LOG_TRANSACTION option. This sets the ``transaction_logging_max_field_length`` option of each transaction created by this database. See the transaction option description for more information.", "(Int) Maximum length of escaped key and value fields.", true, false, false, false, 405, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_TIMEOUT, "TRANSACTION_TIMEOUT", "Set a timeout in milliseconds which, when elapsed, will cause each transaction automatically to be cancelled. This sets the ``timeout`` option of each transaction created by this database. See the transaction option description for more information. Using this option requires that the API version is 610 or higher.", "(Int) value in milliseconds of timeout", true, false, false, false, 500, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_RETRY_LIMIT, "TRANSACTION_RETRY_LIMIT", "Set a maximum number of retries after which additional calls to ``onError`` will throw the most recently seen error code. This sets the ``retry_limit`` option of each transaction created by this database. See the transaction option description for more information.", "(Int) number of times to retry", true, false, false, false, 501, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_MAX_RETRY_DELAY, "TRANSACTION_MAX_RETRY_DELAY", "Set the maximum amount of backoff delay incurred in the call to ``onError`` if the error is retryable. This sets the ``max_retry_delay`` option of each transaction created by this database. See the transaction option description for more information.", "(Int) value in milliseconds of maximum delay", true, false, false, false, 502, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_SIZE_LIMIT, "TRANSACTION_SIZE_LIMIT", "Set the maximum transaction size in bytes. This sets the ``size_limit`` option on each transaction created by this database. See the transaction option description for more information.", "(Int) value in bytes", true, false, false, false, 503, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_CAUSAL_READ_RISKY, "TRANSACTION_CAUSAL_READ_RISKY", "The read version will be committed, and usually will be the latest committed, but might not be the latest committed in the event of a simultaneous fault and misbehaving clock.", "Option takes no parameter", false, false, false, false, 20, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_INCLUDE_PORT_IN_ADDRESS, "TRANSACTION_INCLUDE_PORT_IN_ADDRESS", "Deprecated. Addresses returned by get_addresses_for_key include the port when enabled. As of api version 630, this option is enabled by default and setting this has no effect.", "Option takes no parameter", false, false, false, false, 23, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_AUTOMATIC_IDEMPOTENCY, "TRANSACTION_AUTOMATIC_IDEMPOTENCY", "Set a random idempotency id for all transactions. See the transaction option description for more information. This feature is in development and not ready for general use.", "Option takes no parameter", false, false, false, false, 505, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_BYPASS_UNREADABLE, "TRANSACTION_BYPASS_UNREADABLE", "Allows ``get`` operations to read from sections of keyspace that have become unreadable because of versionstamp operations. This sets the ``bypass_unreadable`` option of each transaction created by this database. See the transaction option description for more information.", "Option takes no parameter", false, false, false, false, 1100, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_USED_DURING_COMMIT_PROTECTION_DISABLE, "TRANSACTION_USED_DURING_COMMIT_PROTECTION_DISABLE", "By default, operations that are performed on a transaction while it is being committed will not only fail themselves, but they will attempt to fail other in-flight operations (such as the commit) as well. This behavior is intended to help developers discover situations where operations could be unintentionally executed after the transaction has been reset. Setting this option removes that protection, causing only the offending operation to fail.", "Option takes no parameter", false, false, false, false, 701, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TRANSACTION_REPORT_CONFLICTING_KEYS, "TRANSACTION_REPORT_CONFLICTING_KEYS", "Enables conflicting key reporting on all transactions, allowing them to retrieve the keys that are conflicting with other transactions.", "Option takes no parameter", false, false, false, false, 712, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, USE_CONFIG_DATABASE, "USE_CONFIG_DATABASE", "Use configuration database.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBDatabaseOptions, TEST_CAUSAL_READ_RISKY, "TEST_CAUSAL_READ_RISKY", "Enables verification of causal read risky by checking whether clients are able to read stale data when they detect a recovery, and logging an error if so.", "(Int) integer between 0 and 100 expressing the probability a client will verify it can't read stale data", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
}

FDBOptionInfoMap<FDBTransactionOptions> FDBTransactionOptions::optionInfo;

void FDBTransactionOptions::init() {
	ADD_OPTION_INFO(FDBTransactionOptions, CAUSAL_WRITE_RISKY, "CAUSAL_WRITE_RISKY", "The transaction, if not self-conflicting, may be committed a second time after commit succeeds, in the event of a fault", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, CAUSAL_READ_RISKY, "CAUSAL_READ_RISKY", "The read version will be committed, and usually will be the latest committed, but might not be the latest committed in the event of a simultaneous fault and misbehaving clock.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, CAUSAL_READ_DISABLE, "CAUSAL_READ_DISABLE", "", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, INCLUDE_PORT_IN_ADDRESS, "INCLUDE_PORT_IN_ADDRESS", "Addresses returned by get_addresses_for_key include the port when enabled. As of api version 630, this option is enabled by default and setting this has no effect.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, NEXT_WRITE_NO_WRITE_CONFLICT_RANGE, "NEXT_WRITE_NO_WRITE_CONFLICT_RANGE", "The next write performed on this transaction will not generate a write conflict range. As a result, other transactions which read the key(s) being modified by the next write will not conflict with this transaction. Care needs to be taken when using this option on a transaction that is shared between multiple threads. When setting this option, write conflict ranges will be disabled on the next write operation, regardless of what thread it is on.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, COMMIT_ON_FIRST_PROXY, "COMMIT_ON_FIRST_PROXY", "Committing this transaction will bypass the normal load balancing across commit proxies and go directly to the specifically nominated 'first commit proxy'.", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, CHECK_WRITES_ENABLE, "CHECK_WRITES_ENABLE", "", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_YOUR_WRITES_DISABLE, "READ_YOUR_WRITES_DISABLE", "Reads performed by a transaction will not see any prior mutations that occurred in that transaction, instead seeing the value which was in the database at the transaction's read version. This option may provide a small performance benefit for the client, but also disables a number of client-side optimizations which are beneficial for transactions which tend to read and write the same keys within a single transaction. It is an error to set this option after performing any reads or writes on the transaction.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_AHEAD_DISABLE, "READ_AHEAD_DISABLE", "Deprecated", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_SERVER_SIDE_CACHE_ENABLE, "READ_SERVER_SIDE_CACHE_ENABLE", "Storage server should cache disk blocks needed for subsequent read requests in this transaction.  This is the default behavior.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_SERVER_SIDE_CACHE_DISABLE, "READ_SERVER_SIDE_CACHE_DISABLE", "Storage server should not cache disk blocks needed for subsequent read requests in this transaction.  This can be used to avoid cache pollution for reads not expected to be repeated.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_PRIORITY_NORMAL, "READ_PRIORITY_NORMAL", "Use normal read priority for subsequent read requests in this transaction.  This is the default read priority.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_PRIORITY_LOW, "READ_PRIORITY_LOW", "Use low read priority for subsequent read requests in this transaction.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_PRIORITY_HIGH, "READ_PRIORITY_HIGH", "Use high read priority for subsequent read requests in this transaction.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, DURABILITY_DATACENTER, "DURABILITY_DATACENTER", "", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, DURABILITY_RISKY, "DURABILITY_RISKY", "", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, DURABILITY_DEV_NULL_IS_WEB_SCALE, "DURABILITY_DEV_NULL_IS_WEB_SCALE", "Deprecated", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, PRIORITY_SYSTEM_IMMEDIATE, "PRIORITY_SYSTEM_IMMEDIATE", "Specifies that this transaction should be treated as highest priority and that lower priority transactions should block behind this one. Use is discouraged outside of low-level tools", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, PRIORITY_BATCH, "PRIORITY_BATCH", "Specifies that this transaction should be treated as low priority and that default priority transactions will be processed first. Batch priority transactions will also be throttled at load levels smaller than for other types of transactions and may be fully cut off in the event of machine failures. Useful for doing batch work simultaneously with latency-sensitive work", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, INITIALIZE_NEW_DATABASE, "INITIALIZE_NEW_DATABASE", "This is a write-only transaction which sets the initial configuration. This option is designed for use by database system tools only.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, ACCESS_SYSTEM_KEYS, "ACCESS_SYSTEM_KEYS", "Allows this transaction to read and modify system keys (those that start with the byte 0xFF). Implies raw_access.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_SYSTEM_KEYS, "READ_SYSTEM_KEYS", "Allows this transaction to read system keys (those that start with the byte 0xFF). Implies raw_access.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, RAW_ACCESS, "RAW_ACCESS", "Allows this transaction to access the raw key-space when tenant mode is on.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, BYPASS_STORAGE_QUOTA, "BYPASS_STORAGE_QUOTA", "Allows this transaction to bypass storage quota enforcement. Should only be used for transactions that directly or indirectly decrease the size of the tenant group's data.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, DEBUG_DUMP, "DEBUG_DUMP", "", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, DEBUG_RETRY_LOGGING, "DEBUG_RETRY_LOGGING", "", "(String) Optional transaction name", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, TRANSACTION_LOGGING_ENABLE, "TRANSACTION_LOGGING_ENABLE", "Deprecated", "(String) String identifier to be used in the logs when tracing this transaction. The identifier must not exceed 100 characters.", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, DEBUG_TRANSACTION_IDENTIFIER, "DEBUG_TRANSACTION_IDENTIFIER", "Sets a client provided identifier for the transaction that will be used in scenarios like tracing or profiling. Client trace logging or transaction profiling must be separately enabled.", "(String) String identifier to be used when tracing or profiling this transaction. The identifier must not exceed 100 characters.", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, LOG_TRANSACTION, "LOG_TRANSACTION", "Enables tracing for this transaction and logs results to the client trace logs. The DEBUG_TRANSACTION_IDENTIFIER option must be set before using this option, and client trace logging must be enabled to get log output.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, TRANSACTION_LOGGING_MAX_FIELD_LENGTH, "TRANSACTION_LOGGING_MAX_FIELD_LENGTH", "Sets the maximum escaped length of key and value fields to be logged to the trace file via the LOG_TRANSACTION option, after which the field will be truncated. A negative value disables truncation.", "(Int) Maximum length of escaped key and value fields.", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBTransactionOptions, SERVER_REQUEST_TRACING, "SERVER_REQUEST_TRACING", "Sets an identifier for server tracing of this transaction. When committed, this identifier triggers logging when each part of the transaction authority encounters it, which is helpful in diagnosing slowness in misbehaving clusters. The identifier is randomly generated. When there is also a debug_transaction_identifier, both IDs are logged together.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, TIMEOUT, "TIMEOUT", "Set a timeout in milliseconds which, when elapsed, will cause the transaction automatically to be cancelled. Valid parameter values are ``[0, INT_MAX]``. If set to 0, will disable all timeouts. All pending and any future uses of the transaction will throw an exception. The transaction can be used again after it is reset. Prior to API version 610, like all other transaction options, the timeout must be reset after a call to ``onError``. If the API version is 610 or greater, the timeout is not reset after an ``onError`` call. This allows the user to specify a longer timeout on specific transactions than the default timeout specified through the ``transaction_timeout`` database option without the shorter database timeout cancelling transactions that encounter a retryable error. Note that at all API versions, it is safe and legal to set the timeout each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option.", "(Int) value in milliseconds of timeout", true, false, true, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBTransactionOptions, RETRY_LIMIT, "RETRY_LIMIT", "Set a maximum number of retries after which additional calls to ``onError`` will throw the most recently seen error code. Valid parameter values are ``[-1, INT_MAX]``. If set to -1, will disable the retry limit. Prior to API version 610, like all other transaction options, the retry limit must be reset after a call to ``onError``. If the API version is 610 or greater, the retry limit is not reset after an ``onError`` call. Note that at all API versions, it is safe and legal to set the retry limit each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option.", "(Int) number of times to retry", true, false, true, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBTransactionOptions, MAX_RETRY_DELAY, "MAX_RETRY_DELAY", "Set the maximum amount of backoff delay incurred in the call to ``onError`` if the error is retryable. Defaults to 1000 ms. Valid parameter values are ``[0, INT_MAX]``. If the maximum retry delay is less than the current retry delay of the transaction, then the current retry delay will be clamped to the maximum retry delay. Prior to API version 610, like all other transaction options, the maximum retry delay must be reset after a call to ``onError``. If the API version is 610 or greater, the retry limit is not reset after an ``onError`` call. Note that at all API versions, it is safe and legal to set the maximum retry delay each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option.", "(Int) value in milliseconds of maximum delay", true, false, true, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBTransactionOptions, SIZE_LIMIT, "SIZE_LIMIT", "Set the transaction size limit in bytes. The size is calculated by combining the sizes of all keys and values written or mutated, all key ranges cleared, and all read and write conflict ranges. (In other words, it includes the total size of all data included in the request to the cluster to commit the transaction.) Large transactions can cause performance problems on FoundationDB clusters, so setting this limit to a smaller value than the default can help prevent the client from accidentally degrading the cluster's performance. This value must be at least 32 and cannot be set to higher than 10,000,000, the default transaction size limit.", "(Int) value in bytes", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
	ADD_OPTION_INFO(FDBTransactionOptions, IDEMPOTENCY_ID, "IDEMPOTENCY_ID", "Associate this transaction with this ID for the purpose of checking whether or not this transaction has already committed. Must be at least 16 bytes and less than 256 bytes. This feature is in development and not ready for general use. Unless the automatic_idempotency option is set after this option, the client will not automatically attempt to remove this id from the cluster after a successful commit.", "(String) Unique ID", true, true, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, AUTOMATIC_IDEMPOTENCY, "AUTOMATIC_IDEMPOTENCY", "Automatically assign a random 16 byte idempotency id for this transaction. Prevents commits from failing with ``commit_unknown_result``. WARNING: If you are also using the multiversion client or transaction timeouts, if either cluster_version_changed or transaction_timed_out was thrown during a commit, then that commit may have already succeeded or may succeed in the future. This feature is in development and not ready for general use.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, SNAPSHOT_RYW_ENABLE, "SNAPSHOT_RYW_ENABLE", "Snapshot read operations will see the results of writes done in the same transaction. This is the default behavior.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, SNAPSHOT_RYW_DISABLE, "SNAPSHOT_RYW_DISABLE", "Snapshot read operations will not see the results of writes done in the same transaction. This was the default behavior prior to API version 300.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, LOCK_AWARE, "LOCK_AWARE", "The transaction can read and write to locked databases, and is responsible for checking that it took the lock.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, USED_DURING_COMMIT_PROTECTION_DISABLE, "USED_DURING_COMMIT_PROTECTION_DISABLE", "By default, operations that are performed on a transaction while it is being committed will not only fail themselves, but they will attempt to fail other in-flight operations (such as the commit) as well. This behavior is intended to help developers discover situations where operations could be unintentionally executed after the transaction has been reset. Setting this option removes that protection, causing only the offending operation to fail.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, READ_LOCK_AWARE, "READ_LOCK_AWARE", "The transaction can read from locked databases.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, FIRST_IN_BATCH, "FIRST_IN_BATCH", "No other transactions will be applied before this transaction within the same commit version.", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, USE_PROVISIONAL_PROXIES, "USE_PROVISIONAL_PROXIES", "This option should only be used by tools which change the database configuration.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, REPORT_CONFLICTING_KEYS, "REPORT_CONFLICTING_KEYS", "The transaction can retrieve keys that are conflicting with other transactions.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, SPECIAL_KEY_SPACE_RELAXED, "SPECIAL_KEY_SPACE_RELAXED", "By default, the special key space will only allow users to read from exactly one module (a subspace in the special key space). Use this option to allow reading from zero or more modules. Users who set this option should be prepared for new modules, which may have different behaviors than the modules they're currently reading. For example, a new module might block or return an error.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, SPECIAL_KEY_SPACE_ENABLE_WRITES, "SPECIAL_KEY_SPACE_ENABLE_WRITES", "By default, users are not allowed to write to special keys. Enable this option will implicitly enable all options required to achieve the configuration change.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, TAG, "TAG", "Adds a tag to the transaction that can be used to apply manual targeted throttling. At most 5 tags can be set on a transaction.", "(String) String identifier used to associated this transaction with a throttling group. Must not exceed 16 characters.", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, AUTO_THROTTLE_TAG, "AUTO_THROTTLE_TAG", "Adds a tag to the transaction that can be used to apply manual or automatic targeted throttling. At most 5 tags can be set on a transaction.", "(String) String identifier used to associated this transaction with a throttling group. Must not exceed 16 characters.", true, false, false, false, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, SPAN_PARENT, "SPAN_PARENT", "Adds a parent to the Span of this transaction. Used for transaction tracing. A span can be identified with a 33 bytes serialized binary format which consists of: 8 bytes protocol version, e.g. ``0x0FDB00B073000000LL`` in little-endian format, 16 bytes trace id, 8 bytes span id, 1 byte set to 1 if sampling is enabled", "(Bytes) A serialized binary byte string of length 33 used to associate the span of this transaction with a parent", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBTransactionOptions, EXPENSIVE_CLEAR_COST_ESTIMATION_ENABLE, "EXPENSIVE_CLEAR_COST_ESTIMATION_ENABLE", "Asks storage servers for how many bytes a clear key range contains. Otherwise uses the location cache to roughly estimate this.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, BYPASS_UNREADABLE, "BYPASS_UNREADABLE", "Allows ``get`` operations to read from sections of keyspace that have become unreadable because of versionstamp operations. These reads will view versionstamp operations as if they were set operations that did not fill in the versionstamp.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, USE_GRV_CACHE, "USE_GRV_CACHE", "Allows this transaction to use cached GRV from the database context. Defaults to off. Upon first usage, starts a background updater to periodically update the cache to avoid stale read versions. The disable_client_bypass option must also be set.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, SKIP_GRV_CACHE, "SKIP_GRV_CACHE", "Specifically instruct this transaction to NOT use cached GRV. Primarily used for the read version cache's background updater to avoid attempting to read a cached entry in specific situations.", "Option takes no parameter", false, true, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, AUTHORIZATION_TOKEN, "AUTHORIZATION_TOKEN", "Attach given authorization token to the transaction such that subsequent tenant-aware requests are authorized", "(String) A JSON Web Token authorized to access data belonging to one or more tenants, indicated by 'tenants' claim of the token's payload.", true, false, true, true, -1, FDBOptionInfo::ParamType::String)
	ADD_OPTION_INFO(FDBTransactionOptions, ENABLE_REPLICA_CONSISTENCY_CHECK, "ENABLE_REPLICA_CONSISTENCY_CHECK", "Enables replica consistency check, which compares the results returned by storage server replicas (as many as specified by consistency_check_required_replicas option) for a given read request, in client-side load balancer.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBTransactionOptions, CONSISTENCY_CHECK_REQUIRED_REPLICAS, "CONSISTENCY_CHECK_REQUIRED_REPLICAS", "Specifies the number of storage server replica results that the load balancer needs to compare when enable_replica_consistency_check option is set.", "(Int) Number of storage replicas over which the load balancer consistency check is done.", true, false, false, false, -1, FDBOptionInfo::ParamType::Int)
}

FDBOptionInfoMap<FDBStreamingModes> FDBStreamingModes::optionInfo;

void FDBStreamingModes::init() {
	ADD_OPTION_INFO(FDBStreamingModes, WANT_ALL, "WANT_ALL", "Client intends to consume the entire range and would like it all transferred as early as possible.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, ITERATOR, "ITERATOR", "The default. The client doesn't know how much of the range it is likely to used and wants different performance concerns to be balanced. Only a small portion of data is transferred to the client initially (in order to minimize costs if the client doesn't read the entire range), and as the caller iterates over more items in the range larger batches will be transferred in order to minimize latency. After enough iterations, the iterator mode will eventually reach the same byte limit as ``WANT_ALL``", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, EXACT, "EXACT", "Infrequently used. The client has passed a specific row limit and wants that many rows delivered in a single batch. Because of iterator operation in client drivers make request batches transparent to the user, consider ``WANT_ALL`` StreamingMode instead. A row limit must be specified if this mode is used.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, SMALL, "SMALL", "Infrequently used. Transfer data in batches small enough to not be much more expensive than reading individual rows, to minimize cost if iteration stops early.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, MEDIUM, "MEDIUM", "Infrequently used. Transfer data in batches sized in between small and large.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, LARGE, "LARGE", "Infrequently used. Transfer data in batches large enough to be, in a high-concurrency environment, nearly as efficient as possible. If the client stops iteration early, some disk and network bandwidth may be wasted. The batch size may still be too small to allow a single client to get high throughput from the database, so if that is what you need consider the SERIAL StreamingMode.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBStreamingModes, SERIAL, "SERIAL", "Transfer data in batches large enough that an individual client can get reasonable read bandwidth from the database. If the client stops iteration early, considerable disk and network bandwidth may be wasted.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
}

FDBOptionInfoMap<FDBMutationTypes> FDBMutationTypes::optionInfo;

void FDBMutationTypes::init() {
	ADD_OPTION_INFO(FDBMutationTypes, ADD, "ADD", "Performs an addition of little-endian integers. If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The integers to be added must be stored in a little-endian representation.  They can be signed in two's complement representation or unsigned. You can add to an integer at a known offset in the value by prepending the appropriate number of zero bytes to ``param`` and padding with zero bytes to match the length of the value. However, this offset technique requires that you know the addition will not cause the integer field within the value to overflow.", "(Bytes) addend", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, AND, "AND", "Deprecated", "(Bytes) value with which to perform bitwise and", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, BIT_AND, "BIT_AND", "Performs a bitwise ``and`` operation.  If the existing value in the database is not present, then ``param`` is stored in the database. If the existing value in the database is shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", "(Bytes) value with which to perform bitwise and", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, OR, "OR", "Deprecated", "(Bytes) value with which to perform bitwise or", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, BIT_OR, "BIT_OR", "Performs a bitwise ``or`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", "(Bytes) value with which to perform bitwise or", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, XOR, "XOR", "Deprecated", "(Bytes) value with which to perform bitwise xor", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, BIT_XOR, "BIT_XOR", "Performs a bitwise ``xor`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", "(Bytes) value with which to perform bitwise xor", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, APPEND_IF_FITS, "APPEND_IF_FITS", "Appends ``param`` to the end of the existing value already in the database at the given key (or creates the key and sets the value to ``param`` if the key is empty). This will only append the value if the final concatenated value size is less than or equal to the maximum value size (i.e., if it fits). WARNING: No error is surfaced back to the user if the final value is too large because the mutation will not be applied until after the transaction has been committed. Therefore, it is only safe to use this mutation type if one can guarantee that one will keep the total value size under the maximum size.", "(Bytes) value to append to the database value", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, MAX, "MAX", "Performs a little-endian comparison of byte strings. If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The larger of the two values is then stored in the database.", "(Bytes) value to check against database value", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, MIN, "MIN", "Performs a little-endian comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored in the database. If the existing value in the database is shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The smaller of the two values is then stored in the database.", "(Bytes) value to check against database value", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, SET_VERSIONSTAMPED_KEY, "SET_VERSIONSTAMPED_KEY", "Transforms ``key`` using a versionstamp for the transaction. Sets the transformed key in the database to ``param``. The key is transformed by removing the final four bytes from the key and reading those as a little-Endian 32-bit integer to get a position ``pos``. The 10 bytes of the key from ``pos`` to ``pos + 10`` are replaced with the versionstamp of the transaction used. The first byte of the key is position 0. A versionstamp is a 10 byte, unique, monotonically (but not sequentially) increasing value for each committed transaction. The first 8 bytes are the committed version of the database (serialized in big-Endian order). The last 2 bytes are monotonic in the serialization order for transactions. WARNING: At this time, versionstamps are compatible with the Tuple layer only in the Java, Python, and Go bindings. Also, note that prior to API version 520, the offset was computed from only the final two bytes rather than the final four bytes.", "(Bytes) value to which to set the transformed key", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, SET_VERSIONSTAMPED_VALUE, "SET_VERSIONSTAMPED_VALUE", "Transforms ``param`` using a versionstamp for the transaction. Sets the ``key`` given to the transformed ``param``. The parameter is transformed by removing the final four bytes from ``param`` and reading those as a little-Endian 32-bit integer to get a position ``pos``. The 10 bytes of the parameter from ``pos`` to ``pos + 10`` are replaced with the versionstamp of the transaction used. The first byte of the parameter is position 0. A versionstamp is a 10 byte, unique, monotonically (but not sequentially) increasing value for each committed transaction. The first 8 bytes are the committed version of the database (serialized in big-Endian order). The last 2 bytes are monotonic in the serialization order for transactions. WARNING: At this time, versionstamps are compatible with the Tuple layer only in the Java, Python, and Go bindings. Also, note that prior to API version 520, the versionstamp was always placed at the beginning of the parameter rather than computing an offset.", "(Bytes) value to versionstamp and set", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, BYTE_MIN, "BYTE_MIN", "Performs lexicographic comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored. Otherwise the smaller of the two values is then stored in the database.", "(Bytes) value to check against database value", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, BYTE_MAX, "BYTE_MAX", "Performs lexicographic comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored. Otherwise the larger of the two values is then stored in the database.", "(Bytes) value to check against database value", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
	ADD_OPTION_INFO(FDBMutationTypes, COMPARE_AND_CLEAR, "COMPARE_AND_CLEAR", "Performs an atomic ``compare and clear`` operation. If the existing value in the database is equal to the given value, then given key is cleared.", "(Bytes) Value to compare with", true, false, false, false, -1, FDBOptionInfo::ParamType::Bytes)
}

FDBOptionInfoMap<FDBConflictRangeTypes> FDBConflictRangeTypes::optionInfo;

void FDBConflictRangeTypes::init() {
	ADD_OPTION_INFO(FDBConflictRangeTypes, READ, "READ", "Used to add a read conflict range", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBConflictRangeTypes, WRITE, "WRITE", "Used to add a write conflict range", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
}

FDBOptionInfoMap<FDBErrorPredicates> FDBErrorPredicates::optionInfo;

void FDBErrorPredicates::init() {
	ADD_OPTION_INFO(FDBErrorPredicates, RETRYABLE, "RETRYABLE", "Returns ``true`` if the error indicates the operations in the transactions should be retried because of transient error.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBErrorPredicates, MAYBE_COMMITTED, "MAYBE_COMMITTED", "Returns ``true`` if the error indicates the transaction may have succeeded, though not in a way the system can verify.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
	ADD_OPTION_INFO(FDBErrorPredicates, RETRYABLE_NOT_COMMITTED, "RETRYABLE_NOT_COMMITTED", "Returns ``true`` if the error indicates the transaction has not committed, though in a way that can be retried.", "Option takes no parameter", false, false, false, false, -1, FDBOptionInfo::ParamType::None)
}

