#define POST_ACTOR_COMPILER 1
#line 2 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"

/*
 * MetaclusterData.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_METACLUSTERDATA_ACTOR_G_H)
#define METACLUSTER_METACLUSTERDATA_ACTOR_G_H
#include "metacluster/MetaclusterData.actor.g.h"
#elif !defined(METACLUSTER_METACLUSTERDATA_ACTOR_H)
#define METACLUSTER_METACLUSTERDATA_ACTOR_H

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantData.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "flow/BooleanParam.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterMetadata.h"
#include "metacluster/MetaclusterUtil.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace metacluster::util {
template <class DB>
class MetaclusterData {
public:
	struct ManagementClusterData {
		Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
		std::map<ClusterName, DataClusterMetadata> dataClusters;
		KeyBackedRangeResult<std::pair<ClusterName, int64_t>> clusterTenantCounts;
		KeyBackedRangeResult<UID> registrationTombstones;
		KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> activeRestoreIds;
		Optional<Versionstamp> maxRestoreId;

		std::map<ClusterName, int64_t> clusterAllocatedMap;
		std::map<ClusterName, std::set<int64_t>> clusterTenantMap;
		std::map<ClusterName, std::set<TenantGroupName>> clusterTenantGroupMap;

		Optional<int64_t> tenantIdPrefix;
		TenantData<DB, MetaclusterTenantTypes> tenantData;

		// Similar to operator==, but useful in assertions for identifying which member is different
		void assertEquals(ManagementClusterData const& other) const {
			ASSERT(metaclusterRegistration == other.metaclusterRegistration);
			ASSERT(dataClusters == other.dataClusters);
			ASSERT(clusterTenantCounts == other.clusterTenantCounts);
			ASSERT(registrationTombstones == other.registrationTombstones);
			ASSERT(activeRestoreIds == other.activeRestoreIds);
			ASSERT(maxRestoreId == other.maxRestoreId);
			ASSERT(clusterAllocatedMap == other.clusterAllocatedMap);
			ASSERT(clusterTenantMap == other.clusterTenantMap);
			ASSERT(clusterTenantGroupMap == other.clusterTenantGroupMap);
			ASSERT(tenantIdPrefix == other.tenantIdPrefix);
			tenantData.assertEquals(other.tenantData);
		}

		bool operator==(ManagementClusterData const& other) const {
			return metaclusterRegistration == other.metaclusterRegistration && dataClusters == other.dataClusters &&
			       clusterTenantCounts == other.clusterTenantCounts &&
			       registrationTombstones == other.registrationTombstones &&
			       activeRestoreIds == other.activeRestoreIds && maxRestoreId == other.maxRestoreId &&
			       clusterAllocatedMap == other.clusterAllocatedMap && clusterTenantMap == other.clusterTenantMap &&
			       clusterTenantGroupMap == other.clusterTenantGroupMap && tenantIdPrefix == other.tenantIdPrefix &&
			       tenantData == other.tenantData;
		}

		bool operator!=(ManagementClusterData const& other) const { return !(*this == other); }
	};

	struct DataClusterData {
		Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
		KeyBackedRangeResult<UID> registrationTombstones;
		KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> activeRestoreIds;
		Optional<Versionstamp> maxRestoreId;
		TenantData<DB, StandardTenantTypes> tenantData;

		// Similar to operator==, but useful in assertions for identifying which member is different
		void assertEquals(DataClusterData const& other) const {
			ASSERT(metaclusterRegistration == other.metaclusterRegistration);
			ASSERT(registrationTombstones == other.registrationTombstones);
			ASSERT(activeRestoreIds == other.activeRestoreIds);
			ASSERT(maxRestoreId == other.maxRestoreId);
			tenantData.assertEquals(other.tenantData);
		}

		bool operator==(DataClusterData const& other) const {
			return metaclusterRegistration == other.metaclusterRegistration &&
			       registrationTombstones == other.registrationTombstones &&
			       activeRestoreIds == other.activeRestoreIds && maxRestoreId == other.maxRestoreId &&
			       tenantData == other.tenantData;
		}

		bool operator!=(DataClusterData const& other) const { return !(*this == other); }
	};

	Reference<DB> managementDb;
	ManagementClusterData managementMetadata;
	std::map<ClusterName, DataClusterData> dataClusterMetadata;

private:
	// Note: this check can only be run on metaclusters with a reasonable number of tenants, as should be
	// the case with the current metacluster simulation workloads
	static inline const int metaclusterMaxTenants = 10e6;

																#line 128 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
// This generated class is to be used only via loadManagementClusterMetadata()
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
template <class LoadManagementClusterMetadataActor>
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadManagementClusterMetadataActorState {
															#line 134 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadManagementClusterMetadataActorState(MetaclusterData* const& self) 
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		 : self(self),
															#line 127 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   managementTr(self->managementDb->createTransaction()),
															#line 129 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   clusterCapacityTuples(),
															#line 130 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   clusterTenantTuples(),
															#line 131 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   clusterTenantGroupTuples()
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
	{
		fdb_probe_actor_create("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	~LoadManagementClusterMetadataActorState() 
	{
		fdb_probe_actor_destroy("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			self->managementMetadata.tenantData = TenantData<DB, MetaclusterTenantTypes>(self->managementDb, &metadata::management::tenantMetadata());
															#line 136 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			;
															#line 166 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadManagementClusterMetadataActorState();
		static_cast<LoadManagementClusterMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 172 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		self->managementMetadata.clusterAllocatedMap.clear();
															#line 173 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		for( auto t : clusterCapacityTuples.results ) {
															#line 174 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT_EQ(t.size(), 2);
															#line 175 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			int64_t capacity = t.getInt(0);
															#line 176 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ClusterName clusterName = t.getString(1);
															#line 177 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT(self->managementMetadata.clusterAllocatedMap.try_emplace(clusterName, capacity).second);
															#line 199 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		}
															#line 180 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		self->managementMetadata.clusterTenantMap.clear();
															#line 181 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		for( auto t : clusterTenantTuples.results ) {
															#line 182 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT_EQ(t.size(), 3);
															#line 183 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			TenantName tenantName = t.getString(1);
															#line 184 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			int64_t tenantId = t.getInt(2);
															#line 185 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			bool renaming = tenantId == TenantInfo::INVALID_TENANT;
															#line 186 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (renaming)
															#line 215 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			{
															#line 187 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				tenantId = self->managementMetadata.tenantData.tenantNameIndex[tenantName];
															#line 219 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			}
															#line 189 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			MetaclusterTenantMapEntry const& entry = self->managementMetadata.tenantData.tenantMap[tenantId];
															#line 190 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (renaming)
															#line 225 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			{
															#line 191 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				CODE_PROBE(true, "Loading metacluster data with renaming tenant");
															#line 192 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				ASSERT(entry.tenantState == TenantState::RENAMING || entry.tenantState == TenantState::REMOVING);
															#line 193 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				ASSERT(entry.renameDestination == tenantName);
															#line 233 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			}
			else
			{
															#line 195 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				ASSERT(entry.tenantName == tenantName);
															#line 196 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				ASSERT(self->managementMetadata.clusterTenantMap[t.getString(0)].insert(tenantId).second);
															#line 241 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			}
		}
															#line 200 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		self->managementMetadata.clusterTenantGroupMap.clear();
															#line 201 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		for( auto t : clusterTenantGroupTuples.results ) {
															#line 202 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT_EQ(t.size(), 2);
															#line 203 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			TenantGroupName tenantGroupName = t.getString(1);
															#line 204 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT(self->managementMetadata.clusterTenantGroupMap[t.getString(0)].insert(tenantGroupName).second);
															#line 254 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		}
															#line 207 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (!static_cast<LoadManagementClusterMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadManagementClusterMetadataActorState(); static_cast<LoadManagementClusterMetadataActor*>(this)->destroy(); return 0; }
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		new (&static_cast<LoadManagementClusterMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadManagementClusterMetadataActorState();
		static_cast<LoadManagementClusterMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 138 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			managementTr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 139 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			StrictFuture<Void> __when_expr_0 = store(self->managementMetadata.tenantIdPrefix, TenantMetadata::tenantIdPrefix().get(managementTr)) && store(self->managementMetadata.metaclusterRegistration, metadata::metaclusterRegistration().get(managementTr)) && store(self->managementMetadata.dataClusters, listClustersTransaction( managementTr, ""_sr, "\xff\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS + 1)) && store(self->managementMetadata.clusterTenantCounts, metadata::management::clusterTenantCount().getRange( managementTr, {}, {}, CLIENT_KNOBS->MAX_DATA_CLUSTERS)) && store(self->managementMetadata.registrationTombstones, metadata::registrationTombstones().getRange(managementTr, {}, {}, CLIENT_KNOBS->TOO_MANY)) && store(self->managementMetadata.activeRestoreIds, metadata::activeRestoreIds().getRange( managementTr, {}, {}, CLIENT_KNOBS->MAX_DATA_CLUSTERS)) && store(self->managementMetadata.maxRestoreId, metadata::maxRestoreId().get(managementTr)) && store(clusterCapacityTuples, metadata::management::clusterCapacityIndex().getRange( managementTr, {}, {}, CLIENT_KNOBS->MAX_DATA_CLUSTERS)) && store(clusterTenantTuples, metadata::management::clusterTenantIndex().getRange( managementTr, {}, {}, metaclusterMaxTenants)) && store(clusterTenantGroupTuples, metadata::management::clusterTenantGroupIndex().getRange( managementTr, {}, {}, metaclusterMaxTenants)) && self->managementMetadata.tenantData.load(managementTr);
															#line 139 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 282 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadManagementClusterMetadataActor, 0, Void >*>(static_cast<LoadManagementClusterMetadataActor*>(this)));
															#line 287 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 168 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(managementTr->onError(e));
															#line 168 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 324 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadManagementClusterMetadataActor, 1, Void >*>(static_cast<LoadManagementClusterMetadataActor*>(this)));
															#line 329 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadManagementClusterMetadataActor*>(this)->ActorCallback< LoadManagementClusterMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadManagementClusterMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadManagementClusterMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadManagementClusterMetadataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadManagementClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadManagementClusterMetadataActor*>(this)->ActorCallback< LoadManagementClusterMetadataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadManagementClusterMetadataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadManagementClusterMetadataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadManagementClusterMetadataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	MetaclusterData* self;
															#line 127 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	Reference<typename DB::TransactionT> managementTr;
															#line 129 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	KeyBackedRangeResult<Tuple> clusterCapacityTuples;
															#line 130 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	KeyBackedRangeResult<Tuple> clusterTenantTuples;
															#line 131 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	KeyBackedRangeResult<Tuple> clusterTenantGroupTuples;
															#line 524 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
};
// This generated class is to be used only via loadManagementClusterMetadata()
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadManagementClusterMetadataActor final : public Actor<Void>, public ActorCallback< LoadManagementClusterMetadataActor, 0, Void >, public ActorCallback< LoadManagementClusterMetadataActor, 1, Void >, public FastAllocated<LoadManagementClusterMetadataActor>, public LoadManagementClusterMetadataActorState<LoadManagementClusterMetadataActor> {
															#line 529 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
	using FastAllocated<LoadManagementClusterMetadataActor>::operator new;
	using FastAllocated<LoadManagementClusterMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3625726506916504320UL, 12525369654715710976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadManagementClusterMetadataActor, 0, Void >;
friend struct ActorCallback< LoadManagementClusterMetadataActor, 1, Void >;
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadManagementClusterMetadataActor(MetaclusterData* const& self) 
															#line 547 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		 : Actor<Void>(),
		   LoadManagementClusterMetadataActorState<LoadManagementClusterMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1135443672987736576UL, 2763318864864158720UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManagementClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadManagementClusterMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadManagementClusterMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadManagementClusterMetadataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadManagementClusterMetadataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
[[nodiscard]] static Future<Void> loadManagementClusterMetadata( MetaclusterData* const& self ) {
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	return Future<Void>(new LoadManagementClusterMetadataActor(self));
															#line 580 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
}

#line 209 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"

																#line 585 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
// This generated class is to be used only via loadDataClusterMetadata()
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
template <class LoadDataClusterMetadataActor>
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadDataClusterMetadataActorState {
															#line 591 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadDataClusterMetadataActorState(MetaclusterData* const& self,ClusterName const& clusterName,ClusterConnectionString const& connectionString) 
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		 : self(self),
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   clusterName(clusterName),
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		   connectionString(connectionString)
															#line 602 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
	{
		fdb_probe_actor_create("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	~LoadDataClusterMetadataActorState() 
	{
		fdb_probe_actor_destroy("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 214 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				clusterItr = self->dataClusterMetadata.try_emplace(clusterName);
															#line 217 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
				if (clusterItr.second)
															#line 620 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
				{
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
					StrictFuture<Reference<IDatabase>> __when_expr_0 = openDatabase(connectionString);
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
					if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 626 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >*>(static_cast<LoadDataClusterMetadataActor*>(this)));
															#line 631 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadDataClusterMetadataActorState();
		static_cast<LoadDataClusterMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 247 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (!static_cast<LoadDataClusterMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadDataClusterMetadataActorState(); static_cast<LoadDataClusterMetadataActor*>(this)->destroy(); return 0; }
															#line 665 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		new (&static_cast<LoadDataClusterMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadDataClusterMetadataActorState();
		static_cast<LoadDataClusterMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			TraceEvent(SevError, "LoadDataClusterError").error(e).detail("ClusterName", clusterName);
															#line 244 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			ASSERT(false);
															#line 680 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 219 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		tr = dataDb->createTransaction();
															#line 221 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		clusterItr.first->second.tenantData = TenantData<IDatabase, StandardTenantTypes>(dataDb, &TenantMetadata::instance());
															#line 223 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		;
															#line 705 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& __dataDb,int loopDepth) 
	{
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		dataDb = __dataDb;
															#line 714 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && __dataDb,int loopDepth) 
	{
		dataDb = std::move(__dataDb);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterMetadataActor*>(this)->ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 225 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 226 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			StrictFuture<Void> __when_expr_1 = store(clusterItr.first->second.metaclusterRegistration, metadata::metaclusterRegistration().get(tr)) && store(clusterItr.first->second.registrationTombstones, metadata::registrationTombstones().getRange(tr, {}, {}, CLIENT_KNOBS->TOO_MANY)) && store(clusterItr.first->second.activeRestoreIds, metadata::activeRestoreIds().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_DATA_CLUSTERS)) && store(clusterItr.first->second.maxRestoreId, metadata::maxRestoreId().get(tr)) && clusterItr.first->second.tenantData.load(tr);
															#line 226 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 811 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont3loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterMetadataActor, 1, Void >*>(static_cast<LoadDataClusterMetadataActor*>(this)));
															#line 816 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 238 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 238 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 853 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 3;
															#line 238 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterMetadataActor, 2, Void >*>(static_cast<LoadDataClusterMetadataActor*>(this)));
															#line 858 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterMetadataActor*>(this)->ActorCallback< LoadDataClusterMetadataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadDataClusterMetadataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterMetadataActor*>(this)->ActorCallback< LoadDataClusterMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadDataClusterMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	MetaclusterData* self;
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	ClusterName clusterName;
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	ClusterConnectionString connectionString;
															#line 214 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	std::pair<typename std::map<ClusterName, DataClusterData>::iterator, bool> clusterItr;
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	Reference<IDatabase> dataDb;
															#line 219 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	Reference<ITransaction> tr;
															#line 1068 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
};
// This generated class is to be used only via loadDataClusterMetadata()
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadDataClusterMetadataActor final : public Actor<Void>, public ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >, public ActorCallback< LoadDataClusterMetadataActor, 1, Void >, public ActorCallback< LoadDataClusterMetadataActor, 2, Void >, public FastAllocated<LoadDataClusterMetadataActor>, public LoadDataClusterMetadataActorState<LoadDataClusterMetadataActor> {
															#line 1073 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
	using FastAllocated<LoadDataClusterMetadataActor>::operator new;
	using FastAllocated<LoadDataClusterMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3832785985224482048UL, 283593714121289984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< LoadDataClusterMetadataActor, 1, Void >;
friend struct ActorCallback< LoadDataClusterMetadataActor, 2, Void >;
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadDataClusterMetadataActor(MetaclusterData* const& self,ClusterName const& clusterName,ClusterConnectionString const& connectionString) 
															#line 1092 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		 : Actor<Void>(),
		   LoadDataClusterMetadataActorState<LoadDataClusterMetadataActor>(self, clusterName, connectionString),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18416461156053167360UL, 11229665651317824256UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadDataClusterMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadDataClusterMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadDataClusterMetadataActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadDataClusterMetadataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadDataClusterMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
[[nodiscard]] static Future<Void> loadDataClusterMetadata( MetaclusterData* const& self, ClusterName const& clusterName, ClusterConnectionString const& connectionString ) {
															#line 210 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	return Future<Void>(new LoadDataClusterMetadataActor(self, clusterName, connectionString));
															#line 1126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
}

#line 249 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"

																#line 1131 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
// This generated class is to be used only via load()
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
template <class LoadActor>
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadActorState {
															#line 1137 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadActorState(MetaclusterData* const& self) 
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		 : self(self)
															#line 1144 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
	{
		fdb_probe_actor_create("load", reinterpret_cast<unsigned long>(this));

	}
	~LoadActorState() 
	{
		fdb_probe_actor_destroy("load", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 251 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			StrictFuture<Void> __when_expr_0 = loadManagementClusterMetadata(self);
															#line 251 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1161 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadActor*>(this)->actor_wait_state = 1;
															#line 251 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 0, Void >*>(static_cast<LoadActor*>(this)));
															#line 1166 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		dataClusterFutures = std::vector<Future<Void>>();
															#line 254 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		for( auto [clusterName, clusterMetadata] : self->managementMetadata.dataClusters ) {
															#line 255 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			dataClusterFutures.push_back(loadDataClusterMetadata(self, clusterName, clusterMetadata.connectionString));
															#line 1193 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		}
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(dataClusterFutures);
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1199 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 1, Void >*>(static_cast<LoadActor*>(this)));
															#line 1204 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		dataClusterFutures = std::vector<Future<Void>>();
															#line 254 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		for( auto [clusterName, clusterMetadata] : self->managementMetadata.dataClusters ) {
															#line 255 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
			dataClusterFutures.push_back(loadDataClusterMetadata(self, clusterName, clusterMetadata.connectionString));
															#line 1217 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		}
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(dataClusterFutures);
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1223 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 1, Void >*>(static_cast<LoadActor*>(this)));
															#line 1228 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (!static_cast<LoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadActorState(); static_cast<LoadActor*>(this)->destroy(); return 0; }
															#line 1312 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		new (&static_cast<LoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
		if (!static_cast<LoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadActorState(); static_cast<LoadActor*>(this)->destroy(); return 0; }
															#line 1324 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		new (&static_cast<LoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	MetaclusterData* self;
															#line 253 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	std::vector<Future<Void>> dataClusterFutures;
															#line 1411 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
};
// This generated class is to be used only via load()
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
class LoadActor final : public Actor<Void>, public ActorCallback< LoadActor, 0, Void >, public ActorCallback< LoadActor, 1, Void >, public FastAllocated<LoadActor>, public LoadActorState<LoadActor> {
															#line 1416 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
public:
	using FastAllocated<LoadActor>::operator new;
	using FastAllocated<LoadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3493131288646515968UL, 7202165970748696064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadActor, 0, Void >;
friend struct ActorCallback< LoadActor, 1, Void >;
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	LoadActor(MetaclusterData* const& self) 
															#line 1434 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
		 : Actor<Void>(),
		   LoadActorState<LoadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9452025005965542912UL, 13383681653903659008UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("load");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
[[nodiscard]] static Future<Void> load( MetaclusterData* const& self ) {
															#line 250 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"
	return Future<Void>(new LoadActor(self));
															#line 1467 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterData.actor.g.h"
}

#line 262 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterData.actor.h"

public:
	MetaclusterData() {}
	MetaclusterData(Reference<DB> managementDb) : managementDb(managementDb) {}

	Future<Void> load() { return load(this); }
	Future<Void> loadDataCluster(ClusterName clusterName, ClusterConnectionString connectionString) {
		return loadDataClusterMetadata(this, clusterName, connectionString);
	}

	// Similar to operator==, but useful in assertions for identifying which member is different
	void assertEquals(MetaclusterData const& other) const {
		managementMetadata.assertEquals(other.managementMetadata);

		for (auto const& [name, data] : dataClusterMetadata) {
			auto itr = other.dataClusterMetadata.find(name);
			ASSERT(itr != other.dataClusterMetadata.end());
			data.assertEquals(itr->second);
		}

		ASSERT(dataClusterMetadata.size() == other.dataClusterMetadata.size());
	}

	bool operator==(MetaclusterData const& other) const {
		return managementMetadata == other.managementMetadata && dataClusterMetadata == other.dataClusterMetadata;
	}

	bool operator!=(MetaclusterData const& other) const { return !(*this == other); }
};
} // namespace metacluster::util

#include "flow/unactorcompiler.h"

#endif
