#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
/*
 * DcLag.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/StatusClient.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/CodeProbe.h"
#include "flow/NetworkAddress.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload tests a gray failure scenario: a satellite TLog is have network issue
// for sending packets to the remote data center's log routers. This will cause these
// log routers to fail to progress, and causing data center lag, i.e., lag between the
// primary and remote DC's tlogs. With changes to log routers, they can detect that the
// peek is taking a long time (> LOG_ROUTER_PEEK_SWITCH_DC_TIME) and switch to use
// another DC to get data, thus recovering from the data center lag.
struct DcLagWorkload : TestWorkload {
	static constexpr auto NAME = "DcLag";
	bool enabled;
	double testDuration;
	double startDelay;
	std::vector<std::pair<IPAddress, IPAddress>> cloggedPairs;

	DcLagWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 1000.0);
		startDelay = getOption(options, "startDelay"_sr, 10.0);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (g_network->isSimulated() && enabled)
			return timeout(reportErrors(clogClient(this, cx), "DcLagError"), testDuration, Void());
		else
			return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Clog a satellite tlog with all remote processes so that this triggers high
	// data center lag.
	bool clogTlog(double seconds) {
		ASSERT(dbInfo->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION);

		std::vector<IPAddress> ips; // all remote process IPs
		for (const auto& process : g_simulator->getAllProcesses()) {
			const auto& ip = process->address.ip;
			if (process->locality.dcId().present() && process->locality.dcId() == g_simulator->remoteDcId) {
				ips.push_back(ip);
			}
		}
		ASSERT(ips.size() > 0);

		// Find all primary satellite tlogs
		std::vector<NetworkAddress> logs; // all primary satellite logs
		for (const auto& tlogset : dbInfo->get().logSystemConfig.tLogs) {
			if (!tlogset.isLocal || tlogset.locality != tagLocalitySatellite)
				continue;
			for (const auto& log : tlogset.tLogs) {
				const NetworkAddress& addr = log.interf().address();
				logs.push_back(addr);
			}
		}
		if (logs.empty()) {
			// No satellite tlog found: fearless config may not have satellites
			return false;
		}

		// clog pairs
		auto tlog = logs[0].ip;
		for (const auto& ip : ips) {
			if (tlog != ip) {
				// Clog TLogReply messages, but allow peek/pop requests
				// g_simulator->clogPair(ip, tlog, seconds);
				g_simulator->clogPair(tlog, ip, seconds);
				cloggedPairs.emplace_back(tlog, ip);
			}
		}
		return true;
	}

	void unclogAll() {
		// unclog previously clogged connections
		for (const auto& pair : cloggedPairs) {
			g_simulator->unclogPair(pair.first, pair.second);
		}
		cloggedPairs.clear();
	}

																#line 122 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
// This generated class is to be used only via fetchDatacenterLag()
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
template <class FetchDatacenterLagActor>
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
class FetchDatacenterLagActorState {
															#line 128 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
public:
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	FetchDatacenterLagActorState(Database const& cx) 
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		 : cx(cx)
															#line 135 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	~FetchDatacenterLagActorState() 
	{
		fdb_probe_actor_destroy("fetchDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(cx);
															#line 121 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (static_cast<FetchDatacenterLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 152 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchDatacenterLagActor*>(this)->actor_wait_state = 1;
															#line 121 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchDatacenterLagActor, 0, StatusObject >*>(static_cast<FetchDatacenterLagActor*>(this)));
															#line 157 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchDatacenterLagActorState();
		static_cast<FetchDatacenterLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& result,int loopDepth) 
	{
															#line 122 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 123 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 124 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 184 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 125 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoCluster");
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 190 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 129 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader dcLag;
															#line 130 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!statusObjCluster.get("datacenter_lag", dcLag))
															#line 200 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoLagData");
															#line 132 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 206 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		Version versions = 0;
															#line 136 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		double seconds = 0;
															#line 137 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!dcLag.get("versions", versions))
															#line 218 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 138 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoVersions");
															#line 139 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 224 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 141 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!dcLag.get("seconds", seconds))
															#line 232 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 142 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoSeconds");
															#line 143 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 238 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 145 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		TraceEvent("DcLag").detail("Versions", versions).detail("Seconds", seconds);
															#line 146 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(seconds); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 248 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(seconds);
		this->~FetchDatacenterLagActorState();
		static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject && result,int loopDepth) 
	{
															#line 122 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 123 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 124 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 264 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 125 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoCluster");
															#line 126 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 270 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 129 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StatusObjectReader dcLag;
															#line 130 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!statusObjCluster.get("datacenter_lag", dcLag))
															#line 280 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoLagData");
															#line 132 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 286 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		Version versions = 0;
															#line 136 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		double seconds = 0;
															#line 137 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!dcLag.get("versions", versions))
															#line 298 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 138 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoVersions");
															#line 139 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 304 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 141 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!dcLag.get("seconds", seconds))
															#line 312 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 142 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagNoSeconds");
															#line 143 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 318 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~FetchDatacenterLagActorState();
			static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 145 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		TraceEvent("DcLag").detail("Versions", versions).detail("Seconds", seconds);
															#line 146 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!static_cast<FetchDatacenterLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(seconds); this->~FetchDatacenterLagActorState(); static_cast<FetchDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 328 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		new (&static_cast<FetchDatacenterLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(seconds);
		this->~FetchDatacenterLagActorState();
		static_cast<FetchDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(StatusObject const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchDatacenterLagActor*>(this)->actor_wait_state > 0) static_cast<FetchDatacenterLagActor*>(this)->actor_wait_state = 0;
		static_cast<FetchDatacenterLagActor*>(this)->ActorCallback< FetchDatacenterLagActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< FetchDatacenterLagActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchDatacenterLagActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchDatacenterLagActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	Database cx;
															#line 413 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
};
// This generated class is to be used only via fetchDatacenterLag()
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
class FetchDatacenterLagActor final : public Actor<Optional<double>>, public ActorCallback< FetchDatacenterLagActor, 0, StatusObject >, public FastAllocated<FetchDatacenterLagActor>, public FetchDatacenterLagActorState<FetchDatacenterLagActor> {
															#line 418 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
public:
	using FastAllocated<FetchDatacenterLagActor>::operator new;
	using FastAllocated<FetchDatacenterLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12226826556486969088UL, 14017057700994207744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<double>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchDatacenterLagActor, 0, StatusObject >;
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	FetchDatacenterLagActor(Database const& cx) 
															#line 435 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		 : Actor<Optional<double>>(),
		   FetchDatacenterLagActorState<FetchDatacenterLagActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7085704606527203584UL, 9875961645447242752UL);
		ActorExecutionContextHelper __helper(static_cast<FetchDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchDatacenterLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchDatacenterLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchDatacenterLagActor, 0, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
[[nodiscard]] static Future<Optional<double>> fetchDatacenterLag( Database const& cx ) {
															#line 120 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	return Future<Optional<double>>(new FetchDatacenterLagActor(cx));
															#line 467 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
}

#line 148 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"

																#line 472 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
// This generated class is to be used only via clogClient()
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
template <class ClogClientActor>
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
class ClogClientActorState {
															#line 478 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
public:
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	ClogClientActorState(DcLagWorkload* const& self,Database const& cx) 
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		 : self(self),
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		   cx(cx)
															#line 487 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
	{
		fdb_probe_actor_create("clogClient", reinterpret_cast<unsigned long>(this));

	}
	~ClogClientActorState() 
	{
		fdb_probe_actor_destroy("clogClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startDelay);
															#line 150 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 504 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClogClientActor*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 0, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 509 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		;
															#line 532 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		;
															#line 541 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 156 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		double startTime = now();
															#line 157 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		double workloadEnd = now() + self->testDuration;
															#line 158 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		TraceEvent("DcLag").detail("StartTime", startTime).detail("EndTime", workloadEnd);
															#line 161 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!self->clogTlog(self->testDuration))
															#line 631 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 162 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 635 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 165 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		status = Never();
															#line 166 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		lagged = false;
															#line 167 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		;
															#line 647 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED))
															#line 663 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 153 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 153 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 671 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 2;
															#line 153 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 1, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 676 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 168 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 167 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 794 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 172 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		StrictFuture<Optional<double>> __when_expr_3 = status;
															#line 798 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 3;
															#line 168 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 2, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 172 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 3, Optional<double> >*>(static_cast<ClogClientActor*>(this)));
															#line 805 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		status = fetchDatacenterLag(cx);
															#line 820 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		status = fetchDatacenterLag(cx);
															#line 829 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Optional<double> const& lag,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (lag.present() && lag.get() >= SERVER_KNOBS->LOG_ROUTER_PEEK_SWITCH_DC_TIME - 10.0)
															#line 838 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 175 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			lagged = true;
															#line 176 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagDetected");
															#line 844 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		}
															#line 178 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (lagged && lag.present() && lag.get() < 5.0)
															#line 848 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 179 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagRecovered");
															#line 180 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			self->unclogAll();
															#line 181 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 856 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 183 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		status = Never();
															#line 864 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Optional<double> && lag,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (lag.present() && lag.get() >= SERVER_KNOBS->LOG_ROUTER_PEEK_SWITCH_DC_TIME - 10.0)
															#line 873 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 175 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			lagged = true;
															#line 176 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagDetected");
															#line 879 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		}
															#line 178 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		if (lagged && lag.present() && lag.get() < 5.0)
															#line 883 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		{
															#line 179 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			TraceEvent("DcLagRecovered");
															#line 180 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			self->unclogAll();
															#line 181 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 891 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 183 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
		status = Never();
															#line 899 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 2, Void >::remove();
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 3, Optional<double> >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 3, Optional<double> >*,Optional<double> const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 3, Optional<double> >*,Optional<double> && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 3, Optional<double> >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	DcLagWorkload* self;
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	Database cx;
															#line 165 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	Future<Optional<double>> status;
															#line 166 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	bool lagged;
															#line 1033 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
};
// This generated class is to be used only via clogClient()
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
class ClogClientActor final : public Actor<Void>, public ActorCallback< ClogClientActor, 0, Void >, public ActorCallback< ClogClientActor, 1, Void >, public ActorCallback< ClogClientActor, 2, Void >, public ActorCallback< ClogClientActor, 3, Optional<double> >, public FastAllocated<ClogClientActor>, public ClogClientActorState<ClogClientActor> {
															#line 1038 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
public:
	using FastAllocated<ClogClientActor>::operator new;
	using FastAllocated<ClogClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15620043776333991680UL, 1847978041860281600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogClientActor, 0, Void >;
friend struct ActorCallback< ClogClientActor, 1, Void >;
friend struct ActorCallback< ClogClientActor, 2, Void >;
friend struct ActorCallback< ClogClientActor, 3, Optional<double> >;
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	ClogClientActor(DcLagWorkload* const& self,Database const& cx) 
															#line 1058 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
		 : Actor<Void>(),
		   ClogClientActorState<ClogClientActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6639068557903887104UL, 1016936592221440256UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClogClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClogClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
[[nodiscard]] Future<Void> clogClient( DcLagWorkload* const& self, Database const& cx ) {
															#line 149 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
	return Future<Void>(new ClogClientActor(self, cx));
															#line 1092 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DcLag.actor.g.cpp"
}

#line 187 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/workloads/DcLag.actor.cpp"
};

WorkloadFactory<DcLagWorkload> DcLagWorkloadFactory;