#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"
/*
 * BulkLoadUtil.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <memory>
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_BULKLOADUTIL_ACTOR_G_H)
#define FDBSERVER_BULKLOADUTIL_ACTOR_G_H
#include "fdbserver/BulkLoadUtil.actor.g.h"
#elif !defined(FDBSERVER_BULKLOADUTIL_ACTOR_H)
#define FDBSERVER_BULKLOADUTIL_ACTOR_H
#pragma once

#include "fdbclient/BulkLoading.h"
#include "flow/actorcompiler.h" // has to be last include

// Erase file folder
void clearFileFolder(const std::string& folderPath, const UID& logId = UID(), bool ignoreError = false);

// Erase and recreate file folder
void resetFileFolder(const std::string& folderPath);

// Asynchronously copy file from one path to another.
															#line 41 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<Void> copyBulkFile( std::string const& fromFile, std::string const& toFile, size_t const& fileBytesMax );

#line 40 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Asynchronously read file bytes from local file.
															#line 47 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<Void> readBulkFileBytes( std::string const& path, int64_t const& maxLength, std::shared_ptr<std::string> const& output );

#line 43 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Asynchronously write file bytes to local file.
															#line 53 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<Void> writeBulkFileBytes( std::string const& path, std::shared_ptr<std::string> const& content );

#line 46 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Get the bulkLoadTask metadata of the dataMoveMetadata since the atLeastVersion given the dataMoveId
// This actor is stuck if the actor is failed to read the dataMoveMetadata.
															#line 60 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<BulkLoadTaskState> getBulkLoadTaskStateFromDataMove( Database const& cx, UID const& dataMoveId, Version const& atLeastVersion, UID const& logId );

#line 53 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

															#line 65 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<BulkLoadFileSet> bulkLoadDownloadTaskFileSet( BulkLoadTransportMethod const& transportMethod, BulkLoadFileSet const& fromRemoteFileSet, std::string const& toLocalRoot, UID const& logId );

#line 58 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

															#line 70 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<Void> bulkLoadDownloadTaskFileSets( BulkLoadTransportMethod const& transportMethod, std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets, std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets, std::string const& toLocalRoot, UID const& logId );

#line 64 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

															#line 75 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<bool> doBytesSamplingOnDataFile( std::string const& dataFileFullPath, std::string const& byteSampleFileFullPath, UID const& logId );

#line 68 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Download job manifest file which is generated when dumping the data
															#line 81 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<Void> downloadBulkLoadJobManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& localJobManifestFilePath, std::string const& remoteJobManifestFilePath, UID const& logId );

#line 74 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Extract manifest entries from job manifest file with the input range
															#line 87 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<KeyRange> getBulkLoadJobFileManifestEntryFromJobManifestFile( std::string const& localJobManifestFilePath, KeyRange const& range, UID const& logId, std::shared_ptr<BulkLoadManifestFileMap> const& manifestMap );

#line 81 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

// Get BulkLoad manifest metadata from the entry in the job manifest file
															#line 93 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BulkLoadUtil.actor.g.h"
[[nodiscard]] Future<BulkLoadManifestSet> getBulkLoadManifestMetadataFromEntry( std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries, std::string const& manifestLocalTempFolder, BulkLoadTransportMethod const& transportMethod, std::string const& jobRoot, UID const& logId );

#line 89 "/codebuild/output/src2171772327/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BulkLoadUtil.actor.h"

#include "flow/unactorcompiler.h"
#endif
