#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
/*
 * TenantConsistency.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_TENANTCONSISTENCY_ACTOR_G_H)
#define METACLUSTER_TENANTCONSISTENCY_ACTOR_G_H
#include "metacluster/TenantConsistency.actor.g.h"
#elif !defined(METACLUSTER_TENANTCONSISTENCY_ACTOR_H)
#define METACLUSTER_TENANTCONSISTENCY_ACTOR_H

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/BooleanParam.h"
#include "flow/ThreadHelper.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantData.actor.h"
#include "fdbclient/TenantManagement.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace metacluster::util {
template <class DB, class TenantTypes>
class TenantConsistencyCheck {
private:
	TenantData<DB, TenantTypes> tenantData;

	// Note: this check can only be run on metaclusters with a reasonable number of tenants, as should be
	// the case with the current metacluster simulation workloads
	static inline const int metaclusterMaxTenants = 10e6;

	void validateTenantMetadataImpl() {
		ASSERT_EQ(tenantData.tenantMap.size(), tenantData.tenantCount);

		std::set<int64_t> tenantsInTenantGroupIndex;
		for (auto const& [groupName, tenants] : tenantData.tenantGroupIndex) {
			for (auto const& tenant : tenants) {
				tenantsInTenantGroupIndex.insert(tenant);
			}
		}

		for (auto [tenantId, tenantMapEntry] : tenantData.tenantMap) {
			ASSERT_EQ(tenantId, tenantMapEntry.id);
			ASSERT_EQ(tenantData.tenantNameIndex[tenantMapEntry.tenantName], tenantId);

			if (TenantAPI::getTenantIdPrefix(tenantId) == TenantAPI::getTenantIdPrefix(tenantData.lastTenantId)) {
				ASSERT_LE(tenantId, tenantData.lastTenantId);
			}

			if (tenantMapEntry.tenantGroup.present()) {
				auto tenantGroupMapItr = tenantData.tenantGroupMap.find(tenantMapEntry.tenantGroup.get());
				ASSERT(tenantGroupMapItr != tenantData.tenantGroupMap.end());
				ASSERT(tenantData.tenantGroupIndex[tenantMapEntry.tenantGroup.get()].count(tenantId));
			} else {
				ASSERT(!tenantsInTenantGroupIndex.count(tenantId));
			}
			ASSERT_NE(tenantMapEntry.tenantLockState == TenantAPI::TenantLockState::UNLOCKED,
			          tenantMapEntry.tenantLockId.present());
		}
	}

	// Specialization for TenantMapEntry, used on data and standalone clusters
	void validateTenantMetadata(TenantData<DB, StandardTenantTypes> tenantData) {
		ASSERT(tenantData.clusterType == ClusterType::METACLUSTER_DATA ||
		       tenantData.clusterType == ClusterType::STANDALONE);
		ASSERT_LE(tenantData.tenantMap.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
		ASSERT_EQ(tenantData.tenantNameIndex.size(), tenantData.tenantCount);

		validateTenantMetadataImpl();
	}

	// Specialization for MetaclusterTenantMapEntry, used on management clusters
	void validateTenantMetadata(TenantData<DB, MetaclusterTenantTypes> tenantData) {
		ASSERT_EQ(tenantData.clusterType, ClusterType::METACLUSTER_MANAGEMENT);
		ASSERT_LE(tenantData.tenantMap.size(), metaclusterMaxTenants);

		// Check metacluster specific properties
		int renameCount = 0;
		for (auto [tenantId, tenantMapEntry] : tenantData.tenantMap) {
			if (tenantMapEntry.tenantGroup.present()) {
				auto tenantGroupMapItr = tenantData.tenantGroupMap.find(tenantMapEntry.tenantGroup.get());
				ASSERT(tenantMapEntry.assignedCluster == tenantGroupMapItr->second.assignedCluster);
			}
			if (tenantMapEntry.renameDestination.present()) {
				ASSERT(tenantMapEntry.tenantState == TenantState::RENAMING ||
				       tenantMapEntry.tenantState == TenantState::REMOVING);

				auto nameIndexItr = tenantData.tenantNameIndex.find(tenantMapEntry.renameDestination.get());
				ASSERT(nameIndexItr != tenantData.tenantNameIndex.end());
				ASSERT_EQ(nameIndexItr->second, tenantMapEntry.id);
				++renameCount;
			} else {
				ASSERT_NE(tenantMapEntry.tenantState, TenantState::RENAMING);
			}

			// An error string should be set if and only if the tenant state is an error
			ASSERT((tenantMapEntry.tenantState == TenantState::ERROR) != tenantMapEntry.error.empty());
		}

		ASSERT_EQ(tenantData.tenantCount + renameCount, tenantData.tenantNameIndex.size());

		validateTenantMetadataImpl();
	}

	// Check that the tenant tombstones are properly cleaned up and only present on a metacluster data cluster
	void checkTenantTombstones() {
		if (tenantData.clusterType == ClusterType::METACLUSTER_DATA) {
			if (!tenantData.tombstoneCleanupData.present()) {
				ASSERT(tenantData.tenantTombstones.empty());
			}

			if (!tenantData.tenantTombstones.empty()) {
				ASSERT(*tenantData.tenantTombstones.begin() >
				       tenantData.tombstoneCleanupData.get().tombstonesErasedThrough);
			}
		} else {
			ASSERT(tenantData.tenantTombstones.empty() && !tenantData.tombstoneCleanupData.present());
		}
	}

																#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
// This generated class is to be used only via validateNoDataInRanges()
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
template <class ValidateNoDataInRangesActor>
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class ValidateNoDataInRangesActorState {
															#line 150 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	ValidateNoDataInRangesActorState(Reference<DB> const& db,Standalone<VectorRef<KeyRangeRef>> const& ranges) 
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		 : db(db),
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		   ranges(ranges),
															#line 143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		   rangeReadFutures(),
															#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		   rangeReadThreadFutures()
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
	{
		fdb_probe_actor_create("validateNoDataInRanges", reinterpret_cast<unsigned long>(this));

	}
	~ValidateNoDataInRangesActorState() 
	{
		fdb_probe_actor_destroy("validateNoDataInRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			std::vector<typename transaction_future_type<typename DB::TransactionT, RangeResult>::type>* ptr = std::addressof(rangeReadThreadFutures);
															#line 148 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			for( const auto& range : ranges ) {
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				Future<RangeResult> future = runTransaction(db, [range, ptr](Reference<typename DB::TransactionT> tr) { tr->setOption(FDBTransactionOptions::RAW_ACCESS); typename transaction_future_type<typename DB::TransactionT, RangeResult>::type f = tr->getRange(range, 1); ptr->emplace_back(f); return safeThreadFutureToFuture(f); });
															#line 156 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				rangeReadFutures.emplace_back(future);
															#line 184 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			}
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			StrictFuture<Void> __when_expr_0 = waitForAll(rangeReadFutures);
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (static_cast<ValidateNoDataInRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 190 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateNoDataInRangesActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateNoDataInRangesActor, 0, Void >*>(static_cast<ValidateNoDataInRangesActor*>(this)));
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateNoDataInRangesActorState();
		static_cast<ValidateNoDataInRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		for(size_t i = 0;i < ranges.size();++i) {
															#line 160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			auto f = rangeReadFutures[i];
															#line 161 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT(f.isReady());
															#line 162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			RangeResult rangeReadResult = f.get();
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (!rangeReadResult.empty())
															#line 226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			{
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				TraceEvent(SevError, "DataOutsideTenants") .detail("Count", rangeReadFutures.size()) .detail("Index", i) .detail("Begin", ranges[i].begin.toHexString()) .detail("End", ranges[i].end.toHexString()) .detail("RangeReadResult", rangeReadResult.toString()) .detail("ReadThrough", rangeReadResult.getReadThrough().toHexString());
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				ASSERT(false);
															#line 232 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			}
		}
															#line 174 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<ValidateNoDataInRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateNoDataInRangesActorState(); static_cast<ValidateNoDataInRangesActor*>(this)->destroy(); return 0; }
															#line 237 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<ValidateNoDataInRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateNoDataInRangesActorState();
		static_cast<ValidateNoDataInRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		for(size_t i = 0;i < ranges.size();++i) {
															#line 160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			auto f = rangeReadFutures[i];
															#line 161 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT(f.isReady());
															#line 162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			RangeResult rangeReadResult = f.get();
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (!rangeReadResult.empty())
															#line 257 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			{
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				TraceEvent(SevError, "DataOutsideTenants") .detail("Count", rangeReadFutures.size()) .detail("Index", i) .detail("Begin", ranges[i].begin.toHexString()) .detail("End", ranges[i].end.toHexString()) .detail("RangeReadResult", rangeReadResult.toString()) .detail("ReadThrough", rangeReadResult.getReadThrough().toHexString());
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				ASSERT(false);
															#line 263 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			}
		}
															#line 174 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<ValidateNoDataInRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateNoDataInRangesActorState(); static_cast<ValidateNoDataInRangesActor*>(this)->destroy(); return 0; }
															#line 268 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<ValidateNoDataInRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateNoDataInRangesActorState();
		static_cast<ValidateNoDataInRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateNoDataInRangesActor*>(this)->actor_wait_state > 0) static_cast<ValidateNoDataInRangesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateNoDataInRangesActor*>(this)->ActorCallback< ValidateNoDataInRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateNoDataInRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateNoDataInRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateNoDataInRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateNoDataInRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateNoDataInRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateNoDataInRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	Reference<DB> db;
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	std::vector<Future<RangeResult>> rangeReadFutures;
															#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	std::vector<typename transaction_future_type<typename DB::TransactionT, RangeResult>::type> rangeReadThreadFutures;
															#line 359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
};
// This generated class is to be used only via validateNoDataInRanges()
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class ValidateNoDataInRangesActor final : public Actor<Void>, public ActorCallback< ValidateNoDataInRangesActor, 0, Void >, public FastAllocated<ValidateNoDataInRangesActor>, public ValidateNoDataInRangesActorState<ValidateNoDataInRangesActor> {
															#line 364 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
	using FastAllocated<ValidateNoDataInRangesActor>::operator new;
	using FastAllocated<ValidateNoDataInRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(893872592728291072UL, 17795791840221617664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateNoDataInRangesActor, 0, Void >;
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	ValidateNoDataInRangesActor(Reference<DB> const& db,Standalone<VectorRef<KeyRangeRef>> const& ranges) 
															#line 381 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		 : Actor<Void>(),
		   ValidateNoDataInRangesActorState<ValidateNoDataInRangesActor>(db, ranges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12185905923149982208UL, 9674922867098233600UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateNoDataInRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateNoDataInRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateNoDataInRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateNoDataInRangesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
[[nodiscard]] static Future<Void> validateNoDataInRanges( Reference<DB> const& db, Standalone<VectorRef<KeyRangeRef>> const& ranges ) {
															#line 142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	return Future<Void>(new ValidateNoDataInRangesActor(db, ranges));
															#line 413 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
}

#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"

																#line 418 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
// This generated class is to be used only via checkNoDataOutsideTenantsInRequiredMode()
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
template <class CheckNoDataOutsideTenantsInRequiredModeActor>
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class CheckNoDataOutsideTenantsInRequiredModeActorState {
															#line 424 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	CheckNoDataOutsideTenantsInRequiredModeActorState(TenantConsistencyCheck<DB, StandardTenantTypes>* const& self) 
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		 : self(self),
															#line 179 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		   tenantModeFuture(runTransaction(self->tenantData.db, [](Reference<typename DB::TransactionT> tr) { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); return TenantAPI::getEffectiveTenantMode(tr); }))
															#line 433 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
	{
		fdb_probe_actor_create("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this));

	}
	~CheckNoDataOutsideTenantsInRequiredModeActorState() 
	{
		fdb_probe_actor_destroy("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			StrictFuture<TenantMode> __when_expr_0 = tenantModeFuture;
															#line 185 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 450 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state = 1;
															#line 185 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >*>(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)));
															#line 455 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckNoDataOutsideTenantsInRequiredModeActorState();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TenantMode const& tenantMode,int loopDepth) 
	{
															#line 186 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (tenantMode != TenantMode::REQUIRED)
															#line 478 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		{
															#line 187 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActorState(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->destroy(); return 0; }
															#line 482 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckNoDataOutsideTenantsInRequiredModeActorState();
			static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		CODE_PROBE(true, "Data or standalone cluster with tenant_mode=required");
															#line 191 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		int64_t prevId = -1;
															#line 192 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Key prevPrefix;
															#line 193 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Key prevGapStart;
															#line 194 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Standalone<VectorRef<KeyRangeRef>> gaps;
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		for( const auto& [id, entry] : self->tenantData.tenantMap ) {
															#line 196 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT(id > prevId);
															#line 197 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT_EQ(TenantAPI::idToPrefix(id), entry.prefix);
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (prevId >= 0)
															#line 506 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			{
															#line 199 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				ASSERT_GT(entry.prefix, prevPrefix);
															#line 510 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			}
															#line 201 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT_GE(entry.prefix, prevGapStart);
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			gaps.push_back_deep(gaps.arena(), KeyRangeRef(prevGapStart, entry.prefix));
															#line 203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevGapStart = strinc(entry.prefix);
															#line 204 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevId = id;
															#line 205 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevPrefix = entry.prefix;
															#line 522 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		}
															#line 207 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		ASSERT_LE(prevGapStart, "\xff"_sr);
															#line 208 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		gaps.push_back_deep(gaps.arena(), KeyRangeRef(prevGapStart, "\xff"_sr));
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = validateNoDataInRanges(self->tenantData.db, gaps);
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 532 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state = 2;
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*>(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)));
															#line 537 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TenantMode && tenantMode,int loopDepth) 
	{
															#line 186 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (tenantMode != TenantMode::REQUIRED)
															#line 546 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		{
															#line 187 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActorState(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->destroy(); return 0; }
															#line 550 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckNoDataOutsideTenantsInRequiredModeActorState();
			static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		CODE_PROBE(true, "Data or standalone cluster with tenant_mode=required");
															#line 191 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		int64_t prevId = -1;
															#line 192 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Key prevPrefix;
															#line 193 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Key prevGapStart;
															#line 194 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		Standalone<VectorRef<KeyRangeRef>> gaps;
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		for( const auto& [id, entry] : self->tenantData.tenantMap ) {
															#line 196 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT(id > prevId);
															#line 197 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT_EQ(TenantAPI::idToPrefix(id), entry.prefix);
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (prevId >= 0)
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			{
															#line 199 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
				ASSERT_GT(entry.prefix, prevPrefix);
															#line 578 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			}
															#line 201 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			ASSERT_GE(entry.prefix, prevGapStart);
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			gaps.push_back_deep(gaps.arena(), KeyRangeRef(prevGapStart, entry.prefix));
															#line 203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevGapStart = strinc(entry.prefix);
															#line 204 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevId = id;
															#line 205 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			prevPrefix = entry.prefix;
															#line 590 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		}
															#line 207 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		ASSERT_LE(prevGapStart, "\xff"_sr);
															#line 208 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		gaps.push_back_deep(gaps.arena(), KeyRangeRef(prevGapStart, "\xff"_sr));
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = validateNoDataInRanges(self->tenantData.db, gaps);
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state = 2;
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*>(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)));
															#line 605 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TenantMode const& tenantMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantMode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMode && tenantMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state > 0) static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >::remove();

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >*,TenantMode const& value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >*,TenantMode && value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >*,Error err) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActorState(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->destroy(); return 0; }
															#line 689 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckNoDataOutsideTenantsInRequiredModeActorState();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActorState(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->destroy(); return 0; }
															#line 701 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckNoDataOutsideTenantsInRequiredModeActorState();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state > 0) static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	TenantConsistencyCheck<DB, StandardTenantTypes>* self;
															#line 179 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	Future<TenantMode> tenantModeFuture;
															#line 788 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
};
// This generated class is to be used only via checkNoDataOutsideTenantsInRequiredMode()
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class CheckNoDataOutsideTenantsInRequiredModeActor final : public Actor<Void>, public ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >, public ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >, public FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor>, public CheckNoDataOutsideTenantsInRequiredModeActorState<CheckNoDataOutsideTenantsInRequiredModeActor> {
															#line 793 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
	using FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor>::operator new;
	using FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5123923332782630912UL, 6069546808272533760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >;
friend struct ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >;
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	CheckNoDataOutsideTenantsInRequiredModeActor(TenantConsistencyCheck<DB, StandardTenantTypes>* const& self) 
															#line 811 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		 : Actor<Void>(),
		   CheckNoDataOutsideTenantsInRequiredModeActorState<CheckNoDataOutsideTenantsInRequiredModeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10871667025836703232UL, 13549726681400217856UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkNoDataOutsideTenantsInRequiredMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 0, TenantMode >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
[[nodiscard]] static Future<Void> checkNoDataOutsideTenantsInRequiredMode( TenantConsistencyCheck<DB, StandardTenantTypes>* const& self ) {
															#line 177 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	return Future<Void>(new CheckNoDataOutsideTenantsInRequiredModeActor(self));
															#line 844 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
}

#line 212 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"

																#line 849 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
// This generated class is to be used only via checkNoDataOutsideTenantsInRequiredMode()
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
template <class CheckNoDataOutsideTenantsInRequiredModeActor1>
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class CheckNoDataOutsideTenantsInRequiredModeActor1State {
															#line 855 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	CheckNoDataOutsideTenantsInRequiredModeActor1State(TenantConsistencyCheck<DB, MetaclusterTenantTypes>* const& self) 
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		 : self(self),
															#line 216 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		   gaps()
															#line 864 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
	{
		fdb_probe_actor_create("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this));

	}
	~CheckNoDataOutsideTenantsInRequiredModeActor1State() 
	{
		fdb_probe_actor_destroy("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 217 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			gaps.push_back_deep(gaps.arena(), KeyRangeRef(""_sr, "metacluster/"_sr));
															#line 218 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			gaps.push_back_deep(gaps.arena(), KeyRangeRef("metacluster0"_sr, "tenant/"_sr));
															#line 219 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			gaps.push_back_deep(gaps.arena(), KeyRangeRef("tenant0"_sr, "\xff"_sr));
															#line 220 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			StrictFuture<Void> __when_expr_0 = validateNoDataInRanges(self->tenantData.db, gaps);
															#line 220 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 887 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->actor_wait_state = 1;
															#line 220 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >*>(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)));
															#line 892 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckNoDataOutsideTenantsInRequiredModeActor1State();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActor1State(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->destroy(); return 0; }
															#line 915 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckNoDataOutsideTenantsInRequiredModeActor1State();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckNoDataOutsideTenantsInRequiredModeActor1State(); static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->destroy(); return 0; }
															#line 927 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckNoDataOutsideTenantsInRequiredModeActor1State();
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->actor_wait_state > 0) static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->actor_wait_state = 0;
		static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	TenantConsistencyCheck<DB, MetaclusterTenantTypes>* self;
															#line 216 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	Standalone<VectorRef<KeyRangeRef>> gaps;
															#line 1014 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
};
// This generated class is to be used only via checkNoDataOutsideTenantsInRequiredMode()
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class CheckNoDataOutsideTenantsInRequiredModeActor1 final : public Actor<Void>, public ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >, public FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor1>, public CheckNoDataOutsideTenantsInRequiredModeActor1State<CheckNoDataOutsideTenantsInRequiredModeActor1> {
															#line 1019 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
	using FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor1>::operator new;
	using FastAllocated<CheckNoDataOutsideTenantsInRequiredModeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5123923332782630912UL, 6069546808272533760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >;
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	CheckNoDataOutsideTenantsInRequiredModeActor1(TenantConsistencyCheck<DB, MetaclusterTenantTypes>* const& self) 
															#line 1036 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		 : Actor<Void>(),
		   CheckNoDataOutsideTenantsInRequiredModeActor1State<CheckNoDataOutsideTenantsInRequiredModeActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11140385113112876544UL, 776770911995065600UL);
		ActorExecutionContextHelper __helper(static_cast<CheckNoDataOutsideTenantsInRequiredModeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkNoDataOutsideTenantsInRequiredMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkNoDataOutsideTenantsInRequiredMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckNoDataOutsideTenantsInRequiredModeActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
[[nodiscard]] static Future<Void> checkNoDataOutsideTenantsInRequiredMode( TenantConsistencyCheck<DB, MetaclusterTenantTypes>* const& self ) {
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	return Future<Void>(new CheckNoDataOutsideTenantsInRequiredModeActor1(self));
															#line 1068 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
}

#line 223 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"

																#line 1073 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
// This generated class is to be used only via run()
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
template <class RunActor>
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class RunActorState {
															#line 1079 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	RunActorState(TenantConsistencyCheck* const& self) 
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		 : self(self)
															#line 1086 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			StrictFuture<Void> __when_expr_0 = self->tenantData.load();
															#line 225 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1103 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 225 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 1108 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		self->validateTenantMetadata(self->tenantData);
															#line 227 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		self->checkTenantTombstones();
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = checkNoDataOutsideTenantsInRequiredMode(self);
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1137 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		self->validateTenantMetadata(self->tenantData);
															#line 227 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		self->checkTenantTombstones();
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = checkNoDataOutsideTenantsInRequiredMode(self);
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1246 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	TenantConsistencyCheck* self;
															#line 1343 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
};
// This generated class is to be used only via run()
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 1348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3601467908448617728UL, 16835779160224991744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	RunActor(TenantConsistencyCheck* const& self) 
															#line 1366 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
[[nodiscard]] static Future<Void> run( TenantConsistencyCheck* const& self ) {
															#line 224 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"
	return Future<Void>(new RunActor(self));
															#line 1399 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/TenantConsistency.actor.g.h"
}

#line 232 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/metacluster/include/metacluster/TenantConsistency.actor.h"

public:
	TenantConsistencyCheck() {}
	TenantConsistencyCheck(Reference<DB> db, TenantMetadataSpecification<TenantTypes>* tenantMetadata)
	  : tenantData(db, tenantMetadata) {}

	Future<Void> run() { return run(this); }
};
} // namespace metacluster::util

#include "flow/unactorcompiler.h"

#endif
