#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
/*
 * ChangeFeedOperations.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "flow/serialize.h"
#include <cstring>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

// enable to debug specific operations for a given change feed
#define DEBUG_KEY ""_sr

#define DEBUG_CF(feedKey) (feedKey.printable() == DEBUG_KEY)

															#line 45 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
namespace {
// This generated class is to be used only via doPop()
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class DoPopActor>
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoPopActorState {
															#line 52 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoPopActorState(Database const& cx,Key const& key,Key const& feedID,Version const& version,Version* const& doneOut) 
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   key(key),
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedID(feedID),
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   version(version),
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   doneOut(doneOut)
															#line 67 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("doPop", reinterpret_cast<unsigned long>(this));

	}
	~DoPopActorState() 
	{
		fdb_probe_actor_destroy("doPop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->popChangeFeedMutations(feedID, version);
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DoPopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 84 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoPopActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoPopActor, 0, Void >*>(static_cast<DoPopActor*>(this)));
															#line 89 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoPopActorState();
		static_cast<DoPopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (*doneOut < version)
															#line 112 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 46 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			*doneOut = version;
															#line 116 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 48 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(key))
															#line 120 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 49 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Popped through {1}\n", key.printable(), version);
															#line 124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 52 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoPopActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoPopActorState(); static_cast<DoPopActor*>(this)->destroy(); return 0; }
															#line 128 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoPopActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoPopActorState();
		static_cast<DoPopActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (*doneOut < version)
															#line 140 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 46 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			*doneOut = version;
															#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 48 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(key))
															#line 148 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 49 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Popped through {1}\n", key.printable(), version);
															#line 152 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 52 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoPopActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoPopActorState(); static_cast<DoPopActor*>(this)->destroy(); return 0; }
															#line 156 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoPopActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoPopActorState();
		static_cast<DoPopActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoPopActor*>(this)->actor_wait_state > 0) static_cast<DoPopActor*>(this)->actor_wait_state = 0;
		static_cast<DoPopActor*>(this)->ActorCallback< DoPopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoPopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoPopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoPopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPop", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Key key;
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Key feedID;
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version version;
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version* doneOut;
															#line 249 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via doPop()
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoPopActor final : public Actor<Void>, public ActorCallback< DoPopActor, 0, Void >, public FastAllocated<DoPopActor>, public DoPopActorState<DoPopActor> {
															#line 254 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<DoPopActor>::operator new;
	using FastAllocated<DoPopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7602958332592295936UL, 7007516499226205696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoPopActor, 0, Void >;
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoPopActor(Database const& cx,Key const& key,Key const& feedID,Version const& version,Version* const& doneOut) 
															#line 271 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   DoPopActorState<DoPopActor>(cx, key, feedID, version, doneOut),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doPop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1528768350428869120UL, 3911073667367625216UL);
		ActorExecutionContextHelper __helper(static_cast<DoPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doPop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doPop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoPopActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> doPop( Database const& cx, Key const& key, Key const& feedID, Version const& version, Version* const& doneOut ) {
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new DoPopActor(cx, key, feedID, version, doneOut));
															#line 304 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 54 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

struct FeedTestData : ReferenceCounted<FeedTestData>, NonCopyable {
	Key key;
	KeyRange keyRange;
	Key feedID;
	int nextVal;
	Future<Void> liveReader;
	bool lastCleared = false;

	std::vector<Future<Void>> pops;
	Version poppingVersion;
	Version poppedVersion;
	Optional<Version> stopVersion;
	bool destroying;
	bool destroyed;
	bool complete;

	int popWindow;
	int popDelayWindow;

	std::deque<std::pair<Version, Optional<Value>>> writesByVersion;

	// these were all committed
	std::deque<std::pair<Version, Optional<Value>>> pendingCheck;
	NotifiedVersion checkVersion;

	FeedTestData(Key key, bool doPops)
	  : key(key), keyRange(KeyRangeRef(key, keyAfter(key))), feedID(key.withPrefix("CF"_sr)), nextVal(0),
	    lastCleared(false), poppingVersion(0), poppedVersion(0), destroying(false), destroyed(false), complete(false),
	    checkVersion(0) {
		if (doPops) {
			popWindow = deterministicRandom()->randomExp(1, 8);
			popDelayWindow = deterministicRandom()->randomInt(0, 2) * deterministicRandom()->randomExp(1, 4);
		} else {
			popWindow = -1;
			popDelayWindow = -1;
		}
	}

	Value nextValue() {
		std::string v = std::to_string(nextVal);
		nextVal++;
		return Value(v);
	}

	void update(Version version, Optional<Value> value) {
		if (!stopVersion.present()) {
			// if feed is stopped, value should not get read
			writesByVersion.push_back({ version, value });
			pendingCheck.push_back(writesByVersion.back());
			checkVersion.set(version);
		}
	}

	void testComplete() {
		complete = true;
		checkVersion.set(checkVersion.get() + 1);
	}

	void pop(Database cx, Version v) {
		if (DEBUG_CF(key)) {
			fmt::print("DBG) {0} Popping through {1}\n", key.printable(), v);
		}
		ASSERT(poppingVersion < v);
		poppingVersion = v;
		while (!writesByVersion.empty() && v > writesByVersion.front().first) {
			writesByVersion.pop_front();
		}
		while (!pendingCheck.empty() && v > pendingCheck.front().first) {
			pendingCheck.pop_front();
		}
		pops.push_back(doPop(cx, key, feedID, v, &poppedVersion));
	}
};

static void rollbackFeed(Key key,
                         std::deque<Standalone<MutationsAndVersionRef>>& buffered,
                         Version version,
                         MutationRef rollbackMutation) {
	Version rollbackVersion;
	BinaryReader br(rollbackMutation.param2, Unversioned());
	br >> rollbackVersion;
	TraceEvent("ChangeFeedRollback").detail("Key", key).detail("Ver", version).detail("RollbackVer", rollbackVersion);
	if (DEBUG_CF(key)) {
		fmt::print("DBG) {0} Rolling back {1} -> {2}\n", key.printable(), version, rollbackVersion);
	}
	while (!buffered.empty() && buffered.back().version > rollbackVersion) {
		TraceEvent("ChangeFeedRollbackVer").detail("Ver", buffered.back().version);
		buffered.pop_back();
	}
}

static void checkNextResult(Key key,
                            std::deque<Standalone<MutationsAndVersionRef>>& buffered,
                            std::deque<std::pair<Version, Optional<Value>>>& checkData) {
	// First asserts are checking data is in the form the test is supposed to produce
	ASSERT(!buffered.empty());
	ASSERT(buffered.front().mutations.size() == 1);
	ASSERT(buffered.front().mutations[0].param1 == key);

	// Below asserts are correctness of change feed invariants.

	// Handle case where txn retried and wrote same value twice. checkData's version is the committed one, so the same
	// update may appear at an earlier version. This is fine, as long as it then actually appears at the committed
	// version
	// TODO: could strengthen this check a bit and only allow it to appear at the lower version if the txn retried on
	// commit_unknown_result?
	if (checkData.front().first < buffered.front().version) {
		fmt::print("ERROR. {0} Check version {1} != {2}.\n  Check: {3} {4}\n  Buffered: {5} {6}\n",
		           key.printable(),
		           checkData.front().first,
		           buffered.front().version,
		           checkData.front().second.present() ? "SET" : "CLEAR",
		           checkData.front().second.present() ? checkData.front().second.get().printable()
		                                              : keyAfter(key).printable(),
		           buffered.front().mutations[0].type == MutationRef::SetValue ? "SET" : "CLEAR",
		           buffered.front().mutations[0].param2.printable());
	}
	ASSERT(checkData.front().first >= buffered.front().version);

	if (checkData.front().second.present()) {
		ASSERT(buffered.front().mutations[0].type == MutationRef::SetValue);
		ASSERT(buffered.front().mutations[0].param2 == checkData.front().second.get());
	} else {
		ASSERT(buffered.front().mutations[0].type == MutationRef::ClearRange);
		ASSERT(buffered.front().mutations[0].param2 == keyAfter(key));
	}

	if (checkData.front().first == buffered.front().version) {
		checkData.pop_front();
	}
	buffered.pop_front();
}

															#line 442 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
namespace {
// This generated class is to be used only via liveReader()
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class LiveReaderActor>
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class LiveReaderActorState {
															#line 449 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	LiveReaderActorState(Database const& cx,Reference<FeedTestData> const& data,Version const& begin) 
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   data(data),
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   begin(begin),
															#line 189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   lastCheckVersion(0),
															#line 190 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   nextCheckVersion(0),
															#line 191 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   buffered(),
															#line 192 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   results(makeReference<ChangeFeedData>()),
															#line 193 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   stream(cx->getChangeFeedStream(results, data->feedID, begin, std::numeric_limits<Version>::max(), data->keyRange))
															#line 470 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("liveReader", reinterpret_cast<unsigned long>(this));

	}
	~LiveReaderActorState() 
	{
		fdb_probe_actor_destroy("liveReader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 196 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				;
															#line 486 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LiveReaderActorState();
		static_cast<LiveReaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 283 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 516 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 197 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (data->complete && data->pendingCheck.empty())
															#line 537 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (!static_cast<LiveReaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LiveReaderActorState(); static_cast<LiveReaderActor*>(this)->destroy(); return 0; }
															#line 541 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			new (&static_cast<LiveReaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LiveReaderActorState();
			static_cast<LiveReaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 200 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		nextCheckVersion = data->pendingCheck.empty() ? invalidVersion : data->pendingCheck.front().first;
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		auto __when_expr_0 = results->mutations.getFuture();
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value, "invalid type");
															#line 201 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<LiveReaderActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 555 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 232 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = data->checkVersion.whenAtLeast(lastCheckVersion + 1);
															#line 559 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 236 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_2 = data->pendingCheck.empty() ? Never() : results->whenAtLeast(data->pendingCheck.front().first);
															#line 563 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<LiveReaderActor*>(this)->actor_wait_state = 1;
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*>(static_cast<LiveReaderActor*>(this)));
															#line 232 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LiveReaderActor, 1, Void >*>(static_cast<LiveReaderActor*>(this)));
															#line 236 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LiveReaderActor, 2, Void >*>(static_cast<LiveReaderActor*>(this)));
															#line 572 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> const& res,int loopDepth) 
	{
															#line 203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for( auto& it : res ) {
															#line 204 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 589 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 205 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				rollbackFeed(data->key, buffered, it.version, it.mutations.back());
															#line 593 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 207 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.mutations.size() == 0)
															#line 599 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
				}
				else
				{
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (data->stopVersion.present())
															#line 606 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 212 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						if (it.version > data->stopVersion.get())
															#line 610 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						{
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
							fmt::print("DBG) {0} Read data with version {1} > stop version {2} ({3})\n", data->key.printable(), it.version, data->stopVersion.get(), it.mutations.size());
															#line 614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						}
															#line 219 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						ASSERT(it.version <= data->stopVersion.get());
															#line 618 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
															#line 221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					buffered.push_back(Standalone<MutationsAndVersionRef>(it));
															#line 222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (DEBUG_CF(data->key))
															#line 624 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 223 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						fmt::print("DBG) {0} Live read through {1} ({2})\n", data->key.printable(), it.version, it.mutations.size());
															#line 628 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> && res,int loopDepth) 
	{
															#line 203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for( auto& it : res ) {
															#line 204 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 643 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 205 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				rollbackFeed(data->key, buffered, it.version, it.mutations.back());
															#line 647 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 207 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.mutations.size() == 0)
															#line 653 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
				}
				else
				{
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (data->stopVersion.present())
															#line 660 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 212 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						if (it.version > data->stopVersion.get())
															#line 664 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						{
															#line 213 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
							fmt::print("DBG) {0} Read data with version {1} > stop version {2} ({3})\n", data->key.printable(), it.version, data->stopVersion.get(), it.mutations.size());
															#line 668 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						}
															#line 219 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						ASSERT(it.version <= data->stopVersion.get());
															#line 672 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
															#line 221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					buffered.push_back(Standalone<MutationsAndVersionRef>(it));
															#line 222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (DEBUG_CF(data->key))
															#line 678 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 223 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						fmt::print("DBG) {0} Live read through {1} ({2})\n", data->key.printable(), it.version, it.mutations.size());
															#line 682 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		lastCheckVersion = data->checkVersion.get();
															#line 695 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		lastCheckVersion = data->checkVersion.get();
															#line 704 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (data->pendingCheck.empty() || data->pendingCheck.front().first > nextCheckVersion)
															#line 713 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 243 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			CODE_PROBE(true, "popped while waiting for whenAtLeast to check next value");
															#line 717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 246 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for(;!buffered.empty() && buffered.front().version < data->poppingVersion;) {
															#line 247 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			CODE_PROBE(true, "live reader ignoring data that is being popped");
															#line 248 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			buffered.pop_front();
															#line 726 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (buffered.empty())
															#line 730 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (data->poppingVersion < data->pendingCheck.front().first && !data->destroying)
															#line 734 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 252 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Buffered empty after ready for check, and data not popped! popped " "{1}, popping {2}, check {3}\n", data->key.printable(), data->poppedVersion, data->poppingVersion, data->pendingCheck.front().first);
															#line 738 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 259 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			ASSERT(data->poppingVersion >= data->pendingCheck.front().first || data->destroying);
															#line 260 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			data->pendingCheck.pop_front();
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
		else
		{
															#line 262 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			Version v = buffered.front().version;
															#line 263 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(data->key))
															#line 752 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Live checking through {1}\n", data->key.printable(), data->pendingCheck.front().first);
															#line 756 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 268 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			checkNextResult(data->key, buffered, data->pendingCheck);
															#line 269 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(data->key))
															#line 762 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Live Checked through {1}\n", data->key.printable(), v);
															#line 766 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 273 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (data->popDelayWindow >= 0 && data->popWindow >= 0 && data->writesByVersion.size() == data->popWindow + data->popDelayWindow)
															#line 770 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				data->pop(cx, data->writesByVersion[data->popWindow - 1].first + 1);
															#line 276 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				ASSERT(data->writesByVersion.size() == data->popDelayWindow);
															#line 776 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (data->pendingCheck.empty() || data->pendingCheck.front().first > nextCheckVersion)
															#line 787 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 243 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			CODE_PROBE(true, "popped while waiting for whenAtLeast to check next value");
															#line 791 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 246 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for(;!buffered.empty() && buffered.front().version < data->poppingVersion;) {
															#line 247 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			CODE_PROBE(true, "live reader ignoring data that is being popped");
															#line 248 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			buffered.pop_front();
															#line 800 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (buffered.empty())
															#line 804 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (data->poppingVersion < data->pendingCheck.front().first && !data->destroying)
															#line 808 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 252 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Buffered empty after ready for check, and data not popped! popped " "{1}, popping {2}, check {3}\n", data->key.printable(), data->poppedVersion, data->poppingVersion, data->pendingCheck.front().first);
															#line 812 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 259 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			ASSERT(data->poppingVersion >= data->pendingCheck.front().first || data->destroying);
															#line 260 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			data->pendingCheck.pop_front();
															#line 818 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
		else
		{
															#line 262 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			Version v = buffered.front().version;
															#line 263 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(data->key))
															#line 826 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Live checking through {1}\n", data->key.printable(), data->pendingCheck.front().first);
															#line 830 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 268 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			checkNextResult(data->key, buffered, data->pendingCheck);
															#line 269 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(data->key))
															#line 836 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Live Checked through {1}\n", data->key.printable(), v);
															#line 840 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 273 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (data->popDelayWindow >= 0 && data->popWindow >= 0 && data->writesByVersion.size() == data->popWindow + data->popDelayWindow)
															#line 844 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				data->pop(cx, data->writesByVersion[data->popWindow - 1].first + 1);
															#line 276 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				ASSERT(data->writesByVersion.size() == data->popDelayWindow);
															#line 850 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LiveReaderActor*>(this)->actor_wait_state > 0) static_cast<LiveReaderActor*>(this)->actor_wait_state = 0;
		static_cast<LiveReaderActor*>(this)->ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >::remove();
		static_cast<LiveReaderActor*>(this)->ActorCallback< LiveReaderActor, 1, Void >::remove();
		static_cast<LiveReaderActor*>(this)->ActorCallback< LiveReaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> const& value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> && value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LiveReaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LiveReaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LiveReaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LiveReaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LiveReaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LiveReaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> data;
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version begin;
															#line 189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version lastCheckVersion;
															#line 190 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version nextCheckVersion;
															#line 191 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	std::deque<Standalone<MutationsAndVersionRef>> buffered;
															#line 192 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<ChangeFeedData> results;
															#line 193 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Future<Void> stream;
															#line 1052 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via liveReader()
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class LiveReaderActor final : public Actor<Void>, public ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >, public ActorCallback< LiveReaderActor, 1, Void >, public ActorCallback< LiveReaderActor, 2, Void >, public FastAllocated<LiveReaderActor>, public LiveReaderActorState<LiveReaderActor> {
															#line 1057 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<LiveReaderActor>::operator new;
	using FastAllocated<LiveReaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11331531975034942208UL, 16826973418414013440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >;
friend struct ActorCallback< LiveReaderActor, 1, Void >;
friend struct ActorCallback< LiveReaderActor, 2, Void >;
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	LiveReaderActor(Database const& cx,Reference<FeedTestData> const& data,Version const& begin) 
															#line 1076 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   LiveReaderActorState<LiveReaderActor>(cx, data, begin),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("liveReader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4186250403760151552UL, 6513688807721899520UL);
		ActorExecutionContextHelper __helper(static_cast<LiveReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("liveReader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("liveReader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LiveReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> liveReader( Database const& cx, Reference<FeedTestData> const& data, Version const& begin ) {
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new LiveReaderActor(cx, data, begin));
															#line 1109 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 286 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

															#line 1114 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
namespace {
// This generated class is to be used only via historicReader()
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class HistoricReaderActor>
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class HistoricReaderActorState {
															#line 1121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	HistoricReaderActorState(Database const& cx,Reference<FeedTestData> const& data,Version const& begin,Version const& end,bool const& skipPopped) 
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   data(data),
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   begin(begin),
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   end(end),
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   skipPopped(skipPopped),
															#line 292 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   checkData(),
															#line 293 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   buffered(),
															#line 294 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   results(makeReference<ChangeFeedData>()),
															#line 295 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   stream(cx->getChangeFeedStream(results, data->feedID, begin, end, data->keyRange))
															#line 1144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("historicReader", reinterpret_cast<unsigned long>(this));

	}
	~HistoricReaderActorState() 
	{
		fdb_probe_actor_destroy("historicReader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 298 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(data->key))
															#line 1159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Starting historical read {1} - {2}\n", data->key.printable(), begin, end);
															#line 1163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 303 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			for( auto& it : data->writesByVersion ) {
															#line 304 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.first >= end)
															#line 1169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
					break;
				}
															#line 307 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.first >= begin)
															#line 1175 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 308 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					checkData.push_back(it);
															#line 1179 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
			try {
															#line 313 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				;
															#line 1185 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HistoricReaderActorState();
		static_cast<HistoricReaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 337 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (skipPopped)
															#line 1214 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			for(;!buffered.empty() && buffered.front().version < data->poppingVersion;) {
															#line 340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				buffered.pop_front();
															#line 1220 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 342 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			for(;!checkData.empty() && checkData.front().first < data->poppingVersion;) {
															#line 343 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				checkData.pop_front();
															#line 1226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
		}
															#line 347 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for(;!checkData.empty() && !buffered.empty();) {
															#line 348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			checkNextResult(data->key, buffered, checkData);
															#line 1233 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		ASSERT(checkData.empty());
															#line 353 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		ASSERT(buffered.empty());
															#line 362 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<HistoricReaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HistoricReaderActorState(); static_cast<HistoricReaderActor*>(this)->destroy(); return 0; }
															#line 1241 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<HistoricReaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HistoricReaderActorState();
		static_cast<HistoricReaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 332 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 1254 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 333 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		auto __when_expr_0 = results->mutations.getFuture();
															#line 1281 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value, "invalid type");
															#line 314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<HistoricReaderActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1285 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HistoricReaderActor*>(this)->actor_wait_state = 1;
															#line 314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*>(static_cast<HistoricReaderActor*>(this)));
															#line 1290 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<VectorRef<MutationsAndVersionRef>> const& res,int loopDepth) 
	{
															#line 315 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for( auto& it : res ) {
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 1301 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 317 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				rollbackFeed(data->key, buffered, it.version, it.mutations.back());
															#line 1305 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 319 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.mutations.size() == 0)
															#line 1311 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
				}
				else
				{
															#line 323 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (data->stopVersion.present())
															#line 1318 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						ASSERT(it.version <= data->stopVersion.get());
															#line 1322 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
															#line 326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					buffered.push_back(Standalone<MutationsAndVersionRef>(it));
															#line 1326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<VectorRef<MutationsAndVersionRef>> && res,int loopDepth) 
	{
															#line 315 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		for( auto& it : res ) {
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 1340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 317 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				rollbackFeed(data->key, buffered, it.version, it.mutations.back());
															#line 1344 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 319 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (it.mutations.size() == 0)
															#line 1350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
				}
				else
				{
															#line 323 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (data->stopVersion.present())
															#line 1357 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						ASSERT(it.version <= data->stopVersion.get());
															#line 1361 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					}
															#line 326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					buffered.push_back(Standalone<MutationsAndVersionRef>(it));
															#line 1365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HistoricReaderActor*>(this)->actor_wait_state > 0) static_cast<HistoricReaderActor*>(this)->actor_wait_state = 0;
		static_cast<HistoricReaderActor*>(this)->ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> const& value) 
	{
		fdb_probe_actor_enter("historicReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HistoricReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("historicReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> && value) 
	{
		fdb_probe_actor_enter("historicReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HistoricReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("historicReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("historicReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HistoricReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("historicReader", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> data;
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version begin;
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Version end;
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	bool skipPopped;
															#line 292 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	std::deque<std::pair<Version, Optional<Value>>> checkData;
															#line 293 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	std::deque<Standalone<MutationsAndVersionRef>> buffered;
															#line 294 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<ChangeFeedData> results;
															#line 295 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Future<Void> stream;
															#line 1466 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via historicReader()
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class HistoricReaderActor final : public Actor<Void>, public ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >, public FastAllocated<HistoricReaderActor>, public HistoricReaderActorState<HistoricReaderActor> {
															#line 1471 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<HistoricReaderActor>::operator new;
	using FastAllocated<HistoricReaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3871135325489520384UL, 6775227924704480000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >;
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	HistoricReaderActor(Database const& cx,Reference<FeedTestData> const& data,Version const& begin,Version const& end,bool const& skipPopped) 
															#line 1488 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   HistoricReaderActorState<HistoricReaderActor>(cx, data, begin, end, skipPopped),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("historicReader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(64962147716904448UL, 6845680170344618240UL);
		ActorExecutionContextHelper __helper(static_cast<HistoricReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("historicReader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("historicReader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HistoricReaderActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> historicReader( Database const& cx, Reference<FeedTestData> const& data, Version const& begin, Version const& end, bool const& skipPopped ) {
															#line 287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new HistoricReaderActor(cx, data, begin, end, skipPopped));
															#line 1521 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 364 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

enum Op {
	CREATE_DELETE = 0,
	READ = 1,
	UPDATE_CLEAR = 2,
	STOP = 3,
	POP = 4,
	OP_COUNT = 5 /* keep this last */
};

struct ChangeFeedOperationsWorkload : TestWorkload {
	static constexpr auto NAME = "ChangeFeedOperations";
	// test settings
	double testDuration;
	int operationsPerSecond;
	int targetFeeds;
	bool clientsDisjointKeyspace;
	bool clearKeyWhenDestroy;
	double clearFrequency;
	int popMode;

	int opWeights[Op::OP_COUNT];
	int totalOpWeight;

	Future<Void> client;
	std::unordered_set<Key> usedKeys;
	std::vector<Reference<FeedTestData>> data;

	ChangeFeedOperationsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		operationsPerSecond = getOption(options, "opsPerSecond"_sr, 100.0);
		int64_t rand = wcx.sharedRandomNumber;
		targetFeeds = deterministicRandom()->randomExp(1, 1 + rand % 10);
		targetFeeds *= (0.8 + (deterministicRandom()->random01() * 0.4));
		targetFeeds = std::max(1, targetFeeds / clientCount);
		rand /= 10;
		clientsDisjointKeyspace = rand % 2;
		rand /= 2;
		clearKeyWhenDestroy = rand % 2;
		rand /= 2;
		bool doStops = rand % 2;
		rand /= 2;
		bool noCreateDelete = rand % 10 == 0;
		rand /= 10;
		popMode = rand % 3; // 0=none, 1=read-driven, 2=op-driven
		rand /= 3;

		ASSERT(clientId >= 0);
		ASSERT(clientId < clientCount);
		ASSERT(clientCount < 255);

		clearFrequency = deterministicRandom()->random01();

		for (int i = 0; i < Op::OP_COUNT; i++) {
			int randWeight = deterministicRandom()->randomExp(0, 5);
			ASSERT(randWeight > 0);
			opWeights[i] = randWeight;
		}

		if (!doStops) {
			opWeights[Op::STOP] = 0;
		}
		if (noCreateDelete) {
			opWeights[Op::CREATE_DELETE] = 0;
		}
		if (popMode != 2) {
			opWeights[Op::POP] = 0;
		}

		std::string weightString = "|";
		totalOpWeight = 0;
		for (int i = 0; i < Op::OP_COUNT; i++) {
			totalOpWeight += opWeights[i];
			weightString += std::to_string(opWeights[i]) + "|";
		}

		TraceEvent("ChangeFeedOperationsInit")
		    .detail("TargetFeeds", targetFeeds)
		    .detail("DisjointKeyspace", clientsDisjointKeyspace)
		    .detail("ClearWhenDestroy", clearKeyWhenDestroy)
		    .detail("DoStops", doStops)
		    .detail("NoCreateDelete", noCreateDelete)
		    .detail("Weights", weightString);
	}

	Key unusedNewRandomKey() {
		while (true) {
			Key k = newRandomKey();
			if (usedKeys.insert(k).second) {
				return k;
			}
		}
	}

	Key newRandomKey() {
		if (clientsDisjointKeyspace) {
			double keyspaceRange = (1.0 / clientCount);
			double randPartOfRange = deterministicRandom()->random01() * (keyspaceRange - 0.0001);
			double randomDouble = clientId * keyspaceRange + 0.0001 + randPartOfRange;
			return doubleToTestKey(randomDouble);
		} else {
			// this is kinda hacky but it guarantees disjoint keys per client
			Key ret = doubleToTestKey(deterministicRandom()->random01());
			std::string str = ret.toString();
			str.back() = (uint8_t)clientId;
			return Key(str);
		}
	}

	// Pick op with weighted average
	Op pickRandomOp() {
		int r = deterministicRandom()->randomInt(0, totalOpWeight);
		int i = 0;
		while (i < Op::OP_COUNT && (opWeights[i] <= r || opWeights[i] == 0)) {
			r -= opWeights[i];
			i++;
		}
		ASSERT(i < Op::OP_COUNT);
		return (Op)i;
	}

																#line 1646 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via createNewFeed()
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class CreateNewFeedActor>
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class CreateNewFeedActorState {
															#line 1652 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	CreateNewFeedActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self),
															#line 486 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   tr(cx),
															#line 487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   key(self->unusedNewRandomKey()),
															#line 488 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(makeReference<FeedTestData>(key, self->popMode == 1)),
															#line 489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   initialValue(feedData->nextValue())
															#line 1669 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("createNewFeed", reinterpret_cast<unsigned long>(this));

	}
	~CreateNewFeedActorState() 
	{
		fdb_probe_actor_destroy("createNewFeed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 491 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(key))
															#line 1684 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 492 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) Creating {0}\n", key.printable());
															#line 1688 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 495 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			;
															#line 1692 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateNewFeedActorState();
		static_cast<CreateNewFeedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 497 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			tr.set(key, initialValue);
															#line 498 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateChangeFeed(&tr, feedData->feedID, ChangeFeedStatus::CHANGE_FEED_CREATE, feedData->keyRange);
															#line 498 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1727 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 1;
															#line 498 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateNewFeedActor, 0, Void >*>(static_cast<CreateNewFeedActor*>(this)));
															#line 1732 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 512 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 512 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1756 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 3;
															#line 512 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateNewFeedActor, 2, Void >*>(static_cast<CreateNewFeedActor*>(this)));
															#line 1761 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1778 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 2;
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateNewFeedActor, 1, Void >*>(static_cast<CreateNewFeedActor*>(this)));
															#line 1783 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1794 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 2;
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateNewFeedActor, 1, Void >*>(static_cast<CreateNewFeedActor*>(this)));
															#line 1799 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state > 0) static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNewFeedActor*>(this)->ActorCallback< CreateNewFeedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateNewFeedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 501 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version createVersion = tr.getCommittedVersion();
															#line 502 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(key))
															#line 1885 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) Created {0} @ {1}\n", key.printable(), createVersion);
															#line 1889 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->update(createVersion, initialValue);
															#line 506 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->liveReader = liveReader(cx, feedData, createVersion);
															#line 508 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		self->data.push_back(feedData);
															#line 510 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<CreateNewFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateNewFeedActorState(); static_cast<CreateNewFeedActor*>(this)->destroy(); return 0; }
															#line 1899 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<CreateNewFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateNewFeedActorState();
		static_cast<CreateNewFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 501 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version createVersion = tr.getCommittedVersion();
															#line 502 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(key))
															#line 1913 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) Created {0} @ {1}\n", key.printable(), createVersion);
															#line 1917 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->update(createVersion, initialValue);
															#line 506 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->liveReader = liveReader(cx, feedData, createVersion);
															#line 508 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		self->data.push_back(feedData);
															#line 510 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<CreateNewFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateNewFeedActorState(); static_cast<CreateNewFeedActor*>(this)->destroy(); return 0; }
															#line 1927 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<CreateNewFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateNewFeedActorState();
		static_cast<CreateNewFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state > 0) static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNewFeedActor*>(this)->ActorCallback< CreateNewFeedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateNewFeedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateNewFeedActor*>(this)->actor_wait_state > 0) static_cast<CreateNewFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNewFeedActor*>(this)->ActorCallback< CreateNewFeedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateNewFeedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateNewFeedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 486 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Transaction tr;
															#line 487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Key key;
															#line 488 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Value initialValue;
															#line 2109 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via createNewFeed()
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class CreateNewFeedActor final : public Actor<Void>, public ActorCallback< CreateNewFeedActor, 0, Void >, public ActorCallback< CreateNewFeedActor, 1, Void >, public ActorCallback< CreateNewFeedActor, 2, Void >, public FastAllocated<CreateNewFeedActor>, public CreateNewFeedActorState<CreateNewFeedActor> {
															#line 2114 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<CreateNewFeedActor>::operator new;
	using FastAllocated<CreateNewFeedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7311867484535657216UL, 8944580250958631168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateNewFeedActor, 0, Void >;
friend struct ActorCallback< CreateNewFeedActor, 1, Void >;
friend struct ActorCallback< CreateNewFeedActor, 2, Void >;
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	CreateNewFeedActor(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 2133 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   CreateNewFeedActorState<CreateNewFeedActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createNewFeed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10733331713937524992UL, 16758289472984696576UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNewFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createNewFeed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createNewFeed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateNewFeedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateNewFeedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateNewFeedActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> createNewFeed( Database const& cx, ChangeFeedOperationsWorkload* const& self ) {
															#line 485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new CreateNewFeedActor(cx, self));
															#line 2167 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 516 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 2174 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class _setupActor>
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class _setupActorState {
															#line 2180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	_setupActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self)
															#line 2189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 521 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			TraceEvent("ChangeFeedOperationsSetup").detail("InitialFeeds", self->targetFeeds).log();
															#line 522 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			i = int();
															#line 523 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			i = 0;
															#line 2208 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 526 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		TraceEvent("ChangeFeedOperationsSetupComplete");
															#line 527 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2233 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 523 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!(i < self->targetFeeds))
															#line 2252 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 524 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->createNewFeed(cx, self);
															#line 524 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2260 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 524 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 2265 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 523 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		i++;
															#line 2287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 523 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		i++;
															#line 2296 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 522 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	int i;
															#line 2382 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 2387 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8930995196927428608UL, 9478527525969359616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	_setupActor(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 2404 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, ChangeFeedOperationsWorkload* const& self ) {
															#line 519 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 2436 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 529 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

	Future<Void> start(Database const& cx) override {
		client = changeFeedOperationsClient(cx->clone(), this);
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		client = Future<Void>();
		return _check(cx, this);
	}

																#line 2450 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via checkFeed()
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class CheckFeedActor>
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class CheckFeedActorState {
															#line 2456 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	CheckFeedActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self,Reference<FeedTestData> const& feedData) 
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self),
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(feedData),
															#line 540 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   popIdx()
															#line 2469 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFeed", reinterpret_cast<unsigned long>(this));

	}
	~CheckFeedActorState() 
	{
		fdb_probe_actor_destroy("checkFeed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 541 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			feedData->testComplete();
															#line 543 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 2486 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 544 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("Final check {0} waiting on live reader\n", feedData->key.printable());
															#line 2490 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 547 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = feedData->liveReader;
															#line 547 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<CheckFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2496 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckFeedActor*>(this)->actor_wait_state = 1;
															#line 547 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFeedActor, 0, Void >*>(static_cast<CheckFeedActor*>(this)));
															#line 2501 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFeedActorState();
		static_cast<CheckFeedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 548 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 2524 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 549 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("Final check {0} waiting on {1} pops\n", feedData->key.printable(), feedData->pops.size());
															#line 2528 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		popIdx = 0;
															#line 2532 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 548 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 2541 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 549 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("Final check {0} waiting on {1} pops\n", feedData->key.printable(), feedData->pops.size());
															#line 2545 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		popIdx = 0;
															#line 2549 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedActor*>(this)->ActorCallback< CheckFeedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFeedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 556 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 2633 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 557 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("Final check {0} waiting on data check\n", feedData->key.printable(), feedData->pops.size());
															#line 2637 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 559 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->doRead(cx, feedData, feedData->writesByVersion.size());
															#line 559 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2643 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckFeedActor*>(this)->actor_wait_state = 3;
															#line 559 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckFeedActor, 2, Void >*>(static_cast<CheckFeedActor*>(this)));
															#line 2648 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!(popIdx < feedData->pops.size()))
															#line 2664 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 552 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = feedData->pops[popIdx];
															#line 552 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2672 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckFeedActor*>(this)->actor_wait_state = 2;
															#line 552 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckFeedActor, 1, Void >*>(static_cast<CheckFeedActor*>(this)));
															#line 2677 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		popIdx++;
															#line 2699 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		popIdx++;
															#line 2708 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedActor*>(this)->ActorCallback< CheckFeedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckFeedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (feedData->poppedVersion > 0)
															#line 2792 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 563 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 2796 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 564 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print( "Final check {0} waiting on read popped check\n", feedData->key.printable(), feedData->pops.size());
															#line 2800 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_3 = historicReader(cx, feedData, 0, feedData->poppedVersion, true);
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<CheckFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2806 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFeedActor*>(this)->actor_wait_state = 4;
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFeedActor, 3, Void >*>(static_cast<CheckFeedActor*>(this)));
															#line 2811 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (feedData->poppedVersion > 0)
															#line 2825 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 563 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 2829 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 564 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print( "Final check {0} waiting on read popped check\n", feedData->key.printable(), feedData->pops.size());
															#line 2833 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_3 = historicReader(cx, feedData, 0, feedData->poppedVersion, true);
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<CheckFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2839 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFeedActor*>(this)->actor_wait_state = 4;
															#line 568 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFeedActor, 3, Void >*>(static_cast<CheckFeedActor*>(this)));
															#line 2844 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedActor*>(this)->ActorCallback< CheckFeedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckFeedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 571 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<CheckFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFeedActorState(); static_cast<CheckFeedActor*>(this)->destroy(); return 0; }
															#line 2933 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<CheckFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckFeedActorState();
		static_cast<CheckFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckFeedActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedActor*>(this)->ActorCallback< CheckFeedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckFeedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckFeedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 540 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	int popIdx;
															#line 3036 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via checkFeed()
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class CheckFeedActor final : public Actor<Void>, public ActorCallback< CheckFeedActor, 0, Void >, public ActorCallback< CheckFeedActor, 1, Void >, public ActorCallback< CheckFeedActor, 2, Void >, public ActorCallback< CheckFeedActor, 3, Void >, public FastAllocated<CheckFeedActor>, public CheckFeedActorState<CheckFeedActor> {
															#line 3041 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<CheckFeedActor>::operator new;
	using FastAllocated<CheckFeedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18036450604230604800UL, 1850957935278463744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFeedActor, 0, Void >;
friend struct ActorCallback< CheckFeedActor, 1, Void >;
friend struct ActorCallback< CheckFeedActor, 2, Void >;
friend struct ActorCallback< CheckFeedActor, 3, Void >;
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	CheckFeedActor(Database const& cx,ChangeFeedOperationsWorkload* const& self,Reference<FeedTestData> const& feedData) 
															#line 3061 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFeedActorState<CheckFeedActor>(cx, self, feedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFeed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3125811655670786048UL, 17328261561509134592UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFeed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFeed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFeedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckFeedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckFeedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckFeedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> checkFeed( Database const& cx, ChangeFeedOperationsWorkload* const& self, Reference<FeedTestData> const& feedData ) {
															#line 539 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new CheckFeedActor(cx, self, feedData));
															#line 3096 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 573 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

																#line 3101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class _checkActor>
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class _checkActorState {
															#line 3107 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	_checkActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self)
															#line 3116 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 575 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			TraceEvent("ChangeFeedOperationsCheck").detail("FeedCount", self->data.size()).log();
															#line 576 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("Checking {0} feeds\n", self->data.size());
															#line 577 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			feedChecks = std::vector<Future<Void>>();
															#line 578 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			for(int i = 0;i < self->data.size();i++) {
															#line 579 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (self->data[i]->destroying)
															#line 3139 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
					continue;
				}
															#line 582 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (DEBUG_CF(self->data[i]->key))
															#line 3145 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 583 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					fmt::print("Final check {0}\n", self->data[i]->key.printable());
															#line 3149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
															#line 585 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				feedChecks.push_back(self->checkFeed(cx, self, self->data[i]));
															#line 3153 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 587 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(feedChecks);
															#line 587 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 587 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 3164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 589 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		TraceEvent("ChangeFeedOperationsCheckComplete");
															#line 590 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 589 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		TraceEvent("ChangeFeedOperationsCheckComplete");
															#line 590 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 577 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	std::vector<Future<Void>> feedChecks;
															#line 3292 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 3297 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12322521755879588864UL, 16581348458159120128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	_checkActor(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 3314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, ChangeFeedOperationsWorkload* const& self ) {
															#line 574 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 3346 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 592 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 3353 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via stopFeed()
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class StopFeedActor>
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class StopFeedActorState {
															#line 3359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	StopFeedActorState(Database const& cx,Reference<FeedTestData> const& feedData) 
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(feedData),
															#line 596 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   tr(cx)
															#line 3370 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("stopFeed", reinterpret_cast<unsigned long>(this));

	}
	~StopFeedActorState() 
	{
		fdb_probe_actor_destroy("stopFeed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 597 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 3385 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 598 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Stopping\n", feedData->key.printable());
															#line 3389 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 600 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			;
															#line 3393 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopFeedActorState();
		static_cast<StopFeedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 602 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateChangeFeed(&tr, feedData->feedID, ChangeFeedStatus::CHANGE_FEED_STOP, feedData->keyRange);
															#line 602 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<StopFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3426 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StopFeedActor*>(this)->actor_wait_state = 1;
															#line 602 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopFeedActor, 0, Void >*>(static_cast<StopFeedActor*>(this)));
															#line 3431 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<StopFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3455 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<StopFeedActor*>(this)->actor_wait_state = 3;
															#line 614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StopFeedActor, 2, Void >*>(static_cast<StopFeedActor*>(this)));
															#line 3460 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<StopFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3477 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StopFeedActor*>(this)->actor_wait_state = 2;
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StopFeedActor, 1, Void >*>(static_cast<StopFeedActor*>(this)));
															#line 3482 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<StopFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3493 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StopFeedActor*>(this)->actor_wait_state = 2;
															#line 603 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StopFeedActor, 1, Void >*>(static_cast<StopFeedActor*>(this)));
															#line 3498 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopFeedActor*>(this)->actor_wait_state > 0) static_cast<StopFeedActor*>(this)->actor_wait_state = 0;
		static_cast<StopFeedActor*>(this)->ActorCallback< StopFeedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopFeedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 605 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version stopVersion = tr.getCommittedVersion();
															#line 606 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!feedData->stopVersion.present())
															#line 3584 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 607 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			feedData->stopVersion = stopVersion;
															#line 3588 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 609 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 3592 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 610 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Stopped @ {1}\n", feedData->key.printable(), stopVersion);
															#line 3596 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 612 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<StopFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StopFeedActorState(); static_cast<StopFeedActor*>(this)->destroy(); return 0; }
															#line 3600 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<StopFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StopFeedActorState();
		static_cast<StopFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 605 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version stopVersion = tr.getCommittedVersion();
															#line 606 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!feedData->stopVersion.present())
															#line 3614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 607 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			feedData->stopVersion = stopVersion;
															#line 3618 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 609 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 3622 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 610 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Stopped @ {1}\n", feedData->key.printable(), stopVersion);
															#line 3626 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 612 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<StopFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StopFeedActorState(); static_cast<StopFeedActor*>(this)->destroy(); return 0; }
															#line 3630 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<StopFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StopFeedActorState();
		static_cast<StopFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StopFeedActor*>(this)->actor_wait_state > 0) static_cast<StopFeedActor*>(this)->actor_wait_state = 0;
		static_cast<StopFeedActor*>(this)->ActorCallback< StopFeedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StopFeedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StopFeedActor*>(this)->actor_wait_state > 0) static_cast<StopFeedActor*>(this)->actor_wait_state = 0;
		static_cast<StopFeedActor*>(this)->ActorCallback< StopFeedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StopFeedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StopFeedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 596 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Transaction tr;
															#line 3806 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via stopFeed()
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class StopFeedActor final : public Actor<Void>, public ActorCallback< StopFeedActor, 0, Void >, public ActorCallback< StopFeedActor, 1, Void >, public ActorCallback< StopFeedActor, 2, Void >, public FastAllocated<StopFeedActor>, public StopFeedActorState<StopFeedActor> {
															#line 3811 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<StopFeedActor>::operator new;
	using FastAllocated<StopFeedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13872599858732419584UL, 11988476974070887168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StopFeedActor, 0, Void >;
friend struct ActorCallback< StopFeedActor, 1, Void >;
friend struct ActorCallback< StopFeedActor, 2, Void >;
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	StopFeedActor(Database const& cx,Reference<FeedTestData> const& feedData) 
															#line 3830 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   StopFeedActorState<StopFeedActor>(cx, feedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stopFeed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17664967278629581056UL, 3507366745825584640UL);
		ActorExecutionContextHelper __helper(static_cast<StopFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopFeed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopFeed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopFeedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StopFeedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StopFeedActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> stopFeed( Database const& cx, Reference<FeedTestData> const& feedData ) {
															#line 595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new StopFeedActor(cx, feedData));
															#line 3864 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 618 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

	void popFeed(Database cx, Reference<FeedTestData> feedData) {
		if (!feedData->writesByVersion.empty()) {
			feedData->pop(cx, feedData->writesByVersion.front().first + 1);
		}
	}

																#line 3875 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via destroyFeed()
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class DestroyFeedActor>
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DestroyFeedActorState {
															#line 3881 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DestroyFeedActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self,int const& feedIdx) 
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self),
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedIdx(feedIdx),
															#line 626 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(self->data[feedIdx]),
															#line 627 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   tr(cx)
															#line 3896 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("destroyFeed", reinterpret_cast<unsigned long>(this));

	}
	~DestroyFeedActorState() 
	{
		fdb_probe_actor_destroy("destroyFeed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 628 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			feedData->destroying = true;
															#line 629 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 3913 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 630 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Destroying\n", feedData->key.printable());
															#line 3917 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 632 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			;
															#line 3921 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DestroyFeedActorState();
		static_cast<DestroyFeedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 634 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateChangeFeed(&tr, feedData->feedID, ChangeFeedStatus::CHANGE_FEED_DESTROY, feedData->keyRange);
															#line 634 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DestroyFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3954 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DestroyFeedActor*>(this)->actor_wait_state = 1;
															#line 634 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyFeedActor, 0, Void >*>(static_cast<DestroyFeedActor*>(this)));
															#line 3959 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DestroyFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DestroyFeedActor*>(this)->actor_wait_state = 3;
															#line 650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DestroyFeedActor, 2, Void >*>(static_cast<DestroyFeedActor*>(this)));
															#line 3988 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (self->clearKeyWhenDestroy)
															#line 4003 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 637 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			tr.clear(feedData->key);
															#line 4007 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<DestroyFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4013 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DestroyFeedActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DestroyFeedActor, 1, Void >*>(static_cast<DestroyFeedActor*>(this)));
															#line 4018 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (self->clearKeyWhenDestroy)
															#line 4027 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 637 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			tr.clear(feedData->key);
															#line 4031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<DestroyFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4037 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DestroyFeedActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DestroyFeedActor, 1, Void >*>(static_cast<DestroyFeedActor*>(this)));
															#line 4042 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyFeedActor*>(this)->actor_wait_state > 0) static_cast<DestroyFeedActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyFeedActor*>(this)->ActorCallback< DestroyFeedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyFeedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->destroyed = true;
															#line 643 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		ASSERT(self->data[feedIdx]->key == feedData->key);
															#line 644 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		swapAndPop(&self->data, feedIdx);
															#line 645 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 4132 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 646 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Destroyed @ {1}\n", feedData->key.printable(), tr.getCommittedVersion());
															#line 4136 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 648 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DestroyFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyFeedActorState(); static_cast<DestroyFeedActor*>(this)->destroy(); return 0; }
															#line 4140 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DestroyFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyFeedActorState();
		static_cast<DestroyFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->destroyed = true;
															#line 643 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		ASSERT(self->data[feedIdx]->key == feedData->key);
															#line 644 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		swapAndPop(&self->data, feedIdx);
															#line 645 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 4158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 646 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Destroyed @ {1}\n", feedData->key.printable(), tr.getCommittedVersion());
															#line 4162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 648 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DestroyFeedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyFeedActorState(); static_cast<DestroyFeedActor*>(this)->destroy(); return 0; }
															#line 4166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DestroyFeedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyFeedActorState();
		static_cast<DestroyFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DestroyFeedActor*>(this)->actor_wait_state > 0) static_cast<DestroyFeedActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyFeedActor*>(this)->ActorCallback< DestroyFeedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DestroyFeedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DestroyFeedActor*>(this)->actor_wait_state > 0) static_cast<DestroyFeedActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyFeedActor*>(this)->ActorCallback< DestroyFeedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DestroyFeedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DestroyFeedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	int feedIdx;
															#line 626 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 627 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Transaction tr;
															#line 4346 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via destroyFeed()
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DestroyFeedActor final : public Actor<Void>, public ActorCallback< DestroyFeedActor, 0, Void >, public ActorCallback< DestroyFeedActor, 1, Void >, public ActorCallback< DestroyFeedActor, 2, Void >, public FastAllocated<DestroyFeedActor>, public DestroyFeedActorState<DestroyFeedActor> {
															#line 4351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<DestroyFeedActor>::operator new;
	using FastAllocated<DestroyFeedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9079219124535542272UL, 16827844191539129856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyFeedActor, 0, Void >;
friend struct ActorCallback< DestroyFeedActor, 1, Void >;
friend struct ActorCallback< DestroyFeedActor, 2, Void >;
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DestroyFeedActor(Database const& cx,ChangeFeedOperationsWorkload* const& self,int const& feedIdx) 
															#line 4370 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   DestroyFeedActorState<DestroyFeedActor>(cx, self, feedIdx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("destroyFeed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12295673156676899840UL, 360569765555789568UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroyFeed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroyFeed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DestroyFeedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DestroyFeedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DestroyFeedActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> destroyFeed( Database const& cx, ChangeFeedOperationsWorkload* const& self, int const& feedIdx ) {
															#line 625 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new DestroyFeedActor(cx, self, feedIdx));
															#line 4404 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 654 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

																#line 4409 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via doRead()
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class DoReadActor>
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoReadActorState {
															#line 4415 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoReadActorState(Database const& cx,Reference<FeedTestData> const& feedData,int const& targetReadWidth) 
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(feedData),
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   targetReadWidth(targetReadWidth)
															#line 4426 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("doRead", reinterpret_cast<unsigned long>(this));

	}
	~DoReadActorState() 
	{
		fdb_probe_actor_destroy("doRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 656 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (feedData->writesByVersion.empty())
															#line 4441 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 657 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (!static_cast<DoReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoReadActorState(); static_cast<DoReadActor*>(this)->destroy(); return 0; }
															#line 4445 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				new (&static_cast<DoReadActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoReadActorState();
				static_cast<DoReadActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 659 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			Version beginVersion;
															#line 660 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			Version endVersion;
															#line 661 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (targetReadWidth >= feedData->writesByVersion.size())
															#line 4457 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 662 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				beginVersion = feedData->writesByVersion.front().first;
															#line 663 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				endVersion = feedData->writesByVersion.back().first + 1;
															#line 4463 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 666 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				int randStart = deterministicRandom()->randomInt(0, feedData->writesByVersion.size() - targetReadWidth);
															#line 667 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				beginVersion = feedData->writesByVersion[randStart].first;
															#line 668 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				int end = randStart + targetReadWidth;
															#line 669 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (end == feedData->writesByVersion.size())
															#line 4475 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 670 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					endVersion = feedData->writesByVersion.back().first + 1;
															#line 4479 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
				else
				{
															#line 673 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					endVersion = feedData->writesByVersion[end].first + 1;
															#line 4485 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
															#line 677 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (DEBUG_CF(feedData->key))
															#line 4490 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 678 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				fmt::print("DBG) {0} Reading @ {1} - {2}\n", feedData->key.printable(), beginVersion, endVersion);
															#line 4494 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 682 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = historicReader(cx, feedData, beginVersion, endVersion, true);
															#line 682 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DoReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4500 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadActor*>(this)->actor_wait_state = 1;
															#line 682 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadActor, 0, Void >*>(static_cast<DoReadActor*>(this)));
															#line 4505 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 684 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 4528 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 685 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Read complete\n", feedData->key.printable());
															#line 4532 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoReadActorState(); static_cast<DoReadActor*>(this)->destroy(); return 0; }
															#line 4536 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 684 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key))
															#line 4548 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 685 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Read complete\n", feedData->key.printable());
															#line 4552 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoReadActorState(); static_cast<DoReadActor*>(this)->destroy(); return 0; }
															#line 4556 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadActor*>(this)->actor_wait_state > 0) static_cast<DoReadActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadActor*>(this)->ActorCallback< DoReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	int targetReadWidth;
															#line 4645 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via doRead()
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoReadActor final : public Actor<Void>, public ActorCallback< DoReadActor, 0, Void >, public FastAllocated<DoReadActor>, public DoReadActorState<DoReadActor> {
															#line 4650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<DoReadActor>::operator new;
	using FastAllocated<DoReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10507111505742371584UL, 9948912074434420992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadActor, 0, Void >;
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoReadActor(Database const& cx,Reference<FeedTestData> const& feedData,int const& targetReadWidth) 
															#line 4667 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   DoReadActorState<DoReadActor>(cx, feedData, targetReadWidth),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12313637287084170496UL, 16087923704333355776UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> doRead( Database const& cx, Reference<FeedTestData> const& feedData, int const& targetReadWidth ) {
															#line 655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new DoReadActor(cx, feedData, targetReadWidth));
															#line 4699 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 690 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

																#line 4704 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via doUpdateClear()
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class DoUpdateClearActor>
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoUpdateClearActorState {
															#line 4710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoUpdateClearActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self,Reference<FeedTestData> const& feedData) 
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self),
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   feedData(feedData),
															#line 694 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   tr(cx),
															#line 695 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   updateValue()
															#line 4725 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("doUpdateClear", reinterpret_cast<unsigned long>(this));

	}
	~DoUpdateClearActorState() 
	{
		fdb_probe_actor_destroy("doUpdateClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 701 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (feedData->stopVersion.present())
															#line 4740 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 702 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (!static_cast<DoUpdateClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoUpdateClearActorState(); static_cast<DoUpdateClearActor*>(this)->destroy(); return 0; }
															#line 4744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				new (&static_cast<DoUpdateClearActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoUpdateClearActorState();
				static_cast<DoUpdateClearActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 706 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (feedData->lastCleared || deterministicRandom()->random01() > self->clearFrequency)
															#line 4752 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 707 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				updateValue = feedData->nextValue();
															#line 708 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (DEBUG_CF(feedData->key))
															#line 4758 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 709 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					fmt::print("DBG) {0} Setting {1}\n", feedData->key.printable(), updateValue.get().printable());
															#line 4762 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
			else
			{
															#line 711 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (DEBUG_CF(feedData->key))
															#line 4769 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 712 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					fmt::print("DBG) {0} Clearing\n", feedData->key.printable());
															#line 4773 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				}
			}
															#line 714 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			;
															#line 4778 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoUpdateClearActorState();
		static_cast<DoUpdateClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 716 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (updateValue.present())
															#line 4809 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				tr.set(feedData->key, updateValue.get());
															#line 4813 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
			else
			{
															#line 719 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				tr.clear(feedData->key);
															#line 4819 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			}
															#line 722 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 722 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DoUpdateClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4825 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoUpdateClearActor*>(this)->actor_wait_state = 1;
															#line 722 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoUpdateClearActor, 0, Void >*>(static_cast<DoUpdateClearActor*>(this)));
															#line 4830 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 739 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 739 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (static_cast<DoUpdateClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4854 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoUpdateClearActor*>(this)->actor_wait_state = 2;
															#line 739 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoUpdateClearActor, 1, Void >*>(static_cast<DoUpdateClearActor*>(this)));
															#line 4859 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 724 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version writtenVersion = tr.getCommittedVersion();
															#line 726 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key) && updateValue.present())
															#line 4876 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Set {1} @ {2}\n", feedData->key.printable(), updateValue.get().printable(), writtenVersion);
															#line 4880 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 732 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key) && !updateValue.present())
															#line 4884 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 733 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Cleared @ {1}\n", feedData->key.printable(), writtenVersion);
															#line 4888 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 736 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->update(writtenVersion, updateValue);
															#line 737 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoUpdateClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoUpdateClearActorState(); static_cast<DoUpdateClearActor*>(this)->destroy(); return 0; }
															#line 4894 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoUpdateClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoUpdateClearActorState();
		static_cast<DoUpdateClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 724 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Version writtenVersion = tr.getCommittedVersion();
															#line 726 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key) && updateValue.present())
															#line 4908 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Set {1} @ {2}\n", feedData->key.printable(), updateValue.get().printable(), writtenVersion);
															#line 4912 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 732 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (DEBUG_CF(feedData->key) && !updateValue.present())
															#line 4916 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 733 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			fmt::print("DBG) {0} Cleared @ {1}\n", feedData->key.printable(), writtenVersion);
															#line 4920 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		}
															#line 736 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		feedData->update(writtenVersion, updateValue);
															#line 737 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (!static_cast<DoUpdateClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoUpdateClearActorState(); static_cast<DoUpdateClearActor*>(this)->destroy(); return 0; }
															#line 4926 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		new (&static_cast<DoUpdateClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoUpdateClearActorState();
		static_cast<DoUpdateClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoUpdateClearActor*>(this)->actor_wait_state > 0) static_cast<DoUpdateClearActor*>(this)->actor_wait_state = 0;
		static_cast<DoUpdateClearActor*>(this)->ActorCallback< DoUpdateClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoUpdateClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoUpdateClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoUpdateClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoUpdateClearActor*>(this)->actor_wait_state > 0) static_cast<DoUpdateClearActor*>(this)->actor_wait_state = 0;
		static_cast<DoUpdateClearActor*>(this)->ActorCallback< DoUpdateClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoUpdateClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoUpdateClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoUpdateClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Reference<FeedTestData> feedData;
															#line 694 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Transaction tr;
															#line 695 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Optional<Value> updateValue;
															#line 5106 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via doUpdateClear()
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class DoUpdateClearActor final : public Actor<Void>, public ActorCallback< DoUpdateClearActor, 0, Void >, public ActorCallback< DoUpdateClearActor, 1, Void >, public FastAllocated<DoUpdateClearActor>, public DoUpdateClearActorState<DoUpdateClearActor> {
															#line 5111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<DoUpdateClearActor>::operator new;
	using FastAllocated<DoUpdateClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3342497565698995712UL, 7821548253176075264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoUpdateClearActor, 0, Void >;
friend struct ActorCallback< DoUpdateClearActor, 1, Void >;
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	DoUpdateClearActor(Database const& cx,ChangeFeedOperationsWorkload* const& self,Reference<FeedTestData> const& feedData) 
															#line 5129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   DoUpdateClearActorState<DoUpdateClearActor>(cx, self, feedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doUpdateClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8920444281620194560UL, 7405241109462679296UL);
		ActorExecutionContextHelper __helper(static_cast<DoUpdateClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doUpdateClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doUpdateClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoUpdateClearActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoUpdateClearActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> doUpdateClear( Database const& cx, ChangeFeedOperationsWorkload* const& self, Reference<FeedTestData> const& feedData ) {
															#line 691 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new DoUpdateClearActor(cx, self, feedData));
															#line 5162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 743 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"

																#line 5167 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
// This generated class is to be used only via changeFeedOperationsClient()
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
template <class ChangeFeedOperationsClientActor>
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class ChangeFeedOperationsClientActorState {
															#line 5173 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsClientActorState(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		 : cx(cx),
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   self(self),
															#line 745 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		   last(now())
															#line 5184 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
	{
		fdb_probe_actor_create("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this));

	}
	~ChangeFeedOperationsClientActorState() 
	{
		fdb_probe_actor_destroy("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 746 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			;
															#line 5199 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeFeedOperationsClientActorState();
		static_cast<ChangeFeedOperationsClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 747 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		waitNextOp = poisson(&last, 1.0 / self->operationsPerSecond);
															#line 748 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		Op op = self->pickRandomOp();
															#line 749 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		int feedIdx = deterministicRandom()->randomInt(0, self->data.size());
															#line 750 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (op == Op::CREATE_DELETE)
															#line 5235 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		{
															#line 752 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (deterministicRandom()->random01() < 0.5 || self->data.size() == 1)
															#line 5239 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 753 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->createNewFeed(cx, self);
															#line 753 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5245 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 1;
															#line 753 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 0, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 755 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->destroyFeed(cx, self, feedIdx);
															#line 755 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5259 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 2;
															#line 755 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 1, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5264 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 757 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
			if (op == Op::READ)
															#line 5272 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
			{
															#line 759 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->doRead(cx, self->data[feedIdx], deterministicRandom()->randomExp(2, 8));
															#line 759 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5278 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 3;
															#line 759 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 2, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5283 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 760 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
				if (op == Op::UPDATE_CLEAR)
															#line 5290 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
				{
															#line 761 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					StrictFuture<Void> __when_expr_3 = self->doUpdateClear(cx, self, self->data[feedIdx]);
															#line 761 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5296 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
					static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 4;
															#line 761 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 3, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5301 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 762 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
					if (op == Op::STOP)
															#line 5308 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
					{
															#line 763 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						StrictFuture<Void> __when_expr_4 = self->stopFeed(cx, self->data[feedIdx]);
															#line 763 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
						static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 5;
															#line 763 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 4, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5319 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 764 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
						if (op == Op::POP)
															#line 5326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						{
															#line 765 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
							self->popFeed(cx, self->data[feedIdx]);
															#line 5330 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						}
						else
						{
															#line 767 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
							ASSERT(false);
															#line 5336 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
						}
						loopDepth = a_body1loopBody1cont9(loopDepth);
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 770 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitNextOp;
															#line 770 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5352 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 6;
															#line 770 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedOperationsClientActor, 5, Void >*>(static_cast<ChangeFeedOperationsClientActor*>(this)));
															#line 5357 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedOperationsClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedOperationsClientActor*>(this)->ActorCallback< ChangeFeedOperationsClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeFeedOperationsClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeFeedOperationsClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Database cx;
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsWorkload* self;
															#line 745 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	double last;
															#line 747 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	Future<Void> waitNextOp;
															#line 5916 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
};
// This generated class is to be used only via changeFeedOperationsClient()
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
class ChangeFeedOperationsClientActor final : public Actor<Void>, public ActorCallback< ChangeFeedOperationsClientActor, 0, Void >, public ActorCallback< ChangeFeedOperationsClientActor, 1, Void >, public ActorCallback< ChangeFeedOperationsClientActor, 2, Void >, public ActorCallback< ChangeFeedOperationsClientActor, 3, Void >, public ActorCallback< ChangeFeedOperationsClientActor, 4, Void >, public ActorCallback< ChangeFeedOperationsClientActor, 5, Void >, public FastAllocated<ChangeFeedOperationsClientActor>, public ChangeFeedOperationsClientActorState<ChangeFeedOperationsClientActor> {
															#line 5921 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
public:
	using FastAllocated<ChangeFeedOperationsClientActor>::operator new;
	using FastAllocated<ChangeFeedOperationsClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17804999707671060480UL, 16093645099318679040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeFeedOperationsClientActor, 0, Void >;
friend struct ActorCallback< ChangeFeedOperationsClientActor, 1, Void >;
friend struct ActorCallback< ChangeFeedOperationsClientActor, 2, Void >;
friend struct ActorCallback< ChangeFeedOperationsClientActor, 3, Void >;
friend struct ActorCallback< ChangeFeedOperationsClientActor, 4, Void >;
friend struct ActorCallback< ChangeFeedOperationsClientActor, 5, Void >;
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	ChangeFeedOperationsClientActor(Database const& cx,ChangeFeedOperationsWorkload* const& self) 
															#line 5943 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeFeedOperationsClientActorState<ChangeFeedOperationsClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18111102481301571072UL, 14592491655556667136UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedOperationsClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeFeedOperationsClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeFeedOperationsClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeFeedOperationsClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
[[nodiscard]] Future<Void> changeFeedOperationsClient( Database const& cx, ChangeFeedOperationsWorkload* const& self ) {
															#line 744 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
	return Future<Void>(new ChangeFeedOperationsClientActor(cx, self));
															#line 5980 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ChangeFeedOperations.actor.g.cpp"
}

#line 773 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/ChangeFeedOperations.actor.cpp"
};

WorkloadFactory<ChangeFeedOperationsWorkload> ChangeFeedOperationsWorkloadFactory;
