#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
/*
 * AtomicRestore.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RestoreCommon.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which test the correctness of backup and restore process
struct AtomicRestoreWorkload : TestWorkload {
	static constexpr auto NAME = "AtomicRestore";
	double startAfter, restoreAfter;
	bool fastRestore; // true: use fast restore, false: use old style restore
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	UsePartitionedLog usePartitionedLogs{ false };
	Key addPrefix, removePrefix; // Original key will be first applied removePrefix and then applied addPrefix
	// CAVEAT: When removePrefix is used, we must ensure every key in backup have the removePrefix

	AtomicRestoreWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {

		startAfter = getOption(options, "startAfter"_sr, 10.0);
		restoreAfter = getOption(options, "restoreAfter"_sr, 20.0);
		fastRestore = getOption(options, "fastRestore"_sr, false);
		if (!fastRestore) {
			addDefaultBackupRanges(backupRanges);
		} else {
			// Fast restore doesn't support multiple ranges yet
			backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
		}
		usePartitionedLogs.set(
		    getOption(options, "usePartitionedLogs"_sr, deterministicRandom()->random01() < 0.5 ? true : false));

		addPrefix = getOption(options, "addPrefix"_sr, ""_sr);
		removePrefix = getOption(options, "removePrefix"_sr, ""_sr);

		// Correctness is not clean for addPrefix feature yet. Uncomment below to enable the test
		// Generate addPrefix
		// if (addPrefix.size() == 0 && removePrefix.size() == 0) {
		// 	if (deterministicRandom()->random01() < 0.5) { // Generate random addPrefix
		// 		int len = deterministicRandom()->randomInt(1, 100);
		// 		std::string randomStr = deterministicRandom()->randomAlphaNumeric(len);
		// 		TraceEvent("AtomicRestoreWorkload")
		// 		    .detail("GenerateAddPrefix", randomStr)
		// 		    .detail("Length", len)
		// 		    .detail("StrLen", randomStr.size());
		// 		addPrefix = Key(randomStr);
		// 	}
		// }
		TraceEvent("AtomicRestoreWorkload").detail("AddPrefix", addPrefix).detail("RemovePrefix", removePrefix);
		ASSERT(addPrefix.size() == 0 && removePrefix.size() == 0);
		// Do not support removePrefix right now because we must ensure all backup keys have the removePrefix
		// otherwise, test will fail because fast restore will simply add the removePrefix to every key in the end.
		ASSERT(removePrefix.size() == 0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	bool hasPrefix() const { return addPrefix != ""_sr || removePrefix != ""_sr; }

																#line 95 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
template <class _startActor>
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
class _startActorState {
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
public:
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	_startActorState(Database const& cx,AtomicRestoreWorkload* const& self) 
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		 : cx(cx),
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		   self(self),
															#line 94 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		   backupAgent()
															#line 112 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startAfter * deterministicRandom()->random01());
															#line 96 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 134 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_Start").detail("UsePartitionedLog", self->usePartitionedLogs);
															#line 99 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		try {
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_1 = backupAgent.submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), BackupAgentBase::getDefaultTagName(), self->backupRanges, true, StopWhenDone::False, self->usePartitionedLogs, IncrementalBackupOnly::False, {});
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_Start").detail("UsePartitionedLog", self->usePartitionedLogs);
															#line 99 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 187 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		try {
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_1 = backupAgent.submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), BackupAgentBase::getDefaultTagName(), self->backupRanges, true, StopWhenDone::False, self->usePartitionedLogs, IncrementalBackupOnly::False, {});
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 193 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 118 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_Wait").log();
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(backupAgent.waitBackup(cx, BackupAgentBase::getDefaultTagName(), StopWhenDone::False));
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 292 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 297 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 307 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			{
															#line 115 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 311 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_BackupStart").log();
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(self->restoreAfter * deterministicRandom()->random01());
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 431 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 436 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_BackupStart").log();
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(self->restoreAfter * deterministicRandom()->random01());
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 449 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_RestoreStart").log();
															#line 124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (self->fastRestore)
															#line 540 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		{
															#line 125 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			TraceEvent(SevInfo, "AtomicParallelRestore").log();
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_4 = backupAgent.atomicParallelRestore( cx, BackupAgentBase::getDefaultTag(), self->backupRanges, self->addPrefix, self->removePrefix);
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 548 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 553 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			;
															#line 560 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_RestoreStart").log();
															#line 124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (self->fastRestore)
															#line 572 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		{
															#line 125 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			TraceEvent(SevInfo, "AtomicParallelRestore").log();
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_4 = backupAgent.atomicParallelRestore( cx, BackupAgentBase::getDefaultTag(), self->backupRanges, self->addPrefix, self->removePrefix);
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 580 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 126 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 585 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			;
															#line 592 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (g_simulator->backupAgents == ISimulator::BackupAgentType::BackupToFile)
															#line 677 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		{
															#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			g_simulator->backupAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 681 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		}
															#line 147 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		TraceEvent("AtomicRestore_Done").log();
															#line 148 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 687 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
		try {
															#line 131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			StrictFuture<Void> __when_expr_5 = success(backupAgent.atomicRestore( cx, BackupAgentBase::getDefaultTag(), self->backupRanges, StringRef(), StringRef()));
															#line 131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 802 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 807 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 837 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 842 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 852 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			{
															#line 136 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 856 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
			}
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	Database cx;
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	AtomicRestoreWorkload* self;
															#line 94 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	FileBackupAgent backupAgent;
															#line 99 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	std::string backupContainer;
															#line 1050 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1055 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9695796621705592064UL, 9616630110144445184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	_startActor(Database const& cx,AtomicRestoreWorkload* const& self) 
															#line 1078 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, AtomicRestoreWorkload* const& self ) {
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1116 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicRestore.actor.g.cpp"
}

#line 150 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicRestore.actor.cpp"
};

WorkloadFactory<AtomicRestoreWorkload> AtomicRestoreWorkloadFactory;
