#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
/*
 *RocksDBCheckpointUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/RocksDBCheckpointUtils.actor.h"

#ifdef WITH_ROCKSDB
#include <rocksdb/db.h>
#include <rocksdb/env.h>
#include <rocksdb/options.h>
#include <rocksdb/slice.h>
#include <rocksdb/slice_transform.h>
#include <rocksdb/sst_file_reader.h>
#include <rocksdb/types.h>
#include <rocksdb/version.h>
#endif // WITH_ROCKSDB

#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/MutationTracking.h"
#include "fdbclient/StorageCheckpoint.h"
#include "fdbserver/CoroFlow.h"
#include "fdbserver/FDBRocksDBVersion.h"
#include "fdbserver/Knobs.h"
#include "flow/IThreadPool.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"

#include "flow/actorcompiler.h" // has to be last include

#ifdef WITH_ROCKSDB

// Enforcing rocksdb version.
static_assert((ROCKSDB_MAJOR == FDB_ROCKSDB_MAJOR && ROCKSDB_MINOR == FDB_ROCKSDB_MINOR &&
               ROCKSDB_PATCH == FDB_ROCKSDB_PATCH),
              "Unsupported rocksdb version.");

namespace {

using DB = rocksdb::DB*;
using CF = rocksdb::ColumnFamilyHandle*;

const KeyRef persistVersion = "\xff\xffVersion"_sr;
const KeyRef readerInitialized = "\xff\xff/ReaderInitialized"_sr;
const std::string checkpointCf = "RocksDBCheckpoint";
const std::string checkpointReaderSubDir = "/reader";
const std::string rocksDefaultCf = "default";

rocksdb::ExportImportFilesMetaData getMetaData(const CheckpointMetaData& checkpoint) {
	rocksdb::ExportImportFilesMetaData metaData;
	if (checkpoint.getFormat() != DataMoveRocksCF) {
		return metaData;
	}

	RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
	metaData.db_comparator_name = rocksCF.dbComparatorName;

	for (const LiveFileMetaData& fileMetaData : rocksCF.sstFiles) {
		rocksdb::LiveFileMetaData liveFileMetaData;
		liveFileMetaData.relative_filename = fileMetaData.relative_filename;
		liveFileMetaData.directory = fileMetaData.directory;
		liveFileMetaData.file_number = fileMetaData.file_number;
		liveFileMetaData.file_type = static_cast<rocksdb::FileType>(fileMetaData.file_type);
		liveFileMetaData.size = fileMetaData.size;
		liveFileMetaData.temperature = static_cast<rocksdb::Temperature>(fileMetaData.temperature);
		liveFileMetaData.file_checksum = fileMetaData.file_checksum;
		liveFileMetaData.file_checksum_func_name = fileMetaData.file_checksum_func_name;
		liveFileMetaData.smallest_seqno = fileMetaData.smallest_seqno;
		liveFileMetaData.largest_seqno = fileMetaData.largest_seqno;
		liveFileMetaData.smallestkey = fileMetaData.smallestkey;
		liveFileMetaData.largestkey = fileMetaData.largestkey;
		liveFileMetaData.num_reads_sampled = fileMetaData.num_reads_sampled;
		liveFileMetaData.being_compacted = fileMetaData.being_compacted;
		liveFileMetaData.num_entries = fileMetaData.num_entries;
		liveFileMetaData.num_deletions = fileMetaData.num_deletions;
		liveFileMetaData.oldest_blob_file_number = fileMetaData.oldest_blob_file_number;
		liveFileMetaData.oldest_ancester_time = fileMetaData.oldest_ancester_time;
		liveFileMetaData.file_creation_time = fileMetaData.file_creation_time;
		liveFileMetaData.epoch_number = fileMetaData.epoch_number;
		liveFileMetaData.name = fileMetaData.name;
		liveFileMetaData.db_path = fileMetaData.db_path;
		liveFileMetaData.column_family_name = fileMetaData.column_family_name;
		liveFileMetaData.level = fileMetaData.level;
		liveFileMetaData.smallest = fileMetaData.smallest;
		liveFileMetaData.largest = fileMetaData.largest;
		liveFileMetaData.file_type = rocksdb::kTableFile;
		metaData.files.push_back(liveFileMetaData);
	}

	return metaData;
}

rocksdb::Slice toSlice(StringRef s) {
	return rocksdb::Slice(reinterpret_cast<const char*>(s.begin()), s.size());
}

StringRef toStringRef(rocksdb::Slice s) {
	return StringRef(reinterpret_cast<const uint8_t*>(s.data()), s.size());
}

rocksdb::ColumnFamilyOptions getCFOptions() {
	rocksdb::ColumnFamilyOptions options;
	return options;
}

rocksdb::Options getOptions() {
	rocksdb::Options options({}, getCFOptions());
	options.create_if_missing = true;
	options.db_log_dir = g_network->isSimulated() ? "" : SERVER_KNOBS->LOG_DIRECTORY;
	return options;
}

// Set some useful defaults desired for all reads.
rocksdb::ReadOptions getReadOptions() {
	rocksdb::ReadOptions options;
	options.background_purge_on_iterator_cleanup = true;
	options.auto_prefix_mode = (SERVER_KNOBS->SHARDED_ROCKSDB_PREFIX_LEN > 0);
	return options;
}

void logRocksDBError(const rocksdb::Status& status, const std::string& method, const UID& logId) {
	auto level = status.IsTimedOut() ? SevWarn : SevError;
	TraceEvent e(level, "RocksDBCheckpointReaderError", logId);
	e.detail("Error", status.ToString()).detail("Method", method).detail("RocksDBSeverity", status.severity());
	if (status.IsIOError()) {
		e.detail("SubCode", status.subcode());
	}
}

Error statusToError(const rocksdb::Status& s) {
	if (s.IsIOError()) {
		return io_error();
	} else if (s.IsTimedOut()) {
		return transaction_too_old();
	} else {
		return unknown_error();
	}
}

// Fetch a single sst file from storage server. The progress is checkpointed via cFun.
															#line 160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via doFetchCheckpointFile()
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class DoFetchCheckpointFileActor>
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoFetchCheckpointFileActorState {
															#line 166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoFetchCheckpointFileActorState(Database const& cx,std::string const& remoteFile,std::string const& localFile,UID const& ssId,UID const& checkpointId,int const& maxRetries = 3) 
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   remoteFile(remoteFile),
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   localFile(localFile),
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   ssId(ssId),
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   checkpointId(checkpointId),
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   maxRetries(maxRetries),
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   tr(cx),
															#line 165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   ssi()
															#line 187 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this));

	}
	~DoFetchCheckpointFileActorState() 
	{
		fdb_probe_actor_destroy("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			;
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoFetchCheckpointFileActorState();
		static_cast<DoFetchCheckpointFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		attempt = 0;
															#line 181 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		offset = 0;
															#line 182 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		asyncFile = Reference<IAsyncFile>();
															#line 183 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 168 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(serverListKeyFor(ssId));
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 252 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 257 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 294 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 2;
															#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 1, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ss,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!ss.present())
															#line 314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1loopBody1Catch1(checkpoint_not_found(), loopDepth);
															#line 318 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 173 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		ssi = decodeServerListValue(ss.get());
															#line 322 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ss,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!ss.present())
															#line 331 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1loopBody1Catch1(checkpoint_not_found(), loopDepth);
															#line 335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 173 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		ssi = decodeServerListValue(ss.get());
															#line 339 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ss,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ss, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ss,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ss), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 184 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		offset = 0;
															#line 517 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		try {
															#line 186 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			asyncFile = Reference<IAsyncFile>();
															#line 187 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			++attempt;
															#line 188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevDebug, "FetchCheckpointFileBegin") .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt);
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(localFile, true);
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 529 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 3;
															#line 195 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 2, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 534 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 215 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 556 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 216 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 560 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
			else
			{
															#line 217 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (e.code() != error_code_end_of_stream)
															#line 566 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 218 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					TraceEvent(SevWarnAlways, "FetchCheckpointFileError") .errorUnsuppressed(e) .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt);
															#line 225 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (attempt >= maxRetries)
															#line 572 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					{
															#line 226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 576 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					}
					loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);
				}
				else
				{
															#line 229 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					StrictFuture<Void> __when_expr_7 = asyncFile->sync();
															#line 229 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 586 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
					static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 8;
															#line 229 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 7, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 591 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		const int64_t flags = IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO;
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(asyncFile, IAsyncFileSystem::filesystem()->open(localFile, flags, 0666));
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 612 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 4;
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 3, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 617 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		const int64_t flags = IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO;
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(asyncFile, IAsyncFileSystem::filesystem()->open(localFile, flags, 0666));
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 630 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 4;
															#line 198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 3, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 635 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		stream = ssi.fetchCheckpoint.getReplyStream(FetchCheckpointRequest(checkpointId, remoteFile));
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointFileReceivingData") .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt);
															#line 208 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 723 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		stream = ssi.fetchCheckpoint.getReplyStream(FetchCheckpointRequest(checkpointId, remoteFile));
															#line 202 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointFileReceivingData") .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt);
															#line 208 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 736 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		auto __when_expr_4 = stream.getFuture();
															#line 827 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<FetchCheckpointReply>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<FetchCheckpointReply>>::value, "invalid type");
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 831 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_4.pop(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 5;
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 836 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_5 = asyncFile->write(rep.data.begin(), rep.data.size(), offset);
															#line 210 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 847 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 6;
															#line 210 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 5, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 852 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(FetchCheckpointReply const& __rep,int loopDepth) 
	{
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		rep = __rep;
															#line 861 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(FetchCheckpointReply && __rep,int loopDepth) 
	{
		rep = std::move(__rep);
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >::remove();

	}
	void a_callback_fire(ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >*,FetchCheckpointReply const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >*,FetchCheckpointReply && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_6 = asyncFile->flush();
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 942 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 7;
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 6, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 947 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_6 = asyncFile->flush();
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 958 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 7;
															#line 211 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 6, Void >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 963 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		offset += rep.data.size();
															#line 1047 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		offset += rep.data.size();
															#line 1056 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<int64_t> __when_expr_8 = asyncFile->size();
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1154 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont6when1(__when_expr_8.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 9;
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 1159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<int64_t> __when_expr_8 = asyncFile->size();
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont6when1(__when_expr_8.get(), loopDepth); };
		static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 9;
															#line 230 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*>(static_cast<DoFetchCheckpointFileActor*>(this)));
															#line 1175 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1Catch1cont7(int64_t const& fileSize,int loopDepth) 
	{
															#line 231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointFileEnd") .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt) .detail("FileSize", fileSize);
															#line 238 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DoFetchCheckpointFileActor*>(this)->SAV<int64_t>::futures) { (void)(fileSize); this->~DoFetchCheckpointFileActorState(); static_cast<DoFetchCheckpointFileActor*>(this)->destroy(); return 0; }
															#line 1261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DoFetchCheckpointFileActor*>(this)->SAV< int64_t >::value()) int64_t(fileSize);
		this->~DoFetchCheckpointFileActorState();
		static_cast<DoFetchCheckpointFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont7(int64_t && fileSize,int loopDepth) 
	{
															#line 231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointFileEnd") .detail("RemoteFile", remoteFile) .detail("LocalFile", localFile) .detail("TargetUID", ssId) .detail("CheckpointId", checkpointId) .detail("Attempt", attempt) .detail("FileSize", fileSize);
															#line 238 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DoFetchCheckpointFileActor*>(this)->SAV<int64_t>::futures) { (void)(fileSize); this->~DoFetchCheckpointFileActorState(); static_cast<DoFetchCheckpointFileActor*>(this)->destroy(); return 0; }
															#line 1275 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DoFetchCheckpointFileActor*>(this)->SAV< int64_t >::value()) int64_t(fileSize);
		this->~DoFetchCheckpointFileActorState();
		static_cast<DoFetchCheckpointFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<DoFetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoFetchCheckpointFileActor*>(this)->ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string remoteFile;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string localFile;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	UID ssId;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	UID checkpointId;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int maxRetries;
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Transaction tr;
															#line 165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	StorageServerInterface ssi;
															#line 180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int attempt;
															#line 181 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int64_t offset;
															#line 182 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 200 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	ReplyPromiseStream<FetchCheckpointReply> stream;
															#line 209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointReply rep;
															#line 1384 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via doFetchCheckpointFile()
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoFetchCheckpointFileActor final : public Actor<int64_t>, public ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >, public ActorCallback< DoFetchCheckpointFileActor, 1, Void >, public ActorCallback< DoFetchCheckpointFileActor, 2, Void >, public ActorCallback< DoFetchCheckpointFileActor, 3, Void >, public ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >, public ActorCallback< DoFetchCheckpointFileActor, 5, Void >, public ActorCallback< DoFetchCheckpointFileActor, 6, Void >, public ActorCallback< DoFetchCheckpointFileActor, 7, Void >, public ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >, public FastAllocated<DoFetchCheckpointFileActor>, public DoFetchCheckpointFileActorState<DoFetchCheckpointFileActor> {
															#line 1389 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<DoFetchCheckpointFileActor>::operator new;
	using FastAllocated<DoFetchCheckpointFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3916270073067933440UL, 9721352806405998592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 1, Void >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 2, Void >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 3, Void >;
friend struct ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 5, Void >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 6, Void >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 7, Void >;
friend struct ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >;
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoFetchCheckpointFileActor(Database const& cx,std::string const& remoteFile,std::string const& localFile,UID const& ssId,UID const& checkpointId,int const& maxRetries = 3) 
															#line 1414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<int64_t>(),
		   DoFetchCheckpointFileActorState<DoFetchCheckpointFileActor>(cx, remoteFile, localFile, ssId, checkpointId, maxRetries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8881334019132907264UL, 8701852576964757760UL);
		ActorExecutionContextHelper __helper(static_cast<DoFetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doFetchCheckpointFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doFetchCheckpointFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< DoFetchCheckpointFileActor, 4, FetchCheckpointReply >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoFetchCheckpointFileActor, 8, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<int64_t> doFetchCheckpointFile( Database const& cx, std::string const& remoteFile, std::string const& localFile, UID const& ssId, UID const& checkpointId, int const& maxRetries = 3 ) {
															#line 158 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<int64_t>(new DoFetchCheckpointFileActor(cx, remoteFile, localFile, ssId, checkpointId, maxRetries));
															#line 1454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 243 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

															#line 1459 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via fetchCheckpointBytesSampleFile()
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchCheckpointBytesSampleFileActor>
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointBytesSampleFileActorState {
															#line 1465 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointBytesSampleFileActorState(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   metaData(metaData),
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun),
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   maxRetries(maxRetries)
															#line 1480 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointBytesSampleFileActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 249 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT(metaData->bytesSampleFile.present());
															#line 250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			localFile = joinPath(dir, metaData->checkpointID.toString() + "_metadata_bytes.sst");
															#line 251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevDebug, "FetchCheckpointByteSampleBegin") .detail("Checkpoint", metaData->toString()) .detail("LocalFile", localFile);
															#line 255 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT(!metaData->src.empty());
															#line 256 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ssId = metaData->src.front();
															#line 258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(doFetchCheckpointFile(cx, metaData->bytesSampleFile.get(), localFile, ssId, metaData->checkpointID));
															#line 258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1507 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state = 1;
															#line 258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >*>(static_cast<FetchCheckpointBytesSampleFileActor*>(this)));
															#line 1512 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointBytesSampleFileActorState();
		static_cast<FetchCheckpointBytesSampleFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		metaData->bytesSampleFile = localFile;
															#line 260 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 1537 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1543 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state = 2;
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*>(static_cast<FetchCheckpointBytesSampleFileActor*>(this)));
															#line 1548 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		metaData->bytesSampleFile = localFile;
															#line 260 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 1564 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1570 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state = 2;
															#line 261 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*>(static_cast<FetchCheckpointBytesSampleFileActor*>(this)));
															#line 1575 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointBytesSampleFileActor*>(this)->ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 263 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchCheckpointBytesSampleFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointBytesSampleFileActorState(); static_cast<FetchCheckpointBytesSampleFileActor*>(this)->destroy(); return 0; }
															#line 1664 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchCheckpointBytesSampleFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointBytesSampleFileActorState();
		static_cast<FetchCheckpointBytesSampleFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointBytesSampleFileActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointBytesSampleFileActor*>(this)->ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<CheckpointMetaData> metaData;
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int maxRetries;
															#line 250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string localFile;
															#line 256 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	UID ssId;
															#line 1773 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpointBytesSampleFile()
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointBytesSampleFileActor final : public Actor<Void>, public ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >, public ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >, public FastAllocated<FetchCheckpointBytesSampleFileActor>, public FetchCheckpointBytesSampleFileActorState<FetchCheckpointBytesSampleFileActor> {
															#line 1778 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointBytesSampleFileActor>::operator new;
	using FastAllocated<FetchCheckpointBytesSampleFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9419595066095655168UL, 4400548372420571648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >;
friend struct ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >;
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointBytesSampleFileActor(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 1796 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FetchCheckpointBytesSampleFileActorState<FetchCheckpointBytesSampleFileActor>(cx, metaData, dir, cFun, maxRetries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5019297861748404736UL, 7963139749767314176UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointBytesSampleFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointBytesSampleFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointBytesSampleFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointBytesSampleFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointBytesSampleFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointBytesSampleFile( Database const& cx, std::shared_ptr<CheckpointMetaData> const& metaData, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun, int const& maxRetries = 3 ) {
															#line 244 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new FetchCheckpointBytesSampleFileActor(cx, metaData, dir, cFun, maxRetries));
															#line 1829 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 265 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

// RocksDBColumnFamilyReader reads a RocksDB checkpoint, and returns the key-value pairs via nextKeyValues.
class RocksDBColumnFamilyReader : public ICheckpointReader {
public:
	class RocksCfCheckpointIterator : public ICheckpointIterator {
	public:
		RocksCfCheckpointIterator(RocksDBColumnFamilyReader* reader, const KeyRange& range, const UID& logId)
		  : reader(reader), range(range), logId(logId) {
			ASSERT(reader != nullptr);
			ASSERT(reader->db != nullptr);
			ASSERT(reader->cf != nullptr);
			this->beginSlice = toSlice(this->range.begin);
			this->endSlice = toSlice(this->range.end);
			rocksdb::ReadOptions options = getReadOptions();
			options.iterate_lower_bound = &beginSlice;
			options.iterate_upper_bound = &endSlice;
			options.fill_cache = false; // Optimized for bulk scan.
			options.readahead_size = SERVER_KNOBS->ROCKSDB_CHECKPOINT_READ_AHEAD_SIZE;
			// Note: ROCKSDB_SET_READ_TIMEOUT is false in simulation. If turned on, this code could lead to
			// non-deterministic simulation because of db->GetEnv()->NowMicros().
			if (SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT) {
				const uint64_t deadlineMicros =
				    reader->db->GetEnv()->NowMicros() + SERVER_KNOBS->ROCKSDB_READ_CHECKPOINT_TIMEOUT * 1000000;
				options.deadline = std::chrono::microseconds(deadlineMicros);
			}
			this->iterator = std::unique_ptr<rocksdb::Iterator>(reader->db->NewIterator(options, reader->cf));
			iterator->Seek(this->beginSlice);
		}

		~RocksCfCheckpointIterator() { this->reader->numIter--; }

		Future<RangeResult> nextBatch(const int rowLimit, const int ByteLimit) override;

		rocksdb::Iterator* getIterator() { return iterator.get(); }

		const rocksdb::Slice& end() const { return this->endSlice; }

	private:
		RocksDBColumnFamilyReader* const reader;
		const KeyRange range;
		rocksdb::Slice beginSlice;
		rocksdb::Slice endSlice;
		std::unique_ptr<rocksdb::Iterator> iterator;
		const UID logId;
	};

	class DummyRocksDBCheckpointIterator : public ICheckpointIterator {
	public:
		DummyRocksDBCheckpointIterator(const UID& logId) : logId(logId) {}

		~DummyRocksDBCheckpointIterator() {}

		Future<RangeResult> nextBatch(const int rowLimit, const int ByteLimit) override { throw end_of_stream(); }

	private:
		const UID logId;
	};

	RocksDBColumnFamilyReader(const CheckpointMetaData& checkpoint, UID logId);

	Future<Void> init(StringRef token) override;

	Future<RangeResult> nextKeyValues(const int rowLimit, const int byteLimit) override { throw not_implemented(); }

	Future<Standalone<StringRef>> nextChunk(const int byteLimit) override { throw not_implemented(); }

	Future<Void> close() override { return doClose(this); }

	std::unique_ptr<ICheckpointIterator> getIterator(KeyRange range) override;

	bool inUse() const override { return this->numIter > 0; }

private:
	struct Reader : IThreadPoolReceiver {
		struct OpenAction : TypedAction<Reader, OpenAction> {
			OpenAction(CheckpointMetaData checkpoint) : checkpoint(std::move(checkpoint)) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }

			const CheckpointMetaData checkpoint;
			ThreadReturnPromise<Void> done;
		};

		struct CloseAction : TypedAction<Reader, CloseAction> {
			CloseAction(std::string path, bool deleteOnClose) : path(path), deleteOnClose(deleteOnClose) {}
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }

			std::string path;
			bool deleteOnClose;
			ThreadReturnPromise<Void> done;
		};

		struct ReadRangeAction : TypedAction<Reader, ReadRangeAction>, FastAllocated<ReadRangeAction> {
			ReadRangeAction(int rowLimit, int byteLimit, RocksCfCheckpointIterator* iterator)
			  : rowLimit(rowLimit), byteLimit(byteLimit), iterator(iterator), startTime(timer_monotonic()) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->READ_RANGE_TIME_ESTIMATE; }

			const int rowLimit, byteLimit;
			RocksCfCheckpointIterator* const iterator;
			const double startTime;
			ThreadReturnPromise<RangeResult> result;
		};

		explicit Reader(DB& db, CF& cf, std::vector<rocksdb::ColumnFamilyHandle*>& handles, const UID& logId);
		~Reader() override {}

		void init() override {}

		void action(OpenAction& a);

		void action(CloseAction& a);

		void action(ReadRangeAction& a);

		rocksdb::Status tryOpenForRead(const std::string& path);

		rocksdb::Status importCheckpoint(const std::string& path, const CheckpointMetaData& checkpoint);

		rocksdb::Status closeInternal(const std::string& path, const bool deleteOnClose);

		DB& db;
		CF& cf;
		std::vector<rocksdb::ColumnFamilyHandle*>& handles;
		double readRangeTimeout;
		const UID logId;
	};

	Future<RangeResult> nextBatch(const int rowLimit, const int byteLimit, RocksCfCheckpointIterator* iterator);

																#line 1963 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
[[nodiscard]] static Future<Void> doClose( RocksDBColumnFamilyReader* const& self );
template <class> friend class RocksDBColumnFamilyReader_DoCloseActorState;

#line 396 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

	DB db = nullptr;
	CF cf = nullptr;
	std::vector<rocksdb::ColumnFamilyHandle*> handles;
	std::string path;
	const UID logId;
	Version version;
	CheckpointMetaData checkpoint;
	Reference<IThreadPool> threads;
	Future<Void> openFuture;
	int numIter;
	bool empty;
};

Future<RangeResult> RocksDBColumnFamilyReader::RocksCfCheckpointIterator::nextBatch(const int rowLimit,
                                                                                    const int ByteLimit) {
	return this->reader->nextBatch(rowLimit, ByteLimit, this);
}

RocksDBColumnFamilyReader::RocksDBColumnFamilyReader(const CheckpointMetaData& checkpoint, UID logId)
  : logId(logId), checkpoint(checkpoint), numIter(0) {
	if (g_network->isSimulated()) {
		threads = CoroThreadPool::createThreadPool();
	} else {
		threads = createGenericThreadPool();
	}
	for (int i = 0; i < SERVER_KNOBS->ROCKSDB_CHECKPOINT_READER_PARALLELISM; ++i) {
		threads->addThread(new Reader(db, cf, handles, logId), "fdb-rocks-cr");
	}
	if (checkpoint.getFormat() == DataMoveRocksCF) {
		const RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
		this->empty = rocksCF.sstFiles.empty();
	} else {
		this->empty = false;
	}
}

Future<Void> RocksDBColumnFamilyReader::init(StringRef token) {
	if (openFuture.isValid()) {
		return openFuture;
	}

	if (this->empty) {
		return Void();
	}

	auto a = std::make_unique<Reader::OpenAction>(this->checkpoint);
	openFuture = a->done.getFuture();
	threads->post(a.release());
	return openFuture;
}

Future<RangeResult> RocksDBColumnFamilyReader::nextBatch(const int rowLimit,
                                                         const int byteLimit,
                                                         RocksCfCheckpointIterator* iterator) {
	auto a = std::make_unique<Reader::ReadRangeAction>(rowLimit, byteLimit, iterator);
	auto res = a->result.getFuture();
	threads->post(a.release());
	return res;
}

std::unique_ptr<ICheckpointIterator> RocksDBColumnFamilyReader::getIterator(KeyRange range) {
	++this->numIter;
	if (this->empty) {
		return std::unique_ptr<ICheckpointIterator>(new DummyRocksDBCheckpointIterator(logId));
	} else {
		return std::unique_ptr<ICheckpointIterator>(new RocksCfCheckpointIterator(this, range, logId));
	}
}

RocksDBColumnFamilyReader::Reader::Reader(DB& db,
                                          CF& cf,
                                          std::vector<rocksdb::ColumnFamilyHandle*>& handles,
                                          const UID& logId)
  : db(db), cf(cf), handles(handles), logId(logId) {}

void RocksDBColumnFamilyReader::Reader::action(RocksDBColumnFamilyReader::Reader::OpenAction& a) {
	TraceEvent(SevDebug, "RocksDBCheckpointReaderInitBegin", logId).detail("Checkpoint", a.checkpoint.toString());
	ASSERT(cf == nullptr);

	const CheckpointMetaData& checkpoint = a.checkpoint;
	const CheckpointFormat format = checkpoint.getFormat();
	if (format != DataMoveRocksCF) {
		TraceEvent(SevDebug, "RocksDBCheckpointReaderError", logId).detail("InvalidFormat", checkpoint.toString());
		a.done.sendError(not_implemented());
		return;
	}

	RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
	ASSERT(!rocksCF.sstFiles.empty());
	const std::vector<std::string> files = platform::listFiles(rocksCF.sstFiles.front().db_path);
	TraceEvent(SevDebug, "RocksDBColumnFamilyReaderInputFiles", logId).detail("Files", describe(files));
	const std::string path = joinPath(rocksCF.sstFiles.front().db_path, checkpointReaderSubDir);

	// Try to read the existing DB, the checkpoint could have been imported already.
	rocksdb::Status status = tryOpenForRead(path);

	// Existing DB is not ready to use, redo checkpoint import.
	if (!status.ok()) {
		TraceEvent(SevDebug, "RocksDBCheckpointOpenForReadFailed", logId)
		    .detail("Status", status.ToString())
		    .detail("Path", path);
		platform::eraseDirectoryRecursive(path);
		status = importCheckpoint(path, checkpoint);
		if (status.ok()) {
			status = tryOpenForRead(path);
		}
	}

	if (!status.ok()) {
		a.done.sendError(checkpoint_not_found());
		return;
	}

	a.done.send(Void());
	TraceEvent(SevDebug, "RocksDBCheckpointReaderInitEnd", logId)
	    .detail("Path", path)
	    .detail("ColumnFamily", cf->GetName());
}

void RocksDBColumnFamilyReader::Reader::action(RocksDBColumnFamilyReader::Reader::CloseAction& a) {
	closeInternal(a.path, a.deleteOnClose);
	a.done.send(Void());
}

void RocksDBColumnFamilyReader::Reader::action(RocksDBColumnFamilyReader::Reader::ReadRangeAction& a) {
	TraceEvent(SevDebug, "RocksDBCheckpointReaderReadRangeBegin", logId);
	ASSERT(a.iterator != nullptr);

	RangeResult result;
	if (a.rowLimit == 0 || a.byteLimit == 0) {
		a.result.send(result);
		return;
	}

	// For now, only forward scan is supported.
	ASSERT(a.rowLimit > 0);

	rocksdb::Iterator* iter = a.iterator->getIterator();
	int accumulatedBytes = 0;
	rocksdb::Status s;
	while (iter->Valid() && iter->key().compare(a.iterator->end()) < 0) {
		KeyValueRef kv(toStringRef(iter->key()), toStringRef(iter->value()));
		accumulatedBytes += sizeof(KeyValueRef) + kv.expectedSize();
		result.push_back_deep(result.arena(), kv);
		iter->Next();
		if (result.size() >= a.rowLimit || accumulatedBytes >= a.byteLimit) {
			break;
		}
	}

	s = iter->status();

	if (!s.ok()) {
		logRocksDBError(s, "ReadRange", logId);
		a.result.sendError(statusToError(s));
		return;
	}

	if (result.empty()) {
		a.result.sendError(end_of_stream());
	} else {
		a.result.send(result);
	}
}

rocksdb::Status RocksDBColumnFamilyReader::Reader::tryOpenForRead(const std::string& path) {
	std::vector<std::string> columnFamilies;
	const rocksdb::Options options = getOptions();
	rocksdb::Status status = rocksdb::DB::ListColumnFamilies(options, path, &columnFamilies);
	if (std::find(columnFamilies.begin(), columnFamilies.end(), rocksDefaultCf) == columnFamilies.end() ||
	    std::find(columnFamilies.begin(), columnFamilies.end(), checkpointCf) == columnFamilies.end()) {
		return rocksdb::Status::Aborted();
	}

	const rocksdb::ColumnFamilyOptions cfOptions = getCFOptions();
	std::vector<rocksdb::ColumnFamilyDescriptor> descriptors;
	for (const std::string& name : columnFamilies) {
		descriptors.emplace_back(name, cfOptions);
	}
	status = rocksdb::DB::OpenForReadOnly(options, path, descriptors, &handles, &db);
	if (!status.ok()) {
		logRocksDBError(status, "OpenForReadOnly", logId);
		return status;
	}

	rocksdb::PinnableSlice value;
	rocksdb::ReadOptions readOptions = getReadOptions();
	status = db->Get(readOptions, db->DefaultColumnFamily(), toSlice(readerInitialized), &value);
	if (!status.ok() && !status.IsNotFound()) {
		logRocksDBError(status, "CheckpointCheckInitState", logId);
		auto closeStatus = closeInternal(path, /*deleteOnClose=*/true);
		if (!closeStatus.ok()) {
			logRocksDBError(closeStatus, "CheckpointCloseInternal", logId);
		}
		delete db;
		return status;
	}

	if (status.IsNotFound()) {
		status = closeInternal(path, /*deleteOnClose=*/true);
		if (!status.ok()) {
			logRocksDBError(status, "CheckpointCloseInternal", logId);
		}
		delete db;
		TraceEvent(SevDebug, "RocksDBCheckpointReaderTryOpenError", logId).detail("Path", path);
		return rocksdb::Status::Aborted();
	}

	ASSERT(handles.size() == 2);
	for (rocksdb::ColumnFamilyHandle* handle : handles) {
		if (handle->GetName() == checkpointCf) {
			TraceEvent(SevDebug, "RocksDBCheckpointCF", logId)
			    .detail("Path", path)
			    .detail("ColumnFamily", handle->GetName());
			cf = handle;
			break;
		}
	}

	ASSERT(db != nullptr && cf != nullptr);
	return rocksdb::Status::OK();
}

rocksdb::Status RocksDBColumnFamilyReader::Reader::importCheckpoint(const std::string& path,
                                                                    const CheckpointMetaData& checkpoint) {
	TraceEvent(SevInfo, "CheckpointReaderImportCheckpointBegin", logId)
	    .detail("Path", path)
	    .detail("Checkpoint", checkpoint.toString());
	std::vector<std::string> columnFamilies;
	const rocksdb::Options options = getOptions();
	rocksdb::Status status = rocksdb::DB::ListColumnFamilies(options, path, &columnFamilies);
	if (std::find(columnFamilies.begin(), columnFamilies.end(), rocksDefaultCf) == columnFamilies.end()) {
		columnFamilies.push_back(rocksDefaultCf);
	}
	ASSERT(std::find(columnFamilies.begin(), columnFamilies.end(), checkpointCf) == columnFamilies.end());

	const rocksdb::ColumnFamilyOptions cfOptions = getCFOptions();
	std::vector<rocksdb::ColumnFamilyDescriptor> descriptors;
	for (const std::string& name : columnFamilies) {
		descriptors.emplace_back(name, cfOptions);
	}

	status = rocksdb::DB::Open(options, path, descriptors, &handles, &db);
	if (!status.ok()) {
		TraceEvent(SevWarn, "CheckpointReaderOpenedFailed", logId)
		    .detail("Status", status.ToString())
		    .detail("Path", path)
		    .detail("Checkpoint", checkpoint.toString());
		return status;
	}

	TraceEvent(SevInfo, "CheckpointReaderOpenedForImport", logId)
	    .detail("Path", path)
	    .detail("Checkpoint", checkpoint.toString());

	rocksdb::ExportImportFilesMetaData metaData = getMetaData(checkpoint);
	rocksdb::ImportColumnFamilyOptions importOptions;
	importOptions.move_files = false;
	status = db->CreateColumnFamilyWithImport(cfOptions, checkpointCf, importOptions, metaData, &cf);
	if (!status.ok()) {
		logRocksDBError(status, "CheckpointReaderImportCheckpoint", logId);
		return status;
	}
	handles.push_back(cf);
	TraceEvent(SevDebug, "RocksDBCheckpointReaderImportedCF", logId);

	rocksdb::WriteOptions writeOptions;
	writeOptions.sync = !SERVER_KNOBS->ROCKSDB_UNSAFE_AUTO_FSYNC;
	status = db->Put(writeOptions, toSlice(readerInitialized), toSlice("1"_sr));
	if (!status.ok()) {
		logRocksDBError(status, "CheckpointReaderPersistInitKey", logId);
		return status;
	}
	ASSERT(db != nullptr && cf != nullptr);

	return closeInternal(path, /*deleteOnClose=*/false);
}

rocksdb::Status RocksDBColumnFamilyReader::Reader::closeInternal(const std::string& path, const bool deleteOnClose) {
	if (db == nullptr) {
		return rocksdb::Status::OK();
	}

	for (rocksdb::ColumnFamilyHandle* handle : handles) {
		if (handle != nullptr) {
			TraceEvent("RocksDBCheckpointReaderDestroyCF", logId).detail("Path", path).detail("CF", handle->GetName());
			db->DestroyColumnFamilyHandle(handle);
		}
	}
	handles.clear();

	rocksdb::Status s = db->Close();
	if (!s.ok()) {
		logRocksDBError(s, "Close", logId);
	}

	if (deleteOnClose) {
		rocksdb::ColumnFamilyOptions options;
		std::vector<rocksdb::ColumnFamilyDescriptor> descriptors;
		descriptors.emplace_back(rocksDefaultCf, options);
		descriptors.emplace_back(checkpointCf, options);
		s = rocksdb::DestroyDB(path, getOptions(), descriptors);
		if (!s.ok()) {
			logRocksDBError(s, "Destroy", logId);
		} else {
			TraceEvent(SevDebug, "RocksDBColumnFamilyReader", logId).detail("Path", path).detail("Method", "Destroy");
		}
	}

	TraceEvent(SevDebug, "RocksDBColumnFamilyReader", logId).detail("Path", path).detail("Method", "Close");
	return s;
}

															#line 2282 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via doClose()
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class RocksDBColumnFamilyReader_DoCloseActor>
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class RocksDBColumnFamilyReader_DoCloseActorState {
															#line 2288 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBColumnFamilyReader_DoCloseActorState(RocksDBColumnFamilyReader* const& self) 
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : self(self)
															#line 2295 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("doClose", reinterpret_cast<unsigned long>(this));

	}
	~RocksDBColumnFamilyReader_DoCloseActorState() 
	{
		fdb_probe_actor_destroy("doClose", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 711 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (self == nullptr)
															#line 2310 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 712 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (!static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RocksDBColumnFamilyReader_DoCloseActorState(); static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->destroy(); return 0; }
															#line 2314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				new (&static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RocksDBColumnFamilyReader_DoCloseActorState();
				static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 714 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			auto a = new RocksDBColumnFamilyReader::Reader::CloseAction(self->path, false);
															#line 715 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			auto f = a->done.getFuture();
															#line 716 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			self->threads->post(a);
															#line 717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2330 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state = 1;
															#line 717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >*>(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)));
															#line 2335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RocksDBColumnFamilyReader_DoCloseActorState();
		static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (self != nullptr)
															#line 2358 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->threads->stop();
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2364 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*>(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)));
															#line 2369 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (self != nullptr)
															#line 2383 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->threads->stop();
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2389 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*>(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)));
															#line 2394 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state > 0) static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 723 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (self != nullptr)
															#line 2483 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 724 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (self->db != nullptr)
															#line 2487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 725 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				delete self->db;
															#line 2491 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
															#line 727 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			delete self;
															#line 2495 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 730 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RocksDBColumnFamilyReader_DoCloseActorState(); static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->destroy(); return 0; }
															#line 2499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RocksDBColumnFamilyReader_DoCloseActorState();
		static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state > 0) static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBColumnFamilyReader* self;
															#line 2596 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via doClose()
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class RocksDBColumnFamilyReader_DoCloseActor final : public Actor<Void>, public ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >, public ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >, public FastAllocated<RocksDBColumnFamilyReader_DoCloseActor>, public RocksDBColumnFamilyReader_DoCloseActorState<RocksDBColumnFamilyReader_DoCloseActor> {
															#line 2601 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<RocksDBColumnFamilyReader_DoCloseActor>::operator new;
	using FastAllocated<RocksDBColumnFamilyReader_DoCloseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17788341229792328448UL, 4437742301019845632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >;
friend struct ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >;
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBColumnFamilyReader_DoCloseActor(RocksDBColumnFamilyReader* const& self) 
															#line 2619 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   RocksDBColumnFamilyReader_DoCloseActorState<RocksDBColumnFamilyReader_DoCloseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7415260561252717312UL, 2457538904907657984UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBColumnFamilyReader_DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doClose");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RocksDBColumnFamilyReader_DoCloseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> RocksDBColumnFamilyReader::doClose( RocksDBColumnFamilyReader* const& self ) {
															#line 710 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new RocksDBColumnFamilyReader_DoCloseActor(self));
															#line 2652 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 732 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

class RocksDBSstFileWriter : public IRocksDBSstFileWriter {
public:
	RocksDBSstFileWriter()
	  : writer(std::make_unique<rocksdb::SstFileWriter>(rocksdb::EnvOptions(), rocksdb::Options())), hasData(false) {};

	void open(const std::string localFile) override;

	void write(const KeyRef key, const ValueRef value) override;

	bool finish() override;

private:
	std::unique_ptr<rocksdb::SstFileWriter> writer;
	std::string localFile;
	bool hasData;
};

void RocksDBSstFileWriter::open(const std::string localFile) {
	this->localFile = abspath(localFile);
	rocksdb::Status status = this->writer->Open(this->localFile);
	if (!status.ok()) {
		TraceEvent(SevError, "RocksDBSstFileWriterWrapperOpenFileError")
		    .detail("LocalFile", this->localFile)
		    .detail("Status", status.ToString());
		throw failed_to_create_checkpoint_shard_metadata();
	}
}

void RocksDBSstFileWriter::write(const KeyRef key, const ValueRef value) {
	rocksdb::Status status = this->writer->Put(toSlice(key), toSlice(value));
	if (!status.ok()) {
		TraceEvent(SevError, "RocksDBSstFileWriterWrapperWriteError")
		    .detail("LocalFile", this->localFile)
		    .detail("Key", key)
		    .detail("Value", value)
		    .detail("Status", status.ToString());
		throw failed_to_create_checkpoint_shard_metadata();
	}
	this->hasData = true;
}

bool RocksDBSstFileWriter::finish() {
	if (!this->hasData) {
		// writer->finish() cannot create sst file with no entries
		// So, we have to check whether any data set to be written to sst file before writer->finish()
		return false;
	}
	rocksdb::Status status = this->writer->Finish();
	if (!status.ok()) {
		TraceEvent(SevError, "RocksDBSstFileWriterWrapperCloseError")
		    .detail("LocalFile", this->localFile)
		    .detail("Status", status.ToString());
		throw failed_to_create_checkpoint_shard_metadata();
	}
	return true;
}

class RocksDBSstFileReader : public IRocksDBSstFileReader {
public:
	RocksDBSstFileReader() : sstReader(std::make_unique<rocksdb::SstFileReader>(rocksdb::Options())) {};

	RocksDBSstFileReader(const KeyRange& rangeBoundary, size_t rowLimit, size_t byteLimit)
	  : sstReader(std::make_unique<rocksdb::SstFileReader>(rocksdb::Options())), rowLimit(rowLimit),
	    byteLimit(byteLimit) {
		beginSlice = toSlice(rangeBoundary.begin);
		endSlice = toSlice(rangeBoundary.end);
	};

	~RocksDBSstFileReader() {}

	void open(const std::string localFile) override;

	KeyValue next() override;

	bool hasNext() const override;

	RangeResult getRange(const KeyRange& range) override;

private:
	std::unique_ptr<rocksdb::SstFileReader> sstReader;
	std::unique_ptr<rocksdb::Iterator> iter;
	std::string localFile;
	rocksdb::Slice beginSlice;
	rocksdb::Slice endSlice;
	size_t byteLimit = -1;
	size_t rowLimit = -1;
};

void RocksDBSstFileReader::open(const std::string localFile) {
	this->localFile = abspath(localFile);
	rocksdb::Status status = sstReader->Open(this->localFile);
	if (status.ok()) {
		rocksdb::ReadOptions readOptions = getReadOptions();
		if (!beginSlice.empty()) {
			readOptions.iterate_lower_bound = &beginSlice;
		}
		if (!endSlice.empty()) {
			readOptions.iterate_upper_bound = &endSlice;
			// Note that iterator can return the endSlice but this endSlice is out of the range.
			// So, we need to check whether the key from iterator is out of the range.
		}
		iter.reset(sstReader->NewIterator(readOptions));
		if (!beginSlice.empty()) {
			iter->Seek(beginSlice);
		} else {
			iter->SeekToFirst();
		}
	} else {
		TraceEvent(SevError, "RocksDBSstFileReaderWrapperOpenFileError")
		    .detail("LocalFile", this->localFile)
		    .detail("Status", status.ToString());
	}
}

bool RocksDBSstFileReader::hasNext() const {
	return iter != nullptr && this->iter->Valid();
}

KeyValue RocksDBSstFileReader::next() {
	KeyValue res(KeyValueRef(toStringRef(this->iter->key()), toStringRef(this->iter->value())));
	iter->Next();
	return res;
}

// TODO(BulkLoad): current the bulkload is the only place using the method.
// This is implemented as the sync call for the simplicity. In the future
// we will implement this as async call using action.
RangeResult RocksDBSstFileReader::getRange(const KeyRange& range) {
	RangeResult rep;
	size_t expectedSize = 0;
	size_t keyCount = 0;
	ASSERT(iter != nullptr);
	iter->Seek(toSlice(range.begin));
	if (!iter->Valid() || toStringRef(iter->key()) >= range.end) {
		rep.more = false;
		return rep;
	}
	while (true) {
		KeyValue kv = KeyValueRef(toStringRef(iter->key()), toStringRef(iter->value()));
		rep.push_back_deep(rep.arena(), kv);
		expectedSize = expectedSize + kv.expectedSize();
		keyCount++;
		if (g_network->isSimulated() && SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION &&
		    deterministicRandom()->random01() < 0.1) {
			TraceEvent(SevWarnAlways, "TryGetRangeForBulkLoadInjectError");
			throw operation_failed();
		}
		if ((byteLimit > 0 && expectedSize >= byteLimit) || (rowLimit > 0 && keyCount >= rowLimit)) {
			break;
		}

		iter->Next(); // Go to next at first, then decide if the rep has more.
		if (!iter->Valid()) {
			break;
		}
		if (toStringRef(iter->key()) >= range.end) {
			break;
		}
	}
	rep.more = iter->Valid() && toStringRef(iter->key()) < range.end;
	return rep;
}

class RocksDBCheckpointByteSampleReader : public ICheckpointByteSampleReader {
public:
	RocksDBCheckpointByteSampleReader(const CheckpointMetaData& checkpoint);
	~RocksDBCheckpointByteSampleReader() {}

	KeyValue next() override;

	bool hasNext() const override;

private:
	std::unique_ptr<rocksdb::SstFileReader> sstReader;
	std::unique_ptr<rocksdb::Iterator> iter;
};

RocksDBCheckpointByteSampleReader::RocksDBCheckpointByteSampleReader(const CheckpointMetaData& checkpoint)
  : sstReader(std::make_unique<rocksdb::SstFileReader>(rocksdb::Options())) {
	ASSERT(checkpoint.bytesSampleFile.present());
	rocksdb::Status status = sstReader->Open(checkpoint.bytesSampleFile.get());
	TraceEvent(SevDebug, "RocksDBCheckpointByteSampleReaderInit")
	    .detail("Checkpoint", checkpoint.toString())
	    .detail("Status", status.ToString());
	if (status.ok()) {
		iter.reset(sstReader->NewIterator(getReadOptions()));
		iter->SeekToFirst();
	} else {
		TraceEvent(SevError, "RocksDBCheckpointByteSampleReaderInit")
		    .detail("Checkpoint", checkpoint.toString())
		    .detail("Status", status.ToString());
	}
}

bool RocksDBCheckpointByteSampleReader::hasNext() const {
	return iter != nullptr && this->iter->Valid();
}

KeyValue RocksDBCheckpointByteSampleReader::next() {
	KeyValue res(KeyValueRef(toStringRef(this->iter->key()), toStringRef(this->iter->value())));
	iter->Next();
	return res;
}

// RocksDBCFCheckpointReader reads an exported RocksDB Column Family checkpoint files, and returns the
// serialized checkpoint via nextChunk.
class RocksDBCFCheckpointReader : public ICheckpointReader {
public:
	RocksDBCFCheckpointReader(const CheckpointMetaData& checkpoint, UID logId)
	  : checkpoint_(checkpoint), id_(logId), file_(Reference<IAsyncFile>()), offset_(0) {}

	Future<Void> init(StringRef token) override;

	Future<RangeResult> nextKeyValues(const int rowLimit, const int byteLimit) override { throw not_implemented(); }

	Future<Standalone<StringRef>> nextChunk(const int byteLimit) override;

	Future<Void> close() override;

private:
																#line 2877 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via doInit()
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class DoInitActor>
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoInitActorState {
															#line 2883 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoInitActorState(RocksDBCFCheckpointReader* const& self) 
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : self(self)
															#line 2890 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("doInit", reinterpret_cast<unsigned long>(this));

	}
	~DoInitActorState() 
	{
		fdb_probe_actor_destroy("doInit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 954 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT(self != nullptr);
															#line 2905 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			try {
															#line 956 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( self->path_, IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO, 0);
															#line 956 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (static_cast<DoInitActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2911 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoInitActor*>(this)->actor_wait_state = 1;
															#line 956 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >*>(static_cast<DoInitActor*>(this)));
															#line 2916 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoInitActorState();
		static_cast<DoInitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 967 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DoInitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoInitActorState(); static_cast<DoInitActor*>(this)->destroy(); return 0; }
															#line 2945 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DoInitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoInitActorState();
		static_cast<DoInitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 961 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "RocksDBCFCheckpointReaderInitError") .errorUnsuppressed(e) .detail("File", self->path_);
															#line 964 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2960 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 958 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		self->file_ = _file;
															#line 959 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent("RocksDBCheckpointReaderOpenFile").detail("File", self->path_);
															#line 2976 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& ___file,int loopDepth) 
	{
															#line 956 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		_file = ___file;
															#line 2985 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && ___file,int loopDepth) 
	{
		_file = std::move(___file);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoInitActor*>(this)->actor_wait_state > 0) static_cast<DoInitActor*>(this)->actor_wait_state = 0;
		static_cast<DoInitActor*>(this)->ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("doInit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoInitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doInit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("doInit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoInitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doInit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("doInit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoInitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doInit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBCFCheckpointReader* self;
															#line 956 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Reference<IAsyncFile> _file;
															#line 3077 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via doInit()
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoInitActor final : public Actor<Void>, public ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >, public FastAllocated<DoInitActor>, public DoInitActorState<DoInitActor> {
															#line 3082 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<DoInitActor>::operator new;
	using FastAllocated<DoInitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9175833506245436928UL, 7369793011172352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >;
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoInitActor(RocksDBCFCheckpointReader* const& self) 
															#line 3099 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   DoInitActorState<DoInitActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doInit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13765458169324506368UL, 15929961339081742592UL);
		ActorExecutionContextHelper __helper(static_cast<DoInitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doInit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doInit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoInitActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] static Future<Void> doInit( RocksDBCFCheckpointReader* const& self ) {
															#line 953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new DoInitActor(self));
															#line 3131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 969 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

																#line 3136 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via getNextChunk()
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class GetNextChunkActor>
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class GetNextChunkActorState {
															#line 3142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	GetNextChunkActorState(RocksDBCFCheckpointReader* const& self,int const& byteLimit) 
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : self(self),
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   byteLimit(byteLimit)
															#line 3151 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("getNextChunk", reinterpret_cast<unsigned long>(this));

	}
	~GetNextChunkActorState() 
	{
		fdb_probe_actor_destroy("getNextChunk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 972 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			int blockSize = std::min(64 * 1024, byteLimit);
															#line 973 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			buf = makeAlignedString(_PAGE_SIZE, blockSize);
															#line 974 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<int> __when_expr_0 = self->file_->read(mutateString(buf), blockSize, self->offset_);
															#line 974 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3172 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			static_cast<GetNextChunkActor*>(this)->actor_wait_state = 1;
															#line 974 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNextChunkActor, 0, int >*>(static_cast<GetNextChunkActor*>(this)));
															#line 3176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNextChunkActorState();
		static_cast<GetNextChunkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 975 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (bytesRead == 0)
															#line 3199 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 976 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1Catch1(end_of_stream(), loopDepth);
															#line 3203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 979 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		self->offset_ += bytesRead;
															#line 980 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<GetNextChunkActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(buf.substr(0, bytesRead)); this->~GetNextChunkActorState(); static_cast<GetNextChunkActor*>(this)->destroy(); return 0; }
															#line 3209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<GetNextChunkActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(buf.substr(0, bytesRead));
		this->~GetNextChunkActorState();
		static_cast<GetNextChunkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && bytesRead,int loopDepth) 
	{
															#line 975 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (bytesRead == 0)
															#line 3221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 976 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1Catch1(end_of_stream(), loopDepth);
															#line 3225 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 979 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		self->offset_ += bytesRead;
															#line 980 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<GetNextChunkActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(buf.substr(0, bytesRead)); this->~GetNextChunkActorState(); static_cast<GetNextChunkActor*>(this)->destroy(); return 0; }
															#line 3231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<GetNextChunkActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(buf.substr(0, bytesRead));
		this->~GetNextChunkActorState();
		static_cast<GetNextChunkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNextChunkActor*>(this)->actor_wait_state > 0) static_cast<GetNextChunkActor*>(this)->actor_wait_state = 0;
		static_cast<GetNextChunkActor*>(this)->ActorCallback< GetNextChunkActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< GetNextChunkActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("getNextChunk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextChunkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextChunk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNextChunkActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("getNextChunk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextChunkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextChunk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNextChunkActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("getNextChunk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextChunkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextChunk", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBCFCheckpointReader* self;
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int byteLimit;
															#line 973 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Standalone<StringRef> buf;
															#line 3320 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via getNextChunk()
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class GetNextChunkActor final : public Actor<Standalone<StringRef>>, public ActorCallback< GetNextChunkActor, 0, int >, public FastAllocated<GetNextChunkActor>, public GetNextChunkActorState<GetNextChunkActor> {
															#line 3325 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<GetNextChunkActor>::operator new;
	using FastAllocated<GetNextChunkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5830445895224741376UL, 10611612522252638976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNextChunkActor, 0, int >;
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	GetNextChunkActor(RocksDBCFCheckpointReader* const& self,int const& byteLimit) 
															#line 3342 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   GetNextChunkActorState<GetNextChunkActor>(self, byteLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNextChunk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13948379558479865600UL, 15894959338260709632UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextChunkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNextChunk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNextChunk", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
static Future<Standalone<StringRef>> getNextChunk( RocksDBCFCheckpointReader* const& self, int const& byteLimit ) {
															#line 970 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Standalone<StringRef>>(new GetNextChunkActor(self, byteLimit));
															#line 3365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 982 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

																#line 3370 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via doClose()
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class DoCloseActor>
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoCloseActorState {
															#line 3376 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoCloseActorState(RocksDBCFCheckpointReader* const& self) 
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : self(self)
															#line 3383 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("doClose", reinterpret_cast<unsigned long>(this));

	}
	~DoCloseActorState() 
	{
		fdb_probe_actor_destroy("doClose", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 984 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::FetchKeys);
															#line 984 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<DoCloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3400 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoCloseActor*>(this)->actor_wait_state = 1;
															#line 984 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 0, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 3405 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCloseActorState();
		static_cast<DoCloseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 985 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		delete self;
															#line 986 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DoCloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCloseActorState(); static_cast<DoCloseActor*>(this)->destroy(); return 0; }
															#line 3430 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DoCloseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCloseActorState();
		static_cast<DoCloseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 985 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		delete self;
															#line 986 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DoCloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCloseActorState(); static_cast<DoCloseActor*>(this)->destroy(); return 0; }
															#line 3444 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DoCloseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCloseActorState();
		static_cast<DoCloseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCloseActor*>(this)->actor_wait_state > 0) static_cast<DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<DoCloseActor*>(this)->ActorCallback< DoCloseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCloseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBCFCheckpointReader* self;
															#line 3529 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via doClose()
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DoCloseActor final : public Actor<Void>, public ActorCallback< DoCloseActor, 0, Void >, public FastAllocated<DoCloseActor>, public DoCloseActorState<DoCloseActor> {
															#line 3534 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<DoCloseActor>::operator new;
	using FastAllocated<DoCloseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17788341229792328448UL, 4437742301019845632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCloseActor, 0, Void >;
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DoCloseActor(RocksDBCFCheckpointReader* const& self) 
															#line 3551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   DoCloseActorState<DoCloseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8249376994020974080UL, 9463511211515355904UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doClose");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCloseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] static Future<Void> doClose( RocksDBCFCheckpointReader* const& self ) {
															#line 983 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new DoCloseActor(self));
															#line 3583 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 988 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

	CheckpointMetaData checkpoint_;
	UID id_;
	Reference<IAsyncFile> file_;
	int offset_;
	std::string path_;
};

Future<Void> RocksDBCFCheckpointReader::init(StringRef token) {
	ASSERT_EQ(this->checkpoint_.getFormat(), DataMoveRocksCF);
	const std::string name = token.toString();
	this->offset_ = 0;
	this->path_.clear();
	const RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(this->checkpoint_);
	for (const auto& sstFile : rocksCF.sstFiles) {
		if (sstFile.name == name) {
			this->path_ = sstFile.db_path + sstFile.name;
			break;
		}
	}

	if (this->path_.empty() && this->checkpoint_.bytesSampleFile.present() &&
	    this->checkpoint_.bytesSampleFile.get() == name) {
		this->path_ = name;
	}

	if (this->path_.empty()) {
		TraceEvent("RocksDBCheckpointReaderInitFileNotFound").detail("File", this->path_);
		return checkpoint_not_found();
	}

	return doInit(this);
}

Future<Standalone<StringRef>> RocksDBCFCheckpointReader::nextChunk(const int byteLimit) {
	return getNextChunk(this, byteLimit);
}

Future<Void> RocksDBCFCheckpointReader::close() {
	return doClose(this);
}

// Fetch a single sst file from storage server. The progress is checkpointed via cFun.
															#line 3630 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via fetchCheckpointFile()
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchCheckpointFileActor>
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointFileActorState {
															#line 3636 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointFileActorState(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,int const& idx,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   metaData(metaData),
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   idx(idx),
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun),
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   maxRetries(maxRetries),
															#line 1037 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   rocksCF(getRocksCF(*metaData))
															#line 3655 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpointFile", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointFileActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1040 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (rocksCF.sstFiles[idx].fetched && rocksCF.sstFiles[idx].db_path == dir)
															#line 3670 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1041 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (!static_cast<FetchCheckpointFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointFileActorState(); static_cast<FetchCheckpointFileActor*>(this)->destroy(); return 0; }
															#line 3674 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				new (&static_cast<FetchCheckpointFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FetchCheckpointFileActorState();
				static_cast<FetchCheckpointFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1044 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			const std::string remoteFile = rocksCF.sstFiles[idx].name;
															#line 1045 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			const std::string localFile = joinPath(dir, rocksCF.sstFiles[idx].name);
															#line 1046 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT_EQ(metaData->src.size(), 1);
															#line 1047 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			const UID ssId = metaData->src.front();
															#line 1049 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(doFetchCheckpointFile(cx, remoteFile, localFile, ssId, metaData->checkpointID));
															#line 1049 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3692 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state = 1;
															#line 1049 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointFileActor, 0, Void >*>(static_cast<FetchCheckpointFileActor*>(this)));
															#line 3697 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointFileActorState();
		static_cast<FetchCheckpointFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		rocksCF.sstFiles[idx].db_path = dir;
															#line 1051 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		rocksCF.sstFiles[idx].fetched = true;
															#line 1052 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		metaData->setSerializedCheckpoint(ObjectWriter::toValue(rocksCF, IncludeVersion()));
															#line 1053 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 3726 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3732 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state = 2;
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointFileActor, 1, Void >*>(static_cast<FetchCheckpointFileActor*>(this)));
															#line 3737 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		rocksCF.sstFiles[idx].db_path = dir;
															#line 1051 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		rocksCF.sstFiles[idx].fetched = true;
															#line 1052 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		metaData->setSerializedCheckpoint(ObjectWriter::toValue(rocksCF, IncludeVersion()));
															#line 1053 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 3757 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3763 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state = 2;
															#line 1054 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointFileActor, 1, Void >*>(static_cast<FetchCheckpointFileActor*>(this)));
															#line 3768 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointFileActor*>(this)->ActorCallback< FetchCheckpointFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1056 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchCheckpointFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointFileActorState(); static_cast<FetchCheckpointFileActor*>(this)->destroy(); return 0; }
															#line 3857 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchCheckpointFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointFileActorState();
		static_cast<FetchCheckpointFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointFileActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointFileActor*>(this)->ActorCallback< FetchCheckpointFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<CheckpointMetaData> metaData;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int idx;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int maxRetries;
															#line 1037 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBColumnFamilyCheckpoint rocksCF;
															#line 3966 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpointFile()
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointFileActor final : public Actor<Void>, public ActorCallback< FetchCheckpointFileActor, 0, Void >, public ActorCallback< FetchCheckpointFileActor, 1, Void >, public FastAllocated<FetchCheckpointFileActor>, public FetchCheckpointFileActorState<FetchCheckpointFileActor> {
															#line 3971 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointFileActor>::operator new;
	using FastAllocated<FetchCheckpointFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14349669633015057920UL, 15335654477796948992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointFileActor, 0, Void >;
friend struct ActorCallback< FetchCheckpointFileActor, 1, Void >;
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointFileActor(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,int const& idx,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 3989 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FetchCheckpointFileActorState<FetchCheckpointFileActor>(cx, metaData, idx, dir, cFun, maxRetries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2808661410110164480UL, 11465314132131964928UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointFile( Database const& cx, std::shared_ptr<CheckpointMetaData> const& metaData, int const& idx, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun, int const& maxRetries = 3 ) {
															#line 1031 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new FetchCheckpointFileActor(cx, metaData, idx, dir, cFun, maxRetries));
															#line 4022 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1058 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

// TODO: Return when a file exceeds a limit.
															#line 4028 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via fetchCheckpointRange()
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchCheckpointRangeActor>
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointRangeActorState {
															#line 4034 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointRangeActorState(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,KeyRange const& range,std::string const& dir,std::shared_ptr<rocksdb::SstFileWriter> const& writer,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   metaData(metaData),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   range(range),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   writer(writer),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun),
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   maxRetries(maxRetries),
															#line 1067 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   localFile(joinPath(dir, UID(metaData->checkpointID.first(), deterministicRandom()->randomUInt64()).toString() + ".sst"))
															#line 4055 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpointRange", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointRangeActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1069 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			RocksDBCheckpointKeyValues rkv = getRocksKeyValuesCheckpoint(*metaData);
															#line 1070 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent("FetchCheckpointRange", metaData->checkpointID) .detail("InitialState", metaData->toString()) .detail("RocksCheckpointKeyValues", rkv.toString()) .detail("FilePath", localFile);
															#line 1075 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			for( const auto& file : rkv.fetchedFiles ) {
															#line 1076 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				ASSERT(!file.range.intersects(range));
															#line 4076 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
															#line 1079 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT(!metaData->src.empty());
															#line 1080 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ssID = metaData->src.front();
															#line 1081 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			tr = Transaction(cx);
															#line 1082 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ssi = StorageServerInterface();
															#line 1083 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			;
															#line 4088 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointRangeActorState();
		static_cast<FetchCheckpointRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		ASSERT(ssi.id() == ssID);
															#line 1103 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		attempt = 0;
															#line 1104 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		totalBytes = 0;
															#line 1105 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		totalKeys = 0;
															#line 1106 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		status = rocksdb::Status();
															#line 1107 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		error = Optional<Error>();
															#line 1108 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 4123 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1084 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1085 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4141 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		try {
															#line 1087 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(serverListKeyFor(ssID));
															#line 1087 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4147 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 1;
															#line 1087 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >*>(static_cast<FetchCheckpointRangeActor*>(this)));
															#line 4152 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1097 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1097 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4189 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 2;
															#line 1097 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangeActor, 1, Void >*>(static_cast<FetchCheckpointRangeActor*>(this)));
															#line 4194 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ss,int loopDepth) 
	{
															#line 1088 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!ss.present())
															#line 4209 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1089 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "FetchCheckpointRangeStorageServerNotFound", metaData->checkpointID) .detail("SSID", ssID) .detail("InitialState", metaData->toString());
															#line 1092 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1loopBody1Catch1(checkpoint_not_found(), loopDepth);
															#line 4215 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 1094 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		ssi = decodeServerListValue(ss.get());
															#line 4219 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ss,int loopDepth) 
	{
															#line 1088 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!ss.present())
															#line 4228 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1089 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "FetchCheckpointRangeStorageServerNotFound", metaData->checkpointID) .detail("SSID", ssID) .detail("InitialState", metaData->toString());
															#line 1092 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1loopBody1Catch1(checkpoint_not_found(), loopDepth);
															#line 4234 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 1094 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		ssi = decodeServerListValue(ss.get());
															#line 4238 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ss,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ss, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ss,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ss), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangeActor*>(this)->ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangeActor*>(this)->ActorCallback< FetchCheckpointRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1215 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (error.present())
															#line 4409 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1216 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1Catch1(error.get(), loopDepth);
															#line 4413 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 1219 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchCheckpointRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointRangeActorState(); static_cast<FetchCheckpointRangeActor*>(this)->destroy(); return 0; }
															#line 4417 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchCheckpointRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointRangeActorState();
		static_cast<FetchCheckpointRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1109 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		totalBytes = 0;
															#line 1110 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		totalKeys = 0;
															#line 1111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		++attempt;
															#line 4440 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		try {
															#line 1113 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevInfo, "FetchCheckpointRangeBegin", metaData->checkpointID) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt) .log();
															#line 1121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(localFile, true);
															#line 1121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4448 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 3;
															#line 1121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangeActor, 2, Void >*>(static_cast<FetchCheckpointRangeActor*>(this)));
															#line 4453 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			Error err = e;
															#line 1165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (totalBytes > 0)
															#line 4490 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				status = writer->Finish();
															#line 1167 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (!status.ok())
															#line 4496 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1168 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					err = statusToError(status);
															#line 4500 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
			}
															#line 1171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (err.code() != error_code_end_of_stream)
															#line 4505 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1172 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				TraceEvent(SevWarn, "FetchCheckpointRangeError", metaData->checkpointID) .errorUnsuppressed(err) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt);
															#line 1179 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (attempt >= maxRetries)
															#line 4511 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					error = err;
															#line 4515 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
			else
			{
															#line 1184 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				RocksDBCheckpointKeyValues rcp = getRocksKeyValuesCheckpoint(*metaData);
															#line 1185 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (totalBytes > 0)
															#line 4525 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1186 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					rcp.fetchedFiles.emplace_back(localFile, range, totalBytes);
															#line 4529 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
				else
				{
															#line 1188 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					rcp.fetchedFiles.emplace_back(emptySstFilePath, range, totalBytes);
															#line 4535 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
															#line 1190 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				metaData->setSerializedCheckpoint(ObjectWriter::toValue(rcp, IncludeVersion()));
															#line 1191 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (!fileExists(localFile))
															#line 4541 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1192 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					TraceEvent(SevWarn, "FetchCheckpointRangeEndFileNotFound", metaData->checkpointID) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt) .detail("TotalKeys", totalKeys) .detail("TotalBytes", totalBytes);
															#line 4545 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
				else
				{
															#line 1201 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					TraceEvent(SevInfo, "FetchCheckpointRangeEnd", metaData->checkpointID) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt) .detail("TotalKeys", totalKeys) .detail("TotalBytes", totalBytes);
															#line 4551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		status = writer->Open(localFile);
															#line 1123 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!status.ok())
															#line 4571 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			Error e = statusToError(status);
															#line 1125 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevError, "FetchCheckpointRangeOpenFileError", metaData->checkpointID) .detail("LocalFile", localFile) .detail("Status", status.ToString());
															#line 1128 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 4579 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 1131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		stream = ssi.fetchCheckpointKeyValues.getReplyStream( FetchCheckpointKeyValuesRequest(metaData->checkpointID, range));
															#line 1134 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointKeyValuesReceivingData", metaData->checkpointID) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt) .log();
															#line 1142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 4587 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		status = writer->Open(localFile);
															#line 1123 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!status.ok())
															#line 4598 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			Error e = statusToError(status);
															#line 1125 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevError, "FetchCheckpointRangeOpenFileError", metaData->checkpointID) .detail("LocalFile", localFile) .detail("Status", status.ToString());
															#line 1128 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 4606 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
															#line 1131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		stream = ssi.fetchCheckpointKeyValues.getReplyStream( FetchCheckpointKeyValuesRequest(metaData->checkpointID, range));
															#line 1134 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointKeyValuesReceivingData", metaData->checkpointID) .detail("Range", range) .detail("CheckpointID", metaData->checkpointID) .detail("TargetStorageServerUID", ssID) .detail("LocalFile", localFile) .detail("Attempt", attempt) .log();
															#line 1142 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		;
															#line 4614 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangeActor*>(this)->ActorCallback< FetchCheckpointRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 1143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		auto __when_expr_3 = stream.getFuture();
															#line 4705 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<FetchCheckpointKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<FetchCheckpointKeyValuesStreamReply>>::value, "invalid type");
															#line 1143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4709 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1when1(__when_expr_3.pop(), loopDepth); };
		static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 4;
															#line 1143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >*>(static_cast<FetchCheckpointRangeActor*>(this)));
															#line 4714 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(FetchCheckpointKeyValuesStreamReply const& rep,int loopDepth) 
	{
															#line 1144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		for(int i = 0;i < rep.data.size();++i) {
															#line 1145 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			DEBUG_MUTATION("FetchCheckpointData", metaData->version, MutationRef(MutationRef::SetValue, rep.data[i].key, rep.data[i].value), metaData->checkpointID);
															#line 1149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			status = writer->Put(toSlice(rep.data[i].key), toSlice(rep.data[i].value));
															#line 1150 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (!status.ok())
															#line 4729 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1151 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				Error e = statusToError(status);
															#line 1152 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				TraceEvent(SevError, "FetchCheckpointRangeWriteError", metaData->checkpointID) .detail("LocalFile", localFile) .detail("Key", rep.data[i].key) .detail("Value", rep.data[i].value) .detail("Status", status.ToString());
															#line 1157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 4737 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
															#line 1159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			totalBytes += rep.data[i].expectedSize();
															#line 1160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			++totalKeys;
															#line 4743 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(FetchCheckpointKeyValuesStreamReply && rep,int loopDepth) 
	{
															#line 1144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		for(int i = 0;i < rep.data.size();++i) {
															#line 1145 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			DEBUG_MUTATION("FetchCheckpointData", metaData->version, MutationRef(MutationRef::SetValue, rep.data[i].key, rep.data[i].value), metaData->checkpointID);
															#line 1149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			status = writer->Put(toSlice(rep.data[i].key), toSlice(rep.data[i].value));
															#line 1150 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (!status.ok())
															#line 4759 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1151 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				Error e = statusToError(status);
															#line 1152 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				TraceEvent(SevError, "FetchCheckpointRangeWriteError", metaData->checkpointID) .detail("LocalFile", localFile) .detail("Key", rep.data[i].key) .detail("Value", rep.data[i].value) .detail("Status", status.ToString());
															#line 1157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 4767 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
															#line 1159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			totalBytes += rep.data[i].expectedSize();
															#line 1160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			++totalKeys;
															#line 4773 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(FetchCheckpointKeyValuesStreamReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(FetchCheckpointKeyValuesStreamReply && rep,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangeActor*>(this)->ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >*,FetchCheckpointKeyValuesStreamReply const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >*,FetchCheckpointKeyValuesStreamReply && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<CheckpointMetaData> metaData;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	KeyRange range;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<rocksdb::SstFileWriter> writer;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int maxRetries;
															#line 1067 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string localFile;
															#line 1080 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	UID ssID;
															#line 1081 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Transaction tr;
															#line 1082 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	StorageServerInterface ssi;
															#line 1103 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int attempt;
															#line 1104 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int64_t totalBytes;
															#line 1105 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int64_t totalKeys;
															#line 1106 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	rocksdb::Status status;
															#line 1107 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Optional<Error> error;
															#line 1131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	ReplyPromiseStream<FetchCheckpointKeyValuesStreamReply> stream;
															#line 4888 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpointRange()
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointRangeActor final : public Actor<Void>, public ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >, public ActorCallback< FetchCheckpointRangeActor, 1, Void >, public ActorCallback< FetchCheckpointRangeActor, 2, Void >, public ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >, public FastAllocated<FetchCheckpointRangeActor>, public FetchCheckpointRangeActorState<FetchCheckpointRangeActor> {
															#line 4893 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointRangeActor>::operator new;
	using FastAllocated<FetchCheckpointRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1225235998370664448UL, 18343938270607474432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< FetchCheckpointRangeActor, 1, Void >;
friend struct ActorCallback< FetchCheckpointRangeActor, 2, Void >;
friend struct ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >;
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointRangeActor(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,KeyRange const& range,std::string const& dir,std::shared_ptr<rocksdb::SstFileWriter> const& writer,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun,int const& maxRetries = 3) 
															#line 4913 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FetchCheckpointRangeActorState<FetchCheckpointRangeActor>(cx, metaData, range, dir, writer, cFun, maxRetries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8634423398599794944UL, 13051869693580783616UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchCheckpointRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< FetchCheckpointRangeActor, 3, FetchCheckpointKeyValuesStreamReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointRange( Database const& cx, std::shared_ptr<CheckpointMetaData> const& metaData, KeyRange const& range, std::string const& dir, std::shared_ptr<rocksdb::SstFileWriter> const& writer, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun, int const& maxRetries = 3 ) {
															#line 1060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new FetchCheckpointRangeActor(cx, metaData, range, dir, writer, cFun, maxRetries));
															#line 4948 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1221 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

															#line 4953 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
// This generated class is to be used only via fetchCheckpointRanges()
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchCheckpointRangesActor>
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointRangesActorState {
															#line 4959 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointRangesActorState(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   metaData(metaData),
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun)
															#line 4972 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointRangesActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1226 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			RocksDBCheckpointKeyValues rkv = getRocksKeyValuesCheckpoint(*metaData);
															#line 1227 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent("FetchCheckpointRanges") .detail("InitialState", metaData->toString()) .detail("RocksCheckpointKeyValues", rkv.toString());
															#line 1231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			KeyRangeMap<CheckpointFile> fileMap;
															#line 1232 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			for( const auto& file : rkv.fetchedFiles ) {
															#line 1233 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				fileMap.insert(file.range, file);
															#line 4995 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			}
															#line 1236 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			std::vector<Future<Void>> fs;
															#line 1237 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			for( const auto& range : rkv.ranges ) {
															#line 1238 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				auto ranges = fileMap.intersectingRanges(range);
															#line 1239 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 1240 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					CheckpointFile& file = r->value();
															#line 1241 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					KeyRangeRef currentRange = range & r->range();
															#line 1242 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (!file.isValid())
															#line 5011 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					{
															#line 1243 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						std::shared_ptr<rocksdb::SstFileWriter> writer = std::make_shared<rocksdb::SstFileWriter>(rocksdb::EnvOptions(), rocksdb::Options());
															#line 1245 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						fs.push_back(fetchCheckpointRange(cx, metaData, currentRange, dir, writer, cFun));
															#line 5017 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					}
				}
			}
															#line 1249 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 1249 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5025 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 1;
															#line 1249 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangesActor, 0, Void >*>(static_cast<FetchCheckpointRangesActor*>(this)));
															#line 5030 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointRangesActorState();
		static_cast<FetchCheckpointRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 5053 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5059 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 2;
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangesActor, 1, Void >*>(static_cast<FetchCheckpointRangesActor*>(this)));
															#line 5064 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (cFun)
															#line 5078 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cFun(*metaData);
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5084 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 2;
															#line 1251 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangesActor, 1, Void >*>(static_cast<FetchCheckpointRangesActor*>(this)));
															#line 5089 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangesActor*>(this)->ActorCallback< FetchCheckpointRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1254 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchCheckpointRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointRangesActorState(); static_cast<FetchCheckpointRangesActor*>(this)->destroy(); return 0; }
															#line 5178 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchCheckpointRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointRangesActorState();
		static_cast<FetchCheckpointRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangesActor*>(this)->ActorCallback< FetchCheckpointRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<CheckpointMetaData> metaData;
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 5281 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpointRanges()
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchCheckpointRangesActor final : public Actor<Void>, public ActorCallback< FetchCheckpointRangesActor, 0, Void >, public ActorCallback< FetchCheckpointRangesActor, 1, Void >, public FastAllocated<FetchCheckpointRangesActor>, public FetchCheckpointRangesActorState<FetchCheckpointRangesActor> {
															#line 5286 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointRangesActor>::operator new;
	using FastAllocated<FetchCheckpointRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18059686639353334784UL, 217673961853552384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointRangesActor, 0, Void >;
friend struct ActorCallback< FetchCheckpointRangesActor, 1, Void >;
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchCheckpointRangesActor(Database const& cx,std::shared_ptr<CheckpointMetaData> const& metaData,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 5304 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FetchCheckpointRangesActorState<FetchCheckpointRangesActor>(cx, metaData, dir, cFun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12796336108807475200UL, 12433676179912681984UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointRanges( Database const& cx, std::shared_ptr<CheckpointMetaData> const& metaData, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun ) {
															#line 1222 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new FetchCheckpointRangesActor(cx, metaData, dir, cFun));
															#line 5337 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1256 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
} // namespace

															#line 5343 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchRocksDBCheckpoint()
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchRocksDBCheckpointActor>
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchRocksDBCheckpointActorState {
															#line 5350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchRocksDBCheckpointActorState(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   initialState(initialState),
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun)
															#line 5363 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~FetchRocksDBCheckpointActorState() 
	{
		fdb_probe_actor_destroy("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1262 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevInfo, "FetchRocksCheckpointBegin") .detail("InitialState", initialState.toString()) .detail("CheckpointDir", dir);
															#line 1266 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			ASSERT(!initialState.ranges.empty());
															#line 1268 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			metaData = std::make_shared<CheckpointMetaData>(initialState);
															#line 1269 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			futures = std::vector<Future<Void>>();
															#line 1271 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (metaData->getFormat() == DataMoveRocksCF)
															#line 5386 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1272 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				rocksCF = getRocksCF(initialState);
															#line 1273 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				TraceEvent(SevDebug, "RocksDBCheckpointMetaData").detail("RocksCF", rocksCF.toString());
															#line 1275 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				i = 0;
															#line 1276 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				for(;i < rocksCF.sstFiles.size();++i) {
															#line 1277 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					futures.push_back(fetchCheckpointFile(cx, metaData, i, dir, cFun));
															#line 1278 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					TraceEvent(SevDebug, "GetCheckpointFetchingFile") .detail("FileName", rocksCF.sstFiles[i].name) .detail("Server", describe(metaData->src));
															#line 5400 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
															#line 1282 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (metaData->bytesSampleFile.present())
															#line 5404 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1283 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					futures.push_back(fetchCheckpointBytesSampleFile(cx, metaData, dir, cFun));
															#line 5408 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
															#line 1285 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 1285 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state = 1;
															#line 1285 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchRocksDBCheckpointActor, 0, Void >*>(static_cast<FetchRocksDBCheckpointActor*>(this)));
															#line 5419 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1286 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (metaData->getFormat() == RocksDBKeyValues)
															#line 5426 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1287 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					futures.push_back(fetchCheckpointRanges(cx, metaData, dir, cFun));
															#line 1288 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (metaData->bytesSampleFile.present())
															#line 5432 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					{
															#line 1289 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						futures.push_back(fetchCheckpointBytesSampleFile(cx, metaData, dir, cFun));
															#line 5436 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					}
															#line 1291 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 1291 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5442 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state = 2;
															#line 1291 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchRocksDBCheckpointActor, 1, Void >*>(static_cast<FetchRocksDBCheckpointActor*>(this)));
															#line 5447 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1292 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (metaData->getFormat() == RocksDB)
															#line 5454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					{
															#line 1293 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						return a_body1Catch1(not_implemented(), loopDepth);
															#line 5458 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					}
					loopDepth = a_body1cont5(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchRocksDBCheckpointActorState();
		static_cast<FetchRocksDBCheckpointActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1296 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchRocksDBCheckpointActor*>(this)->SAV<CheckpointMetaData>::futures) { (void)(*metaData); this->~FetchRocksDBCheckpointActorState(); static_cast<FetchRocksDBCheckpointActor*>(this)->destroy(); return 0; }
															#line 5484 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchRocksDBCheckpointActor*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(*metaData);
		this->~FetchRocksDBCheckpointActorState();
		static_cast<FetchRocksDBCheckpointActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state > 0) static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state = 0;
		static_cast<FetchRocksDBCheckpointActor*>(this)->ActorCallback< FetchRocksDBCheckpointActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchRocksDBCheckpointActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state > 0) static_cast<FetchRocksDBCheckpointActor*>(this)->actor_wait_state = 0;
		static_cast<FetchRocksDBCheckpointActor*>(this)->ActorCallback< FetchRocksDBCheckpointActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchRocksDBCheckpointActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	CheckpointMetaData initialState;
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 1268 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::shared_ptr<CheckpointMetaData> metaData;
															#line 1269 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 1272 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	RocksDBColumnFamilyCheckpoint rocksCF;
															#line 1275 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	int i;
															#line 5688 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchRocksDBCheckpoint()
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchRocksDBCheckpointActor final : public Actor<CheckpointMetaData>, public ActorCallback< FetchRocksDBCheckpointActor, 0, Void >, public ActorCallback< FetchRocksDBCheckpointActor, 1, Void >, public FastAllocated<FetchRocksDBCheckpointActor>, public FetchRocksDBCheckpointActorState<FetchRocksDBCheckpointActor> {
															#line 5693 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchRocksDBCheckpointActor>::operator new;
	using FastAllocated<FetchRocksDBCheckpointActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5003482531367213568UL, 8836197991614567168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<CheckpointMetaData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchRocksDBCheckpointActor, 0, Void >;
friend struct ActorCallback< FetchRocksDBCheckpointActor, 1, Void >;
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchRocksDBCheckpointActor(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 5711 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<CheckpointMetaData>(),
		   FetchRocksDBCheckpointActorState<FetchRocksDBCheckpointActor>(cx, initialState, dir, cFun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6361414164501952512UL, 3684212670942404352UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchRocksDBCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchRocksDBCheckpointActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchRocksDBCheckpointActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<CheckpointMetaData> fetchRocksDBCheckpoint( Database const& cx, CheckpointMetaData const& initialState, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun ) {
															#line 1258 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<CheckpointMetaData>(new FetchRocksDBCheckpointActor(cx, initialState, dir, cFun));
															#line 5745 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1298 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

															#line 5750 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteRocksCheckpoint()
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class DeleteRocksCheckpointActor>
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DeleteRocksCheckpointActorState {
															#line 5757 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DeleteRocksCheckpointActorState(CheckpointMetaData const& checkpoint) 
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : checkpoint(checkpoint)
															#line 5764 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~DeleteRocksCheckpointActorState() 
	{
		fdb_probe_actor_destroy("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1300 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			TraceEvent(SevInfo, "DeleteRocksCheckpointBegin", checkpoint.checkpointID) .detail("Checkpoint", checkpoint.toString());
															#line 1302 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (checkpoint.getState() == CheckpointMetaData::Fail)
															#line 5781 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1303 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (!static_cast<DeleteRocksCheckpointActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteRocksCheckpointActorState(); static_cast<DeleteRocksCheckpointActor*>(this)->destroy(); return 0; }
															#line 5785 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				new (&static_cast<DeleteRocksCheckpointActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteRocksCheckpointActorState();
				static_cast<DeleteRocksCheckpointActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1306 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			format = checkpoint.getFormat();
															#line 1307 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			dirs = std::unordered_set<std::string>();
															#line 1308 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (format == DataMoveRocksCF)
															#line 5797 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			{
															#line 1309 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
															#line 1310 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				TraceEvent(SevInfo, "DeleteRocksColumnFamilyCheckpoint", checkpoint.checkpointID) .detail("CheckpointID", checkpoint.checkpointID) .detail("RocksCF", rocksCF.toString());
															#line 1314 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				for( const LiveFileMetaData& file : rocksCF.sstFiles ) {
															#line 1315 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					dirs.insert(file.db_path);
															#line 5807 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
			}
			else
			{
															#line 1317 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
				if (format == RocksDB)
															#line 5814 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				{
															#line 1318 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					RocksDBCheckpoint rocksCheckpoint = getRocksCheckpoint(checkpoint);
															#line 1319 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					TraceEvent(SevInfo, "DeleteRocksCheckpoint", checkpoint.checkpointID) .detail("CheckpointID", checkpoint.checkpointID) .detail("RocksCheckpoint", rocksCheckpoint.toString());
															#line 1322 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					dirs.insert(rocksCheckpoint.checkpointDir);
															#line 5822 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
				}
				else
				{
															#line 1323 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
					if (format == RocksDBKeyValues)
															#line 5828 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					{
															#line 1324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						RocksDBCheckpointKeyValues rocksKv = getRocksKeyValuesCheckpoint(checkpoint);
															#line 1325 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						TraceEvent(SevInfo, "DeleteRocksKeyValuesCheckpoint", checkpoint.checkpointID) .detail("CheckpointID", checkpoint.checkpointID) .detail("RocksCF", rocksKv.toString());
															#line 1329 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						for( const CheckpointFile& file : rocksKv.fetchedFiles ) {
															#line 1330 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
							if (file.path != emptySstFilePath)
															#line 5838 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
							{
															#line 1331 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
								dirs.insert(file.path);
															#line 5842 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
							}
						}
					}
					else
					{
															#line 1335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
						ASSERT(false);
															#line 5850 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
					}
				}
			}
															#line 1338 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			it = dirs.begin();
															#line 1339 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			;
															#line 5858 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteRocksCheckpointActorState();
		static_cast<DeleteRocksCheckpointActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DeleteRocksCheckpointActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteRocksCheckpointActorState(); static_cast<DeleteRocksCheckpointActor*>(this)->destroy(); return 0; }
															#line 5881 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DeleteRocksCheckpointActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteRocksCheckpointActorState();
		static_cast<DeleteRocksCheckpointActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1339 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!(it != dirs.end()))
															#line 5900 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		const std::string dir = *it;
															#line 1341 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		platform::eraseDirectoryRecursive(dir);
															#line 1342 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		TraceEvent(SevInfo, "DeleteCheckpointRemovedDir", checkpoint.checkpointID) .detail("CheckpointID", checkpoint.checkpointID) .detail("Dir", dir);
															#line 1345 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::FetchKeys);
															#line 1345 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (static_cast<DeleteRocksCheckpointActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5914 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DeleteRocksCheckpointActor*>(this)->actor_wait_state = 1;
															#line 1345 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteRocksCheckpointActor, 0, Void >*>(static_cast<DeleteRocksCheckpointActor*>(this)));
															#line 5919 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1339 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		++it;
															#line 5941 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1339 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		++it;
															#line 5950 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteRocksCheckpointActor*>(this)->actor_wait_state > 0) static_cast<DeleteRocksCheckpointActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteRocksCheckpointActor*>(this)->ActorCallback< DeleteRocksCheckpointActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteRocksCheckpointActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteRocksCheckpointActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteRocksCheckpointActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	CheckpointMetaData checkpoint;
															#line 1306 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	CheckpointFormat format;
															#line 1307 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::unordered_set<std::string> dirs;
															#line 1338 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::unordered_set<std::string>::iterator it;
															#line 6038 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via deleteRocksCheckpoint()
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DeleteRocksCheckpointActor final : public Actor<Void>, public ActorCallback< DeleteRocksCheckpointActor, 0, Void >, public FastAllocated<DeleteRocksCheckpointActor>, public DeleteRocksCheckpointActorState<DeleteRocksCheckpointActor> {
															#line 6043 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<DeleteRocksCheckpointActor>::operator new;
	using FastAllocated<DeleteRocksCheckpointActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15859839639643584256UL, 2561762070526859776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteRocksCheckpointActor, 0, Void >;
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DeleteRocksCheckpointActor(CheckpointMetaData const& checkpoint) 
															#line 6060 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteRocksCheckpointActorState<DeleteRocksCheckpointActor>(checkpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2771154367210585856UL, 6255588299204401664UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteRocksCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteRocksCheckpointActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> deleteRocksCheckpoint( CheckpointMetaData const& checkpoint ) {
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new DeleteRocksCheckpointActor(checkpoint));
															#line 6093 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
#else
															#line 6098 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchRocksDBCheckpoint()
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class FetchRocksDBCheckpointActor1>
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchRocksDBCheckpointActor1State {
															#line 6105 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchRocksDBCheckpointActor1State(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : cx(cx),
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   initialState(initialState),
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   dir(dir),
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		   cFun(cFun)
															#line 6118 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~FetchRocksDBCheckpointActor1State() 
	{
		fdb_probe_actor_destroy("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1355 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 1355 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<FetchRocksDBCheckpointActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6135 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchRocksDBCheckpointActor1*>(this)->actor_wait_state = 1;
															#line 1355 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >*>(static_cast<FetchRocksDBCheckpointActor1*>(this)));
															#line 6140 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchRocksDBCheckpointActor1State();
		static_cast<FetchRocksDBCheckpointActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1356 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchRocksDBCheckpointActor1*>(this)->SAV<CheckpointMetaData>::futures) { (void)(initialState); this->~FetchRocksDBCheckpointActor1State(); static_cast<FetchRocksDBCheckpointActor1*>(this)->destroy(); return 0; }
															#line 6163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchRocksDBCheckpointActor1*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(std::move(initialState)); // state_var_RVO
		this->~FetchRocksDBCheckpointActor1State();
		static_cast<FetchRocksDBCheckpointActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1356 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<FetchRocksDBCheckpointActor1*>(this)->SAV<CheckpointMetaData>::futures) { (void)(initialState); this->~FetchRocksDBCheckpointActor1State(); static_cast<FetchRocksDBCheckpointActor1*>(this)->destroy(); return 0; }
															#line 6175 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<FetchRocksDBCheckpointActor1*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(std::move(initialState)); // state_var_RVO
		this->~FetchRocksDBCheckpointActor1State();
		static_cast<FetchRocksDBCheckpointActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchRocksDBCheckpointActor1*>(this)->actor_wait_state > 0) static_cast<FetchRocksDBCheckpointActor1*>(this)->actor_wait_state = 0;
		static_cast<FetchRocksDBCheckpointActor1*>(this)->ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	Database cx;
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	CheckpointMetaData initialState;
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::string dir;
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 6266 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via fetchRocksDBCheckpoint()
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class FetchRocksDBCheckpointActor1 final : public Actor<CheckpointMetaData>, public ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >, public FastAllocated<FetchRocksDBCheckpointActor1>, public FetchRocksDBCheckpointActor1State<FetchRocksDBCheckpointActor1> {
															#line 6271 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<FetchRocksDBCheckpointActor1>::operator new;
	using FastAllocated<FetchRocksDBCheckpointActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5003482531367213568UL, 8836197991614567168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<CheckpointMetaData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >;
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	FetchRocksDBCheckpointActor1(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 6288 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<CheckpointMetaData>(),
		   FetchRocksDBCheckpointActor1State<FetchRocksDBCheckpointActor1>(cx, initialState, dir, cFun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17986764281083193600UL, 4833274434599877120UL);
		ActorExecutionContextHelper __helper(static_cast<FetchRocksDBCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchRocksDBCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchRocksDBCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchRocksDBCheckpointActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<CheckpointMetaData> fetchRocksDBCheckpoint( Database const& cx, CheckpointMetaData const& initialState, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun ) {
															#line 1351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<CheckpointMetaData>(new FetchRocksDBCheckpointActor1(cx, initialState, dir, cFun));
															#line 6321 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1358 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"

															#line 6326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteRocksCheckpoint()
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
template <class DeleteRocksCheckpointActor1>
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DeleteRocksCheckpointActor1State {
															#line 6333 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DeleteRocksCheckpointActor1State(CheckpointMetaData const& checkpoint) 
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		 : checkpoint(checkpoint)
															#line 6340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~DeleteRocksCheckpointActor1State() 
	{
		fdb_probe_actor_destroy("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1360 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 1360 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			if (static_cast<DeleteRocksCheckpointActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6357 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteRocksCheckpointActor1*>(this)->actor_wait_state = 1;
															#line 1360 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteRocksCheckpointActor1, 0, Void >*>(static_cast<DeleteRocksCheckpointActor1*>(this)));
															#line 6362 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteRocksCheckpointActor1State();
		static_cast<DeleteRocksCheckpointActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1361 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DeleteRocksCheckpointActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteRocksCheckpointActor1State(); static_cast<DeleteRocksCheckpointActor1*>(this)->destroy(); return 0; }
															#line 6385 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DeleteRocksCheckpointActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteRocksCheckpointActor1State();
		static_cast<DeleteRocksCheckpointActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1361 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
		if (!static_cast<DeleteRocksCheckpointActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteRocksCheckpointActor1State(); static_cast<DeleteRocksCheckpointActor1*>(this)->destroy(); return 0; }
															#line 6397 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		new (&static_cast<DeleteRocksCheckpointActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteRocksCheckpointActor1State();
		static_cast<DeleteRocksCheckpointActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteRocksCheckpointActor1*>(this)->actor_wait_state > 0) static_cast<DeleteRocksCheckpointActor1*>(this)->actor_wait_state = 0;
		static_cast<DeleteRocksCheckpointActor1*>(this)->ActorCallback< DeleteRocksCheckpointActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteRocksCheckpointActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteRocksCheckpointActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteRocksCheckpointActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	CheckpointMetaData checkpoint;
															#line 6482 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
};
// This generated class is to be used only via deleteRocksCheckpoint()
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
class DeleteRocksCheckpointActor1 final : public Actor<Void>, public ActorCallback< DeleteRocksCheckpointActor1, 0, Void >, public FastAllocated<DeleteRocksCheckpointActor1>, public DeleteRocksCheckpointActor1State<DeleteRocksCheckpointActor1> {
															#line 6487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
public:
	using FastAllocated<DeleteRocksCheckpointActor1>::operator new;
	using FastAllocated<DeleteRocksCheckpointActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15859839639643584256UL, 2561762070526859776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteRocksCheckpointActor1, 0, Void >;
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	DeleteRocksCheckpointActor1(CheckpointMetaData const& checkpoint) 
															#line 6504 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteRocksCheckpointActor1State<DeleteRocksCheckpointActor1>(checkpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(172254810622401536UL, 264982691904115200UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteRocksCheckpointActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteRocksCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteRocksCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteRocksCheckpointActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
[[nodiscard]] Future<Void> deleteRocksCheckpoint( CheckpointMetaData const& checkpoint ) {
															#line 1359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
	return Future<Void>(new DeleteRocksCheckpointActor1(checkpoint));
															#line 6537 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBCheckpointUtils.actor.g.cpp"
}

#line 1363 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbserver/RocksDBCheckpointUtils.actor.cpp"
#endif // WITH_ROCKSDB

int64_t getTotalFetchedBytes(const std::vector<CheckpointMetaData>& checkpoints) {
	int64_t totalBytes = 0;
	for (const auto& checkpoint : checkpoints) {
		const CheckpointFormat format = checkpoint.getFormat();
		if (format == DataMoveRocksCF) {
			const RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
			for (const auto& file : rocksCF.sstFiles) {
				totalBytes += file.size;
			}
		} else if (format == RocksDB) {
			auto rcp = getRocksCheckpoint(checkpoint);
			for (const auto& file : rcp.fetchedFiles) {
				totalBytes += file.size;
			}
		} else if (format == RocksDBKeyValues) {
			const RocksDBCheckpointKeyValues rkv = getRocksKeyValuesCheckpoint(checkpoint);
			for (const auto& file : rkv.fetchedFiles) {
				totalBytes += file.size;
			}
		}
	}
	return totalBytes;
}

ICheckpointReader* newRocksDBCheckpointReader(const CheckpointMetaData& checkpoint,
                                              const CheckpointAsKeyValues checkpointAsKeyValues,
                                              UID logId) {
#ifdef WITH_ROCKSDB
	const CheckpointFormat format = checkpoint.getFormat();
	if (format == DataMoveRocksCF && !checkpointAsKeyValues) {
		return new RocksDBCFCheckpointReader(checkpoint, logId);
	} else {
		return new RocksDBColumnFamilyReader(checkpoint, logId);
	}
#endif // WITH_ROCKSDB
	return nullptr;
}

std::unique_ptr<IRocksDBSstFileWriter> newRocksDBSstFileWriter() {
#ifdef WITH_ROCKSDB
	std::unique_ptr<IRocksDBSstFileWriter> sstWriter = std::make_unique<RocksDBSstFileWriter>();
	return sstWriter;
#endif // WITH_ROCKSDB
	return nullptr;
}

std::unique_ptr<IRocksDBSstFileReader> newRocksDBSstFileReader() {
#ifdef WITH_ROCKSDB
	std::unique_ptr<IRocksDBSstFileReader> sstReader = std::make_unique<RocksDBSstFileReader>();
	return sstReader;
#endif // WITH_ROCKSDB
	return nullptr;
}

std::unique_ptr<IRocksDBSstFileReader> newRocksDBSstFileReader(const KeyRange& range,
                                                               size_t rowLimit,
                                                               size_t byteLimit) {
#ifdef WITH_ROCKSDB
	std::unique_ptr<IRocksDBSstFileReader> sstReader =
	    std::make_unique<RocksDBSstFileReader>(range, rowLimit, byteLimit);
	return sstReader;
#endif // WITH_ROCKSDB
	return nullptr;
}

std::unique_ptr<ICheckpointByteSampleReader> newCheckpointByteSampleReader(const CheckpointMetaData& checkpoint) {
#ifdef WITH_ROCKSDB
	return std::make_unique<RocksDBCheckpointByteSampleReader>(checkpoint);
#endif // WITH_ROCKSDB
	return nullptr;
}

RocksDBColumnFamilyCheckpoint getRocksCF(const CheckpointMetaData& checkpoint) {
	RocksDBColumnFamilyCheckpoint rocksCF;
	ObjectReader reader(checkpoint.getSerializedCheckpoint().begin(), IncludeVersion());
	reader.deserialize(rocksCF);
	return rocksCF;
}

RocksDBCheckpoint getRocksCheckpoint(const CheckpointMetaData& checkpoint) {
	RocksDBCheckpoint rocksCheckpoint;
	ObjectReader reader(checkpoint.getSerializedCheckpoint().begin(), IncludeVersion());
	reader.deserialize(rocksCheckpoint);
	return rocksCheckpoint;
}

RocksDBCheckpointKeyValues getRocksKeyValuesCheckpoint(const CheckpointMetaData& checkpoint) {
	RocksDBCheckpointKeyValues rocksCheckpoint;
	ObjectReader reader(checkpoint.getSerializedCheckpoint().begin(), IncludeVersion());
	reader.deserialize(rocksCheckpoint);
	return rocksCheckpoint;
}