#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
/*
 * DebugCommands.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fmt/core.h>

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

std::string toHex(StringRef v) {
	std::string result;
	result.reserve(v.size() * 4);
	for (int i = 0; i < v.size(); i++) {
		result.append(format("\\x%02x", v[i]));
	}
	return result;
}

// Gets a version at which to read from the storage servers
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via getVersion()
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class GetVersionActor>
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetVersionActorState {
															#line 50 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetVersionActorState(Database const& cx) 
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx)
															#line 57 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			;
															#line 72 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		tr = Transaction(cx);
															#line 45 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 104 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		try {
															#line 47 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 47 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Version >*>(static_cast<GetVersionActor*>(this)));
															#line 115 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 50 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 139 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 144 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 44 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Transaction tr;
															#line 345 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via getVersion()
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetVersionActor final : public Actor<Version>, public ActorCallback< GetVersionActor, 0, Version >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18298887760274267648UL, 14222207579269618432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Version >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetVersionActor(Database const& cx) 
															#line 368 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<Version>(),
		   GetVersionActorState<GetVersionActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<Version> getVersion( Database const& cx ) {
															#line 42 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<Version>(new GetVersionActor(cx));
															#line 401 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 54 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"

// Get a list of storage servers that persist keys within range "kr" from the
// first commit proxy. Returns false if there is a failure (in this case,
// keyServersPromise will never be set).
// If dcid is set, only return the storage servers in the given datacenter.
// Ignore the input dcid if the cluster has not set dcid.
															#line 411 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via getKeyServers()
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class GetKeyServersActor>
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetKeyServersActorState {
															#line 417 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetKeyServersActorState(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,Optional<StringRef> const& dcid) 
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx),
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   keyServersPromise(keyServersPromise),
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   kr(kr),
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   dcid(dcid),
															#line 65 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   keyServers(),
															#line 68 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   keyServerLocationFuture(),
															#line 69 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   begin(kr.begin),
															#line 70 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   end(kr.end),
															#line 71 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   limitKeyServers(100)
															#line 440 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyServersActorState() 
	{
		fdb_probe_actor_destroy("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			;
															#line 455 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		keyServersPromise.send(keyServers);
															#line 115 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 480 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 73 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!(begin < end))
															#line 499 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 74 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Reference<CommitProxyInfo>> __when_expr_0 = cx->getCommitProxiesFuture(UseProvisionalProxies::False);
															#line 74 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 507 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*>(static_cast<GetKeyServersActor*>(this)));
															#line 512 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 76 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		keyServerLocationFuture = commitProxyInfo->get(0, &CommitProxyInterface::getKeyServersLocations) .getReplyUnlessFailedFor( GetKeyServerLocationsRequest({}, {}, begin, end, limitKeyServers, false, latestVersion, Arena()), 2, 0);
															#line 83 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		keyServersInsertedForThisIteration = false;
															#line 85 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<ErrorOr<GetKeyServerLocationsReply>> __when_expr_1 = keyServerLocationFuture;
															#line 84 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 540 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 107 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Void> __when_expr_2 = cx->onProxiesChanged();
															#line 544 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 2;
															#line 85 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >*>(static_cast<GetKeyServersActor*>(this)));
															#line 107 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 2, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 551 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> const& __commitProxyInfo,int loopDepth) 
	{
															#line 74 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		commitProxyInfo = __commitProxyInfo;
															#line 560 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> && __commitProxyInfo,int loopDepth) 
	{
		commitProxyInfo = std::move(__commitProxyInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 110 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!keyServersInsertedForThisIteration)
															#line 639 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 645 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetKeyServersActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 3, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<GetKeyServerLocationsReply> const& shards,int loopDepth) 
	{
															#line 87 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (shards.present() && !keyServersInsertedForThisIteration)
															#line 664 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			std::vector<std::pair<KeyRangeRef, std::vector<StorageServerInterface>>> shardResultList;
															#line 89 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for( auto& result : shards.get().results ) {
															#line 90 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				std::vector<StorageServerInterface> servers;
															#line 91 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				for( auto& server : result.second ) {
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					Optional<Standalone<StringRef>> serverDcId = server.locality.dcId();
															#line 94 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					if (dcid.present() && serverDcId.present() && serverDcId.get() != dcid.get())
															#line 678 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
					{
						continue;
					}
															#line 97 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					servers.push_back(server);
															#line 684 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
															#line 99 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				shardResultList.push_back({ result.first, servers });
															#line 688 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServers.insert(keyServers.end(), shardResultList.begin(), shardResultList.end());
															#line 102 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServersInsertedForThisIteration = true;
															#line 103 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			begin = shards.get().results.back().first.end;
															#line 696 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<GetKeyServerLocationsReply> && shards,int loopDepth) 
	{
															#line 87 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (shards.present() && !keyServersInsertedForThisIteration)
															#line 707 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			std::vector<std::pair<KeyRangeRef, std::vector<StorageServerInterface>>> shardResultList;
															#line 89 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for( auto& result : shards.get().results ) {
															#line 90 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				std::vector<StorageServerInterface> servers;
															#line 91 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				for( auto& server : result.second ) {
															#line 93 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					Optional<Standalone<StringRef>> serverDcId = server.locality.dcId();
															#line 94 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					if (dcid.present() && serverDcId.present() && serverDcId.get() != dcid.get())
															#line 721 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
					{
						continue;
					}
															#line 97 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					servers.push_back(server);
															#line 727 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
															#line 99 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				shardResultList.push_back({ result.first, servers });
															#line 731 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 101 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServers.insert(keyServers.end(), shardResultList.begin(), shardResultList.end());
															#line 102 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServersInsertedForThisIteration = true;
															#line 103 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			begin = shards.get().results.back().first.end;
															#line 739 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >::remove();
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >*,ErrorOr<GetKeyServerLocationsReply> const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >*,ErrorOr<GetKeyServerLocationsReply> && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServersPromise;
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRangeRef kr;
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Optional<StringRef> dcid;
															#line 65 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 68 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Future<ErrorOr<GetKeyServerLocationsReply>> keyServerLocationFuture;
															#line 69 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Key begin;
															#line 70 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Key end;
															#line 71 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	int limitKeyServers;
															#line 74 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Reference<CommitProxyInfo> commitProxyInfo;
															#line 83 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	bool keyServersInsertedForThisIteration;
															#line 994 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via getKeyServers()
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetKeyServersActor final : public Actor<bool>, public ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >, public ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >, public ActorCallback< GetKeyServersActor, 2, Void >, public ActorCallback< GetKeyServersActor, 3, Void >, public FastAllocated<GetKeyServersActor>, public GetKeyServersActorState<GetKeyServersActor> {
															#line 999 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<GetKeyServersActor>::operator new;
	using FastAllocated<GetKeyServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18310912197108348416UL, 12906100888612706560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >;
friend struct ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >;
friend struct ActorCallback< GetKeyServersActor, 2, Void >;
friend struct ActorCallback< GetKeyServersActor, 3, Void >;
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetKeyServersActor(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,Optional<StringRef> const& dcid) 
															#line 1019 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<bool>(),
		   GetKeyServersActorState<GetKeyServersActor>(cx, keyServersPromise, kr, dcid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2154856847302521088UL, 16578737356717173248UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyServersActor, 1, ErrorOr<GetKeyServerLocationsReply> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyServersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<bool> getKeyServers( Database const& cx, Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise, KeyRangeRef const& kr, Optional<StringRef> const& dcid ) {
															#line 60 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<bool>(new GetKeyServersActor(cx, keyServersPromise, kr, dcid));
															#line 1053 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 117 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"

// The command is used to get all storage server addresses for a given key.
															#line 1059 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via getLocationCommandActor()
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class GetLocationCommandActorActor>
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetLocationCommandActorActorState {
															#line 1065 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetLocationCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx),
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   tokens(tokens)
															#line 1074 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("getLocationCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~GetLocationCommandActorActorState() 
	{
		fdb_probe_actor_destroy("getLocationCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (tokens.size() != 2 && tokens.size() != 3)
															#line 1089 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 121 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("getlocation <KEY> [<KEY2>]\n" "fetch the storage server address for a given key or range.\n" "Displays the addresses of storage servers, or `not found' if location is not found.");
															#line 124 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (!static_cast<GetLocationCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetLocationCommandActorActorState(); static_cast<GetLocationCommandActorActor*>(this)->destroy(); return 0; }
															#line 1095 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				new (&static_cast<GetLocationCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetLocationCommandActorActorState();
				static_cast<GetLocationCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 127 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			kr = KeyRangeRef(tokens[1], tokens.size() == 3 ? tokens[2] : keyAfter(tokens[1]));
															#line 129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServersPromise = Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>>();
															#line 130 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<bool> __when_expr_0 = getKeyServers(cx, keyServersPromise, kr, Optional<StringRef>());
															#line 130 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetLocationCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1109 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLocationCommandActorActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLocationCommandActorActor, 0, bool >*>(static_cast<GetLocationCommandActorActor*>(this)));
															#line 1114 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLocationCommandActorActorState();
		static_cast<GetLocationCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& found,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!found)
															#line 1137 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("{} locations not found", printable(kr));
															#line 133 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (!static_cast<GetLocationCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetLocationCommandActorActorState(); static_cast<GetLocationCommandActorActor*>(this)->destroy(); return 0; }
															#line 1143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			new (&static_cast<GetLocationCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GetLocationCommandActorActorState();
			static_cast<GetLocationCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers = keyServersPromise.getFuture().get();
															#line 137 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for( const auto& [range, servers] : keyServers ) {
															#line 138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("Key range: {}", printable(range));
															#line 139 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for( const auto& server : servers ) {
															#line 140 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("  {}", server.address().toString());
															#line 1159 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
		}
															#line 143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetLocationCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetLocationCommandActorActorState(); static_cast<GetLocationCommandActorActor*>(this)->destroy(); return 0; }
															#line 1164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetLocationCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetLocationCommandActorActorState();
		static_cast<GetLocationCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && found,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!found)
															#line 1176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("{} locations not found", printable(kr));
															#line 133 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (!static_cast<GetLocationCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetLocationCommandActorActorState(); static_cast<GetLocationCommandActorActor*>(this)->destroy(); return 0; }
															#line 1182 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			new (&static_cast<GetLocationCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GetLocationCommandActorActorState();
			static_cast<GetLocationCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers = keyServersPromise.getFuture().get();
															#line 137 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for( const auto& [range, servers] : keyServers ) {
															#line 138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("Key range: {}", printable(range));
															#line 139 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for( const auto& server : servers ) {
															#line 140 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("  {}", server.address().toString());
															#line 1198 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
		}
															#line 143 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetLocationCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetLocationCommandActorActorState(); static_cast<GetLocationCommandActorActor*>(this)->destroy(); return 0; }
															#line 1203 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetLocationCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetLocationCommandActorActorState();
		static_cast<GetLocationCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& found,int loopDepth) 
	{
		loopDepth = a_body1cont1(found, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && found,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(found), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLocationCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetLocationCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetLocationCommandActorActor*>(this)->ActorCallback< GetLocationCommandActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetLocationCommandActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLocationCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLocationCommandActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLocationCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLocationCommandActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLocationCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocationCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 127 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRange kr;
															#line 129 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServersPromise;
															#line 1294 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via getLocationCommandActor()
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetLocationCommandActorActor final : public Actor<bool>, public ActorCallback< GetLocationCommandActorActor, 0, bool >, public FastAllocated<GetLocationCommandActorActor>, public GetLocationCommandActorActorState<GetLocationCommandActorActor> {
															#line 1299 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<GetLocationCommandActorActor>::operator new;
	using FastAllocated<GetLocationCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(77977993413938688UL, 8376721332663380992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLocationCommandActorActor, 0, bool >;
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetLocationCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 1316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<bool>(),
		   GetLocationCommandActorActorState<GetLocationCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLocationCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(193391134671476736UL, 10216948944031904512UL);
		ActorExecutionContextHelper __helper(static_cast<GetLocationCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLocationCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLocationCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLocationCommandActorActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<bool> getLocationCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 119 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<bool>(new GetLocationCommandActorActor(cx, tokens));
															#line 1348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 145 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
// hidden commands, no help text for now
CommandFactory getLocationCommandFactory("getlocation");

// The command is used to get values from all storage servers that have the given key.
															#line 1356 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via getallCommandActor()
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class GetallCommandActorActor>
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetallCommandActorActorState {
															#line 1362 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetallCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens,Version const& version) 
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx),
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   tokens(tokens),
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   version(version)
															#line 1373 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("getallCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~GetallCommandActorActorState() 
	{
		fdb_probe_actor_destroy("getallCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (tokens.size() != 2)
															#line 1388 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 151 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("getall <KEY>\n" "fetch values from all storage servers that have the given key.\n" "Displays the value and the addresses of storage servers, or `not found' if key is not found.");
															#line 154 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (!static_cast<GetallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetallCommandActorActorState(); static_cast<GetallCommandActorActor*>(this)->destroy(); return 0; }
															#line 1394 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				new (&static_cast<GetallCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetallCommandActorActorState();
				static_cast<GetallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<KeyRangeLocationInfo> __when_expr_0 = getKeyLocation_internal( cx, {}, tokens[1], SpanContext(), Optional<UID>(), UseProvisionalProxies::False, Reverse::False, version);
															#line 157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetallCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1404 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetallCommandActorActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >*>(static_cast<GetallCommandActorActor*>(this)));
															#line 1409 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetallCommandActorActorState();
		static_cast<GetallCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyRangeLocationInfo const& loc,int loopDepth) 
	{
															#line 160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (loc.locations)
															#line 1432 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("version is {}", version);
															#line 162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("`{}' is at:", printable(tokens[1]));
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			locations = loc.locations->locations();
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			replies = std::vector<Future<GetValueReply>>();
															#line 165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for(int i = 0;locations && i < locations->size();i++) {
															#line 166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				GetValueRequest req({}, {}, tokens[1], version, {}, {}, {});
															#line 167 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				replies.push_back(locations->get(i, &StorageServerInterface::getValue).getReply(req));
															#line 1448 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(replies);
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetallCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetallCommandActorActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetallCommandActorActor, 1, Void >*>(static_cast<GetallCommandActorActor*>(this)));
															#line 1459 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("`{}': location not found", printable(tokens[1]));
															#line 1466 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(KeyRangeLocationInfo && loc,int loopDepth) 
	{
															#line 160 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (loc.locations)
															#line 1476 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("version is {}", version);
															#line 162 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("`{}' is at:", printable(tokens[1]));
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			locations = loc.locations->locations();
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			replies = std::vector<Future<GetValueReply>>();
															#line 165 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			for(int i = 0;locations && i < locations->size();i++) {
															#line 166 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				GetValueRequest req({}, {}, tokens[1], version, {}, {}, {});
															#line 167 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				replies.push_back(locations->get(i, &StorageServerInterface::getValue).getReply(req));
															#line 1492 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(replies);
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<GetallCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetallCommandActorActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetallCommandActorActor, 1, Void >*>(static_cast<GetallCommandActorActor*>(this)));
															#line 1503 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 180 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("`{}': location not found", printable(tokens[1]));
															#line 1510 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(KeyRangeLocationInfo const& loc,int loopDepth) 
	{
		loopDepth = a_body1cont1(loc, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyRangeLocationInfo && loc,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(loc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetallCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetallCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetallCommandActorActor*>(this)->ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 182 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<GetallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetallCommandActorActorState(); static_cast<GetallCommandActorActor*>(this)->destroy(); return 0; }
															#line 1595 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<GetallCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetallCommandActorActorState();
		static_cast<GetallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for(int i = 0;i < replies.size();i++) {
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			std::string ssi = locations->getInterface(i).address().toString();
															#line 172 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (replies[i].isError())
															#line 1611 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 173 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println(stderr, "ERROR: {} {}", ssi, replies[i].getError().what());
															#line 1615 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
			else
			{
															#line 175 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				Optional<Value> v = replies[i].get().value;
															#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println(" {} {}", ssi, v.present() ? printable(v.get()) : "(not found)");
															#line 1623 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for(int i = 0;i < replies.size();i++) {
															#line 171 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			std::string ssi = locations->getInterface(i).address().toString();
															#line 172 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (replies[i].isError())
															#line 1638 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 173 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println(stderr, "ERROR: {} {}", ssi, replies[i].getError().what());
															#line 1642 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
			else
			{
															#line 175 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				Optional<Value> v = replies[i].get().value;
															#line 176 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println(" {} {}", ssi, v.present() ? printable(v.get()) : "(not found)");
															#line 1650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetallCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetallCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetallCommandActorActor*>(this)->ActorCallback< GetallCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetallCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetallCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetallCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Version version;
															#line 163 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Reference<LocationInfo::Locations> locations;
															#line 164 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<Future<GetValueReply>> replies;
															#line 1742 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via getallCommandActor()
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class GetallCommandActorActor final : public Actor<bool>, public ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >, public ActorCallback< GetallCommandActorActor, 1, Void >, public FastAllocated<GetallCommandActorActor>, public GetallCommandActorActorState<GetallCommandActorActor> {
															#line 1747 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<GetallCommandActorActor>::operator new;
	using FastAllocated<GetallCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4514157755557054208UL, 12967943037135572480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >;
friend struct ActorCallback< GetallCommandActorActor, 1, Void >;
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	GetallCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens,Version const& version) 
															#line 1765 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<bool>(),
		   GetallCommandActorActorState<GetallCommandActorActor>(cx, tokens, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getallCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17713017440982812160UL, 5414946743768733696UL);
		ActorExecutionContextHelper __helper(static_cast<GetallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getallCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getallCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetallCommandActorActor, 0, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetallCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<bool> getallCommandActor( Database const& cx, std::vector<StringRef> const& tokens, Version const& version ) {
															#line 149 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<bool>(new GetallCommandActorActor(cx, tokens, version));
															#line 1798 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 184 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
// hidden commands, no help text for now
CommandFactory getallCommandFactory("getall");

std::string printStorageServerMachineInfo(const StorageServerInterface& server) {
	std::string serverIp = server.address().toString();
	std::string serverLocality = server.locality.toString();
	return serverLocality + " " + serverIp;
}

std::string printAllStorageServerMachineInfo(const std::vector<StorageServerInterface>& servers) {
	std::string res;
	for (int i = 0; i < servers.size(); i++) {
		if (i == 0) {
			res = printStorageServerMachineInfo(servers[i]);
		} else {
			res = res + "; " + printStorageServerMachineInfo(servers[i]);
		}
	}
	return res;
}

// check that all replies are the same. Update begin to the next key to check
// checkResults keeps invariants:
// (1) hasMore = true if any server has more data not read yet
// (2) nextBeginKey is the minimal key returned from all servers
// (3) checkResults reports inconsistency of keys only before the nextBeginKey if hasMore=true
// Therefore, whether to proceed to the next round depends on hasMore
// If there is a next round, it starts from the minimal key returned from all servers
bool checkResults(Version version,
                  bool hasMore,
                  Key claimEndKey,
                  const std::vector<StorageServerInterface>& servers,
                  const std::vector<GetKeyValuesReply>& replies) {
	// Compare servers
	bool allSame = true;
	int firstValidServer = -1;
	for (int j = 0; j < replies.size(); j++) {
		if (firstValidServer == -1) {
			firstValidServer = j;
			// Print full list of comparing servers and the reference server
			// Used to check server info which does not produce an inconsistency log
			fmt::println("CheckResult: servers: {}, reference server: {}",
			             printAllStorageServerMachineInfo(servers),
			             printStorageServerMachineInfo(servers[firstValidServer]));
			continue; // always select the first server as reference
		}
		// compare reference and current
		GetKeyValuesReply current = replies[j];
		GetKeyValuesReply reference = replies[firstValidServer];
		if (current.data == reference.data && current.more == reference.more) {
			continue;
		}
		// Detecting corrupted keys for any mismatching replies between current and reference servers
		allSame = false;
		size_t currentI = 0, referenceI = 0;
		while (currentI < current.data.size() || referenceI < reference.data.size()) {
			if (hasMore && ((referenceI < reference.data.size() && reference.data[referenceI].key >= claimEndKey) ||
			                (currentI < current.data.size() && current.data[currentI].key >= claimEndKey))) {
				// If there will be a next round and the key is out of claimEndKey
				// We will delay the detection to the next round
				break;
			}
			if (currentI >= current.data.size()) {
				// ServerA(1), ServerB(0): 1 indicates that ServerA has the key while 0 indicates that ServerB does not
				// have the key
				fmt::println(
				    "Inconsistency: UniqueKey, {}(1), {}(0), CurrentIndex {}, ReferenceIndex {}, Version {}, Key {}",
				    printStorageServerMachineInfo(servers[firstValidServer]),
				    printStorageServerMachineInfo(servers[j]),
				    currentI,
				    referenceI,
				    version,
				    toHex(reference.data[referenceI].key));
				referenceI++;
			} else if (referenceI >= reference.data.size()) {
				fmt::println(
				    "Inconsistency: UniqueKey, {}(1), {}(0), CurrentIndex {}, ReferenceIndex {}, Version {}, Key {}",
				    printStorageServerMachineInfo(servers[j]),
				    printStorageServerMachineInfo(servers[firstValidServer]),
				    currentI,
				    referenceI,
				    version,
				    toHex(current.data[currentI].key));
				currentI++;
			} else {
				KeyValueRef currentKV = current.data[currentI];
				KeyValueRef referenceKV = reference.data[referenceI];
				if (currentKV.key == referenceKV.key) {
					if (currentKV.value != referenceKV.value) {
						fmt::println("Inconsistency: MismatchValue, {}(1), {}(1), CurrentIndex {}, ReferenceIndex {}, "
						             "Version {}, Key {}",
						             printStorageServerMachineInfo(servers[firstValidServer]),
						             printStorageServerMachineInfo(servers[j]),
						             currentI,
						             referenceI,
						             version,
						             toHex(currentKV.key));
					}
					currentI++;
					referenceI++;
				} else if (currentKV.key < referenceKV.key) {
					fmt::println(
					    "Inconsistency: UniqueKey, {}(1), {}(0), CurrentIndex {}, ReferenceIndex {}, Version {}, "
					    "Key {}",
					    printStorageServerMachineInfo(servers[j]),
					    printStorageServerMachineInfo(servers[firstValidServer]),
					    currentI,
					    referenceI,
					    version,
					    toHex(currentKV.key));
					currentI++;
				} else {
					fmt::println(
					    "Inconsistency: UniqueKey, {}(1), {}(0), CurrentIndex {}, ReferenceIndex {}, Version {}, "
					    "Key {}",
					    printStorageServerMachineInfo(servers[firstValidServer]),
					    printStorageServerMachineInfo(servers[j]),
					    currentI,
					    referenceI,
					    version,
					    toHex(referenceKV.key));
					referenceI++;
				}
			}
		}
	}

	return allSame;
}

															#line 1932 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
[[nodiscard]] Future<bool> doCheckAll( Database const& cx, KeyRange const& inputRange, Optional<StringRef> const& dcid, bool const& checkAll );

#line 315 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
// Return whether inconsistency is detected in the inputRange
															#line 1937 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via doCheckAll()
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class DoCheckAllActor>
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class DoCheckAllActorState {
															#line 1943 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	DoCheckAllActorState(Database const& cx,KeyRange const& inputRange,Optional<StringRef> const& dcid,bool const& checkAll) 
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx),
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   inputRange(inputRange),
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   dcid(dcid),
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   checkAll(checkAll),
															#line 317 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   onErrorTr(cx),
															#line 318 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   consistent(true)
															#line 1960 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("doCheckAll", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckAllActorState() 
	{
		fdb_probe_actor_destroy("doCheckAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			;
															#line 1975 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckAllActorState();
		static_cast<DoCheckAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 450 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<DoCheckAllActor*>(this)->SAV<bool>::futures) { (void)(consistent); this->~DoCheckAllActorState(); static_cast<DoCheckAllActor*>(this)->destroy(); return 0; }
															#line 1998 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<DoCheckAllActor*>(this)->SAV< bool >::value()) bool(std::move(consistent)); // state_var_RVO
		this->~DoCheckAllActorState();
		static_cast<DoCheckAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 321 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("Start checking for range: {}", printable(inputRange));
															#line 323 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			keyServerPromise = Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>>();
															#line 324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<bool> __when_expr_0 = getKeyServers(cx, keyServerPromise, inputRange, dcid);
															#line 324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2024 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoCheckAllActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 0, bool >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2029 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(1.0);
															#line 448 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2059 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<DoCheckAllActor*>(this)->actor_wait_state = 7;
															#line 448 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 6, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2064 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 444 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::print("Error: {}", e.what());
															#line 445 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_5 = onErrorTr.onError(e);
															#line 445 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2078 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoCheckAllActor*>(this)->actor_wait_state = 6;
															#line 445 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 5, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2083 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& foundKeyServers,int loopDepth) 
	{
															#line 325 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!foundKeyServers)
															#line 2098 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("key server locations for {} not found, retrying in 1s...", printable(inputRange));
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2106 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckAllActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 1, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2111 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && foundKeyServers,int loopDepth) 
	{
															#line 325 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!foundKeyServers)
															#line 2125 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("key server locations for {} not found, retrying in 1s...", printable(inputRange));
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2133 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckAllActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 1, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2138 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& foundKeyServers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(foundKeyServers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && foundKeyServers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(foundKeyServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 330 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		keyServers = keyServerPromise.getFuture().get();
															#line 334 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		i = 0;
															#line 335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		;
															#line 2231 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!(i < keyServers.size()))
															#line 2340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 336 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		rangeToCheck = keyServers[i].first;
															#line 337 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		rangeToCheck = rangeToCheck & inputRange;
															#line 338 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (rangeToCheck.empty())
															#line 2350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
			return a_body1loopBody1cont3continue1(loopDepth); // continue
		}
															#line 341 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		const auto& servers = keyServers[i].second;
															#line 342 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		beginKeyToCheck = rangeToCheck.begin;
															#line 343 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Key range to check: {}", printable(rangeToCheck));
															#line 344 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for( const auto& server : servers ) {
															#line 345 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			fmt::println("\t{}", server.address().toString());
															#line 2364 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		}
															#line 347 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		replies = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		hasMore = true;
															#line 349 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		round = 0;
															#line 350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		version = Version();
															#line 351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		;
															#line 2376 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3continue1(int loopDepth) 
	{
															#line 335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		i++;
															#line 2398 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 335 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		i++;
															#line 2407 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1(int loopDepth) 
	{
															#line 351 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!(hasMore))
															#line 2423 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
			return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 352 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(version, getVersion(cx));
															#line 352 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2431 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoCheckAllActor*>(this)->actor_wait_state = 3;
															#line 352 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 2, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2436 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 353 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		replies.clear();
															#line 354 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Round {}: {} - {}", round, toHex(beginKeyToCheck), toHex(rangeToCheck.end));
															#line 355 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for( const auto& s : keyServers[i].second ) {
															#line 356 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			GetKeyValuesRequest req;
															#line 357 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.begin = firstGreaterOrEqual(beginKeyToCheck);
															#line 358 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.end = firstGreaterOrEqual(rangeToCheck.end);
															#line 359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.limit = CLIENT_KNOBS->KRM_GET_RANGE_LIMIT;
															#line 360 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.limitBytes = CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES;
															#line 361 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.version = version;
															#line 362 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.tags = TagSet();
															#line 363 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			replies.push_back(s.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 2478 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		}
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2484 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoCheckAllActor*>(this)->actor_wait_state = 4;
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 3, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 353 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		replies.clear();
															#line 354 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Round {}: {} - {}", round, toHex(beginKeyToCheck), toHex(rangeToCheck.end));
															#line 355 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for( const auto& s : keyServers[i].second ) {
															#line 356 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			GetKeyValuesRequest req;
															#line 357 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.begin = firstGreaterOrEqual(beginKeyToCheck);
															#line 358 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.end = firstGreaterOrEqual(rangeToCheck.end);
															#line 359 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.limit = CLIENT_KNOBS->KRM_GET_RANGE_LIMIT;
															#line 360 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.limitBytes = CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES;
															#line 361 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.version = version;
															#line 362 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			req.tags = TagSet();
															#line 363 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			replies.push_back(s.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 2518 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		}
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2524 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoCheckAllActor*>(this)->actor_wait_state = 4;
															#line 365 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 3, Void >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2529 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		Key claimEndKey;
															#line 369 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		Key maxEndKey;
															#line 370 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		hasMore = false;
															#line 371 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for(int j = 0;j < replies.size();j++) {
															#line 372 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			auto reply = replies[j].get();
															#line 373 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (reply.isError())
															#line 2623 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 374 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("checkResults error: {}", reply.getError().what());
															#line 375 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				return a_body1loopBody1Catch1(reply.getError(), std::max(0, loopDepth - 2));
															#line 2629 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
			else
			{
															#line 376 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (reply.get().error.present())
															#line 2635 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				{
															#line 377 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					fmt::println("checkResults error: {}", reply.get().error.get().what());
															#line 378 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					return a_body1loopBody1Catch1(reply.get().error.get(), std::max(0, loopDepth - 2));
															#line 2641 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
			}
															#line 380 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			GetKeyValuesReply current = reply.get();
															#line 381 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (current.data.size() == 0)
															#line 2648 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
				continue;
			}
															#line 384 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (claimEndKey.empty() || current.data[current.data.size() - 1].key < claimEndKey)
															#line 2654 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 385 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				claimEndKey = current.data[current.data.size() - 1].key;
															#line 2658 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 387 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (maxEndKey.empty() || current.data[current.data.size() - 1].key > maxEndKey)
															#line 2662 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 388 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				maxEndKey = current.data[current.data.size() - 1].key;
															#line 2666 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 390 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			hasMore = hasMore || current.more;
															#line 2670 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		}
															#line 392 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Compare scope has been decided\n\tBeginKey: {}\n\tEndKey: {}\n\tHasMore: {}", toHex(beginKeyToCheck), toHex(claimEndKey), hasMore);
															#line 396 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (claimEndKey.empty())
															#line 2676 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 400 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			ASSERT(hasMore == false);
															#line 2680 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 402 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if ((beginKeyToCheck == claimEndKey) && hasMore)
															#line 2687 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 412 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				spawnedRangeToCheck = Standalone(KeyRangeRef(beginKeyToCheck, maxEndKey));
															#line 413 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("Spawn new checkall for range {}", printable(spawnedRangeToCheck));
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				StrictFuture<bool> __when_expr_4 = doCheckAll(cx, spawnedRangeToCheck, dcid, checkAll);
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2697 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoCheckAllActor*>(this)->actor_wait_state = 5;
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 4, bool >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2702 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 418 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				std::vector<GetKeyValuesReply> keyValueReplies;
															#line 419 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				for(int j = 0;j < replies.size();j++) {
															#line 420 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					auto reply = replies[j].get();
															#line 421 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					ASSERT(reply.present() && !reply.get().error.present());
															#line 422 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					keyValueReplies.push_back(reply.get());
															#line 2717 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
															#line 425 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				bool allSame = checkResults(version, hasMore, claimEndKey, keyServers[i].second, keyValueReplies);
															#line 430 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("Result: compared {} - {}", toHex(beginKeyToCheck), toHex(claimEndKey));
															#line 431 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				beginKeyToCheck = claimEndKey;
															#line 432 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("allSame {}, hasMore {}, checkAll {}", allSame, hasMore, checkAll);
															#line 433 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				consistent = consistent && allSame;
															#line 2729 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		Key claimEndKey;
															#line 369 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		Key maxEndKey;
															#line 370 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		hasMore = false;
															#line 371 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		for(int j = 0;j < replies.size();j++) {
															#line 372 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			auto reply = replies[j].get();
															#line 373 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (reply.isError())
															#line 2750 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 374 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("checkResults error: {}", reply.getError().what());
															#line 375 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				return a_body1loopBody1Catch1(reply.getError(), std::max(0, loopDepth - 2));
															#line 2756 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
			else
			{
															#line 376 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (reply.get().error.present())
															#line 2762 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				{
															#line 377 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					fmt::println("checkResults error: {}", reply.get().error.get().what());
															#line 378 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					return a_body1loopBody1Catch1(reply.get().error.get(), std::max(0, loopDepth - 2));
															#line 2768 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
			}
															#line 380 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			GetKeyValuesReply current = reply.get();
															#line 381 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (current.data.size() == 0)
															#line 2775 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
				continue;
			}
															#line 384 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (claimEndKey.empty() || current.data[current.data.size() - 1].key < claimEndKey)
															#line 2781 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 385 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				claimEndKey = current.data[current.data.size() - 1].key;
															#line 2785 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 387 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (maxEndKey.empty() || current.data[current.data.size() - 1].key > maxEndKey)
															#line 2789 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 388 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				maxEndKey = current.data[current.data.size() - 1].key;
															#line 2793 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
															#line 390 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			hasMore = hasMore || current.more;
															#line 2797 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		}
															#line 392 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Compare scope has been decided\n\tBeginKey: {}\n\tEndKey: {}\n\tHasMore: {}", toHex(beginKeyToCheck), toHex(claimEndKey), hasMore);
															#line 396 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (claimEndKey.empty())
															#line 2803 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 400 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			ASSERT(hasMore == false);
															#line 2807 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 402 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if ((beginKeyToCheck == claimEndKey) && hasMore)
															#line 2814 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 412 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				spawnedRangeToCheck = Standalone(KeyRangeRef(beginKeyToCheck, maxEndKey));
															#line 413 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("Spawn new checkall for range {}", printable(spawnedRangeToCheck));
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				StrictFuture<bool> __when_expr_4 = doCheckAll(cx, spawnedRangeToCheck, dcid, checkAll);
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (static_cast<DoCheckAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2824 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoCheckAllActor*>(this)->actor_wait_state = 5;
															#line 414 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoCheckAllActor, 4, bool >*>(static_cast<DoCheckAllActor*>(this)));
															#line 2829 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 418 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				std::vector<GetKeyValuesReply> keyValueReplies;
															#line 419 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				for(int j = 0;j < replies.size();j++) {
															#line 420 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					auto reply = replies[j].get();
															#line 421 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					ASSERT(reply.present() && !reply.get().error.present());
															#line 422 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					keyValueReplies.push_back(reply.get());
															#line 2844 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
															#line 425 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				bool allSame = checkResults(version, hasMore, claimEndKey, keyServers[i].second, keyValueReplies);
															#line 430 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("Result: compared {} - {}", toHex(beginKeyToCheck), toHex(claimEndKey));
															#line 431 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				beginKeyToCheck = claimEndKey;
															#line 432 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("allSame {}, hasMore {}, checkAll {}", allSame, hasMore, checkAll);
															#line 433 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				consistent = consistent && allSame;
															#line 2856 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 435 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!consistent && !checkAll)
															#line 2942 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		{
															#line 436 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (!static_cast<DoCheckAllActor*>(this)->SAV<bool>::futures) { (void)(false); this->~DoCheckAllActorState(); static_cast<DoCheckAllActor*>(this)->destroy(); return 0; }
															#line 2946 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			new (&static_cast<DoCheckAllActor*>(this)->SAV< bool >::value()) bool(false);
			this->~DoCheckAllActorState();
			static_cast<DoCheckAllActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 438 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		round++;
															#line 2954 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont15(bool const& allSame,int loopDepth) 
	{
															#line 415 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		beginKeyToCheck = spawnedRangeToCheck.end;
															#line 416 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		consistent = consistent && allSame;
															#line 2971 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont15(bool && allSame,int loopDepth) 
	{
															#line 415 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		beginKeyToCheck = spawnedRangeToCheck.end;
															#line 416 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		consistent = consistent && allSame;
															#line 2982 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont3when1(bool const& allSame,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont15(allSame, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont3when1(bool && allSame,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont15(std::move(allSame), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 446 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println(", retrying in 1s...");
															#line 3066 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 446 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println(", retrying in 1s...");
															#line 3075 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoCheckAllActor*>(this)->actor_wait_state > 0) static_cast<DoCheckAllActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckAllActor*>(this)->ActorCallback< DoCheckAllActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoCheckAllActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoCheckAllActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRange inputRange;
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Optional<StringRef> dcid;
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	bool checkAll;
															#line 317 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Transaction onErrorTr;
															#line 318 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	bool consistent;
															#line 323 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 330 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 334 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	int i;
															#line 336 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRange rangeToCheck;
															#line 342 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Key beginKeyToCheck;
															#line 347 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> replies;
															#line 348 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	bool hasMore;
															#line 349 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	int round;
															#line 350 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Version version;
															#line 412 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRange spawnedRangeToCheck;
															#line 3274 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via doCheckAll()
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class DoCheckAllActor final : public Actor<bool>, public ActorCallback< DoCheckAllActor, 0, bool >, public ActorCallback< DoCheckAllActor, 1, Void >, public ActorCallback< DoCheckAllActor, 2, Void >, public ActorCallback< DoCheckAllActor, 3, Void >, public ActorCallback< DoCheckAllActor, 4, bool >, public ActorCallback< DoCheckAllActor, 5, Void >, public ActorCallback< DoCheckAllActor, 6, Void >, public FastAllocated<DoCheckAllActor>, public DoCheckAllActorState<DoCheckAllActor> {
															#line 3279 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<DoCheckAllActor>::operator new;
	using FastAllocated<DoCheckAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3536285786750305536UL, 13270922254290978816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckAllActor, 0, bool >;
friend struct ActorCallback< DoCheckAllActor, 1, Void >;
friend struct ActorCallback< DoCheckAllActor, 2, Void >;
friend struct ActorCallback< DoCheckAllActor, 3, Void >;
friend struct ActorCallback< DoCheckAllActor, 4, bool >;
friend struct ActorCallback< DoCheckAllActor, 5, Void >;
friend struct ActorCallback< DoCheckAllActor, 6, Void >;
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	DoCheckAllActor(Database const& cx,KeyRange const& inputRange,Optional<StringRef> const& dcid,bool const& checkAll) 
															#line 3302 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<bool>(),
		   DoCheckAllActorState<DoCheckAllActor>(cx, inputRange, dcid, checkAll),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1823196480599694848UL, 18107422674712228096UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckAllActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckAllActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckAllActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoCheckAllActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoCheckAllActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoCheckAllActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoCheckAllActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<bool> doCheckAll( Database const& cx, KeyRange const& inputRange, Optional<StringRef> const& dcid, bool const& checkAll ) {
															#line 316 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<bool>(new DoCheckAllActor(cx, inputRange, dcid, checkAll));
															#line 3340 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 452 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"

// The command is used to check the data inconsistency of the user input range
															#line 3346 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
// This generated class is to be used only via checkallCommandActor()
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
template <class CheckallCommandActorActor>
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class CheckallCommandActorActorState {
															#line 3352 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	CheckallCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		 : cx(cx),
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   tokens(tokens),
															#line 455 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   checkAll(false),
															#line 456 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   dcid(),
															#line 457 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		   inputRange()
															#line 3367 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("checkallCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~CheckallCommandActorActorState() 
	{
		fdb_probe_actor_destroy("checkallCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 458 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (tokens.size() == 3)
															#line 3382 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				inputRange = KeyRangeRef(tokens[1], tokens[2]);
															#line 3386 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			}
			else
			{
															#line 460 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (tokens.size() == 4 && tokens[3] == "all"_sr)
															#line 3392 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				{
															#line 461 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					inputRange = KeyRangeRef(tokens[1], tokens[2]);
															#line 462 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					checkAll = true;
															#line 3398 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				}
				else
				{
															#line 463 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
					if (tokens.size() == 4 && tokens[3] != "all"_sr)
															#line 3404 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
					{
															#line 464 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
						inputRange = KeyRangeRef(tokens[1], tokens[2]);
															#line 465 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
						dcid = tokens[3];
															#line 3410 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
					}
					else
					{
															#line 466 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
						if (tokens.size() == 5 && tokens[4] == "all"_sr)
															#line 3416 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
						{
															#line 467 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
							inputRange = KeyRangeRef(tokens[1], tokens[2]);
															#line 468 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
							checkAll = true;
															#line 469 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
							dcid = tokens[3];
															#line 3424 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
						}
						else
						{
															#line 471 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
							fmt::println( "checkall [<KEY> <KEY2>] <DCID> (all)\n" "Check inconsistency of the input range by comparing all replicas and print any corruptions.\n" "The default behavior is to stop on the first subrange where corruption is found\n" "DCID is optional. If set, the tool only check storage server of the specified data center.\n" "DCID is ignored if the cluster has not set dcid.\n" "`all` is optional. When `all` is appended, the checker does not stop until all subranges have checked.\n" "Note this is intended to check a small range of keys, not the entire database (consider consistencycheck " "for that purpose).");
															#line 480 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
							if (!static_cast<CheckallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckallCommandActorActorState(); static_cast<CheckallCommandActorActor*>(this)->destroy(); return 0; }
															#line 3432 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
							new (&static_cast<CheckallCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckallCommandActorActorState();
							static_cast<CheckallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
															#line 482 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (inputRange.empty())
															#line 3443 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			{
															#line 483 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				fmt::println("Input empty range: {}.\nImmediately exit.", printable(inputRange));
															#line 484 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
				if (!static_cast<CheckallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckallCommandActorActorState(); static_cast<CheckallCommandActorActor*>(this)->destroy(); return 0; }
															#line 3449 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
				new (&static_cast<CheckallCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckallCommandActorActorState();
				static_cast<CheckallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			StrictFuture<bool> __when_expr_0 = doCheckAll(cx, inputRange, dcid, checkAll);
															#line 487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			if (static_cast<CheckallCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3459 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckallCommandActorActor*>(this)->actor_wait_state = 1;
															#line 487 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckallCommandActorActor, 0, bool >*>(static_cast<CheckallCommandActorActor*>(this)));
															#line 3464 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckallCommandActorActorState();
		static_cast<CheckallCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& res,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Checking complete. AllSame: {}", res);
															#line 489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<CheckallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckallCommandActorActorState(); static_cast<CheckallCommandActorActor*>(this)->destroy(); return 0; }
															#line 3489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<CheckallCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckallCommandActorActorState();
		static_cast<CheckallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && res,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		fmt::println("Checking complete. AllSame: {}", res);
															#line 489 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
		if (!static_cast<CheckallCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckallCommandActorActorState(); static_cast<CheckallCommandActorActor*>(this)->destroy(); return 0; }
															#line 3503 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		new (&static_cast<CheckallCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckallCommandActorActorState();
		static_cast<CheckallCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckallCommandActorActor*>(this)->actor_wait_state > 0) static_cast<CheckallCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<CheckallCommandActorActor*>(this)->ActorCallback< CheckallCommandActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckallCommandActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckallCommandActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckallCommandActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkallCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Database cx;
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 455 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	bool checkAll;
															#line 456 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	Optional<StringRef> dcid;
															#line 457 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	KeyRange inputRange;
															#line 3596 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
};
// This generated class is to be used only via checkallCommandActor()
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
class CheckallCommandActorActor final : public Actor<bool>, public ActorCallback< CheckallCommandActorActor, 0, bool >, public FastAllocated<CheckallCommandActorActor>, public CheckallCommandActorActorState<CheckallCommandActorActor> {
															#line 3601 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
public:
	using FastAllocated<CheckallCommandActorActor>::operator new;
	using FastAllocated<CheckallCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14784747884627373312UL, 10043723862593438720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckallCommandActorActor, 0, bool >;
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	CheckallCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 3618 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
		 : Actor<bool>(),
		   CheckallCommandActorActorState<CheckallCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkallCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(713352621146314752UL, 5838028017010071296UL);
		ActorExecutionContextHelper __helper(static_cast<CheckallCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkallCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkallCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckallCommandActorActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
[[nodiscard]] Future<bool> checkallCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 454 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"
	return Future<bool>(new CheckallCommandActorActor(cx, tokens));
															#line 3650 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/build_output/fdbcli/DebugCommands.actor.g.cpp"
}

#line 491 "/codebuild/output/src3055837791/src/github.com/apple/foundationdb/fdbcli/DebugCommands.actor.cpp"

CommandFactory checkallCommandFactory("checkall");
} // namespace fdb_cli
