#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
/*
 * GetTenant.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_GETTENANT_ACTOR_G_H)
#define METACLUSTER_GETTENANT_ACTOR_G_H
#include "metacluster/GetTenant.actor.g.h"
#elif !defined(METACLUSTER_GETTENANT_ACTOR_H)
#define METACLUSTER_GETTENANT_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

template <class Transaction>
Future<Optional<MetaclusterTenantMapEntry>> tryGetTenantTransaction(Transaction tr, int64_t tenantId) {
	CODE_PROBE(true, "Try get tenant by ID");
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	return metadata::management::tenantMetadata().tenantMap.get(tr, tenantId);
}

															#line 47 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
// This generated class is to be used only via tryGetTenantTransaction()
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction, class TryGetTenantTransactionActor>
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class TryGetTenantTransactionActorState {
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	TryGetTenantTransactionActorState(Transaction const& tr,TenantName const& name) 
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		 : tr(tr),
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		   name(name)
															#line 62 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 47 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			CODE_PROBE(true, "Try get tenant by name");
															#line 48 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_0 = metadata::management::tenantMetadata().tenantNameIndex.get(tr, name);
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 83 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<int64_t> const& tenantId,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (tenantId.present())
															#line 111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_1 = metadata::management::tenantMetadata().tenantMap.get(tr, tenantId.get());
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 117 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 122 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 55 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(Optional<MetaclusterTenantMapEntry>()); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 129 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(Optional<MetaclusterTenantMapEntry>());
			this->~TryGetTenantTransactionActorState();
			static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<int64_t> && tenantId,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (tenantId.present())
															#line 142 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_1 = metadata::management::tenantMetadata().tenantMap.get(tr, tenantId.get());
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 148 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 153 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 55 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(Optional<MetaclusterTenantMapEntry>()); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 160 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(Optional<MetaclusterTenantMapEntry>());
			this->~TryGetTenantTransactionActorState();
			static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> const& tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> && tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantTransactionActor*>(this)->ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 248 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(entry);
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 260 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(entry);
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantTransactionActor*>(this)->ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantTransactionActor, 1, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Transaction tr;
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	TenantName name;
															#line 347 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
};
// This generated class is to be used only via tryGetTenantTransaction()
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction>
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class TryGetTenantTransactionActor final : public Actor<Optional<MetaclusterTenantMapEntry>>, public ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >, public ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<TryGetTenantTransactionActor<Transaction>>, public TryGetTenantTransactionActorState<Transaction, TryGetTenantTransactionActor<Transaction>> {
															#line 354 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
	using FastAllocated<TryGetTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<TryGetTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6472755911497181952UL, 17267107501853732608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<MetaclusterTenantMapEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >;
friend struct ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<MetaclusterTenantMapEntry> >;
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	TryGetTenantTransactionActor(Transaction const& tr,TenantName const& name) 
															#line 372 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		 : Actor<Optional<MetaclusterTenantMapEntry>>(),
		   TryGetTenantTransactionActorState<Transaction, TryGetTenantTransactionActor<Transaction>>(tr, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2632132613495744256UL, 14272688076436411392UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction>
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
[[nodiscard]] Future<Optional<MetaclusterTenantMapEntry>> tryGetTenantTransaction( Transaction const& tr, TenantName const& name ) {
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	return Future<Optional<MetaclusterTenantMapEntry>>(new TryGetTenantTransactionActor<Transaction>(tr, name));
															#line 407 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
}

#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"

															#line 412 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
// This generated class is to be used only via tryGetTenant()
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant, class TryGetTenantActor>
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class TryGetTenantActorState {
															#line 418 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	TryGetTenantActorState(Reference<DB> const& db,Tenant const& tenant) 
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		 : db(db),
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		   tenant(tenant),
															#line 61 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		   tr(db->createTransaction())
															#line 429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenant", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			;
															#line 444 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 66 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, tenant);
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<TryGetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 481 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantActor*>(this)->actor_wait_state = 1;
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<TryGetTenantActor*>(this)));
															#line 486 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 70 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<TryGetTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 510 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantActor, 1, Void >*>(static_cast<TryGetTenantActor*>(this)));
															#line 515 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<TryGetTenantActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantActorState(); static_cast<TryGetTenantActor*>(this)->destroy(); return 0; }
															#line 530 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<TryGetTenantActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(entry);
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<TryGetTenantActor*>(this)->SAV<Optional<MetaclusterTenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantActorState(); static_cast<TryGetTenantActor*>(this)->destroy(); return 0; }
															#line 542 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<TryGetTenantActor*>(this)->SAV< Optional<MetaclusterTenantMapEntry> >::value()) Optional<MetaclusterTenantMapEntry>(entry);
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantActor*>(this)->ActorCallback< TryGetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantActor*>(this)->ActorCallback< TryGetTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Reference<DB> db;
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Tenant tenant;
															#line 61 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 718 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
};
// This generated class is to be used only via tryGetTenant()
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant>
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class TryGetTenantActor final : public Actor<Optional<MetaclusterTenantMapEntry>>, public ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >, public ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >, public FastAllocated<TryGetTenantActor<DB, Tenant>>, public TryGetTenantActorState<DB, Tenant, TryGetTenantActor<DB, Tenant>> {
															#line 725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
	using FastAllocated<TryGetTenantActor<DB, Tenant>>::operator new;
	using FastAllocated<TryGetTenantActor<DB, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14760588514883040256UL, 6924732127750858496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<MetaclusterTenantMapEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >;
friend struct ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >;
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	TryGetTenantActor(Reference<DB> const& db,Tenant const& tenant) 
															#line 743 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		 : Actor<Optional<MetaclusterTenantMapEntry>>(),
		   TryGetTenantActorState<DB, Tenant, TryGetTenantActor<DB, Tenant>>(db, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10458749581686870528UL, 11957054532112398080UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant>
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
[[nodiscard]] Future<Optional<MetaclusterTenantMapEntry>> tryGetTenant( Reference<DB> const& db, Tenant const& tenant ) {
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	return Future<Optional<MetaclusterTenantMapEntry>>(new TryGetTenantActor<DB, Tenant>(db, tenant));
															#line 778 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
}

#line 74 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"

															#line 783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
// This generated class is to be used only via getTenantTransaction()
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction, class Tenant, class GetTenantTransactionActor>
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class GetTenantTransactionActorState {
															#line 789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	GetTenantTransactionActorState(Transaction const& tr,Tenant const& tenant) 
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		 : tr(tr),
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		   tenant(tenant)
															#line 798 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
	{
		fdb_probe_actor_create("getTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("getTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, tenant);
															#line 77 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<GetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 815 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantTransactionActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<GetTenantTransactionActor*>(this)));
															#line 820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!entry.present())
															#line 843 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		}
															#line 82 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<GetTenantTransactionActor*>(this)->SAV<MetaclusterTenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantTransactionActorState(); static_cast<GetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 851 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<GetTenantTransactionActor*>(this)->SAV< MetaclusterTenantMapEntry >::value()) MetaclusterTenantMapEntry(entry.get());
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!entry.present())
															#line 863 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 867 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		}
															#line 82 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<GetTenantTransactionActor*>(this)->SAV<MetaclusterTenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantTransactionActorState(); static_cast<GetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<GetTenantTransactionActor*>(this)->SAV< MetaclusterTenantMapEntry >::value()) MetaclusterTenantMapEntry(entry.get());
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<GetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantTransactionActor*>(this)->ActorCallback< GetTenantTransactionActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantTransactionActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantTransactionActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantTransactionActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Transaction tr;
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Tenant tenant;
															#line 958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
};
// This generated class is to be used only via getTenantTransaction()
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction, class Tenant>
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class GetTenantTransactionActor final : public Actor<MetaclusterTenantMapEntry>, public ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>, public GetTenantTransactionActorState<Transaction, Tenant, GetTenantTransactionActor<Transaction, Tenant>> {
															#line 965 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
	using FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>::operator new;
	using FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3524952478507325696UL, 13870899632133837568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MetaclusterTenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	GetTenantTransactionActor(Transaction const& tr,Tenant const& tenant) 
															#line 982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		 : Actor<MetaclusterTenantMapEntry>(),
		   GetTenantTransactionActorState<Transaction, Tenant, GetTenantTransactionActor<Transaction, Tenant>>(tr, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4865543640709564416UL, 2379330836080751872UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class Transaction, class Tenant>
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
[[nodiscard]] Future<MetaclusterTenantMapEntry> getTenantTransaction( Transaction const& tr, Tenant const& tenant ) {
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	return Future<MetaclusterTenantMapEntry>(new GetTenantTransactionActor<Transaction, Tenant>(tr, tenant));
															#line 1016 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
}

#line 84 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"

															#line 1021 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
// This generated class is to be used only via getTenant()
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant, class GetTenantActor>
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class GetTenantActorState {
															#line 1027 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	GetTenantActorState(Reference<DB> const& db,Tenant const& tenant) 
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		 : db(db),
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		   tenant(tenant)
															#line 1036 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
	{
		fdb_probe_actor_create("getTenant", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantActorState() 
	{
		fdb_probe_actor_destroy("getTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenant(db, tenant);
															#line 87 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1053 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<GetTenantActor*>(this)));
															#line 1058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!entry.present())
															#line 1081 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 1085 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		}
															#line 92 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<GetTenantActor*>(this)->SAV<MetaclusterTenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 1089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<GetTenantActor*>(this)->SAV< MetaclusterTenantMapEntry >::value()) MetaclusterTenantMapEntry(entry.get());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!entry.present())
															#line 1101 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		{
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 1105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		}
															#line 92 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
		if (!static_cast<GetTenantActor*>(this)->SAV<MetaclusterTenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 1109 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		new (&static_cast<GetTenantActor*>(this)->SAV< MetaclusterTenantMapEntry >::value()) MetaclusterTenantMapEntry(entry.get());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Reference<DB> db;
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	Tenant tenant;
															#line 1196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
};
// This generated class is to be used only via getTenant()
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant>
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
class GetTenantActor final : public Actor<MetaclusterTenantMapEntry>, public ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<GetTenantActor<DB, Tenant>>, public GetTenantActorState<DB, Tenant, GetTenantActor<DB, Tenant>> {
															#line 1203 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
public:
	using FastAllocated<GetTenantActor<DB, Tenant>>::operator new;
	using FastAllocated<GetTenantActor<DB, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8313556340483925760UL, 1052890551194237440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MetaclusterTenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	GetTenantActor(Reference<DB> const& db,Tenant const& tenant) 
															#line 1220 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
		 : Actor<MetaclusterTenantMapEntry>(),
		   GetTenantActorState<DB, Tenant, GetTenantActor<DB, Tenant>>(db, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5539216869899646464UL, 17063241412762073856UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
template <class DB, class Tenant>
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
[[nodiscard]] Future<MetaclusterTenantMapEntry> getTenant( Reference<DB> const& db, Tenant const& tenant ) {
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"
	return Future<MetaclusterTenantMapEntry>(new GetTenantActor<DB, Tenant>(db, tenant));
															#line 1254 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenant.actor.g.h"
}

#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenant.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif