#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
/*
 * BenchIONet2.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"

#include "flow/Platform.h"
#include "flow/TreeBenchmark.h"
#include "flow/flow.h"
#include "flow/DeterministicRandom.h"
#include "flow/network.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/IAsyncFile.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
namespace {
// This generated class is to be used only via increment()
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
template <class IncrementActor>
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
class IncrementActorState {
															#line 42 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
public:
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	IncrementActorState(TaskPriority const& priority,uint32_t* const& sum) 
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		 : priority(priority),
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		   sum(sum)
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
	{
		fdb_probe_actor_create("increment", reinterpret_cast<unsigned long>(this));

	}
	~IncrementActorState() 
	{
		fdb_probe_actor_destroy("increment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 34 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, priority);
															#line 34 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			if (static_cast<IncrementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementActor*>(this)->actor_wait_state = 1;
															#line 34 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementActor, 0, Void >*>(static_cast<IncrementActor*>(this)));
															#line 73 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		DeterministicRandom rand(1);
															#line 36 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		int randSum = 0;
															#line 37 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		for(int i = 0;i < 1e6;++i) {
															#line 38 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			randSum += rand.randomInt(0, 3);
															#line 102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		}
															#line 40 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		benchmark::DoNotOptimize(randSum);
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		++(*sum);
															#line 42 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		DeterministicRandom rand(1);
															#line 36 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		int randSum = 0;
															#line 37 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		for(int i = 0;i < 1e6;++i) {
															#line 38 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			randSum += rand.randomInt(0, 3);
															#line 128 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		}
															#line 40 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		benchmark::DoNotOptimize(randSum);
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		++(*sum);
															#line 42 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 136 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementActor*>(this)->actor_wait_state > 0) static_cast<IncrementActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActor*>(this)->ActorCallback< IncrementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	TaskPriority priority;
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	uint32_t* sum;
															#line 223 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
};
// This generated class is to be used only via increment()
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
class IncrementActor final : public Actor<Void>, public ActorCallback< IncrementActor, 0, Void >, public FastAllocated<IncrementActor>, public IncrementActorState<IncrementActor> {
															#line 228 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
public:
	using FastAllocated<IncrementActor>::operator new;
	using FastAllocated<IncrementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15132980081053281792UL, 15757878560714771456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementActor, 0, Void >;
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	IncrementActor(TaskPriority const& priority,uint32_t* const& sum) 
															#line 245 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementActorState<IncrementActor>(priority, sum),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8333160961439996160UL, 13338264904658082560UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("increment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
[[nodiscard]] static Future<Void> increment( TaskPriority const& priority, uint32_t* const& sum ) {
															#line 33 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	return Future<Void>(new IncrementActor(priority, sum));
															#line 278 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
}

#line 44 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"

static inline TaskPriority getRandomTaskPriority(DeterministicRandom& rand) {
	return static_cast<TaskPriority>(rand.randomInt(0, 100));
}

															#line 287 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
namespace {
// This generated class is to be used only via benchIONet2Actor()
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
template <class BenchIONet2ActorActor>
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
class BenchIONet2ActorActorState {
															#line 294 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
public:
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	BenchIONet2ActorActorState(benchmark::State* const& benchState) 
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		 : benchState(benchState),
															#line 50 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		   actorCount(benchState->range(0)),
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		   sum(),
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		   seed(platform::getRandomSeed()),
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		   data(new char[4096])
															#line 309 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
	{
		fdb_probe_actor_create("benchIONet2Actor", reinterpret_cast<unsigned long>(this));

	}
	~BenchIONet2ActorActorState() 
	{
		fdb_probe_actor_destroy("benchIONet2Actor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			memset(data.get(), 0, 4096);
															#line 55 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			;
															#line 326 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchIONet2ActorActorState();
		static_cast<BenchIONet2ActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		benchState->SetItemsProcessed(actorCount * static_cast<long>(benchState->iterations()));
															#line 72 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (!static_cast<BenchIONet2ActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchIONet2ActorActorState(); static_cast<BenchIONet2ActorActor*>(this)->destroy(); return 0; }
															#line 351 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		new (&static_cast<BenchIONet2ActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchIONet2ActorActorState();
		static_cast<BenchIONet2ActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 55 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 56 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		sum = 0;
															#line 57 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		futures = std::vector<Future<Void>>();
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		futures.reserve(actorCount);
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		DeterministicRandom rand(seed);
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		for(int i = 0;i < actorCount;++i) {
															#line 61 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
			futures.push_back(increment(getRandomTaskPriority(rand), &sum));
															#line 386 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		}
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( "/tmp/__test-benchmark-file__", IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 392 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >*>(static_cast<BenchIONet2ActorActor*>(this)));
															#line 397 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->write(data.get(), 4096, 0);
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 2;
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BenchIONet2ActorActor, 1, Void >*>(static_cast<BenchIONet2ActorActor*>(this)));
															#line 426 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		f = __f;
															#line 435 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state > 0) static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchIONet2ActorActor*>(this)->ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->sync();
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 516 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 3;
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BenchIONet2ActorActor, 2, Void >*>(static_cast<BenchIONet2ActorActor*>(this)));
															#line 521 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->sync();
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 532 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 3;
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BenchIONet2ActorActor, 2, Void >*>(static_cast<BenchIONet2ActorActor*>(this)));
															#line 537 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state > 0) static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchIONet2ActorActor*>(this)->ActorCallback< BenchIONet2ActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BenchIONet2ActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 630 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state > 0) static_cast<BenchIONet2ActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchIONet2ActorActor*>(this)->ActorCallback< BenchIONet2ActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BenchIONet2ActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BenchIONet2ActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	benchmark::State* benchState;
															#line 50 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	size_t actorCount;
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	uint32_t sum;
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	int seed;
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	std::unique_ptr<char[]> data;
															#line 57 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	Reference<IAsyncFile> f;
															#line 724 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
};
// This generated class is to be used only via benchIONet2Actor()
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
class BenchIONet2ActorActor final : public Actor<Void>, public ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >, public ActorCallback< BenchIONet2ActorActor, 1, Void >, public ActorCallback< BenchIONet2ActorActor, 2, Void >, public FastAllocated<BenchIONet2ActorActor>, public BenchIONet2ActorActorState<BenchIONet2ActorActor> {
															#line 729 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
public:
	using FastAllocated<BenchIONet2ActorActor>::operator new;
	using FastAllocated<BenchIONet2ActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3065352031711752960UL, 15098576953492829696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< BenchIONet2ActorActor, 1, Void >;
friend struct ActorCallback< BenchIONet2ActorActor, 2, Void >;
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	BenchIONet2ActorActor(benchmark::State* const& benchState) 
															#line 748 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
		 : Actor<Void>(),
		   BenchIONet2ActorActorState<BenchIONet2ActorActor>(benchState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("benchIONet2Actor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14360396058333962496UL, 6965049725510038016UL);
		ActorExecutionContextHelper __helper(static_cast<BenchIONet2ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchIONet2Actor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchIONet2Actor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchIONet2ActorActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BenchIONet2ActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BenchIONet2ActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
[[nodiscard]] static Future<Void> benchIONet2Actor( benchmark::State* const& benchState ) {
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"
	return Future<Void>(new BenchIONet2ActorActor(benchState));
															#line 783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/flowbench/BenchIONet2.actor.g.cpp"
}

#line 74 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/flowbench/BenchIONet2.actor.cpp"

static void bench_ionet2(benchmark::State& benchState) {
	onMainThread([&benchState] { return benchIONet2Actor(&benchState); }).blockUntilReady();
}

BENCHMARK(bench_ionet2)->Range(1, 1 << 16)->ReportAggregatesOnly(true);
