#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
/*
 * ClusterController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>
#include <map>
#include <memory>
#include <set>
#include <tuple>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/LeaderElection.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SingletonRoles.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbrpc/sim_validation.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"

#include "metacluster/MetaclusterMetrics.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 80 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via getPreviousCoordinators()
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class GetPreviousCoordinatorsActor>
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActorState {
															#line 87 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActorState(ClusterControllerData* const& self) 
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(self->db.db)
															#line 96 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~GetPreviousCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 82 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 83 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 84 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(previousCoordinatorsKey);
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 155 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 184 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
															#line 86 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 199 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && previousCoordinators,int loopDepth) 
	{
															#line 86 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 211 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previousCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previousCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via getPreviousCoordinators()
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActor final : public Actor<Optional<Value>>, public ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< GetPreviousCoordinatorsActor, 1, Void >, public FastAllocated<GetPreviousCoordinatorsActor>, public GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor> {
															#line 390 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<GetPreviousCoordinatorsActor>::operator new;
	using FastAllocated<GetPreviousCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7637395339630393088UL, 14475453432129146624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetPreviousCoordinatorsActor, 1, Void >;
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActor(ClusterControllerData* const& self) 
															#line 408 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9522256357088947712UL, 3090868322878582016UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPreviousCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getPreviousCoordinators( ClusterControllerData* const& self ) {
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Optional<Value>>(new GetPreviousCoordinatorsActor(self));
															#line 442 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 92 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

bool ClusterControllerData::processesInSameDC(const NetworkAddress& addr1, const NetworkAddress& addr2) const {
	return this->addr_locality.contains(addr1) && this->addr_locality.contains(addr2) &&
	       this->addr_locality.at(addr1).dcId().present() && this->addr_locality.at(addr2).dcId().present() &&
	       this->addr_locality.at(addr1).dcId().get() == this->addr_locality.at(addr2).dcId().get();
}

bool ClusterControllerData::transactionSystemContainsDegradedServers() {
	const ServerDBInfo& dbi = db.serverInfo->get();
	const Reference<ClusterRecoveryData> recoveryData = db.recoveryData;
	auto transactionWorkerInList = [&dbi, &recoveryData](const std::unordered_set<NetworkAddress>& serverList,
	                                                     bool skipSatellite,
	                                                     bool skipRemoteTLog,
	                                                     bool skipRemoteLogRouter) -> bool {
		for (const auto& server : serverList) {
			if (dbi.master.addresses().contains(server)) {
				return true;
			}

			// Getting the current log system config to check if any TLogs are degraded. recoveryData->logSystem has the
			// most up to date log system and we should use it whenever available.
			auto logSystemConfig = (recoveryData.isValid() && recoveryData->logSystem.isValid())
			                           ? recoveryData->logSystem->getLogSystemConfig()
			                           : dbi.logSystemConfig;
			for (const auto& logSet : logSystemConfig.tLogs) {
				if (skipSatellite && logSet.locality == tagLocalitySatellite) {
					continue;
				}

				if (!logSet.isLocal) {
					if (!skipRemoteTLog) {
						for (const auto& tlog : logSet.tLogs) {
							if (tlog.present() && tlog.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
					if (!skipRemoteLogRouter) {
						for (const auto& logRouter : logSet.logRouters) {
							if (logRouter.present() && logRouter.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
				} else {
					for (const auto& tlog : logSet.tLogs) {
						if (tlog.present() && tlog.interf().addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			if (SERVER_KNOBS->GRAY_FAILURE_ENABLE_TLOG_RECOVERY_MONITORING && recoveryData.isValid() &&
			    recoveryData->recoveryState < RecoveryState::ACCEPTING_COMMITS) {
				// During recovery, TLogs may not be able to pull data from previous generation TLogs due to gray
				// failures. In this case, we rely on the latest recruitment information and see if any newly recruited
				// TLogs are degraded.
				for (const auto& tlog : recoveryData->primaryRecruitment.tLogs) {
					if (tlog.addresses().contains(server)) {
						return true;
					}
				}

				if (!skipSatellite) {
					for (const auto& satelliteLog : recoveryData->primaryRecruitment.satelliteTLogs) {
						if (satelliteLog.addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			for (const auto& proxy : dbi.client.grvProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& proxy : dbi.client.commitProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& resolver : dbi.resolvers) {
				if (resolver.addresses().contains(server)) {
					return true;
				}
			}
		}
		return false;
	};

	// Check if transaction system contains degraded/disconnected servers. For satellite, we only
	// check for disconnection since the latency between prmary and satellite is across WAN and may not be very
	// stable.
	// TODO: Consider adding satellite latency degradation check and rely on
	//       SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY for accurate health signal
	return transactionWorkerInList(degradationInfo.degradedServers,
	                               /*skipSatellite=*/true,
	                               /*skipRemoteTLog=*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DEGRADATION_MONITORING),
	                               /*skipRemoteLogRouter*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DEGRADATION_MONITORING)) ||
	       transactionWorkerInList(
	           degradationInfo.disconnectedServers,
	           /*skipSatellite=*/false,
	           /*skipRemoteTLog=*/!SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DISCONNECT_MONITORING,
	           /*skipRemoteLogRouter*/ !SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DISCONNECT_MONITORING);
}

bool ClusterControllerData::remoteTransactionSystemContainsDegradedServers() {
	if (db.config.usableRegions <= 1) {
		return false;
	}

	for (const auto& excludedServer : degradationInfo.degradedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	for (const auto& excludedServer : degradationInfo.disconnectedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	return false;
}

															#line 580 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterWatchDatabase()
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterWatchDatabaseActor>
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActorState {
															#line 587 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 229 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   iMaster(),
															#line 230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   addActor(),
															#line 231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCore()
															#line 604 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterWatchDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 619 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterWatchDatabaseActorState();
		static_cast<ClusterWatchDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).log();
															#line 649 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		try {
															#line 239 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recoveryStart = now();
															#line 240 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newMaster = MasterInterface();
															#line 241 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			collection = Future<Void>();
															#line 243 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).detail("Recruiting", "Master");
															#line 244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = recruitNewMaster(cluster, db, std::addressof(newMaster));
															#line 244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 663 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 1;
															#line 244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 0, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 668 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 342 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			err = e;
															#line 343 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).errorUnsuppressed(e).detail("Master", iMaster.id());
															#line 344 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 694 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 345 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(0.0);
															#line 345 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 700 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 5;
															#line 345 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 8, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 705 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 248 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 249 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 251 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 252 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 254 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 255 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 256 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 257 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 260 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 263 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 264 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
															#line 266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 268 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.metaclusterName = db->metaclusterName;
															#line 270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 281 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 282 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 292 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 294 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 248 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 249 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 251 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 252 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 254 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 255 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 256 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 257 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 260 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 263 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 264 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
															#line 266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 268 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.metaclusterName = db->metaclusterName;
															#line 270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 281 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 282 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 292 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 294 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 850 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 329 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide)
															#line 934 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 330 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 938 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 333 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 334 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cleanupRecoveryActorCollection(db->recoveryData, false);
															#line 334 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 946 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 3;
															#line 334 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 6, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 951 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = recoveryCore;
															#line 298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 969 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 300 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitFailureClient( iMaster.waitFailure, db->masterRegistrationCount ? SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME : (now() - recoveryStart) * SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY, db->masterRegistrationCount ? -SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY : SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY), "CCWDBMasterFailed") || traceAfter(db->forceMasterFailure.onTrigger(), "CCWDBForceMasterFailureTriggered");
															#line 973 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 313 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = db->serverInfo->onChange();
															#line 977 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 314 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_4 = db->serverInfo->get().clusterInterface.notifyBackupWorkerDone.getFuture();
															#line 981 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<BackupWorkerDoneRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<BackupWorkerDoneRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 323 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = collection;
															#line 986 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 2;
															#line 299 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 1, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 300 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 2, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 313 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 3, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 314 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 323 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 5, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest const& req,int loopDepth) 
	{
															#line 316 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 1063 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 1067 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 319 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 320 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest && req,int loopDepth) 
	{
															#line 316 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 1084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 1088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 319 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 320 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 1096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 1105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void && _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 1113 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 1, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 2, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 3, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1420 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1425 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1438 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1443 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 340 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 1529 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 340 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 1540 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 347 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_9 = cleanupRecoveryActorCollection(db->recoveryData, true);
															#line 348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1641 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 6;
															#line 348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 9, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1646 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 350 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 1744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 351 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 1748 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 354 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 1752 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 1756 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 359 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 360 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 361 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 362 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 363 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 369 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 1774 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 371 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 1780 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 374 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 1784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 1788 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 377 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 378 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 1796 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1807 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 350 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 1818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 351 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 1822 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 354 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 1826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 1830 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 359 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 360 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 361 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 362 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 363 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 369 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 1848 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 371 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 1854 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 374 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 1862 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 377 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 378 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 1870 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1876 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1881 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 229 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface iMaster;
															#line 230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recoveryCore;
															#line 239 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double recoveryStart;
															#line 240 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface newMaster;
															#line 241 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> collection;
															#line 276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> spinDelay;
															#line 342 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Error err;
															#line 2070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterWatchDatabase()
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterWatchDatabaseActor, 0, Void >, public ActorCallback< ClusterWatchDatabaseActor, 1, Void >, public ActorCallback< ClusterWatchDatabaseActor, 2, Void >, public ActorCallback< ClusterWatchDatabaseActor, 3, Void >, public ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >, public ActorCallback< ClusterWatchDatabaseActor, 5, Void >, public ActorCallback< ClusterWatchDatabaseActor, 6, Void >, public ActorCallback< ClusterWatchDatabaseActor, 7, Void >, public ActorCallback< ClusterWatchDatabaseActor, 8, Void >, public ActorCallback< ClusterWatchDatabaseActor, 9, Void >, public ActorCallback< ClusterWatchDatabaseActor, 10, Void >, public FastAllocated<ClusterWatchDatabaseActor>, public ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor> {
															#line 2075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterWatchDatabaseActor>::operator new;
	using FastAllocated<ClusterWatchDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13629269873582334720UL, 13167704134335116288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterWatchDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 1, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 2, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 3, Void >;
friend struct ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 5, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 6, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 7, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 8, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 9, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 10, Void >;
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 2102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor>(cluster, db, coordinators),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15084720662247522304UL, 7134482422509323520UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterWatchDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterWatchDatabase( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, ServerCoordinators const& coordinators ) {
															#line 226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterWatchDatabaseActor(cluster, db, coordinators));
															#line 2141 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 384 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 2146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterGetServerInfo()
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterGetServerInfoActor>
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActorState {
															#line 2153 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActorState(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   knownServerInfoID(knownServerInfoID),
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   reply(reply)
															#line 2164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetServerInfoActorState() 
	{
		fdb_probe_actor_destroy("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 2179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 396 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		reply.send(db->serverInfo->get());
															#line 397 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterGetServerInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterGetServerInfoActorState(); static_cast<ClusterGetServerInfoActor*>(this)->destroy(); return 0; }
															#line 2204 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<ClusterGetServerInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->serverInfo->get().id == knownServerInfoID))
															#line 2223 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 390 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(db->serverInfo->onChange());
															#line 389 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 391 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(300);
															#line 2235 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 1;
															#line 390 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 0, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 391 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 1, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 2242 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 0, Void >::remove();
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID knownServerInfoID;
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReplyPromise<ServerDBInfo> reply;
															#line 2417 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterGetServerInfo()
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActor final : public Actor<Void>, public ActorCallback< ClusterGetServerInfoActor, 0, Void >, public ActorCallback< ClusterGetServerInfoActor, 1, Void >, public FastAllocated<ClusterGetServerInfoActor>, public ClusterGetServerInfoActorState<ClusterGetServerInfoActor> {
															#line 2422 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterGetServerInfoActor>::operator new;
	using FastAllocated<ClusterGetServerInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11385609546015075328UL, 14500561344775769600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterGetServerInfoActor, 0, Void >;
friend struct ActorCallback< ClusterGetServerInfoActor, 1, Void >;
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActor(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 2440 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterGetServerInfoActorState<ClusterGetServerInfoActor>(db, knownServerInfoID, reply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8722247202050210304UL, 18223546808676413184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterGetServerInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterGetServerInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterGetServerInfo( ClusterControllerData::DBInfo* const& db, UID const& knownServerInfoID, ReplyPromise<ServerDBInfo> const& reply ) {
															#line 385 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterGetServerInfoActor(db, knownServerInfoID, reply));
															#line 2473 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 399 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 2478 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterOpenDatabase()
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterOpenDatabaseActor>
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActorState {
															#line 2485 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActorState(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 2494 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 401 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->clientStatus[req.reply.getEndpoint().getPrimaryAddress()] = std::make_pair(now(), req);
															#line 402 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (db->clientStatus.size() > 10000)
															#line 2511 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 403 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyClientStatusEntries").suppressFor(1.0);
															#line 2515 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 406 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 2519 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 415 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(db->clientInfo->get());
															#line 416 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterOpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterOpenDatabaseActorState(); static_cast<ClusterOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 2544 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<ClusterOpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 406 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->clientInfo->get().id == req.knownClientInfoID))
															#line 2563 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 408 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->clientInfo->onChange();
															#line 407 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2571 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 409 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL);
															#line 2575 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 408 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 0, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 409 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 1, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 2582 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 0, Void >::remove();
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	OpenDatabaseRequest req;
															#line 2755 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterOpenDatabase()
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterOpenDatabaseActor, 0, Void >, public ActorCallback< ClusterOpenDatabaseActor, 1, Void >, public FastAllocated<ClusterOpenDatabaseActor>, public ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor> {
															#line 2760 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterOpenDatabaseActor>::operator new;
	using FastAllocated<ClusterOpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7904801019118590720UL, 941451073682363648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterOpenDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterOpenDatabaseActor, 1, Void >;
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActor(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 2778 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4479359797486159872UL, 7876825679301567232UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterOpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterOpenDatabase( ClusterControllerData::DBInfo* const& db, OpenDatabaseRequest const& req ) {
															#line 400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterOpenDatabaseActor(db, req));
															#line 2811 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 418 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRecruitmentRequests.size(); i++) {
		Reference<RecruitWorkersInfo> info = self->outstandingRecruitmentRequests[i];
		try {
			info->rep = self->findWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingRemoteRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRemoteRecruitmentRequests.size(); i++) {
		Reference<RecruitRemoteWorkersInfo> info = self->outstandingRemoteRecruitmentRequests[i];
		try {
			info->rep = self->findRemoteWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRemoteRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRemoteRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitRemoteTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitRemoteTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingStorageRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingStorageRequests.size(); i++) {
		auto& req = self->outstandingStorageRequests[i];
		try {
			if (req.second < now()) {
				req.first.reply.sendError(timed_out());
				swapAndPop(&self->outstandingStorageRequests, i--);
			} else {
				if (!self->gotProcessClasses && !req.first.criticalRecruitment)
					throw no_more_servers();

				auto worker = self->getStorageWorker(req.first);
				RecruitStorageReply rep;
				rep.worker = worker.interf;
				rep.processClass = worker.processClass;
				req.first.reply.send(rep);
				swapAndPop(&self->outstandingStorageRequests, i--);
			}
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers) {
				TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
				    .errorUnsuppressed(e)
				    .suppressFor(1.0)
				    .detail("OutstandingReq", i)
				    .detail("IsCriticalRecruitment", req.first.criticalRecruitment);
			} else {
				TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
				throw;
			}
		}
	}
}

// Finds and returns a new process for role
WorkerDetails findNewProcessForSingleton(ClusterControllerData* self,
                                         const ProcessClass::ClusterRole role,
                                         std::map<Optional<Standalone<StringRef>>, int>& id_used) {
	// find new process in cluster for role
	WorkerDetails newWorker =
	    self->getWorkerForRoleInDatacenter(
	            self->clusterControllerDcId, role, ProcessClass::NeverAssign, self->db.config, id_used, {}, true)
	        .worker;

	// check if master's process is actually better suited for role
	if (self->onMasterIsBetter(newWorker, role)) {
		newWorker = self->id_worker[self->masterProcessId.get()].details;
	}

	// acknowledge that the pid is now potentially used by this role as well
	id_used[newWorker.interf.locality.processId()]++;

	return newWorker;
}

// Return best possible fitness for singleton. Note that lower fitness is better.
ProcessClass::Fitness findBestFitnessForSingleton(const ClusterControllerData* self,
                                                  const WorkerDetails& worker,
                                                  const ProcessClass::ClusterRole& role) {
	auto bestFitness = worker.processClass.machineClassFitness(role);
	// If the process has been marked as excluded, we take the max with ExcludeFit to ensure its fit
	// is at least as bad as ExcludeFit. This assists with successfully offboarding such processes
	// and removing them from the cluster.
	if (self->db.config.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
		bestFitness = std::max(bestFitness, ProcessClass::ExcludeFit);
	}
	return bestFitness;
}

// Returns true iff the singleton is healthy. "Healthy" here means that
// the singleton is stable (see below) and doesn't need to be rerecruited.
// Side effects: (possibly) initiates recruitment
template <class SingletonClass>
bool isHealthySingleton(ClusterControllerData* self,
                        const WorkerDetails& newWorker,
                        const SingletonClass& singleton,
                        const ProcessClass::Fitness& bestFitness,
                        const Optional<UID> recruitingID) {
	// A singleton is stable if it exists in cluster, has not been killed off of proc and is not being recruited
	bool isStableSingleton = singleton.isPresent() &&
	                         self->id_worker.contains(singleton.getInterface().locality.processId()) &&
	                         (!recruitingID.present() || (recruitingID.get() == singleton.getInterface().id()));

	if (!isStableSingleton) {
		return false; // not healthy because unstable
	}

	auto& currWorker = self->id_worker[singleton.getInterface().locality.processId()];
	auto currFitness = currWorker.details.processClass.machineClassFitness(singleton.getClusterRole());
	if (currWorker.priorityInfo.isExcluded) {
		currFitness = ProcessClass::ExcludeFit;
	}
	// If any of the following conditions are met, we will switch the singleton's process:
	// - if the current proc is used by some non-master, non-singleton role
	// - if the current fitness is less than optimal (lower fitness is better)
	// - if currently at peak fitness but on same process as master, and the new worker is on different process
	bool shouldRerecruit =
	    self->isUsedNotMaster(currWorker.details.interf.locality.processId()) || bestFitness < currFitness ||
	    (currFitness == bestFitness && currWorker.details.interf.locality.processId() == self->masterProcessId &&
	     newWorker.interf.locality.processId() != self->masterProcessId);
	if (g_network->isSimulated() && singleton.getRole() == Role::DATA_DISTRIBUTOR &&
	    SERVER_KNOBS->CC_ENFORCE_USE_UNFIT_DD_IN_SIM) {
		// It is possible that DD location is not optimal in the simulation.
		// This can cause the simulation stuck if it always halts DD.
		// TODO(BulkLoad): this is a work around. We should figure out why DD can be repeatedly
		// terminated by CC throughout the simulation.
		shouldRerecruit = false;
	}
	if (shouldRerecruit) {
		std::string roleAbbr = singleton.getRole().abbreviation;
		TraceEvent(("CCHalt" + roleAbbr).c_str(), self->id)
		    .detail(roleAbbr + "ID", singleton.getInterface().id())
		    .detail("Excluded", currWorker.priorityInfo.isExcluded)
		    .detail("Fitness", currFitness)
		    .detail("BestFitness", bestFitness)
		    .detail("MasterProcessId", self->masterProcessId)
		    .detail("CurrentWorkerProcessId", currWorker.details.interf.locality.processId())
		    .detail("NewWorkerProcessId", newWorker.interf.locality.processId())
		    .detail("IsUsedNotMaster", self->isUsedNotMaster(currWorker.details.interf.locality.processId()));
		singleton.recruit(*self); // SIDE EFFECT: initiating recruitment
		return false; // not healthy since needed to be rerecruited
	} else {
		return true; // healthy because doesn't need to be rerecruited
	}
}

// Returns a mapping from pid->pidCount for pids
std::map<Optional<Standalone<StringRef>>, int> getColocCounts(
    const std::vector<Optional<Standalone<StringRef>>>& pids) {
	std::map<Optional<Standalone<StringRef>>, int> counts;
	for (const auto& pid : pids) {
		if (pid.present()) {
			++counts[pid];
		}
	}
	return counts;
}

// Checks if there exists a better process for each singleton (e.g. DD) compared
// to the process it is currently on.
// When adding new singletons, just follow the ratekeeper/data distributor examples.
void checkBetterSingletons(ClusterControllerData* self) {
	if (!self->masterProcessId.present() ||
	    self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS) {
		return;
	}

	// note: this map doesn't consider pids used by existing singletons
	std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();

	// We prefer spreading out other roles more than separating singletons on their own process
	// so we artificially amplify the pid count for the processes used by non-singleton roles.
	// In other words, we make the processes used for other roles less desirable to be used
	// by singletons as well.
	for (auto& it : id_used) {
		it.second *= PID_USED_AMP_FOR_NON_SINGLETON;
	}

	// Try to find a new process for each singleton.
	WorkerDetails newRKWorker = findNewProcessForSingleton(self, ProcessClass::Ratekeeper, id_used);
	WorkerDetails newDDWorker = findNewProcessForSingleton(self, ProcessClass::DataDistributor, id_used);
	WorkerDetails newCSWorker = findNewProcessForSingleton(self, ProcessClass::ConsistencyScan, id_used);

	WorkerDetails newEKPWorker;
	EncryptionAtRestMode encryptMode = self->db.config.encryptionAtRestMode;
	const bool enableKmsCommunication =
	    encryptMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION;
	if (enableKmsCommunication) {
		newEKPWorker = findNewProcessForSingleton(self, ProcessClass::EncryptKeyProxy, id_used);
	}

	// Find best possible fitnesses for each singleton.
	auto bestFitnessForRK = findBestFitnessForSingleton(self, newRKWorker, ProcessClass::Ratekeeper);
	auto bestFitnessForDD = findBestFitnessForSingleton(self, newDDWorker, ProcessClass::DataDistributor);
	auto bestFitnessForCS = findBestFitnessForSingleton(self, newCSWorker, ProcessClass::ConsistencyScan);

	ProcessClass::Fitness bestFitnessForEKP;
	if (enableKmsCommunication) {
		bestFitnessForEKP = findBestFitnessForSingleton(self, newEKPWorker, ProcessClass::EncryptKeyProxy);
	}

	auto& db = self->db.serverInfo->get();
	auto rkSingleton = RatekeeperSingleton(db.ratekeeper);
	auto ddSingleton = DataDistributorSingleton(db.distributor);
	ConsistencyScanSingleton csSingleton(db.consistencyScan);
	EncryptKeyProxySingleton ekpSingleton(db.client.encryptKeyProxy);

	// Check if the singletons are healthy.
	// side effect: try to rerecruit the singletons to more optimal processes
	bool rkHealthy = isHealthySingleton<RatekeeperSingleton>(
	    self, newRKWorker, rkSingleton, bestFitnessForRK, self->recruitingRatekeeperID);

	bool ddHealthy = isHealthySingleton<DataDistributorSingleton>(
	    self, newDDWorker, ddSingleton, bestFitnessForDD, self->recruitingDistributorID);

	bool csHealthy = isHealthySingleton<ConsistencyScanSingleton>(
	    self, newCSWorker, csSingleton, bestFitnessForCS, self->recruitingConsistencyScanID);

	bool ekpHealthy = true;
	if (enableKmsCommunication) {
		ekpHealthy = isHealthySingleton<EncryptKeyProxySingleton>(
		    self, newEKPWorker, ekpSingleton, bestFitnessForEKP, self->recruitingEncryptKeyProxyID);
	}
	// if any of the singletons are unhealthy (rerecruited or not stable), then do not
	// consider any further re-recruitments
	if (!(rkHealthy && ddHealthy && ekpHealthy && csHealthy)) {
		return;
	}

	// if we reach here, we know that the singletons are healthy so let's
	// check if we can colocate the singletons in a more optimal way
	Optional<Standalone<StringRef>> currRKProcessId = rkSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currDDProcessId = ddSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currCSProcessId = csSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> newRKProcessId = newRKWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newDDProcessId = newDDWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newCSProcessId = newCSWorker.interf.locality.processId();

	Optional<Standalone<StringRef>> currEKPProcessId, newEKPProcessId;
	if (enableKmsCommunication) {
		currEKPProcessId = ekpSingleton.getInterface().locality.processId();
		newEKPProcessId = newEKPWorker.interf.locality.processId();
	}

	std::vector<Optional<Standalone<StringRef>>> currPids = { currRKProcessId, currDDProcessId, currCSProcessId };
	std::vector<Optional<Standalone<StringRef>>> newPids = { newRKProcessId, newDDProcessId, newCSProcessId };
	if (enableKmsCommunication) {
		currPids.emplace_back(currEKPProcessId);
		newPids.emplace_back(newEKPProcessId);
	}

	auto currColocMap = getColocCounts(currPids);
	auto newColocMap = getColocCounts(newPids);

	// if the knob is disabled, the EKP coloc counts should have no affect on the coloc counts check below
	if (!enableKmsCommunication) {
		ASSERT(currColocMap[currEKPProcessId] == 0);
		ASSERT(newColocMap[newEKPProcessId] == 0);
	}

	// if the new coloc counts are collectively better (i.e. each singleton's coloc count has not increased)
	if (newColocMap[newRKProcessId] <= currColocMap[currRKProcessId] &&
	    newColocMap[newDDProcessId] <= currColocMap[currDDProcessId] &&
	    newColocMap[newEKPProcessId] <= currColocMap[currEKPProcessId] &&
	    newColocMap[newCSProcessId] <= currColocMap[currCSProcessId]) {
		// rerecruit the singleton for which we have found a better process, if any
		if (newColocMap[newRKProcessId] < currColocMap[currRKProcessId]) {
			rkSingleton.recruit(*self);
		} else if (newColocMap[newDDProcessId] < currColocMap[currDDProcessId]) {
			ddSingleton.recruit(*self);
		} else if (enableKmsCommunication && newColocMap[newEKPProcessId] < currColocMap[currEKPProcessId]) {
			ekpSingleton.recruit(*self);
		} else if (newColocMap[newCSProcessId] < currColocMap[currCSProcessId]) {
			csSingleton.recruit(*self);
		}
	}
}

															#line 3117 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRequestsActor>
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActorState {
															#line 3124 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActorState(ClusterControllerData* const& self) 
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 3131 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 722 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 722 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3149 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 1;
															#line 722 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 748 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRequestsActorState(); static_cast<DoCheckOutstandingRequestsActor*>(this)->destroy(); return 0; }
															#line 3183 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 3196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 745 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 3200 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 723 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3216 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 723 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3225 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRecruitmentRequests(self);
															#line 734 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingStorageRequests(self);
															#line 736 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkBetterSingletons(self);
															#line 738 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->checkRecoveryStalled();
															#line 739 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->betterMasterExists())
															#line 3317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 740 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.forceMasterFailure.trigger();
															#line 741 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("MasterRegistrationKill", self->id).detail("MasterId", self->db.serverInfo->get().master.id());
															#line 3323 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 723 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY || !self->goodRecruitmentTime.isReady()))
															#line 3340 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY)
															#line 3346 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 726 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY + 0.001 - (now() - self->lastRecruitTime));
															#line 726 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3352 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 2;
															#line 726 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3357 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 728 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->goodRecruitmentTime.isReady())
															#line 3384 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 729 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->goodRecruitmentTime;
															#line 729 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3390 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 3;
															#line 729 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 3600 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >, public FastAllocated<DoCheckOutstandingRequestsActor>, public DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor> {
															#line 3605 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6221265721389263104UL, 3702179553842216448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >;
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActor(ClusterControllerData* const& self) 
															#line 3624 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18376869144156441344UL, 10196932547024268032UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRequests( ClusterControllerData* const& self ) {
															#line 720 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRequestsActor(self));
															#line 3659 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 750 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3664 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRemoteRequestsActor>
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActorState {
															#line 3671 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActorState(ClusterControllerData* const& self) 
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 3678 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRemoteRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3696 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 1;
															#line 753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 3701 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 764 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRemoteRequestsActorState(); static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->destroy(); return 0; }
															#line 3730 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 760 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 3743 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 761 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 3747 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3763 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3772 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 758 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRemoteRecruitmentRequests(self);
															#line 3856 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 754 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 3872 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 755 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->goodRemoteRecruitmentTime;
															#line 755 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3880 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 2;
															#line 755 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 3885 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 4005 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >, public FastAllocated<DoCheckOutstandingRemoteRequestsActor>, public DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor> {
															#line 4010 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6686546187177615104UL, 13841274765563545856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >;
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActor(ClusterControllerData* const& self) 
															#line 4028 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11202796549843407360UL, 6198894268515362560UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRemoteRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRemoteRequests( ClusterControllerData* const& self ) {
															#line 751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRemoteRequestsActor(self));
															#line 4062 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 766 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRequests(ClusterControllerData* self) {
	if (self->outstandingRemoteRequestChecker.isReady()) {
		self->outstandingRemoteRequestChecker = doCheckOutstandingRemoteRequests(self);
	}

	if (self->outstandingRequestChecker.isReady()) {
		self->outstandingRequestChecker = doCheckOutstandingRequests(self);
	}
}

															#line 4077 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via rebootAndCheck()
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RebootAndCheckActor>
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActorState {
															#line 4084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActorState(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   processID(processID)
															#line 4093 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~RebootAndCheckActorState() 
	{
		fdb_probe_actor_destroy("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 779 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(processID.present());
															#line 780 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto watcher = cluster->id_worker.find(processID);
															#line 781 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(watcher != cluster->id_worker.end());
															#line 783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots++;
															#line 784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(g_network->isSimulated() ? SERVER_KNOBS->SIM_SHUTDOWN_TIMEOUT : SERVER_KNOBS->SHUTDOWN_TIMEOUT);
															#line 784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4119 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 1;
															#line 784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RebootAndCheckActor, 0, Void >*>(static_cast<RebootAndCheckActor*>(this)));
															#line 4124 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 788 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto watcher = cluster->id_worker.find(processID);
															#line 789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (watcher != cluster->id_worker.end())
															#line 4151 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 790 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots--;
															#line 791 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (watcher->second.reboots < 2)
															#line 4157 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 792 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					checkOutstandingRequests(cluster);
															#line 4161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 796 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RebootAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RebootAndCheckActorState(); static_cast<RebootAndCheckActor*>(this)->destroy(); return 0; }
															#line 4167 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RebootAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state > 0) static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RebootAndCheckActor*>(this)->ActorCallback< RebootAndCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RebootAndCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Standalone<StringRef>> processID;
															#line 4266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via rebootAndCheck()
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActor final : public Actor<Void>, public ActorCallback< RebootAndCheckActor, 0, Void >, public FastAllocated<RebootAndCheckActor>, public RebootAndCheckActorState<RebootAndCheckActor> {
															#line 4271 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RebootAndCheckActor>::operator new;
	using FastAllocated<RebootAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5653927457233392128UL, 6518764891175292160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RebootAndCheckActor, 0, Void >;
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActor(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 4288 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   RebootAndCheckActorState<RebootAndCheckActor>(cluster, processID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17703883454640654592UL, 13640791943228081920UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rebootAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RebootAndCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> rebootAndCheck( ClusterControllerData* const& cluster, Optional<Standalone<StringRef>> const& processID ) {
															#line 777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RebootAndCheckActor(cluster, processID));
															#line 4321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 798 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 4326 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via workerAvailabilityWatch()
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class WorkerAvailabilityWatchActor>
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActorState {
															#line 4333 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActorState(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : worker(worker),
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   startingClass(startingClass),
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cluster(cluster),
															#line 802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failed((worker.address() == g_network->getLocalAddress()) ? Never() : waitFailureClient(worker.waitFailure, SERVER_KNOBS->WORKER_FAILURE_TIME))
															#line 4346 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	~WorkerAvailabilityWatchActorState() 
	{
		fdb_probe_actor_destroy("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 805 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateWorkerList.set( worker.locality.processId(), ProcessData(worker.locality, startingClass, worker.stableAddress(), worker.grpcAddress()));
															#line 810 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 810 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4365 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 1;
															#line 810 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 4370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 812 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4393 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 812 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4402 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 814 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = IFailureMonitor::failureMonitor().onStateEqual( worker.storage.getEndpoint(), FailureStatus( IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable()));
															#line 813 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4495 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 823 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failed;
															#line 4499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 2;
															#line 814 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 823 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 4506 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 4521 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 819 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 4527 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 4537 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 819 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 4543 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 824 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 4555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 827 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 4559 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 830 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 4563 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 831 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 4567 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 833 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 837 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 838 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 841 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 4577 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 842 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 843 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 4583 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 844 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 4587 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 848 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 4594 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 824 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 4608 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 827 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 4612 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 830 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 4616 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 831 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 4620 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 833 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 837 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 838 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 841 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 4630 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 842 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 843 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 4636 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 844 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 4640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 848 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 4647 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 1, Void >::remove();
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerInterface worker;
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ProcessClass startingClass;
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> failed;
															#line 4784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via workerAvailabilityWatch()
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActor final : public Actor<Void>, public ActorCallback< WorkerAvailabilityWatchActor, 0, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 1, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 2, Void >, public FastAllocated<WorkerAvailabilityWatchActor>, public WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor> {
															#line 4789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<WorkerAvailabilityWatchActor>::operator new;
	using FastAllocated<WorkerAvailabilityWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1250448850497501952UL, 1463560433305244672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerAvailabilityWatchActor, 0, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 1, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 2, Void >;
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActor(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 4808 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor>(worker, startingClass, cluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10692884594389689856UL, 3271400941493304320UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerAvailabilityWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> workerAvailabilityWatch( WorkerInterface const& worker, ProcessClass const& startingClass, ClusterControllerData* const& cluster ) {
															#line 799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new WorkerAvailabilityWatchActor(worker, startingClass, cluster));
															#line 4842 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 853 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

struct FailureStatusInfo {
	FailureStatus status;
	double lastRequestTime;
	double penultimateRequestTime;

	FailureStatusInfo() : lastRequestTime(0), penultimateRequestTime(0) {}

	void insertRequest(double now) {
		penultimateRequestTime = lastRequestTime;
		lastRequestTime = now;
	}

	double latency(double now) const {
		return std::max(now - lastRequestTime, lastRequestTime - penultimateRequestTime);
	}
};

															#line 4864 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via requireAll()
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RequireAllActor>
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActorState {
															#line 4871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActorState(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : in(in),
															#line 872 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   out(),
															#line 873 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   i()
															#line 4882 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("requireAll", reinterpret_cast<unsigned long>(this));

	}
	~RequireAllActorState() 
	{
		fdb_probe_actor_destroy("requireAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 874 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			i = 0;
															#line 4897 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 880 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RequireAllActor*>(this)->SAV<std::vector<TLogInterface>>::futures) { (void)(out); this->~RequireAllActorState(); static_cast<RequireAllActor*>(this)->destroy(); return 0; }
															#line 4920 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RequireAllActor*>(this)->SAV< std::vector<TLogInterface> >::value()) std::vector<TLogInterface>(std::move(out)); // state_var_RVO
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 874 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(i < in.size()))
															#line 4939 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Optional<std::vector<TLogInterface>>> __when_expr_0 = in[i];
															#line 875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RequireAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4947 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequireAllActor*>(this)->actor_wait_state = 1;
															#line 875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*>(static_cast<RequireAllActor*>(this)));
															#line 4952 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
															#line 876 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 4974 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 877 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 4978 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 878 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 874 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 4984 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
															#line 876 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 4993 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 877 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 4997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 878 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 874 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 5003 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireAllActor*>(this)->actor_wait_state > 0) static_cast<RequireAllActor*>(this)->actor_wait_state = 0;
		static_cast<RequireAllActor*>(this)->ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> const& value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> && value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Optional<std::vector<TLogInterface>>>> in;
															#line 872 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<TLogInterface> out;
															#line 873 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int i;
															#line 5089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via requireAll()
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActor final : public Actor<std::vector<TLogInterface>>, public ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >, public FastAllocated<RequireAllActor>, public RequireAllActorState<RequireAllActor> {
															#line 5094 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RequireAllActor>::operator new;
	using FastAllocated<RequireAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17670346390801142272UL, 2202364492019928064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TLogInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >;
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActor(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 5111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<std::vector<TLogInterface>>(),
		   RequireAllActorState<RequireAllActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16593527381228025088UL, 9468838150300793600UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requireAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<TLogInterface>> requireAll( std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in ) {
															#line 871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<TLogInterface>>(new RequireAllActor(in));
															#line 5144 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 882 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void clusterRecruitStorage(ClusterControllerData* self, RecruitStorageRequest req) {
	try {
		if (!self->gotProcessClasses && !req.criticalRecruitment)
			throw no_more_servers();
		auto worker = self->getStorageWorker(req);
		RecruitStorageReply rep;
		rep.worker = worker.interf;
		rep.processClass = worker.processClass;
		req.reply.send(rep);
	} catch (Error& e) {
		if (e.code() == error_code_no_more_servers) {
			self->outstandingStorageRequests.emplace_back(req, now() + SERVER_KNOBS->RECRUITMENT_TIMEOUT);
			TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
			    .error(e)
			    .detail("IsCriticalRecruitment", req.criticalRecruitment);
		} else {
			TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
			throw; // Any other error will bring down the cluster controller
		}
	}
}

void clusterRegisterMaster(ClusterControllerData* self, RegisterMasterRequest const& req) {
	++self->registerMasterRequests;

	TraceEvent("MasterRegistrationReceived", self->id)
	    .detail("MasterId", req.id)
	    .detail("Master", req.mi.toString())
	    .detail("Tlogs", describe(req.logSystemConfig.tLogs))
	    .detail("Resolvers", req.resolvers.size())
	    .detail("RecoveryState", (int)req.recoveryState)
	    .detail("RegistrationCount", req.registrationCount)
	    .detail("CommitProxies", req.commitProxies.size())
	    .detail("GrvProxies", req.grvProxies.size())
	    .detail("RecoveryCount", req.recoveryCount)
	    .detail("Stalled", req.recoveryStalled)
	    .detail("OldestBackupEpoch", req.logSystemConfig.oldestBackupEpoch);

	// make sure the request comes from an active database
	auto db = &self->db;
	if (db->serverInfo->get().master.id() != req.id || req.registrationCount <= db->masterRegistrationCount) {
		TraceEvent("MasterRegistrationNotFound", self->id)
		    .detail("MasterId", req.id)
		    .detail("ExistingId", db->serverInfo->get().master.id())
		    .detail("RegCount", req.registrationCount)
		    .detail("ExistingRegCount", db->masterRegistrationCount);
		return;
	}

	if (req.recoveryState == RecoveryState::FULLY_RECOVERED) {
		self->db.unfinishedRecoveries = 0;
		ASSERT(!req.logSystemConfig.oldTLogs.size());
	}

	db->masterRegistrationCount = req.registrationCount;
	db->recoveryStalled = req.recoveryStalled;
	if (req.configuration.present()) {
		db->config = req.configuration.get();

		if (req.recoveryState >= RecoveryState::ACCEPTING_COMMITS) {
			self->gotFullyRecoveredConfig = true;
			db->fullyRecoveredConfig = req.configuration.get();
			for (auto& it : self->id_worker) {
				bool isExcludedFromConfig = db->fullyRecoveredConfig.isExcludedServer(
				    it.second.details.interf.addresses(), it.second.details.interf.locality);
				if (it.second.priorityInfo.isExcluded != isExcludedFromConfig) {
					it.second.priorityInfo.isExcluded = isExcludedFromConfig;
					if (!it.second.reply.isSet()) {
						it.second.reply.send(
						    RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
					}
				}
			}
		}
	}

	bool isChanged = false;
	auto dbInfo = self->db.serverInfo->get();

	if (dbInfo.recoveryState != req.recoveryState) {
		dbInfo.recoveryState = req.recoveryState;
		isChanged = true;
	}

	if (dbInfo.priorCommittedLogServers != req.priorCommittedLogServers) {
		dbInfo.priorCommittedLogServers = req.priorCommittedLogServers;
		isChanged = true;
	}

	// Construct the client information
	if (db->clientInfo->get().commitProxies != req.commitProxies ||
	    db->clientInfo->get().grvProxies != req.grvProxies ||
	    db->clientInfo->get().tenantMode != db->config.tenantMode ||
	    db->clientInfo->get().clusterId != db->serverInfo->get().client.clusterId ||
	    db->clientInfo->get().clusterType != db->clusterType ||
	    db->clientInfo->get().metaclusterName != db->metaclusterName) {
		TraceEvent("PublishNewClientInfo", self->id)
		    .detail("Master", dbInfo.master.id())
		    .detail("GrvProxies", db->clientInfo->get().grvProxies)
		    .detail("ReqGrvProxies", req.grvProxies)
		    .detail("CommitProxies", db->clientInfo->get().commitProxies)
		    .detail("GlobalConfigHistorySize", db->clientInfo->get().history.size())
		    .detail("ReqCPs", req.commitProxies)
		    .detail("TenantMode", db->clientInfo->get().tenantMode.toString())
		    .detail("ReqTenantMode", db->config.tenantMode.toString())
		    .detail("ClusterId", db->serverInfo->get().client.clusterId)
		    .detail("ClientClusterId", db->clientInfo->get().clusterId)
		    .detail("ClusterType", db->clientInfo->get().clusterType)
		    .detail("ReqClusterType", db->clusterType)
		    .detail("MetaclusterName", db->clientInfo->get().metaclusterName)
		    .detail("ReqMetaclusterName", db->metaclusterName);
		isChanged = true;
		// TODO why construct a new one and not just copy the old one and change proxies + id?
		ClientDBInfo clientInfo;
		clientInfo.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
		clientInfo.id = deterministicRandom()->randomUniqueID();
		clientInfo.commitProxies = req.commitProxies;
		clientInfo.grvProxies = req.grvProxies;
		clientInfo.history = db->clientInfo->get().history;
		clientInfo.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
		clientInfo.clusterId = db->serverInfo->get().client.clusterId;
		clientInfo.clusterType = db->clusterType;
		clientInfo.metaclusterName = db->metaclusterName;
		db->clientInfo->set(clientInfo);
		dbInfo.client = db->clientInfo->get();
	}

	if (!dbInfo.logSystemConfig.isEqual(req.logSystemConfig)) {
		isChanged = true;
		dbInfo.logSystemConfig = req.logSystemConfig;
	}

	if (dbInfo.resolvers != req.resolvers) {
		isChanged = true;
		dbInfo.resolvers = req.resolvers;
	}

	if (dbInfo.recoveryCount != req.recoveryCount) {
		isChanged = true;
		dbInfo.recoveryCount = req.recoveryCount;
	}

	if (isChanged) {
		dbInfo.id = deterministicRandom()->randomUniqueID();
		dbInfo.infoGeneration = ++self->db.dbInfoCount;
		self->db.serverInfo->set(dbInfo);
	}

	checkOutstandingRequests(self);
}

// Halts the registering (i.e. requesting) singleton if one is already in the process of being recruited
// or, halts the existing singleton in favour of the requesting one
template <class SingletonClass>
void haltRegisteringOrCurrentSingleton(ClusterControllerData* self,
                                       const WorkerInterface& worker,
                                       const SingletonClass& currSingleton,
                                       const SingletonClass& registeringSingleton,
                                       const Optional<UID> recruitingID) {
	ASSERT(currSingleton.getRole() == registeringSingleton.getRole());
	const UID registeringID = registeringSingleton.getInterface().id();
	const std::string roleName = currSingleton.getRole().roleName;
	const std::string roleAbbr = currSingleton.getRole().abbreviation;

	// halt the requesting singleton if it isn't the one currently being recruited
	if ((recruitingID.present() && recruitingID.get() != registeringID) ||
	    self->clusterControllerDcId != worker.locality.dcId()) {
		TraceEvent(("CCHaltRegistering" + roleName).c_str(), self->id)
		    .detail(roleAbbr + "ID", registeringID)
		    .detail("DcID", printable(self->clusterControllerDcId))
		    .detail("ReqDcID", printable(worker.locality.dcId()))
		    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
		registeringSingleton.halt(*self, worker.locality.processId());
	} else if (!recruitingID.present()) {
		// if not currently recruiting, then halt previous one in favour of requesting one
		TraceEvent(("CCRegister" + roleName).c_str(), self->id).detail(roleAbbr + "ID", registeringID);
		if (currSingleton.isPresent() && currSingleton.getInterface().id() != registeringID &&
		    self->id_worker.contains(currSingleton.getInterface().locality.processId())) {
			TraceEvent(("CCHaltPrevious" + roleName).c_str(), self->id)
			    .detail(roleAbbr + "ID", currSingleton.getInterface().id())
			    .detail("DcID", printable(self->clusterControllerDcId))
			    .detail("ReqDcID", printable(worker.locality.dcId()))
			    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
			currSingleton.halt(*self, currSingleton.getInterface().locality.processId());
		}
		// set the curr singleton if it doesn't exist or its different from the requesting one
		if (!currSingleton.isPresent() || currSingleton.getInterface().id() != registeringID) {
			registeringSingleton.setInterfaceToDbInfo(*self);
		}
	}
}

															#line 5341 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorker()
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RegisterWorkerActor>
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActorState {
															#line 5348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActorState(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : req(req),
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cs(cs),
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster)
															#line 5361 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerActorState() 
	{
		fdb_probe_actor_destroy("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1079 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1079 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5378 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 1;
															#line 1079 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*>(static_cast<RegisterWorkerActor*>(this)));
															#line 5383 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1082 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 5408 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1090 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5416 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1093 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1094 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1095 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1098 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1106 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 5436 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5442 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1119 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1120 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 5450 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1122 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 5456 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1133 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 5460 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1134 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 5464 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1135 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5468 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1136 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5472 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1139 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5479 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1140 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5483 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1144 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 5491 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5495 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1149 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5506 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1150 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5510 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 1156 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5516 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1158 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 5520 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1159 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 5526 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1163 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 5530 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1165 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 5536 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1167 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 5540 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1170 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 5544 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1171 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 5548 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1175 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5553 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1188 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5559 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1189 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1191 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 5565 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1192 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 5569 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1197 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1198 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1199 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 5577 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1200 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 5581 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
															#line 1203 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 5586 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1205 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 5590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1207 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5594 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1208 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 5598 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1214 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1215 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1216 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 5606 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1217 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5612 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 5616 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1219 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 5620 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1221 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1222 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1223 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1224 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1225 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1227 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1228 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 5640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1232 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1236 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 5650 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1239 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 5654 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1240 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1241 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 5660 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1243 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5664 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 5668 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1250 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 5672 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1252 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 5678 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 5683 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1260 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 5691 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 5695 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1268 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 5703 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1272 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 5707 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1273 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1275 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 5715 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1279 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 5719 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1280 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1281 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1282 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 5727 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1287 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 5731 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1288 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 5735 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1291 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5739 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1082 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 5753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1090 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5761 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1093 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1094 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1095 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1098 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1106 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 5781 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5787 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1119 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1120 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 5795 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1122 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 5801 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1133 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 5805 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1134 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 5809 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1135 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5813 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1136 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5817 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1139 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5824 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1140 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5828 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1144 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 5836 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5840 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5844 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1149 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5851 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1150 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5855 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 1156 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5861 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1158 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 5865 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1159 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 5871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1163 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 5875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1165 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 5881 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1167 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 5885 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1170 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 5889 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1171 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 5893 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1175 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5898 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1188 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5904 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1189 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1191 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 5910 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1192 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 5914 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1197 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1198 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1199 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 5922 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1200 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 5926 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
			}
															#line 1203 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 5931 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1205 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 5935 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1207 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5939 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1208 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 5943 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1214 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1215 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1216 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 5951 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1217 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5957 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 5961 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1219 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 5965 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1221 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1222 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1223 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1224 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1225 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1227 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1228 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 5985 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1232 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1236 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 5995 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1239 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 5999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1240 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1241 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 6005 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1243 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 6009 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 6013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1250 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 6017 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1252 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 6023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 6028 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1260 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 6036 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 6040 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1268 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 6048 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1272 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 6052 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1273 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1275 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 6060 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1279 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 6064 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1280 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1281 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1282 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 6072 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1287 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 6076 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1288 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 6080 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1291 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 6084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(coordinatorAddresses, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(coordinatorAddresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerActor*>(this)->ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerRequest req;
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterConnectionString cs;
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster* configBroadcaster;
															#line 6175 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via registerWorker()
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActor final : public Actor<Void>, public ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >, public FastAllocated<RegisterWorkerActor>, public RegisterWorkerActorState<RegisterWorkerActor> {
															#line 6180 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerActor>::operator new;
	using FastAllocated<RegisterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15230273178296475136UL, 9112587955056017408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >;
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActor(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 6197 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerActorState<RegisterWorkerActor>(req, self, cs, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14446594949420451840UL, 3262990831982615808UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> registerWorker( RegisterWorkerRequest const& req, ClusterControllerData* const& self, ClusterConnectionString const& cs, ConfigBroadcaster* const& configBroadcaster ) {
															#line 1075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RegisterWorkerActor(req, self, cs, configBroadcaster));
															#line 6230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

#define TIME_KEEPER_VERSION "1"_sr

															#line 6237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperSetVersionActor>
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActorState {
															#line 6244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActorState(ClusterControllerData* const& self) 
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1297 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx))
															#line 6253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperSetVersionActorState() 
	{
		fdb_probe_actor_destroy("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 6268 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1311 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TimeKeeperSetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TimeKeeperSetVersionActorState(); static_cast<TimeKeeperSetVersionActor*>(this)->destroy(); return 0; }
															#line 6291 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<TimeKeeperSetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1300 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1301 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1302 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1303 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->set(timeKeeperVersionKey, TIME_KEEPER_VERSION);
															#line 1304 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1304 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 1;
															#line 1304 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 0, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 6326 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1307 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1307 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6363 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 2;
															#line 1307 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 1, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 6368 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1297 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 6557 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActor final : public Actor<Void>, public ActorCallback< TimeKeeperSetVersionActor, 0, Void >, public ActorCallback< TimeKeeperSetVersionActor, 1, Void >, public FastAllocated<TimeKeeperSetVersionActor>, public TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor> {
															#line 6562 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TimeKeeperSetVersionActor>::operator new;
	using FastAllocated<TimeKeeperSetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5804584572399390976UL, 280251437218355456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperSetVersionActor, 0, Void >;
friend struct ActorCallback< TimeKeeperSetVersionActor, 1, Void >;
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActor(ClusterControllerData* const& self) 
															#line 6580 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15389618584066260224UL, 624794717111917056UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeperSetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeperSetVersion( ClusterControllerData* const& self ) {
															#line 1296 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperSetVersionActor(self));
															#line 6614 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1313 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// This actor periodically gets read version and writes it to cluster with current timestamp as key. To avoid
// running out of space, it limits the max number of entries and clears old entries on each update. This mapping is
// used from backup and restore to get the version information for a timestamp.
															#line 6622 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via timeKeeper()
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperActor>
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActorState {
															#line 6629 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActorState(ClusterControllerData* const& self) 
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1318 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   versionMap(timeKeeperPrefixRange.begin)
															#line 6638 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperActorState() 
	{
		fdb_probe_actor_destroy("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1320 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperStarted").log();
															#line 1322 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeKeeperSetVersion(self);
															#line 1322 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6657 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 1;
															#line 1322 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 0, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6662 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperActorState();
		static_cast<TimeKeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6685 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6694 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1325 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(self->cx);
															#line 1326 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6787 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1362 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 1362 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6798 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 5;
															#line 1362 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 4, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6803 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1328 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 1329 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!g_network->isSimulated())
															#line 6822 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1333 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				tr->debugTransaction(debugID);
															#line 6826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1335 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1336 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1339 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(timeKeeperDisableKey);
															#line 1339 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6838 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 2;
															#line 1339 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 1, Optional<Value> >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6843 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6880 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 4;
															#line 1358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 3, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6885 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> const& disableValue,int loopDepth) 
	{
															#line 1340 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 6900 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1344 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1345 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1346 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1347 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 6912 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 6916 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1350 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1351 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 6922 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1352 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 6926 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6932 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6937 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> && disableValue,int loopDepth) 
	{
															#line 1340 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 6946 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1344 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1345 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1346 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1347 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 6958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1348 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 6962 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1350 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1351 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 6968 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1352 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 6972 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6978 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6983 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> const& disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(disableValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> && disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(disableValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1318 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedMap<int64_t, Version> versionMap;
															#line 1325 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1328 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID debugID;
															#line 7332 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via timeKeeper()
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActor final : public Actor<Void>, public ActorCallback< TimeKeeperActor, 0, Void >, public ActorCallback< TimeKeeperActor, 1, Optional<Value> >, public ActorCallback< TimeKeeperActor, 2, Void >, public ActorCallback< TimeKeeperActor, 3, Void >, public ActorCallback< TimeKeeperActor, 4, Void >, public FastAllocated<TimeKeeperActor>, public TimeKeeperActorState<TimeKeeperActor> {
															#line 7337 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TimeKeeperActor>::operator new;
	using FastAllocated<TimeKeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5384071935578899968UL, 10080744966966385152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperActor, 0, Void >;
friend struct ActorCallback< TimeKeeperActor, 1, Optional<Value> >;
friend struct ActorCallback< TimeKeeperActor, 2, Void >;
friend struct ActorCallback< TimeKeeperActor, 3, Void >;
friend struct ActorCallback< TimeKeeperActor, 4, Void >;
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActor(ClusterControllerData* const& self) 
															#line 7358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TimeKeeperActorState<TimeKeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10218480498489324032UL, 15738055826982653184UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TimeKeeperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TimeKeeperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TimeKeeperActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeper( ClusterControllerData* const& self ) {
															#line 1317 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperActor(self));
															#line 7395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1365 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 7400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via statusServer()
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StatusServerActor>
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActorState {
															#line 7407 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActorState(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : requests(requests),
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 1371 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   last_request_time(0.0),
															#line 1374 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   requests_batch()
															#line 7424 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("statusServer", reinterpret_cast<unsigned long>(this));

	}
	~StatusServerActorState() 
	{
		fdb_probe_actor_destroy("statusServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1376 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 7439 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusServerActorState();
		static_cast<StatusServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1379 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto __when_expr_0 = requests;
															#line 7470 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StatusRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StatusRequest>>::value, "invalid type");
															#line 1379 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7474 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StatusServerActor*>(this)->actor_wait_state = 1;
															#line 1379 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StatusServerActor, 0, StatusRequest >*>(static_cast<StatusServerActor*>(this)));
															#line 7479 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1470 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "StatusServerError").error(e);
															#line 1471 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7503 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest const& req,int loopDepth) 
	{
															#line 1380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1381 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1384 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1387 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7527 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 7532 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest && req,int loopDepth) 
	{
															#line 1380 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1381 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1384 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1387 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7551 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1388 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 7556 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorSingleCallback< StatusServerActor, 0, StatusRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1394 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1396 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 7644 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1399 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1402 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 7650 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1404 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 7656 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1409 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1410 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1412 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1413 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1414 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 7669 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1415 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 7673 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1419 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1420 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 7682 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1422 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 7686 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1424 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1425 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 7694 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->db.metaclusterRegistration, self->db.metaclusterMetrics, self->excludedDegradedServers));
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7701 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 7706 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1394 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1396 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 7719 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1399 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1402 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 7725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1404 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 7731 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1409 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1410 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1412 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1413 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1414 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 7744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1415 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 7748 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1419 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1420 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 7757 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1422 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 7761 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1424 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1425 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 7769 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->db.metaclusterRegistration, self->db.metaclusterMetrics, self->excludedDegradedServers));
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7776 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 7781 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1445 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError() && result.getError().code() == error_code_actor_cancelled)
															#line 7865 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1446 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(result.getError(), loopDepth);
															#line 7869 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1450 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		last_request_time = now();
															#line 1452 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus = Optional<StatusReply>();
															#line 1453 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 7877 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> const& __result,int loopDepth) 
	{
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		result = __result;
															#line 7886 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1468 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus.reset();
															#line 7965 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 1453 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!requests_batch.empty()))
															#line 7981 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1454 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError())
															#line 7987 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1455 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			requests_batch.back().reply.sendError(result.getError());
															#line 7991 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1456 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (requests_batch.back().statusField.empty())
															#line 7997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1457 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(result.get());
															#line 8001 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1459 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(requests_batch.back().statusField == "fault_tolerance");
															#line 1460 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!faultToleranceRelatedStatus.present())
															#line 8009 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1461 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					faultToleranceRelatedStatus = clusterGetFaultToleranceStatus(result.get().statusStr);
															#line 8013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1463 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(faultToleranceRelatedStatus.get());
															#line 8017 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1465 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.pop_back();
															#line 1466 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1466 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8026 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 4;
															#line 1466 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 3, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8031 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	FutureStream<StatusRequest> requests;
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster const* configBroadcaster;
															#line 1371 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double last_request_time;
															#line 1374 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StatusRequest> requests_batch;
															#line 1429 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ErrorOr<StatusReply> result;
															#line 1452 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<StatusReply> faultToleranceRelatedStatus;
															#line 8165 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via statusServer()
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActor final : public Actor<Void>, public ActorSingleCallback< StatusServerActor, 0, StatusRequest >, public ActorCallback< StatusServerActor, 1, Void >, public ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >, public ActorCallback< StatusServerActor, 3, Void >, public FastAllocated<StatusServerActor>, public StatusServerActorState<StatusServerActor> {
															#line 8170 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StatusServerActor>::operator new;
	using FastAllocated<StatusServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2317873206835431680UL, 12052307277617579264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StatusServerActor, 0, StatusRequest >;
friend struct ActorCallback< StatusServerActor, 1, Void >;
friend struct ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >;
friend struct ActorCallback< StatusServerActor, 3, Void >;
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActor(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 8190 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StatusServerActorState<StatusServerActor>(requests, self, coordinators, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7571137253636277504UL, 14171083556526699776UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StatusServerActor, 0, StatusRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> statusServer( FutureStream<StatusRequest> const& requests, ClusterControllerData* const& self, ServerCoordinators const& coordinators, ConfigBroadcaster const* const& configBroadcaster ) {
															#line 1366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StatusServerActor(requests, self, coordinators, configBroadcaster));
															#line 8226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1475 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 8231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorProcessClasses()
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorProcessClassesActor>
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActorState {
															#line 8238 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActorState(ClusterControllerData* const& self) 
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1478 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   trVer(self->db.db)
															#line 8247 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1479 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 8262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProcessClassesActorState();
		static_cast<MonitorProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1507 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8285 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1481 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1482 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1484 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = trVer.get(processClassVersionKey);
															#line 1484 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8308 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 1484 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8313 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1503 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = trVer.onError(e);
															#line 1503 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8350 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 4;
															#line 1503 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 3, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8355 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 1486 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 8370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8378 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8383 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 1486 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 8392 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1489 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8405 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1490 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1492 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1493 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1494 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1495 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1496 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 8499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8505 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8510 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && processClasses,int loopDepth) 
	{
															#line 1490 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1492 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1493 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1494 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1495 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1496 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 8529 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8535 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8540 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 8624 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 8633 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1508 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(self->db.db);
															#line 1510 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8813 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1512 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1513 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1514 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1514 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8842 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 5;
															#line 1514 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1558 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 1558 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8884 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 8;
															#line 1558 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 7, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8889 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1517 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 8906 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1518 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1519 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1520 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1521 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1522 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 8918 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1525 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1526 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1527 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1529 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 8928 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1532 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 8932 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1534 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 8938 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1537 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 8942 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1538 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1539 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1541 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 8950 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1542 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 8954 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
															#line 1548 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1549 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1550 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 8964 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8972 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8977 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && processClasses,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1517 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 8988 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1518 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1519 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1520 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1521 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1522 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 9000 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1525 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1526 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1527 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1529 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 9010 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1532 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 9014 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1534 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 9020 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1537 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 9024 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1538 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1539 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1541 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 9032 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1542 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 9036 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
															#line 1548 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1549 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1550 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 9046 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9054 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1554 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9059 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9150 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1555 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9166 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1478 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction trVer;
															#line 1508 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1553 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 9428 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorProcessClasses()
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActor final : public Actor<Void>, public ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >, public ActorCallback< MonitorProcessClassesActor, 1, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 2, Void >, public ActorCallback< MonitorProcessClassesActor, 3, Void >, public ActorCallback< MonitorProcessClassesActor, 4, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 5, Void >, public ActorCallback< MonitorProcessClassesActor, 6, Void >, public ActorCallback< MonitorProcessClassesActor, 7, Void >, public FastAllocated<MonitorProcessClassesActor>, public MonitorProcessClassesActorState<MonitorProcessClassesActor> {
															#line 9433 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorProcessClassesActor>::operator new;
	using FastAllocated<MonitorProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14361089405028909568UL, 3934848177159557376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorProcessClassesActor, 1, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 2, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 3, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 4, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 5, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 6, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 7, Void >;
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActor(ClusterControllerData* const& self) 
															#line 9457 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorProcessClassesActorState<MonitorProcessClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588372557279712768UL, 7971599830169234176UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorProcessClasses( ClusterControllerData* const& self ) {
															#line 1476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorProcessClassesActor(self));
															#line 9497 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1563 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 9502 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorServerInfoConfigActor>
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActorState {
															#line 9509 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 9516 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerInfoConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1565 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 9531 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerInfoConfigActorState();
		static_cast<MonitorServerInfoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1566 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1567 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9563 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1569 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1570 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1571 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1573 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(latencyBandConfigKey);
															#line 1573 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9594 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 1;
															#line 1573 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9599 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1595 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1595 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9636 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 4;
															#line 1595 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 3, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9641 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& configVal,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1575 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 9658 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1576 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 9662 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1579 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1580 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 9668 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1581 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1582 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1583 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1584 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1585 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 9680 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1588 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9688 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9693 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && configVal,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1575 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 9704 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1576 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 9708 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1579 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1580 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 9714 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1581 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1582 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1583 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1584 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1585 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 9726 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1588 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9734 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1590 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9739 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(configVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(configVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9825 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9830 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9841 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1591 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9846 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1566 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1588 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> configChangeFuture;
															#line 10106 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActor final : public Actor<Void>, public ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorServerInfoConfigActor, 1, Void >, public ActorCallback< MonitorServerInfoConfigActor, 2, Void >, public ActorCallback< MonitorServerInfoConfigActor, 3, Void >, public FastAllocated<MonitorServerInfoConfigActor>, public MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor> {
															#line 10111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorServerInfoConfigActor>::operator new;
	using FastAllocated<MonitorServerInfoConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8033668564904816896UL, 9441441813687011584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 1, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 2, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 3, Void >;
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 10131 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7361646417378993920UL, 12905750869672403968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerInfoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorServerInfoConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorServerInfoConfigActor(db));
															#line 10167 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1600 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors storage metadata changes and updates to storage servers.
															#line 10173 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorStorageMetadata()
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorStorageMetadataActor>
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActorState {
															#line 10180 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActorState(ClusterControllerData* const& self) 
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1603 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1605 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx)),
															#line 1606 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   servers()
															#line 10193 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1607 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10208 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageMetadataActorState();
		static_cast<MonitorStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1609 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.clear();
															#line 1610 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1611 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1612 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1613 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1613 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10249 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1613 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10254 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 1643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10278 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 5;
															#line 1643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 4, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10283 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1614 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1616 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		servers.reserve(serverList.size());
															#line 1617 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto ss : serverList ) {
															#line 1618 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.push_back(StorageServerMetaInfo(decodeServerListValue(ss.value)));
															#line 10304 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverMetadataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10310 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10315 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __serverList,int loopDepth) 
	{
															#line 1613 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverList = __serverList;
															#line 10324 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __serverList,int loopDepth) 
	{
		serverList = std::move(__serverList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1622 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverMetadata.more && serverMetadata.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1623 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<UID, StorageMetadataType> idMetadata;
															#line 1624 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& sm : serverMetadata ) {
															#line 1625 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const UID id = decodeServerMetadataKey(sm.key);
															#line 1626 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			idMetadata[id] = decodeServerMetadataValue(sm.value);
															#line 10411 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1628 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& s : servers ) {
															#line 1629 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (idMetadata.contains(s.id()))
															#line 10417 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1630 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				s.metadata = idMetadata[s.id()];
															#line 10421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1632 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "StorageServerMetadataMissing", self->id).detail("ServerID", s.id());
															#line 10427 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1636 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr->watch(serverMetadataChangeKey);
															#line 1637 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1637 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10436 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1637 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 2, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10441 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __serverMetadata,int loopDepth) 
	{
															#line 1621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverMetadata = __serverMetadata;
															#line 10450 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __serverMetadata,int loopDepth) 
	{
		serverMetadata = std::move(__serverMetadata);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1639 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10533 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10538 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1639 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10551 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10556 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1641 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 10640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1641 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 10649 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1603 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1605 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1606 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StorageServerMetaInfo> servers;
															#line 1613 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverList;
															#line 1621 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverMetadata;
															#line 1636 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 10843 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorStorageMetadata()
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActor final : public Actor<Void>, public ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 2, Void >, public ActorCallback< MonitorStorageMetadataActor, 3, Void >, public ActorCallback< MonitorStorageMetadataActor, 4, Void >, public FastAllocated<MonitorStorageMetadataActor>, public MonitorStorageMetadataActorState<MonitorStorageMetadataActor> {
															#line 10848 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorStorageMetadataActor>::operator new;
	using FastAllocated<MonitorStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18361018752653169920UL, 14174741731445686528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 2, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 3, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 4, Void >;
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActor(ClusterControllerData* const& self) 
															#line 10869 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorStorageMetadataActorState<MonitorStorageMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8345257820642168576UL, 250769687947896832UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorStorageMetadata( ClusterControllerData* const& self ) {
															#line 1602 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorStorageMetadataActor(self));
															#line 10906 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1647 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors the global configuration version key for changes. When changes are
// made, the global configuration history is read and any updates are sent to
// all processes in the system by updating the ClientDBInfo object. The
// GlobalConfig actor class contains the functionality to read the latest
// history and update the processes local view.
															#line 10916 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorGlobalConfig()
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorGlobalConfigActor>
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActorState {
															#line 10923 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 10930 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGlobalConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1654 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10945 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGlobalConfigActorState();
		static_cast<MonitorGlobalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1655 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1656 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = ClientDBInfo();
															#line 1657 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10979 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1659 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1660 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(globalConfigVersionKey);
															#line 1661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11008 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 1;
															#line 1661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1736 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1736 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11050 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 5;
															#line 1736 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 4, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11055 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 1663 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (globalConfigVersion.present())
															#line 11070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1667 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1667 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11076 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 2;
															#line 1667 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11081 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 1661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 11095 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1731 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigFuture = tr.watch(globalConfigVersionKey);
															#line 1732 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1732 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11178 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 3;
															#line 1732 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 2, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11183 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult const& globalConfigHistory,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1672 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1673 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1675 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1676 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1677 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 11202 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1685 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1686 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 11208 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				break;
			}
															#line 1690 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1691 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1694 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1696 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1697 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1698 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1699 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1701 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 11227 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1704 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 11231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1716 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 11235 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1719 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1721 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1722 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1723 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1724 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1728 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 11251 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult && globalConfigHistory,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1672 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1673 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1675 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1676 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1677 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 11270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1685 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1686 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 11276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				break;
			}
															#line 1690 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1691 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1694 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1696 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1697 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1698 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1699 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1701 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 11295 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1704 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 11299 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1716 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 11303 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1719 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1721 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1722 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1723 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1724 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1728 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 11319 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(globalConfigHistory, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(globalConfigHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11405 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11410 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1733 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11426 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1655 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1656 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClientDBInfo clientInfo;
															#line 1661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1731 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> globalConfigFuture;
															#line 11690 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorGlobalConfig()
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActor final : public Actor<Void>, public ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >, public ActorCallback< MonitorGlobalConfigActor, 2, Void >, public ActorCallback< MonitorGlobalConfigActor, 3, Void >, public ActorCallback< MonitorGlobalConfigActor, 4, Void >, public FastAllocated<MonitorGlobalConfigActor>, public MonitorGlobalConfigActorState<MonitorGlobalConfigActor> {
															#line 11695 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorGlobalConfigActor>::operator new;
	using FastAllocated<MonitorGlobalConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14851680393926735872UL, 11692331064881067520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >;
friend struct ActorCallback< MonitorGlobalConfigActor, 2, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 3, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 4, Void >;
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 11716 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorGlobalConfigActorState<MonitorGlobalConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619138829789891328UL, 5514350300057065984UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGlobalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorGlobalConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1653 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorGlobalConfigActor(db));
															#line 11753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1741 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 11758 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangingDatacentersActor>
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActorState {
															#line 11765 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActorState(ClusterControllerData* const& self) 
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 11772 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangingDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1744 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 11794 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangingDatacentersActorState();
		static_cast<UpdatedChangingDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11817 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1746 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->desiredDcIds.onChange();
															#line 1747 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->desiredDcIds.get().present())
															#line 11919 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1748 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set(std::make_pair(false, self->desiredDcIds.get()));
															#line 11923 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 1750 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1751 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->desiredDcIds.get().get());
															#line 1753 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set( std::make_pair(worker.priorityInfo.dcFitness > newFitness, self->desiredDcIds.get()));
															#line 1756 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangingDatacenter", self->id) .detail("OldFitness", worker.priorityInfo.dcFitness) .detail("NewFitness", newFitness);
															#line 1759 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.priorityInfo.dcFitness > newFitness)
															#line 11938 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1760 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				worker.priorityInfo.dcFitness = newFitness;
															#line 1761 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!worker.reply.isSet())
															#line 11944 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1762 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.reply.send(RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 11948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				}
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 1765 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1766 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 11958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1793 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onChange;
															#line 1793 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11971 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 3;
															#line 1793 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 11976 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1766 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 12004 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1767 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1768 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1769 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 12014 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1772 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changingDcIds.get().second.get());
															#line 1774 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 12020 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1776 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1777 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1778 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 12028 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1779 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send( RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 12032 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
		}
															#line 1785 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 12039 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1786 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 1786 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12045 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 2;
															#line 1786 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 12050 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1788 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 12077 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1746 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1765 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 12262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangingDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangingDatacentersActor>, public UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor> {
															#line 12267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdatedChangingDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangingDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1858864142465472512UL, 6417636188211580672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangingDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 2, Void >;
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActor(ClusterControllerData* const& self) 
															#line 12286 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7981795789287489024UL, 15976645570533241600UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangingDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangingDatacenters( ClusterControllerData* const& self ) {
															#line 1742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangingDatacentersActor(self));
															#line 12321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1796 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 12326 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangedDatacentersActor>
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActorState {
															#line 12333 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActorState(ClusterControllerData* const& self) 
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1798 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   changeDelay(delay(SERVER_KNOBS->CC_CHANGE_DELAY)),
															#line 1799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   onChange(self->changingDcIds.onChange())
															#line 12344 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangedDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1800 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12359 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangedDatacentersActorState();
		static_cast<UpdatedChangedDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1801 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12391 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1806 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = changeDelay;
															#line 12395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 1806 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 12402 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1803 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 1804 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 12419 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1803 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 1804 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 12430 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1807 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 1808 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 1810 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 1811 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 12445 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1812 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 1813 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 12451 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1814 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1815 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1817 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 12459 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 1819 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 12465 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 12469 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 1825 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 12480 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1807 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 1808 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 1810 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 1811 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 12501 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1812 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 1813 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 12507 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1814 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1815 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1817 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 12515 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 1819 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 12521 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 12525 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 1825 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 12536 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 0, Void >::remove();
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 1826 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 12640 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1827 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1828 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1829 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 12650 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1832 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1835 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 12656 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1837 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1838 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1839 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 12664 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1840 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send(RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 12668 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
		}
															#line 1846 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 12675 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 1847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12681 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 2;
															#line 1847 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 12686 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(int loopDepth) 
	{
															#line 1849 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 12713 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1798 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> changeDelay;
															#line 1799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1825 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 12870 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangedDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangedDatacentersActor>, public UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor> {
															#line 12875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdatedChangedDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangedDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11714316332142605056UL, 848551777652342528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangedDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 2, Void >;
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActor(ClusterControllerData* const& self) 
															#line 12894 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151090047836179200UL, 49094124038652928UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangedDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangedDatacenters( ClusterControllerData* const& self ) {
															#line 1797 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangedDatacentersActor(self));
															#line 12928 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1857 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 12933 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateDatacenterVersionDifferenceActor>
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActorState {
															#line 12940 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActorState(ClusterControllerData* const& self) 
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1859 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   lastLogTime(0)
															#line 12949 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDatacenterVersionDifferenceActorState() 
	{
		fdb_probe_actor_destroy("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1860 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12964 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDatacenterVersionDifferenceActorState();
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1861 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->versionDifferenceUpdated = false;
															#line 1862 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && self->db.config.usableRegions == 1)
															#line 12996 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1864 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1866 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1867 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = 0;
															#line 1868 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = 0;
															#line 1869 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = 0;
															#line 1871 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge)
															#line 13010 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1872 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13014 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 1875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13020 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 1;
															#line 1875 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13025 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1879 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 1880 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 1881 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 13043 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1882 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& logSet : self->db.serverInfo->get().logSystemConfig.tLogs ) {
															#line 1883 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (logSet.isLocal && logSet.locality != tagLocalitySatellite)
															#line 13049 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1884 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 1885 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 13055 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
						{
															#line 1886 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							primaryLog = tLog.interf();
															#line 13059 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
							break;
						}
					}
				}
															#line 1891 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!logSet.isLocal)
															#line 13066 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1892 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 1893 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 13072 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
						{
															#line 1894 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							remoteLog = tLog.interf();
															#line 13076 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
							break;
						}
					}
				}
			}
		}
															#line 1902 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present() || !self->db.serverInfo->get().ratekeeper.present())
															#line 13085 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1903 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 1903 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13091 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 2;
															#line 1903 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 1907 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->db.serverInfo->onChange();
															#line 1908 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13199 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 1909 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 1911 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 1913 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ssVersionLagReply = brokenPromiseToNever( self->db.serverInfo->get().ratekeeper.get().getSSVersionLag.getReply(GetSSVersionLagRequest()));
															#line 1916 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = (success(primaryMetrics) && success(remoteMetrics) && success(ssVersionLagReply)) || onChange;
															#line 1916 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13316 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 3;
															#line 1916 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1917 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13343 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1921 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 13349 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1922 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1924 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1925 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 1926 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 1930 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 1933 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 1935 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 13365 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1936 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13369 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1939 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 13373 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1940 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 1941 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 13379 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13386 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13391 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1917 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1921 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 13406 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1922 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1924 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1925 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 1926 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 1930 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 1933 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 1935 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 13422 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1936 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13426 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1939 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 13430 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1940 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 1941 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 13436 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13443 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 1948 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13448 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1949 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13532 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1949 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13544 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1859 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double lastLogTime;
															#line 1879 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 1880 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 1907 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1909 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 1911 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 1913 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<GetSSVersionLagReply> ssVersionLagReply;
															#line 13643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActor final : public Actor<Void>, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >, public FastAllocated<UpdateDatacenterVersionDifferenceActor>, public UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor> {
															#line 13648 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator new;
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17132058817583078144UL, 17079846126356959744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >;
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActor(ClusterControllerData* const& self) 
															#line 13668 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937717957229000960UL, 3709248056524776448UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDatacenterVersionDifference");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateDatacenterVersionDifference( ClusterControllerData* const& self ) {
															#line 1858 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateDatacenterVersionDifferenceActor(self));
															#line 13704 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1955 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// A background actor that periodically checks remote DC health, and `checkOutstandingRequests` if remote DC
// recovers.
															#line 13711 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRemoteDCHealth()
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateRemoteDCHealthActor>
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActorState {
															#line 13718 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActorState(ClusterControllerData* const& self) 
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 13725 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRemoteDCHealthActorState() 
	{
		fdb_probe_actor_destroy("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1961 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->INITIAL_UPDATE_CROSS_DC_INFO_DELAY);
															#line 1961 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13742 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 1;
															#line 1961 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 13747 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRemoteDCHealthActorState();
		static_cast<UpdateRemoteDCHealthActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1963 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 1967 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 13772 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1968 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13776 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1971 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13780 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1963 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 1967 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 13791 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1968 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13795 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1971 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13799 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1972 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool oldRemoteTransactionSystemDegraded = self->remoteTransactionSystemDegraded;
															#line 1973 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteTransactionSystemDegraded = self->remoteTransactionSystemContainsDegradedServers();
															#line 1975 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (oldRemoteTransactionSystemDegraded && !self->remoteTransactionSystemDegraded)
															#line 13894 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1976 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13898 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1978 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_REMOTE_HEALTH_INTERVAL);
															#line 1978 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13904 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 2;
															#line 1978 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 13909 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 14003 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updateRemoteDCHealth()
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActor final : public Actor<Void>, public ActorCallback< UpdateRemoteDCHealthActor, 0, Void >, public ActorCallback< UpdateRemoteDCHealthActor, 1, Void >, public FastAllocated<UpdateRemoteDCHealthActor>, public UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor> {
															#line 14008 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdateRemoteDCHealthActor>::operator new;
	using FastAllocated<UpdateRemoteDCHealthActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16969770298697633280UL, 11355959485783919360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRemoteDCHealthActor, 0, Void >;
friend struct ActorCallback< UpdateRemoteDCHealthActor, 1, Void >;
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActor(ClusterControllerData* const& self) 
															#line 14026 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4727392956320167168UL, 13078950417560124416UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRemoteDCHealth");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateRemoteDCHealth( ClusterControllerData* const& self ) {
															#line 1958 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateRemoteDCHealthActor(self));
															#line 14060 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1981 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14065 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doEmptyCommit()
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoEmptyCommitActor>
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActorState {
															#line 14072 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActorState(Database const& cx) 
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cx(cx),
															#line 1983 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(cx)
															#line 14081 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoEmptyCommitActorState() 
	{
		fdb_probe_actor_destroy("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1984 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1986 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1987 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1988 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.makeSelfConflicting();
															#line 1989 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 1989 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14135 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 1;
															#line 1989 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 0, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 14140 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1992 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1992 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 2;
															#line 1992 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 1, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 14169 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1990 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 14184 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1990 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 14196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 1983 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Transaction tr;
															#line 14370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doEmptyCommit()
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActor final : public Actor<Void>, public ActorCallback< DoEmptyCommitActor, 0, Void >, public ActorCallback< DoEmptyCommitActor, 1, Void >, public FastAllocated<DoEmptyCommitActor>, public DoEmptyCommitActorState<DoEmptyCommitActor> {
															#line 14375 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoEmptyCommitActor>::operator new;
	using FastAllocated<DoEmptyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7043783521524835584UL, 7951681377237884672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoEmptyCommitActor, 0, Void >;
friend struct ActorCallback< DoEmptyCommitActor, 1, Void >;
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActor(Database const& cx) 
															#line 14393 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoEmptyCommitActorState<DoEmptyCommitActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9964447062675513344UL, 11254058382217442560UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doEmptyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doEmptyCommit( Database const& cx ) {
															#line 1982 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoEmptyCommitActor(cx));
															#line 14427 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 1996 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14432 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via handleForcedRecoveries()
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleForcedRecoveriesActor>
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActorState {
															#line 14439 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 14448 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	~HandleForcedRecoveriesActorState() 
	{
		fdb_probe_actor_destroy("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1998 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14463 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleForcedRecoveriesActorState();
		static_cast<HandleForcedRecoveriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.forceRecovery.getFuture();
															#line 14493 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ForceRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ForceRecoveryRequest>>::value, "invalid type");
															#line 1999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14497 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 1;
															#line 1999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14502 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2000 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryStart", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("DcId", req.dcId.printable());
															#line 2003 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		fCommit = doEmptyCommit(self->cx);
															#line 2004 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = fCommit || delay(SERVER_KNOBS->FORCE_RECOVERY_CHECK_DELAY);
															#line 2004 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14517 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 2;
															#line 2004 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 1, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14522 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest const& __req,int loopDepth) 
	{
															#line 1999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req = __req;
															#line 14531 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2005 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 14610 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2006 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 14614 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2007 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2008 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2009 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2010 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 14624 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 2012 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 14632 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14638 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2005 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 14657 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2006 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 14661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2007 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2008 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2009 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2010 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 14671 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 2012 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 14679 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14685 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2015 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14690 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2017 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryFinish", self->id).log();
															#line 2018 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.forceRecovery = false;
															#line 2019 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 14783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 1999 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ForceRecoveryRequest req;
															#line 2003 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> fCommit;
															#line 14883 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via handleForcedRecoveries()
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActor final : public Actor<Void>, public ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >, public ActorCallback< HandleForcedRecoveriesActor, 1, Void >, public ActorCallback< HandleForcedRecoveriesActor, 2, Void >, public FastAllocated<HandleForcedRecoveriesActor>, public HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor> {
															#line 14888 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<HandleForcedRecoveriesActor>::operator new;
	using FastAllocated<HandleForcedRecoveriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16627608265382515456UL, 14678401081912033024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 1, Void >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 2, Void >;
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 14907 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14107891886794473728UL, 6151159479286482432UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleForcedRecoveries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleForcedRecoveries( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 1997 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleForcedRecoveriesActor(self, interf));
															#line 14942 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2022 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14947 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerAuditStorage()
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TriggerAuditStorageActor>
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActorState {
															#line 14954 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req),
															#line 2024 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   auditId()
															#line 14965 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2025 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(!req.cancel);
															#line 14980 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			try {
															#line 2027 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 14984 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2055 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TriggerAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerAuditStorageActorState(); static_cast<TriggerAuditStorageActor*>(this)->destroy(); return 0; }
															#line 15013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<TriggerAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2046 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCTriggerAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2052 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 15028 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2031 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageBegin", self->id) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2036 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.range, req.engineType);
															#line 2037 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2037 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15049 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2037 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 1, UID >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 15054 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2027 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 15070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2029 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2029 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15078 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2029 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 0, Void >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 15083 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 2038 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2039 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2044 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId_,int loopDepth) 
	{
															#line 2038 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2039 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2044 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15209 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 2024 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID auditId;
															#line 15308 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via triggerAuditStorage()
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActor final : public Actor<Void>, public ActorCallback< TriggerAuditStorageActor, 0, Void >, public ActorCallback< TriggerAuditStorageActor, 1, UID >, public FastAllocated<TriggerAuditStorageActor>, public TriggerAuditStorageActorState<TriggerAuditStorageActor> {
															#line 15313 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TriggerAuditStorageActor>::operator new;
	using FastAllocated<TriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4626459772368981760UL, 4217276497850754816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageActor, 0, Void >;
friend struct ActorCallback< TriggerAuditStorageActor, 1, UID >;
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 15331 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerAuditStorageActorState<TriggerAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12747449799772827392UL, 11482104197366523904UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> triggerAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TriggerAuditStorageActor(self, req));
															#line 15365 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2057 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15370 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via cancelAuditStorage()
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class CancelAuditStorageActor>
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActorState {
															#line 15377 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 15386 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2059 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.cancel);
															#line 15401 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			try {
															#line 2061 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 15405 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2085 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<CancelAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditStorageActorState(); static_cast<CancelAuditStorageActor*>(this)->destroy(); return 0; }
															#line 15434 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<CancelAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2078 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCCancelAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditType", req.getType());
															#line 2082 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(cancel_audit_storage_failed());
															#line 15449 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2065 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageBegin", self->id) .detail("AuditID", req.id) .detail("AuditType", req.getType()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2069 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.id);
															#line 2070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15470 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2070 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 1, UID >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 15475 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2061 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 15491 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2063 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2063 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15499 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2063 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 0, Void >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 15504 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId,int loopDepth) 
	{
															#line 2071 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2076 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15617 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId,int loopDepth) 
	{
															#line 2071 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2075 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2076 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15630 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 15727 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via cancelAuditStorage()
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActor final : public Actor<Void>, public ActorCallback< CancelAuditStorageActor, 0, Void >, public ActorCallback< CancelAuditStorageActor, 1, UID >, public FastAllocated<CancelAuditStorageActor>, public CancelAuditStorageActorState<CancelAuditStorageActor> {
															#line 15732 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<CancelAuditStorageActor>::operator new;
	using FastAllocated<CancelAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16747977446309066496UL, 1912559214464363776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditStorageActor, 0, Void >;
friend struct ActorCallback< CancelAuditStorageActor, 1, UID >;
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 15750 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   CancelAuditStorageActorState<CancelAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10342539104284409856UL, 5939736706038642176UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new CancelAuditStorageActor(self, req));
															#line 15784 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2087 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleTriggerAuditStorageActor>
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActorState {
															#line 15796 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 15805 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~HandleTriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15820 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleTriggerAuditStorageActorState();
		static_cast<HandleTriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2090 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.triggerAudit.getFuture();
															#line 15850 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TriggerAuditRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TriggerAuditRequest>>::value, "invalid type");
															#line 2090 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15854 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2090 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*>(static_cast<HandleTriggerAuditStorageActor*>(this)));
															#line 15859 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest const& req,int loopDepth) 
	{
															#line 2091 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 15870 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2097 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2098 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 15876 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 2100 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 15882 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest && req,int loopDepth) 
	{
															#line 2091 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2096 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 15894 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2097 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2098 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 15900 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 2100 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 15906 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTriggerAuditStorageActor*>(this)->ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest const& value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest && value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 15991 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActor final : public Actor<Void>, public ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >, public FastAllocated<HandleTriggerAuditStorageActor>, public HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor> {
															#line 15996 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<HandleTriggerAuditStorageActor>::operator new;
	using FastAllocated<HandleTriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14744766110990498304UL, 17211846893960871680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >;
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 16013 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15197834898829094656UL, 1920184061417848064UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleTriggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleTriggerAuditStorage( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2088 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleTriggerAuditStorageActor(self, interf));
															#line 16046 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2104 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16051 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startDataDistributor()
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartDataDistributorActor>
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActorState {
															#line 16058 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 16067 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~StartDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16084 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 0, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartDataDistributorActorState();
		static_cast<StartDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16114 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16125 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2113 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			noDistributor = !self->db.serverInfo->get().distributor.present();
															#line 2114 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16219 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2172 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2172 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16236 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 4;
															#line 2172 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 3, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16241 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2167 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruitError", self->id).error(e);
															#line 2168 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 16253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2169 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 16257 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2119 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (noDistributor && self->db.serverInfo->get().distributor.present())
															#line 16273 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2121 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16277 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2124 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> idUsed = self->getUsedIds();
															#line 2125 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo ddWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::DataDistributor, ProcessClass::NeverAssign, self->db.config, idUsed);
															#line 2130 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeDataDistributorRequest req(deterministicRandom()->randomUniqueID());
															#line 2131 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = ddWorker.worker;
															#line 2132 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::DataDistributor))
															#line 16293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2133 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 16297 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 2136 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingDistributorID = req.reqId;
															#line 2137 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitDataDistributor", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", req.reqId);
															#line 2141 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<DataDistributorInterface>> __when_expr_2 = worker.interf.dataDistributor.getReplyUnlessFailedFor( req, SERVER_KNOBS->WAIT_FOR_DISTRIBUTOR_JOIN_DELAY, 0);
															#line 2141 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16307 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2141 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16312 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2114 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 16328 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2117 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2117 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16336 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2117 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 1, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16341 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
															#line 2144 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 16450 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2147 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2148 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2151 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 16462 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2158 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 16468 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2160 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 16472 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 16476 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2163 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16482 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
															#line 2144 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 16496 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2147 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2148 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2151 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 16508 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2158 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 16514 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2160 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 16518 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 16522 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2163 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16528 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddInterf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2113 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool noDistributor;
															#line 2131 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 16721 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via startDataDistributor()
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActor final : public Actor<Void>, public ActorCallback< StartDataDistributorActor, 0, Void >, public ActorCallback< StartDataDistributorActor, 1, Void >, public ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >, public ActorCallback< StartDataDistributorActor, 3, Void >, public FastAllocated<StartDataDistributorActor>, public StartDataDistributorActorState<StartDataDistributorActor> {
															#line 16726 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StartDataDistributorActor>::operator new;
	using FastAllocated<StartDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2140460855326502400UL, 16720346069001967104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartDataDistributorActor, 0, Void >;
friend struct ActorCallback< StartDataDistributorActor, 1, Void >;
friend struct ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >;
friend struct ActorCallback< StartDataDistributorActor, 3, Void >;
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 16746 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StartDataDistributorActorState<StartDataDistributorActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8266636108691840000UL, 3944324526065100544UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startDataDistributor( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2105 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartDataDistributorActor(self, waitTime));
															#line 16782 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2175 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16787 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorDataDistributor()
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorDataDistributorActor>
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActorState {
															#line 16794 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActorState(ClusterControllerData* const& self) 
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2177 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 16803 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2178 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16818 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDataDistributorActorState();
		static_cast<MonitorDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2182 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16841 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2178 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 16857 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16865 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 0, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 16870 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2183 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool ddExist = self->db.serverInfo->get().distributor.present();
															#line 2184 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevInfo, "CCMonitorDataDistributor", self->id) .detail("Recruiting", self->recruitDistributor.get()) .detail("Existing", ddExist) .detail("ExistingDD", ddExist ? self->db.serverInfo->get().distributor.get().id().toString() : "");
															#line 2189 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().distributor.present() && !self->recruitDistributor.get())
															#line 16990 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2191 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo->get().distributor.get().waitFailure, SERVER_KNOBS->DD_FAILURE_TIME);
															#line 2190 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16996 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2198 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitDistributor.onChange();
															#line 17000 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2191 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 1, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 2198 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 2, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 17007 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2201 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startDataDistributor(self, recruitThrottler.newRecruitment());
															#line 2201 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17016 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2201 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 3, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 17021 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2193 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2194 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2195 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 17049 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2193 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2194 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2195 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2196 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 17064 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 1, Void >::remove();
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2177 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	SingletonRecruitThrottler recruitThrottler;
															#line 17293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorDataDistributor()
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActor final : public Actor<Void>, public ActorCallback< MonitorDataDistributorActor, 0, Void >, public ActorCallback< MonitorDataDistributorActor, 1, Void >, public ActorCallback< MonitorDataDistributorActor, 2, Void >, public ActorCallback< MonitorDataDistributorActor, 3, Void >, public FastAllocated<MonitorDataDistributorActor>, public MonitorDataDistributorActorState<MonitorDataDistributorActor> {
															#line 17298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorDataDistributorActor>::operator new;
	using FastAllocated<MonitorDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8747893442072822528UL, 15094957222256097536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDataDistributorActor, 0, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 1, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 2, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 3, Void >;
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActor(ClusterControllerData* const& self) 
															#line 17318 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorDataDistributorActorState<MonitorDataDistributorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3240252173218499840UL, 15914322439490313216UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorDataDistributor( ClusterControllerData* const& self ) {
															#line 2176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorDataDistributorActor(self));
															#line 17353 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2205 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17358 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startRatekeeper()
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartRatekeeperActor>
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActorState {
															#line 17365 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 17374 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~StartRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2209 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2209 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17391 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2209 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 0, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17396 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRatekeeperActorState();
		static_cast<StartRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2211 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2212 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17421 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2211 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2212 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17432 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2214 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			no_ratekeeper = !self->db.serverInfo->get().ratekeeper.present();
															#line 2215 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17526 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17543 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 4;
															#line 2270 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 3, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17548 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruitError", self->id).error(e);
															#line 2266 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 17560 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2267 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17564 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2220 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (no_ratekeeper && self->db.serverInfo->get().ratekeeper.present())
															#line 17580 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2222 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17584 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2225 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();
															#line 2226 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo rkWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::Ratekeeper, ProcessClass::NeverAssign, self->db.config, id_used);
															#line 2231 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeRatekeeperRequest req(deterministicRandom()->randomUniqueID());
															#line 2232 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = rkWorker.worker;
															#line 2233 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::Ratekeeper))
															#line 17600 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2234 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 17604 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 2237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingRatekeeperID = req.reqId;
															#line 2238 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitRatekeeper", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", req.reqId);
															#line 2242 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<RatekeeperInterface>> __when_expr_2 = worker.interf.ratekeeper.getReplyUnlessFailedFor(req, SERVER_KNOBS->WAIT_FOR_RATEKEEPER_JOIN_DELAY, 0);
															#line 2242 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17614 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 3;
															#line 2242 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17619 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2215 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 17635 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17643 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 2;
															#line 2218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 1, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17648 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
															#line 2244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 17757 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2245 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2246 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2247 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2248 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2251 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 17769 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2256 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 17775 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 17779 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 17783 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17789 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
															#line 2244 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 17803 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2245 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2246 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2247 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2248 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2251 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 17815 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2253 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2256 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 17821 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 17825 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2259 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 17829 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17835 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(interf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(interf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2214 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool no_ratekeeper;
															#line 2232 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 18028 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via startRatekeeper()
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActor final : public Actor<Void>, public ActorCallback< StartRatekeeperActor, 0, Void >, public ActorCallback< StartRatekeeperActor, 1, Void >, public ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >, public ActorCallback< StartRatekeeperActor, 3, Void >, public FastAllocated<StartRatekeeperActor>, public StartRatekeeperActorState<StartRatekeeperActor> {
															#line 18033 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StartRatekeeperActor>::operator new;
	using FastAllocated<StartRatekeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17009879816381280512UL, 13827308293473657600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRatekeeperActor, 0, Void >;
friend struct ActorCallback< StartRatekeeperActor, 1, Void >;
friend struct ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >;
friend struct ActorCallback< StartRatekeeperActor, 3, Void >;
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 18053 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StartRatekeeperActorState<StartRatekeeperActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3469128922560809472UL, 14309449484042826496UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRatekeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRatekeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRatekeeperActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartRatekeeperActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startRatekeeper( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2206 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartRatekeeperActor(self, waitTime));
															#line 18089 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
}

#line 2273 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 18094 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorRatekeeper()
															#line 2274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorRatekeeperActor>
															#line 2274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorRatekeeperActorState {
															#line 18101 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorRatekeeperActorState(ClusterControllerData* const& self) 
															#line 2274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2274 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2275 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 18110 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 18125 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRatekeeperActorState();
		static_cast<MonitorRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2280 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18148 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2276 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 18164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2277 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2277 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18172 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2277 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 0, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 18177 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2281 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().ratekeeper.present() && !self->recruitRatekeeper.get())
															#line 18293 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2283 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo