#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
/*
 * TenantGroupCommands.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "metacluster/Metacluster.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

template <class TenantGroupEntryImpl>
void tenantGroupListOutput(std::vector<std::pair<TenantGroupName, TenantGroupEntryImpl>> tenantGroups, int tokensSize) {
	if (tenantGroups.empty()) {
		if (tokensSize == 2) {
			fmt::print("The cluster has no tenant groups\n");
		} else {
			fmt::print("The cluster has no tenant groups in the specified range\n");
		}
	}

	int index = 0;
	for (auto tenantGroup : tenantGroups) {
		fmt::print("  {}. {}\n", ++index, printable(tenantGroup.first));
	}
}

// tenantgroup list command
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
// This generated class is to be used only via tenantGroupListCommand()
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
template <class TenantGroupListCommandActor>
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
class TenantGroupListCommandActorState {
															#line 66 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
public:
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	TenantGroupListCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		 : db(db),
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		   tokens(tokens)
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantGroupListCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantGroupListCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantGroupListCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (tokens.size() > 5)
															#line 90 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("Usage: tenantgroup list [BEGIN] [END] [LIMIT]\n\n");
															#line 61 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("Lists the tenant groups in a cluster.\n");
															#line 62 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("Only tenant groups in the range BEGIN - END will be printed.\n");
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("An optional LIMIT can be specified to limit the number of results (default 100).\n");
															#line 64 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (!static_cast<TenantGroupListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGroupListCommandActorState(); static_cast<TenantGroupListCommandActor*>(this)->destroy(); return 0; }
															#line 102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				new (&static_cast<TenantGroupListCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantGroupListCommandActorState();
				static_cast<TenantGroupListCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			beginTenantGroup = ""_sr;
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			endTenantGroup = "\xff\xff"_sr;
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			limit = 100;
															#line 71 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (tokens.size() >= 3)
															#line 116 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 72 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				beginTenantGroup = tokens[2];
															#line 120 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			}
															#line 74 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (tokens.size() >= 4)
															#line 124 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				endTenantGroup = tokens[3];
															#line 76 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (endTenantGroup <= beginTenantGroup)
															#line 130 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				{
															#line 77 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					fmt::print(stderr, "ERROR: end must be larger than begin");
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					if (!static_cast<TenantGroupListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGroupListCommandActorState(); static_cast<TenantGroupListCommandActor*>(this)->destroy(); return 0; }
															#line 136 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
					new (&static_cast<TenantGroupListCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantGroupListCommandActorState();
					static_cast<TenantGroupListCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 81 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (tokens.size() == 5)
															#line 145 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 82 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				int n = 0;
															#line 83 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (sscanf(tokens[4].toString().c_str(), "%d%n", &limit, &n) != 1 || n != tokens[4].size() || limit <= 0)
															#line 151 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				{
															#line 84 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					fmt::print(stderr, "ERROR: invalid limit `{}'\n", tokens[4].toString());
															#line 85 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					if (!static_cast<TenantGroupListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGroupListCommandActorState(); static_cast<TenantGroupListCommandActor*>(this)->destroy(); return 0; }
															#line 157 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
					new (&static_cast<TenantGroupListCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantGroupListCommandActorState();
					static_cast<TenantGroupListCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			tr = db->createTransaction();
															#line 91 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			;
															#line 168 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantGroupListCommandActorState();
		static_cast<TenantGroupListCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 93 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 203 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 1;
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantGroupListCommandActor, 0, ClusterType >*>(static_cast<TenantGroupListCommandActor*>(this)));
															#line 208 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 109 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 232 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantGroupListCommandActor, 3, Void >*>(static_cast<TenantGroupListCommandActor*>(this)));
															#line 237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 96 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 252 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		{
															#line 97 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>>> __when_expr_1 = metacluster::listTenantGroupsTransaction(tr, beginTenantGroup, endTenantGroup, limit);
															#line 97 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 258 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 2;
															#line 97 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >*>(static_cast<TenantGroupListCommandActor*>(this)));
															#line 263 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>> __when_expr_2 = TenantAPI::listTenantGroupsTransaction(tr, beginTenantGroup, endTenantGroup, limit);
															#line 102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 272 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*>(static_cast<TenantGroupListCommandActor*>(this)));
															#line 277 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		clusterType = __clusterType;
															#line 287 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupListCommandActor*>(this)->ActorCallback< TenantGroupListCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantGroupListCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 107 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (!static_cast<TenantGroupListCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantGroupListCommandActorState(); static_cast<TenantGroupListCommandActor*>(this)->destroy(); return 0; }
															#line 366 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		new (&static_cast<TenantGroupListCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantGroupListCommandActorState();
		static_cast<TenantGroupListCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> const& metaclusterTenantGroups,int loopDepth) 
	{
															#line 100 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupListOutput(metaclusterTenantGroups, tokens.size());
															#line 378 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> && metaclusterTenantGroups,int loopDepth) 
	{
															#line 100 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupListOutput(metaclusterTenantGroups, tokens.size());
															#line 387 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> const& metaclusterTenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(metaclusterTenantGroups, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> && metaclusterTenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(metaclusterTenantGroups), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupListCommandActor*>(this)->ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
															#line 104 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupListOutput(tenantGroups, tokens.size());
															#line 471 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
															#line 104 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupListOutput(tenantGroups, tokens.size());
															#line 480 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(tenantGroups, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(tenantGroups), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupListCommandActor*>(this)->ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupListCommandActor*>(this)->ActorCallback< TenantGroupListCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantGroupListCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantGroupListCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	StringRef beginTenantGroup;
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	StringRef endTenantGroup;
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	int limit;
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	ClusterType clusterType;
															#line 661 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantGroupListCommand()
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
class TenantGroupListCommandActor final : public Actor<bool>, public ActorCallback< TenantGroupListCommandActor, 0, ClusterType >, public ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >, public ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >, public ActorCallback< TenantGroupListCommandActor, 3, Void >, public FastAllocated<TenantGroupListCommandActor>, public TenantGroupListCommandActorState<TenantGroupListCommandActor> {
															#line 666 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
public:
	using FastAllocated<TenantGroupListCommandActor>::operator new;
	using FastAllocated<TenantGroupListCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4454440039032203264UL, 5835686042486274048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantGroupListCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >;
friend struct ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >;
friend struct ActorCallback< TenantGroupListCommandActor, 3, Void >;
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	TenantGroupListCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 686 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantGroupListCommandActorState<TenantGroupListCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17838772149809171456UL, 2342623083843471872UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantGroupListCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantGroupListCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantGroupListCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantGroupListCommandActor, 1, std::vector<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantGroupListCommandActor, 2, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantGroupListCommandActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantGroupListCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	return Future<bool>(new TenantGroupListCommandActor(db, tokens));
															#line 721 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
}

#line 113 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"

void tenantGroupGetOutput(metacluster::MetaclusterTenantGroupEntry entry, bool useJson) {
	if (useJson) {
		json_spirit::mObject resultObj;
		resultObj["tenant_group"] = entry.toJson();
		resultObj["type"] = "success";
		fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print));
	} else {
		fmt::print("  assigned cluster: {}\n", printable(entry.assignedCluster));
	}
}
void tenantGroupGetOutput(TenantGroupEntry entry, bool useJson) {
	if (useJson) {
		json_spirit::mObject resultObj;
		resultObj["tenant_group"] = entry.toJson();
		resultObj["type"] = "success";
		fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print));
	} else {
		// This is a placeholder output for when a tenant group is read in a non-metacluster, where
		// it currently has no metadata. When metadata is eventually added, we can print that instead.
		fmt::print("The tenant group is present in the cluster\n");
	}
}

// tenantgroup get command
															#line 750 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
// This generated class is to be used only via tenantGroupGetCommand()
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
template <class TenantGroupGetCommandActor>
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
class TenantGroupGetCommandActorState {
															#line 756 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
public:
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	TenantGroupGetCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		 : db(db),
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		   tokens(tokens)
															#line 765 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantGroupGetCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (tokens.size() > 4 || tokens.size() < 3 || (tokens.size() == 4 && tokens[3] != "JSON"_sr))
															#line 780 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("Usage: tenantgroup get <NAME> [JSON]\n\n");
															#line 141 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("Prints metadata associated with the given tenant group.\n");
															#line 142 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 143 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (!static_cast<TenantGroupGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGroupGetCommandActorState(); static_cast<TenantGroupGetCommandActor*>(this)->destroy(); return 0; }
															#line 790 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				new (&static_cast<TenantGroupGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantGroupGetCommandActorState();
				static_cast<TenantGroupGetCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			useJson = tokens.size() == 4;
															#line 147 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			tr = db->createTransaction();
															#line 149 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			;
															#line 802 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantGroupGetCommandActorState();
		static_cast<TenantGroupGetCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 152 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 152 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 837 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 1;
															#line 152 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >*>(static_cast<TenantGroupGetCommandActor*>(this)));
															#line 842 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 171 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 171 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 867 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 4;
															#line 171 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantGroupGetCommandActor, 3, Void >*>(static_cast<TenantGroupGetCommandActor*>(this)));
															#line 872 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 153 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 893 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<Optional<metacluster::MetaclusterTenantGroupEntry>> __when_expr_1 = metacluster::tryGetTenantGroupTransaction(tr, tokens[2]);
															#line 154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 899 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 2;
															#line 154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >*>(static_cast<TenantGroupGetCommandActor*>(this)));
															#line 904 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			StrictFuture<Optional<TenantGroupEntry>> __when_expr_2 = TenantAPI::tryGetTenantGroupTransaction(tr, tokens[2]);
															#line 161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 913 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 3;
															#line 161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >*>(static_cast<TenantGroupGetCommandActor*>(this)));
															#line 918 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 152 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		clusterType = __clusterType;
															#line 928 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupGetCommandActor*>(this)->ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 168 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (!static_cast<TenantGroupGetCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantGroupGetCommandActorState(); static_cast<TenantGroupGetCommandActor*>(this)->destroy(); return 0; }
															#line 1007 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		new (&static_cast<TenantGroupGetCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantGroupGetCommandActorState();
		static_cast<TenantGroupGetCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 156 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (!mEntry.present())
															#line 1019 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		{
															#line 157 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 1023 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		}
															#line 159 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupGetOutput(mEntry.get(), useJson);
															#line 1027 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<metacluster::MetaclusterTenantGroupEntry> const& __mEntry,int loopDepth) 
	{
															#line 154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		mEntry = __mEntry;
															#line 1036 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<metacluster::MetaclusterTenantGroupEntry> && __mEntry,int loopDepth) 
	{
		mEntry = std::move(__mEntry);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupGetCommandActor*>(this)->ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Optional<metacluster::MetaclusterTenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Optional<metacluster::MetaclusterTenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 162 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		if (!entry.present())
															#line 1115 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 1119 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		}
															#line 165 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		tenantGroupGetOutput(entry.get(), useJson);
															#line 1123 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<TenantGroupEntry> const& __entry,int loopDepth) 
	{
															#line 161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
		entry = __entry;
															#line 1132 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<TenantGroupEntry> && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupGetCommandActor*>(this)->ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& finalErr,int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			errorStr = std::string();
															#line 174 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (finalErr.code() == error_code_tenant_not_found)
															#line 1220 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 175 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				errorStr = "tenant group not found";
															#line 1224 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			}
			else
			{
															#line 176 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				if (useJson)
															#line 1230 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				{
															#line 177 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					errorStr = finalErr.what();
															#line 1234 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				}
				else
				{
															#line 179 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
					return a_body1Catch1(finalErr, std::max(0, loopDepth - 1));
															#line 1240 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
				}
			}
															#line 182 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (useJson)
															#line 1245 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				json_spirit::mObject resultObj;
															#line 184 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				resultObj["type"] = "error";
															#line 185 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				resultObj["error"] = errorStr;
															#line 186 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print));
															#line 1255 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			}
			else
			{
															#line 189 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
				fmt::print(stderr, "ERROR: {}\n", errorStr);
															#line 1261 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			}
															#line 192 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
			if (!static_cast<TenantGroupGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGroupGetCommandActorState(); static_cast<TenantGroupGetCommandActor*>(this)->destroy(); return 0; }
															#line 1265 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
			new (&static_cast<TenantGroupGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantGroupGetCommandActorState();
			static_cast<TenantGroupGetCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGroupGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGroupGetCommandActor*>(this)->ActorCallback< TenantGroupGetCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantGroupGetCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantGroupGetCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 146 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	bool useJson;
															#line 147 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 152 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	ClusterType clusterType;
															#line 154 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Optional<metacluster::MetaclusterTenantGroupEntry> mEntry;
															#line 161 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	Optional<TenantGroupEntry> entry;
															#line 173 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	std::string errorStr;
															#line 1395 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantGroupGetCommand()
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
class TenantGroupGetCommandActor final : public Actor<bool>, public ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >, public ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >, public ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >, public ActorCallback< TenantGroupGetCommandActor, 3, Void >, public FastAllocated<TenantGroupGetCommandActor>, public TenantGroupGetCommandActorState<TenantGroupGetCommandActor> {
															#line 1400 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
public:
	using FastAllocated<TenantGroupGetCommandActor>::operator new;
	using FastAllocated<TenantGroupGetCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14745543295674899712UL, 3072536500023156224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >;
friend struct ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >;
friend struct ActorCallback< TenantGroupGetCommandActor, 3, Void >;
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	TenantGroupGetCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1420 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantGroupGetCommandActorState<TenantGroupGetCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2103778864151867392UL, 10943945746392711168UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGroupGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantGroupGetCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantGroupGetCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantGroupGetCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantGroupGetCommandActor, 1, Optional<metacluster::MetaclusterTenantGroupEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantGroupGetCommandActor, 2, Optional<TenantGroupEntry> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantGroupGetCommandActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantGroupGetCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 138 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"
	return Future<bool>(new TenantGroupGetCommandActor(db, tokens));
															#line 1455 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/TenantGroupCommands.actor.g.cpp"
}

#line 197 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/TenantGroupCommands.actor.cpp"

// tenantgroup command
Future<bool> tenantGroupCommand(Reference<IDatabase> db, std::vector<StringRef> tokens) {
	if (tokens.size() == 1) {
		printUsage(tokens[0]);
		return true;
	} else if (tokencmp(tokens[1], "list")) {
		return tenantGroupListCommand(db, tokens);
	} else if (tokencmp(tokens[1], "get")) {
		return tenantGroupGetCommand(db, tokens);
	} else {
		printUsage(tokens[0]);
		return true;
	}
}

void tenantGroupGenerator(const char* text,
                          const char* line,
                          std::vector<std::string>& lc,
                          std::vector<StringRef> const& tokens) {
	if (tokens.size() == 1) {
		const char* opts[] = { "list", "get", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() == 3 && tokencmp(tokens[1], "get")) {
		const char* opts[] = { "JSON", nullptr };
		arrayGenerator(text, line, opts, lc);
	}
}

std::vector<const char*> tenantGroupHintGenerator(std::vector<StringRef> const& tokens, bool inArgument) {
	if (tokens.size() == 1) {
		return { "<list|get>", "[ARGS]" };
	} else if (tokencmp(tokens[1], "list") && tokens.size() < 5) {
		static std::vector<const char*> opts = { "[BEGIN]", "[END]", "[LIMIT]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "get") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<NAME>", "[JSON]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else {
		return {};
	}
}

CommandFactory tenantGroupRegisterFactory("tenantgroup",
                                          CommandHelp("tenantgroup <list|get> [ARGS]",
                                                      "view tenant group information",
                                                      "`list' prints a list of tenant groups in the cluster.\n"
                                                      "`get' prints the metadata for a particular tenant group.\n"),
                                          &tenantGroupGenerator,
                                          &tenantGroupHintGenerator);

} // namespace fdb_cli
