#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
/*
 * IdempotencyIdsCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/IdempotencyId.actor.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/json_spirit/json_spirit_reader_template.h"
#include "flow/actorcompiler.h" // This must be the last include

namespace {

Optional<double> parseAgeValue(StringRef token) {
	try {
		return std::stod(token.toString());
	} catch (...) {
		return {};
	}
}

} // namespace

namespace fdb_cli {

															#line 43 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
// This generated class is to be used only via idempotencyIdsCommandActor()
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
template <class IdempotencyIdsCommandActorActor>
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
class IdempotencyIdsCommandActorActorState {
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
public:
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
	IdempotencyIdsCommandActorActorState(Database const& db,std::vector<StringRef> const& tokens) 
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		 : db(db),
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		   tokens(tokens)
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~IdempotencyIdsCommandActorActorState() 
	{
		fdb_probe_actor_destroy("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
			if (tokens.size() < 2 || tokens.size() > 3)
															#line 73 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
			{
															#line 43 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 44 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
				if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
				new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~IdempotencyIdsCommandActorActorState();
				static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 46 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
				auto const action = tokens[1];
															#line 47 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
				if (action == "status"_sr)
															#line 91 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
				{
															#line 48 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
					if (tokens.size() != 2)
															#line 95 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
					{
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 50 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 101 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~IdempotencyIdsCommandActorActorState();
						static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
					StrictFuture<JsonBuilderObject> __when_expr_0 = getIdmpKeyStatus(db);
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
					if (static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >*>(static_cast<IdempotencyIdsCommandActorActor*>(this)));
															#line 116 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 55 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
					if (action == "clear"_sr)
															#line 123 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
					{
															#line 56 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 127 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						{
															#line 57 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 58 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
							if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 133 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
							new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~IdempotencyIdsCommandActorActorState();
							static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						auto const age = parseAgeValue(tokens[2]);
															#line 61 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						if (!age.present())
															#line 143 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						{
															#line 62 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 63 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
							if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 149 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
							new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~IdempotencyIdsCommandActorActorState();
							static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = cleanIdempotencyIds(db, age.get());
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						if (static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 159 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state = 2;
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >*>(static_cast<IdempotencyIdsCommandActorActor*>(this)));
															#line 164 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 70 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
						if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 173 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
						new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~IdempotencyIdsCommandActorActorState();
						static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IdempotencyIdsCommandActorActorState();
		static_cast<IdempotencyIdsCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(JsonBuilderObject const& status,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		fmt::print("{}\n", status.getJson());
															#line 54 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 204 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
		new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IdempotencyIdsCommandActorActorState();
		static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(JsonBuilderObject && status,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		fmt::print("{}\n", status.getJson());
															#line 54 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 218 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
		new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IdempotencyIdsCommandActorActorState();
		static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(JsonBuilderObject const& status,int loopDepth) 
	{
		loopDepth = a_body1cont4(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(JsonBuilderObject && status,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsCommandActorActor*>(this)->ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >::remove();

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >*,JsonBuilderObject const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >*,JsonBuilderObject && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		fmt::print("Successfully cleared idempotency IDs.\n");
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 307 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
		new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IdempotencyIdsCommandActorActorState();
		static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		fmt::print("Successfully cleared idempotency IDs.\n");
															#line 67 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
		if (!static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IdempotencyIdsCommandActorActorState(); static_cast<IdempotencyIdsCommandActorActor*>(this)->destroy(); return 0; }
															#line 321 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
		new (&static_cast<IdempotencyIdsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IdempotencyIdsCommandActorActorState();
		static_cast<IdempotencyIdsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsCommandActorActor*>(this)->ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
	Database db;
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 408 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
};
// This generated class is to be used only via idempotencyIdsCommandActor()
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
class IdempotencyIdsCommandActorActor final : public Actor<bool>, public ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >, public ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >, public FastAllocated<IdempotencyIdsCommandActorActor>, public IdempotencyIdsCommandActorActorState<IdempotencyIdsCommandActorActor> {
															#line 413 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
public:
	using FastAllocated<IdempotencyIdsCommandActorActor>::operator new;
	using FastAllocated<IdempotencyIdsCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14048494450917619200UL, 18243853876934006528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >;
friend struct ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >;
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
	IdempotencyIdsCommandActorActor(Database const& db,std::vector<StringRef> const& tokens) 
															#line 431 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
		 : Actor<bool>(),
		   IdempotencyIdsCommandActorActorState<IdempotencyIdsCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15278168372243649024UL, 3863007396123127552UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("idempotencyIdsCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("idempotencyIdsCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IdempotencyIdsCommandActorActor, 0, JsonBuilderObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IdempotencyIdsCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
[[nodiscard]] Future<bool> idempotencyIdsCommandActor( Database const& db, std::vector<StringRef> const& tokens ) {
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"
	return Future<bool>(new IdempotencyIdsCommandActorActor(db, tokens));
															#line 464 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/fdbcli/IdempotencyIdsCommand.actor.g.cpp"
}

#line 74 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/fdbcli/IdempotencyIdsCommand.actor.cpp"

CommandFactory idempotencyIdsCommandFactory(
    "idempotencyids",
    CommandHelp(
        "idempotencyids [status | clear <min_age_seconds>]",
        "View status of idempotency ids, or reclaim space used by idempotency ids older than the given age",
        "View status of idempotency ids currently in the cluster, or reclaim space by clearing all the idempotency ids "
        "older than min_age_seconds (which will expire all transaction versions older than this age)\n"));

} // namespace fdb_cli
