#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
/*
 * HighContentionAllocator.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "HighContentionAllocator.h"

namespace FDB {
															#line 26 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
// This generated class is to be used only via _allocate()
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
template <class _allocateActor>
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
class _allocateActorState {
															#line 32 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
public:
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	_allocateActorState(Reference<Transaction> const& tr,Subspace const& counters,Subspace const& recent) 
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		 : tr(tr),
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		   counters(counters),
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		   recent(recent),
															#line 25 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		   start(0),
															#line 26 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		   window(0)
															#line 47 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
	{
		fdb_probe_actor_create("_allocate", reinterpret_cast<unsigned long>(this));

	}
	~_allocateActorState() 
	{
		fdb_probe_actor_destroy("_allocate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 28 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			;
															#line 62 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_allocateActorState();
		static_cast<_allocateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 29 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(counters.range(), 1, true, true);
															#line 29 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (static_cast<_allocateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 94 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_allocateActor*>(this)->actor_wait_state = 1;
															#line 29 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >*>(static_cast<_allocateActor*>(this)));
															#line 99 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(FDBStandalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 31 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (range.size() > 0)
															#line 108 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 32 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			start = counters.unpack(range[0].key).getInt(0);
															#line 112 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		windowAdvanced = false;
															#line 36 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		;
															#line 118 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(FDBStandalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 31 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (range.size() > 0)
															#line 127 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 32 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			start = counters.unpack(range[0].key).getInt(0);
															#line 131 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		windowAdvanced = false;
															#line 36 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		;
															#line 137 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_allocateActor*>(this)->actor_wait_state > 0) static_cast<_allocateActor*>(this)->actor_wait_state = 0;
		static_cast<_allocateActor*>(this)->ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 68 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		;
															#line 221 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 38 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (windowAdvanced)
															#line 237 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 39 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			tr->clear(KeyRangeRef(counters.key(), counters.get(start).key()));
															#line 40 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			tr->setOption(FDBTransactionOption::FDB_TR_OPTION_NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 41 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			tr->clear(KeyRangeRef(recent.key(), recent.get(start).key()));
															#line 245 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 44 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		int64_t inc = 1;
															#line 45 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		tr->atomicOp(counters.get(start).key(), StringRef((uint8_t*)&inc, 8), FDB_MUTATION_TYPE_ADD);
															#line 46 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		Future<Optional<FDBStandalone<ValueRef>>> countFuture = tr->get(counters.get(start).key(), true);
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_1 = countFuture;
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (static_cast<_allocateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 257 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_allocateActor*>(this)->actor_wait_state = 2;
															#line 49 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >*>(static_cast<_allocateActor*>(this)));
															#line 262 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Optional<FDBStandalone<ValueRef>> const& countValue,int loopDepth) 
	{
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		int64_t count = 0;
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (countValue.present())
															#line 286 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			if (countValue.get().size() != 8)
															#line 290 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			{
															#line 54 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
				return a_body1Catch1(invalid_directory_layer_metadata(), std::max(0, loopDepth - 2));
															#line 294 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			}
															#line 56 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			count = *(int64_t*)countValue.get().begin();
															#line 298 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		window = HighContentionAllocator::windowSize(start);
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (count * 2 < window)
															#line 304 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 64 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		start += window;
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		windowAdvanced = true;
															#line 312 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Optional<FDBStandalone<ValueRef>> && countValue,int loopDepth) 
	{
															#line 51 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		int64_t count = 0;
															#line 52 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (countValue.present())
															#line 323 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			if (countValue.get().size() != 8)
															#line 327 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			{
															#line 54 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
				return a_body1Catch1(invalid_directory_layer_metadata(), std::max(0, loopDepth - 2));
															#line 331 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			}
															#line 56 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			count = *(int64_t*)countValue.get().begin();
															#line 335 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 59 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		window = HighContentionAllocator::windowSize(start);
															#line 60 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (count * 2 < window)
															#line 341 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 64 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		start += window;
															#line 65 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		windowAdvanced = true;
															#line 349 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<FDBStandalone<ValueRef>> const& countValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(countValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<FDBStandalone<ValueRef>> && countValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(countValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_allocateActor*>(this)->actor_wait_state > 0) static_cast<_allocateActor*>(this)->actor_wait_state = 0;
		static_cast<_allocateActor*>(this)->ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		candidate = deterministicRandom()->randomInt(start, start + window);
															#line 72 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		latestCounter = tr->getRange(counters.range(), 1, true, true);
															#line 73 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		candidateValue = tr->get(recent.get(candidate).key());
															#line 74 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		tr->setOption(FDBTransactionOption::FDB_TR_OPTION_NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 75 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		tr->set(recent.get(candidate).key(), ValueRef());
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(latestCounter) && success(candidateValue);
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (static_cast<_allocateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 458 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_allocateActor*>(this)->actor_wait_state = 3;
															#line 78 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _allocateActor, 2, Void >*>(static_cast<_allocateActor*>(this)));
															#line 463 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		int64_t currentWindowStart = 0;
															#line 80 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (latestCounter.get().size() > 0)
															#line 487 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			currentWindowStart = counters.unpack(latestCounter.get()[0].key).getInt(0);
															#line 491 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 84 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (currentWindowStart > start)
															#line 495 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (!candidateValue.get().present())
															#line 501 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			tr->addWriteConflictKey(recent.get(candidate).key());
															#line 90 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			if (!static_cast<_allocateActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Tuple().append(candidate).pack()); this->~_allocateActorState(); static_cast<_allocateActor*>(this)->destroy(); return 0; }
															#line 507 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			new (&static_cast<_allocateActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Tuple().append(candidate).pack());
			this->~_allocateActorState();
			static_cast<_allocateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		int64_t currentWindowStart = 0;
															#line 80 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (latestCounter.get().size() > 0)
															#line 523 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			currentWindowStart = counters.unpack(latestCounter.get()[0].key).getInt(0);
															#line 527 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		}
															#line 84 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (currentWindowStart > start)
															#line 531 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 88 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
		if (!candidateValue.get().present())
															#line 537 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		{
															#line 89 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			tr->addWriteConflictKey(recent.get(candidate).key());
															#line 90 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
			if (!static_cast<_allocateActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Tuple().append(candidate).pack()); this->~_allocateActorState(); static_cast<_allocateActor*>(this)->destroy(); return 0; }
															#line 543 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
			new (&static_cast<_allocateActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Tuple().append(candidate).pack());
			this->~_allocateActorState();
			static_cast<_allocateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_allocateActor*>(this)->actor_wait_state > 0) static_cast<_allocateActor*>(this)->actor_wait_state = 0;
		static_cast<_allocateActor*>(this)->ActorCallback< _allocateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _allocateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _allocateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _allocateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	Reference<Transaction> tr;
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	Subspace counters;
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	Subspace recent;
															#line 25 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	int64_t start;
															#line 26 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	int64_t window;
															#line 35 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	bool windowAdvanced;
															#line 69 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	int64_t candidate;
															#line 72 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	Future<FDBStandalone<RangeResultRef>> latestCounter;
															#line 73 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	Future<Optional<FDBStandalone<ValueRef>>> candidateValue;
															#line 646 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
};
// This generated class is to be used only via _allocate()
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
class _allocateActor final : public Actor<Standalone<StringRef>>, public ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >, public ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >, public ActorCallback< _allocateActor, 2, Void >, public FastAllocated<_allocateActor>, public _allocateActorState<_allocateActor> {
															#line 651 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
public:
	using FastAllocated<_allocateActor>::operator new;
	using FastAllocated<_allocateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7014979412484748800UL, 9125869512758279680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >;
friend struct ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >;
friend struct ActorCallback< _allocateActor, 2, Void >;
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	_allocateActor(Reference<Transaction> const& tr,Subspace const& counters,Subspace const& recent) 
															#line 670 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   _allocateActorState<_allocateActor>(tr, counters, recent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_allocate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1352776299070911232UL, 9793560287748375296UL);
		ActorExecutionContextHelper __helper(static_cast<_allocateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_allocate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_allocate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _allocateActor, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _allocateActor, 1, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _allocateActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> _allocate( Reference<Transaction> const& tr, Subspace const& counters, Subspace const& recent ) {
															#line 24 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"
	return Future<Standalone<StringRef>>(new _allocateActor(tr, counters, recent));
															#line 704 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/build_output/bindings/flow/HighContentionAllocator.actor.g.cpp"
}

#line 95 "/codebuild/output/src4025437609/src/github.com/apple/foundationdb/bindings/flow/HighContentionAllocator.actor.cpp"

Future<Standalone<StringRef>> HighContentionAllocator::allocate(Reference<Transaction> const& tr) const {
	return _allocate(tr, counters, recent);
}

int64_t HighContentionAllocator::windowSize(int64_t start) {
	if (start < 255) {
		return 64;
	}
	if (start < 65535) {
		return 1024;
	}

	return 8192;
}
} // namespace FDB
