#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
/*
 * worker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdlib>
#include <tuple>
#include <boost/lexical_cast.hpp>
#include <unordered_map>

#include "fdbclient/FDBTypes.h"
#include "flow/ApiVersion.h"
#include "flow/Buggify.h"
#include "flow/CodeProbe.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/Locality.h"
#include "fdbclient/GetEncryptCipherKeys_impl.actor.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/versions.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/NetworkAddress.h"
#include "fdbrpc/FlowGrpc.h"
#include "flow/ObjectSerializer.h"
#include "flow/Platform.h"
#include "flow/ProtocolVersion.h"
#include "flow/SystemMonitor.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/MetricLogger.actor.h"
#include "fdbserver/BackupInterface.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbserver/RoleLineage.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h" // for poisson()
#include "fdbserver/IDiskQueue.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ClientWorkerInterface.h"
#include "flow/Profiler.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include "flow/ChaosMetrics.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "flow/ApiVersion.h"
#include "fdbctl/ControlService.h"

#ifdef __linux__
#include <fcntl.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(__linux__) || defined(__FreeBSD__)
#ifdef USE_GPERFTOOLS
#include "gperftools/profiler.h"
#include "gperftools/heap-profiler.h"
#endif
#include <unistd.h>
#include <execinfo.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

#if CENABLED(0, NOT_IN_CLEAN)
extern IKeyValueStore* keyValueStoreCompressTestData(IKeyValueStore* store);
#define KV_STORE(filename, uid) keyValueStoreCompressTestData(keyValueStoreSQLite(filename, uid))
#elif CENABLED(0, NOT_IN_CLEAN)
#define KV_STORE(filename, uid) keyValueStoreSQLite(filename, uid)
#else
#define KV_STORE(filename, uid) keyValueStoreMemory(filename, uid)
#endif

template class RequestStream<RecruitMasterRequest, false>;
template struct NetNotifiedQueue<RecruitMasterRequest, false>;

template class RequestStream<RegisterMasterRequest, false>;
template struct NetNotifiedQueue<RegisterMasterRequest, false>;

template class RequestStream<InitializeCommitProxyRequest, false>;
template struct NetNotifiedQueue<InitializeCommitProxyRequest, false>;

template class RequestStream<InitializeGrvProxyRequest, false>;
template struct NetNotifiedQueue<InitializeGrvProxyRequest, false>;

template class RequestStream<GetServerDBInfoRequest, false>;
template struct NetNotifiedQueue<GetServerDBInfoRequest, false>;
template class GetEncryptCipherKeys<ServerDBInfo>;

namespace {
RoleLineageCollector roleLineageCollector;
}

															#line 130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TryDBInfoBroadcastActor>
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActorState {
															#line 137 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActorState(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : stream(stream),
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(req)
															#line 146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~TryDBInfoBroadcastActorState() 
	{
		fdb_probe_actor_destroy("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<std::vector<Endpoint>>> __when_expr_0 = stream.getReplyUnlessFailedFor(req, SERVER_KNOBS->DBINFO_FAILED_DELAY, 0);
															#line 130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*>(static_cast<TryDBInfoBroadcastActor*>(this)));
															#line 168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 191 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 136 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 205 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 136 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 231 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state > 0) static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<TryDBInfoBroadcastActor*>(this)->ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >::remove();

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> const& value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> && value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,Error err) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RequestStream<UpdateServerDBInfoRequest> stream;
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >, public FastAllocated<TryDBInfoBroadcastActor>, public TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor> {
															#line 323 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TryDBInfoBroadcastActor>::operator new;
	using FastAllocated<TryDBInfoBroadcastActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1591248097663792384UL, 2223455914619048704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >;
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActor(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor>(stream, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4829059694717746176UL, 12815649290741346816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryDBInfoBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> tryDBInfoBroadcast( RequestStream<UpdateServerDBInfoRequest> const& stream, UpdateServerDBInfoRequest const& req ) {
															#line 128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new TryDBInfoBroadcastActor(stream, req));
															#line 373 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 138 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class BroadcastDBInfoRequestActor>
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActorState {
															#line 385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActorState(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req),
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendAmount(sendAmount),
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sender(sender),
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendReply(sendReply),
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   replies(),
															#line 144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   reply(req.reply)
															#line 402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastDBInfoRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			resetReply(req);
															#line 146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			int currentStream = 0;
															#line 147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				RequestStream<UpdateServerDBInfoRequest> cur(broadcastEndpoints[currentStream++]);
															#line 151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				replies.push_back(tryDBInfoBroadcast(cur, req));
															#line 156 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				resetReply(req);
															#line 439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*>(static_cast<BroadcastDBInfoRequestActor*>(this)));
															#line 450 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 489 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 515 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 521 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 525 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 529 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 533 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastDBInfoRequestActor*>(this)->ActorCallback< BroadcastDBInfoRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int sendAmount;
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Endpoint> sender;
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool sendReply;
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<std::vector<Endpoint>>> replies;
															#line 144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ReplyPromise<std::vector<Endpoint>> reply;
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< BroadcastDBInfoRequestActor, 0, Void >, public FastAllocated<BroadcastDBInfoRequestActor>, public BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor> {
															#line 633 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<BroadcastDBInfoRequestActor>::operator new;
	using FastAllocated<BroadcastDBInfoRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7421511980611024640UL, 17571315915364235520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastDBInfoRequestActor, 0, Void >;
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActor(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 650 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor>(req, sendAmount, sender, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7360236551166211584UL, 3807311166382409728UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastDBInfoRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> broadcastDBInfoRequest( UpdateServerDBInfoRequest const& req, int const& sendAmount, Optional<Endpoint> const& sender, bool const& sendReply ) {
															#line 139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new BroadcastDBInfoRequestActor(req, sendAmount, sender, sendReply));
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 171 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via extractClientInfo()
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClientInfoActor>
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActorState {
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   info(info),
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxyUIDs(),
															#line 175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxies(),
															#line 176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxyUIDs(),
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxies()
															#line 712 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClientInfoActorState() 
	{
		fdb_probe_actor_destroy("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClientInfoActorState();
		static_cast<ExtractClientInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ClientDBInfo ni = db->get().client;
															#line 180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		shrinkProxyList(ni, lastCommitProxyUIDs, lastCommitProxies, lastGrvProxyUIDs, lastGrvProxies);
															#line 181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		info->setUnconditional(ni);
															#line 182 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 182 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 765 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClientInfoActor, 0, Void >*>(static_cast<ExtractClientInfoActor*>(this)));
															#line 770 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state > 0) static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClientInfoActor*>(this)->ActorCallback< ExtractClientInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClientInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClientDBInfo>> info;
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastCommitProxyUIDs;
															#line 175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<CommitProxyInterface> lastCommitProxies;
															#line 176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastGrvProxyUIDs;
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<GrvProxyInterface> lastGrvProxies;
															#line 874 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via extractClientInfo()
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActor final : public Actor<Void>, public ActorCallback< ExtractClientInfoActor, 0, Void >, public FastAllocated<ExtractClientInfoActor>, public ExtractClientInfoActorState<ExtractClientInfoActor> {
															#line 879 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ExtractClientInfoActor>::operator new;
	using FastAllocated<ExtractClientInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17215389742911570176UL, 8036983004658171392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClientInfoActor, 0, Void >;
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ExtractClientInfoActorState<ExtractClientInfoActor>(db, info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(936284430390917120UL, 5465665005456452352UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClientInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClientInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] static Future<Void> extractClientInfo( Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<ClientDBInfo>> const& info ) {
															#line 172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClientInfoActor(db, info));
															#line 929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 185 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Database openDBOnServer(Reference<AsyncVar<ServerDBInfo> const> const& db,
                        TaskPriority taskID,
                        LockAware lockAware,
                        EnableLocalityLoadBalance enableLocalityLoadBalance) {
	auto info = makeReference<AsyncVar<ClientDBInfo>>();
	auto cx = DatabaseContext::create(info,
	                                  extractClientInfo(db, info),
	                                  enableLocalityLoadBalance ? db->get().myLocality : LocalityData(),
	                                  enableLocalityLoadBalance,
	                                  taskID,
	                                  lockAware);
	cx->globalConfig->init(db, std::addressof(db->get().client));
	cx->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	cx->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);
	return cx;
}

struct ErrorInfo {
	Error error;
	const Role& role;
	UID id;
	ErrorInfo(Error e, const Role& role, UID id) : error(e), role(role), id(id) {}
	template <class Ar>
	void serialize(Ar&) {
		ASSERT(false);
	}
};

Error checkIOTimeout(Error const& e) {
	// Convert all_errors to io_timeout if global timeout bool was set
	bool timeoutOccurred = (bool)g_network->global(INetwork::enASIOTimedOut);
	// In simulation, have to check global timed out flag for both this process and the machine process on which IO is
	// done
	if (g_network->isSimulated() && !timeoutOccurred)
		timeoutOccurred = g_simulator->getCurrentProcess()->machine->machineProcess->global(INetwork::enASIOTimedOut);

	if (timeoutOccurred) {
		CODE_PROBE(true, "Timeout occurred");
		Error timeout = io_timeout();
		// Preserve injectedness of error
		if (e.isInjectedFault())
			timeout = timeout.asInjectedFault();
		return timeout;
	}
	return e;
}

															#line 981 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via forwardError()
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ForwardErrorActor>
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActorState {
															#line 988 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActorState(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors),
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   role(role),
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   process(process)
															#line 1001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("forwardError", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("forwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = process;
															#line 235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ForwardErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1019 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorActor, 0, Void >*>(static_cast<ForwardErrorActor*>(this)));
															#line 1024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errors.send(ErrorInfo(e, role, id));
															#line 240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForwardErrorActorState();
			static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1090 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorActor*>(this)->ActorCallback< ForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> process;
															#line 1181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via forwardError()
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActor final : public Actor<Void>, public ActorCallback< ForwardErrorActor, 0, Void >, public FastAllocated<ForwardErrorActor>, public ForwardErrorActorState<ForwardErrorActor> {
															#line 1186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ForwardErrorActor>::operator new;
	using FastAllocated<ForwardErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3510256074026881536UL, 18220263499774295552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorActor, 0, Void >;
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActor(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 1203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ForwardErrorActorState<ForwardErrorActor>(errors, role, id, process),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1301226801814355968UL, 15803518444079550976UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> forwardError( PromiseStream<ErrorInfo> const& errors, Role const& role, UID const& id, Future<Void> const& process ) {
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ForwardErrorActor(errors, role, id, process));
															#line 1236 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 1241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via handleIOErrors()
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HandleIOErrorsActor>
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActorState {
															#line 1248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActorState(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : actor(actor),
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeError(storeError),
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   onClosed(onClosed)
															#line 1261 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	~HandleIOErrorsActorState() 
	{
		fdb_probe_actor_destroy("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(actor);
															#line 248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1278 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = storeError;
															#line 1282 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleIOErrorsActorState();
		static_cast<HandleIOErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> const& __e,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e = __e;
															#line 250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1324 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1329 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> && __e,int loopDepth) 
	{
		e = std::move(__e);
															#line 250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1369 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 274 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 279 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1396 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 274 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1414 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1430 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 279 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1435 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >::remove();
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >::remove();

	}
	int a_body1when1cont1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_broken_promise && !storeError.isReady())
															#line 1450 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.00001 + FLOW_KNOBS->MAX_BUGGIFIED_DELAY);
															#line 256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 3;
															#line 256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 3, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1461 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1when1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1when1cont3(int loopDepth) 
	{
															#line 258 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (storeError.isReady() && storeError.isError() && storeError.getError().code() != error_code_file_not_found)
															#line 1562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 260 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(storeError.get().getError(), loopDepth);
															#line 1566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 1570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e.getError(), loopDepth);
															#line 1574 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 265 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> actor;
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<ErrorOr<Void>> storeError;
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> onClosed;
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Void> e;
															#line 1800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via handleIOErrors()
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActor final : public Actor<Void>, public ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >, public ActorCallback< HandleIOErrorsActor, 2, Void >, public ActorCallback< HandleIOErrorsActor, 3, Void >, public ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >, public FastAllocated<HandleIOErrorsActor>, public HandleIOErrorsActorState<HandleIOErrorsActor> {
															#line 1805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HandleIOErrorsActor>::operator new;
	using FastAllocated<HandleIOErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15386505041151682304UL, 6622822112507166208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< HandleIOErrorsActor, 2, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 3, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >;
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActor(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 1825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HandleIOErrorsActorState<HandleIOErrorsActor>(actor, storeError, id, onClosed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6206421713096993792UL, 16845784795105158144UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleIOErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> handleIOErrors( Future<Void> const& actor, Future<ErrorOr<Void>> const& storeError, UID const& id, Future<Void> const& onClosed = Void() ) {
															#line 244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HandleIOErrorsActor(actor, storeError, id, onClosed));
															#line 1860 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Future<Void> handleIOErrors(Future<Void> actor, IClosable* store, UID id, Future<Void> onClosed = Void()) {
	Future<ErrorOr<Void>> storeError = actor.isReady() ? Never() : errorOr(store->getError());
	return handleIOErrors(actor, storeError, id, onClosed);
}

Future<Void> deregisterGrpcService(const UID& id) {
#ifdef FLOW_GRPC_ENABLED
	if (g_network->isSimulated()) {
		return Void();
	}

	if (GrpcServer::instance() != nullptr) {
		return GrpcServer::instance()->deregisterRoleServices(id);
	}
#endif
	return Void();
}

															#line 1883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerHandleErrors()
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerHandleErrorsActor>
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActorState {
															#line 1890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActorState(FutureStream<ErrorInfo> const& errors) 
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors)
															#line 1897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	~WorkerHandleErrorsActorState() 
	{
		fdb_probe_actor_destroy("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 1912 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerHandleErrorsActorState();
		static_cast<WorkerHandleErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = errors;
															#line 1942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ErrorInfo>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ErrorInfo>>::value, "invalid type");
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 1;
															#line 304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*>(static_cast<WorkerHandleErrorsActor*>(this)));
															#line 1951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo const& _err,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress;
															#line 312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 1970 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 1974 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 1982 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 1986 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 1990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo && _err,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress;
															#line 312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 2008 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 2012 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 2020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 2028 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 2032 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state > 0) static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerHandleErrorsActor*>(this)->ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo const& value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo && value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,Error err) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<ErrorInfo> errors;
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::optional<Error> rethrow;
															#line 2105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerHandleErrors()
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActor final : public Actor<Void>, public ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >, public FastAllocated<WorkerHandleErrorsActor>, public WorkerHandleErrorsActorState<WorkerHandleErrorsActor> {
															#line 2110 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerHandleErrorsActor>::operator new;
	using FastAllocated<WorkerHandleErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7632433950648430848UL, 16128494994250212352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >;
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActor(FutureStream<ErrorInfo> const& errors) 
															#line 2127 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerHandleErrorsActorState<WorkerHandleErrorsActor>(errors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8795450729902019072UL, 3187225731259694336UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerHandleErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerHandleErrors( FutureStream<ErrorInfo> const& errors ) {
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerHandleErrorsActor(errors));
															#line 2160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 333 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Improve simulation code coverage by sometimes deferring the destruction of workerInterface (and therefore "endpoint
// not found" responses to clients
//		for an extra second, so that clients are more likely to see broken_promise errors
															#line 2168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via zombie()
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T, class ZombieActor>
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActorState {
															#line 2175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActorState(T const& workerInterface,Future<Void> const& worker) 
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : workerInterface(workerInterface),
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   worker(worker)
															#line 2184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("zombie", reinterpret_cast<unsigned long>(this));

	}
	~ZombieActorState() 
	{
		fdb_probe_actor_destroy("zombie", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = worker;
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ZombieActor*>(this)->actor_wait_state = 1;
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 0, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2257 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2282 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZombieActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 343 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ZombieActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZombieActorState(); static_cast<ZombieActor*>(this)->destroy(); return 0; }
															#line 2376 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ZombieActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZombieActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	T workerInterface;
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> worker;
															#line 2475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via zombie()
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActor final : public Actor<Void>, public ActorCallback< ZombieActor<T>, 0, Void >, public ActorCallback< ZombieActor<T>, 1, Void >, public FastAllocated<ZombieActor<T>>, public ZombieActorState<T, ZombieActor<T>> {
															#line 2482 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ZombieActor<T>>::operator new;
	using FastAllocated<ZombieActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12357618231022088704UL, 18176953840169514240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZombieActor<T>, 0, Void >;
friend struct ActorCallback< ZombieActor<T>, 1, Void >;
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActor(T const& workerInterface,Future<Void> const& worker) 
															#line 2500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ZombieActorState<T, ZombieActor<T>>(workerInterface, worker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17103515626195448064UL, 1853427329179145472UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zombie");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZombieActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZombieActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> zombie( T const& workerInterface, Future<Void> const& worker ) {
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ZombieActor<T>(workerInterface, worker));
															#line 2536 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 348 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 2541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via loadedPonger()
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class LoadedPongerActor>
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActorState {
															#line 2548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActorState(FutureStream<LoadedPingRequest> const& pings) 
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : pings(pings),
															#line 350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   payloadBack(std::string(20480, '.'))
															#line 2557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	~LoadedPongerActorState() 
	{
		fdb_probe_actor_destroy("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 352 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 2572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadedPongerActorState();
		static_cast<LoadedPongerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = pings;
															#line 2602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<LoadedPingRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<LoadedPingRequest>>::value, "invalid type");
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2606 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<LoadedPongerActor*>(this)->actor_wait_state = 1;
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*>(static_cast<LoadedPongerActor*>(this)));
															#line 2611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest const& pong,int loopDepth) 
	{
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 356 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest && pong,int loopDepth) 
	{
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 356 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2641 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest const& pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(pong, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest && pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(pong), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state > 0) static_cast<LoadedPongerActor*>(this)->actor_wait_state = 0;
		static_cast<LoadedPongerActor*>(this)->ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest const& value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest && value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<LoadedPingRequest> pings;
															#line 350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Standalone<StringRef> payloadBack;
															#line 2725 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via loadedPonger()
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActor final : public Actor<Void>, public ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >, public FastAllocated<LoadedPongerActor>, public LoadedPongerActorState<LoadedPongerActor> {
															#line 2730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<LoadedPongerActor>::operator new;
	using FastAllocated<LoadedPongerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8930340884673993984UL, 18093894171864548608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >;
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActor(FutureStream<LoadedPingRequest> const& pings) 
															#line 2747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   LoadedPongerActorState<LoadedPongerActor>(pings),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17672933219176974592UL, 1478809613757852416UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadedPonger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> loadedPonger( FutureStream<LoadedPingRequest> const& pings ) {
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new LoadedPongerActor(pings));
															#line 2780 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

StringRef fileStoragePrefix = "storage-"_sr;
StringRef testingStoragePrefix = "testingstorage-"_sr;
StringRef fileLogDataPrefix = "log-"_sr;
StringRef fileVersionedLogDataPrefix = "log2-"_sr;
StringRef fileLogQueuePrefix = "logqueue-"_sr;
StringRef tlogQueueExtension = "fdq"_sr;

enum class FilesystemCheck {
	FILES_ONLY,
	DIRECTORIES_ONLY,
	FILES_AND_DIRECTORIES,
};

struct KeyValueStoreSuffix {
	KeyValueStoreType type;
	std::string suffix;
	FilesystemCheck check;
};

KeyValueStoreSuffix bTreeV1Suffix = { KeyValueStoreType::SSD_BTREE_V1, ".fdb", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix bTreeV2Suffix = { KeyValueStoreType::SSD_BTREE_V2, ".sqlite", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memorySuffix = { KeyValueStoreType::MEMORY, "-0.fdq", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memoryRTSuffix = { KeyValueStoreType::MEMORY_RADIXTREE, "-0.fdr", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix redwoodSuffix = { KeyValueStoreType::SSD_REDWOOD_V1, ".redwood-v1", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix rocksdbSuffix = { KeyValueStoreType::SSD_ROCKSDB_V1,
	                                  ".rocksdb",
	                                  FilesystemCheck::DIRECTORIES_ONLY };
KeyValueStoreSuffix shardedRocksdbSuffix = { KeyValueStoreType::SSD_SHARDED_ROCKSDB,
	                                         ".shardedrocksdb",
	                                         FilesystemCheck::DIRECTORIES_ONLY };

std::string validationFilename = "_validate";

std::string filenameFromSample(KeyValueStoreType storeType, std::string folder, std::string sample_filename) {
	switch (storeType.storeType()) {
	case KeyValueStoreType::SSD_BTREE_V1:
	case KeyValueStoreType::SSD_BTREE_V2:
	case KeyValueStoreType::SSD_REDWOOD_V1:
	case KeyValueStoreType::SSD_ROCKSDB_V1:
	case KeyValueStoreType::SSD_SHARDED_ROCKSDB:
		return joinPath(folder, sample_filename);

	case KeyValueStoreType::MEMORY:
	case KeyValueStoreType::MEMORY_RADIXTREE:
		return joinPath(folder, sample_filename.substr(0, sample_filename.size() - 5));

	default:
		UNREACHABLE();
	}
}

std::string filenameFromId(KeyValueStoreType storeType, std::string folder, std::string prefix, UID id) {

	if (storeType == KeyValueStoreType::SSD_BTREE_V1)
		return joinPath(folder, prefix + id.toString() + ".fdb");
	else if (storeType == KeyValueStoreType::SSD_BTREE_V2)
		return joinPath(folder, prefix + id.toString() + ".sqlite");
	else if (storeType == KeyValueStoreType::MEMORY || storeType == KeyValueStoreType::MEMORY_RADIXTREE)
		return joinPath(folder, prefix + id.toString() + "-");
	else if (storeType == KeyValueStoreType::SSD_REDWOOD_V1)
		return joinPath(folder, prefix + id.toString() + ".redwood-v1");
	else if (storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
		return joinPath(folder, prefix + id.toString() + ".rocksdb");
	else if (storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
		return joinPath(folder, prefix + id.toString() + ".shardedrocksdb");

	TraceEvent(SevError, "UnknownStoreType").detail("StoreType", storeType.toString());
	UNREACHABLE();
}

struct TLogOptions {
	TLogOptions() = default;
	TLogOptions(TLogVersion v, TLogSpillType s) : version(v), spillType(s) {}

	TLogVersion version = TLogVersion::DEFAULT;
	TLogSpillType spillType = TLogSpillType::UNSET;

	static ErrorOr<TLogOptions> FromStringRef(StringRef s) {
		TLogOptions options;
		for (StringRef key = s.eat("_"), value = s.eat("_"); s.size() != 0 || key.size();
		     key = s.eat("_"), value = s.eat("_")) {
			if (key.size() != 0 && value.size() == 0)
				return default_error_or();

			if (key == "V"_sr) {
				ErrorOr<TLogVersion> tLogVersion = TLogVersion::FromStringRef(value);
				if (tLogVersion.isError())
					return tLogVersion.getError();
				options.version = tLogVersion.get();
			} else if (key == "LS"_sr) {
				ErrorOr<TLogSpillType> tLogSpillType = TLogSpillType::FromStringRef(value);
				if (tLogSpillType.isError())
					return tLogSpillType.getError();
				options.spillType = tLogSpillType.get();
			} else {
				return default_error_or();
			}
		}
		return options;
	}

	bool operator==(const TLogOptions& o) {
		return version == o.version && (spillType == o.spillType || version >= TLogVersion::V5);
	}

	std::string toPrefix() const {
		std::string toReturn = "";
		switch (version) {
		case TLogVersion::UNSET:
			ASSERT(false);
		case TLogVersion::V2:
			return "";
		case TLogVersion::V3:
		case TLogVersion::V4:
			toReturn =
			    "V_" + boost::lexical_cast<std::string>(version) + "_LS_" + boost::lexical_cast<std::string>(spillType);
			break;
		case TLogVersion::V5:
		case TLogVersion::V6:
		case TLogVersion::V7:
			toReturn = "V_" + boost::lexical_cast<std::string>(version);
			break;
		}
		ASSERT_WE_THINK(FromStringRef(toReturn).get() == *this);
		return toReturn + "-";
	}

	DiskQueueVersion getDiskQueueVersion() const {
		if (version < TLogVersion::V3) {
			ASSERT(false); // no longer supported
			return DiskQueueVersion::V0;
		}
		if (version < TLogVersion::V7)
			return DiskQueueVersion::V1;
		return DiskQueueVersion::V2;
	}
};

TLogFn tLogFnForOptions(TLogOptions options) {
	switch (options.version) {
	case TLogVersion::V2:
	case TLogVersion::V3:
	case TLogVersion::V4:
		ASSERT(false); // V2 to V4 are no longer supported

	case TLogVersion::V5:
	case TLogVersion::V6:
	case TLogVersion::V7:
		return tLog;
	default:
		ASSERT(false);
	}
	return tLog;
}

struct DiskStore {
	enum COMPONENT { TLogData, Storage, BlobWorker, UNSET };

	UID storeID = UID();
	std::string filename = ""; // For KVStoreMemory just the base filename to be passed to IDiskQueue
	COMPONENT storedComponent = UNSET;
	KeyValueStoreType storeType = KeyValueStoreType::END;
	TLogOptions tLogOptions;
};

std::vector<DiskStore> getDiskStores(std::string folder,
                                     std::string suffix,
                                     KeyValueStoreType type,
                                     FilesystemCheck check) {
	std::vector<DiskStore> result;
	std::vector<std::string> files;

	if (check == FilesystemCheck::FILES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		files = platform::listFiles(folder, suffix);
	}
	if (check == FilesystemCheck::DIRECTORIES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		for (const auto& directory : platform::listDirectories(folder)) {
			if (StringRef(directory).endsWith(suffix)) {
				files.push_back(directory);
			}
		}
	}

	for (int idx = 0; idx < files.size(); idx++) {
		DiskStore store;
		store.storeType = type;

		StringRef filename = StringRef(files[idx]);
		Standalone<StringRef> prefix;
		if (filename.startsWith(fileStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = fileStoragePrefix;
		} else if (filename.startsWith(testingStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = testingStoragePrefix;
		} else if (filename.startsWith(fileVersionedLogDataPrefix)) {
			store.storedComponent = DiskStore::TLogData;
			// Use the option string that's in the file rather than tLogOptions.toPrefix(),
			// because they might be different if a new option was introduced in this version.
			StringRef optionsString = filename.removePrefix(fileVersionedLogDataPrefix).eat("-");
			TraceEvent("DiskStoreVersioned").detail("Filename", filename);
			ErrorOr<TLogOptions> tLogOptions = TLogOptions::FromStringRef(optionsString);
			if (tLogOptions.isError()) {
				TraceEvent(SevWarn, "DiskStoreMalformedFilename").detail("Filename", filename);
				continue;
			}
			TraceEvent("DiskStoreVersionedSuccess").detail("Filename", filename);
			store.tLogOptions = tLogOptions.get();
			prefix = filename.substr(0, fileVersionedLogDataPrefix.size() + optionsString.size() + 1);
		} else if (filename.startsWith(fileLogDataPrefix)) {
			TraceEvent("DiskStoreUnversioned").detail("Filename", filename);
			store.storedComponent = DiskStore::TLogData;
			store.tLogOptions.version = TLogVersion::V2;
			store.tLogOptions.spillType = TLogSpillType::VALUE;
			prefix = fileLogDataPrefix;
		} else {
			continue;
		}

		store.storeID = UID::fromString(files[idx].substr(prefix.size(), 32));
		store.filename = filenameFromSample(type, folder, files[idx]);
		result.push_back(store);
	}
	return result;
}

std::vector<DiskStore> getDiskStores(std::string folder) {
	auto result = getDiskStores(folder, bTreeV1Suffix.suffix, bTreeV1Suffix.type, bTreeV1Suffix.check);
	auto result1 = getDiskStores(folder, bTreeV2Suffix.suffix, bTreeV2Suffix.type, bTreeV2Suffix.check);
	result.insert(result.end(), result1.begin(), result1.end());
	auto result2 = getDiskStores(folder, memorySuffix.suffix, memorySuffix.type, memorySuffix.check);
	result.insert(result.end(), result2.begin(), result2.end());
	auto result3 = getDiskStores(folder, redwoodSuffix.suffix, redwoodSuffix.type, redwoodSuffix.check);
	result.insert(result.end(), result3.begin(), result3.end());
	auto result4 = getDiskStores(folder, memoryRTSuffix.suffix, memoryRTSuffix.type, memoryRTSuffix.check);
	result.insert(result.end(), result4.begin(), result4.end());
	auto result5 = getDiskStores(folder, rocksdbSuffix.suffix, rocksdbSuffix.type, rocksdbSuffix.check);
	result.insert(result.end(), result5.begin(), result5.end());
	auto result6 =
	    getDiskStores(folder, shardedRocksdbSuffix.suffix, shardedRocksdbSuffix.type, shardedRocksdbSuffix.check);
	result.insert(result.end(), result6.begin(), result6.end());
	return result;
}

// Register the worker interf to cluster controller (cc) and
// re-register the worker when key roles interface, e.g., cc, dd, ratekeeper, change.
															#line 3031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registrationClient()
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegistrationClientActor>
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActorState {
															#line 3038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(ddInterf),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(rkInterf),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(ekpInterf),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(csInterf),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(degraded),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   connRecord(connRecord),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   issues(issues),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   recoveredDiskFiles(recoveredDiskFiles),
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   requestGeneration(0),
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   processClass(initialClass),
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   scInterf(new AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>()),
															#line 631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheProcessFuture(),
															#line 632 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheErrorsFuture(),
															#line 633 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   incorrectTime(),
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   firstReg(true)
															#line 3091 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	~RegistrationClientActorState() 
	{
		fdb_probe_actor_destroy("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 3106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegistrationClientActorState();
		static_cast<RegistrationClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 636 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		storedConnectionString = ClusterConnectionString();
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = true;
															#line 638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (connRecord)
															#line 3140 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 639 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<bool> __when_expr_0 = connRecord->upToDate(storedConnectionString);
															#line 639 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegistrationClientActor*>(this)->actor_wait_state = 1;
															#line 639 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 0, bool >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 642 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (upToDate)
															#line 3165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 643 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			incorrectTime = Optional<double>();
															#line 3169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RegisterWorkerRequest request(interf, initialClass, processClass, asyncPriorityInfo->get(), requestGeneration++, ddInterf->get(), rkInterf->get(), ekpInterf->get(), csInterf->get(), degraded->get(), localConfig.isValid() ? localConfig->lastSeenVersion() : Optional<Version>(), localConfig.isValid() ? localConfig->configClassSet() : Optional<ConfigClassSet>(), recoveredDiskFiles.isSet(), configBroadcastInterface, clusterId->get());
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto const& i : issues->get() ) {
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), i);
															#line 3177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!upToDate)
															#line 3181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), "incorrect_cluster_file_contents"_sr);
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string connectionString = connRecord->getConnectionString().toString();
															#line 670 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!incorrectTime.present())
															#line 3189 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				incorrectTime = now();
															#line 3193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 676 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(now() - incorrectTime.get() > 300 ? SevWarnAlways : SevWarn, "IncorrectClusterFileContents") .detail("ClusterFile", connRecord->toString()) .detail("StoredConnectionString", storedConnectionString.toString()) .detail("CurrentConnectionString", connectionString);
															#line 3197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 681 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto peers = FlowTransport::transport().getIncompatiblePeers();
															#line 682 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(auto it = peers->begin();it != peers->end();) {
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (now() - it->second.second > FLOW_KNOBS->INCOMPATIBLE_PEER_DELAY_BEFORE_LOGGING)
															#line 3205 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.incompatiblePeers.push_back(it->first);
															#line 685 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it = peers->erase(it);
															#line 3211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it++;
															#line 3217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ccInterfacePresent = ccInterface->get().present();
															#line 692 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ccInterfacePresent)
															#line 3224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 693 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.requestDbInfo = (ccInterface->get().get().id() != dbInfo->get().clusterInterface.id());
															#line 694 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (firstReg)
															#line 3230 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.requestDbInfo = true;
															#line 696 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				firstReg = false;
															#line 3236 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("WorkerRegister") .detail("CCID", ccInterface->get().get().id()) .detail("Generation", requestGeneration) .detail("RecoveredDiskFiles", recoveredDiskFiles.isSet()) .detail("ClusterId", clusterId->get());
															#line 3240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		registrationReply = ccInterfacePresent ? brokenPromiseToNever(ccInterface->get().get().registerWorker.getReply(request)) : Never();
															#line 707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recovered = recoveredDiskFiles.isSet() ? Never() : recoveredDiskFiles.getFuture();
															#line 708 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startTime = now();
															#line 709 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 3250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& upToDateResult,int loopDepth) 
	{
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3259 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && upToDateResult,int loopDepth) 
	{
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(upToDateResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(upToDateResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<RegisterWorkerReply> __when_expr_1 = registrationReply;
															#line 709 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->UNKNOWN_CC_TIMEOUT);
															#line 3371 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ccInterface->onChange();
															#line 3375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ddInterf->onChange();
															#line 3379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when4(__when_expr_4.get(), loopDepth); };
															#line 729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rkInterf->onChange();
															#line 3383 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
															#line 732 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = csInterf->onChange();
															#line 3387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when6(__when_expr_6.get(), loopDepth); };
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_7 = ekpInterf->onChange();
															#line 3391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when7(__when_expr_7.get(), loopDepth); };
															#line 738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = degraded->onChange();
															#line 3395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_9 = FlowTransport::transport().onIncompatibleChanged();
															#line 3399 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when9(__when_expr_9.get(), loopDepth); };
															#line 744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_10 = issues->onChange();
															#line 3403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when10(__when_expr_10.get(), loopDepth); };
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_11 = recovered;
															#line 3407 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when11(__when_expr_11.get(), loopDepth); };
															#line 750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_12 = clusterId->onChange();
															#line 3411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when12(__when_expr_12.get(), loopDepth); };
		static_cast<RegistrationClientActor*>(this)->actor_wait_state = 2;
															#line 710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*>(static_cast<RegistrationClientActor*>(this)));
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 2, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 3, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 4, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 5, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 732 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 6, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 7, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 8, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 9, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 10, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 11, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 12, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply const& reply,int loopDepth) 
	{
															#line 711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 712 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3470 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply && reply,int loopDepth) 
	{
															#line 711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 712 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3492 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3496 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3506 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3510 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 2, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 3, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 4, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 5, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 6, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 7, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 8, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 9, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 10, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 11, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>> const> ddInterf;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>> const> rkInterf;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> ekpInterf;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> csInterf;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool> const> degraded;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>> const> issues;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> recoveredDiskFiles;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Generation requestGeneration;
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass processClass;
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>> scInterf;
															#line 631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheProcessFuture;
															#line 632 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheErrorsFuture;
															#line 633 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<double> incorrectTime;
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool firstReg;
															#line 636 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ClusterConnectionString storedConnectionString;
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool upToDate;
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool ccInterfacePresent;
															#line 704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<RegisterWorkerReply> registrationReply;
															#line 707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> recovered;
															#line 708 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double startTime;
															#line 4397 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registrationClient()
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActor final : public Actor<Void>, public ActorCallback< RegistrationClientActor, 0, bool >, public ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >, public ActorCallback< RegistrationClientActor, 2, Void >, public ActorCallback< RegistrationClientActor, 3, Void >, public ActorCallback< RegistrationClientActor, 4, Void >, public ActorCallback< RegistrationClientActor, 5, Void >, public ActorCallback< RegistrationClientActor, 6, Void >, public ActorCallback< RegistrationClientActor, 7, Void >, public ActorCallback< RegistrationClientActor, 8, Void >, public ActorCallback< RegistrationClientActor, 9, Void >, public ActorCallback< RegistrationClientActor, 10, Void >, public ActorCallback< RegistrationClientActor, 11, Void >, public ActorCallback< RegistrationClientActor, 12, Void >, public FastAllocated<RegistrationClientActor>, public RegistrationClientActorState<RegistrationClientActor> {
															#line 4402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegistrationClientActor>::operator new;
	using FastAllocated<RegistrationClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6605862198768733952UL, 11620042812762298368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegistrationClientActor, 0, bool >;
friend struct ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >;
friend struct ActorCallback< RegistrationClientActor, 2, Void >;
friend struct ActorCallback< RegistrationClientActor, 3, Void >;
friend struct ActorCallback< RegistrationClientActor, 4, Void >;
friend struct ActorCallback< RegistrationClientActor, 5, Void >;
friend struct ActorCallback< RegistrationClientActor, 6, Void >;
friend struct ActorCallback< RegistrationClientActor, 7, Void >;
friend struct ActorCallback< RegistrationClientActor, 8, Void >;
friend struct ActorCallback< RegistrationClientActor, 9, Void >;
friend struct ActorCallback< RegistrationClientActor, 10, Void >;
friend struct ActorCallback< RegistrationClientActor, 11, Void >;
friend struct ActorCallback< RegistrationClientActor, 12, Void >;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 4431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegistrationClientActorState<RegistrationClientActor>(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853273321946395648UL, 10112439968674810368UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registrationClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegistrationClientActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registrationClient( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf, Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf, Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf, Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf, Reference<AsyncVar<bool> const> const& degraded, Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<std::set<std::string>> const> const& issues, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, ConfigBroadcastInterface const& configBroadcastInterface, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, Promise<Void> const& recoveredDiskFiles, Reference<AsyncVar<Optional<UID>>> const& clusterId ) {
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegistrationClientActor(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 4465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary DC.
bool addressInDbAndPrimaryDc(
    const NetworkAddress& address,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	const auto& dbi = dbInfo->get();

	if (dbi.master.addresses().contains(address)) {
		return true;
	}

	if (dbi.distributor.present() && dbi.distributor.get().address() == address) {
		return true;
	}

	if (dbi.ratekeeper.present() && dbi.ratekeeper.get().address() == address) {
		return true;
	}

	if (dbi.consistencyScan.present() && dbi.consistencyScan.get().address() == address) {
		return true;
	}

	if (dbi.client.encryptKeyProxy.present() && dbi.client.encryptKeyProxy.get().address() == address) {
		return true;
	}

	for (const auto& resolver : dbi.resolvers) {
		if (resolver.address() == address) {
			return true;
		}
	}

	for (const auto& grvProxy : dbi.client.grvProxies) {
		if (grvProxy.addresses().contains(address)) {
			return true;
		}
	}

	for (const auto& commitProxy : dbi.client.commitProxies) {
		if (commitProxy.addresses().contains(address)) {
			return true;
		}
	}

	auto localityIsInPrimaryDc = [&dbInfo](const LocalityData& locality) {
		return locality.dcId() == dbInfo->get().master.locality.dcId();
	};

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		for (const auto& tlog : logSet.tLogs) {
			if (!tlog.present()) {
				continue;
			}

			if (!localityIsInPrimaryDc(tlog.interf().filteredLocality)) {
				continue;
			}

			if (tlog.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndPrimaryDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndPrimaryDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimaryDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4554 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase841()
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase841Actor>
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase841ActorState {
															#line 4560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase841ActorState(UnitTestParameters const& params) 
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase841", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase841ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase841", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 844 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 845 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 846 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 849 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress testAddress(IPAddress(0x13131313), 1);
															#line 850 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.getCommitVersion = RequestStream<struct GetCommitVersionRequest>(Endpoint({ testAddress }, UID(1, 2)));
															#line 854 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 860 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 862 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 863 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 864 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 865 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 868 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 869 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 870 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 874 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.clear();
															#line 875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(testAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 878 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress grvProxyAddress(IPAddress(0x26262626), 1);
															#line 879 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GrvProxyInterface grvProxyInterf;
															#line 880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			grvProxyInterf.getConsistentReadVersion = PublicRequestStream<struct GetReadVersionRequest>(Endpoint({ grvProxyAddress }, UID(1, 2)));
															#line 882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.grvProxies.push_back(grvProxyInterf);
															#line 883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(grvProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress commitProxyAddress(IPAddress(0x37373737), 1);
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CommitProxyInterface commitProxyInterf;
															#line 887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			commitProxyInterf.commit = PublicRequestStream<struct CommitTransactionRequest>(Endpoint({ commitProxyAddress }, UID(1, 2)));
															#line 889 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.commitProxies.push_back(commitProxyInterf);
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(commitProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase841Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase841ActorState(); static_cast<FlowTestCase841Actor*>(this)->destroy(); return 0; }
															#line 4644 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase841Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase841ActorState();
			static_cast<FlowTestCase841Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase841ActorState();
		static_cast<FlowTestCase841Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase841()
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase841Actor final : public Actor<Void>, public FastAllocated<FlowTestCase841Actor>, public FlowTestCase841ActorState<FlowTestCase841Actor> {
															#line 4673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase841Actor>::operator new;
	using FastAllocated<FlowTestCase841Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9980568341671662848UL, 9696676264473524480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase841Actor(UnitTestParameters const& params) 
															#line 4689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase841ActorState<FlowTestCase841Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase841", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1435872734562745856UL, 18251688846073864960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase841Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase841");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase841", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase841( UnitTestParameters const& params ) {
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase841Actor(params));
															#line 4720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase841, "/fdbserver/worker/addressInDbAndPrimaryDc")

#line 894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary
// satellite DC.
bool addressInDbAndPrimarySatelliteDc(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	for (const auto& logSet : dbInfo->get().logSystemConfig.tLogs) {
		if (logSet.isLocal && logSet.locality == tagLocalitySatellite) {
			for (const auto& tlog : logSet.tLogs) {
				if (tlog.present() && tlog.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

bool addressesInDbAndPrimarySatelliteDc(const NetworkAddressList& addresses,
                                        Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return addressInDbAndPrimarySatelliteDc(addresses.address, dbInfo) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimarySatelliteDc(addresses.secondaryAddress.get(), dbInfo));
}

namespace {

															#line 4753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase922()
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase922Actor>
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase922ActorState {
															#line 4759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase922ActorState(UnitTestParameters const& params) 
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase922", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase922ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase922", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 924 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 925 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 926 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 927 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 931 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 932 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 933 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 934 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 939 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(testLocal);
															#line 940 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 943 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimarySatelliteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress primaryTLogAddress(IPAddress(0x26262626), 1);
															#line 947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 948 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface primaryTLog(testLocal);
															#line 950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.initEndpoints();
															#line 951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ primaryTLogAddress }, UID(1, 2)));
															#line 952 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(primaryTLog));
															#line 953 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(primaryTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 956 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress remoteTLogAddress(IPAddress(0x37373737), 1);
															#line 957 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 958 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTLog(fakeRemote);
															#line 960 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.initEndpoints();
															#line 961 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ remoteTLogAddress }, UID(1, 2)));
															#line 963 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 964 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 965 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTLog));
															#line 966 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(remoteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 968 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase922Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase922ActorState(); static_cast<FlowTestCase922Actor*>(this)->destroy(); return 0; }
															#line 4847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase922Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase922ActorState();
			static_cast<FlowTestCase922Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase922ActorState();
		static_cast<FlowTestCase922Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase922()
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase922Actor final : public Actor<Void>, public FastAllocated<FlowTestCase922Actor>, public FlowTestCase922ActorState<FlowTestCase922Actor> {
															#line 4876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase922Actor>::operator new;
	using FastAllocated<FlowTestCase922Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12935180083068406784UL, 3335482495921270784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase922Actor(UnitTestParameters const& params) 
															#line 4892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase922ActorState<FlowTestCase922Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase922", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16452066485220861696UL, 17581326006788289792UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase922Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase922");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase922", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase922( UnitTestParameters const& params ) {
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase922Actor(params));
															#line 4923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase922, "/fdbserver/worker/addressInDbAndPrimarySatelliteDc")

#line 970 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressInDbAndRemoteDc(const NetworkAddress& address,
                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                            Optional<std::vector<NetworkAddress>> storageServers) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (logSet.isLocal || logSet.locality == tagLocalitySatellite) {
			continue;
		}
		for (const auto& tlog : logSet.tLogs) {
			if (tlog.present() && tlog.interf().addresses().contains(address)) {
				return true;
			}
		}

		for (const auto& logRouter : logSet.logRouters) {
			if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndRemoteDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndRemoteDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndRemoteDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1014()
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1014Actor>
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1014ActorState {
															#line 4978 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1014ActorState(UnitTestParameters const& params) 
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1014", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1014ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1014", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1016 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1019 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1022 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1023 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 1025 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1027 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 1028 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 1029 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 1030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1033 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1034 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1036 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1041 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1044 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1045 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1046 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1047 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1048 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1049 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1052 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 1054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 1055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(fakeRemote);
															#line 1056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 1057 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 1058 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 1059 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1014Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1014ActorState(); static_cast<FlowTestCase1014Actor*>(this)->destroy(); return 0; }
															#line 5068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1014Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1014ActorState();
			static_cast<FlowTestCase1014Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1014ActorState();
		static_cast<FlowTestCase1014Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1014()
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1014Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1014Actor>, public FlowTestCase1014ActorState<FlowTestCase1014Actor> {
															#line 5097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1014Actor>::operator new;
	using FastAllocated<FlowTestCase1014Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6153521749788259072UL, 14828680627632901376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1014Actor(UnitTestParameters const& params) 
															#line 5113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1014ActorState<FlowTestCase1014Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1014", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(279334789842443776UL, 17169309344262758656UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1014Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1014");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1014", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1014( UnitTestParameters const& params ) {
															#line 1014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1014Actor(params));
															#line 5144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1014, "/fdbserver/worker/addressInDbAndRemoteDc")

#line 1063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressIsRemoteLogRouter(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (!logSet.isLocal) {
			for (const auto& logRouter : logSet.logRouters) {
				if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

namespace {

															#line 5170 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1084()
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1084Actor>
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1084ActorState {
															#line 5176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1084ActorState(UnitTestParameters const& params) 
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 5183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1084", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1084ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1084", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1086 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1087 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1093 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1094 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface<TLogInterface>());
															#line 1095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1098 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localLogRouter(testLocal);
															#line 1099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localLogRouter.initEndpoints();
															#line 1100 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(localLogRouter));
															#line 1101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1104 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1110 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1111 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1115 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1118 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1119 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressIsRemoteLogRouter(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1122 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1084Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1084ActorState(); static_cast<FlowTestCase1084Actor*>(this)->destroy(); return 0; }
															#line 5250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1084Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1084ActorState();
			static_cast<FlowTestCase1084Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1084ActorState();
		static_cast<FlowTestCase1084Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5274 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1084()
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1084Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1084Actor>, public FlowTestCase1084ActorState<FlowTestCase1084Actor> {
															#line 5279 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1084Actor>::operator new;
	using FastAllocated<FlowTestCase1084Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13803535099653931776UL, 3285442068978812928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1084Actor(UnitTestParameters const& params) 
															#line 5295 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1084ActorState<FlowTestCase1084Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1084", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7990276998591725568UL, 17780638665742168320UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1084Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1084");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1084", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1084( UnitTestParameters const& params ) {
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1084Actor(params));
															#line 5326 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1084, "/fdbserver/worker/addressIsRemoteLogRouter")

#line 1124 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if the `peer` has enough measurement samples that should be checked by the health monitor.
bool shouldCheckPeer(Reference<Peer> peer) {
	TraceEvent(SevDebug, "ShouldCheckPeer")
	    .suppressFor(0.1)
	    .detail("ConnectFailedCount", peer->connectFailedCount)
	    .detail("PingLatencyPopulationSize", peer->pingLatencies.getPopulationSize());

	if (peer->connectFailedCount != 0) {
		return true;
	}

	if (peer->pingLatencies.getPopulationSize() >= SERVER_KNOBS->PEER_LATENCY_CHECK_MIN_POPULATION) {
		// Ignore peers that don't have enough samples.
		// TODO(zhewu): Currently, FlowTransport latency monitor clears ping latency samples on a
		// regular basis, which may affect the measurement count. Currently,
		// WORKER_HEALTH_MONITOR_INTERVAL is much smaller than the ping clearance interval, so it may be
		// ok. If this ends to be a problem, we need to consider keep track of last ping latencies
		// logged.
		return true;
	}

	return false;
}

// Returns true if `address` is a degraded/disconnected peer in `lastReq` sent to CC.
bool isDegradedPeer(const UpdateWorkerHealthRequest& lastReq, const NetworkAddress& address) {
	if (std::find(lastReq.degradedPeers.begin(), lastReq.degradedPeers.end(), address) != lastReq.degradedPeers.end()) {
		return true;
	}

	if (std::find(lastReq.disconnectedPeers.begin(), lastReq.disconnectedPeers.end(), address) !=
	    lastReq.disconnectedPeers.end()) {
		return true;
	}

	return false;
}

struct PrimaryAndRemoteAddresses {
	std::vector<NetworkAddress> primary;
	std::vector<NetworkAddress> remote;
};

// Check if the current worker is a transaction worker, and is experiencing degraded or disconnected peers.
UpdateWorkerHealthRequest doPeerHealthCheck(const WorkerInterface& interf,
                                            const LocalityData& locality,
                                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                                            const UpdateWorkerHealthRequest& lastReq,
                                            Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck,
                                            Optional<PrimaryAndRemoteAddresses> storageServers) {
	const auto& allPeers = FlowTransport::transport().getAllPeers();

	// Check remote log router connectivity only when remote TLogs are recruited and in use.
	bool checkRemoteLogRouterConnectivity = dbInfo->get().recoveryState == RecoveryState::ALL_LOGS_RECRUITED ||
	                                        dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED;
	UpdateWorkerHealthRequest req;

	enum WorkerLocation { None, Primary, Satellite, Remote };
	WorkerLocation workerLocation = None;
	if (addressesInDbAndPrimaryDc(interf.addresses(),
	                              dbInfo,
	                              storageServers.present() ? storageServers.get().primary
	                                                       : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Primary;
	} else if (addressesInDbAndRemoteDc(interf.addresses(),
	                                    dbInfo,
	                                    storageServers.present() ? storageServers.get().remote
	                                                             : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Remote;
	} else if (addressesInDbAndPrimarySatelliteDc(interf.addresses(), dbInfo)) {
		workerLocation = Satellite;
	}

	TraceEvent(SevInfo, "DoPeerHealthCheck")
	    .detail("WorkerLocation", workerLocation)
	    .detail("StorageServersPresent", storageServers.present())
	    .detail("StorageServersPrimarySize",
	            storageServers.present() ? std::to_string(storageServers.get().primary.size()) : "NA")
	    .detail("StorageServersRemoteSize",
	            storageServers.present() ? std::to_string(storageServers.get().remote.size()) : "NA");

	if (workerLocation == None && !enablePrimaryTxnSystemHealthCheck->get()) {
		// This worker doesn't need to monitor anything if it is not in transaction system or in remote satellite.
		return req;
	}

	for (const auto& [address, peer] : allPeers) {
		if (!shouldCheckPeer(peer)) {
			continue;
		}

		bool degradedPeer = false;
		bool disconnectedPeer = false;

		// If peer->lastLoggedTime == 0, we just started monitor this peer and haven't logged it once yet.
		double lastLoggedTime = peer->lastLoggedTime <= 0.0 ? peer->lastConnectTime : peer->lastLoggedTime;

		TraceEvent(SevDebug, "PeerHealthMonitor")
		    .suppressFor(5.0)
		    .detail("Peer", address)
		    .detail("PeerAddress", address)
		    .detail("Force", enablePrimaryTxnSystemHealthCheck->get())
		    .detail("Elapsed", now() - lastLoggedTime)
		    .detail("Disconnected", disconnectedPeer)
		    .detail("MinLatency", peer->pingLatencies.min())
		    .detail("MaxLatency", peer->pingLatencies.max())
		    .detail("MeanLatency", peer->pingLatencies.mean())
		    .detail("MedianLatency", peer->pingLatencies.median())
		    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
		    .detail("CheckedPercentileLatency",
		            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
		    .detail("PingCount", peer->pingLatencies.getPopulationSize())
		    .detail("PingTimeoutCount", peer->timeoutCount)
		    .detail("ConnectionFailureCount", peer->connectFailedCount)
		    .detail("WorkerLocation", workerLocation)
		    .detail("PeerInPrimaryDc", addressInDbAndPrimaryDc(address, dbInfo))
		    .detail("PeerInRemoteDc", addressInDbAndRemoteDc(address, dbInfo))
		    .detail("PeerInPrimarySatelliteDc", addressInDbAndPrimarySatelliteDc(address, dbInfo))
		    .detail("PeerIsRemoteLogRouter", addressIsRemoteLogRouter(address, dbInfo));

		if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
		    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo))) {
			// Monitors intra DC latencies between servers that in the primary or remote DC's transaction
			// systems. Note that currently we are not monitor storage servers, since lagging in storage
			// servers today already can trigger server exclusion by data distributor.

			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}
			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) {
			// Monitors inter DC latencies between servers in primary and primary satellite DC. Note that
			// TLog workers in primary satellite DC are on the critical path of serving a commit.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD_SATELLITE ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}

			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Satellite", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
		           addressIsRemoteLogRouter(address, dbInfo)) {
			// Monitor remote log router's connectivity to the primary DCs' transaction system. We ignore
			// latency based degradation between primary region and remote region due to that remote region
			// may be distant from primary region.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("RemoteLogRouter", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		} else if (enablePrimaryTxnSystemHealthCheck->get() &&
		           (addressInDbAndPrimaryDc(address, dbInfo) || addressInDbAndPrimarySatelliteDc(address, dbInfo))) {
			// For force checking, we only detect connection timeout. Currently this should only be used during recovery
			// and only used in TLogs.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("ExtensiveConnectivityCheck", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		}

		if (disconnectedPeer) {
			req.disconnectedPeers.push_back(address);
		} else if (degradedPeer) {
			req.degradedPeers.push_back(address);
		} else if (isDegradedPeer(lastReq, address)) {
			TraceEvent("HealthMonitorDetectRecoveredPeer").detail("Peer", address).detail("PeerAddress", address);
			req.recoveredPeers.push_back(address);
		}
	}

	if (SERVER_KNOBS->WORKER_HEALTH_REPORT_RECENT_DESTROYED_PEER) {
		// When the worker cannot connect to a remote peer, the peer maybe erased from the list returned
		// from getAllPeers(). Therefore, we also look through all the recent closed peers in the flow
		// transport's health monitor. Note that all the closed peers stored here are caused by connection
		// failure, but not normal connection close. Therefore, we report all such peers if they are also
		// part of the transaction sub system.
		// Note that we don't need to calculate recovered peer in this case since all the recently closed peers are
		// considered permanently closed peers.
		for (const auto& address : FlowTransport::transport().healthMonitor()->getRecentClosedPeers()) {
			if (allPeers.find(address) != allPeers.end()) {
				// We have checked this peer in the above for loop.
				continue;
			}

			if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
			    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo)) ||
			    (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) ||
			    (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
			     addressIsRemoteLogRouter(address, dbInfo))) {
				TraceEvent("HealthMonitorDetectRecentClosedPeer")
				    .suppressFor(30)
				    .detail("Peer", address)
				    .detail("PeerAddress", address);
				req.disconnectedPeers.push_back(address);
			}
		}
	}

	if (g_network->isSimulated()) {
		// Invariant check in simulation: for any peers that shouldn't be checked, we won't include it in the
		// UpdateWorkerHealthRequest sent to CC.
		for (const auto& [address, peer] : allPeers) {
			if (!shouldCheckPeer(peer)) {
				for (const auto& disconnectedPeer : req.disconnectedPeers) {
					ASSERT(address != disconnectedPeer);
				}
				for (const auto& degradedPeer : req.degradedPeers) {
					ASSERT(address != degradedPeer);
				}
				for (const auto& recoveredPeer : req.recoveredPeers) {
					ASSERT(address != recoveredPeer);
				}
			}
		}
	}

	return req;
}

static Optional<Standalone<StringRef>> getPrimaryDCId(const ServerDBInfo& dbInfo) {
	return dbInfo.master.locality.dcId();
}

// Makes a "best effort" to return the network addresses of primary and remote storage servers.
// Both primary and secondary (if present) addresses are returned.
// This actor makes a network call, and if that call fails, an empty optional is returned in addition to a
// TraceEvent being logged. Intentionally, this actor does not implement a retry policy, but the client can
// choose to retry by waiting on this actor again.
															#line 5628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class GetStorageServersActor>
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActorState {
															#line 5635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ret(),
															#line 1424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   tr(db)
															#line 5648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1428 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 1429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<GetStorageServersActor*>(this)));
															#line 5677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<Optional<PrimaryAndRemoteAddresses>>::futures) { (void)(ret); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 5706 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< Optional<PrimaryAndRemoteAddresses> >::value()) Optional<PrimaryAndRemoteAddresses>(std::move(ret)); // state_var_RVO
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1452 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1453 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("GetStorageServersError").error(e);
															#line 5723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 1431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1432 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1433 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1434 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1436 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5749 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5755 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 1446 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1450 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 1431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1432 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1433 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1434 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1436 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5802 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5808 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5812 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 1446 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1450 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5836 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> ret;
															#line 1424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Transaction tr;
															#line 5937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via getStorageServers()
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActor final : public Actor<Optional<PrimaryAndRemoteAddresses>>, public ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 5942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(543882182942768128UL, 2514139762230226688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<PrimaryAndRemoteAddresses>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 5959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Optional<PrimaryAndRemoteAddresses>>(),
		   GetStorageServersActorState<GetStorageServersActor>(db, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Optional<PrimaryAndRemoteAddresses>> getStorageServers( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Optional<PrimaryAndRemoteAddresses>>(new GetStorageServersActor(db, dbInfo));
															#line 5992 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1458 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// The actor that actively monitors the health of local and peer servers, and reports anomaly to the cluster controller.
															#line 5998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMonitor()
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HealthMonitorActor>
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActorState {
															#line 6005 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   enablePrimaryTxnSystemHealthCheck(enablePrimaryTxnSystemHealthCheck),
															#line 1465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(),
															#line 1466 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db()
															#line 6024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	~HealthMonitorActorState() 
	{
		fdb_probe_actor_destroy("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN || SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN)
															#line 6039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				db = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 6043 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 1471 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 6047 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMonitorActorState();
		static_cast<HealthMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1472 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		nextHealthCheckDelay = Never();
															#line 1473 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const RecoveryState& recoveryState = dbInfo->get().recoveryState;
															#line 1474 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool primaryTxnSystemHealthCheckEnabled = enablePrimaryTxnSystemHealthCheck->get();
															#line 1475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool ccInterfacePresent = ccInterface->get().present();
															#line 1476 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerHealthMonitor") .detail("DBInfoRecoveryState", recoveryState) .detail("PrimaryTxnSystemHealthCheckEnabled", primaryTxnSystemHealthCheckEnabled) .detail("CCInterfacePresent", ccInterface->get().present());
															#line 1480 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if ((recoveryState >= RecoveryState::ACCEPTING_COMMITS || primaryTxnSystemHealthCheckEnabled) && ccInterfacePresent)
															#line 6087 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1482 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			nextHealthCheckDelay = delay(SERVER_KNOBS->WORKER_HEALTH_MONITOR_INTERVAL);
															#line 1483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			storageServers = Optional<PrimaryAndRemoteAddresses>();
															#line 1484 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (db.present())
															#line 6095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(storageServers, getStorageServers(db.get(), dbInfo));
															#line 1485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<HealthMonitorActor*>(this)->actor_wait_state = 1;
															#line 1485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 0, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextHealthCheckDelay;
															#line 1510 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6127 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1512 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ccInterface->onChange();
															#line 6131 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
															#line 1513 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dbInfo->onChange();
															#line 6135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
															#line 1514 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = enablePrimaryTxnSystemHealthCheck->onChange();
															#line 6139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
		static_cast<HealthMonitorActor*>(this)->actor_wait_state = 2;
															#line 1511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 1, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1512 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 2, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1513 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 3, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1514 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 4, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1487 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req = doPeerHealthCheck(interf, locality, dbInfo, req, enablePrimaryTxnSystemHealthCheck, storageServers);
															#line 1489 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!req.disconnectedPeers.empty() || !req.degradedPeers.empty() || !req.recoveredPeers.empty())
															#line 6161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1490 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (g_network->isSimulated())
															#line 6165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for( const auto& recoveredPeer : req.recoveredPeers ) {
															#line 1494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& disconnectedPeer : req.disconnectedPeers ) {
															#line 1495 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != disconnectedPeer);
															#line 6173 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
															#line 1497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& degradedPeer : req.degradedPeers ) {
															#line 1498 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != degradedPeer);
															#line 6179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
															#line 1504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.address = FlowTransport::transport().getLocalAddress();
															#line 1505 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (ccInterface->get().present())
															#line 6187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1506 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ccInterface->get().get().updateWorkerHealth.send(req);
															#line 6191 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 1, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 2, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 3, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 1465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateWorkerHealthRequest req;
															#line 1466 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Database> db;
															#line 1472 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> nextHealthCheckDelay;
															#line 1483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> storageServers;
															#line 6594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via healthMonitor()
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActor final : public Actor<Void>, public ActorCallback< HealthMonitorActor, 0, Void >, public ActorCallback< HealthMonitorActor, 1, Void >, public ActorCallback< HealthMonitorActor, 2, Void >, public ActorCallback< HealthMonitorActor, 3, Void >, public ActorCallback< HealthMonitorActor, 4, Void >, public FastAllocated<HealthMonitorActor>, public HealthMonitorActorState<HealthMonitorActor> {
															#line 6599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HealthMonitorActor>::operator new;
	using FastAllocated<HealthMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1919200080953038592UL, 5682203813116174848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMonitorActor, 0, Void >;
friend struct ActorCallback< HealthMonitorActor, 1, Void >;
friend struct ActorCallback< HealthMonitorActor, 2, Void >;
friend struct ActorCallback< HealthMonitorActor, 3, Void >;
friend struct ActorCallback< HealthMonitorActor, 4, Void >;
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 6620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMonitorActorState<HealthMonitorActor>(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11146410862898602752UL, 8671132782290732288UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMonitorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> healthMonitor( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck ) {
															#line 1460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HealthMonitorActor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 6654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1518 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
// A set of threads that should be profiled
std::set<std::thread::id> profiledThreads;

// Returns whether or not a given thread should be profiled
int filter_in_thread(void* arg) {
	return profiledThreads.contains(std::this_thread::get_id()) ? 1 : 0;
}
#endif

// Enables the calling thread to be profiled
void registerThreadForProfiling() {
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
	// Not sure if this is actually needed, but a call to backtrace was advised here:
	// http://groups.google.com/group/google-perftools/browse_thread/thread/0dfd74532e038eb8/2686d9f24ac4365f?pli=1
	profiledThreads.insert(std::this_thread::get_id());
	const int num_levels = 100;
	void* pc[num_levels];
	backtrace(pc, num_levels);
#endif
}

// Starts or stops the CPU profiler
void updateCpuProfiler(ProfilerRequest req) {
	switch (req.type) {
	case ProfilerRequest::Type::GPROF:
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE: {
			const char* path = (const char*)req.outputFile.begin();
			ProfilerOptions* options = new ProfilerOptions();
			options->filter_in_thread = &filter_in_thread;
			options->filter_in_thread_arg = nullptr;
			ProfilerStartWithOptions(path, options);
			break;
		}
		case ProfilerRequest::Action::DISABLE:
			ProfilerStop();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
#endif
		break;
	case ProfilerRequest::Type::FLOW:
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE:
			startProfiling(g_network, {}, req.outputFile);
			break;
		case ProfilerRequest::Action::DISABLE:
			stopProfiling();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
		break;
	default:
		ASSERT(false);
		break;
	}
}

															#line 6723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runCpuProfiler()
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunCpuProfilerActor>
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActorState {
															#line 6730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActorState(ProfilerRequest const& req) 
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunCpuProfilerActorState() 
	{
		fdb_probe_actor_destroy("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1584 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.action == ProfilerRequest::Action::RUN)
															#line 6752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.action = ProfilerRequest::Action::ENABLE;
															#line 1586 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(req.duration);
															#line 1587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 1;
															#line 1587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCpuProfilerActor, 0, Void >*>(static_cast<RunCpuProfilerActor*>(this)));
															#line 6767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunCpuProfilerActorState();
				static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1589 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1590 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6807 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1589 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1590 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6823 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunCpuProfilerActor*>(this)->ActorCallback< RunCpuProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCpuProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 6908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runCpuProfiler()
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActor final : public Actor<Void>, public ActorCallback< RunCpuProfilerActor, 0, Void >, public FastAllocated<RunCpuProfilerActor>, public RunCpuProfilerActorState<RunCpuProfilerActor> {
															#line 6913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunCpuProfilerActor>::operator new;
	using FastAllocated<RunCpuProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14840817369798254848UL, 16362678021591349248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCpuProfilerActor, 0, Void >;
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActor(ProfilerRequest const& req) 
															#line 6930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunCpuProfilerActorState<RunCpuProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9421576084395799552UL, 13013016949884672512UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCpuProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCpuProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runCpuProfiler( ProfilerRequest const& req ) {
															#line 1583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunCpuProfilerActor(req));
															#line 6963 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1596 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

void runHeapProfiler(const char* msg) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	if (IsHeapProfilerRunning()) {
		HeapProfilerDump(msg);
	} else {
		TraceEvent("ProfilerError").detail("Message", "HeapProfiler not running");
	}
#else
	TraceEvent("ProfilerError").detail("Message", "HeapProfiler Unsupported");
#endif
}

															#line 6980 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runProfiler()
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunProfilerActor>
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActorState {
															#line 6987 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActorState(ProfilerRequest const& req) 
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunProfilerActorState() 
	{
		fdb_probe_actor_destroy("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.type == ProfilerRequest::Type::GPROF_HEAP)
															#line 7009 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				runHeapProfiler("User triggered heap dump");
															#line 7013 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = runCpuProfiler(req);
															#line 1613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7022 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunProfilerActor*>(this)->actor_wait_state = 1;
															#line 1613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunProfilerActor, 0, Void >*>(static_cast<RunProfilerActor*>(this)));
															#line 7027 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1616 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunProfilerActorState(); static_cast<RunProfilerActor*>(this)->destroy(); return 0; }
															#line 7051 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunProfilerActor*>(this)->ActorCallback< RunProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 7148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runProfiler()
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActor final : public Actor<Void>, public ActorCallback< RunProfilerActor, 0, Void >, public FastAllocated<RunProfilerActor>, public RunProfilerActorState<RunProfilerActor> {
															#line 7153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunProfilerActor>::operator new;
	using FastAllocated<RunProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4099831380446717952UL, 15346176346096999680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunProfilerActor, 0, Void >;
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActor(ProfilerRequest const& req) 
															#line 7170 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunProfilerActorState<RunProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14649713953804097280UL, 18193392918468773120UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runProfiler( ProfilerRequest const& req ) {
															#line 1609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunProfilerActor(req));
															#line 7203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

bool checkHighMemory(int64_t threshold, bool* error) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	*error = false;
	uint64_t page_size = sysconf(_SC_PAGESIZE);
	int fd = open("/proc/self/statm", O_RDONLY | O_CLOEXEC);
	if (fd < 0) {
		TraceEvent("OpenStatmFileFailure").log();
		*error = true;
		return false;
	}

	const int buf_sz = 256;
	char stat_buf[buf_sz];
	ssize_t stat_nread = read(fd, stat_buf, buf_sz);
	if (stat_nread < 0) {
		TraceEvent("ReadStatmFileFailure").log();
		*error = true;
		return false;
	}

	uint64_t vmsize, rss;
	sscanf(stat_buf, "%lu %lu", &vmsize, &rss);
	rss *= page_size;
	if (rss >= threshold) {
		return true;
	}
#else
	TraceEvent("CheckHighMemoryUnsupported").log();
	*error = true;
#endif
	return false;
}

// Runs heap profiler when RSS memory usage is high.
															#line 7242 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorHighMemory()
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorHighMemoryActor>
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActorState {
															#line 7249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActorState(int64_t const& threshold) 
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : threshold(threshold)
															#line 7256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	~MonitorHighMemoryActorState() 
	{
		fdb_probe_actor_destroy("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (threshold <= 0)
															#line 7271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1655 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MonitorHighMemoryActorState();
				static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1657 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool err = false;
															#line 1659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool highmem = checkHighMemory(threshold, &err);
															#line 1660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err)
															#line 7329 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (highmem)
															#line 7335 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			runHeapProfiler("Highmem heap dump");
															#line 7339 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->HEAP_PROFILER_INTERVAL);
															#line 1665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 1;
															#line 1665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorHighMemoryActor, 0, Void >*>(static_cast<MonitorHighMemoryActor*>(this)));
															#line 7350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state > 0) static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHighMemoryActor*>(this)->ActorCallback< MonitorHighMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t threshold;
															#line 7457 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorHighMemory()
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActor final : public Actor<Void>, public ActorCallback< MonitorHighMemoryActor, 0, Void >, public FastAllocated<MonitorHighMemoryActor>, public MonitorHighMemoryActorState<MonitorHighMemoryActor> {
															#line 7462 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorHighMemoryActor>::operator new;
	using FastAllocated<MonitorHighMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12602561590307869184UL, 13156252070472657920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorHighMemoryActor, 0, Void >;
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActor(int64_t const& threshold) 
															#line 7479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorHighMemoryActorState<MonitorHighMemoryActor>(threshold),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3552868021743521024UL, 13539544626851908096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorHighMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorHighMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorHighMemory( int64_t const& threshold ) {
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorHighMemoryActor(threshold));
															#line 7512 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

struct StorageDiskCleaner {
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	Future<Void> future;
};

struct TrackRunningStorage {
	UID self;
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;

	TrackRunningStorage(UID self,
	                    KeyValueStoreType storeType,
	                    LocalityData locality,
	                    const std::string& filename,
	                    std::set<std::pair<UID, KeyValueStoreType>>* runningStorages,
	                    std::unordered_map<UID, StorageDiskCleaner>* storageCleaners)
	  : self(self), storeType(storeType), locality(locality), filename(filename), runningStorages(runningStorages),
	    storageCleaners(storageCleaners) {
		TraceEvent("StorageServerAddedToRunningStorage", self);
		runningStorages->emplace(self, storeType);
	}
	~TrackRunningStorage() {
		runningStorages->erase(std::make_pair(self, storeType));
		TraceEvent("StorageServerRemoveFromRunningStorage", self);

		// Start a disk cleaner except for tss data store
		try {
			if (basename(filename).find(testingStoragePrefix.toString()) != 0) {
				if (!storageCleaners->contains(self)) {
					StorageDiskCleaner cleaner;
					cleaner.storeType = storeType;
					cleaner.locality = locality;
					cleaner.filename = filename;
					cleaner.future = Void(); // cleaner task will start later
					storageCleaners->insert({ self, cleaner });
					TraceEvent("AddStorageCleaner", self).detail("Size", storageCleaners->size());
				}
			}
		} catch (Error& e) {
			TraceEvent("SkipStorageCleaner", self).error(e).detail("File", filename);
		}
	};
};

															#line 7566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class StorageServerRollbackRebooterActor>
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActorState {
															#line 7573 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActorState(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : runningStorages(runningStorages),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners(storageCleaners),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   prevStorageServer(prevStorageServer),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeType(storeType),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   isTss(isTss),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db(db),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(filesClosed),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   store(store),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   validateDataFiles(validateDataFiles),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVStore(rebootKVStore),
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   encryptionMonitor(encryptionMonitor),
															#line 1735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _(id, storeType, locality, filename, runningStorages, storageCleaners)
															#line 7612 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerRollbackRebooterActorState() 
	{
		fdb_probe_actor_destroy("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerRollbackRebooterActorState();
		static_cast<StorageServerRollbackRebooterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(prevStorageServer);
															#line 1737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 1;
															#line 1737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 1738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1740 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7706 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 1738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7725 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1740 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1775 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = id;
															#line 1777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 1781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 1787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1789 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 1791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 1792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1795 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1797 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 1798 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 1799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 1800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 1802 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(store->getError());
															#line 1803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = storageServer(store, recruited, db, folder, Promise<Void>(), Reference<IClusterConnectionRecord>(nullptr), encryptionMonitor);
															#line 1810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = handleIOErrors(prevStorageServer, storeError, id, store->onClosed());
															#line 7902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7936 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> prevStorageServer;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool isTss;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection* filesClosed;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* store;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void>* rebootKVStore;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<GetEncryptCipherKeysMonitor> encryptionMonitor;
															#line 1735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TrackRunningStorage _;
															#line 8050 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActor final : public Actor<Void>, public ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >, public ActorCallback< StorageServerRollbackRebooterActor, 1, Void >, public FastAllocated<StorageServerRollbackRebooterActor>, public StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor> {
															#line 8055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<StorageServerRollbackRebooterActor>::operator new;
	using FastAllocated<StorageServerRollbackRebooterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12129710248213376512UL, 2794357805823573504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< StorageServerRollbackRebooterActor, 1, Void >;
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActor(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 8073 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor>(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9711723034093058560UL, 17546821082729568512UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerRollbackRebooter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> storageServerRollbackRebooter( std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages, std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners, Future<Void> const& prevStorageServer, KeyValueStoreType const& storeType, std::string const& filename, UID const& id, LocalityData const& locality, bool const& isTss, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& folder, ActorCollection* const& filesClosed, int64_t const& memoryLimit, IKeyValueStore* const& store, bool const& validateDataFiles, Promise<Void>* const& rebootKVStore, Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor ) {
															#line 1719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new StorageServerRollbackRebooterActor(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor));
															#line 8107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1813 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// FIXME:  This will not work correctly in simulation as all workers would share the same roles map
std::set<std::pair<std::string, std::string>> g_roles;

Standalone<StringRef> roleString(std::set<std::pair<std::string, std::string>> roles, bool with_ids) {
	std::string result;
	for (auto& r : roles) {
		if (!result.empty())
			result.append(",");
		result.append(r.first);
		if (with_ids) {
			result.append(":");
			result.append(r.second);
		}
	}
	return StringRef(result);
}

void startRole(const Role& role,
               UID roleId,
               UID workerId,
               const std::map<std::string, std::string>& details,
               const std::string& origination) {
	if (role.includeInTraceRoles) {
		addTraceRole(role.abbreviation);
	}

	TraceEvent ev("Role", roleId);
	ev.detail("As", role.roleName)
	    .detail("Transition", "Begin")
	    .detail("Origination", origination)
	    .detail("OnWorker", workerId);
	for (auto it = details.begin(); it != details.end(); it++)
		ev.detail(it->first.c_str(), it->second);

	ev.trackLatest(roleId.shortString() + ".Role");

	// Update roles map, log Roles metrics
	g_roles.insert({ role.roleName, roleId.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->addRole(g_network->getLocalAddress(), role.roleName);
}

void endRole(const Role& role, UID id, std::string reason, bool ok, Error e) {
	{
		TraceEvent ev("Role", id);
		if (e.code() != invalid_error_code)
			ev.errorUnsuppressed(e);
		ev.detail("Transition", "End").detail("As", role.roleName).detail("Reason", reason);

		ev.trackLatest(id.shortString() + ".Role");
	}

	if (!ok) {
		std::string type = role.roleName + "Failed";

		TraceEvent err(SevError, type.c_str(), id);
		if (e.code() != invalid_error_code) {
			err.errorUnsuppressed(e);
		}
		err.detail("Reason", reason);
	}

	latestEventCache.clear(id.shortString());

	// Update roles map, log Roles metrics
	g_roles.erase({ role.roleName, id.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->removeRole(g_network->getLocalAddress(), role.roleName);

	if (role.includeInTraceRoles) {
		removeTraceRole(role.abbreviation);
	}
}

															#line 8190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via traceRole()
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TraceRoleActor>
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActorState {
															#line 8197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActorState(Role const& role,UID const& roleId) 
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : role(role),
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   roleId(roleId)
															#line 8206 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("traceRole", reinterpret_cast<unsigned long>(this));

	}
	~TraceRoleActorState() 
	{
		fdb_probe_actor_destroy("traceRole", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1893 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRoleActorState();
		static_cast<TraceRoleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL);
															#line 1894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRoleActor*>(this)->actor_wait_state = 1;
															#line 1894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRoleActor, 0, Void >*>(static_cast<TraceRoleActor*>(this)));
															#line 8258 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state > 0) static_cast<TraceRoleActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRoleActor*>(this)->ActorCallback< TraceRoleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRoleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID roleId;
															#line 8360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via traceRole()
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActor final : public Actor<Void>, public ActorCallback< TraceRoleActor, 0, Void >, public FastAllocated<TraceRoleActor>, public TraceRoleActorState<TraceRoleActor> {
															#line 8365 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TraceRoleActor>::operator new;
	using FastAllocated<TraceRoleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8099065953281005568UL, 8119536832832135936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRoleActor, 0, Void >;
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActor(Role const& role,UID const& roleId) 
															#line 8382 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   TraceRoleActorState<TraceRoleActor>(role, roleId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14398465994869201920UL, 9614722329871585280UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRole");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRoleActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> traceRole( Role const& role, UID const& roleId ) {
															#line 1892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new TraceRoleActor(role, roleId));
															#line 8415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1898 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 8420 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerSnapCreate()
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerSnapCreateActor>
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActorState {
															#line 8427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActorState(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : snapReq(snapReq),
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapFolder(snapFolder),
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(snapReqMap),
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(snapReqResultMap),
															#line 1905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapArg(snapReq.snapPayload),
															#line 1906 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqKey(snapReq.snapUID.toString() + snapReq.role.toString())
															#line 8444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~WorkerSnapCreateActorState() 
	{
		fdb_probe_actor_destroy("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<int> __when_expr_0 = execHelper(&snapArg, snapReq.snapUID, snapFolder, snapReq.role.toString());
															#line 1908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8462 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 1;
															#line 1908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerSnapCreateActor, 0, int >*>(static_cast<WorkerSnapCreateActor*>(this)));
															#line 8467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1935 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<WorkerSnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerSnapCreateActorState(); static_cast<WorkerSnapCreateActor*>(this)->destroy(); return 0; }
															#line 8496 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<WorkerSnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1926 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ExecHelperError").errorUnsuppressed(e);
															#line 1927 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 8511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1928 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->at(snapReqKey).reply.sendError(e);
															#line 1929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->erase(snapReqKey);
															#line 1930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(e);
															#line 8519 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1932 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8525 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& err,int loopDepth) 
	{
															#line 1909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1916 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8553 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1924 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int && err,int loopDepth) 
	{
															#line 1909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1916 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8582 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8586 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8590 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1924 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& err,int loopDepth) 
	{
		loopDepth = a_body1cont2(err, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && err,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(err), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state > 0) static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerSnapCreateActor*>(this)->ActorCallback< WorkerSnapCreateActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerSnapCreateActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapFolder;
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest>* snapReqMap;
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>>* snapReqResultMap;
															#line 1905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExecCmdValueString snapArg;
															#line 1906 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapReqKey;
															#line 8703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerSnapCreate()
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActor final : public Actor<Void>, public ActorCallback< WorkerSnapCreateActor, 0, int >, public FastAllocated<WorkerSnapCreateActor>, public WorkerSnapCreateActorState<WorkerSnapCreateActor> {
															#line 8708 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerSnapCreateActor>::operator new;
	using FastAllocated<WorkerSnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13761400791322996736UL, 5118940979747428352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerSnapCreateActor, 0, int >;
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActor(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 8725 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerSnapCreateActorState<WorkerSnapCreateActor>(snapReq, snapFolder, snapReqMap, snapReqResultMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10166740224002249728UL, 13188349297975825664UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerSnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerSnapCreateActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerSnapCreate( WorkerSnapRequest const& snapReq, std::string const& snapFolder, std::map<std::string, WorkerSnapRequest>* const& snapReqMap, std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap ) {
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerSnapCreateActor(snapReq, snapFolder, snapReqMap, snapReqResultMap));
															#line 8758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// TODO: `issues` is right now only updated by `monitorTraceLogIssues` and thus is being `set` on every update.
// It could be changed to `insert` and `trigger` later if we want to use it as a generic way for the caller of this
// function to report issues to cluster controller.
															#line 8766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorTraceLogIssuesActor>
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActorState {
															#line 8773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActorState(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : issues(issues),
															#line 1942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   pingTimeout(false)
															#line 8782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	~MonitorTraceLogIssuesActorState() 
	{
		fdb_probe_actor_destroy("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1943 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8797 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorTraceLogIssuesActorState();
		static_cast<MonitorTraceLogIssuesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1944 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TRACE_LOG_FLUSH_FAILURE_CHECK_INTERVAL_SECONDS);
															#line 1944 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 1;
															#line 1944 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8849 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8854 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8869 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::set<std::string> _issues;
															#line 1956 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retrieveTraceLogIssues(_issues);
															#line 1957 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (pingTimeout)
															#line 8974 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			_issues.insert("trace_log_writer_thread_unresponsive");
															#line 1960 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			pingTimeout = false;
															#line 8980 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1962 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		issues->set(_issues);
															#line 8984 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 8994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				pingTimeout = true;
															#line 8998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1952 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 1942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool pingTimeout;
															#line 9120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActor final : public Actor<Void>, public ActorCallback< MonitorTraceLogIssuesActor, 0, Void >, public ActorCallback< MonitorTraceLogIssuesActor, 1, Void >, public FastAllocated<MonitorTraceLogIssuesActor>, public MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor> {
															#line 9125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorTraceLogIssuesActor>::operator new;
	using FastAllocated<MonitorTraceLogIssuesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4920148052496178432UL, 9690209434217826560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorTraceLogIssuesActor, 0, Void >;
friend struct ActorCallback< MonitorTraceLogIssuesActor, 1, Void >;
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActor(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 9143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor>(issues),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17589411279920321024UL, 1269187454341278720UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorTraceLogIssues");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorTraceLogIssues( Reference<AsyncVar<std::set<std::string>>> const& issues ) {
															#line 1941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorTraceLogIssuesActor(issues));
															#line 9177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1965 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

class SharedLogsKey {
	TLogVersion logVersion;
	TLogSpillType spillType;
	KeyValueStoreType storeType;

public:
	SharedLogsKey(const TLogOptions& options, KeyValueStoreType kvst)
	  : logVersion(options.version), spillType(options.spillType), storeType(kvst) {
		if (logVersion >= TLogVersion::V5)
			spillType = TLogSpillType::UNSET;
	}

	bool operator<(const SharedLogsKey& other) const {
		return std::tie(logVersion, spillType, storeType) <
		       std::tie(other.logVersion, other.spillType, other.storeType);
	}
};

struct SharedLogsValue {
	Future<Void> actor = Void();
	UID uid = UID();
	PromiseStream<InitializeTLogRequest> requests;

	SharedLogsValue() = default;
	SharedLogsValue(Future<Void> actor, UID uid, PromiseStream<InitializeTLogRequest> requests)
	  : actor(actor), uid(uid), requests(requests) {}
};

															#line 9210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via chaosMetricsLogger()
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ChaosMetricsLoggerActor>
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActorState {
															#line 9217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActorState() 
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 9223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		fdb_probe_actor_create("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~ChaosMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1996 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto res = g_network->global(INetwork::enChaosMetrics);
															#line 1997 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!res)
															#line 9239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<ChaosMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChaosMetricsLoggerActorState(); static_cast<ChaosMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 9243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<ChaosMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ChaosMetricsLoggerActorState();
				static_cast<ChaosMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2000 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics = static_cast<ChaosMetrics*>(res);
															#line 2001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics->clear();
															#line 2003 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChaosMetricsLoggerActorState();
		static_cast<ChaosMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(FLOW_KNOBS->CHAOS_LOGGING_INTERVAL);
															#line 2004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 2004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChaosMetricsLoggerActor, 0, Void >*>(static_cast<ChaosMetricsLoggerActor*>(this)));
															#line 9292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2007 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2008 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2009 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2010 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2011 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9311 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2007 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2008 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2009 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2010 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2011 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosMetricsLoggerActor*>(this)->ActorCallback< ChaosMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2000 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetrics* chaosMetrics;
															#line 9412 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via chaosMetricsLogger()
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActor final : public Actor<Void>, public ActorCallback< ChaosMetricsLoggerActor, 0, Void >, public FastAllocated<ChaosMetricsLoggerActor>, public ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor> {
															#line 9417 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ChaosMetricsLoggerActor>::operator new;
	using FastAllocated<ChaosMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6408725809794020352UL, 7260585963078410240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChaosMetricsLoggerActor, 0, Void >;
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActor() 
															#line 9434 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11301253459754392576UL, 10330861438325872384UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chaosMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChaosMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> chaosMetricsLogger(  ) {
															#line 1994 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ChaosMetricsLoggerActor());
															#line 9467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2014 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

static const std::string clusterIdFilename = "clusterId";

															#line 9474 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via createClusterIdFile()
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CreateClusterIdFileActor>
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActorState {
															#line 9481 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActorState(std::string const& folder,UID const& clusterId) 
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterIdPath(joinPath(folder, clusterIdFilename))
															#line 9492 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateClusterIdFileActorState() 
	{
		fdb_probe_actor_destroy("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2019 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (fileExists(clusterIdPath))
															#line 9507 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateClusterIdFileActorState();
				static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2022 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9519 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open( clusterIdPath, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_LOCK, 0600));
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 1;
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2045 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9573 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2046 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9577 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2048 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!e.isInjectedFault())
															#line 9581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2049 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				fprintf(stderr, "ERROR: error creating or opening cluster id file `%s'.\n", joinPath(folder, clusterIdFilename).c_str());
															#line 9585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "OpenClusterIdError").error(e);
															#line 2054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2028 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (clusterIdFile.isError() && clusterIdFile.getError().code() == error_code_file_not_found && !fileExists(clusterIdPath))
															#line 9605 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( clusterIdPath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_LOCK | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 2;
															#line 2030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9616 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2042 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1loopBody1Catch1(clusterIdFile.getError(), loopDepth);
															#line 9623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> const& __clusterIdFile,int loopDepth) 
	{
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = __clusterIdFile;
															#line 9632 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> && __clusterIdFile,int loopDepth) 
	{
		clusterIdFile = std::move(__clusterIdFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
															#line 2035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2036 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2037 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9724 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
															#line 2035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2036 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2037 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9746 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_clusterIdFile, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_clusterIdFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9832 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9837 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9848 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID clusterId;
															#line 2018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string clusterIdPath;
															#line 2024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Reference<IAsyncFile>> clusterIdFile;
															#line 10040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via createClusterIdFile()
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActor final : public Actor<Void>, public ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CreateClusterIdFileActor, 2, Void >, public ActorCallback< CreateClusterIdFileActor, 3, Void >, public FastAllocated<CreateClusterIdFileActor>, public CreateClusterIdFileActorState<CreateClusterIdFileActor> {
															#line 10045 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CreateClusterIdFileActor>::operator new;
	using FastAllocated<CreateClusterIdFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8364532091389930752UL, 14376784018169261056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateClusterIdFileActor, 2, Void >;
friend struct ActorCallback< CreateClusterIdFileActor, 3, Void >;
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActor(std::string const& folder,UID const& clusterId) 
															#line 10065 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CreateClusterIdFileActorState<CreateClusterIdFileActor>(folder, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2623832799678928640UL, 8068581988244134144UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createClusterIdFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> createClusterIdFile( std::string const& folder, UID const& clusterId ) {
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CreateClusterIdFileActor(folder, clusterId));
															#line 10101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2058 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Updates this processes cluster ID based off the cluster ID received in the
// ServerDBInfo. Persists the cluster ID to disk if it does not already exist.
															#line 10108 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateClusterId()
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class UpdateClusterIdActor>
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActorState {
															#line 10115 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActorState(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccClusterId(ccClusterId),
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder)
															#line 10126 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateClusterIdActorState() 
	{
		fdb_probe_actor_destroy("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2062 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!clusterId->get().present() && ccClusterId.isValid())
															#line 10141 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = createClusterIdFile(folder, ccClusterId);
															#line 2063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 1;
															#line 2063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterIdActor, 0, Void >*>(static_cast<UpdateClusterIdActor*>(this)));
															#line 10152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<UpdateClusterIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateClusterIdActorState(); static_cast<UpdateClusterIdActor*>(this)->destroy(); return 0; }
															#line 10180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<UpdateClusterIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2064 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2064 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterIdActor*>(this)->ActorCallback< UpdateClusterIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateClusterIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID ccClusterId;
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 10287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via updateClusterId()
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActor final : public Actor<Void>, public ActorCallback< UpdateClusterIdActor, 0, Void >, public FastAllocated<UpdateClusterIdActor>, public UpdateClusterIdActorState<UpdateClusterIdActor> {
															#line 10292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<UpdateClusterIdActor>::operator new;
	using FastAllocated<UpdateClusterIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2700167766876690944UL, 5614811198591200512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateClusterIdActor, 0, Void >;
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActor(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 10309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateClusterIdActorState<UpdateClusterIdActor>(ccClusterId, clusterId, folder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10009873598315805184UL, 15517297218935779072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateClusterId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateClusterIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> updateClusterId( UID const& ccClusterId, Reference<AsyncVar<Optional<UID>>> const& clusterId, std::string const& folder ) {
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new UpdateClusterIdActor(ccClusterId, clusterId, folder));
															#line 10342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 10347 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteStorageFile()
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class DeleteStorageFileActor>
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActorState {
															#line 10354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActorState(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : storeType(storeType),
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   kvs(openKVStore(storeType, filename, storeID, memoryLimit, false, false, false, dbInfo, {}))
															#line 10371 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	~DeleteStorageFileActorState() 
	{
		fdb_probe_actor_destroy("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(kvs->init());
															#line 2075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10388 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 1;
															#line 2075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteStorageFileActor, 0, Void >*>(static_cast<DeleteStorageFileActor*>(this)));
															#line 10393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2078 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2079 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2080 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2078 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2079 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2080 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state > 0) static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteStorageFileActor*>(this)->ActorCallback< DeleteStorageFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteStorageFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* kvs;
															#line 10539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via deleteStorageFile()
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActor final : public Actor<Void>, public ActorCallback< DeleteStorageFileActor, 0, Void >, public FastAllocated<DeleteStorageFileActor>, public DeleteStorageFileActorState<DeleteStorageFileActor> {
															#line 10544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<DeleteStorageFileActor>::operator new;
	using FastAllocated<DeleteStorageFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10165861156462370304UL, 6435152861257814272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteStorageFileActor, 0, Void >;
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActor(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 10561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteStorageFileActorState<DeleteStorageFileActor>(storeType, filename, storeID, memoryLimit, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7303347310383014400UL, 15168961707397160448UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteStorageFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteStorageFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> deleteStorageFile( KeyValueStoreType const& storeType, std::string const& filename, UID const& storeID, int64_t const& memoryLimit, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2069 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new DeleteStorageFileActor(storeType, filename, storeID, memoryLimit, dbInfo));
															#line 10594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2082 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 10599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CleanupStaleStorageDiskActor>
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActorState {
															#line 10606 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : dbInfo(dbInfo),
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaners(cleaners),
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaner(cleaner),
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   retries(0)
															#line 10623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	~CleanupStaleStorageDiskActorState() 
	{
		fdb_probe_actor_destroy("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 10638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2091 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (retries > SERVER_KNOBS->STORAGE_DISK_CLEANUP_MAX_RETRIES)
															#line 10669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").detail("Filename", cleaner.filename).detail("StoreID", storeID);
															#line 2093 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2096 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerLivenessCheck").detail("StoreID", storeID).detail("Retry", retries);
															#line 2097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<CommitProxyInfo> commitProxies(new CommitProxyInfo(dbInfo->get().client.commitProxies));
															#line 2098 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (commitProxies->size() == 0)
															#line 10687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").log();
															#line 2100 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10693 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GetStorageServerRejoinInfoRequest request(storeID, cleaner.locality.dcId());
															#line 2103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<GetStorageServerRejoinInfoReply> __when_expr_0 = basicLoadBalance(commitProxies, &CommitProxyInterface::getStorageServerRejoinInfo, request);
															#line 2103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10705 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 1;
															#line 2103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->STORAGE_DISK_CLEANUP_RETRY_INTERVAL);
															#line 2120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 3;
															#line 2120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10732 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 10742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2111 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (fileExists(cleaner.filename))
															#line 10746 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StrictFuture<Void> __when_expr_1 = deleteStorageFile(cleaner.storeType, cleaner.filename, storeID, memoryLimit, dbInfo);
															#line 2112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 2;
															#line 2112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 2116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		cleaners->erase(storeID);
															#line 2117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* cleaners;
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageDiskCleaner cleaner;
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int retries;
															#line 11090 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActor final : public Actor<Void>, public ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >, public ActorCallback< CleanupStaleStorageDiskActor, 1, Void >, public ActorCallback< CleanupStaleStorageDiskActor, 2, Void >, public FastAllocated<CleanupStaleStorageDiskActor>, public CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor> {
															#line 11095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CleanupStaleStorageDiskActor>::operator new;
	using FastAllocated<CleanupStaleStorageDiskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6780841970161854720UL, 8550248421002083840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 1, Void >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 2, Void >;
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 11114 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor>(dbInfo, cleaners, storeID, cleaner, memoryLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10954477009460037888UL, 11591692359139200000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupStaleStorageDisk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> cleanupStaleStorageDisk( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, std::unordered_map<UID, StorageDiskCleaner>* const& cleaners, UID const& storeID, StorageDiskCleaner const& cleaner, int64_t const& memoryLimit ) {
															#line 2083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CleanupStaleStorageDiskActor(dbInfo, cleaners, storeID, cleaner, memoryLimit));
															#line 11149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2123 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Delete storage server data files if it's not alive anymore
void cleanupStorageDisks(Reference<AsyncVar<ServerDBInfo>> dbInfo,
                         std::unordered_map<UID, StorageDiskCleaner>& storageCleaners,
                         int64_t memoryLimit) {
	for (auto& cleaner : storageCleaners) {
		if (cleaner.second.future.isReady()) {
			CODE_PROBE(true, "Cleanup stale disk stores for double recruitment");
			cleaner.second.future =
			    cleanupStaleStorageDisk(dbInfo, &storageCleaners, cleaner.first, cleaner.second, memoryLimit);
		}
	}
}

bool skipInitRspInSim(const UID workerInterfID, const bool allowDropInSim) {
	const bool skip = allowDropInSim && g_network->isSimulated() && BUGGIFY_WITH_PROB(/* 1% */ 0.01);
	if (skip) {
		TraceEvent("SkipInitRspInSimTrue").detail("WorkerInterfID", workerInterfID);
	}
	return skip;
}

#ifdef FLOW_GRPC_ENABLED
															#line 11176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor>
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActorState {
															#line 11183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActorState(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActorState() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (GrpcServer::instance() == nullptr)
															#line 11207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				this->~RegisterWorkerGrpcServicesActorState();
															#line 11211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			else
			{
															#line 2149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 11219 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					this->~RegisterWorkerGrpcServicesActorState();
															#line 11223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
					return 0;
				}
			}
															#line 2153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto db = Database::createDatabase(ccr, ApiVersion::LATEST_VERSION);
															#line 2154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = safeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(db));
															#line 2154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11234 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 1;
															#line 2154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*>(static_cast<RegisterWorkerGrpcServicesActor*>(this)));
															#line 11239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActorState();
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> const& idb,int loopDepth) 
	{
															#line 2155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{};
															#line 2156 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> && idb,int loopDepth) 
	{
															#line 2155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{};
															#line 2156 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(idb, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(idb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11369 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor final : public Actor<Void>, public ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >, public FastAllocated<RegisterWorkerGrpcServicesActor>, public RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor> {
															#line 11374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1700136661301773824UL, 2163363793128466688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >;
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11091973658458607872UL, 4923644862601870848UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor(id, ccr));
															#line 11424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
#else
															#line 11429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor1>
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1State {
															#line 11436 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1State(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActor1State() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			this->~RegisterWorkerGrpcServicesActor1State();
															#line 11460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActor1State();
		static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11484 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1 final : public Actor<Void>, public FastAllocated<RegisterWorkerGrpcServicesActor1>, public RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1> {
															#line 11489 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1700136661301773824UL, 2163363793128466688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11505 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6368418377314189568UL, 12623130874699170304UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor1(id, ccr));
															#line 11537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
#endif

															#line 11543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerServer()
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerServerActor>
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActorState {
															#line 11550 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActorState(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : connRecord(connRecord),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccInterface(ccInterface),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsConnFile(metricsConnFile),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsPrefix(metricsPrefix),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryProfileThreshold(memoryProfileThreshold),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _coordFolder(_coordFolder),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   consistencyCheckUrgentMode(consistencyCheckUrgentMode),
															#line 2184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errors(),
															#line 2185 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(new AsyncVar<Optional<DataDistributorInterface>>()),
															#line 2187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(new AsyncVar<Optional<RatekeeperInterface>>()),
															#line 2188 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(new AsyncVar<Optional<EncryptKeyProxyInterface>>()),
															#line 2190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(new AsyncVar<Optional<ConsistencyScanInterface>>()),
															#line 2192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   handleErrors(workerHandleErrors(errors.getFuture())),
															#line 2193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errorForwarders(false),
															#line 2194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingTrigger(Void()),
															#line 2195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingDelay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL),
															#line 2197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise(),
															#line 2198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise2(),
															#line 2199 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(true),
															#line 2200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   stopping(),
															#line 2201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsLogger(),
															#line 2202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   chaosMetricsActor(),
															#line 2203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(FlowTransport::transport().getDegraded()),
															#line 2209 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sharedLogs(),
															#line 2210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   activeSharedTLog(new AsyncVar<UID>()),
															#line 2211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   backupWorkerCache(),
															#line 2212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   blobWorkerFuture(Void()),
															#line 2214 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapReq(),
															#line 2216 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(),
															#line 2217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(),
															#line 2218 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapTime(-SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP),
															#line 2219 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   coordFolder(abspath(_coordFolder)),
															#line 2221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(locality),
															#line 2223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   runningStorages(),
															#line 2228 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners()
															#line 11647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerServer", reinterpret_cast<unsigned long>(this));

	}
	~WorkerServerActorState() 
	{
		fdb_probe_actor_destroy("workerServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2230 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			interf.initEndpoints();
															#line 2232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			issues = Reference<AsyncVar<std::set<std::string>>>(new AsyncVar<std::set<std::string>>());
															#line 2234 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			updateClusterIdFuture = Future<Void>();
															#line 2238 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			enablePrimaryTxnSystemHealthCheck = makeReference<AsyncVar<bool>>(false);
															#line 2240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 2240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 1;
															#line 2240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 0, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 11677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerServerActorState();
		static_cast<WorkerServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2245 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11708 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11714 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
				try {
															#line 2253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2261 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2264 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11746 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11754 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2245 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
				try {
															#line 2253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2261 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2264 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11818 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(resetAfter(degraded, SERVER_KNOBS->DEGRADED_RESET_INTERVAL, false, SERVER_KNOBS->DEGRADED_WARNING_LIMIT, SERVER_KNOBS->DEGRADED_WARNING_RESET_DELAY, "DegradedReset"));
															#line 2276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(loadedPonger(interf.debugPing.getFuture()));
															#line 2277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(waitFailureServer(interf.waitFailure.getFuture()));
															#line 2278 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorTraceLogIssues(issues));
															#line 2279 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( testerServerCore(interf.testerInterface, connRecord, dbInfo, locality, consistencyCheckUrgentMode ? "ConsistencyCheckUrgent" : Optional<std::string>()));
															#line 2285 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorHighMemory(memoryProfileThreshold));
															#line 2287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(stopping.getFuture());
															#line 2289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		initializeSystemMonitorMachineState(SystemMonitorMachineState(folder, locality.dcId(), locality.zoneId(), locality.machineId(), locality.dataHallId(), g_network->getLocalAddress().ip, FDB_VT_VERSION));
															#line 11917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2298 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto recruited = interf;
															#line 2299 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.reboot);
															#line 2300 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.profiler);
															#line 2301 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.tLog);
															#line 2302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.master);
															#line 2303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commitProxy);
															#line 2304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.grvProxy);
															#line 2305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.resolver);
															#line 2306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.storage);
															#line 2307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.debugPing);
															#line 2308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.coordinationPing);
															#line 2309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.setMetricsRate);
															#line 2311 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.eventLogRequest);
															#line 2312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.traceBatchDumpRequest);
															#line 2313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.updateServerDBInfo);
															#line 11951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries = std::vector<Future<Void>>();
															#line 11955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			stores = getDiskStores(folder);
															#line 2320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			validateDataFiles = deleteFile(joinPath(folder, validationFilename));
															#line 2321 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			index = 0;
															#line 2322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 11965 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2258 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "TDMetricsBadClusterFile").error(e).detail("ConnFile", metricsConnFile);
															#line 11993 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 3253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for( auto f : recoveries ) {
															#line 3254 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				f.cancel();
															#line 12024 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = err;
															#line 3256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_actor_cancelled || e.code() == error_code_please_reboot_delete || e.code() == error_code_local_config_changed || e.code() == error_code_invalid_cluster_id;
															#line 3259 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			endRole(Role::WORKER, interf.id(), "WorkerError", ok, e);
															#line 3260 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.clear(false);
															#line 3261 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			sharedLogs.clear();
															#line 3264 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture.cancel();
															#line 3266 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 12040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				stopping.send(Void());
															#line 3271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_29 = filesClosed.getResult();
															#line 3271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12048 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont2Catch1when1(__when_expr_29.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 6;
															#line 3271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 2492 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["Locality"] = locality.toString();
															#line 2494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["DataFolder"] = folder;
															#line 2495 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StoresPresent"] = format("%d", stores.size());
															#line 2497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::WORKER, interf.id(), interf.id(), details);
															#line 2498 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(traceRole(Role::WORKER, interf.id()));
															#line 2511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recoveredDiskFiles;
															#line 2512 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> recoverDiskFiles = trigger( [=]() { TraceEvent("DiskFileRecoveriesComplete", interf.id()); recoveredDiskFiles.send(Void()); }, waitForAll(recoveries));
															#line 2518 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(recoverDiskFiles);
															#line 2520 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(registrationClient(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 2538 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (configNode.isValid())
															#line 12093 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(brokenPromiseToNever(localConfig->consume(configBroadcastInterface)));
															#line 12097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (SERVER_KNOBS->ENABLE_WORKER_HEALTH_MONITOR)
															#line 12101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( healthMonitor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 12105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 12109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!(index < stores.size()))
															#line 12125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2323 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		s = stores[index];
															#line 2327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (s.storedComponent == DiskStore::Storage)
															#line 12133 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (index >= 2 && SERVER_KNOBS->WORKER_START_STORAGE_DELAY > 0.0)
															#line 12137 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->WORKER_START_STORAGE_DELAY);
															#line 2331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 2;
															#line 2331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 1, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont3(loopDepth);
			}
		}
		else
		{
															#line 2423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (s.storedComponent == DiskStore::TLogData)
															#line 12160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				LocalLineage _;
															#line 2425 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::string logQueueBasename;
															#line 2427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const std::string filename = basename(s.filename);
															#line 2428 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (StringRef(filename).startsWith(fileLogDataPrefix))
															#line 12172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString();
															#line 12176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 2431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StringRef optionsString = StringRef(filename).removePrefix(fileVersionedLogDataPrefix).eat("-");
															#line 2432 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString() + optionsString.toString() + "-";
															#line 12184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 2434 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT_WE_THINK(abspath(parentDirectory(s.filename)) == folder);
															#line 2435 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IKeyValueStore* kv = openKVStore(s.storeType, s.filename, s.storeID, memoryLimit, validateDataFiles, false, false, dbInfo, EncryptionAtRestMode());
															#line 2444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const DiskQueueVersion dqv = s.tLogOptions.getDiskQueueVersion();
															#line 2445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const int64_t diskQueueWarnSize = s.tLogOptions.spillType == TLogSpillType::VALUE ? 10 * SERVER_KNOBS->TARGET_BYTES_PER_TLOG : -1;
															#line 2447 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IDiskQueue* queue = openDiskQueue(joinPath(folder, logQueueBasename + s.storeID.toString() + "-"), tlogQueueExtension.toString(), s.storeID, dqv, diskQueueWarnSize);
															#line 2452 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(kv->onClosed());
															#line 2453 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(queue->onClosed());
															#line 2455 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::map<std::string, std::string> details;
															#line 2456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				details["StorageEngine"] = s.storeType.toString();
															#line 2457 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::SHARED_TRANSACTION_LOG, s.storeID, interf.id(), details, "Restored");
															#line 2459 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> oldLog;
															#line 2460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> recovery;
															#line 2461 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TLogFn tLogFn = tLogFnForOptions(s.tLogOptions);
															#line 2462 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto& logData = sharedLogs[SharedLogsKey(s.tLogOptions, s.storeType)];
															#line 2463 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.push_back(SharedLogsValue());
															#line 2467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> tl = tLogFn(kv, queue, dbInfo, locality, logData.back().requests, s.storeID, interf.id(), true, oldLog, recovery, folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2481 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				recoveries.push_back(recovery.getFuture());
															#line 2482 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				activeSharedTLog->set(s.storeID);
															#line 2484 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, kv, s.storeID);
															#line 2485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, queue, s.storeID);
															#line 2486 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().actor = oldLog.getFuture() || tl;
															#line 2487 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().uid = s.storeID;
															#line 2488 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, s.storeID, tl));
															#line 12232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		++index;
															#line 12256 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2333 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2336 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		IKeyValueStore* kv = openKVStore( s.storeType, s.filename, s.storeID, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( s.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && s.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, Optional<EncryptionAtRestMode>(), 0, encryptionMonitor);
															#line 2354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> kvClosed = kv->onClosed() || rebootKVSPromise.getFuture();
															#line 2357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(kvClosed);
															#line 2360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string tssPrefix = testingStoragePrefix.toString();
															#line 2363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool isTss = s.filename.find(tssPrefix) != std::string::npos;
															#line 2364 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2366 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 2367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = s.storeID;
															#line 2368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2369 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 2373 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2376 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StorageEngine"] = s.storeType.toString();
															#line 2377 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["IsTSS"] = isTss ? "Yes" : "No";
															#line 2379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(ssRole, recruited.id(), interf.id(), details, "Restored");
															#line 2381 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 2382 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 2383 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 2384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 2386 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 2387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 2388 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 2389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2390 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 2391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2394 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 2395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2396 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 2397 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 2398 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2400 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(kv->getError());
															#line 2401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recovery;
															#line 2402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> f = storageServer(kv, recruited, dbInfo, folder, recovery, connRecord, encryptionMonitor);
															#line 2403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries.push_back(recovery.getFuture());
															#line 2405 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = handleIOErrors(f, storeError, s.storeID, kvClosed);
															#line 2406 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = storageServerRollbackRebooter(&runningStorages, &storageCleaners, f, s.storeType, s.filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, kv, validateDataFiles, &rebootKVSPromise, encryptionMonitor);
															#line 2422 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(forwardError(errors, ssRole, recruited.id(), f));
															#line 12349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 2548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_2 = interf.updateServerDBInfo.getFuture();
															#line 12452 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<UpdateServerDBInfoRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<UpdateServerDBInfoRequest>>::value, "invalid type");
															#line 2547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_2.pop(), loopDepth); };
															#line 2587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_3 = interf.clientInterface.reboot.getFuture();
															#line 12460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RebootRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RebootRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2(__when_expr_3.pop(), loopDepth); };
															#line 2618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_4 = interf.clientInterface.setFailureInjection.getFuture();
															#line 12465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<SetFailureInjection>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<SetFailureInjection>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3(__when_expr_4.pop(), loopDepth); };
															#line 2634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_5 = interf.clientInterface.profiler.getFuture();
															#line 12470 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ProfilerRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ProfilerRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when4(__when_expr_5.pop(), loopDepth); };
															#line 2655 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_6 = interf.master.getFuture();
															#line 12475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RecruitMasterRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RecruitMasterRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when5(__when_expr_6.pop(), loopDepth); };
															#line 2677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_7 = interf.dataDistributor.getFuture();
															#line 12480 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<InitializeDataDistributorRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<InitializeDataDistributorRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when6(__when_expr_7.pop(), loopDepth); };
															#line 2703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_8 = interf.ratekeeper.getFuture();
															#line 12485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_8), FutureStream<InitializeRatekeeperRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<InitializeRatekeeperRequest>>::value, "invalid type");
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when7(__when_expr_8.pop(), loopDepth); };
															#line 2730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_9 = interf.consistencyScan.getFuture();
															#line 12490 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_9), FutureStream<InitializeConsistencyScanRequest>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<InitializeConsistencyScanRequest>>::value, "invalid type");
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when8(__when_expr_9.pop(), loopDepth); };
															#line 2755 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_10 = interf.backup.getFuture();
															#line 12495 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_10), FutureStream<InitializeBackupRequest>>::value || std::is_same<decltype(__when_expr_10), ThreadFutureStream<InitializeBackupRequest>>::value, "invalid type");
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when9(__when_expr_10.pop(), loopDepth); };
															#line 2777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_11 = interf.encryptKeyProxy.getFuture();
															#line 12500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_11), FutureStream<InitializeEncryptKeyProxyRequest>>::value || std::is_same<decltype(__when_expr_11), ThreadFutureStream<InitializeEncryptKeyProxyRequest>>::value, "invalid type");
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont2Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when10(__when_expr_11.pop(), loopDepth); };
															#line 2806 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_12 = interf.tLog.getFuture();
															#line 12505 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_12), FutureStream<InitializeTLogRequest>>::value || std::is_same<decltype(__when_expr_12), ThreadFutureStream<InitializeTLogRequest>>::value, "invalid type");
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont2Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when11(__when_expr_12.pop(), loopDepth); };
															#line 2882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_13 = interf.storage.getFuture();
															#line 12510 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_13), FutureStream<InitializeStorageRequest>>::value || std::is_same<decltype(__when_expr_13), ThreadFutureStream<InitializeStorageRequest>>::value, "invalid type");
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont2Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when12(__when_expr_13.pop(), loopDepth); };
															#line 3027 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_14 = interf.commitProxy.getFuture();
															#line 12515 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_14), FutureStream<InitializeCommitProxyRequest>>::value || std::is_same<decltype(__when_expr_14), ThreadFutureStream<InitializeCommitProxyRequest>>::value, "invalid type");
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont2Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when13(__when_expr_14.pop(), loopDepth); };
															#line 3054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_15 = interf.grvProxy.getFuture();
															#line 12520 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_15), FutureStream<InitializeGrvProxyRequest>>::value || std::is_same<decltype(__when_expr_15), ThreadFutureStream<InitializeGrvProxyRequest>>::value, "invalid type");
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont2Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when14(__when_expr_15.pop(), loopDepth); };
															#line 3076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_16 = interf.resolver.getFuture();
															#line 12525 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_16), FutureStream<InitializeResolverRequest>>::value || std::is_same<decltype(__when_expr_16), ThreadFutureStream<InitializeResolverRequest>>::value, "invalid type");
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont2Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when15(__when_expr_16.pop(), loopDepth); };
															#line 3095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_17 = interf.logRouter.getFuture();
															#line 12530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_17), FutureStream<InitializeLogRouterRequest>>::value || std::is_same<decltype(__when_expr_17), ThreadFutureStream<InitializeLogRouterRequest>>::value, "invalid type");
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont2Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when16(__when_expr_17.pop(), loopDepth); };
															#line 3125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_18 = interf.coordinationPing.getFuture();
															#line 12535 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_18), FutureStream<CoordinationPingMessage>>::value || std::is_same<decltype(__when_expr_18), ThreadFutureStream<CoordinationPingMessage>>::value, "invalid type");
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont2Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when17(__when_expr_18.pop(), loopDepth); };
															#line 3130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_19 = interf.setMetricsRate.getFuture();
															#line 12540 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_19), FutureStream<SetMetricsLogRateRequest>>::value || std::is_same<decltype(__when_expr_19), ThreadFutureStream<SetMetricsLogRateRequest>>::value, "invalid type");
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont2Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when18(__when_expr_19.pop(), loopDepth); };
															#line 3139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_20 = interf.eventLogRequest.getFuture();
															#line 12545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_20), FutureStream<EventLogRequest>>::value || std::is_same<decltype(__when_expr_20), ThreadFutureStream<EventLogRequest>>::value, "invalid type");
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont2Catch1(__when_expr_20.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when19(__when_expr_20.pop(), loopDepth); };
															#line 3147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_21 = interf.traceBatchDumpRequest.getFuture();
															#line 12550 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_21), FutureStream<TraceBatchDumpRequest>>::value || std::is_same<decltype(__when_expr_21), ThreadFutureStream<TraceBatchDumpRequest>>::value, "invalid type");
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont2Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when20(__when_expr_21.pop(), loopDepth); };
															#line 3151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_22 = interf.diskStoreRequest.getFuture();
															#line 12555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_22), FutureStream<DiskStoreRequest>>::value || std::is_same<decltype(__when_expr_22), ThreadFutureStream<DiskStoreRequest>>::value, "invalid type");
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont2Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when21(__when_expr_22.pop(), loopDepth); };
															#line 3192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_23 = loggingTrigger;
															#line 12560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont2Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when22(__when_expr_23.get(), loopDepth); };
															#line 3196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_24 = interf.workerSnapReq.getFuture();
															#line 12564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_24), FutureStream<WorkerSnapRequest>>::value || std::is_same<decltype(__when_expr_24), ThreadFutureStream<WorkerSnapRequest>>::value, "invalid type");
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont2Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when23(__when_expr_24.pop(), loopDepth); };
															#line 3248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_25 = errorForwarders.getResult();
															#line 12569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont2Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when24(__when_expr_25.get(), loopDepth); };
															#line 3249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_26 = handleErrors;
															#line 12573 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont2Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when25(__when_expr_26.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 3;
															#line 2548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*>(static_cast<WorkerServerActor*>(this)));
															#line 2634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2655 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2755 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2806 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3027 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*>(static_cast<WorkerServerActor*>(this)));
															#line 3130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 23, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3248 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 25, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 26, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest const& req,int loopDepth) 
	{
															#line 2549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2553 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12645 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12661 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest && req,int loopDepth) 
	{
															#line 2549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2553 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12746 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest const& req,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12761 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2595 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2596 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12775 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_27 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_27.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest && req,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2595 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2596 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12818 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_27 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_27.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection const& req,int loopDepth) 
	{
															#line 2619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2621 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2622 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2625 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12859 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12865 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12870 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection && req,int loopDepth) 
	{
															#line 2619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2621 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2622 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2625 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest const& req,int loopDepth) 
	{
															#line 2635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2641 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2642 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2643 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2645 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2649 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest && req,int loopDepth) 
	{
															#line 2635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12967 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2641 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2642 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2643 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12975 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2645 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12983 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2649 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12989 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest const& req,int loopDepth) 
	{
															#line 2656 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2657 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2666 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest && req,int loopDepth) 
	{
															#line 2656 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2657 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2666 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest const& req,int loopDepth) 
	{
															#line 2678 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2679 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2680 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2681 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2685 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2696 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest && req,int loopDepth) 
	{
															#line 2678 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2679 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2680 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2681 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13126 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2685 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13132 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2696 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest const& req,int loopDepth) 
	{
															#line 2704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2705 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2706 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2709 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2714 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2716 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2717 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2725 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest && req,int loopDepth) 
	{
															#line 2704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2705 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2706 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2709 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13218 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2714 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2716 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2717 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2725 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 2731 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2732 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13267 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2740 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2745 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13295 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest && req,int loopDepth) 
	{
															#line 2731 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2732 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2740 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2745 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest const& req,int loopDepth) 
	{
															#line 2756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2760 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2765 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2769 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2770 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2774 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest && req,int loopDepth) 
	{
															#line 2756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2760 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2765 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2769 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2770 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13425 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2774 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeEncryptKeyProxyRequest const& req,int loopDepth) 
	{
															#line 2778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2779 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2780 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 13449 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 13455 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2789 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2795 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2801 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 13479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeEncryptKeyProxyRequest && req,int loopDepth) 
	{
															#line 2778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2779 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2780 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 13502 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 13508 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2789 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2795 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2801 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 13532 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13538 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeTLogRequest const& req,int loopDepth) 
	{
															#line 2811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13553 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2817 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2818 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2822 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2823 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13573 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2826 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2827 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2828 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2833 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2837 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 2848 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2849 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2859 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2873 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2874 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2879 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeTLogRequest && req,int loopDepth) 
	{
															#line 2811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2817 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2818 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2822 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2823 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13650 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2826 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2827 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2828 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2833 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2837 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 2848 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2849 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2859 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2873 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2874 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13694 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2879 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeStorageRequest const& req,int loopDepth) 
	{
															#line 2883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2888 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2889 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2893 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2911 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2925 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2926 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2927 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2928 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2936 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2939 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2940 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2943 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2944 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2948 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2952 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2953 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2960 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2962 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 2979 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2989 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 2991 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 2992 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3002 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3021 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeStorageRequest && req,int loopDepth) 
	{
															#line 2883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2888 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2889 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2893 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2911 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2925 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2926 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2927 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2928 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2936 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2939 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2940 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2943 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2944 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2948 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2952 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2953 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2960 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2962 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 2979 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2989 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 2991 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 2992 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3002 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13979 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3021 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13987 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeCommitProxyRequest const& req,int loopDepth) 
	{
															#line 3028 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3029 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3032 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3033 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3036 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3037 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3041 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3042 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3043 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3044 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3045 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3047 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3052 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeCommitProxyRequest && req,int loopDepth) 
	{
															#line 3028 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3029 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3032 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3033 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3036 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3037 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3041 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3042 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3043 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3044 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3045 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3047 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3052 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeGrvProxyRequest const& req,int loopDepth) 
	{
															#line 3055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3057 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3058 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3059 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3060 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3062 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3064 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3067 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3071 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeGrvProxyRequest && req,int loopDepth) 
	{
															#line 3055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3057 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3058 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3059 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3060 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3062 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3063 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3064 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3067 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3071 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeResolverRequest const& req,int loopDepth) 
	{
															#line 3077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3078 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3079 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3080 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3081 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3086 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3087 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3091 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3093 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeResolverRequest && req,int loopDepth) 
	{
															#line 3077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3078 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3079 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3080 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3081 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3083 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3086 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3087 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3091 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3093 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(InitializeLogRouterRequest const& req,int loopDepth) 
	{
															#line 3096 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3098 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3104 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3108 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3110 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3111 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3114 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3115 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3121 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14257 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3122 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(recruited);
															#line 14261 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(InitializeLogRouterRequest && req,int loopDepth) 
	{
															#line 3096 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3098 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3104 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3108 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3110 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3111 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3114 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3115 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3121 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3122 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(recruited);
															#line 14313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(CoordinationPingMessage const& m,int loopDepth) 
	{
															#line 3126 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14323 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(CoordinationPingMessage && m,int loopDepth) 
	{
															#line 3126 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14332 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(SetMetricsLogRateRequest const& req,int loopDepth) 
	{
															#line 3131 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3134 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14343 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3136 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(SetMetricsLogRateRequest && req,int loopDepth) 
	{
															#line 3131 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3134 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14361 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3136 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(EventLogRequest const& req,int loopDepth) 
	{
															#line 3140 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3141 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3142 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14383 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(EventLogRequest && req,int loopDepth) 
	{
															#line 3140 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3141 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14404 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3142 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3144 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14414 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14418 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(TraceBatchDumpRequest const& req,int loopDepth) 
	{
															#line 3148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(TraceBatchDumpRequest && req,int loopDepth) 
	{
															#line 3148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(DiskStoreRequest const& req,int loopDepth) 
	{
															#line 3152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14455 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14459 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14463 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 3165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14473 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						{
															#line 3167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14489 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							{
															#line 3169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3171 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14499 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								{
															#line 3172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14503 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14509 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									{
															#line 3175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14513 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3178 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14521 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14534 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(DiskStoreRequest && req,int loopDepth) 
	{
															#line 3152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3161 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14563 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14577 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 3165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						{
															#line 3167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14597 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							{
															#line 3169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3171 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								{
															#line 3172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14617 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									{
															#line 3175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14621 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3178 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14642 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14651 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14656 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(Void const& _,int loopDepth) 
	{
															#line 3193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(Void && _,int loopDepth) 
	{
															#line 3193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14678 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(WorkerSnapRequest const& __snapReq,int loopDepth) 
	{
															#line 3196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReq = __snapReq;
															#line 3197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3199 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3206 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3208 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3218 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14721 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 3231 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3242 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14749 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(WorkerSnapRequest && __snapReq,int loopDepth) 
	{
		snapReq = std::move(__snapReq);
															#line 3197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14764 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3199 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14774 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3206 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14780 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3208 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3218 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14802 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14808 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 3231 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3242 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14816 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3244 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14822 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when25(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when25(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 3, RebootRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 23, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 25, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 26, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12loopBody1when2cont1(int loopDepth) 
	{
															#line 2606 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (g_network->isSimulated())
															#line 14945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("SimulatedReboot").detail("Deletion", rebootReq.deleteData);
															#line 2608 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (rebootReq.deleteData)
															#line 14951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont2Catch1(please_reboot_delete(), std::max(0, loopDepth - 1));
															#line 14955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1cont2Catch1(please_reboot(), std::max(0, loopDepth - 1));
															#line 14959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ProcessReboot").log();
															#line 2614 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!rebootReq.deleteData);
															#line 2615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushAndExit(0);
															#line 14969 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_28 = checkFile->sync();
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14981 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont2Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_28.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 14986 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_28 = checkFile->sync();
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14997 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont2Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_28.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 15002 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(checkFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(std::move(checkFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont12loopBody1when2cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2652 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			profilerReq.reply.sendError(e);
															#line 15294 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,InitializeTLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,InitializeTLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,InitializeStorageRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,InitializeStorageRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,InitializeResolverRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,InitializeResolverRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,InitializeLogRouterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,InitializeLogRouterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,CoordinationPingMessage const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,CoordinationPingMessage && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,EventLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,EventLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,TraceBatchDumpRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,TraceBatchDumpRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,DiskStoreRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,DiskStoreRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,WorkerSnapRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,WorkerSnapRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when25(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when25(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 26, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont2Catch1cont1(int loopDepth) 
	{
															#line 3276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_31 = deregisterGrpcService(interf.id());
															#line 3276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont2Catch1cont1when1(__when_expr_31.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 8;
															#line 3276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 31, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = delay(0.0);
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16599 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void && _,int loopDepth) 
	{
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = delay(0.0);
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont2Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 3273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont4(Void && _,int loopDepth) 
	{
															#line 3273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16708 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont2Catch1cont6(Void const& _,int loopDepth) 
	{
															#line 3277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2Catch1cont6(Void && _,int loopDepth) 
	{
															#line 3277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 31, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 31, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 31, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 31, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsConnFile;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsPrefix;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryProfileThreshold;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string _coordFolder;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string whitelistBinPaths;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool consistencyCheckUrgentMode;
															#line 2184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 2185 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>>> ddInterf;
															#line 2187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>>> rkInterf;
															#line 2188 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<EncryptKeyProxyInterface>>> ekpInterf;
															#line 2190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>>> csInterf;
															#line 2192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> handleErrors;
															#line 2193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection errorForwarders;
															#line 2194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> loggingTrigger;
															#line 2195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double loggingDelay;
															#line 2197 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise;
															#line 2198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise2;
															#line 2199 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection filesClosed;
															#line 2200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> stopping;
															#line 2201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> metricsLogger;
															#line 2202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> chaosMetricsActor;
															#line 2203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> degraded;
															#line 2209 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<SharedLogsKey, std::vector<SharedLogsValue>> sharedLogs;
															#line 2210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<UID>> activeSharedTLog;
															#line 2211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerCache<InitializeBackupReply> backupWorkerCache;
															#line 2212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> blobWorkerFuture;
															#line 2214 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest lastSnapReq;
															#line 2216 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest> snapReqMap;
															#line 2217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>> snapReqResultMap;
															#line 2218 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double lastSnapTime;
															#line 2219 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string coordFolder;
															#line 2221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 2223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>> runningStorages;
															#line 2228 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner> storageCleaners;
															#line 2232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 2234 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> updateClusterIdFuture;
															#line 2238 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 2241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> grpc;
															#line 2253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 2316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<Void>> recoveries;
															#line 2319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<DiskStore> stores;
															#line 2320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 2321 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int index;
															#line 2323 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DiskStore s;
															#line 2588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RebootRequest rebootReq;
															#line 2635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest profilerReq;
															#line 3196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 3255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Error e;
															#line 16999 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerServer()
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActor final : public Actor<Void>, public ActorCallback< WorkerServerActor, 0, Void >, public ActorCallback< WorkerServerActor, 1, Void >, public ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >, public ActorSingleCallback< WorkerServerActor, 3, RebootRequest >, public ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >, public ActorCallback< WorkerServerActor, 28, Void >, public ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >, public ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >, public ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >, public ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >, public ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >, public ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >, public ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >, public ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >, public ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >, public ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >, public ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >, public ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >, public ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >, public ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >, public ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >, public ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >, public ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >, public ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >, public ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >, public ActorCallback< WorkerServerActor, 23, Void >, public ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >, public ActorCallback< WorkerServerActor, 25, Void >, public ActorCallback< WorkerServerActor, 26, Void >, public ActorCallback< WorkerServerActor, 29, Void >, public ActorCallback< WorkerServerActor, 30, Void >, public ActorCallback< WorkerServerActor, 31, Void >, public FastAllocated<WorkerServerActor>, public WorkerServerActorState<WorkerServerActor> {
															#line 17004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerServerActor>::operator new;
	using FastAllocated<WorkerServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12334048758613490688UL, 551509310565741312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerServerActor, 0, Void >;
friend struct ActorCallback< WorkerServerActor, 1, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 3, RebootRequest >;
friend struct ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >;
friend struct ActorCallback< WorkerServerActor, 28, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >;
friend struct ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >;
friend struct ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >;
friend struct ActorCallback< WorkerServerActor, 23, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >;
friend struct ActorCallback< WorkerServerActor, 25, Void >;
friend struct ActorCallback< WorkerServerActor, 26, Void >;
friend struct ActorCallback< WorkerServerActor, 29, Void >;
friend struct ActorCallback< WorkerServerActor, 30, Void >;
friend struct ActorCallback< WorkerServerActor, 31, Void >;
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActor(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 17052 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerServerActorState<WorkerServerActor>(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18295874337252228096UL, 18130278596491120640UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WorkerServerActor, 28, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WorkerServerActor, 29, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WorkerServerActor, 30, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WorkerServerActor, 31, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerServer( Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, LocalityData const& locality, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, std::string const& folder, int64_t const& memoryLimit, std::string const& metricsConnFile, std::string const& metricsPrefix, int64_t const& memoryProfileThreshold, std::string const& _coordFolder, std::string const& whitelistBinPaths, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, ConfigBroadcastInterface const& configBroadcastInterface, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, Reference<AsyncVar<Optional<UID>>> const& clusterId, bool const& consistencyCheckUrgentMode ) {
															#line 2166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerServerActor(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode));
															#line 17092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 3280 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 17097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via extractClusterInterface()
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClusterInterfaceActor>
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActorState {
															#line 17104 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : in(in),
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   out(out)
															#line 17113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClusterInterfaceActorState() 
	{
		fdb_probe_actor_destroy("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClusterInterfaceActorState();
		static_cast<ExtractClusterInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (in->get().present())
															#line 17158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3285 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			out->set(in->get().get().clientInterface);
															#line 17162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			out->set(Optional<ClusterInterface>());
															#line 17168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = in->onChange();
															#line 3289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 1;
															#line 3289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClusterInterfaceActor, 0, Void >*>(static_cast<ExtractClusterInterfaceActor*>(this)));
															#line 17179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state > 0) static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClusterInterfaceActor*>(this)->ActorCallback< ExtractClusterInterfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> in;
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterInterface>>> out;
															#line 17275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via extractClusterInterface()
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActor final : public Actor<Void>, public ActorCallback< ExtractClusterInterfaceActor, 0, Void >, public FastAllocated<ExtractClusterInterfaceActor>, public ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor> {
															#line 17280 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ExtractClusterInterfaceActor>::operator new;
	using FastAllocated<ExtractClusterInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15695194918263067904UL, 7234067898243253760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClusterInterfaceActor, 0, Void >;
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 17297 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor>(in, out),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(557938279338987264UL, 16164323909019904512UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClusterInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClusterInterfaceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> extractClusterInterface( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in, Reference<AsyncVar<Optional<ClusterInterface>>> const& out ) {
															#line 3281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClusterInterfaceActor(in, out));
															#line 17330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 3292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

static std::set<int> const& normalWorkerErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_please_reboot);
		s.insert(error_code_please_reboot_delete);
		s.insert(error_code_local_config_changed);
		s.insert(error_code_invalid_cluster_id);
	}
	return s;
}

															#line 17346 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via printTimeout()
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintTimeoutActor>
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActorState {
															#line 17353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActorState() 
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 17359 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		fdb_probe_actor_create("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	~PrintTimeoutActorState() 
	{
		fdb_probe_actor_destroy("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(5);
															#line 3305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 1;
															#line 3305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintTimeoutActor, 0, Void >*>(static_cast<PrintTimeoutActor*>(this)));
															#line 17380 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17409 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17413 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17425 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17435 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state > 0) static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<PrintTimeoutActor*>(this)->ActorCallback< PrintTimeoutActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via printTimeout()
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActor final : public Actor<Void>, public ActorCallback< PrintTimeoutActor, 0, Void >, public FastAllocated<PrintTimeoutActor>, public PrintTimeoutActorState<PrintTimeoutActor> {
															#line 17522 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<PrintTimeoutActor>::operator new;
	using FastAllocated<PrintTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13752831585184207616UL, 13784655437391558144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintTimeoutActor, 0, Void >;
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActor() 
															#line 17539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   PrintTimeoutActorState<PrintTimeoutActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981782795374445824UL, 6705174968519855616UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> printTimeout(  ) {
															#line 3304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new PrintTimeoutActor());
															#line 17572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 3312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 17577 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via printOnFirstConnected()
															#line 3313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintOnFirstConnectedActor>
															#line 3313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintOnFirstConnectedActorState {
															#line 17584 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 3313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintOnFirstConnectedActorState(Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci) 
															#line 3313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 3313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ci(ci),
															#line 3314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   timeoutFuture(printTimeout())
															#line 17593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	~PrintOnFirstConnectedActorState() 
	{
		fdb_probe_actor_destroy("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3315 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17608 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3317 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ci->get().present() ? IFailureMonitor::failureMonitor().onStateEqual( ci->get().get().openDatabase.getEndpoint(), FailureStatus(false)) : Never();
															#line 3316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 3324 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ci->onChange();
															#line 17644 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 1;
															#line 3317 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 0, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 3324 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 1, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 17651 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 3320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3321 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17670 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 3320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3321 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17686 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state > 0) static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 0;
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 0, Void >::remove();
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifie