#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
/*
 * ConfigDatabaseUnitTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/IConfigTransaction.h"
#include "fdbclient/TestKnobCollection.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbclient/Tuple.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // must be last include

namespace {

Key encodeConfigKey(Optional<KeyRef> configClass, KeyRef knobName) {
	Tuple tuple;
	if (configClass.present()) {
		tuple.append(configClass.get());
	} else {
		tuple.appendNull();
	}
	tuple << knobName;
	return tuple.pack();
}

void appendVersionedMutation(Standalone<VectorRef<VersionedConfigMutationRef>>& versionedMutations,
                             Version version,
                             Optional<KeyRef> configClass,
                             KeyRef knobName,
                             Optional<KnobValueRef> knobValue) {
	auto configKey = ConfigKeyRef(configClass, knobName);
	auto mutation = ConfigMutationRef(configKey, knobValue);
	versionedMutations.emplace_back_deep(versionedMutations.arena(), version, mutation);
}

class WriteToTransactionEnvironment {
	std::string dataDir;
	ConfigTransactionInterface cti;
	ConfigFollowerInterface cfi;
	Reference<ConfigNode> node;
	Future<Void> ctiServer;
	Future<Void> cfiServer;
	Version lastWrittenVersion{ 0 };

	static Value longToValue(int64_t v) {
		auto s = format("%lld", v);
		return StringRef(reinterpret_cast<uint8_t const*>(s.c_str()), s.size());
	}

																#line 70 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via set()
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetActor>
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetActorState {
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetActorState(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,int64_t const& value) 
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   value(value),
															#line 72 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->cti))
															#line 91 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("set", reinterpret_cast<unsigned long>(this));

	}
	~SetActorState() 
	{
		fdb_probe_actor_destroy("set", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			auto configKey = encodeConfigKey(configClass, knobName);
															#line 74 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			tr->set(configKey, longToValue(value));
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetActor, 0, Void >*>(static_cast<SetActor*>(this)));
															#line 117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetActorState();
		static_cast<SetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 77 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 142 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 77 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 156 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetActor*>(this)->actor_wait_state > 0) static_cast<SetActor*>(this)->actor_wait_state = 0;
		static_cast<SetActor*>(this)->ActorCallback< SetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	WriteToTransactionEnvironment* self;
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	int64_t value;
															#line 72 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via set()
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetActor final : public Actor<Void>, public ActorCallback< SetActor, 0, Void >, public FastAllocated<SetActor>, public SetActorState<SetActor> {
															#line 254 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetActor>::operator new;
	using FastAllocated<SetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14793030850437822208UL, 3784695557585567744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetActor, 0, Void >;
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetActor(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,int64_t const& value) 
															#line 271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetActorState<SetActor>(self, configClass, knobName, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15524163840979486720UL, 4513504769136616192UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("set");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> set( WriteToTransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName, int64_t const& value ) {
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetActor(self, configClass, knobName, value));
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 79 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via clear()
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class ClearActor>
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class ClearActorState {
															#line 314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ClearActorState(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName) 
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 83 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->cti))
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("clear", reinterpret_cast<unsigned long>(this));

	}
	~ClearActorState() 
	{
		fdb_probe_actor_destroy("clear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			auto configKey = encodeConfigKey(configClass, knobName);
															#line 85 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			tr->clear(configKey);
															#line 86 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 86 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<ClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 348 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearActor*>(this)->actor_wait_state = 1;
															#line 86 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearActor, 0, Void >*>(static_cast<ClearActor*>(this)));
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<ClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearActorState(); static_cast<ClearActor*>(this)->destroy(); return 0; }
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<ClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<ClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearActorState(); static_cast<ClearActor*>(this)->destroy(); return 0; }
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<ClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearActor*>(this)->actor_wait_state > 0) static_cast<ClearActor*>(this)->actor_wait_state = 0;
		static_cast<ClearActor*>(this)->ActorCallback< ClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	WriteToTransactionEnvironment* self;
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 83 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via clear()
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class ClearActor final : public Actor<Void>, public ActorCallback< ClearActor, 0, Void >, public FastAllocated<ClearActor>, public ClearActorState<ClearActor> {
															#line 488 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<ClearActor>::operator new;
	using FastAllocated<ClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4586948779903731712UL, 5421431040099233024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearActor, 0, Void >;
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ClearActor(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName) 
															#line 505 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   ClearActorState<ClearActor>(self, configClass, knobName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3507049568125712128UL, 16633398102453084160UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> clear( WriteToTransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName ) {
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new ClearActor(self, configClass, knobName));
															#line 537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 90 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

	void setup() {
		ctiServer = node->serve(cti);
		cfiServer = node->serve(cfi);
	}

public:
	WriteToTransactionEnvironment(std::string const& dataDir)
	  : dataDir(dataDir), node(makeReference<ConfigNode>(dataDir)) {
		platform::eraseDirectoryRecursive(dataDir);
		setup();
	}

	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		return set(this, configClass, knobName, value);
	}

	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return clear(this, configClass, knobName); }

	Future<Void> compact() { return cfi.compact.getReply(ConfigFollowerCompactRequest{ lastWrittenVersion }); }

	Future<Void> rollforward(Optional<Version> rollback,
	                         Version lastKnownCommitted,
	                         Version target,
	                         Standalone<VectorRef<VersionedConfigMutationRef>> mutations,
	                         Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations) {
		return cfi.rollforward.getReply(
		    ConfigFollowerRollforwardRequest{ rollback, lastKnownCommitted, target, mutations, annotations, false });
	}

	void restartNode() {
		cfiServer.cancel();
		ctiServer.cancel();
		node = makeReference<ConfigNode>(dataDir);
		setup();
	}

	ConfigTransactionInterface getTransactionInterface() const { return cti; }

	ConfigFollowerInterface getFollowerInterface() const { return cfi; }

	void close() const { node->close(); }

	Future<Void> onClosed() const { return node->onClosed(); }

	Future<Void> getError() const { return cfiServer || ctiServer; }
};

class ReadFromLocalConfigEnvironment {
	UID id;
	std::string dataDir;
	Reference<LocalConfiguration> localConfiguration;
	Reference<AsyncVar<ConfigBroadcastInterface> const> cbi;
	Future<Void> consumer;

																#line 596 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via checkEventually()
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E, class CheckEventuallyActor>
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckEventuallyActorState {
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckEventuallyActorState(Reference<LocalConfiguration const> const& localConfiguration,V T::* const& member,Optional<E> const& expected) 
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : localConfiguration(localConfiguration),
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   member(member),
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   expected(expected),
															#line 149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   lastMismatchTime(now())
															#line 615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("checkEventually", reinterpret_cast<unsigned long>(this));

	}
	~CheckEventuallyActorState() 
	{
		fdb_probe_actor_destroy("checkEventually", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			;
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckEventuallyActorState();
		static_cast<CheckEventuallyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (localConfiguration->getTestKnobs().*member == expected.orDefault(0))
															#line 660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (!static_cast<CheckEventuallyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckEventuallyActorState(); static_cast<CheckEventuallyActor*>(this)->destroy(); return 0; }
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			new (&static_cast<CheckEventuallyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckEventuallyActorState();
			static_cast<CheckEventuallyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (now() > lastMismatchTime + 1.0)
															#line 672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			TraceEvent(SevWarn, "CheckEventuallyStillChecking") .detail("Expected", expected.present() ? expected.get() : 0) .detail("TestMember", localConfiguration->getTestKnobs().*member);
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			lastMismatchTime = now();
															#line 678 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(0.1);
															#line 160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<CheckEventuallyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckEventuallyActor*>(this)->actor_wait_state = 1;
															#line 160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckEventuallyActor, 0, Void >*>(static_cast<CheckEventuallyActor*>(this)));
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckEventuallyActor*>(this)->actor_wait_state > 0) static_cast<CheckEventuallyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckEventuallyActor*>(this)->ActorCallback< CheckEventuallyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckEventuallyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckEventuallyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckEventuallyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<LocalConfiguration const> localConfiguration;
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	V T::* member;
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<E> expected;
															#line 149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	double lastMismatchTime;
															#line 789 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via checkEventually()
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E>
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckEventuallyActor final : public Actor<Void>, public ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >, public FastAllocated<CheckEventuallyActor<T, V, E>>, public CheckEventuallyActorState<T, V, E, CheckEventuallyActor<T, V, E>> {
															#line 796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<CheckEventuallyActor<T, V, E>>::operator new;
	using FastAllocated<CheckEventuallyActor<T, V, E>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6372197574669092608UL, 15925095099663341824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >;
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckEventuallyActor(Reference<LocalConfiguration const> const& localConfiguration,V T::* const& member,Optional<E> const& expected) 
															#line 813 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheckEventuallyActorState<T, V, E, CheckEventuallyActor<T, V, E>>(localConfiguration, member, expected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4366034608073670656UL, 7348849017565997056UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkEventually");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E>
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> checkEventually( Reference<LocalConfiguration const> const& localConfiguration, V T::* const& member, Optional<E> const& expected ) {
															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new CheckEventuallyActor<T, V, E>(localConfiguration, member, expected));
															#line 847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 852 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor>
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActorState {
															#line 858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActorState(ReadFromLocalConfigEnvironment* const& self) 
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self)
															#line 865 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->localConfiguration->initialize();
															#line 165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (self->cbi)
															#line 910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer.cancel();
															#line 175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer = self->localConfiguration->consume(self->cbi->get());
															#line 916 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (self->cbi)
															#line 932 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer.cancel();
															#line 175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer = self->localConfiguration->consume(self->cbi->get());
															#line 938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ReadFromLocalConfigEnvironment* self;
															#line 1027 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 1032 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11989382910569922048UL, 907147050005876736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor(ReadFromLocalConfigEnvironment* const& self) 
															#line 1049 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( ReadFromLocalConfigEnvironment* const& self ) {
															#line 164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor(self));
															#line 1081 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	ReadFromLocalConfigEnvironment(std::string const& dataDir,
	                               std::string const& configPath,
	                               std::map<std::string, std::string> const& manualKnobOverrides)
	  : dataDir(dataDir),
	    localConfiguration(makeReference<LocalConfiguration>(dataDir, configPath, manualKnobOverrides, IsTest::True)),
	    consumer(Never()) {}

	Future<Void> setup() { return setup(this); }

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		std::map<std::string, std::string> manualKnobOverrides = {};
		localConfiguration =
		    makeReference<LocalConfiguration>(dataDir, newConfigPath, manualKnobOverrides, IsTest::True);
		return setup();
	}

	void connectToBroadcaster(Reference<AsyncVar<ConfigBroadcastInterface> const> const& cbi) {
		this->cbi = cbi;
		consumer = localConfiguration->consume(cbi->get());
	}

	template <class T, class V, class E>
	void checkImmediate(V T::* member, Optional<E> expected) const {
		if (expected.present()) {
			ASSERT_EQ(localConfiguration->getTestKnobs().*member, expected.get());
		} else {
			ASSERT_EQ(localConfiguration->getTestKnobs().*member, 0);
		}
	}

	template <class T, class V, class E>
	Future<Void> checkEventually(V T::* member, Optional<E> expected) const {
		return checkEventually(localConfiguration, member, expected);
	}

	LocalConfiguration& getMutableLocalConfiguration() { return *localConfiguration; }

	void close() const { localConfiguration->close(); }
	Future<Void> onClosed() const { return localConfiguration->onClosed(); }

	Future<Void> getError() const { return consumer; }

	Version lastSeenVersion() { return localConfiguration->lastSeenVersion(); }

	ConfigClassSet configClassSet() { return localConfiguration->configClassSet(); }
};

class LocalConfigEnvironment {
	ReadFromLocalConfigEnvironment readFrom;
	Version lastWrittenVersion{ 0 };

	Future<Void> addMutation(Optional<KeyRef> configClass, KeyRef knobName, Optional<KnobValueRef> value) {
		Standalone<VectorRef<VersionedConfigMutationRef>> versionedMutations;
		appendVersionedMutation(versionedMutations, ++lastWrittenVersion, configClass, knobName, value);
		return readFrom.getMutableLocalConfiguration().addChanges(versionedMutations, lastWrittenVersion, 0);
	}

public:
	LocalConfigEnvironment(std::string const& dataDir,
	                       std::string const& configPath,
	                       std::map<std::string, std::string> const& manualKnobOverrides = {})
	  : readFrom(dataDir, configPath, manualKnobOverrides) {}
	Future<Void> setup(ConfigClassSet const& configClassSet) { return readFrom.setup(); }
	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}
	Future<Void> getError() const { return Never(); }
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return addMutation(configClass, knobName, {}); }
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		auto knobValue = KnobValueRef::create(value);
		return addMutation(configClass, knobName, knobValue.contents());
	}
	template <class T, class V, class E>
	void check(V T::* member, Optional<E> value) const {
		return readFrom.checkImmediate(member, value);
	}
};

class BroadcasterToLocalConfigEnvironment {
	ReadFromLocalConfigEnvironment readFrom;
	Reference<AsyncVar<ConfigBroadcastInterface>> cbi;
	ConfigBroadcaster broadcaster;
	Version lastWrittenVersion{ 0 };
	Future<Void> broadcastServer;
	Promise<Void> workerFailure;
	Future<Void> workerFailed_;

																#line 1174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor1>
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor1State {
															#line 1180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor1State(BroadcasterToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClassSet(configClassSet)
															#line 1189 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor1State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->readFrom.setup();
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1206 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor1*>(this)->actor_wait_state = 1;
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor1, 0, Void >*>(static_cast<SetupActor1*>(this)));
															#line 1211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 274 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 1240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 274 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 1258 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor1*>(this)->actor_wait_state > 0) static_cast<SetupActor1*>(this)->actor_wait_state = 0;
		static_cast<SetupActor1*>(this)->ActorCallback< SetupActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BroadcasterToLocalConfigEnvironment* self;
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ConfigClassSet configClassSet;
															#line 1345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor1 final : public Actor<Void>, public ActorCallback< SetupActor1, 0, Void >, public FastAllocated<SetupActor1>, public SetupActor1State<SetupActor1> {
															#line 1350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor1>::operator new;
	using FastAllocated<SetupActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11989382910569922048UL, 907147050005876736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor1, 0, Void >;
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor1(BroadcasterToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 1367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor1State<SetupActor1>(self, configClassSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7554903555599063552UL, 3002477495560883968UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( BroadcasterToLocalConfigEnvironment* const& self, ConfigClassSet const& configClassSet ) {
															#line 268 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor1(self, configClassSet));
															#line 1399 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

	void addMutation(Optional<KeyRef> configClass, KeyRef knobName, KnobValueRef value) {
		Standalone<VectorRef<VersionedConfigMutationRef>> versionedMutations;
		appendVersionedMutation(versionedMutations, ++lastWrittenVersion, configClass, knobName, value);
		broadcaster.applyChanges(versionedMutations, lastWrittenVersion, {}, {});
	}

public:
	BroadcasterToLocalConfigEnvironment(std::string const& dataDir, std::string const& configPath)
	  : readFrom(dataDir, configPath, {}), cbi(makeReference<AsyncVar<ConfigBroadcastInterface>>()),
	    broadcaster(ConfigFollowerInterface{}) {}

	Future<Void> setup(ConfigClassSet const& configClassSet) { return setup(this, configClassSet); }

	void set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		auto knobValue = KnobValueRef::create(value);
		addMutation(configClass, knobName, knobValue.contents());
	}

	void clear(Optional<KeyRef> configClass, KeyRef knobName) { addMutation(configClass, knobName, {}); }

	template <class T, class V, class E>
	Future<Void> check(V T::* member, Optional<E> value) const {
		return readFrom.checkEventually(member, value);
	}

	JsonBuilderObject getStatus() const { return broadcaster.getStatus(); }

	void changeBroadcaster() {
		broadcastServer.cancel();
		cbi->set(ConfigBroadcastInterface{});
		readFrom.connectToBroadcaster(cbi);
		broadcastServer = broadcaster.registerNode(
		    cbi->get(), readFrom.lastSeenVersion(), readFrom.configClassSet(), workerFailure.getFuture(), true);
	}

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}

	void killLocalConfig() {
		workerFailed_ = broadcaster.getClientFailure(cbi->get().id());
		workerFailure.send(Void());
	}

	Future<Void> workerFailed() {
		ASSERT(workerFailed_.isValid());
		return workerFailed_;
	}

	void compact() { broadcaster.compact(lastWrittenVersion); }

	void close() const { readFrom.close(); }

	Future<Void> onClosed() const { return readFrom.onClosed(); }

	Future<Void> getError() const { return readFrom.getError() || broadcaster.getError(); }
};

class TransactionEnvironment {
	WriteToTransactionEnvironment writeTo;

																#line 1465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via check()
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class CheckActor>
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckActorState {
															#line 1471 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckActorState(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,Optional<int64_t> const& expected) 
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   expected(expected),
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 344 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configKey(encodeConfigKey(configClass, knobName))
															#line 1488 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("check", reinterpret_cast<unsigned long>(this));

	}
	~CheckActorState() 
	{
		fdb_probe_actor_destroy("check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(configKey);
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<CheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1505 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckActor*>(this)->actor_wait_state = 1;
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckActor, 0, Optional<Value> >*>(static_cast<CheckActor*>(this)));
															#line 1510 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 346 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (expected.present())
															#line 1533 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 347 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT_EQ(Tuple::unpack(value.get()).getInt(0), expected.get());
															#line 1537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
		else
		{
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(!value.present());
															#line 1543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 351 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<CheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckActorState(); static_cast<CheckActor*>(this)->destroy(); return 0; }
															#line 1547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<CheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& __value,int loopDepth) 
	{
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		value = __value;
															#line 1559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckActor*>(this)->actor_wait_state > 0) static_cast<CheckActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActor*>(this)->ActorCallback< CheckActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<int64_t> expected;
															#line 342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 344 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Key configKey;
															#line 345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<Value> value;
															#line 1648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via check()
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckActor final : public Actor<Void>, public ActorCallback< CheckActor, 0, Optional<Value> >, public FastAllocated<CheckActor>, public CheckActorState<CheckActor> {
															#line 1653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<CheckActor>::operator new;
	using FastAllocated<CheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16201241229938604288UL, 10284954249323343360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckActor, 0, Optional<Value> >;
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckActor(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,Optional<int64_t> const& expected) 
															#line 1670 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheckActorState<CheckActor>(self, configClass, knobName, expected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9223858490859549696UL, 13188886265273636608UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> check( TransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName, Optional<int64_t> const& expected ) {
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new CheckActor(self, configClass, knobName, expected));
															#line 1702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 1707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via getConfigClasses()
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class GetConfigClassesActor>
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetConfigClassesActorState {
															#line 1713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetConfigClassesActorState(TransactionEnvironment* const& self) 
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   begin(firstGreaterOrEqual(configClassKeys.begin)),
															#line 358 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   end(firstGreaterOrEqual(configClassKeys.end))
															#line 1726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	~GetConfigClassesActorState() 
	{
		fdb_probe_actor_destroy("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 359 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, 1000);
															#line 359 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 1;
															#line 359 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 0, RangeResult >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 1748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 361 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 362 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 1777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 365 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetConfigClassesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 1781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetConfigClassesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 361 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 362 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 1799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 365 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetConfigClassesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 1803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetConfigClassesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeySelector begin;
															#line 358 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeySelector end;
															#line 1894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via getConfigClasses()
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetConfigClassesActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetConfigClassesActor, 0, RangeResult >, public FastAllocated<GetConfigClassesActor>, public GetConfigClassesActorState<GetConfigClassesActor> {
															#line 1899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<GetConfigClassesActor>::operator new;
	using FastAllocated<GetConfigClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6732312184812326400UL, 14617477163947634688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConfigClassesActor, 0, RangeResult >;
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetConfigClassesActor(TransactionEnvironment* const& self) 
															#line 1916 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetConfigClassesActorState<GetConfigClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14805324959998266368UL, 16789838799325584384UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConfigClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConfigClassesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getConfigClasses( TransactionEnvironment* const& self ) {
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetConfigClassesActor(self));
															#line 1948 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 1953 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via getKnobNames()
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class GetKnobNamesActor>
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetKnobNamesActorState {
															#line 1959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetKnobNamesActorState(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass) 
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 370 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 372 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   keys(globalConfigKnobKeys)
															#line 1972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("getKnobNames", reinterpret_cast<unsigned long>(this));

	}
	~GetKnobNamesActorState() 
	{
		fdb_probe_actor_destroy("getKnobNames", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 373 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (configClass.present())
															#line 1987 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			{
															#line 374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
				keys = singleKeyRange(configClass.get().withPrefix(configKnobKeys.begin));
															#line 1991 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			}
															#line 376 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector begin = firstGreaterOrEqual(keys.begin);
															#line 377 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector end = firstGreaterOrEqual(keys.end);
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, 1000);
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<GetKnobNamesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKnobNamesActor*>(this)->actor_wait_state = 1;
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKnobNamesActor, 0, RangeResult >*>(static_cast<GetKnobNamesActor*>(this)));
															#line 2006 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 380 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 381 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 382 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 2035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetKnobNamesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetKnobNamesActorState(); static_cast<GetKnobNamesActor*>(this)->destroy(); return 0; }
															#line 2039 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetKnobNamesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 380 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 381 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 382 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 2057 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetKnobNamesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetKnobNamesActorState(); static_cast<GetKnobNamesActor*>(this)->destroy(); return 0; }
															#line 2061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetKnobNamesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKnobNamesActor*>(this)->actor_wait_state > 0) static_cast<GetKnobNamesActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobNamesActor*>(this)->ActorCallback< GetKnobNamesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 370 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 372 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRange keys;
															#line 2152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via getKnobNames()
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetKnobNamesActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetKnobNamesActor, 0, RangeResult >, public FastAllocated<GetKnobNamesActor>, public GetKnobNamesActorState<GetKnobNamesActor> {
															#line 2157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<GetKnobNamesActor>::operator new;
	using FastAllocated<GetKnobNamesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2393086449358221056UL, 7811491688879792384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKnobNamesActor, 0, RangeResult >;
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetKnobNamesActor(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass) 
															#line 2174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetKnobNamesActorState<GetKnobNamesActor>(self, configClass),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16492234349335322368UL, 15783780456143899392UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKnobNames");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKnobNamesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getKnobNames( TransactionEnvironment* const& self, Optional<KeyRef> const& configClass ) {
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetKnobNamesActor(self, configClass));
															#line 2206 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 386 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 2211 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via badRangeRead()
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class BadRangeReadActor>
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class BadRangeReadActorState {
															#line 2217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BadRangeReadActorState(TransactionEnvironment* const& self) 
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 388 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface()))
															#line 2226 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("badRangeRead", reinterpret_cast<unsigned long>(this));

	}
	~BadRangeReadActorState() 
	{
		fdb_probe_actor_destroy("badRangeRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 390 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector begin = firstGreaterOrEqual(normalKeys.begin);
															#line 391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector end = firstGreaterOrEqual(normalKeys.end);
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->getRange(begin, end, 1000));
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<BadRangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2247 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BadRangeReadActor*>(this)->actor_wait_state = 1;
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BadRangeReadActor, 0, Void >*>(static_cast<BadRangeReadActor*>(this)));
															#line 2252 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<BadRangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BadRangeReadActorState(); static_cast<BadRangeReadActor*>(this)->destroy(); return 0; }
															#line 2275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<BadRangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<BadRangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BadRangeReadActorState(); static_cast<BadRangeReadActor*>(this)->destroy(); return 0; }
															#line 2287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<BadRangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BadRangeReadActor*>(this)->actor_wait_state > 0) static_cast<BadRangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<BadRangeReadActor*>(this)->ActorCallback< BadRangeReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BadRangeReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BadRangeReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BadRangeReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 388 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 2374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via badRangeRead()
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class BadRangeReadActor final : public Actor<Void>, public ActorCallback< BadRangeReadActor, 0, Void >, public FastAllocated<BadRangeReadActor>, public BadRangeReadActorState<BadRangeReadActor> {
															#line 2379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<BadRangeReadActor>::operator new;
	using FastAllocated<BadRangeReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3185083781190912256UL, 3972069443479845888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BadRangeReadActor, 0, Void >;
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BadRangeReadActor(TransactionEnvironment* const& self) 
															#line 2396 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   BadRangeReadActorState<BadRangeReadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12901388174225587456UL, 11541444727201612032UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("badRangeRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BadRangeReadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> badRangeRead( TransactionEnvironment* const& self ) {
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new BadRangeReadActor(self));
															#line 2428 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	TransactionEnvironment(std::string const& dataDir) : writeTo(dataDir) {}

	Future<Void> setup() { return Void(); }

	void restartNode() { writeTo.restartNode(); }
	template <class T>
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, T value) {
		return writeTo.set(configClass, knobName, value);
	}
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return writeTo.clear(configClass, knobName); }
	Future<Void> check(Optional<KeyRef> configClass, KeyRef knobName, Optional<int64_t> expected) {
		return check(this, configClass, knobName, expected);
	}
	Future<Void> badRangeRead() { return badRangeRead(this); }

	Future<Standalone<VectorRef<KeyRef>>> getConfigClasses() { return getConfigClasses(this); }
	Future<Standalone<VectorRef<KeyRef>>> getKnobNames(Optional<KeyRef> configClass) {
		return getKnobNames(this, configClass);
	}

	Future<Void> compact() { return writeTo.compact(); }
	Future<Void> rollforward(Optional<Version> rollback,
	                         Version lastKnownCommitted,
	                         Version target,
	                         Standalone<VectorRef<VersionedConfigMutationRef>> mutations,
	                         Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations) {
		return writeTo.rollforward(rollback, lastKnownCommitted, target, mutations, annotations);
	}
	Future<Void> getError() const { return writeTo.getError(); }
};

class TransactionToLocalConfigEnvironment {
	WriteToTransactionEnvironment writeTo;
	ReadFromLocalConfigEnvironment readFrom;
	Reference<AsyncVar<ConfigBroadcastInterface>> cbi;
	ConfigBroadcaster broadcaster;
	Future<Void> broadcastServer;
	Promise<Void> workerFailure;
	Future<Void> workerFailed_;

																#line 2474 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor2>
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor2State {
															#line 2480 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor2State(TransactionToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClassSet(configClassSet)
															#line 2489 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor2State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->readFrom.setup();
															#line 438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2506 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor2*>(this)->actor_wait_state = 1;
															#line 438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor2, 0, Void >*>(static_cast<SetupActor2*>(this)));
															#line 2511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 2540 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 2558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor2*>(this)->actor_wait_state > 0) static_cast<SetupActor2*>(this)->actor_wait_state = 0;
		static_cast<SetupActor2*>(this)->ActorCallback< SetupActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionToLocalConfigEnvironment* self;
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ConfigClassSet configClassSet;
															#line 2645 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor2 final : public Actor<Void>, public ActorCallback< SetupActor2, 0, Void >, public FastAllocated<SetupActor2>, public SetupActor2State<SetupActor2> {
															#line 2650 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor2>::operator new;
	using FastAllocated<SetupActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11989382910569922048UL, 907147050005876736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor2, 0, Void >;
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor2(TransactionToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 2667 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor2State<SetupActor2>(self, configClassSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(605885446803886848UL, 8965722389878324480UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor2, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( TransactionToLocalConfigEnvironment* const& self, ConfigClassSet const& configClassSet ) {
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor2(self, configClassSet));
															#line 2699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	TransactionToLocalConfigEnvironment(std::string const& dataDir, std::string const& configPath)
	  : writeTo(dataDir), readFrom(dataDir, configPath, {}), cbi(makeReference<AsyncVar<ConfigBroadcastInterface>>()),
	    broadcaster(writeTo.getFollowerInterface()) {}

	Future<Void> setup(ConfigClassSet const& configClassSet) { return setup(this, configClassSet); }

	void restartNode() { writeTo.restartNode(); }

	JsonBuilderObject getStatus() const { return broadcaster.getStatus(); }

	void changeBroadcaster() {
		broadcastServer.cancel();
		cbi->set(ConfigBroadcastInterface{});
		readFrom.connectToBroadcaster(cbi);
		broadcastServer = broadcaster.registerNode(
		    cbi->get(), readFrom.lastSeenVersion(), readFrom.configClassSet(), workerFailure.getFuture(), true);
	}

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}

	void killLocalConfig() {
		workerFailed_ = broadcaster.getClientFailure(cbi->get().id());
		workerFailure.send(Void());
	}

	Future<Void> workerFailed() {
		ASSERT(workerFailed_.isValid());
		return workerFailed_;
	}

	Future<Void> compact() { return writeTo.compact(); }

	template <class T>
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, T const& value) {
		return writeTo.set(configClass, knobName, value);
	}
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return writeTo.clear(configClass, knobName); }
	template <class T, class V, class E>
	Future<Void> check(V T::* member, Optional<E> value) const {
		return readFrom.checkEventually(member, value);
	}
	void close() const {
		writeTo.close();
		readFrom.close();
	}
	Future<Void> onClosed() const { return writeTo.onClosed() && readFrom.onClosed(); }
	Future<Void> getError() const { return writeTo.getError() || readFrom.getError() || broadcaster.getError(); }
};

// These functions give a common interface to all environments, to improve code reuse
template <class Env, class... Args>
Future<Void> set(Env& env, Args&&... args) {
	return waitOrError(env.set(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> set(BroadcasterToLocalConfigEnvironment& env, Args&&... args) {
	env.set(std::forward<Args>(args)...);
	return Void();
}
template <class Env, class... Args>
Future<Void> clear(Env& env, Args&&... args) {
	return waitOrError(env.clear(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> clear(BroadcasterToLocalConfigEnvironment& env, Args&&... args) {
	env.clear(std::forward<Args>(args)...);
	return Void();
}
template <class Env, class... Args>
Future<Void> check(Env& env, Args&&... args) {
	return waitOrError(env.check(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> check(LocalConfigEnvironment& env, Args&&... args) {
	env.check(std::forward<Args>(args)...);
	return Void();
}
template <class Env>
Future<Void> compact(Env& env) {
	return waitOrError(env.compact(), env.getError());
}
Future<Void> compact(BroadcasterToLocalConfigEnvironment& env) {
	env.compact();
	return Void();
}
template <class Env, class... Args>
Future<Void> rollforward(Env& env, Args&&... args) {
	return waitOrError(env.rollforward(std::forward<Args>(args)...), env.getError());
}

															#line 2797 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testRestartLocalConfig()
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestRestartLocalConfigActor>
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigActorState {
															#line 2803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigActorState(UnitTestParameters const& params) 
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 2812 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testRestartLocalConfig", reinterpret_cast<unsigned long>(this));

	}
	~TestRestartLocalConfigActorState() 
	{
		fdb_probe_actor_destroy("testRestartLocalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 1;
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 0, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2859 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 2;
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 1, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2864 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 2;
															#line 543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 1, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2966 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 3;
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 2, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2971 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2982 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 3;
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 2, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2987 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-A");
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3073 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 4;
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 3, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3078 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-A");
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3089 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 4;
															#line 545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 3, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3094 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 5;
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 4, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3185 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 5;
															#line 546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 4, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 6;
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 5, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 6;
															#line 547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 5, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3394 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 7;
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 6, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3399 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3410 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 7;
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 6, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigActorState(); static_cast<TestRestartLocalConfigActor*>(this)->destroy(); return 0; }
															#line 3499 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigActorState(); static_cast<TestRestartLocalConfigActor*>(this)->destroy(); return 0; }
															#line 3511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 3598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testRestartLocalConfig()
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigActor final : public Actor<Void>, public ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >, public FastAllocated<TestRestartLocalConfigActor<Env>>, public TestRestartLocalConfigActorState<Env, TestRestartLocalConfigActor<Env>> {
															#line 3605 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestRestartLocalConfigActor<Env>>::operator new;
	using FastAllocated<TestRestartLocalConfigActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14706331632442214656UL, 7055091324855561728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >;
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigActor(UnitTestParameters const& params) 
															#line 3628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestRestartLocalConfigActorState<Env, TestRestartLocalConfigActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9306454998092319488UL, 2954517028675423488UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRestartLocalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testRestartLocalConfig( UnitTestParameters const& params ) {
															#line 539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestRestartLocalConfigActor<Env>(params));
															#line 3668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 3673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testRestartLocalConfigAndChangeClass()
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestRestartLocalConfigAndChangeClassActor>
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigAndChangeClassActorState {
															#line 3679 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigAndChangeClassActorState(UnitTestParameters const& params) 
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 554 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 3688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this));

	}
	~TestRestartLocalConfigAndChangeClassActorState() 
	{
		fdb_probe_actor_destroy("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3705 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 1;
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3710 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 2;
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3740 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 2;
															#line 556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 3;
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 3;
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3863 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-B");
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 4;
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3954 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-B");
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3965 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 4;
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3970 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 0 });
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 0 });
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4072 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 2 });
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 6;
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 2 });
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 6;
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 7;
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4286 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 7;
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4291 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigAndChangeClassActorState(); static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->destroy(); return 0; }
															#line 4375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigAndChangeClassActorState(); static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->destroy(); return 0; }
															#line 4387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 554 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 4474 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testRestartLocalConfigAndChangeClass()
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigAndChangeClassActor final : public Actor<Void>, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >, public FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>, public TestRestartLocalConfigAndChangeClassActorState<Env, TestRestartLocalConfigAndChangeClassActor<Env>> {
															#line 4481 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>::operator new;
	using FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12331030897325370624UL, 10955366023253008640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >;
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigAndChangeClassActor(UnitTestParameters const& params) 
															#line 4504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestRestartLocalConfigAndChangeClassActorState<Env, TestRestartLocalConfigAndChangeClassActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6942187281364030976UL, 9357118023387732480UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRestartLocalConfigAndChangeClass");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testRestartLocalConfigAndChangeClass( UnitTestParameters const& params ) {
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestRestartLocalConfigAndChangeClassActor<Env>(params));
															#line 4544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 4549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testNewLocalConfigAfterCompaction()
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestNewLocalConfigAfterCompactionActor>
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestNewLocalConfigAfterCompactionActorState {
															#line 4555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestNewLocalConfigAfterCompactionActorState(UnitTestParameters const& params) 
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 4564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this));

	}
	~TestNewLocalConfigAfterCompactionActorState() 
	{
		fdb_probe_actor_destroy("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 568 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 568 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 1;
															#line 568 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4586 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 2;
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4616 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 2;
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4632 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 3;
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 3;
															#line 570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = compact(env);
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 4;
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4830 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = compact(env);
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 4;
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4846 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 574 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::eraseDirectoryRecursive(params.getDataDir());
															#line 575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::createDirectory(params.getDataDir());
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = env.restartLocalConfig("class-A");
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4936 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 5;
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 574 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::eraseDirectoryRecursive(params.getDataDir());
															#line 575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::createDirectory(params.getDataDir());
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = env.restartLocalConfig("class-A");
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4956 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 5;
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4961 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5049 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 6;
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5067 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 6;
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5072 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 7;
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 7;
															#line 580 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_7 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5265 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 8;
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_7 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 8;
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5286 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV<std::string>::futures) { (void)(env.getStatus().getJson()); this->~TestNewLocalConfigAfterCompactionActorState(); static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->destroy(); return 0; }
															#line 5370 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV< std::string >::value()) std::string(env.getStatus().getJson());
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV<std::string>::futures) { (void)(env.getStatus().getJson()); this->~TestNewLocalConfigAfterCompactionActorState(); static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->destroy(); return 0; }
															#line 5382 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV< std::string >::value()) std::string(env.getStatus().getJson());
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 5469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testNewLocalConfigAfterCompaction()
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestNewLocalConfigAfterCompactionActor final : public Actor<std::string>, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >, public FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>, public TestNewLocalConfigAfterCompactionActorState<Env, TestNewLocalConfigAfterCompactionActor<Env>> {
															#line 5476 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>::operator new;
	using FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17578616371977460224UL, 7103323760443616512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >;
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestNewLocalConfigAfterCompactionActor(UnitTestParameters const& params) 
															#line 5500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<std::string>(),
		   TestNewLocalConfigAfterCompactionActorState<Env, TestNewLocalConfigAfterCompactionActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6650899712828477952UL, 9683732796116094976UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testNewLocalConfigAfterCompaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<std::string> testNewLocalConfigAfterCompaction( UnitTestParameters const& params ) {
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<std::string>(new TestNewLocalConfigAfterCompactionActor<Env>(params));
															#line 5541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 584 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 5546 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testKillWorker()
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestKillWorkerActor>
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestKillWorkerActorState {
															#line 5552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestKillWorkerActorState(UnitTestParameters const& params) 
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 5561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testKillWorker", reinterpret_cast<unsigned long>(this));

	}
	~TestKillWorkerActorState() 
	{
		fdb_probe_actor_destroy("testKillWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 1;
															#line 588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 0, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5583 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 589 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.killLocalConfig();
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(env.workerFailed(), 3);
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 1, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 589 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.killLocalConfig();
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(env.workerFailed(), 3);
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 1, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5633 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Future<Void> closed = env.onClosed();
															#line 593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.close();
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = closed;
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 2, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Future<Void> closed = env.onClosed();
															#line 593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.close();
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = closed;
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 2, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 595 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKillWorkerActorState(); static_cast<TestKillWorkerActor*>(this)->destroy(); return 0; }
															#line 5832 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 595 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKillWorkerActorState(); static_cast<TestKillWorkerActor*>(this)->destroy(); return 0; }
															#line 5844 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 5931 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testKillWorker()
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestKillWorkerActor final : public Actor<Void>, public ActorCallback< TestKillWorkerActor<Env>, 0, Void >, public ActorCallback< TestKillWorkerActor<Env>, 1, Void >, public ActorCallback< TestKillWorkerActor<Env>, 2, Void >, public FastAllocated<TestKillWorkerActor<Env>>, public TestKillWorkerActorState<Env, TestKillWorkerActor<Env>> {
															#line 5938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestKillWorkerActor<Env>>::operator new;
	using FastAllocated<TestKillWorkerActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2999515274920680704UL, 817388776555508992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKillWorkerActor<Env>, 0, Void >;
friend struct ActorCallback< TestKillWorkerActor<Env>, 1, Void >;
friend struct ActorCallback< TestKillWorkerActor<Env>, 2, Void >;
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestKillWorkerActor(UnitTestParameters const& params) 
															#line 5957 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestKillWorkerActorState<Env, TestKillWorkerActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1488883752621364480UL, 6135929532874476032UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKillWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testKillWorker( UnitTestParameters const& params ) {
															#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestKillWorkerActor<Env>(params));
															#line 5993 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 597 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 5998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testSet()
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestSetActor>
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestSetActorState {
															#line 6004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestSetActorState(UnitTestParameters const& params) 
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 600 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 6013 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testSet", reinterpret_cast<unsigned long>(this));

	}
	~TestSetActorState() 
	{
		fdb_probe_actor_destroy("testSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestSetActor*>(this)->actor_wait_state = 1;
															#line 601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 0, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6060 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 2;
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 1, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6065 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 2;
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 1, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6081 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 3;
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 2, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6172 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 3;
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 2, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6188 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSetActorState(); static_cast<TestSetActor*>(this)->destroy(); return 0; }
															#line 6272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSetActorState(); static_cast<TestSetActor*>(this)->destroy(); return 0; }
															#line 6284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 600 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 6371 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testSet()
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestSetActor final : public Actor<Void>, public ActorCallback< TestSetActor<Env>, 0, Void >, public ActorCallback< TestSetActor<Env>, 1, Void >, public ActorCallback< TestSetActor<Env>, 2, Void >, public FastAllocated<TestSetActor<Env>>, public TestSetActorState<Env, TestSetActor<Env>> {
															#line 6378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestSetActor<Env>>::operator new;
	using FastAllocated<TestSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6884593571680745728UL, 2393651520397402880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestSetActor<Env>, 2, Void >;
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestSetActor(UnitTestParameters const& params) 
															#line 6397 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestSetActorState<Env, TestSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3030299605040313600UL, 16573408122665413376UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testSet( UnitTestParameters const& params ) {
															#line 598 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestSetActor<Env>(params));
															#line 6433 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 606 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 6438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testAtomicSet()
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestAtomicSetActor>
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicSetActorState {
															#line 6444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicSetActorState(UnitTestParameters const& params) 
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 6453 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testAtomicSet", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicSetActorState() 
	{
		fdb_probe_actor_destroy("testAtomicSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6470 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 1;
															#line 610 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 0, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 6498 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 2;
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 1, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6509 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 6524 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 2;
															#line 613 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 1, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6535 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = env.restartLocalConfig("class-A");
															#line 619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 3;
															#line 619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 2, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 616 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 6646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{ 1 });
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 4;
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 3, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{ 1 });
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6779 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 4;
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 3, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicSetActorState(); static_cast<TestAtomicSetActor*>(this)->destroy(); return 0; }
															#line 6868 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicSetActorState(); static_cast<TestAtomicSetActor*>(this)->destroy(); return 0; }
															#line 6880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 611 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool restarted;
															#line 6969 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testAtomicSet()
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicSetActor final : public Actor<Void>, public ActorCallback< TestAtomicSetActor<Env>, 0, Void >, public ActorCallback< TestAtomicSetActor<Env>, 1, Void >, public ActorCallback< TestAtomicSetActor<Env>, 2, Void >, public ActorCallback< TestAtomicSetActor<Env>, 3, Void >, public FastAllocated<TestAtomicSetActor<Env>>, public TestAtomicSetActorState<Env, TestAtomicSetActor<Env>> {
															#line 6976 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestAtomicSetActor<Env>>::operator new;
	using FastAllocated<TestAtomicSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(846712792016302592UL, 4128013216216187648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 2, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 3, Void >;
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicSetActor(UnitTestParameters const& params) 
															#line 6996 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestAtomicSetActorState<Env, TestAtomicSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14410322354549321984UL, 15508186000614925568UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testAtomicSet( UnitTestParameters const& params ) {
															#line 607 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestAtomicSetActor<Env>(params));
															#line 7033 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 7038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testClear()
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestClearActor>
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestClearActorState {
															#line 7044 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestClearActorState(UnitTestParameters const& params) 
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 7053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testClear", reinterpret_cast<unsigned long>(this));

	}
	~TestClearActorState() 
	{
		fdb_probe_actor_destroy("testClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7070 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestClearActor*>(this)->actor_wait_state = 1;
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 0, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7100 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 2;
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 1, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 2;
															#line 628 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 1, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7121 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 3;
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 2, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 3;
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 2, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7228 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{});
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 4;
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 3, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{});
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 4;
															#line 630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 3, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7335 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClearActorState(); static_cast<TestClearActor*>(this)->destroy(); return 0; }
															#line 7419 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClearActorState(); static_cast<TestClearActor*>(this)->destroy(); return 0; }
															#line 7431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestClearActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 7518 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testClear()
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestClearActor final : public Actor<Void>, public ActorCallback< TestClearActor<Env>, 0, Void >, public ActorCallback< TestClearActor<Env>, 1, Void >, public ActorCallback< TestClearActor<Env>, 2, Void >, public ActorCallback< TestClearActor<Env>, 3, Void >, public FastAllocated<TestClearActor<Env>>, public TestClearActorState<Env, TestClearActor<Env>> {
															#line 7525 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestClearActor<Env>>::operator new;
	using FastAllocated<TestClearActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16677527682300881664UL, 6786939166760992512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestClearActor<Env>, 0, Void >;
friend struct ActorCallback< TestClearActor<Env>, 1, Void >;
friend struct ActorCallback< TestClearActor<Env>, 2, Void >;
friend struct ActorCallback< TestClearActor<Env>, 3, Void >;
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestClearActor(UnitTestParameters const& params) 
															#line 7545 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestClearActorState<Env, TestClearActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17917248854791249408UL, 4427933218532448512UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestClearActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestClearActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestClearActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestClearActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testClear( UnitTestParameters const& params ) {
															#line 624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestClearActor<Env>(params));
															#line 7582 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 633 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 7587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testAtomicClear()
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestAtomicClearActor>
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicClearActorState {
															#line 7593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicClearActorState(UnitTestParameters const& params) 
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 636 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 7602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testAtomicClear", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicClearActorState() 
	{
		fdb_probe_actor_destroy("testAtomicClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 1;
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 0, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7624 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 2;
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 1, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7679 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 2;
															#line 640 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 1, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 645 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_atomic_long"_sr);
															#line 648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 7782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 3;
															#line 648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 2, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 642 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 643 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 7805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 653 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{});
															#line 654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7924 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 4;
															#line 654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 3, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 650 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 651 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 7941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 655 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicClearActorState(); static_cast<TestAtomicClearActor*>(this)->destroy(); return 0; }
															#line 8056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 655 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicClearActorState(); static_cast<TestAtomicClearActor*>(this)->destroy(); return 0; }
															#line 8068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 636 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 638 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool restarted;
															#line 8157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testAtomicClear()
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicClearActor final : public Actor<Void>, public ActorCallback< TestAtomicClearActor<Env>, 0, Void >, public ActorCallback< TestAtomicClearActor<Env>, 1, Void >, public ActorCallback< TestAtomicClearActor<Env>, 2, Void >, public ActorCallback< TestAtomicClearActor<Env>, 3, Void >, public FastAllocated<TestAtomicClearActor<Env>>, public TestAtomicClearActorState<Env, TestAtomicClearActor<Env>> {
															#line 8164 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestAtomicClearActor<Env>>::operator new;
	using FastAllocated<TestAtomicClearActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7147163794956512256UL, 13706772105765719296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicClearActor<Env>, 0, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 1, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 2, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 3, Void >;
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicClearActor(UnitTestParameters const& params) 
															#line 8184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestAtomicClearActorState<Env, TestAtomicClearActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9360441192302812160UL, 17781041177295283712UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testAtomicClear( UnitTestParameters const& params ) {
															#line 634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestAtomicClearActor<Env>(params));
															#line 8221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 657 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 8226 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGlobalSet()
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestGlobalSetActor>
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGlobalSetActorState {
															#line 8232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGlobalSetActorState(UnitTestParameters const& params) 
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 8241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGlobalSet", reinterpret_cast<unsigned long>(this));

	}
	~TestGlobalSetActorState() 
	{
		fdb_probe_actor_destroy("testGlobalSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 661 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 661 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8258 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 1;
															#line 661 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 0, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, Optional<KeyRef>{}, "test_long"_sr, int64_t{ 1 });
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 1, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8293 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, Optional<KeyRef>{}, "test_long"_sr, int64_t{ 1 });
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 1, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 3;
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 2, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8400 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 3;
															#line 663 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 2, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8416 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 10 });
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8502 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 4;
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 3, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8507 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 10 });
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8518 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 4;
															#line 664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 3, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8523 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 5;
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 4, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8614 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8625 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 5;
															#line 665 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 4, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8630 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 666 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGlobalSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGlobalSetActorState(); static_cast<TestGlobalSetActor*>(this)->destroy(); return 0; }
															#line 8714 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGlobalSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 666 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGlobalSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGlobalSetActorState(); static_cast<TestGlobalSetActor*>(this)->destroy(); return 0; }
															#line 8726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGlobalSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 8813 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGlobalSet()
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGlobalSetActor final : public Actor<Void>, public ActorCallback< TestGlobalSetActor<Env>, 0, Void >, public ActorCallback< TestGlobalSetActor<Env>, 1, Void >, public ActorCallback< TestGlobalSetActor<Env>, 2, Void >, public ActorCallback< TestGlobalSetActor<Env>, 3, Void >, public ActorCallback< TestGlobalSetActor<Env>, 4, Void >, public FastAllocated<TestGlobalSetActor<Env>>, public TestGlobalSetActorState<Env, TestGlobalSetActor<Env>> {
															#line 8820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGlobalSetActor<Env>>::operator new;
	using FastAllocated<TestGlobalSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5500253965811216640UL, 16955191472547543040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGlobalSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 2, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 3, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 4, Void >;
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGlobalSetActor(UnitTestParameters const& params) 
															#line 8841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGlobalSetActorState<Env, TestGlobalSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9792832150164213248UL, 17045993986056810240UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGlobalSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGlobalSet( UnitTestParameters const& params ) {
															#line 658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGlobalSetActor<Env>(params));
															#line 8879 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 668 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 8884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testIgnore()
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestIgnoreActor>
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestIgnoreActorState {
															#line 8890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestIgnoreActorState(UnitTestParameters const& params) 
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 8899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testIgnore", reinterpret_cast<unsigned long>(this));

	}
	~TestIgnoreActorState() 
	{
		fdb_probe_actor_destroy("testIgnore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8916 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestIgnoreActor*>(this)->actor_wait_state = 1;
															#line 672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 0, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestIgnoreActorState();
		static_cast<TestIgnoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 2;
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 1, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8962 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 2;
															#line 673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 1, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8967 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5);
															#line 674 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 676 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 9057 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 3;
															#line 675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 2, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 676 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 3, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 9064 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5);
															#line 674 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 676 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 9079 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 3;
															#line 675 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 2, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 676 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 3, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 9086 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 680 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestIgnoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestIgnoreActorState(); static_cast<TestIgnoreActor*>(this)->destroy(); return 0; }
															#line 9170 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestIgnoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestIgnoreActorState();
		static_cast<TestIgnoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
															#line 677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(false);
															#line 9194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
															#line 677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(false);
															#line 9203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 2, Void >::remove();
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 9333 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testIgnore()
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestIgnoreActor final : public Actor<Void>, public ActorCallback< TestIgnoreActor<Env>, 0, Void >, public ActorCallback< TestIgnoreActor<Env>, 1, Void >, public ActorCallback< TestIgnoreActor<Env>, 2, Void >, public ActorCallback< TestIgnoreActor<Env>, 3, Void >, public FastAllocated<TestIgnoreActor<Env>>, public TestIgnoreActorState<Env, TestIgnoreActor<Env>> {
															#line 9340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestIgnoreActor<Env>>::operator new;
	using FastAllocated<TestIgnoreActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(252753437718276864UL, 13241655680023993600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestIgnoreActor<Env>, 0, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 1, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 2, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 3, Void >;
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestIgnoreActor(UnitTestParameters const& params) 
															#line 9360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestIgnoreActorState<Env, TestIgnoreActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11448046487994411520UL, 18228452843738158848UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testIgnore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testIgnore( UnitTestParameters const& params ) {
															#line 669 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestIgnoreActor<Env>(params));
															#line 9396 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 682 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 9401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testCompact()
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestCompactActor>
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestCompactActorState {
															#line 9407 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestCompactActorState(UnitTestParameters const& params) 
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 685 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 9416 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testCompact", reinterpret_cast<unsigned long>(this));

	}
	~TestCompactActorState() 
	{
		fdb_probe_actor_destroy("testCompact", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 686 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 686 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9433 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCompactActor*>(this)->actor_wait_state = 1;
															#line 686 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 0, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9463 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 2;
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 1, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9468 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 2;
															#line 687 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 1, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9484 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = compact(env);
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9570 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 3;
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 2, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = compact(env);
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9586 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 3;
															#line 688 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 2, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 4;
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 3, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9682 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9693 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 4;
															#line 689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 3, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 5;
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 4, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9789 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 5;
															#line 690 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 4, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 6;
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 5, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9907 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 6;
															#line 691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 5, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9912 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 692 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestCompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompactActorState(); static_cast<TestCompactActor*>(this)->destroy(); return 0; }
															#line 9996 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestCompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 692 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestCompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompactActorState(); static_cast<TestCompactActor*>(this)->destroy(); return 0; }
															#line 10008 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestCompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 685 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 10095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testCompact()
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestCompactActor final : public Actor<Void>, public ActorCallback< TestCompactActor<Env>, 0, Void >, public ActorCallback< TestCompactActor<Env>, 1, Void >, public ActorCallback< TestCompactActor<Env>, 2, Void >, public ActorCallback< TestCompactActor<Env>, 3, Void >, public ActorCallback< TestCompactActor<Env>, 4, Void >, public ActorCallback< TestCompactActor<Env>, 5, Void >, public FastAllocated<TestCompactActor<Env>>, public TestCompactActorState<Env, TestCompactActor<Env>> {
															#line 10102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestCompactActor<Env>>::operator new;
	using FastAllocated<TestCompactActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16811663083350659328UL, 10723973585617606656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCompactActor<Env>, 0, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 1, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 2, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 3, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 4, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 5, Void >;
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestCompactActor(UnitTestParameters const& params) 
															#line 10124 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestCompactActorState<Env, TestCompactActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13482025005204312064UL, 2440409313776067584UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCompact");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testCompact( UnitTestParameters const& params ) {
															#line 683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestCompactActor<Env>(params));
															#line 10163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 694 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 10168 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testChangeBroadcaster()
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestChangeBroadcasterActor>
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestChangeBroadcasterActorState {
															#line 10174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestChangeBroadcasterActorState(UnitTestParameters const& params) 
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 697 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 10183 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testChangeBroadcaster", reinterpret_cast<unsigned long>(this));

	}
	~TestChangeBroadcasterActorState() 
	{
		fdb_probe_actor_destroy("testChangeBroadcaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 1;
															#line 698 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 0, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10205 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10230 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 1, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10246 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 1, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 3;
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 2, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10342 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 3;
															#line 700 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 2, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10358 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10446 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 4;
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 3, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10451 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10464 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 4;
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 3, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 5;
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 4, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 5;
															#line 703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 4, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestChangeBroadcasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestChangeBroadcasterActorState(); static_cast<TestChangeBroadcasterActor*>(this)->destroy(); return 0; }
															#line 10660 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestChangeBroadcasterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestChangeBroadcasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestChangeBroadcasterActorState(); static_cast<TestChangeBroadcasterActor*>(this)->destroy(); return 0; }
															#line 10672 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestChangeBroadcasterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 697 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 10759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testChangeBroadcaster()
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestChangeBroadcasterActor final : public Actor<Void>, public ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >, public FastAllocated<TestChangeBroadcasterActor<Env>>, public TestChangeBroadcasterActorState<Env, TestChangeBroadcasterActor<Env>> {
															#line 10766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestChangeBroadcasterActor<Env>>::operator new;
	using FastAllocated<TestChangeBroadcasterActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8170929892072113408UL, 6330695689750484992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >;
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestChangeBroadcasterActor(UnitTestParameters const& params) 
															#line 10787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestChangeBroadcasterActorState<Env, TestChangeBroadcasterActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8948996388665113344UL, 6882640595381780480UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testChangeBroadcaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testChangeBroadcaster( UnitTestParameters const& params ) {
															#line 695 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestChangeBroadcasterActor<Env>(params));
															#line 10825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 706 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

bool matches(Standalone<VectorRef<KeyRef>> const& vec, std::set<Key> const& compareTo) {
	std::set<Key> s;
	for (const auto& value : vec) {
		s.insert(value);
	}
	return (s == compareTo);
}

															#line 10838 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGetConfigClasses()
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class TestGetConfigClassesActor>
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetConfigClassesActorState {
															#line 10844 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetConfigClassesActorState(UnitTestParameters const& params,bool const& doCompact) 
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   doCompact(doCompact),
															#line 716 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 10855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	~TestGetConfigClassesActorState() 
	{
		fdb_probe_actor_destroy("testGetConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 717 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 717 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10872 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 1;
															#line 717 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 0, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 2;
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 1, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10907 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 2;
															#line 718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 1, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11007 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = compact(env);
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11013 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 3;
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 2, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11018 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11032 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = compact(env);
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 3;
															#line 720 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 2, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11043 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 722 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_3 = env.getConfigClasses();
															#line 722 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11134 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 4;
															#line 722 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<VectorRef<KeyRef>> const& configClasses,int loopDepth) 
	{
															#line 723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(configClasses, { "class-A"_sr, "class-B"_sr }));
															#line 724 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetConfigClassesActorState(); static_cast<TestGetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 11237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<VectorRef<KeyRef>> && configClasses,int loopDepth) 
	{
															#line 723 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(configClasses, { "class-A"_sr, "class-B"_sr }));
															#line 724 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetConfigClassesActorState(); static_cast<TestGetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 11251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<VectorRef<KeyRef>> const& configClasses,int loopDepth) 
	{
		loopDepth = a_body1cont5(configClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<VectorRef<KeyRef>> && configClasses,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(configClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool doCompact;
															#line 716 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 11340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGetConfigClasses()
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetConfigClassesActor final : public Actor<Void>, public ActorCallback< TestGetConfigClassesActor, 0, Void >, public ActorCallback< TestGetConfigClassesActor, 1, Void >, public ActorCallback< TestGetConfigClassesActor, 2, Void >, public ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >, public FastAllocated<TestGetConfigClassesActor>, public TestGetConfigClassesActorState<TestGetConfigClassesActor> {
															#line 11345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGetConfigClassesActor>::operator new;
	using FastAllocated<TestGetConfigClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3805260934493293824UL, 6505671103782295040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetConfigClassesActor, 0, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 1, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 2, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >;
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetConfigClassesActor(UnitTestParameters const& params,bool const& doCompact) 
															#line 11365 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetConfigClassesActorState<TestGetConfigClassesActor>(params, doCompact),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5533591670701122304UL, 5927137263488159744UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetConfigClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGetConfigClasses( UnitTestParameters const& params, bool const& doCompact ) {
															#line 715 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGetConfigClassesActor(params, doCompact));
															#line 11400 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 11405 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGetKnobs()
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class TestGetKnobsActor>
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetKnobsActorState {
															#line 11411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetKnobsActorState(UnitTestParameters const& params,bool const& global,bool const& doCompact) 
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   global(global),
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   doCompact(doCompact),
															#line 728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir()),
															#line 729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass()
															#line 11426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetKnobs", reinterpret_cast<unsigned long>(this));

	}
	~TestGetKnobsActorState() 
	{
		fdb_probe_actor_destroy("testGetKnobs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (!global)
															#line 11441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			{
															#line 731 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
				configClass = "class-A"_sr;
															#line 11445 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			}
															#line 733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, configClass.castTo<KeyRef>(), "test_long"_sr, int64_t{ 1 });
															#line 733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11451 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 1;
															#line 733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 0, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, configClass.castTo<KeyRef>(), "test_int"_sr, int{ 2 });
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11481 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 2;
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 1, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11486 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, configClass.castTo<KeyRef>(), "test_int"_sr, int{ 2 });
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 2;
															#line 734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 1, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11502 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_double"_sr, double{ 3.0 });
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11588 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 3;
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 2, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11593 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_double"_sr, double{ 3.0 });
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11604 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 3;
															#line 735 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 2, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11609 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11693 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_3 = compact(env);
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 4;
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 3, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11718 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_3 = compact(env);
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11724 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 4;
															#line 737 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 3, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_4 = waitOrError(env.getKnobNames(configClass.castTo<KeyRef>()), env.getError());
															#line 739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 5;
															#line 739 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Standalone<VectorRef<KeyRef>> const& knobNames,int loopDepth) 
	{
															#line 741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(knobNames, { "test_long"_sr, "test_int"_sr }));
															#line 742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetKnobsActorState(); static_cast<TestGetKnobsActor*>(this)->destroy(); return 0; }
															#line 11923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Standalone<VectorRef<KeyRef>> && knobNames,int loopDepth) 
	{
															#line 741 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(knobNames, { "test_long"_sr, "test_int"_sr }));
															#line 742 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetKnobsActorState(); static_cast<TestGetKnobsActor*>(this)->destroy(); return 0; }
															#line 11937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<KeyRef>> const& knobNames,int loopDepth) 
	{
		loopDepth = a_body1cont7(knobNames, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<KeyRef>> && knobNames,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(knobNames), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool global;
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool doCompact;
															#line 728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 729 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<Key> configClass;
															#line 12030 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGetKnobs()
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetKnobsActor final : public Actor<Void>, public ActorCallback< TestGetKnobsActor, 0, Void >, public ActorCallback< TestGetKnobsActor, 1, Void >, public ActorCallback< TestGetKnobsActor, 2, Void >, public ActorCallback< TestGetKnobsActor, 3, Void >, public ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >, public FastAllocated<TestGetKnobsActor>, public TestGetKnobsActorState<TestGetKnobsActor> {
															#line 12035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGetKnobsActor>::operator new;
	using FastAllocated<TestGetKnobsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3543177832870127360UL, 5427952037280031488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetKnobsActor, 0, Void >;
friend struct ActorCallback< TestGetKnobsActor, 1, Void >;
friend struct ActorCallback< TestGetKnobsActor, 2, Void >;
friend struct ActorCallback< TestGetKnobsActor, 3, Void >;
friend struct ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >;
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetKnobsActor(UnitTestParameters const& params,bool const& global,bool const& doCompact) 
															#line 12056 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetKnobsActorState<TestGetKnobsActor>(params, global, doCompact),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13721691855438621440UL, 4832838314609633024UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetKnobs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetKnobsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetKnobsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetKnobsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetKnobsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGetKnobs( UnitTestParameters const& params, bool const& global, bool const& doCompact ) {
															#line 727 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGetKnobsActor(params, global, doCompact));
															#line 12092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

} // namespace

															#line 12099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase747()
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase747Actor>
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase747ActorState {
															#line 12106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase747ActorState(UnitTestParameters const& params) 
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase747", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase747ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase747", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<LocalConfigEnvironment>(params);
															#line 748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase747Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase747Actor*>(this)->actor_wait_state = 1;
															#line 748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase747Actor, 0, Void >*>(static_cast<FlowTestCase747Actor*>(this)));
															#line 12135 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 749 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase747Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase747ActorState(); static_cast<FlowTestCase747Actor*>(this)->destroy(); return 0; }
															#line 12158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase747Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 749 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase747Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase747ActorState(); static_cast<FlowTestCase747Actor*>(this)->destroy(); return 0; }
															#line 12170 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase747Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase747Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase747Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase747Actor*>(this)->ActorCallback< FlowTestCase747Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase747Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase747Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase747Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase747()
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase747Actor final : public Actor<Void>, public ActorCallback< FlowTestCase747Actor, 0, Void >, public FastAllocated<FlowTestCase747Actor>, public FlowTestCase747ActorState<FlowTestCase747Actor> {
															#line 12260 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase747Actor>::operator new;
	using FastAllocated<FlowTestCase747Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3297691714730418176UL, 12087500464853984256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase747Actor, 0, Void >;
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase747Actor(UnitTestParameters const& params) 
															#line 12277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase747ActorState<FlowTestCase747Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7398373504158579968UL, 9257727052614553856UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase747");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase747Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase747( UnitTestParameters const& params ) {
															#line 747 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase747Actor(params));
															#line 12310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase747, "/fdbserver/ConfigDB/LocalConfiguration/Set")

#line 751 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12316 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase752()
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase752Actor>
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase752ActorState {
															#line 12323 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase752ActorState(UnitTestParameters const& params) 
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase752", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase752ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase752", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testAtomicSet<LocalConfigEnvironment>(params);
															#line 753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase752Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12347 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase752Actor*>(this)->actor_wait_state = 1;
															#line 753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase752Actor, 0, Void >*>(static_cast<FlowTestCase752Actor*>(this)));
															#line 12352 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase752Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase752ActorState(); static_cast<FlowTestCase752Actor*>(this)->destroy(); return 0; }
															#line 12375 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase752Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase752Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase752ActorState(); static_cast<FlowTestCase752Actor*>(this)->destroy(); return 0; }
															#line 12387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase752Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase752Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase752Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase752Actor*>(this)->ActorCallback< FlowTestCase752Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase752Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase752Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase752Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12472 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase752()
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase752Actor final : public Actor<Void>, public ActorCallback< FlowTestCase752Actor, 0, Void >, public FastAllocated<FlowTestCase752Actor>, public FlowTestCase752ActorState<FlowTestCase752Actor> {
															#line 12477 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase752Actor>::operator new;
	using FastAllocated<FlowTestCase752Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10201299836780110336UL, 6581636674426865408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase752Actor, 0, Void >;
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase752Actor(UnitTestParameters const& params) 
															#line 12494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase752ActorState<FlowTestCase752Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11006927378514130944UL, 13026646463073603840UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase752");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase752Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase752( UnitTestParameters const& params ) {
															#line 752 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase752Actor(params));
															#line 12527 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase752, "/fdbserver/ConfigDB/LocalConfiguration/AtomicSet")

#line 756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12533 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase757()
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase757Actor>
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase757ActorState {
															#line 12540 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase757ActorState(UnitTestParameters const& params) 
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase757", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase757ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase757", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfig<LocalConfigEnvironment>(params);
															#line 758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase757Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase757Actor*>(this)->actor_wait_state = 1;
															#line 758 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase757Actor, 0, Void >*>(static_cast<FlowTestCase757Actor*>(this)));
															#line 12569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase757Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase757ActorState(); static_cast<FlowTestCase757Actor*>(this)->destroy(); return 0; }
															#line 12592 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase757Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase757Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase757ActorState(); static_cast<FlowTestCase757Actor*>(this)->destroy(); return 0; }
															#line 12604 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase757Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase757Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase757Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase757Actor*>(this)->ActorCallback< FlowTestCase757Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase757Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase757Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase757Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12689 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase757()
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase757Actor final : public Actor<Void>, public ActorCallback< FlowTestCase757Actor, 0, Void >, public FastAllocated<FlowTestCase757Actor>, public FlowTestCase757ActorState<FlowTestCase757Actor> {
															#line 12694 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase757Actor>::operator new;
	using FastAllocated<FlowTestCase757Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16971085188830994176UL, 6118664815973795328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase757Actor, 0, Void >;
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase757Actor(UnitTestParameters const& params) 
															#line 12711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase757ActorState<FlowTestCase757Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6831298534421225216UL, 11991827868289575680UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase757");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase757Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase757( UnitTestParameters const& params ) {
															#line 757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase757Actor(params));
															#line 12744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase757, "/fdbserver/ConfigDB/LocalConfiguration/Restart")

#line 761 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase762()
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase762Actor>
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase762ActorState {
															#line 12757 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase762ActorState(UnitTestParameters const& params) 
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12764 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase762", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase762ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase762", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<LocalConfigEnvironment>(params);
															#line 763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase762Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase762Actor*>(this)->actor_wait_state = 1;
															#line 763 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase762Actor, 0, Void >*>(static_cast<FlowTestCase762Actor*>(this)));
															#line 12786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 764 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase762Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase762ActorState(); static_cast<FlowTestCase762Actor*>(this)->destroy(); return 0; }
															#line 12809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase762Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 764 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase762Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase762ActorState(); static_cast<FlowTestCase762Actor*>(this)->destroy(); return 0; }
															#line 12821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase762Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase762Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase762Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase762Actor*>(this)->ActorCallback< FlowTestCase762Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase762Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase762Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase762Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12906 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase762()
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase762Actor final : public Actor<Void>, public ActorCallback< FlowTestCase762Actor, 0, Void >, public FastAllocated<FlowTestCase762Actor>, public FlowTestCase762ActorState<FlowTestCase762Actor> {
															#line 12911 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase762Actor>::operator new;
	using FastAllocated<FlowTestCase762Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8008519238178260224UL, 4585283514772189696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase762Actor, 0, Void >;
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase762Actor(UnitTestParameters const& params) 
															#line 12928 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase762ActorState<FlowTestCase762Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17018378336429648640UL, 3204161422519132672UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase762");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase762Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase762( UnitTestParameters const& params ) {
															#line 762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase762Actor(params));
															#line 12961 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase762, "/fdbserver/ConfigDB/LocalConfiguration/RestartFresh")

#line 766 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12967 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase767()
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase767Actor>
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase767ActorState {
															#line 12974 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase767ActorState(UnitTestParameters const& params) 
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12981 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase767ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<LocalConfigEnvironment>(params);
															#line 768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase767Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase767Actor*>(this)->actor_wait_state = 1;
															#line 768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase767Actor, 0, Void >*>(static_cast<FlowTestCase767Actor*>(this)));
															#line 13003 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase767Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase767ActorState(); static_cast<FlowTestCase767Actor*>(this)->destroy(); return 0; }
															#line 13026 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase767Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase767Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase767ActorState(); static_cast<FlowTestCase767Actor*>(this)->destroy(); return 0; }
															#line 13038 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase767Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase767Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase767Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase767Actor*>(this)->ActorCallback< FlowTestCase767Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase767Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase767Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase767Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13123 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase767()
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase767Actor final : public Actor<Void>, public ActorCallback< FlowTestCase767Actor, 0, Void >, public FastAllocated<FlowTestCase767Actor>, public FlowTestCase767ActorState<FlowTestCase767Actor> {
															#line 13128 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase767Actor>::operator new;
	using FastAllocated<FlowTestCase767Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9821868610210334208UL, 11101822307616514304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase767Actor, 0, Void >;
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase767Actor(UnitTestParameters const& params) 
															#line 13145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase767ActorState<FlowTestCase767Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18231450268876123904UL, 6519666288237989888UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase767");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase767Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase767( UnitTestParameters const& params ) {
															#line 767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase767Actor(params));
															#line 13178 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase767, "/fdbserver/ConfigDB/LocalConfiguration/Clear")

#line 771 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase772()
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase772Actor>
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase772ActorState {
															#line 13191 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase772ActorState(UnitTestParameters const& params) 
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 13198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase772", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase772ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase772", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testAtomicClear<LocalConfigEnvironment>(params);
															#line 773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase772Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13215 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase772Actor*>(this)->actor_wait_state = 1;
															#line 773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase772Actor, 0, Void >*>(static_cast<FlowTestCase772Actor*>(this)));
															#line 13220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase772Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase772ActorState(); static_cast<FlowTestCase772Actor*>(this)->destroy(); return 0; }
															#line 13243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase772Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase772Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase772ActorState(); static_cast<FlowTestCase772Actor*>(this)->destroy(); return 0; }
															#line 13255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase772Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase772Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase772Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase772Actor*>(this)->ActorCallback< FlowTestCase772Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase772Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase772Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase772Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase772()
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase772Actor final : public Actor<Void>, public ActorCallback< FlowTestCase772Actor, 0, Void >, public FastAllocated<FlowTestCase772Actor>, public FlowTestCase772ActorState<FlowTestCase772Actor> {
															#line 13345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase772Actor>::operator new;
	using FastAllocated<FlowTestCase772Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5746809642846397184UL, 1130998182697602048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase772Actor, 0, Void >;
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase772Actor(UnitTestParameters const& params) 
															#line 13362 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase772ActorState<FlowTestCase772Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16895822603116443648UL, 1449014843031460864UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase772");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase772Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase772( UnitTestParameters const& params ) {
															#line 772 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase772Actor(params));
															#line 13395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase772, "/fdbserver/ConfigDB/LocalConfiguration/AtomicClear")

#line 776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase777()
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase777Actor>
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase777ActorState {
															#line 13408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase777ActorState(UnitTestParameters const& params) 
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 13415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase777", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase777ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase777", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<LocalConfigEnvironment>(params);
															#line 778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase777Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13432 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase777Actor*>(this)->actor_wait_state = 1;
															#line 778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase777Actor, 0, Void >*>(static_cast<FlowTestCase777Actor*>(this)));
															#line 13437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 779 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase777Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase777ActorState(); static_cast<FlowTestCase777Actor*>(this)->destroy(); return 0; }
															#line 13460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase777Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 779 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase777Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase777ActorState(); static_cast<FlowTestCase777Actor*>(this)->destroy(); return 0; }
															#line 13472 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase777Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase777Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase777Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase777Actor*>(this)->ActorCallback< FlowTestCase777Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase777Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase777Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase777Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase777()
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase777Actor final : public Actor<Void>, public ActorCallback< FlowTestCase777Actor, 0, Void >, public FastAllocated<FlowTestCase777Actor>, public FlowTestCase777ActorState<FlowTestCase777Actor> {
															#line 13562 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase777Actor>::operator new;
	using FastAllocated<FlowTestCase777Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10471782368699564800UL, 7822559112470870272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase777Actor, 0, Void >;
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase777Actor(UnitTestParameters const& params) 
															#line 13579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase777ActorState<FlowTestCase777Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18242124149915043840UL, 12944090212235094528UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase777");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase777Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase777( UnitTestParameters const& params ) {
															#line 777 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase777Actor(params));
															#line 13612 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase777, "/fdbserver/ConfigDB/LocalConfiguration/GlobalSet")

#line 781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase782()
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase782Actor>
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase782ActorState {
															#line 13625 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase782ActorState(UnitTestParameters const& params) 
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A/class-B", {})
															#line 13634 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase782", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase782ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase782", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13651 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 1;
															#line 784 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 0, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13656 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13681 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 2;
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 1, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13686 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13697 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 2;
															#line 785 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 1, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 10 });
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 3;
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 2, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 10 });
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 3;
															#line 786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 2, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase782Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase782ActorState(); static_cast<FlowTestCase782Actor*>(this)->destroy(); return 0; }
															#line 13895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase782Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase782Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase782ActorState(); static_cast<FlowTestCase782Actor*>(this)->destroy(); return 0; }
															#line 13909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase782Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 783 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	LocalConfigEnvironment env;
															#line 13996 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase782()
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase782Actor final : public Actor<Void>, public ActorCallback< FlowTestCase782Actor, 0, Void >, public ActorCallback< FlowTestCase782Actor, 1, Void >, public ActorCallback< FlowTestCase782Actor, 2, Void >, public FastAllocated<FlowTestCase782Actor>, public FlowTestCase782ActorState<FlowTestCase782Actor> {
															#line 14001 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase782Actor>::operator new;
	using FastAllocated<FlowTestCase782Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4267327325784956928UL, 731605261896163840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase782Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase782Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase782Actor, 2, Void >;
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase782Actor(UnitTestParameters const& params) 
															#line 14020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase782ActorState<FlowTestCase782Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4906213447740594688UL, 1152581318116959744UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase782");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase782( UnitTestParameters const& params ) {
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase782Actor(params));
															#line 14055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase782, "/fdbserver/ConfigDB/LocalConfiguration/ConflictingOverrides")

#line 790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14061 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase791()
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase791Actor>
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase791ActorState {
															#line 14068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase791ActorState(UnitTestParameters const& params) 
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A", { { "test_long", "1000" } })
															#line 14077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase791", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase791ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase791", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14094 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 1;
															#line 793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 0, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14099 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14124 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 2;
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 1, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14129 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14140 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 2;
															#line 794 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 1, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase791Actor*>(this)->ActorCallback< FlowTestCase791Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase791Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 795 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 1000 });
															#line 796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase791Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase791ActorState(); static_cast<FlowTestCase791Actor*>(this)->destroy(); return 0; }
															#line 14231 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase791Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 795 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 1000 });
															#line 796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase791Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase791ActorState(); static_cast<FlowTestCase791Actor*>(this)->destroy(); return 0; }
															#line 14245 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase791Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase791Actor*>(this)->ActorCallback< FlowTestCase791Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase791Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 792 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	LocalConfigEnvironment env;
															#line 14332 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase791()
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase791Actor final : public Actor<Void>, public ActorCallback< FlowTestCase791Actor, 0, Void >, public ActorCallback< FlowTestCase791Actor, 1, Void >, public FastAllocated<FlowTestCase791Actor>, public FlowTestCase791ActorState<FlowTestCase791Actor> {
															#line 14337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase791Actor>::operator new;
	using FastAllocated<FlowTestCase791Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8541263643710522368UL, 3716420360480881664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase791Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase791Actor, 1, Void >;
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase791Actor(UnitTestParameters const& params) 
															#line 14355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase791ActorState<FlowTestCase791Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2371028010060527616UL, 10283755369829652480UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase791");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase791Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase791Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase791( UnitTestParameters const& params ) {
															#line 791 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase791Actor(params));
															#line 14389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase791, "/fdbserver/ConfigDB/LocalConfiguration/Manual")

#line 798 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase799()
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase799Actor>
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase799ActorState {
															#line 14402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase799ActorState(UnitTestParameters const& params) 
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14409 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase799", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase799ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase799", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<BroadcasterToLocalConfigEnvironment>(params);
															#line 800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase799Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase799Actor*>(this)->actor_wait_state = 1;
															#line 800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase799Actor, 0, Void >*>(static_cast<FlowTestCase799Actor*>(this)));
															#line 14431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 801 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase799Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase799ActorState(); static_cast<FlowTestCase799Actor*>(this)->destroy(); return 0; }
															#line 14454 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase799Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 801 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase799Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase799ActorState(); static_cast<FlowTestCase799Actor*>(this)->destroy(); return 0; }
															#line 14466 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase799Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase799Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase799Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase799Actor*>(this)->ActorCallback< FlowTestCase799Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase799Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase799Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase799Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase799()
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase799Actor final : public Actor<Void>, public ActorCallback< FlowTestCase799Actor, 0, Void >, public FastAllocated<FlowTestCase799Actor>, public FlowTestCase799ActorState<FlowTestCase799Actor> {
															#line 14556 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase799Actor>::operator new;
	using FastAllocated<FlowTestCase799Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15466510998626997504UL, 2380847493729462528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase799Actor, 0, Void >;
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase799Actor(UnitTestParameters const& params) 
															#line 14573 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase799ActorState<FlowTestCase799Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6884708122001271552UL, 1784450062992275968UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase799");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase799Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase799( UnitTestParameters const& params ) {
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase799Actor(params));
															#line 14606 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase799, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Set")

#line 803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14612 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase804()
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase804Actor>
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase804ActorState {
															#line 14619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase804ActorState(UnitTestParameters const& params) 
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14626 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase804", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase804ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase804", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<BroadcasterToLocalConfigEnvironment>(params);
															#line 805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase804Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14643 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase804Actor*>(this)->actor_wait_state = 1;
															#line 805 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase804Actor, 0, Void >*>(static_cast<FlowTestCase804Actor*>(this)));
															#line 14648 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 806 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase804Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase804ActorState(); static_cast<FlowTestCase804Actor*>(this)->destroy(); return 0; }
															#line 14671 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase804Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 806 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase804Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase804ActorState(); static_cast<FlowTestCase804Actor*>(this)->destroy(); return 0; }
															#line 14683 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase804Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase804Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase804Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase804Actor*>(this)->ActorCallback< FlowTestCase804Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase804Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase804Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase804Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase804()
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase804Actor final : public Actor<Void>, public ActorCallback< FlowTestCase804Actor, 0, Void >, public FastAllocated<FlowTestCase804Actor>, public FlowTestCase804ActorState<FlowTestCase804Actor> {
															#line 14773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase804Actor>::operator new;
	using FastAllocated<FlowTestCase804Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3557318783257884416UL, 11261724184962750720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase804Actor, 0, Void >;
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase804Actor(UnitTestParameters const& params) 
															#line 14790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase804ActorState<FlowTestCase804Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3862436700962537472UL, 18189525332794863872UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase804");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase804Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase804( UnitTestParameters const& params ) {
															#line 804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase804Actor(params));
															#line 14823 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase804, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Clear")

#line 808 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase809()
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase809Actor>
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase809ActorState {
															#line 14836 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase809ActorState(UnitTestParameters const& params) 
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase809", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase809ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase809", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testIgnore<BroadcasterToLocalConfigEnvironment>(params);
															#line 810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase809Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14860 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase809Actor*>(this)->actor_wait_state = 1;
															#line 810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase809Actor, 0, Void >*>(static_cast<FlowTestCase809Actor*>(this)));
															#line 14865 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase809Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase809ActorState(); static_cast<FlowTestCase809Actor*>(this)->destroy(); return 0; }
															#line 14888 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase809Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase809Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase809ActorState(); static_cast<FlowTestCase809Actor*>(this)->destroy(); return 0; }
															#line 14900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase809Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase809Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase809Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase809Actor*>(this)->ActorCallback< FlowTestCase809Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase809Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase809Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase809Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase809()
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase809Actor final : public Actor<Void>, public ActorCallback< FlowTestCase809Actor, 0, Void >, public FastAllocated<FlowTestCase809Actor>, public FlowTestCase809ActorState<FlowTestCase809Actor> {
															#line 14990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase809Actor>::operator new;
	using FastAllocated<FlowTestCase809Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16133827722398707456UL, 143728350495144192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase809Actor, 0, Void >;
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase809Actor(UnitTestParameters const& params) 
															#line 15007 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase809ActorState<FlowTestCase809Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13616089986071807744UL, 10214954890626679296UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase809");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase809Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase809( UnitTestParameters const& params ) {
															#line 809 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase809Actor(params));
															#line 15040 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase809, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Ignore")

#line 813 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15046 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase814()
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase814Actor>
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase814ActorState {
															#line 15053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase814ActorState(UnitTestParameters const& params) 
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15060 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase814ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<BroadcasterToLocalConfigEnvironment>(params);
															#line 815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase814Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15077 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase814Actor*>(this)->actor_wait_state = 1;
															#line 815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase814Actor, 0, Void >*>(static_cast<FlowTestCase814Actor*>(this)));
															#line 15082 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 816 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase814Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase814ActorState(); static_cast<FlowTestCase814Actor*>(this)->destroy(); return 0; }
															#line 15105 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase814Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 816 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase814Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase814ActorState(); static_cast<FlowTestCase814Actor*>(this)->destroy(); return 0; }
															#line 15117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase814Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase814Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase814Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase814Actor*>(this)->ActorCallback< FlowTestCase814Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase814Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase814Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase814Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15202 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase814()
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase814Actor final : public Actor<Void>, public ActorCallback< FlowTestCase814Actor, 0, Void >, public FastAllocated<FlowTestCase814Actor>, public FlowTestCase814ActorState<FlowTestCase814Actor> {
															#line 15207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase814Actor>::operator new;
	using FastAllocated<FlowTestCase814Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10634596773324239616UL, 15234527522279145472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase814Actor, 0, Void >;
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase814Actor(UnitTestParameters const& params) 
															#line 15224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase814ActorState<FlowTestCase814Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(521958722407560192UL, 9662297343416479488UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase814");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase814Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase814( UnitTestParameters const& params ) {
															#line 814 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase814Actor(params));
															#line 15257 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase814, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/GlobalSet")

#line 818 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase819()
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase819Actor>
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase819ActorState {
															#line 15270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase819ActorState(UnitTestParameters const& params) 
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase819", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase819ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase819", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testChangeBroadcaster<BroadcasterToLocalConfigEnvironment>(params);
															#line 820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase819Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15294 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase819Actor*>(this)->actor_wait_state = 1;
															#line 820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase819Actor, 0, Void >*>(static_cast<FlowTestCase819Actor*>(this)));
															#line 15299 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase819Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase819ActorState(); static_cast<FlowTestCase819Actor*>(this)->destroy(); return 0; }
															#line 15322 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase819Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase819Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase819ActorState(); static_cast<FlowTestCase819Actor*>(this)->destroy(); return 0; }
															#line 15334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase819Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase819Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase819Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase819Actor*>(this)->ActorCallback< FlowTestCase819Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase819Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase819Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase819Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15419 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase819()
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase819Actor final : public Actor<Void>, public ActorCallback< FlowTestCase819Actor, 0, Void >, public FastAllocated<FlowTestCase819Actor>, public FlowTestCase819ActorState<FlowTestCase819Actor> {
															#line 15424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase819Actor>::operator new;
	using FastAllocated<FlowTestCase819Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13875836294463964416UL, 13530137195455724032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase819Actor, 0, Void >;
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase819Actor(UnitTestParameters const& params) 
															#line 15441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase819ActorState<FlowTestCase819Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14117879735483337984UL, 2931431795118776832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase819");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase819Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase819( UnitTestParameters const& params ) {
															#line 819 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase819Actor(params));
															#line 15474 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase819, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/ChangeBroadcaster")

#line 823 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15480 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase824()
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase824Actor>
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase824ActorState {
															#line 15487 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase824ActorState(UnitTestParameters const& params) 
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase824", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase824ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase824", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfig<BroadcasterToLocalConfigEnvironment>(params);
															#line 825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase824Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase824Actor*>(this)->actor_wait_state = 1;
															#line 825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase824Actor, 0, Void >*>(static_cast<FlowTestCase824Actor*>(this)));
															#line 15516 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase824Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase824ActorState(); static_cast<FlowTestCase824Actor*>(this)->destroy(); return 0; }
															#line 15539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase824Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase824Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase824ActorState(); static_cast<FlowTestCase824Actor*>(this)->destroy(); return 0; }
															#line 15551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase824Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase824Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase824Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase824Actor*>(this)->ActorCallback< FlowTestCase824Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase824Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase824Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase824Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15636 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase824()
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase824Actor final : public Actor<Void>, public ActorCallback< FlowTestCase824Actor, 0, Void >, public FastAllocated<FlowTestCase824Actor>, public FlowTestCase824ActorState<FlowTestCase824Actor> {
															#line 15641 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase824Actor>::operator new;
	using FastAllocated<FlowTestCase824Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6949549458306249728UL, 14360850973667043072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase824Actor, 0, Void >;
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase824Actor(UnitTestParameters const& params) 
															#line 15658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase824ActorState<FlowTestCase824Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10781417912220723456UL, 1708651621433870848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase824");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase824Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase824( UnitTestParameters const& params ) {
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase824Actor(params));
															#line 15691 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase824, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfig")

#line 828 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15697 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase829()
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase829Actor>
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase829ActorState {
															#line 15704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase829ActorState(UnitTestParameters const& params) 
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15711 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase829ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 830 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<BroadcasterToLocalConfigEnvironment>(params);
															#line 830 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase829Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15728 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase829Actor*>(this)->actor_wait_state = 1;
															#line 830 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase829Actor, 0, Void >*>(static_cast<FlowTestCase829Actor*>(this)));
															#line 15733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase829Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase829ActorState(); static_cast<FlowTestCase829Actor*>(this)->destroy(); return 0; }
															#line 15756 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase829Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase829Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase829ActorState(); static_cast<FlowTestCase829Actor*>(this)->destroy(); return 0; }
															#line 15768 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase829Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase829Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase829Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase829Actor*>(this)->ActorCallback< FlowTestCase829Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase829Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase829Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase829Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase829()
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase829Actor final : public Actor<Void>, public ActorCallback< FlowTestCase829Actor, 0, Void >, public FastAllocated<FlowTestCase829Actor>, public FlowTestCase829ActorState<FlowTestCase829Actor> {
															#line 15858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase829Actor>::operator new;
	using FastAllocated<FlowTestCase829Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5731289770753316096UL, 168115781628100352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase829Actor, 0, Void >;
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase829Actor(UnitTestParameters const& params) 
															#line 15875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase829ActorState<FlowTestCase829Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6821780616658211840UL, 3970267137474583040UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase829");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase829Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase829( UnitTestParameters const& params ) {
															#line 829 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase829Actor(params));
															#line 15908 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase829, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfigAndChangeClass")

#line 833 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15914 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase834()
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase834Actor>
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase834ActorState {
															#line 15921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase834ActorState(UnitTestParameters const& params) 
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15928 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase834", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase834ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase834", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testCompact<BroadcasterToLocalConfigEnvironment>(params);
															#line 835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase834Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15945 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase834Actor*>(this)->actor_wait_state = 1;
															#line 835 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase834Actor, 0, Void >*>(static_cast<FlowTestCase834Actor*>(this)));
															#line 15950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 836 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase834Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase834ActorState(); static_cast<FlowTestCase834Actor*>(this)->destroy(); return 0; }
															#line 15973 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase834Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 836 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase834Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase834ActorState(); static_cast<FlowTestCase834Actor*>(this)->destroy(); return 0; }
															#line 15985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase834Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase834Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase834Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase834Actor*>(this)->ActorCallback< FlowTestCase834Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase834Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase834Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase834Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16070 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase834()
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase834Actor final : public Actor<Void>, public ActorCallback< FlowTestCase834Actor, 0, Void >, public FastAllocated<FlowTestCase834Actor>, public FlowTestCase834ActorState<FlowTestCase834Actor> {
															#line 16075 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase834Actor>::operator new;
	using FastAllocated<FlowTestCase834Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6626642982272626688UL, 5169725467146237952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase834Actor, 0, Void >;
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase834Actor(UnitTestParameters const& params) 
															#line 16092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase834ActorState<FlowTestCase834Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345484310959859712UL, 16323488030012064000UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase834");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase834Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase834( UnitTestParameters const& params ) {
															#line 834 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase834Actor(params));
															#line 16125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase834, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Compact")

#line 838 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16131 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase839()
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase839Actor>
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase839ActorState {
															#line 16138 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase839ActorState(UnitTestParameters const& params) 
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase839", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase839ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase839", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 840 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = testNewLocalConfigAfterCompaction<BroadcasterToLocalConfigEnvironment>(params);
															#line 840 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase839Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase839Actor*>(this)->actor_wait_state = 1;
															#line 840 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase839Actor, 0, std::string >*>(static_cast<FlowTestCase839Actor*>(this)));
															#line 16167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::string const& statusStr,int loopDepth) 
	{
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		json_spirit::mValue status;
															#line 842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(json_spirit::read_string(statusStr, status));
															#line 843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(status.type() == json_spirit::obj_type);
															#line 844 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto lastCompacted = status.get_obj().at("last_compacted_version").get_int64();
															#line 845 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(lastCompacted, 1);
															#line 846 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mostRecent = status.get_obj().at("most_recent_version").get_int64();
															#line 847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mostRecent, 2);
															#line 848 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto commits = status.get_obj().at("commits");
															#line 851 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(commits.get_array().size(), 0);
															#line 852 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mutations = status.get_obj().at("mutations");
															#line 853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mutations.get_array().size(), 1);
															#line 854 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto snapshot = status.get_obj().at("snapshot");
															#line 855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto classA = snapshot.get_obj().at("class-A");
															#line 856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto value = classA.get_obj().at("test_long").get_str();
															#line 857 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(value == "int64_t:2");
															#line 858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase839Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase839ActorState(); static_cast<FlowTestCase839Actor*>(this)->destroy(); return 0; }
															#line 16220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase839Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::string && statusStr,int loopDepth) 
	{
															#line 841 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		json_spirit::mValue status;
															#line 842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(json_spirit::read_string(statusStr, status));
															#line 843 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(status.type() == json_spirit::obj_type);
															#line 844 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto lastCompacted = status.get_obj().at("last_compacted_version").get_int64();
															#line 845 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(lastCompacted, 1);
															#line 846 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mostRecent = status.get_obj().at("most_recent_version").get_int64();
															#line 847 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mostRecent, 2);
															#line 848 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto commits = status.get_obj().at("commits");
															#line 851 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(commits.get_array().size(), 0);
															#line 852 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mutations = status.get_obj().at("mutations");
															#line 853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mutations.get_array().size(), 1);
															#line 854 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto snapshot = status.get_obj().at("snapshot");
															#line 855 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto classA = snapshot.get_obj().at("class-A");
															#line 856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto value = classA.get_obj().at("test_long").get_str();
															#line 857 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(value == "int64_t:2");
															#line 858 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase839Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase839ActorState(); static_cast<FlowTestCase839Actor*>(this)->destroy(); return 0; }
															#line 16262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase839Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase839Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase839Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase839Actor*>(this)->ActorCallback< FlowTestCase839Actor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase839Actor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase839Actor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase839Actor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16347 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase839()
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase839Actor final : public Actor<Void>, public ActorCallback< FlowTestCase839Actor, 0, std::string >, public FastAllocated<FlowTestCase839Actor>, public FlowTestCase839ActorState<FlowTestCase839Actor> {
															#line 16352 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase839Actor>::operator new;
	using FastAllocated<FlowTestCase839Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11439702557028892160UL, 12933675150620605184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase839Actor, 0, std::string >;
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase839Actor(UnitTestParameters const& params) 
															#line 16369 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase839ActorState<FlowTestCase839Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4627828986397525248UL, 16945378095993561600UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase839");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase839Actor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase839( UnitTestParameters const& params ) {
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase839Actor(params));
															#line 16402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase839, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfigurationAfterCompaction")

#line 860 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase861()
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase861Actor>
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase861ActorState {
															#line 16415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase861ActorState(UnitTestParameters const& params) 
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16422 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase861", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase861ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase861", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 862 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testKillWorker<BroadcasterToLocalConfigEnvironment>(params);
															#line 862 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase861Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase861Actor*>(this)->actor_wait_state = 1;
															#line 862 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase861Actor, 0, Void >*>(static_cast<FlowTestCase861Actor*>(this)));
															#line 16444 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 863 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase861Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase861ActorState(); static_cast<FlowTestCase861Actor*>(this)->destroy(); return 0; }
															#line 16467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase861Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 863 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase861Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase861ActorState(); static_cast<FlowTestCase861Actor*>(this)->destroy(); return 0; }
															#line 16479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase861Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase861Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase861Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase861Actor*>(this)->ActorCallback< FlowTestCase861Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase861Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase861Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase861Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase861()
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase861Actor final : public Actor<Void>, public ActorCallback< FlowTestCase861Actor, 0, Void >, public FastAllocated<FlowTestCase861Actor>, public FlowTestCase861ActorState<FlowTestCase861Actor> {
															#line 16569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase861Actor>::operator new;
	using FastAllocated<FlowTestCase861Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15574549200464601088UL, 12383431397582126080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase861Actor, 0, Void >;
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase861Actor(UnitTestParameters const& params) 
															#line 16586 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase861ActorState<FlowTestCase861Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6169393718029663744UL, 10388673295265566720UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase861");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase861Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase861( UnitTestParameters const& params ) {
															#line 861 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase861Actor(params));
															#line 16619 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase861, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/KillWorker")

#line 865 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16625 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase866()
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase866Actor>
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase866ActorState {
															#line 16632 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase866ActorState(UnitTestParameters const& params) 
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16639 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase866", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase866ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase866", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<TransactionToLocalConfigEnvironment>(params);
															#line 867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase866Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16656 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase866Actor*>(this)->actor_wait_state = 1;
															#line 867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase866Actor, 0, Void >*>(static_cast<FlowTestCase866Actor*>(this)));
															#line 16661 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 868 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase866Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase866ActorState(); static_cast<FlowTestCase866Actor*>(this)->destroy(); return 0; }
															#line 16684 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase866Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 868 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase866Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase866ActorState(); static_cast<FlowTestCase866Actor*>(this)->destroy(); return 0; }
															#line 16696 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase866Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase866Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase866Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase866Actor*>(this)->ActorCallback< FlowTestCase866Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase866Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase866Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase866Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16781 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase866()
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase866Actor final : public Actor<Void>, public ActorCallback< FlowTestCase866Actor, 0, Void >, public FastAllocated<FlowTestCase866Actor>, public FlowTestCase866ActorState<FlowTestCase866Actor> {
															#line 16786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase866Actor>::operator new;
	using FastAllocated<FlowTestCase866Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16935181436235851008UL, 12285631910155588096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase866Actor, 0, Void >;
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase866Actor(UnitTestParameters const& params) 
															#line 16803 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase866ActorState<FlowTestCase866Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17925566989010165760UL, 9035790778770947072UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase866");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase866Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase866( UnitTestParameters const& params ) {
															#line 866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase866Actor(params));
															#line 16836 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase866, "/fdbserver/ConfigDB/TransactionToLocalConfig/Set")

#line 870 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase871()
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase871Actor>
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase871ActorState {
															#line 16849 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase871ActorState(UnitTestParameters const& params) 
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16856 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase871", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase871ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase871", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 872 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<TransactionToLocalConfigEnvironment>(params);
															#line 872 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase871Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16873 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase871Actor*>(this)->actor_wait_state = 1;
															#line 872 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase871Actor, 0, Void >*>(static_cast<FlowTestCase871Actor*>(this)));
															#line 16878 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 873 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase871Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase871ActorState(); static_cast<FlowTestCase871Actor*>(this)->destroy(); return 0; }
															#line 16901 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase871Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 873 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase871Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase871ActorState(); static_cast<FlowTestCase871Actor*>(this)->destroy(); return 0; }
															#line 16913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase871Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase871Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase871Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase871Actor*>(this)->ActorCallback< FlowTestCase871Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase871Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase871Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase871Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16998 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase871()
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase871Actor final : public Actor<Void>, public ActorCallback< FlowTestCase871Actor, 0, Void >, public FastAllocated<FlowTestCase871Actor>, public FlowTestCase871ActorState<FlowTestCase871Actor> {
															#line 17003 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase871Actor>::operator new;
	using FastAllocated<FlowTestCase871Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14054382397917400832UL, 3305898311981696768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase871Actor, 0, Void >;
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase871Actor(UnitTestParameters const& params) 
															#line 17020 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase871ActorState<FlowTestCase871Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17853841182963421440UL, 2484044399659509760UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase871");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase871Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase871( UnitTestParameters const& params ) {
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase871Actor(params));
															#line 17053 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase871, "/fdbserver/ConfigDB/TransactionToLocalConfig/Clear")

#line 875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17059 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase876()
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase876Actor>
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase876ActorState {
															#line 17066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase876ActorState(UnitTestParameters const& params) 
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17073 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase876", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase876ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase876", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<TransactionToLocalConfigEnvironment>(params);
															#line 877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase876Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17090 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase876Actor*>(this)->actor_wait_state = 1;
															#line 877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase876Actor, 0, Void >*>(static_cast<FlowTestCase876Actor*>(this)));
															#line 17095 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 878 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase876Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase876ActorState(); static_cast<FlowTestCase876Actor*>(this)->destroy(); return 0; }
															#line 17118 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase876Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 878 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase876Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase876ActorState(); static_cast<FlowTestCase876Actor*>(this)->destroy(); return 0; }
															#line 17130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase876Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase876Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase876Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase876Actor*>(this)->ActorCallback< FlowTestCase876Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase876Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase876Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase876Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 17215 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase876()
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase876Actor final : public Actor<Void>, public ActorCallback< FlowTestCase876Actor, 0, Void >, public FastAllocated<FlowTestCase876Actor>, public FlowTestCase876ActorState<FlowTestCase876Actor> {
															#line 17220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase876Actor>::operator new;
	using FastAllocated<FlowTestCase876Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10103418936810266624UL, 14414006080417730048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase876Actor, 0, Void >;
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase876Actor(UnitTestParameters const& params) 
															#line 17237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase876ActorState<FlowTestCase876Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11189247337515972352UL, 3506640124560926208UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase876");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase876Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase876( UnitTestParameters const& params ) {
															#line 876 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase876Actor(params));
															#line 17270 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase876, "/fdbserver/ConfigDB/TransactionToLocalConfig/GlobalSet")

#line 880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase881()
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase881Actor>
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase881ActorState {
															#line 17283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase881ActorState(UnitTestParameters const& params) 
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 17292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase881", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase881ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase881", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 1;
															#line 883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 0, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17339 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 2;
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 1, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17344 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17355 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 2;
															#line 884 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 1, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17448 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 3;
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 2, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17453 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17466 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 3;
															#line 886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 2, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17471 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase881Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase881ActorState(); static_cast<FlowTestCase881Actor*>(this)->destroy(); return 0; }
															#line 17555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase881Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 887 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase881Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase881ActorState(); static_cast<FlowTestCase881Actor*>(this)->destroy(); return 0; }
															#line 17567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase881Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionToLocalConfigEnvironment env;
															#line 17654 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase881()
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase881Actor final : public Actor<Void>, public ActorCallback< FlowTestCase881Actor, 0, Void >, public ActorCallback< FlowTestCase881Actor, 1, Void >, public ActorCallback< FlowTestCase881Actor, 2, Void >, public FastAllocated<FlowTestCase881Actor>, public FlowTestCase881ActorState<FlowTestCase881Actor> {
															#line 17659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase881Actor>::operator new;
	using FastAllocated<FlowTestCase881Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1882355231516056576UL, 1610530505933921792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase881Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase881Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase881Actor, 2, Void >;
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase881Actor(UnitTestParameters const& params) 
															#line 17678 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase881ActorState<FlowTestCase881Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14122163549893164288UL, 17159159028816462080UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase881");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase881( UnitTestParameters const& params ) {
															#line 881 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase881Actor(params));
															#line 17713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase881, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartNode")

#line 889 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17719 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase890()
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase890Actor>
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase890ActorState {
															#line 17726 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase890ActorState(UnitTestParameters const& params) 
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase890", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase890ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase890", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testChangeBroadcaster<TransactionToLocalConfigEnvironment>(params);
															#line 891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase890Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase890Actor*>(this)->actor_wait_state = 1;
															#line 891 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase890Actor, 0, Void >*>(static_cast<FlowTestCase890Actor*>(this)));
															#line 17755 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase890Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase890ActorState(); static_cast<FlowTestCase890Actor*>(this)->destroy(); return 0; }
															#line 17778 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase890Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 892 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase890Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase890ActorState(); static_cast<FlowTestCase890Actor*>(this)->destroy(); return 0; }
															#line 17790 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase890Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase890Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase890Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase890Actor*>(this)->ActorCallback< FlowTestCase890Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase890Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase890Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase890Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 17875 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase890()
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase890Actor final : public Actor<Void>, public ActorCallback< FlowTestCase890Actor, 0, Void >, public FastAllocated<FlowTestCase890Actor>, public FlowTestCase890ActorState<FlowTestCase890Actor> {
															#line 17880 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase890Actor>::operator new;
	using FastAllocated<FlowTestCase890Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17106363676712069632UL, 16232696395076062208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase890Actor, 0, Void >;
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase890Actor(UnitTestParameters const& params) 
															#line 17897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase890ActorState<FlowTestCase890Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2639671460562912000UL, 2843599151296800768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase890");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase890Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase890( UnitTestParameters const& params ) {
															#line 890 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase890Actor(params));
															#line 17930 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase890, "/fdbserver/ConfigDB/TransactionToLocalConfig/ChangeBroadcaster")

#line 894 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17936 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase895()
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase895Actor>
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase895ActorState {
															#line 17943 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase895ActorState(UnitTestParameters const& params) 
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase895", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase895ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase895", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<TransactionToLocalConfigEnvironment>(params);
															#line 896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase895Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17967 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase895Actor*>(this)->actor_wait_state = 1;
															#line 896 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase895Actor, 0, Void >*>(static_cast<FlowTestCase895Actor*>(this)));
															#line 17972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase895Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase895ActorState(); static_cast<FlowTestCase895Actor*>(this)->destroy(); return 0; }
															#line 17995 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase895Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase895Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase895ActorState(); static_cast<FlowTestCase895Actor*>(this)->destroy(); return 0; }
															#line 18007 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase895Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase895Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase895Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase895Actor*>(this)->ActorCallback< FlowTestCase895Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase895Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase895Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase895Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18092 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase895()
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase895Actor final : public Actor<Void>, public ActorCallback< FlowTestCase895Actor, 0, Void >, public FastAllocated<FlowTestCase895Actor>, public FlowTestCase895ActorState<FlowTestCase895Actor> {
															#line 18097 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase895Actor>::operator new;
	using FastAllocated<FlowTestCase895Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11235450435036928000UL, 9936083342725695744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase895Actor, 0, Void >;
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase895Actor(UnitTestParameters const& params) 
															#line 18114 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase895ActorState<FlowTestCase895Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17593559860383894272UL, 8807135508474283776UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase895");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase895Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase895( UnitTestParameters const& params ) {
															#line 895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase895Actor(params));
															#line 18147 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase895, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartLocalConfigAndChangeClass")

#line 899 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase900()
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase900Actor>
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase900ActorState {
															#line 18160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase900ActorState(UnitTestParameters const& params) 
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase900", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase900ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase900", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 901 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testCompact<TransactionToLocalConfigEnvironment>(params);
															#line 901 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase900Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase900Actor*>(this)->actor_wait_state = 1;
															#line 901 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase900Actor, 0, Void >*>(static_cast<FlowTestCase900Actor*>(this)));
															#line 18189 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase900Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase900ActorState(); static_cast<FlowTestCase900Actor*>(this)->destroy(); return 0; }
															#line 18212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase900Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase900Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase900ActorState(); static_cast<FlowTestCase900Actor*>(this)->destroy(); return 0; }
															#line 18224 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase900Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase900Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase900Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase900Actor*>(this)->ActorCallback< FlowTestCase900Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase900Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase900Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase900Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18309 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase900()
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase900Actor final : public Actor<Void>, public ActorCallback< FlowTestCase900Actor, 0, Void >, public FastAllocated<FlowTestCase900Actor>, public FlowTestCase900ActorState<FlowTestCase900Actor> {
															#line 18314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase900Actor>::operator new;
	using FastAllocated<FlowTestCase900Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2870896991233289216UL, 1388946595548866304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase900Actor, 0, Void >;
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase900Actor(UnitTestParameters const& params) 
															#line 18331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase900ActorState<FlowTestCase900Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11655958738668928512UL, 9549210905419656960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase900");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase900Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase900( UnitTestParameters const& params ) {
															#line 900 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase900Actor(params));
															#line 18364 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase900, "/fdbserver/ConfigDB/TransactionToLocalConfig/CompactNode")

#line 904 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18370 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase905()
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase905Actor>
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase905ActorState {
															#line 18377 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase905ActorState(UnitTestParameters const& params) 
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase905", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase905ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase905", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(testNewLocalConfigAfterCompaction<TransactionToLocalConfigEnvironment>(params));
															#line 909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase905Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase905Actor*>(this)->actor_wait_state = 1;
															#line 909 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase905Actor, 0, Void >*>(static_cast<FlowTestCase905Actor*>(this)));
															#line 18406 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase905Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase905ActorState(); static_cast<FlowTestCase905Actor*>(this)->destroy(); return 0; }
															#line 18429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase905Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 910 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase905Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase905ActorState(); static_cast<FlowTestCase905Actor*>(this)->destroy(); return 0; }
															#line 18441 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase905Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase905Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase905Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase905Actor*>(this)->ActorCallback< FlowTestCase905Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase905Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase905Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase905Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18526 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase905()
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase905Actor final : public Actor<Void>, public ActorCallback< FlowTestCase905Actor, 0, Void >, public FastAllocated<FlowTestCase905Actor>, public FlowTestCase905ActorState<FlowTestCase905Actor> {
															#line 18531 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase905Actor>::operator new;
	using FastAllocated<FlowTestCase905Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10496051953585254144UL, 11520433399393946112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase905Actor, 0, Void >;
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase905Actor(UnitTestParameters const& params) 
															#line 18548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase905ActorState<FlowTestCase905Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3588969626550065152UL, 3877870623034724096UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase905");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase905Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase905( UnitTestParameters const& params ) {
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase905Actor(params));
															#line 18581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase905, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartLocalConfigurationAfterCompaction")

#line 912 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase913()
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase913Actor>
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase913ActorState {
															#line 18594 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase913ActorState(UnitTestParameters const& params) 
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase913", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase913ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase913", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 914 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testKillWorker<TransactionToLocalConfigEnvironment>(params);
															#line 914 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase913Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase913Actor*>(this)->actor_wait_state = 1;
															#line 914 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase913Actor, 0, Void >*>(static_cast<FlowTestCase913Actor*>(this)));
															#line 18623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase913Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase913ActorState(); static_cast<FlowTestCase913Actor*>(this)->destroy(); return 0; }
															#line 18646 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase913Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase913Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase913ActorState(); static_cast<FlowTestCase913Actor*>(this)->destroy(); return 0; }
															#line 18658 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase913Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase913Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase913Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase913Actor*>(this)->ActorCallback< FlowTestCase913Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase913Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase913Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase913Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18743 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase913()
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase913Actor final : public Actor<Void>, public ActorCallback< FlowTestCase913Actor, 0, Void >, public FastAllocated<FlowTestCase913Actor>, public FlowTestCase913ActorState<FlowTestCase913Actor> {
															#line 18748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase913Actor>::operator new;
	using FastAllocated<FlowTestCase913Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17342330288934789632UL, 4440569048525897984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase913Actor, 0, Void >;
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase913Actor(UnitTestParameters const& params) 
															#line 18765 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase913ActorState<FlowTestCase913Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11454068281034455296UL, 15261284531602196480UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase913");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase913Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase913( UnitTestParameters const& params ) {
															#line 913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase913Actor(params));
															#line 18798 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase913, "/fdbserver/ConfigDB/TransactionToLocalConfig/KillWorker")

#line 917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18804 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase918()
															#line 918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase918Actor>
															#line 918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase918ActorState {
															#line 18811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase918ActorState(UnitTestParameters const& params) 
															#line 918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 918 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 919 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 18820 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase918", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase918ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase918", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup();
															#line 920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18837 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 1;
															#line 920 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 0, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase918ActorState();
		static_cast<FlowTestCase918Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 2;
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 1, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18872 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18883 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 2;
															#line 921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 1, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18888 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase918Actor*>(this)->ActorCallback< FlowTestCase918Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase918Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18974 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 3;
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 2, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18979 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 3;
															#line 922 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 2, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18995 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase918Actor*>(this)->ActorCallback< FlowTestCase918Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelpe