#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
/*
 * GenericManagementAPI.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H
#include "fdbclient/GenericManagementAPI.actor.g.h"
#elif !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H

/* This file defines "management" interfaces that have been templated to support both IClientAPI
and Native version of databases, transactions, etc., and includes functions for performing cluster
management tasks. It isn't exposed to C clients or anywhere outside our code base and doesn't need
to be versioned. It doesn't do anything you can't do with the standard API and some knowledge of
the contents of the system key space.
*/

#include <string>
#include <map>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/Status.h"
#include "fdbclient/Subspace.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // has to be last include

// ConfigurationResult enumerates normal outcomes of changeConfig() and various error
// conditions specific to it.  changeConfig may also throw an Error to report other problems.
enum class ConfigurationResult {
	NO_OPTIONS_PROVIDED,
	CONFLICTING_OPTIONS,
	UNKNOWN_OPTION,
	INCOMPLETE_CONFIGURATION,
	INVALID_CONFIGURATION,
	STORAGE_MIGRATION_DISABLED,
	DATABASE_ALREADY_CREATED,
	DATABASE_CREATED,
	DATABASE_UNAVAILABLE,
	STORAGE_IN_UNKNOWN_DCID,
	REGION_NOT_FULLY_REPLICATED,
	MULTIPLE_ACTIVE_REGIONS,
	REGIONS_CHANGED,
	NOT_ENOUGH_WORKERS,
	REGION_REPLICATION_MISMATCH,
	DCID_MISSING,
	LOCKED_NOT_NEW,
	SUCCESS_WARN_PPW_GRADUAL,
	SUCCESS,
	SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_IS_REGISTERED,
	ENCRYPTION_AT_REST_MODE_ALREADY_SET,
	INVALID_STORAGE_TYPE
};

enum class CoordinatorsResult {
	INVALID_NETWORK_ADDRESSES,
	SAME_NETWORK_ADDRESSES,
	NOT_COORDINATORS, // FIXME: not detected
	DATABASE_UNREACHABLE, // FIXME: not detected
	BAD_DATABASE_STATE,
	COORDINATOR_UNREACHABLE,
	NOT_ENOUGH_MACHINES,
	SUCCESS
};

struct ConfigureAutoResult {
	std::map<NetworkAddress, ProcessClass> address_class;
	int32_t processes;
	int32_t machines;

	std::string old_replication;
	int32_t old_commit_proxies;
	int32_t old_grv_proxies;
	int32_t old_resolvers;
	int32_t old_logs;
	int32_t old_processes_with_transaction;
	int32_t old_machines_with_transaction;

	std::string auto_replication;
	int32_t auto_commit_proxies;
	int32_t auto_grv_proxies;
	int32_t auto_resolvers;
	int32_t auto_logs;
	int32_t auto_processes_with_transaction;
	int32_t auto_machines_with_transaction;

	int32_t desired_commit_proxies;
	int32_t desired_grv_proxies;
	int32_t desired_resolvers;
	int32_t desired_logs;

	ConfigureAutoResult()
	  : processes(-1), machines(-1), old_commit_proxies(-1), old_grv_proxies(-1), old_resolvers(-1), old_logs(-1),
	    old_processes_with_transaction(-1), old_machines_with_transaction(-1), auto_commit_proxies(-1),
	    auto_grv_proxies(-1), auto_resolvers(-1), auto_logs(-1), auto_processes_with_transaction(-1),
	    auto_machines_with_transaction(-1), desired_commit_proxies(-1), desired_grv_proxies(-1), desired_resolvers(-1),
	    desired_logs(-1) {}

	bool isValid() const { return processes != -1; }
};

ConfigurationResult buildConfiguration(
    std::vector<StringRef> const& modeTokens,
    std::map<std::string, std::string>& outConf); // Accepts a vector of configuration tokens
ConfigurationResult buildConfiguration(
    std::string const& modeString,
    std::map<std::string, std::string>& outConf); // Accepts tokens separated by spaces in a single string

bool isCompleteConfiguration(std::map<std::string, std::string> const& options);

ConfigureAutoResult parseConfig(StatusObject const& status);

bool isEncryptionAtRestModeConfigValid(Optional<DatabaseConfiguration> oldConfiguration,
                                       std::map<std::string, std::string> newConfig,
                                       bool creating);
bool isTenantModeModeConfigValid(DatabaseConfiguration oldConfiguration, DatabaseConfiguration newConfiguration);

// Management API written in template code to support both IClientAPI and NativeAPI
namespace ManagementAPI {

															#line 145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via getWorkers()
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr, class GetWorkersActor>
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActorState {
															#line 151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActorState(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : tr(tr),
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processClassesF(processClassesF),
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processDataF(processDataF)
															#line 162 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 148 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = tr->getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 149 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = tr->getRange(workerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClasses = safeThreadFutureToFuture(processClassesF);
															#line 151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processData = safeThreadFutureToFuture(processDataF);
															#line 153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_0 = success(processClasses) && success(processData);
															#line 153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 153 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 192 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 223 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 171 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 173 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 247 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 252 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 158 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 166 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 171 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 173 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 296 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 177 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 301 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<Tr> tr;
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processClassesF;
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processDataF;
															#line 150 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processClasses;
															#line 151 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processData;
															#line 394 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via getWorkers()
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActor final : public Actor<std::vector<ProcessData>>, public ActorCallback< GetWorkersActor<Tr>, 0, Void >, public FastAllocated<GetWorkersActor<Tr>>, public GetWorkersActorState<Tr, GetWorkersActor<Tr>> {
															#line 401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<GetWorkersActor<Tr>>::operator new;
	using FastAllocated<GetWorkersActor<Tr>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13348060316962707712UL, 7421523979666755840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<ProcessData>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor<Tr>, 0, Void >;
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActor(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 418 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<std::vector<ProcessData>>(),
		   GetWorkersActorState<Tr, GetWorkersActor<Tr>>(tr, processClassesF, processDataF),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor<Tr>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Reference<Tr> const& tr, typename Tr::template FutureT<RangeResult> const& processClassesF, typename Tr::template FutureT<RangeResult> const& processDataF ) {
															#line 143 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<std::vector<ProcessData>>(new GetWorkersActor<Tr>(tr, processClassesF, processDataF));
															#line 452 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 179 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// All versions of changeConfig apply the given set of configuration tokens to the database, and return a
// ConfigurationResult (or error).

// Accepts a full configuration in key/value format (from buildConfiguration)
															#line 461 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via changeConfig()
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class ChangeConfigActor>
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActorState {
															#line 467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActorState(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   m(m),
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   force(force),
															#line 186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   initIdKey("\xff/init_id"_sr),
															#line 187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction())
															#line 482 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigActorState() 
	{
		fdb_probe_actor_destroy("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!m.size())
															#line 497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NO_OPTIONS_PROVIDED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 501 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NO_OPTIONS_PROVIDED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::string initKey = configKeysPrefix.toString() + "initialized";
															#line 195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			creating = m.count(initKey) != 0;
															#line 196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			locked = Optional<UID>();
															#line 513 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 198 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				auto iter = m.find(databaseLockedKey.toString());
															#line 199 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (iter != m.end())
															#line 519 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!creating)
															#line 523 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 201 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::LOCKED_NOT_NEW); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 527 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::LOCKED_NOT_NEW);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					locked = UID::fromString(iter->second);
															#line 204 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					m.erase(iter);
															#line 537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (creating)
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 208 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				m[initIdKey.toString()] = deterministicRandom()->randomUniqueID().toString();
															#line 209 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!isCompleteConfiguration(m))
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 212 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!isEncryptionAtRestModeConfigValid(Optional<DatabaseConfiguration>(), m, creating))
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 213 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 215 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (m.count(encryptionAtRestModeConfKey.toString()) != 0)
															#line 575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 217 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tooLong = delay(60);
															#line 221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			versionKey = BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned());
															#line 222 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = false;
															#line 225 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			resetPPWStats = false;
															#line 226 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnPPWGradual = false;
															#line 227 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnShardedRocksDBIsExperimental = false;
															#line 229 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 600 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigActorState();
		static_cast<ChangeConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 508 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (warnPPWGradual)
															#line 623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 509 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 627 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 510 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (warnShardedRocksDBIsExperimental)
															#line 637 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 511 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 641 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 513 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 651 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 231 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 232 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 233 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 234 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 236 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!creating && !force)
															#line 681 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfigF = tr->getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfig = safeThreadFutureToFuture(fConfigF);
															#line 240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 242 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fWorkers = getWorkers(tr, processClassesF, processDataF);
															#line 243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				StrictFuture<Void> __when_expr_0 = success(fConfig) || tooLong;
															#line 243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 697 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeConfigActor*>(this)->actor_wait_state = 1;
															#line 243 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 0, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 702 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 478 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			e1 = Error(e);
															#line 479 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if ((e.code() == error_code_not_committed || e.code() == error_code_transaction_too_old) && creating)
															#line 744 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 482 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->reset();
															#line 483 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				;
															#line 750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 436 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (creating)
															#line 770 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 437 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::INITIALIZE_NEW_DATABASE);
															#line 438 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->addReadConflictRange(singleKeyRange(initIdKey));
															#line 776 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m.size())
															#line 782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 442 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
															#line 443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->addReadConflictRange(singleKeyRange(m.begin()->first));
															#line 788 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 446 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (locked.present())
															#line 793 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 447 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(creating);
															#line 448 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->atomicOp(databaseLockedKey, BinaryWriter::toValue(locked.get(), Unversioned()) .withPrefix("0123456789"_sr) .withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 799 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 455 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(auto i = m.begin();i != m.end();++i) {
															#line 456 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(StringRef(i->first), StringRef(i->second));
															#line 457 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (i->first == perpetualStorageWiggleKey)
															#line 807 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 458 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (i->second == "0")
															#line 811 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 459 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					resetPPWStats = true;
															#line 815 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
				else
				{
															#line 460 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (i->first == "1")
															#line 821 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 461 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						resetPPWStats = false;
															#line 825 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
			}
		}
															#line 466 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!creating && resetPPWStats)
															#line 832 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			wiggleData = StorageWiggleData();
															#line 468 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_6 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(true));
															#line 468 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 840 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 7;
															#line 468 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 6, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 845 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont24(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 245 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 859 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 246 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 863 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 871 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 252 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 254 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 885 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 257 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid() || !isEncryptionAtRestModeConfigValid(oldConfig, m, creating) || !isTenantModeModeConfigValid(oldConfig, newConfig))
															#line 889 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 259 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 893 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 901 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 266 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 915 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 923 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
															#line 275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 929 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 933 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 282 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 946 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 285 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 950 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
															#line 288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 959 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 293 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 295 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 298 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 299 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 976 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 300 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 986 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 991 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 325 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 328 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 329 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 1004 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						{
															#line 330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 1010 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						}
					}
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1022 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 245 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 1042 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 246 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1046 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 1054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 250 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 252 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 254 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 255 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 1068 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 257 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid() || !isEncryptionAtRestModeConfigValid(oldConfig, m, creating) || !isTenantModeModeConfigValid(oldConfig, newConfig))
															#line 1072 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 259 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1076 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 262 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 1084 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 263 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1088 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 266 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 269 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 1098 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 271 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 272 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 1106 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
															#line 275 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 276 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 1112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 277 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 282 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 284 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 1129 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 285 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 1133 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
															#line 288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 1138 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 289 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1142 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 293 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 295 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 298 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 1155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 299 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 1159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 300 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 303 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1174 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 325 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 328 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 329 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 1187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						{
															#line 330 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 331 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 1193 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						}
					}
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1200 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 334 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1205 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 347 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 1306 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_3 = success(fServerList) || tooLong;
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 4;
															#line 349 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 3, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1317 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 1337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1341 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 311 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 1359 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 1363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 1370 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 1389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1393 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 308 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 310 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 311 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 312 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 313 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 1411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 314 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 1415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 318 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 1422 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 320 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont19(Void const& _,int loopDepth) 
	{
															#line 336 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 1518 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1522 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 1530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 341 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1534 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(Void && _,int loopDepth) 
	{
															#line 336 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 1551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 338 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 340 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 1563 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 341 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
															#line 372 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_4 = success(fWorkers) || tooLong;
															#line 372 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont22when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 5;
															#line 372 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 4, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1664 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void const& _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 1673 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 351 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1677 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 356 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 358 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 1693 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 361 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 362 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 1703 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 364 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 1707 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 1712 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1716 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void && _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 1730 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 351 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1734 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 353 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 354 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 356 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 357 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 358 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 1750 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 360 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 361 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 362 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 363 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 1760 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 364 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 1764 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 367 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 1769 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 368 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1773 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 1862 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1866 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 377 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 1874 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 380 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 1882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 381 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 1886 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 1893 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1897 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 1905 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 390 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 1913 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
															#line 394 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 1917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 400 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 1938 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 1942 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 406 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 1947 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 407 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1951 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 1960 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 412 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1964 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 1972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 417 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1976 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 418 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 1986 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 420 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 1990 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 1996 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 2000 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
		}
															#line 426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.tenantMode != oldConfig.tenantMode)
															#line 2006 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2012 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont22cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 6;
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2017 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1(Void && _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 2031 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2035 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 377 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 2043 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 378 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 380 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2051 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 381 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 2055 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 384 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 385 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2062 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 387 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2066 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 389 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 2074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 390 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 391 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 392 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 2082 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
															#line 394 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 2086 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 395 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2090 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 400 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 401 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 2111 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 406 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 407 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 411 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 2129 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 412 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2133 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 2141 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 417 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2145 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 418 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 2155 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 420 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 2159 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 421 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 2165 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 2169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
		}
															#line 426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.tenantMode != oldConfig.tenantMode)
															#line 2175 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont22cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 6;
															#line 427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont22cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont22(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
															#line 429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (metaclusterRegistration.present())
															#line 2281 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 430 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			CODE_PROBE(true, "Attempt to change tenant mode in a metacluster", probe::decoration::rare);
															#line 431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_IS_REGISTERED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2287 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_IS_REGISTERED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont22(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
															#line 429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (metaclusterRegistration.present())
															#line 2301 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 430 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			CODE_PROBE(true, "Attempt to change tenant mode in a metacluster", probe::decoration::rare);
															#line 431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_IS_REGISTERED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2307 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_IS_REGISTERED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1when1(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont22(metaclusterRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1when1(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont22(std::move(metaclusterRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont22cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont22cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont24(int loopDepth) 
	{
															#line 472 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 473 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_8 = safeThreadFutureToFuture(tr->commit());
															#line 475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2402 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont24when1(__when_expr_8.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 9;
															#line 475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 8, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2407 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void const& _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_7 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2418 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_7.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 8;
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 7, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void && _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_7 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2434 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_7.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 8;
															#line 469 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 7, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont34cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont34when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont34when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont24cont1(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24cont1(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont24when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont24when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_11 = safeThreadFutureToFuture(tr->onError(e1));
															#line 504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2699 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 12;
															#line 504 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 11, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2704 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
		try {
															#line 485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 486 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 487 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 488 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 490 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			vF = tr->get(initIdKey);
															#line 491 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<Value>> __when_expr_9 = safeThreadFutureToFuture(vF);
															#line 491 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2733 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 10;
															#line 491 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 9, Optional<Value> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2738 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_10 = safeThreadFutureToFuture(tr->onError(e2));
															#line 500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2762 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 11;
															#line 500 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 10, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2767 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 492 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 2782 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2786 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 2796 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 496 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2800 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 498 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2810 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 492 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 2824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 493 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2828 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 494 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 2838 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 496 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 498 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2852 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::map<std::string, std::string> m;
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool force;
															#line 186 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StringRef initIdKey;
															#line 187 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool creating;
															#line 196 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Optional<UID> locked;
															#line 220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<Void> tooLong;
															#line 221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 222 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool oldReplicationUsesDcId;
															#line 225 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool resetPPWStats;
															#line 226 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnPPWGradual;
															#line 227 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnShardedRocksDBIsExperimental;
															#line 237 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fConfigF;
															#line 239 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fConfig;
															#line 240 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 241 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 242 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<std::vector<ProcessData>> fWorkers;
															#line 251 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration oldConfig;
															#line 253 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration newConfig;
															#line 293 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fServerListF;
															#line 295 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fServerList;
															#line 300 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fLocalityListF;
															#line 302 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fLocalityList;
															#line 325 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>> replicasFuturesF;
															#line 327 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 467 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StorageWiggleData wiggleData;
															#line 478 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Error e1;
															#line 490 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<Optional<Value>> vF;
															#line 3169 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via changeConfig()
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< ChangeConfigActor<DB>, 0, Void >, public ActorCallback< ChangeConfigActor<DB>, 1, Void >, public ActorCallback< ChangeConfigActor<DB>, 2, Void >, public ActorCallback< ChangeConfigActor<DB>, 3, Void >, public ActorCallback< ChangeConfigActor<DB>, 4, Void >, public ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< ChangeConfigActor<DB>, 6, Void >, public ActorCallback< ChangeConfigActor<DB>, 7, Void >, public ActorCallback< ChangeConfigActor<DB>, 8, Void >, public ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >, public ActorCallback< ChangeConfigActor<DB>, 10, Void >, public ActorCallback< ChangeConfigActor<DB>, 11, Void >, public FastAllocated<ChangeConfigActor<DB>>, public ChangeConfigActorState<DB, ChangeConfigActor<DB>> {
															#line 3176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<ChangeConfigActor<DB>>::operator new;
	using FastAllocated<ChangeConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6256088308782403072UL, 16176748912626365440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigActor<DB>, 0, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 1, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 2, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 3, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 4, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< ChangeConfigActor<DB>, 6, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 7, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 8, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >;
friend struct ActorCallback< ChangeConfigActor<DB>, 10, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 11, Void >;
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActor(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 3204 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<ConfigurationResult>(),
		   ChangeConfigActorState<DB, ChangeConfigActor<DB>>(db, m, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6578240440549909504UL, 3862103298456711424UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> changeConfig( Reference<DB> const& db, std::map<std::string, std::string> const& m, bool const& force ) {
															#line 184 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new ChangeConfigActor<DB>(db, m, force));
															#line 3249 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 516 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

															#line 3254 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via autoConfig()
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class AutoConfigActor>
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActorState {
															#line 3260 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActorState(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   conf(conf),
															#line 519 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction()),
															#line 520 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   versionKey(BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned()))
															#line 3273 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	~AutoConfigActorState() 
	{
		fdb_probe_actor_destroy("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 522 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!conf.address_class.size())
															#line 3288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 523 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3292 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 525 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 3300 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 527 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 528 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 529 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 532 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 533 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 534 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(tr, processClassesF, processDataF);
															#line 534 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3345 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 1;
															#line 534 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*>(static_cast<AutoConfigActor*>(this)));
															#line 3350 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3374 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 3;
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 2, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3379 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 536 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 3398 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 540 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 3404 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 3408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 3414 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 3419 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 3423 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 3427 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 3431 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 554 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 3435 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 3439 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 3443 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 3447 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 3451 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 3455 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 563 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 3459 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 568 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 3471 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 3485 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3496 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3501 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 536 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 3514 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 540 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 541 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 3520 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 3524 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 544 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 3530 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 548 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 3535 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 549 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 3539 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 3543 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 552 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 3547 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 554 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 3551 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 3555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 557 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 3559 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 558 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 3563 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 560 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 3567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 561 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 3571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 563 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 3575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 564 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 565 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 567 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 568 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 3587 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 569 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3591 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 571 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 3601 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 575 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 576 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3612 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 578 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3617 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3701 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3713 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ConfigureAutoResult conf;
															#line 519 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 520 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 532 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 533 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 3895 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via autoConfig()
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >, public ActorCallback< AutoConfigActor<DB>, 1, Void >, public ActorCallback< AutoConfigActor<DB>, 2, Void >, public FastAllocated<AutoConfigActor<DB>>, public AutoConfigActorState<DB, AutoConfigActor<DB>> {
															#line 3902 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<AutoConfigActor<DB>>::operator new;
	using FastAllocated<AutoConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2368742375260595200UL, 5139701857319809280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >;
friend struct ActorCallback< AutoConfigActor<DB>, 1, Void >;
friend struct ActorCallback< AutoConfigActor<DB>, 2, Void >;
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActor(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 3921 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<ConfigurationResult>(),
		   AutoConfigActorState<DB, AutoConfigActor<DB>>(db, conf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(851761084017320448UL, 5414860964962561792UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("autoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> autoConfig( Reference<DB> const& db, ConfigureAutoResult const& conf ) {
															#line 517 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new AutoConfigActor<DB>(db, conf));
															#line 3957 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 585 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// Accepts tokens separated by spaces in a single string
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db, std::string const& modes, bool force) {
	TraceEvent("ChangeConfig").detail("Mode", modes);
	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// Accepts a vector of configuration tokens
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db,
                                         std::vector<StringRef> const& modes,
                                         Optional<ConfigureAutoResult> const& conf,
                                         bool force) {
	if (modes.size() && modes[0] == "auto"_sr && conf.present()) {
		return autoConfig(db, conf.get());
	}

	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// return the corresponding error message for the CoordinatorsResult
// used by special keys and fdbcli
std::string generateErrorMessage(const CoordinatorsResult& res);

} // namespace ManagementAPI

#include "flow/unactorcompiler.h"
#endif
