#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
/*
 * SetClassCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 38 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
// This generated class is to be used only via printProcessClass()
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
template <class PrintProcessClassActor>
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class PrintProcessClassActorState {
															#line 44 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	PrintProcessClassActorState(Reference<IDatabase> const& db) 
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		 : db(db),
															#line 37 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printProcessClass", reinterpret_cast<unsigned long>(this));

	}
	~PrintProcessClassActorState() 
	{
		fdb_probe_actor_destroy("printProcessClass", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			;
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintProcessClassActorState();
		static_cast<PrintProcessClassActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 39 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 98 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		try {
															#line 42 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			classTypeFuture = tr->getRange(fdb_cli::processClassTypeSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 44 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			classSourceFuture = tr->getRange(fdb_cli::processClassSourceSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 46 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(safeThreadFutureToFuture(classSourceFuture)) && success(safeThreadFutureToFuture(classTypeFuture));
															#line 46 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (static_cast<PrintProcessClassActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 108 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintProcessClassActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintProcessClassActor, 0, Void >*>(static_cast<PrintProcessClassActor*>(this)));
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 70 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (static_cast<PrintProcessClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 137 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintProcessClassActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintProcessClassActor, 1, Void >*>(static_cast<PrintProcessClassActor*>(this)));
															#line 142 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		RangeResult processTypeList = classTypeFuture.get();
															#line 49 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		RangeResult processSourceList = classSourceFuture.get();
															#line 50 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		ASSERT(processSourceList.size() == processTypeList.size());
															#line 51 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!processTypeList.size())
															#line 163 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		{
															#line 52 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("No processes are registered in the database.\n");
															#line 167 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		}
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		fmt::print("There are currently {} processes in the database:\n", processTypeList.size());
															#line 54 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		for(int index = 0;index < processTypeList.size();index++) {
															#line 55 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			std::string address = processTypeList[index].key.removePrefix(fdb_cli::processClassTypeSpecialKeyRange.begin).toString();
															#line 58 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			std::string addressFromSourceList = processSourceList[index] .key.removePrefix(fdb_cli::processClassSourceSpecialKeyRange.begin) .toString();
															#line 62 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			ASSERT(address == addressFromSourceList);
															#line 63 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("  %s: %s (%s)\n", address.c_str(), processTypeList[index].value.toString().c_str(), processSourceList[index].value.toString().c_str());
															#line 181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		}
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<PrintProcessClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintProcessClassActorState(); static_cast<PrintProcessClassActor*>(this)->destroy(); return 0; }
															#line 185 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<PrintProcessClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintProcessClassActorState();
		static_cast<PrintProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		RangeResult processTypeList = classTypeFuture.get();
															#line 49 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		RangeResult processSourceList = classSourceFuture.get();
															#line 50 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		ASSERT(processSourceList.size() == processTypeList.size());
															#line 51 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!processTypeList.size())
															#line 203 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		{
															#line 52 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("No processes are registered in the database.\n");
															#line 207 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		}
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		fmt::print("There are currently {} processes in the database:\n", processTypeList.size());
															#line 54 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		for(int index = 0;index < processTypeList.size();index++) {
															#line 55 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			std::string address = processTypeList[index].key.removePrefix(fdb_cli::processClassTypeSpecialKeyRange.begin).toString();
															#line 58 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			std::string addressFromSourceList = processSourceList[index] .key.removePrefix(fdb_cli::processClassSourceSpecialKeyRange.begin) .toString();
															#line 62 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			ASSERT(address == addressFromSourceList);
															#line 63 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("  %s: %s (%s)\n", address.c_str(), processTypeList[index].value.toString().c_str(), processSourceList[index].value.toString().c_str());
															#line 221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		}
															#line 68 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<PrintProcessClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintProcessClassActorState(); static_cast<PrintProcessClassActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<PrintProcessClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintProcessClassActorState();
		static_cast<PrintProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintProcessClassActor*>(this)->actor_wait_state > 0) static_cast<PrintProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<PrintProcessClassActor*>(this)->ActorCallback< PrintProcessClassActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintProcessClassActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintProcessClassActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintProcessClassActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintProcessClassActor*>(this)->actor_wait_state > 0) static_cast<PrintProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<PrintProcessClassActor*>(this)->ActorCallback< PrintProcessClassActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintProcessClassActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintProcessClassActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintProcessClassActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 37 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 42 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	ThreadFuture<RangeResult> classTypeFuture;
															#line 44 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	ThreadFuture<RangeResult> classSourceFuture;
															#line 403 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
};
// This generated class is to be used only via printProcessClass()
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class PrintProcessClassActor final : public Actor<Void>, public ActorCallback< PrintProcessClassActor, 0, Void >, public ActorCallback< PrintProcessClassActor, 1, Void >, public FastAllocated<PrintProcessClassActor>, public PrintProcessClassActorState<PrintProcessClassActor> {
															#line 408 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
	using FastAllocated<PrintProcessClassActor>::operator new;
	using FastAllocated<PrintProcessClassActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3911646281854769664UL, 8652112348142454528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintProcessClassActor, 0, Void >;
friend struct ActorCallback< PrintProcessClassActor, 1, Void >;
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	PrintProcessClassActor(Reference<IDatabase> const& db) 
															#line 426 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintProcessClassActorState<PrintProcessClassActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printProcessClass", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3938506438227535104UL, 15012618716287873792UL);
		ActorExecutionContextHelper __helper(static_cast<PrintProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printProcessClass");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printProcessClass", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintProcessClassActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintProcessClassActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
[[nodiscard]] Future<Void> printProcessClass( Reference<IDatabase> const& db ) {
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	return Future<Void>(new PrintProcessClassActor(db));
															#line 459 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
}

#line 73 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"


															#line 465 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
// This generated class is to be used only via setProcessClass()
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
template <class SetProcessClassActor>
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class SetProcessClassActorState {
															#line 471 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	SetProcessClassActorState(Reference<IDatabase> const& db,KeyRef const& network_address,KeyRef const& class_type) 
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		 : db(db),
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		   network_address(network_address),
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		   class_type(class_type),
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 484 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("setProcessClass", reinterpret_cast<unsigned long>(this));

	}
	~SetProcessClassActorState() 
	{
		fdb_probe_actor_destroy("setProcessClass", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			;
															#line 499 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetProcessClassActorState();
		static_cast<SetProcessClassActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 78 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 529 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		try {
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			result = tr->get(network_address.withPrefix(fdb_cli::processClassTypeSpecialKeyRange.begin));
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(result);
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (static_cast<SetProcessClassActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 537 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetProcessClassActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetProcessClassActor, 0, Optional<Value> >*>(static_cast<SetProcessClassActor*>(this)));
															#line 542 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			err = Error(e);
															#line 92 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			{
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				StrictFuture<std::string> __when_expr_2 = fdb_cli::getSpecialKeysFailureErrorMessage(tr);
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				if (static_cast<SetProcessClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<SetProcessClassActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetProcessClassActor, 2, std::string >*>(static_cast<SetProcessClassActor*>(this)));
															#line 577 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!val.present())
															#line 597 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		{
															#line 84 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("No matching addresses found\n");
															#line 85 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 603 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(false);
			this->~SetProcessClassActorState();
			static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		tr->set(network_address.withPrefix(fdb_cli::processClassTypeSpecialKeyRange.begin), class_type);
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 615 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetProcessClassActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetProcessClassActor, 1, Void >*>(static_cast<SetProcessClassActor*>(this)));
															#line 620 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!val.present())
															#line 629 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		{
															#line 84 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			printf("No matching addresses found\n");
															#line 85 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 635 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(false);
			this->~SetProcessClassActorState();
			static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		tr->set(network_address.withPrefix(fdb_cli::processClassTypeSpecialKeyRange.begin), class_type);
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetProcessClassActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetProcessClassActor, 1, Void >*>(static_cast<SetProcessClassActor*>(this)));
															#line 652 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state > 0) static_cast<SetProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<SetProcessClassActor*>(this)->ActorCallback< SetProcessClassActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetProcessClassActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 736 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SetProcessClassActorState();
		static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SetProcessClassActorState();
		static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state > 0) static_cast<SetProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<SetProcessClassActor*>(this)->ActorCallback< SetProcessClassActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetProcessClassActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(err));
															#line 98 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 837 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<SetProcessClassActor*>(this)->actor_wait_state = 4;
															#line 98 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SetProcessClassActor, 3, Void >*>(static_cast<SetProcessClassActor*>(this)));
															#line 842 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 95 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		fprintf(stderr, "%s", errorMsgStr.c_str());
															#line 96 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 853 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(false);
		this->~SetProcessClassActorState();
		static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 95 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		fprintf(stderr, "%s", errorMsgStr.c_str());
															#line 96 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetProcessClassActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetProcessClassActorState(); static_cast<SetProcessClassActor*>(this)->destroy(); return 0; }
															#line 867 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetProcessClassActor*>(this)->SAV< bool >::value()) bool(false);
		this->~SetProcessClassActorState();
		static_cast<SetProcessClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state > 0) static_cast<SetProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<SetProcessClassActor*>(this)->ActorCallback< SetProcessClassActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetProcessClassActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SetProcessClassActor*>(this)->actor_wait_state > 0) static_cast<SetProcessClassActor*>(this)->actor_wait_state = 0;
		static_cast<SetProcessClassActor*>(this)->ActorCallback< SetProcessClassActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SetProcessClassActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SetProcessClassActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	KeyRef network_address;
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	KeyRef class_type;
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 80 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	ThreadFuture<Optional<Value>> result;
															#line 91 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Error err;
															#line 1049 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
};
// This generated class is to be used only via setProcessClass()
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class SetProcessClassActor final : public Actor<bool>, public ActorCallback< SetProcessClassActor, 0, Optional<Value> >, public ActorCallback< SetProcessClassActor, 1, Void >, public ActorCallback< SetProcessClassActor, 2, std::string >, public ActorCallback< SetProcessClassActor, 3, Void >, public FastAllocated<SetProcessClassActor>, public SetProcessClassActorState<SetProcessClassActor> {
															#line 1054 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
	using FastAllocated<SetProcessClassActor>::operator new;
	using FastAllocated<SetProcessClassActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12273595483580343040UL, 2707707653884271360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetProcessClassActor, 0, Optional<Value> >;
friend struct ActorCallback< SetProcessClassActor, 1, Void >;
friend struct ActorCallback< SetProcessClassActor, 2, std::string >;
friend struct ActorCallback< SetProcessClassActor, 3, Void >;
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	SetProcessClassActor(Reference<IDatabase> const& db,KeyRef const& network_address,KeyRef const& class_type) 
															#line 1074 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		 : Actor<bool>(),
		   SetProcessClassActorState<SetProcessClassActor>(db, network_address, class_type),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setProcessClass", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14323910828051983872UL, 12926326576667201024UL);
		ActorExecutionContextHelper __helper(static_cast<SetProcessClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setProcessClass");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setProcessClass", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetProcessClassActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetProcessClassActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetProcessClassActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SetProcessClassActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
[[nodiscard]] Future<bool> setProcessClass( Reference<IDatabase> const& db, KeyRef const& network_address, KeyRef const& class_type ) {
															#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	return Future<bool>(new SetProcessClassActor(db, network_address, class_type));
															#line 1109 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
}

#line 102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"

} // namespace

namespace fdb_cli {

const KeyRangeRef processClassSourceSpecialKeyRange =
    KeyRangeRef("\xff\xff/configuration/process/class_source/"_sr, "\xff\xff/configuration/process/class_source0"_sr);

const KeyRangeRef processClassTypeSpecialKeyRange =
    KeyRangeRef("\xff\xff/configuration/process/class_type/"_sr, "\xff\xff/configuration/process/class_type0"_sr);

															#line 1124 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
// This generated class is to be used only via setClassCommandActor()
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
template <class SetClassCommandActorActor>
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class SetClassCommandActorActorState {
															#line 1130 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	SetClassCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		 : db(db),
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		   tokens(tokens)
															#line 1139 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("setClassCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~SetClassCommandActorActorState() 
	{
		fdb_probe_actor_destroy("setClassCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
			if (tokens.size() != 3 && tokens.size() != 1)
															#line 1154 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
			{
															#line 115 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				if (!static_cast<SetClassCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetClassCommandActorActorState(); static_cast<SetClassCommandActorActor*>(this)->destroy(); return 0; }
															#line 1160 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
				new (&static_cast<SetClassCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~SetClassCommandActorActorState();
				static_cast<SetClassCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 117 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
				if (tokens.size() == 1)
															#line 1170 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
				{
															#line 118 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = printProcessClass(db);
															#line 118 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					if (static_cast<SetClassCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1176 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<SetClassCommandActorActor*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetClassCommandActorActor, 0, Void >*>(static_cast<SetClassCommandActorActor*>(this)));
															#line 1181 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					StrictFuture<bool> __when_expr_1 = setProcessClass(db, tokens[1], tokens[2]);
															#line 120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					if (static_cast<SetClassCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1190 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<SetClassCommandActorActor*>(this)->actor_wait_state = 2;
															#line 120 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetClassCommandActorActor, 1, bool >*>(static_cast<SetClassCommandActorActor*>(this)));
															#line 1195 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetClassCommandActorActorState();
		static_cast<SetClassCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetClassCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SetClassCommandActorActorState(); static_cast<SetClassCommandActorActor*>(this)->destroy(); return 0; }
															#line 1220 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetClassCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SetClassCommandActorActorState();
		static_cast<SetClassCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetClassCommandActorActor*>(this)->actor_wait_state > 0) static_cast<SetClassCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<SetClassCommandActorActor*>(this)->ActorCallback< SetClassCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetClassCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetClassCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetClassCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(bool const& successful,int loopDepth) 
	{
															#line 121 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetClassCommandActorActor*>(this)->SAV<bool>::futures) { (void)(successful); this->~SetClassCommandActorActorState(); static_cast<SetClassCommandActorActor*>(this)->destroy(); return 0; }
															#line 1325 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetClassCommandActorActor*>(this)->SAV< bool >::value()) bool(successful);
		this->~SetClassCommandActorActorState();
		static_cast<SetClassCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(bool && successful,int loopDepth) 
	{
															#line 121 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
		if (!static_cast<SetClassCommandActorActor*>(this)->SAV<bool>::futures) { (void)(successful); this->~SetClassCommandActorActorState(); static_cast<SetClassCommandActorActor*>(this)->destroy(); return 0; }
															#line 1337 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		new (&static_cast<SetClassCommandActorActor*>(this)->SAV< bool >::value()) bool(successful);
		this->~SetClassCommandActorActorState();
		static_cast<SetClassCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(bool const& successful,int loopDepth) 
	{
		loopDepth = a_body1cont5(successful, loopDepth);

		return loopDepth;
	}
	int a_body1when2(bool && successful,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(successful), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetClassCommandActorActor*>(this)->actor_wait_state > 0) static_cast<SetClassCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<SetClassCommandActorActor*>(this)->ActorCallback< SetClassCommandActorActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SetClassCommandActorActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetClassCommandActorActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetClassCommandActorActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 1424 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
};
// This generated class is to be used only via setClassCommandActor()
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
class SetClassCommandActorActor final : public Actor<bool>, public ActorCallback< SetClassCommandActorActor, 0, Void >, public ActorCallback< SetClassCommandActorActor, 1, bool >, public FastAllocated<SetClassCommandActorActor>, public SetClassCommandActorActorState<SetClassCommandActorActor> {
															#line 1429 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
public:
	using FastAllocated<SetClassCommandActorActor>::operator new;
	using FastAllocated<SetClassCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2408328256756630528UL, 6308065049552897536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetClassCommandActorActor, 0, Void >;
friend struct ActorCallback< SetClassCommandActorActor, 1, bool >;
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	SetClassCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1447 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
		 : Actor<bool>(),
		   SetClassCommandActorActorState<SetClassCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setClassCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9882290383185673728UL, 9542062840330754304UL);
		ActorExecutionContextHelper __helper(static_cast<SetClassCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setClassCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setClassCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetClassCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetClassCommandActorActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
[[nodiscard]] Future<bool> setClassCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 113 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"
	return Future<bool>(new SetClassCommandActorActor(db, tokens));
															#line 1480 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/SetClassCommand.actor.g.cpp"
}

#line 125 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/SetClassCommand.actor.cpp"

CommandFactory setClassFactory(
    "setclass",
    CommandHelp("setclass [<ADDRESS> <CLASS>]",
                "change the class of a process",
                "If no address and class are specified, lists the classes of all servers.\n\nSetting the class to "
                "`default' resets the process class to the class specified on the command line. The available "
                "classes are `unset', `storage', `transaction', `resolution', `commit_proxy', `grv_proxy', "
                "`master', `test', "
                "`stateless', `log', `router', `cluster_controller', `fast_restore', `data_distributor', "
                "`coordinator', `ratekeeper', `backup', and `default'."));

} // namespace fdb_cli
