#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
/*
 * LockCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 37 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
// This generated class is to be used only via lockDatabase()
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
template <class LockDatabaseActor>
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class LockDatabaseActorState {
															#line 43 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	LockDatabaseActorState(Reference<IDatabase> const& db,UID const& id) 
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		 : db(db),
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		   id(id),
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 54 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("lockDatabase", reinterpret_cast<unsigned long>(this));

	}
	~LockDatabaseActorState() 
	{
		fdb_probe_actor_destroy("lockDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			;
															#line 69 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockDatabaseActorState();
		static_cast<LockDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 38 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 99 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		try {
															#line 40 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			tr->set(fdb_cli::lockSpecialKey, id.toString());
															#line 41 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 41 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (static_cast<LockDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockDatabaseActor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockDatabaseActor, 0, Void >*>(static_cast<LockDatabaseActor*>(this)));
															#line 112 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			err = Error(e);
															#line 46 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (e.code() == error_code_database_locked)
															#line 136 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			{
															#line 47 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 140 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			}
			else
			{
															#line 48 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				if (e.code() == error_code_special_keys_api_failure)
															#line 146 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				{
															#line 49 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
					StrictFuture<std::string> __when_expr_1 = fdb_cli::getSpecialKeysFailureErrorMessage(tr);
															#line 49 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
					if (static_cast<LockDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 152 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<LockDatabaseActor*>(this)->actor_wait_state = 2;
															#line 49 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockDatabaseActor, 1, std::string >*>(static_cast<LockDatabaseActor*>(this)));
															#line 157 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		printf("Database locked.\n");
															#line 43 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockDatabaseActor*>(this)->SAV<bool>::futures) { (void)(true); this->~LockDatabaseActorState(); static_cast<LockDatabaseActor*>(this)->destroy(); return 0; }
															#line 180 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockDatabaseActor*>(this)->SAV< bool >::value()) bool(true);
		this->~LockDatabaseActorState();
		static_cast<LockDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		printf("Database locked.\n");
															#line 43 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockDatabaseActor*>(this)->SAV<bool>::futures) { (void)(true); this->~LockDatabaseActorState(); static_cast<LockDatabaseActor*>(this)->destroy(); return 0; }
															#line 194 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockDatabaseActor*>(this)->SAV< bool >::value()) bool(true);
		this->~LockDatabaseActorState();
		static_cast<LockDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockDatabaseActor*>(this)->actor_wait_state > 0) static_cast<LockDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<LockDatabaseActor*>(this)->ActorCallback< LockDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(err));
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (static_cast<LockDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 283 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LockDatabaseActor*>(this)->actor_wait_state = 3;
															#line 53 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockDatabaseActor, 2, Void >*>(static_cast<LockDatabaseActor*>(this)));
															#line 288 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		fprintf(stderr, "%s\n", errorMsgStr.c_str());
															#line 51 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LockDatabaseActorState(); static_cast<LockDatabaseActor*>(this)->destroy(); return 0; }
															#line 305 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
		this->~LockDatabaseActorState();
		static_cast<LockDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(std::string && errorMsgStr,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		fprintf(stderr, "%s\n", errorMsgStr.c_str());
															#line 51 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LockDatabaseActorState(); static_cast<LockDatabaseActor*>(this)->destroy(); return 0; }
															#line 319 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
		this->~LockDatabaseActorState();
		static_cast<LockDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockDatabaseActor*>(this)->actor_wait_state > 0) static_cast<LockDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<LockDatabaseActor*>(this)->ActorCallback< LockDatabaseActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockDatabaseActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LockDatabaseActor*>(this)->actor_wait_state > 0) static_cast<LockDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<LockDatabaseActor*>(this)->ActorCallback< LockDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	UID id;
															#line 36 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 45 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Error err;
															#line 497 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
};
// This generated class is to be used only via lockDatabase()
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class LockDatabaseActor final : public Actor<bool>, public ActorCallback< LockDatabaseActor, 0, Void >, public ActorCallback< LockDatabaseActor, 1, std::string >, public ActorCallback< LockDatabaseActor, 2, Void >, public FastAllocated<LockDatabaseActor>, public LockDatabaseActorState<LockDatabaseActor> {
															#line 502 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
	using FastAllocated<LockDatabaseActor>::operator new;
	using FastAllocated<LockDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8922132126317585408UL, 6025476338200037376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockDatabaseActor, 0, Void >;
friend struct ActorCallback< LockDatabaseActor, 1, std::string >;
friend struct ActorCallback< LockDatabaseActor, 2, Void >;
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	LockDatabaseActor(Reference<IDatabase> const& db,UID const& id) 
															#line 521 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		 : Actor<bool>(),
		   LockDatabaseActorState<LockDatabaseActor>(db, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15971211100070603520UL, 4275338283381576192UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockDatabaseActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LockDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
[[nodiscard]] Future<bool> lockDatabase( Reference<IDatabase> const& db, UID const& id ) {
															#line 35 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	return Future<bool>(new LockDatabaseActor(db, id));
															#line 555 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
}

#line 57 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"

} // namespace

namespace fdb_cli {

const KeyRef lockSpecialKey = "\xff\xff/management/db_locked"_sr;

															#line 566 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
// This generated class is to be used only via lockCommandActor()
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
template <class LockCommandActorActor>
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class LockCommandActorActorState {
															#line 572 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	LockCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		 : db(db),
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		   tokens(tokens)
															#line 581 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("lockCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~LockCommandActorActorState() 
	{
		fdb_probe_actor_destroy("lockCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (tokens.size() != 1)
															#line 596 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			{
															#line 66 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 67 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				if (!static_cast<LockCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LockCommandActorActorState(); static_cast<LockCommandActorActor*>(this)->destroy(); return 0; }
															#line 602 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				new (&static_cast<LockCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~LockCommandActorActorState();
				static_cast<LockCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 69 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				lockUID = deterministicRandom()->randomUniqueID();
															#line 70 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				printf("Locking database with lockUID: %s\n", lockUID.toString().c_str());
															#line 71 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				StrictFuture<bool> __when_expr_0 = (lockDatabase(db, lockUID));
															#line 71 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				if (static_cast<LockCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 618 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LockCommandActorActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockCommandActorActor, 0, bool >*>(static_cast<LockCommandActorActor*>(this)));
															#line 623 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockCommandActorActorState();
		static_cast<LockCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& result,int loopDepth) 
	{
															#line 72 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~LockCommandActorActorState(); static_cast<LockCommandActorActor*>(this)->destroy(); return 0; }
															#line 647 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~LockCommandActorActorState();
		static_cast<LockCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && result,int loopDepth) 
	{
															#line 72 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<LockCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~LockCommandActorActorState(); static_cast<LockCommandActorActor*>(this)->destroy(); return 0; }
															#line 659 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<LockCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~LockCommandActorActorState();
		static_cast<LockCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LockCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockCommandActorActor*>(this)->ActorCallback< LockCommandActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< LockCommandActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockCommandActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockCommandActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 69 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	UID lockUID;
															#line 748 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
};
// This generated class is to be used only via lockCommandActor()
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class LockCommandActorActor final : public Actor<bool>, public ActorCallback< LockCommandActorActor, 0, bool >, public FastAllocated<LockCommandActorActor>, public LockCommandActorActorState<LockCommandActorActor> {
															#line 753 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
	using FastAllocated<LockCommandActorActor>::operator new;
	using FastAllocated<LockCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17482353541754519808UL, 1359145014444094976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockCommandActorActor, 0, bool >;
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	LockCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 770 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		 : Actor<bool>(),
		   LockCommandActorActorState<LockCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8167004015908528640UL, 12418797595303046656UL);
		ActorExecutionContextHelper __helper(static_cast<LockCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockCommandActorActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
[[nodiscard]] Future<bool> lockCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 64 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	return Future<bool>(new LockCommandActorActor(db, tokens));
															#line 802 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
}

#line 75 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"

															#line 807 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
// This generated class is to be used only via unlockDatabaseActor()
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
template <class UnlockDatabaseActorActor>
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class UnlockDatabaseActorActorState {
															#line 813 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	UnlockDatabaseActorActorState(Reference<IDatabase> const& db,UID const& uid) 
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		 : db(db),
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		   uid(uid),
															#line 77 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 824 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("unlockDatabaseActor", reinterpret_cast<unsigned long>(this));

	}
	~UnlockDatabaseActorActorState() 
	{
		fdb_probe_actor_destroy("unlockDatabaseActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			;
															#line 839 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnlockDatabaseActorActorState();
		static_cast<UnlockDatabaseActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 869 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		try {
															#line 81 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			valF = tr->get(fdb_cli::lockSpecialKey);
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(valF);
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 877 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >*>(static_cast<UnlockDatabaseActorActor*>(this)));
															#line 882 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			err = Error(e);
															#line 98 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 906 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			{
															#line 99 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				StrictFuture<std::string> __when_expr_2 = fdb_cli::getSpecialKeysFailureErrorMessage(tr);
															#line 99 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 912 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 3;
															#line 99 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseActorActor, 2, std::string >*>(static_cast<UnlockDatabaseActorActor*>(this)));
															#line 917 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 84 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!val.present())
															#line 937 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 941 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~UnlockDatabaseActorActorState();
			static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (val.present() && UID::fromString(val.get().toString()) != uid)
															#line 949 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			printf("Unable to unlock database. Make sure to unlock with the correct lock UID.\n");
															#line 89 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 955 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~UnlockDatabaseActorActorState();
			static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		tr->clear(fdb_cli::lockSpecialKey);
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 967 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 2;
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseActorActor, 1, Void >*>(static_cast<UnlockDatabaseActorActor*>(this)));
															#line 972 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 84 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!val.present())
															#line 981 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 985 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~UnlockDatabaseActorActorState();
			static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 87 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (val.present() && UID::fromString(val.get().toString()) != uid)
															#line 993 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			printf("Unable to unlock database. Make sure to unlock with the correct lock UID.\n");
															#line 89 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
			if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 999 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
			new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~UnlockDatabaseActorActorState();
			static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		tr->clear(fdb_cli::lockSpecialKey);
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1011 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 2;
															#line 93 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseActorActor, 1, Void >*>(static_cast<UnlockDatabaseActorActor*>(this)));
															#line 1016 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseActorActor*>(this)->ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		printf("Database unlocked.\n");
															#line 95 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 1102 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~UnlockDatabaseActorActorState();
		static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		printf("Database unlocked.\n");
															#line 95 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 1116 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~UnlockDatabaseActorActorState();
		static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseActorActor*>(this)->ActorCallback< UnlockDatabaseActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(err));
															#line 103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1205 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseActorActor, 3, Void >*>(static_cast<UnlockDatabaseActorActor*>(this)));
															#line 1210 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 100 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		fprintf(stderr, "%s\n", errorMsgStr.c_str());
															#line 101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 1221 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(false);
		this->~UnlockDatabaseActorActorState();
		static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 100 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		fprintf(stderr, "%s\n", errorMsgStr.c_str());
															#line 101 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
		if (!static_cast<UnlockDatabaseActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~UnlockDatabaseActorActorState(); static_cast<UnlockDatabaseActorActor*>(this)->destroy(); return 0; }
															#line 1235 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		new (&static_cast<UnlockDatabaseActorActor*>(this)->SAV< bool >::value()) bool(false);
		this->~UnlockDatabaseActorActorState();
		static_cast<UnlockDatabaseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseActorActor*>(this)->ActorCallback< UnlockDatabaseActorActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseActorActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseActorActor*>(this)->ActorCallback< UnlockDatabaseActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	UID uid;
															#line 77 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 81 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	ThreadFuture<Optional<Value>> valF;
															#line 97 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	Error err;
															#line 1415 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
};
// This generated class is to be used only via unlockDatabaseActor()
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
class UnlockDatabaseActorActor final : public Actor<bool>, public ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >, public ActorCallback< UnlockDatabaseActorActor, 1, Void >, public ActorCallback< UnlockDatabaseActorActor, 2, std::string >, public ActorCallback< UnlockDatabaseActorActor, 3, Void >, public FastAllocated<UnlockDatabaseActorActor>, public UnlockDatabaseActorActorState<UnlockDatabaseActorActor> {
															#line 1420 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
public:
	using FastAllocated<UnlockDatabaseActorActor>::operator new;
	using FastAllocated<UnlockDatabaseActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1048454446928252416UL, 13841320212294673408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >;
friend struct ActorCallback< UnlockDatabaseActorActor, 1, Void >;
friend struct ActorCallback< UnlockDatabaseActorActor, 2, std::string >;
friend struct ActorCallback< UnlockDatabaseActorActor, 3, Void >;
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	UnlockDatabaseActorActor(Reference<IDatabase> const& db,UID const& uid) 
															#line 1440 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
		 : Actor<bool>(),
		   UnlockDatabaseActorActorState<UnlockDatabaseActorActor>(db, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9318477942313864704UL, 11276519394868406528UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unlockDatabaseActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unlockDatabaseActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnlockDatabaseActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnlockDatabaseActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UnlockDatabaseActorActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UnlockDatabaseActorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
[[nodiscard]] Future<bool> unlockDatabaseActor( Reference<IDatabase> const& db, UID const& uid ) {
															#line 76 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"
	return Future<bool>(new UnlockDatabaseActorActor(db, uid));
															#line 1475 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/build_output/fdbcli/LockCommand.actor.g.cpp"
}

#line 107 "/codebuild/output/src2725962233/src/github.com/apple/foundationdb/fdbcli/LockCommand.actor.cpp"

CommandFactory lockFactory(
    "lock",
    CommandHelp("lock",
                "lock the database with a randomly generated lockUID",
                "Randomly generates a lockUID, prints this lockUID, and then uses the lockUID to lock the database."));

CommandFactory unlockFactory(
    "unlock",
    CommandHelp("unlock <UID>",
                "unlock the database with the provided lockUID",
                "Unlocks the database with the provided lockUID. This is a potentially dangerous operation, so the "
                "user will be asked to enter a passphrase to confirm their intent."));
} // namespace fdb_cli
