#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
/*
 * UpdateTenantGroups.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_UPDATETENANTGROUPS_ACTOR_G_H)
#define METACLUSTER_UPDATETENANTGROUPS_ACTOR_G_H
#include "metacluster/UpdateTenantGroups.actor.g.h"
#elif !defined(METACLUSTER_UPDATETENANTGROUPS_ACTOR_H)
#define METACLUSTER_UPDATETENANTGROUPS_ACTOR_H

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbrpc/TenantName.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"

#include "metacluster/ConfigureCluster.h"
#include "metacluster/MetaclusterMetadata.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

// This provides internal Metacluster APIs that are not meant to be consumed outside the metacluster project
namespace metacluster::internal {

FDB_BOOLEAN_PARAM(GroupAlreadyExists);

template <class Transaction>
void managementClusterAddTenantToGroup(Transaction tr,
                                       MetaclusterTenantMapEntry tenantEntry,
                                       DataClusterMetadata* clusterMetadata,
                                       GroupAlreadyExists groupAlreadyExists,
                                       IgnoreCapacityLimit ignoreCapacityLimit = IgnoreCapacityLimit::False,
                                       IsRestoring isRestoring = IsRestoring::False) {
	if (tenantEntry.tenantGroup.present()) {
		if (tenantEntry.tenantGroup.get().startsWith("\xff"_sr)) {
			CODE_PROBE(true, "Invalid tenant group name");
			throw invalid_tenant_group_name();
		}

		if (!groupAlreadyExists) {
			metadata::management::tenantMetadata().tenantGroupMap.set(
			    tr, tenantEntry.tenantGroup.get(), MetaclusterTenantGroupEntry(tenantEntry.assignedCluster));
			metadata::management::clusterTenantGroupIndex().insert(
			    tr, Tuple::makeTuple(tenantEntry.assignedCluster, tenantEntry.tenantGroup.get()));
		}
		metadata::management::tenantMetadata().tenantGroupTenantIndex.insert(
		    tr, Tuple::makeTuple(tenantEntry.tenantGroup.get(), tenantEntry.tenantName, tenantEntry.id));
	}

	if (!groupAlreadyExists && !isRestoring) {
		ASSERT(ignoreCapacityLimit || clusterMetadata->entry.hasCapacity());

		DataClusterEntry updatedEntry = clusterMetadata->entry;
		++updatedEntry.allocated.numTenantGroups;

		updateClusterMetadata(
		    tr, tenantEntry.assignedCluster, *clusterMetadata, Optional<ClusterConnectionString>(), updatedEntry);

		clusterMetadata->entry = updatedEntry;
	}
}

															#line 87 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
// This generated class is to be used only via managementClusterRemoveTenantFromGroup()
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
template <class Transaction, class ManagementClusterRemoveTenantFromGroupActor>
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
class ManagementClusterRemoveTenantFromGroupActorState {
															#line 93 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
public:
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	ManagementClusterRemoveTenantFromGroupActorState(Transaction const& tr,MetaclusterTenantMapEntry const& tenantEntry,DataClusterMetadata* const& clusterMetadata) 
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		 : tr(tr),
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		   tenantEntry(tenantEntry),
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		   clusterMetadata(clusterMetadata),
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		   updateClusterCapacity(!tenantEntry.tenantGroup.present())
															#line 106 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
	{
		fdb_probe_actor_create("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this));

	}
	~ManagementClusterRemoveTenantFromGroupActorState() 
	{
		fdb_probe_actor_destroy("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			if (tenantEntry.tenantGroup.present())
															#line 121 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
			{
															#line 91 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
				metadata::management::tenantMetadata().tenantGroupTenantIndex.erase( tr, Tuple::makeTuple(tenantEntry.tenantGroup.get(), tenantEntry.tenantName, tenantEntry.id));
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
				StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_0 = metadata::management::tenantMetadata().tenantGroupTenantIndex.getRange( tr, Tuple::makeTuple(tenantEntry.tenantGroup.get()), Tuple::makeTuple(keyAfter(tenantEntry.tenantGroup.get())), 1);
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
				if (static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->actor_wait_state = 1;
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterRemoveTenantFromGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)));
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementClusterRemoveTenantFromGroupActorState();
		static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		if (updateClusterCapacity)
															#line 162 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		{
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			CODE_PROBE(true, "Remove tenant from group deleted group");
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			DataClusterEntry updatedEntry = clusterMetadata->entry;
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			--updatedEntry.allocated.numTenantGroups;
															#line 116 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			updateClusterMetadata( tr, tenantEntry.assignedCluster, *clusterMetadata, Optional<ClusterConnectionString>(), updatedEntry);
															#line 119 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			clusterMetadata->entry = updatedEntry;
															#line 174 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		}
															#line 122 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		if (!static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementClusterRemoveTenantFromGroupActorState(); static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->destroy(); return 0; }
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		new (&static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementClusterRemoveTenantFromGroupActorState();
		static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 101 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		if (result.results.size() == 0)
															#line 190 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		{
															#line 102 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			metadata::management::clusterTenantGroupIndex().erase( tr, Tuple::makeTuple(tenantEntry.assignedCluster, tenantEntry.tenantGroup.get()));
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			metadata::management::tenantMetadata().tenantGroupMap.erase(tr, tenantEntry.tenantGroup.get());
															#line 106 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
			updateClusterCapacity = true;
															#line 198 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType const& __result,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
		result = __result;
															#line 208 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->ActorCallback< ManagementClusterRemoveTenantFromGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterRemoveTenantFromGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementClusterRemoveTenantFromGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementClusterRemoveTenantFromGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	Transaction tr;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	DataClusterMetadata* clusterMetadata;
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	bool updateClusterCapacity;
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	KeyBackedSet<Tuple>::RangeResultType result;
															#line 293 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
};
// This generated class is to be used only via managementClusterRemoveTenantFromGroup()
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
template <class Transaction>
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
class ManagementClusterRemoveTenantFromGroupActor final : public Actor<Void>, public ActorCallback< ManagementClusterRemoveTenantFromGroupActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >, public FastAllocated<ManagementClusterRemoveTenantFromGroupActor<Transaction>>, public ManagementClusterRemoveTenantFromGroupActorState<Transaction, ManagementClusterRemoveTenantFromGroupActor<Transaction>> {
															#line 300 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
public:
	using FastAllocated<ManagementClusterRemoveTenantFromGroupActor<Transaction>>::operator new;
	using FastAllocated<ManagementClusterRemoveTenantFromGroupActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1519841140845158656UL, 3068126839097941760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementClusterRemoveTenantFromGroupActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	ManagementClusterRemoveTenantFromGroupActor(Transaction const& tr,MetaclusterTenantMapEntry const& tenantEntry,DataClusterMetadata* const& clusterMetadata) 
															#line 317 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
		 : Actor<Void>(),
		   ManagementClusterRemoveTenantFromGroupActorState<Transaction, ManagementClusterRemoveTenantFromGroupActor<Transaction>>(tr, tenantEntry, clusterMetadata),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10088417456573728512UL, 18414517979002996992UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterRemoveTenantFromGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementClusterRemoveTenantFromGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementClusterRemoveTenantFromGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementClusterRemoveTenantFromGroupActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
template <class Transaction>
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
[[nodiscard]] Future<Void> managementClusterRemoveTenantFromGroup( Transaction const& tr, MetaclusterTenantMapEntry const& tenantEntry, DataClusterMetadata* const& clusterMetadata ) {
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"
	return Future<Void>(new ManagementClusterRemoveTenantFromGroupActor<Transaction>(tr, tenantEntry, clusterMetadata));
															#line 351 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/UpdateTenantGroups.actor.g.h"
}

#line 124 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/metacluster/include/metacluster/UpdateTenantGroups.actor.h"

} // namespace metacluster::internal

#include "flow/unactorcompiler.h"
#endif