#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
/*
 * ResolutionBalancer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/ResolutionBalancer.actor.h"

#include "fdbclient/KeyRangeMap.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/Knobs.h"
#include "flow/flow.h"

#include "flow/actorcompiler.h" // This must be the last #include.

void ResolutionBalancer::setResolvers(const std::vector<ResolverInterface>& v) {
	resolvers = v;
	if (resolvers.size() > 1)
		triggerResolution.trigger();
}

void ResolutionBalancer::setChangesInReply(UID requestingProxy, GetCommitVersionReply& rep) {
	if (resolverNeedingChanges.contains(requestingProxy)) {
		rep.resolverChanges = resolverChanges.get();
		rep.resolverChangesVersion = resolverChangesVersion;
		resolverNeedingChanges.erase(requestingProxy);

		CODE_PROBE(!rep.resolverChanges.empty(), "resolution balancing moves keyranges");
		if (resolverNeedingChanges.empty())
			resolverChanges.set(Standalone<VectorRef<ResolverMoveRef>>());
	}
}

static std::pair<KeyRangeRef, bool> findRange(CoalescedKeyRangeMap<int>& key_resolver,
                                              Standalone<VectorRef<ResolverMoveRef>>& movedRanges,
                                              int src,
                                              int dest) {
	auto ranges = key_resolver.ranges();
	auto prev = ranges.begin();
	auto it = ranges.begin();
	++it;
	if (it == ranges.end()) {
		if (ranges.begin().value() != src ||
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(ranges.begin()->range(), dest)) !=
		        movedRanges.end())
			throw operation_failed();
		return std::make_pair(ranges.begin().range(), true);
	}

	std::set<int> borders;
	// If possible expand an existing boundary between the two resolvers
	for (; it != ranges.end(); ++it) {
		if (it->value() == src && prev->value() == dest &&
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(it->range(), dest)) ==
		        movedRanges.end()) {
			return std::make_pair(it->range(), true);
		}
		if (it->value() == dest && prev->value() == src &&
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(prev->range(), dest)) ==
		        movedRanges.end()) {
			return std::make_pair(prev->range(), false);
		}
		if (it->value() == dest)
			borders.insert(prev->value());
		if (prev->value() == dest)
			borders.insert(it->value());
		++prev;
	}

	prev = ranges.begin();
	it = ranges.begin();
	++it;
	// If possible create a new boundary which doesn't exist yet
	for (; it != ranges.end(); ++it) {
		if (it->value() == src && !borders.contains(prev->value()) &&
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(it->range(), dest)) ==
		        movedRanges.end()) {
			return std::make_pair(it->range(), true);
		}
		if (prev->value() == src && !borders.contains(it->value()) &&
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(prev->range(), dest)) ==
		        movedRanges.end()) {
			return std::make_pair(prev->range(), false);
		}
		++prev;
	}

	it = ranges.begin();
	for (; it != ranges.end(); ++it) {
		if (it->value() == src &&
		    std::find(movedRanges.begin(), movedRanges.end(), ResolverMoveRef(it->range(), dest)) ==
		        movedRanges.end()) {
			return std::make_pair(it->range(), true);
		}
	}
	throw operation_failed(); // we are already attempting to move all of the data one resolver is assigned, so do not
	                          // move anything
}

// Balance key ranges among resolvers so that their load are evenly distributed.
															#line 117 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
// This generated class is to be used only via resolutionBalancing_impl()
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
template <class ResolutionBalancer_ResolutionBalancing_implActor>
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
class ResolutionBalancer_ResolutionBalancing_implActorState {
															#line 123 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
public:
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	ResolutionBalancer_ResolutionBalancing_implActorState(ResolutionBalancer* const& self) 
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		 : self(self)
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
	{
		fdb_probe_actor_create("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this));

	}
	~ResolutionBalancer_ResolutionBalancing_implActorState() 
	{
		fdb_probe_actor_destroy("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->triggerResolution.onTrigger();
															#line 116 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 1;
															#line 116 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >*>(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)));
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResolutionBalancer_ResolutionBalancing_implActorState();
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		key_resolver = CoalescedKeyRangeMap<int>(0, SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys.end : allKeys.end);
															#line 120 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		key_resolver.insert(SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys : allKeys, 0);
															#line 121 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		;
															#line 179 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		key_resolver = CoalescedKeyRangeMap<int>(0, SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys.end : allKeys.end);
															#line 120 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		key_resolver.insert(SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys : allKeys, 0);
															#line 121 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		;
															#line 192 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state > 0) static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 0;
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->MIN_BALANCE_TIME, TaskPriority::ResolutionMetrics);
															#line 122 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 285 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >*>(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)));
															#line 290 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		;
															#line 299 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		;
															#line 308 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state > 0) static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 0;
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		futures = std::vector<Future<ResolutionMetricsReply>>();
															#line 126 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		for( auto& p : self->resolvers ) {
															#line 127 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			futures.push_back( brokenPromiseToNever(p.metrics.getReply(ResolutionMetricsRequest(), TaskPriority::ResolutionMetrics)));
															#line 396 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		}
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(futures);
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 402 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >*>(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)));
															#line 407 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (!(self->resolverChanges.get().size()))
															#line 423 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 124 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->resolverChanges.onChange();
															#line 124 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 431 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >*>(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)));
															#line 436 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state > 0) static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 0;
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		metrics = IndexedSet<std::pair<int64_t, int>, NoMetric>();
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		int64_t total = 0;
															#line 133 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		for(int i = 0;i < futures.size();i++) {
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			total += futures[i].get().value;
															#line 135 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			metrics.insert(std::make_pair(futures[i].get().value, i), NoMetric());
															#line 553 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		}
															#line 138 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (metrics.lastItem()->first - metrics.begin()->first > SERVER_KNOBS->MIN_BALANCE_DIFFERENCE)
															#line 557 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		{
			try {
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				src = metrics.lastItem()->second;
															#line 141 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				dest = metrics.begin()->second;
															#line 142 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				amount = std::min(metrics.lastItem()->first - total / self->resolvers.size(), total / self->resolvers.size() - metrics.begin()->first) / 2;
															#line 145 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				movedRanges = Standalone<VectorRef<ResolverMoveRef>>();
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				;
															#line 570 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		metrics = IndexedSet<std::pair<int64_t, int>, NoMetric>();
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		int64_t total = 0;
															#line 133 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		for(int i = 0;i < futures.size();i++) {
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			total += futures[i].get().value;
															#line 135 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			metrics.insert(std::make_pair(futures[i].get().value, i), NoMetric());
															#line 598 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		}
															#line 138 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (metrics.lastItem()->first - metrics.begin()->first > SERVER_KNOBS->MIN_BALANCE_DIFFERENCE)
															#line 602 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		{
			try {
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				src = metrics.lastItem()->second;
															#line 141 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				dest = metrics.begin()->second;
															#line 142 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				amount = std::min(metrics.lastItem()->first - total / self->resolvers.size(), total / self->resolvers.size() - metrics.begin()->first) / 2;
															#line 145 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				movedRanges = Standalone<VectorRef<ResolverMoveRef>>();
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				;
															#line 615 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state > 0) static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 0;
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			if (e.code() != error_code_operation_failed)
															#line 723 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
			{
															#line 184 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 727 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
															#line 173 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		for( auto& it : movedRanges ) {
															#line 174 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			key_resolver.insert(it.range, it.dest);
															#line 745 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		}
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		self->resolverChangesVersion = *self->pVersion + 1;
															#line 179 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		for( auto& p : self->commitProxies ) {
															#line 180 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
			self->resolverNeedingChanges.insert(p.id());
															#line 753 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		}
															#line 181 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		self->resolverChanges.set(movedRanges);
															#line 757 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		range = findRange(key_resolver, movedRanges, src, dest);
															#line 150 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		ResolutionSplitRequest req;
															#line 151 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		req.front = range.second;
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		req.offset = amount;
															#line 153 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		req.range = range.first;
															#line 155 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		StrictFuture<ResolutionSplitReply> __when_expr_4 = brokenPromiseToNever(self->resolvers[metrics.lastItem()->second].split.getReply( req, TaskPriority::ResolutionMetrics));
															#line 155 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 785 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont3Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 5;
															#line 155 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >*>(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)));
															#line 790 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(ResolutionSplitReply const& split,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		KeyRangeRef moveRange = range.second ? KeyRangeRef(range.first.begin, split.key) : KeyRangeRef(split.key, range.first.end);
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		movedRanges.push_back_deep(movedRanges.arena(), ResolverMoveRef(moveRange, dest));
															#line 161 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		TraceEvent("MovingResolutionRange") .detail("Src", src) .detail("Dest", dest) .detail("Amount", amount) .detail("StartRange", range.first) .detail("MoveRange", moveRange) .detail("Used", split.used) .detail("KeyResolverRanges", key_resolver.size());
															#line 169 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		amount -= split.used;
															#line 170 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (moveRange != range.first || amount <= 0)
															#line 820 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(ResolutionSplitReply && split,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		KeyRangeRef moveRange = range.second ? KeyRangeRef(range.first.begin, split.key) : KeyRangeRef(split.key, range.first.end);
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		movedRanges.push_back_deep(movedRanges.arena(), ResolverMoveRef(moveRange, dest));
															#line 161 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		TraceEvent("MovingResolutionRange") .detail("Src", src) .detail("Dest", dest) .detail("Amount", amount) .detail("StartRange", range.first) .detail("MoveRange", moveRange) .detail("Used", split.used) .detail("KeyResolverRanges", key_resolver.size());
															#line 169 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		amount -= split.used;
															#line 170 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
		if (moveRange != range.first || amount <= 0)
															#line 840 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(ResolutionSplitReply const& split,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(split, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(ResolutionSplitReply && split,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(std::move(split), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state > 0) static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->actor_wait_state = 0;
		static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >::remove();

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >*,ResolutionSplitReply const& value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >*,ResolutionSplitReply && value) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >*,Error err) 
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	ResolutionBalancer* self;
															#line 118 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	CoalescedKeyRangeMap<int> key_resolver;
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	std::vector<Future<ResolutionMetricsReply>> futures;
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	IndexedSet<std::pair<int64_t, int>, NoMetric> metrics;
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	int src;
															#line 141 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	int dest;
															#line 142 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	int64_t amount;
															#line 145 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	Standalone<VectorRef<ResolverMoveRef>> movedRanges;
															#line 148 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	std::pair<KeyRangeRef, bool> range;
															#line 954 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
};
// This generated class is to be used only via resolutionBalancing_impl()
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
class ResolutionBalancer_ResolutionBalancing_implActor final : public Actor<Void>, public ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >, public ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >, public ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >, public ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >, public ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >, public FastAllocated<ResolutionBalancer_ResolutionBalancing_implActor>, public ResolutionBalancer_ResolutionBalancing_implActorState<ResolutionBalancer_ResolutionBalancing_implActor> {
															#line 959 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
public:
	using FastAllocated<ResolutionBalancer_ResolutionBalancing_implActor>::operator new;
	using FastAllocated<ResolutionBalancer_ResolutionBalancing_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5414721495336279808UL, 9209040505468950784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >;
friend struct ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >;
friend struct ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >;
friend struct ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >;
friend struct ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >;
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	ResolutionBalancer_ResolutionBalancing_implActor(ResolutionBalancer* const& self) 
															#line 980 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
		 : Actor<Void>(),
		   ResolutionBalancer_ResolutionBalancing_implActorState<ResolutionBalancer_ResolutionBalancing_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1472463922329140224UL, 4086448116718273536UL);
		ActorExecutionContextHelper __helper(static_cast<ResolutionBalancer_ResolutionBalancing_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resolutionBalancing_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resolutionBalancing_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ResolutionBalancer_ResolutionBalancing_implActor, 4, ResolutionSplitReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
[[nodiscard]] Future<Void> ResolutionBalancer::resolutionBalancing_impl( ResolutionBalancer* const& self ) {
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
	return Future<Void>(new ResolutionBalancer_ResolutionBalancing_implActor(self));
															#line 1016 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/ResolutionBalancer.actor.g.cpp"
}

#line 189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/ResolutionBalancer.actor.cpp"
