#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
/*
 * KeyValueStoreCompressTestData.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/IKeyValueStore.h"
#include "flow/actorcompiler.h" // has to be last include

// KeyValueStoreCompressTestData wraps an existing IKeyValueStore and
// implements the following rudimentary compression scheme:
//   An arbitrarily long value which consists entirely of a single repeated nonzero byte is mapped to
//     a 5-byte value consisting of that byte followed by a little-endian integer giving the number
//     of repetitions.
//   All other values are mapped to a zero byte followed by the value.
// This store is used in testing to let us simulate having much bigger disks than we actually
//   have, in order to test really big databases.

struct KeyValueStoreCompressTestData final : IKeyValueStore {
	IKeyValueStore* store;

	KeyValueStoreCompressTestData(IKeyValueStore* store) : store(store) {}

	Future<Void> getError() const override { return store->getError(); }
	Future<Void> onClosed() const override { return store->onClosed(); }
	void dispose() override {

		store->dispose();
		delete this;
	}
	void close() override {
		store->close();
		delete this;
	}

	KeyValueStoreType getType() const override { return store->getType(); }
	StorageBytes getStorageBytes() const override { return store->getStorageBytes(); }

	void set(KeyValueRef keyValue, const Arena* arena = nullptr) override {
		store->set(KeyValueRef(keyValue.key, pack(keyValue.value)), arena);
	}
	void clear(KeyRangeRef range, const Arena* arena = nullptr) override { store->clear(range, arena); }
	Future<Void> commit(bool sequential = false) override { return store->commit(sequential); }

	Future<Optional<Value>> readValue(KeyRef key, Optional<ReadOptions> options) override {
		return doReadValue(store, key, options);
	}

	// Note that readValuePrefix doesn't do anything in this implementation of IKeyValueStore, so the "atomic bomb"
	// problem is still present if you are using this storage interface, but this storage interface is not used by
	// customers ever. However, if you want to try to test malicious atomic op workloads with compressed values for some
	// reason, you will need to fix this.
	Future<Optional<Value>> readValuePrefix(KeyRef key, int maxLength, Optional<ReadOptions> options) override {
		return doReadValuePrefix(store, key, maxLength, options);
	}

	// If rowLimit>=0, reads first rows sorted ascending, otherwise reads last rows sorted descending
	// The total size of the returned value (less the last entry) will be less than byteLimit
	Future<RangeResult> readRange(KeyRangeRef keys,
	                              int rowLimit,
	                              int byteLimit,
	                              Optional<ReadOptions> options = Optional<ReadOptions>()) override {
		return doReadRange(store, keys, rowLimit, byteLimit, options);
	}

	Future<EncryptionAtRestMode> encryptionMode() override {
		return EncryptionAtRestMode(EncryptionAtRestMode::DISABLED);
	}

private:
																#line 87 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
// This generated class is to be used only via doReadValue()
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
template <class DoReadValueActor>
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadValueActorState {
															#line 93 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadValueActorState(IKeyValueStore* const& store,Key const& key,Optional<ReadOptions> const& options) 
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		 : store(store),
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   key(key),
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   options(options)
															#line 104 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
	{
		fdb_probe_actor_create("doReadValue", reinterpret_cast<unsigned long>(this));

	}
	~DoReadValueActorState() 
	{
		fdb_probe_actor_destroy("doReadValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = store->readValue(key, options);
															#line 86 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (static_cast<DoReadValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 121 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadValueActor*>(this)->actor_wait_state = 1;
															#line 86 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadValueActor, 0, Optional<Value> >*>(static_cast<DoReadValueActor*>(this)));
															#line 126 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadValueActorState();
		static_cast<DoReadValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!v.present())
															#line 149 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValueActorState(); static_cast<DoReadValueActor*>(this)->destroy(); return 0; }
															#line 153 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValueActorState();
			static_cast<DoReadValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!static_cast<DoReadValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(unpack(v.get())); this->~DoReadValueActorState(); static_cast<DoReadValueActor*>(this)->destroy(); return 0; }
															#line 161 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		new (&static_cast<DoReadValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(unpack(v.get()));
		this->~DoReadValueActorState();
		static_cast<DoReadValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!v.present())
															#line 173 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValueActorState(); static_cast<DoReadValueActor*>(this)->destroy(); return 0; }
															#line 177 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValueActorState();
			static_cast<DoReadValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!static_cast<DoReadValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(unpack(v.get())); this->~DoReadValueActorState(); static_cast<DoReadValueActor*>(this)->destroy(); return 0; }
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		new (&static_cast<DoReadValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(unpack(v.get()));
		this->~DoReadValueActorState();
		static_cast<DoReadValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadValueActor*>(this)->actor_wait_state > 0) static_cast<DoReadValueActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadValueActor*>(this)->ActorCallback< DoReadValueActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadValueActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("doReadValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadValueActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("doReadValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadValueActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	IKeyValueStore* store;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	Key key;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	Optional<ReadOptions> options;
															#line 274 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
};
// This generated class is to be used only via doReadValue()
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadValueActor final : public Actor<Optional<Value>>, public ActorCallback< DoReadValueActor, 0, Optional<Value> >, public FastAllocated<DoReadValueActor>, public DoReadValueActorState<DoReadValueActor> {
															#line 279 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
	using FastAllocated<DoReadValueActor>::operator new;
	using FastAllocated<DoReadValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6189650693929647104UL, 17311299371776281600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadValueActor, 0, Optional<Value> >;
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadValueActor(IKeyValueStore* const& store,Key const& key,Optional<ReadOptions> const& options) 
															#line 296 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   DoReadValueActorState<DoReadValueActor>(store, key, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13309269154743388416UL, 5397187216745040128UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadValueActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> doReadValue( IKeyValueStore* const& store, Key const& key, Optional<ReadOptions> const& options ) {
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	return Future<Optional<Value>>(new DoReadValueActor(store, key, options));
															#line 328 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
}

#line 91 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"

																#line 333 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
// This generated class is to be used only via doReadValuePrefix()
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
template <class DoReadValuePrefixActor>
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadValuePrefixActorState {
															#line 339 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadValuePrefixActorState(IKeyValueStore* const& store,Key const& key,int const& maxLength,Optional<ReadOptions> const& options) 
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		 : store(store),
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   key(key),
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   maxLength(maxLength),
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   options(options)
															#line 352 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
	{
		fdb_probe_actor_create("doReadValuePrefix", reinterpret_cast<unsigned long>(this));

	}
	~DoReadValuePrefixActorState() 
	{
		fdb_probe_actor_destroy("doReadValuePrefix", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = doReadValue(store, key, options);
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (static_cast<DoReadValuePrefixActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 369 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadValuePrefixActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >*>(static_cast<DoReadValuePrefixActor*>(this)));
															#line 374 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadValuePrefixActorState();
		static_cast<DoReadValuePrefixActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!v.present())
															#line 397 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 401 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (maxLength < v.get().size())
															#line 409 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v.get().substr(0, maxLength)); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 413 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v.get().substr(0, maxLength));
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 102 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 423 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!v.present())
															#line 436 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 440 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (maxLength < v.get().size())
															#line 448 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v.get().substr(0, maxLength)); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 452 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v.get().substr(0, maxLength));
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 102 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (!static_cast<DoReadValuePrefixActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~DoReadValuePrefixActorState(); static_cast<DoReadValuePrefixActor*>(this)->destroy(); return 0; }
															#line 462 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			new (&static_cast<DoReadValuePrefixActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
			this->~DoReadValuePrefixActorState();
			static_cast<DoReadValuePrefixActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadValuePrefixActor*>(this)->actor_wait_state > 0) static_cast<DoReadValuePrefixActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadValuePrefixActor*>(this)->ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValuePrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValuePrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValuePrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadValuePrefix", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	IKeyValueStore* store;
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	Key key;
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	int maxLength;
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	Optional<ReadOptions> options;
															#line 554 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
};
// This generated class is to be used only via doReadValuePrefix()
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadValuePrefixActor final : public Actor<Optional<Value>>, public ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >, public FastAllocated<DoReadValuePrefixActor>, public DoReadValuePrefixActorState<DoReadValuePrefixActor> {
															#line 559 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
	using FastAllocated<DoReadValuePrefixActor>::operator new;
	using FastAllocated<DoReadValuePrefixActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5073994636822516992UL, 7721844590355397632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >;
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadValuePrefixActor(IKeyValueStore* const& store,Key const& key,int const& maxLength,Optional<ReadOptions> const& options) 
															#line 576 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   DoReadValuePrefixActorState<DoReadValuePrefixActor>(store, key, maxLength, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadValuePrefix", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7468510137895111168UL, 12267975723335666176UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadValuePrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadValuePrefix");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadValuePrefix", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadValuePrefixActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> doReadValuePrefix( IKeyValueStore* const& store, Key const& key, int const& maxLength, Optional<ReadOptions> const& options ) {
															#line 92 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	return Future<Optional<Value>>(new DoReadValuePrefixActor(store, key, maxLength, options));
															#line 608 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
}

#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
																#line 612 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
// This generated class is to be used only via doReadRange()
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
template <class DoReadRangeActor>
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadRangeActorState {
															#line 618 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadRangeActorState(IKeyValueStore* const& store,KeyRangeRef const& keys,int const& rowLimit,int const& byteLimit,Optional<ReadOptions> const& options) 
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		 : store(store),
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   keys(keys),
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   rowLimit(rowLimit),
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   byteLimit(byteLimit),
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		   options(options)
															#line 633 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
	{
		fdb_probe_actor_create("doReadRange", reinterpret_cast<unsigned long>(this));

	}
	~DoReadRangeActorState() 
	{
		fdb_probe_actor_destroy("doReadRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = store->readRange(keys, rowLimit, byteLimit, options);
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			if (static_cast<DoReadRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 650 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadRangeActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadRangeActor, 0, RangeResult >*>(static_cast<DoReadRangeActor*>(this)));
															#line 655 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadRangeActorState();
		static_cast<DoReadRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& _vs,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		RangeResult vs = _vs;
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		Arena& a = vs.arena();
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		for(int i = 0;i < vs.size();i++) {
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			vs[i].value = ValueRef(a, (ValueRef const&)unpack(vs[i].value));
															#line 684 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		}
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!static_cast<DoReadRangeActor*>(this)->SAV<RangeResult>::futures) { (void)(vs); this->~DoReadRangeActorState(); static_cast<DoReadRangeActor*>(this)->destroy(); return 0; }
															#line 688 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		new (&static_cast<DoReadRangeActor*>(this)->SAV< RangeResult >::value()) RangeResult(vs);
		this->~DoReadRangeActorState();
		static_cast<DoReadRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && _vs,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		RangeResult vs = _vs;
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		Arena& a = vs.arena();
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		for(int i = 0;i < vs.size();i++) {
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
			vs[i].value = ValueRef(a, (ValueRef const&)unpack(vs[i].value));
															#line 706 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		}
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
		if (!static_cast<DoReadRangeActor*>(this)->SAV<RangeResult>::futures) { (void)(vs); this->~DoReadRangeActorState(); static_cast<DoReadRangeActor*>(this)->destroy(); return 0; }
															#line 710 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		new (&static_cast<DoReadRangeActor*>(this)->SAV< RangeResult >::value()) RangeResult(vs);
		this->~DoReadRangeActorState();
		static_cast<DoReadRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& _vs,int loopDepth) 
	{
		loopDepth = a_body1cont1(_vs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && _vs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_vs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadRangeActor*>(this)->actor_wait_state > 0) static_cast<DoReadRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadRangeActor*>(this)->ActorCallback< DoReadRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("doReadRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("doReadRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("doReadRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	IKeyValueStore* store;
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	KeyRangeRef keys;
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	int rowLimit;
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	int byteLimit;
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	Optional<ReadOptions> options;
															#line 803 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
};
// This generated class is to be used only via doReadRange()
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
class DoReadRangeActor final : public Actor<RangeResult>, public ActorCallback< DoReadRangeActor, 0, RangeResult >, public FastAllocated<DoReadRangeActor>, public DoReadRangeActorState<DoReadRangeActor> {
															#line 808 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
public:
	using FastAllocated<DoReadRangeActor>::operator new;
	using FastAllocated<DoReadRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3331702362071165952UL, 1134258067786343168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadRangeActor, 0, RangeResult >;
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	DoReadRangeActor(IKeyValueStore* const& store,KeyRangeRef const& keys,int const& rowLimit,int const& byteLimit,Optional<ReadOptions> const& options) 
															#line 825 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
		 : Actor<RangeResult>(),
		   DoReadRangeActorState<DoReadRangeActor>(store, keys, rowLimit, byteLimit, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9743107537264834816UL, 11146361642938670592UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
[[nodiscard]] Future<RangeResult> doReadRange( IKeyValueStore* const& store, KeyRangeRef const& keys, int const& rowLimit, int const& byteLimit, Optional<ReadOptions> const& options ) {
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"
	return Future<RangeResult>(new DoReadRangeActor(store, keys, rowLimit, byteLimit, options));
															#line 857 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreCompressTestData.actor.g.cpp"
}

#line 117 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreCompressTestData.actor.cpp"

	// These implement the actual "compression" scheme
	static Value pack(Value val) {
		if (!val.size())
			return val;
		uint8_t c = val[0];

		// If the value starts with a 0-byte, then we don't compress it
		if (c == 0)
			return val.withPrefix("\x00"_sr);

		for (int i = 1; i < val.size(); i++) {
			if (val[i] != c) {
				// The value is something other than a single repeated character, so not compressible :-)
				return val.withPrefix("\x00"_sr);
			}
		}

		int n = val.size();
		val = makeString(5);
		uint8_t* p = mutateString(val);
		p[0] = c;
		*(int*)(p + 1) = n;
		return val;
	}
	static Value unpack(Value val) {
		if (!val.size())
			return val;
		if (val[0] == 0)
			return val.substr(1); // Uncompressed value
		ASSERT(val.size() == 5);
		uint8_t c = val[0];
		int n = *(int*)(val.begin() + 1);
		val = makeString(n);
		uint8_t* p = mutateString(val);
		memset(p, c, n);
		return val;
	}
};

IKeyValueStore* keyValueStoreCompressTestData(IKeyValueStore* store) {
	return new KeyValueStoreCompressTestData(store);
}
