#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
/*
 * BlobConnectionProviderTest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BlobConnectionProvider.h"

#include "flow/UnitTest.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h" // has to be last include

void forceLinkBlobConnectionProviderTests() {}

struct ConnectionProviderTestSettings {
	uint32_t numProviders;
	uint32_t filesPerProvider;
	uint32_t maxFileMemory;
	uint32_t maxFileSize;
	uint32_t threads;

	bool uniformProviderChoice;
	double readWriteSplit;

	double runtime;

	int writeOps;
	int readOps;
	uint32_t targetBytesPerSec;

	ConnectionProviderTestSettings() {
		numProviders = deterministicRandom()->randomSkewedUInt32(1, 1000);
		filesPerProvider =
		    1 + std::min((uint32_t)100, deterministicRandom()->randomSkewedUInt32(10, 10000) / numProviders);
		maxFileMemory = 1024 * 1024 * 1024;
		maxFileSize = maxFileMemory / (numProviders * filesPerProvider);
		maxFileSize = deterministicRandom()->randomSkewedUInt32(8, std::min((uint32_t)(16 * 1024 * 1024), maxFileSize));
		threads = deterministicRandom()->randomInt(16, 128);

		uniformProviderChoice = deterministicRandom()->coinflip();
		readWriteSplit = deterministicRandom()->randomInt(1, 10) / 10.0;

		runtime = 60.0;

		writeOps = 0;
		readOps = 0;

		targetBytesPerSec = 100 * 1024 * 1024;
	}
};

struct ProviderTestData {
	Reference<BlobConnectionProvider> provider;
	std::vector<std::pair<std::string, Value>> data;
	std::unordered_set<std::string> usedNames;

	ProviderTestData() {}
	explicit ProviderTestData(Reference<BlobConnectionProvider> provider) : provider(provider) {}
};

															#line 77 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
namespace {
// This generated class is to be used only via createObject()
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
template <class CreateObjectActor>
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class CreateObjectActorState {
															#line 84 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	CreateObjectActorState(ConnectionProviderTestSettings* const& settings,ProviderTestData* const& provider) 
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		 : settings(settings),
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   provider(provider)
															#line 93 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
	{
		fdb_probe_actor_create("createObject", reinterpret_cast<unsigned long>(this));

	}
	~CreateObjectActorState() 
	{
		fdb_probe_actor_destroy("createObject", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			std::string objName;
															#line 78 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			for(;;) {
															#line 79 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				objName = deterministicRandom()->randomAlphaNumeric(12);
															#line 80 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				if (provider->usedNames.insert(objName).second)
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				{
					break;
				}
			}
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			int randomDataSize = deterministicRandom()->randomInt(1, settings->maxFileSize);
															#line 86 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			data = makeString(randomDataSize);
															#line 87 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			deterministicRandom()->randomBytes(mutateString(data), randomDataSize);
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			bstore = Reference<BackupContainerFileSystem>();
															#line 90 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			fullPath = std::string();
															#line 91 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			std::tie(bstore, fullPath) = provider->provider->createForWrite(objName);
															#line 93 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 133 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			{
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				StrictFuture<Reference<IBackupFile>> __when_expr_0 = bstore->writeFile(fullPath);
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				if (static_cast<CreateObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CreateObjectActor*>(this)->actor_wait_state = 1;
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >*>(static_cast<CreateObjectActor*>(this)));
															#line 144 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 98 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				std::string contents = data.toString();
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				StrictFuture<Void> __when_expr_3 = bstore->writeEntireFile(fullPath, contents);
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				if (static_cast<CreateObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 155 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
				static_cast<CreateObjectActor*>(this)->actor_wait_state = 4;
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateObjectActor, 3, Void >*>(static_cast<CreateObjectActor*>(this)));
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateObjectActorState();
		static_cast<CreateObjectActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		provider->data.push_back({ fullPath, data });
															#line 105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<CreateObjectActor*>(this)->SAV<int64_t>::futures) { (void)(data.size()); this->~CreateObjectActorState(); static_cast<CreateObjectActor*>(this)->destroy(); return 0; }
															#line 186 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<CreateObjectActor*>(this)->SAV< int64_t >::value()) int64_t(data.size());
		this->~CreateObjectActorState();
		static_cast<CreateObjectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 95 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->append(data.begin(), data.size());
															#line 95 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 200 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateObjectActor*>(this)->actor_wait_state = 2;
															#line 95 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateObjectActor, 1, Void >*>(static_cast<CreateObjectActor*>(this)));
															#line 205 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __file,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		file = __file;
															#line 214 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state > 0) static_cast<CreateObjectActor*>(this)->actor_wait_state = 0;
		static_cast<CreateObjectActor*>(this)->ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->finish();
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 295 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateObjectActor*>(this)->actor_wait_state = 3;
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateObjectActor, 2, Void >*>(static_cast<CreateObjectActor*>(this)));
															#line 300 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->finish();
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 311 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateObjectActor*>(this)->actor_wait_state = 3;
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateObjectActor, 2, Void >*>(static_cast<CreateObjectActor*>(this)));
															#line 316 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state > 0) static_cast<CreateObjectActor*>(this)->actor_wait_state = 0;
		static_cast<CreateObjectActor*>(this)->ActorCallback< CreateObjectActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateObjectActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state > 0) static_cast<CreateObjectActor*>(this)->actor_wait_state = 0;
		static_cast<CreateObjectActor*>(this)->ActorCallback< CreateObjectActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateObjectActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateObjectActor*>(this)->actor_wait_state > 0) static_cast<CreateObjectActor*>(this)->actor_wait_state = 0;
		static_cast<CreateObjectActor*>(this)->ActorCallback< CreateObjectActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateObjectActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateObjectActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ConnectionProviderTestSettings* settings;
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ProviderTestData* provider;
															#line 86 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Value data;
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Reference<BackupContainerFileSystem> bstore;
															#line 90 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	std::string fullPath;
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Reference<IBackupFile> file;
															#line 582 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
};
// This generated class is to be used only via createObject()
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class CreateObjectActor final : public Actor<int64_t>, public ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >, public ActorCallback< CreateObjectActor, 1, Void >, public ActorCallback< CreateObjectActor, 2, Void >, public ActorCallback< CreateObjectActor, 3, Void >, public FastAllocated<CreateObjectActor>, public CreateObjectActorState<CreateObjectActor> {
															#line 587 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
	using FastAllocated<CreateObjectActor>::operator new;
	using FastAllocated<CreateObjectActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2386493484353384960UL, 17343823004274091520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< CreateObjectActor, 1, Void >;
friend struct ActorCallback< CreateObjectActor, 2, Void >;
friend struct ActorCallback< CreateObjectActor, 3, Void >;
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	CreateObjectActor(ConnectionProviderTestSettings* const& settings,ProviderTestData* const& provider) 
															#line 607 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		 : Actor<int64_t>(),
		   CreateObjectActorState<CreateObjectActor>(settings, provider),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createObject", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15288755177741009152UL, 14373168278133194496UL);
		ActorExecutionContextHelper __helper(static_cast<CreateObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createObject");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createObject", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateObjectActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateObjectActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateObjectActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateObjectActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
[[nodiscard]] Future<int64_t> createObject( ConnectionProviderTestSettings* const& settings, ProviderTestData* const& provider ) {
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	return Future<int64_t>(new CreateObjectActor(settings, provider));
															#line 643 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
}

#line 107 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"

															#line 648 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
namespace {
// This generated class is to be used only via readAndVerifyObject()
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
template <class ReadAndVerifyObjectActor>
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class ReadAndVerifyObjectActorState {
															#line 655 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ReadAndVerifyObjectActorState(ProviderTestData* const& provider,std::string const& objFullPath,Value const& expectedData) 
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		 : provider(provider),
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   objFullPath(objFullPath),
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   expectedData(expectedData)
															#line 666 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
	{
		fdb_probe_actor_create("readAndVerifyObject", reinterpret_cast<unsigned long>(this));

	}
	~ReadAndVerifyObjectActorState() 
	{
		fdb_probe_actor_destroy("readAndVerifyObject", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			Reference<BackupContainerFileSystem> bstore = provider->provider->getForRead(objFullPath);
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bstore->readFile(objFullPath);
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 685 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadAndVerifyObjectActor*>(this)));
															#line 690 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadAndVerifyObjectActorState();
		static_cast<ReadAndVerifyObjectActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		actualData = makeString(expectedData.size());
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<int> __when_expr_1 = reader->read(mutateString(actualData), expectedData.size(), 0);
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 717 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyObjectActor, 1, int >*>(static_cast<ReadAndVerifyObjectActor*>(this)));
															#line 722 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __reader,int loopDepth) 
	{
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		reader = __reader;
															#line 731 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __reader,int loopDepth) 
	{
		reader = std::move(__reader);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyObjectActor*>(this)->ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int const& readSize,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		ASSERT_EQ(expectedData.size(), readSize);
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		ASSERT(expectedData == actualData);
															#line 117 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<ReadAndVerifyObjectActor*>(this)->SAV<int64_t>::futures) { (void)(expectedData.size()); this->~ReadAndVerifyObjectActorState(); static_cast<ReadAndVerifyObjectActor*>(this)->destroy(); return 0; }
															#line 814 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<ReadAndVerifyObjectActor*>(this)->SAV< int64_t >::value()) int64_t(expectedData.size());
		this->~ReadAndVerifyObjectActorState();
		static_cast<ReadAndVerifyObjectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && readSize,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		ASSERT_EQ(expectedData.size(), readSize);
															#line 115 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		ASSERT(expectedData == actualData);
															#line 117 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<ReadAndVerifyObjectActor*>(this)->SAV<int64_t>::futures) { (void)(expectedData.size()); this->~ReadAndVerifyObjectActorState(); static_cast<ReadAndVerifyObjectActor*>(this)->destroy(); return 0; }
															#line 830 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<ReadAndVerifyObjectActor*>(this)->SAV< int64_t >::value()) int64_t(expectedData.size());
		this->~ReadAndVerifyObjectActorState();
		static_cast<ReadAndVerifyObjectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& readSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(readSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && readSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(readSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyObjectActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyObjectActor*>(this)->ActorCallback< ReadAndVerifyObjectActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyObjectActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyObjectActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyObjectActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ProviderTestData* provider;
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	std::string objFullPath;
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Value expectedData;
															#line 110 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Reference<IAsyncFile> reader;
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Value actualData;
															#line 923 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
};
// This generated class is to be used only via readAndVerifyObject()
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class ReadAndVerifyObjectActor final : public Actor<int64_t>, public ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadAndVerifyObjectActor, 1, int >, public FastAllocated<ReadAndVerifyObjectActor>, public ReadAndVerifyObjectActorState<ReadAndVerifyObjectActor> {
															#line 928 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
	using FastAllocated<ReadAndVerifyObjectActor>::operator new;
	using FastAllocated<ReadAndVerifyObjectActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5008001857117779200UL, 2399019628459295744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadAndVerifyObjectActor, 1, int >;
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ReadAndVerifyObjectActor(ProviderTestData* const& provider,std::string const& objFullPath,Value const& expectedData) 
															#line 946 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		 : Actor<int64_t>(),
		   ReadAndVerifyObjectActorState<ReadAndVerifyObjectActor>(provider, objFullPath, expectedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readAndVerifyObject", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5730265235926779392UL, 14251521157628487168UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyObjectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readAndVerifyObject");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readAndVerifyObject", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadAndVerifyObjectActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadAndVerifyObjectActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
[[nodiscard]] Future<int64_t> readAndVerifyObject( ProviderTestData* const& provider, std::string const& objFullPath, Value const& expectedData ) {
															#line 108 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	return Future<int64_t>(new ReadAndVerifyObjectActor(provider, objFullPath, expectedData));
															#line 980 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
}

#line 119 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"

Future<Void> deleteObject(ProviderTestData* provider, std::string objFullPath) {
	Reference<BackupContainerFileSystem> bstore = provider->provider->getForRead(objFullPath);
	return bstore->deleteFile(objFullPath);
}

															#line 990 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
namespace {
// This generated class is to be used only via workerThread()
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
template <class WorkerThreadActor>
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class WorkerThreadActorState {
															#line 997 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	WorkerThreadActorState(ConnectionProviderTestSettings* const& settings,std::vector<ProviderTestData>* const& providers) 
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		 : settings(settings),
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   providers(providers),
															#line 128 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   targetBytesPerSec(std::max((uint32_t)1, settings->targetBytesPerSec / settings->threads / 2)),
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   rateLimiter(Reference<IRateControl>(new SpeedLimit(targetBytesPerSec, 1))),
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   endTime(now() + settings->runtime)
															#line 1012 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
	{
		fdb_probe_actor_create("workerThread", reinterpret_cast<unsigned long>(this));

	}
	~WorkerThreadActorState() 
	{
		fdb_probe_actor_destroy("workerThread", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				;
															#line 1028 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerThreadActorState();
		static_cast<WorkerThreadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			fmt::print("WorkerThread Unexpected Error {0}\n", e.name());
															#line 167 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1060 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 164 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<WorkerThreadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerThreadActorState(); static_cast<WorkerThreadActor*>(this)->destroy(); return 0; }
															#line 1074 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<WorkerThreadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerThreadActorState();
		static_cast<WorkerThreadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!(now() < endTime))
															#line 1093 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		int providerIdx;
															#line 135 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (settings->uniformProviderChoice)
															#line 1101 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		{
															#line 136 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			providerIdx = deterministicRandom()->randomInt(0, providers->size());
															#line 1105 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		}
		else
		{
															#line 138 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			providerIdx = deterministicRandom()->randomSkewedUInt32(0, providers->size());
															#line 1111 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		}
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		ProviderTestData* provider = &(*providers)[providerIdx];
															#line 143 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		bool doWrite = deterministicRandom()->random01() < settings->readWriteSplit;
															#line 144 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		opSize = 0;
															#line 145 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (provider->usedNames.size() < settings->filesPerProvider && (provider->data.empty() || doWrite))
															#line 1121 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(opSize, createObject(settings, provider));
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (static_cast<WorkerThreadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1127 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerThreadActor*>(this)->actor_wait_state = 1;
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerThreadActor, 0, Void >*>(static_cast<WorkerThreadActor*>(this)));
															#line 1132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 149 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (!provider->data.empty())
															#line 1139 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			{
															#line 151 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				auto& readInfo = provider->data[deterministicRandom()->randomInt(0, provider->data.size())];
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				StrictFuture<Void> __when_expr_1 = store(opSize, readAndVerifyObject(provider, readInfo.first, readInfo.second));
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				if (static_cast<WorkerThreadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WorkerThreadActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerThreadActor, 1, Void >*>(static_cast<WorkerThreadActor*>(this)));
															#line 1152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				if (static_cast<WorkerThreadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1161 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<WorkerThreadActor*>(this)->actor_wait_state = 3;
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerThreadActor, 2, Void >*>(static_cast<WorkerThreadActor*>(this)));
															#line 1166 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 159 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (opSize > 0 && deterministicRandom()->coinflip())
															#line 1190 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		{
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(opSize) && delayJittered(0.01);
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (static_cast<WorkerThreadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1196 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WorkerThreadActor*>(this)->actor_wait_state = 4;
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkerThreadActor, 3, Void >*>(static_cast<WorkerThreadActor*>(this)));
															#line 1201 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		settings->writeOps++;
															#line 1215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		settings->writeOps++;
															#line 1224 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerThreadActor*>(this)->actor_wait_state > 0) static_cast<WorkerThreadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerThreadActor*>(this)->ActorCallback< WorkerThreadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerThreadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		settings->readOps++;
															#line 1314 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		settings->readOps++;
															#line 1323 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerThreadActor*>(this)->actor_wait_state > 0) static_cast<WorkerThreadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerThreadActor*>(this)->ActorCallback< WorkerThreadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerThreadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerThreadActor*>(this)->actor_wait_state > 0) static_cast<WorkerThreadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerThreadActor*>(this)->ActorCallback< WorkerThreadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerThreadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerThreadActor*>(this)->actor_wait_state > 0) static_cast<WorkerThreadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerThreadActor*>(this)->ActorCallback< WorkerThreadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkerThreadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkerThreadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ConnectionProviderTestSettings* settings;
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	std::vector<ProviderTestData>* providers;
															#line 128 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	int targetBytesPerSec;
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	double endTime;
															#line 144 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	int64_t opSize;
															#line 1595 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
};
// This generated class is to be used only via workerThread()
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class WorkerThreadActor final : public Actor<Void>, public ActorCallback< WorkerThreadActor, 0, Void >, public ActorCallback< WorkerThreadActor, 1, Void >, public ActorCallback< WorkerThreadActor, 2, Void >, public ActorCallback< WorkerThreadActor, 3, Void >, public FastAllocated<WorkerThreadActor>, public WorkerThreadActorState<WorkerThreadActor> {
															#line 1600 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
	using FastAllocated<WorkerThreadActor>::operator new;
	using FastAllocated<WorkerThreadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(271294228363177472UL, 15880259782962624512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerThreadActor, 0, Void >;
friend struct ActorCallback< WorkerThreadActor, 1, Void >;
friend struct ActorCallback< WorkerThreadActor, 2, Void >;
friend struct ActorCallback< WorkerThreadActor, 3, Void >;
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	WorkerThreadActor(ConnectionProviderTestSettings* const& settings,std::vector<ProviderTestData>* const& providers) 
															#line 1620 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerThreadActorState<WorkerThreadActor>(settings, providers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerThread", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14721148509806403584UL, 10009843202162629632UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerThreadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerThread");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerThread", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerThreadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerThreadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkerThreadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkerThreadActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
[[nodiscard]] Future<Void> workerThread( ConnectionProviderTestSettings* const& settings, std::vector<ProviderTestData>* const& providers ) {
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	return Future<Void>(new WorkerThreadActor(settings, providers));
															#line 1656 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
}

#line 170 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"

															#line 1661 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
namespace {
// This generated class is to be used only via checkAndCleanUp()
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
template <class CheckAndCleanUpActor>
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class CheckAndCleanUpActorState {
															#line 1668 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	CheckAndCleanUpActorState(ProviderTestData* const& provider) 
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		 : provider(provider),
															#line 172 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   i()
															#line 1677 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAndCleanUp", reinterpret_cast<unsigned long>(this));

	}
	~CheckAndCleanUpActorState() 
	{
		fdb_probe_actor_destroy("checkAndCleanUp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			ASSERT(provider->usedNames.size() == provider->data.size());
															#line 175 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			i = 0;
															#line 1694 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAndCleanUpActorState();
		static_cast<CheckAndCleanUpActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 181 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<CheckAndCleanUpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAndCleanUpActorState(); static_cast<CheckAndCleanUpActor*>(this)->destroy(); return 0; }
															#line 1717 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<CheckAndCleanUpActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAndCleanUpActorState();
		static_cast<CheckAndCleanUpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 175 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!(i < provider->data.size()))
															#line 1736 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 176 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		auto& readInfo = provider->data[i];
															#line 177 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(readAndVerifyObject(provider, readInfo.first, readInfo.second));
															#line 177 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1746 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state = 1;
															#line 177 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAndCleanUpActor, 0, Void >*>(static_cast<CheckAndCleanUpActor*>(this)));
															#line 1751 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = deleteObject(provider, provider->data[i].first);
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1775 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state = 2;
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAndCleanUpActor, 1, Void >*>(static_cast<CheckAndCleanUpActor*>(this)));
															#line 1780 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = deleteObject(provider, provider->data[i].first);
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1791 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state = 2;
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAndCleanUpActor, 1, Void >*>(static_cast<CheckAndCleanUpActor*>(this)));
															#line 1796 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state > 0) static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndCleanUpActor*>(this)->ActorCallback< CheckAndCleanUpActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndCleanUpActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAndCleanUpActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAndCleanUpActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		i++;
															#line 1880 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		i++;
															#line 1889 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state > 0) static_cast<CheckAndCleanUpActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndCleanUpActor*>(this)->ActorCallback< CheckAndCleanUpActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndCleanUpActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAndCleanUpActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAndCleanUpActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ProviderTestData* provider;
															#line 172 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	int i;
															#line 1973 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
};
// This generated class is to be used only via checkAndCleanUp()
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class CheckAndCleanUpActor final : public Actor<Void>, public ActorCallback< CheckAndCleanUpActor, 0, Void >, public ActorCallback< CheckAndCleanUpActor, 1, Void >, public FastAllocated<CheckAndCleanUpActor>, public CheckAndCleanUpActorState<CheckAndCleanUpActor> {
															#line 1978 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
	using FastAllocated<CheckAndCleanUpActor>::operator new;
	using FastAllocated<CheckAndCleanUpActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12276850527939381504UL, 3025776260288974336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAndCleanUpActor, 0, Void >;
friend struct ActorCallback< CheckAndCleanUpActor, 1, Void >;
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	CheckAndCleanUpActor(ProviderTestData* const& provider) 
															#line 1996 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		 : Actor<Void>(),
		   CheckAndCleanUpActorState<CheckAndCleanUpActor>(provider),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAndCleanUp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(597637750545196800UL, 1489547479552884224UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndCleanUpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAndCleanUp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAndCleanUp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAndCleanUpActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAndCleanUpActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
[[nodiscard]] Future<Void> checkAndCleanUp( ProviderTestData* const& provider ) {
															#line 171 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	return Future<Void>(new CheckAndCleanUpActor(provider));
															#line 2030 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
}

#line 183 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"

// maybe this should be a workload instead?
															#line 2036 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase185()
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
template <class FlowTestCase185Actor>
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class FlowTestCase185ActorState {
															#line 2043 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	FlowTestCase185ActorState(UnitTestParameters const& params) 
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		 : params(params),
															#line 186 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   settings(),
															#line 188 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		   providers()
															#line 2054 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase185", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase185ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase185", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			providers.reserve(settings.numProviders);
															#line 190 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			for(int i = 0;i < settings.numProviders;i++) {
															#line 191 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				std::string nameStr = std::to_string(i);
															#line 192 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				auto metadata = createRandomTestBlobMetadata(SERVER_KNOBS->BG_URL, i);
															#line 193 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				providers.emplace_back(BlobConnectionProvider::newBlobConnectionProvider(metadata));
															#line 2077 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			}
															#line 195 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			fmt::print("BlobConnectionProviderTest\n");
															#line 197 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			futures = std::vector<Future<Void>>();
															#line 198 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			futures.reserve(settings.threads);
															#line 199 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			for(int i = 0;i < settings.threads;i++) {
															#line 200 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
				futures.push_back(workerThread(&settings, &providers));
															#line 2089 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			}
															#line 203 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 203 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			if (static_cast<FlowTestCase185Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2095 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase185Actor*>(this)->actor_wait_state = 1;
															#line 203 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase185Actor, 0, Void >*>(static_cast<FlowTestCase185Actor*>(this)));
															#line 2100 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase185ActorState();
		static_cast<FlowTestCase185Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		fmt::print("BlobConnectionProviderTest workload phase complete with {0} files and {1} reads\n", settings.writeOps, settings.readOps);
															#line 209 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		futures.clear();
															#line 210 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		futures.reserve(providers.size());
															#line 211 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		for(int i = 0;i < providers.size();i++) {
															#line 212 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			futures.push_back(checkAndCleanUp(&providers[i]));
															#line 2131 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		}
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<FlowTestCase185Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2137 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase185Actor*>(this)->actor_wait_state = 2;
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase185Actor, 1, Void >*>(static_cast<FlowTestCase185Actor*>(this)));
															#line 2142 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		fmt::print("BlobConnectionProviderTest workload phase complete with {0} files and {1} reads\n", settings.writeOps, settings.readOps);
															#line 209 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		futures.clear();
															#line 210 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		futures.reserve(providers.size());
															#line 211 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		for(int i = 0;i < providers.size();i++) {
															#line 212 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
			futures.push_back(checkAndCleanUp(&providers[i]));
															#line 2159 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		}
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (static_cast<FlowTestCase185Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2165 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase185Actor*>(this)->actor_wait_state = 2;
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase185Actor, 1, Void >*>(static_cast<FlowTestCase185Actor*>(this)));
															#line 2170 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase185Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase185Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase185Actor*>(this)->ActorCallback< FlowTestCase185Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase185Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase185Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase185Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		fmt::print("BlobConnectionProviderTest check and cleanup phase complete\n");
															#line 218 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<FlowTestCase185Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase185ActorState(); static_cast<FlowTestCase185Actor*>(this)->destroy(); return 0; }
															#line 2256 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<FlowTestCase185Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase185ActorState();
		static_cast<FlowTestCase185Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		fmt::print("BlobConnectionProviderTest check and cleanup phase complete\n");
															#line 218 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
		if (!static_cast<FlowTestCase185Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase185ActorState(); static_cast<FlowTestCase185Actor*>(this)->destroy(); return 0; }
															#line 2270 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		new (&static_cast<FlowTestCase185Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase185ActorState();
		static_cast<FlowTestCase185Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase185Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase185Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase185Actor*>(this)->ActorCallback< FlowTestCase185Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase185Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase185Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase185Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	UnitTestParameters params;
															#line 186 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	ConnectionProviderTestSettings settings;
															#line 188 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	std::vector<ProviderTestData> providers;
															#line 197 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 2361 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase185()
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
class FlowTestCase185Actor final : public Actor<Void>, public ActorCallback< FlowTestCase185Actor, 0, Void >, public ActorCallback< FlowTestCase185Actor, 1, Void >, public FastAllocated<FlowTestCase185Actor>, public FlowTestCase185ActorState<FlowTestCase185Actor> {
															#line 2366 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase185Actor>::operator new;
	using FastAllocated<FlowTestCase185Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1487920805547144448UL, 10478248055612055040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase185Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase185Actor, 1, Void >;
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	FlowTestCase185Actor(UnitTestParameters const& params) 
															#line 2384 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase185ActorState<FlowTestCase185Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase185", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14569162241325025280UL, 2080777073508940288UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase185Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase185");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase185", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase185Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase185Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
static Future<Void> flowTestCase185( UnitTestParameters const& params ) {
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbserver/BlobConnectionProviderTest.actor.cpp"
	return Future<Void>(new FlowTestCase185Actor(params));
															#line 2418 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbserver/BlobConnectionProviderTest.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase185, "/fdbserver/blob/connectionprovider")

