#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
/*
 * BlobKeyCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 37 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
// This generated class is to be used only via printBlobHistory()
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
template <class PrintBlobHistoryActor>
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
class PrintBlobHistoryActorState {
															#line 43 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	PrintBlobHistoryActorState(Database const& db,Optional<Reference<Tenant>> const& tenant,Optional<TenantMapEntry> const& tenantEntry,Key const& key,Optional<Version> const& version) 
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		 : db(db),
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   tenant(tenant),
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   tenantEntry(tenantEntry),
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   key(key),
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   version(version)
															#line 58 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printBlobHistory", reinterpret_cast<unsigned long>(this));

	}
	~PrintBlobHistoryActorState() 
	{
		fdb_probe_actor_destroy("printBlobHistory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("Printing blob history for {0}", key.printable());
															#line 41 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (version.present())
															#line 75 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 42 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				fmt::print(" @ {0}", version.get());
															#line 79 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			}
															#line 44 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("\n");
															#line 46 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			tr = Transaction(db, tenant);
															#line 47 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			activeGranule = KeyRange();
															#line 48 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			queryRange = KeyRange(KeyRangeRef(key, keyAfter(key)));
															#line 49 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			;
															#line 91 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintBlobHistoryActorState();
		static_cast<PrintBlobHistoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 63 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (tenant.present())
															#line 114 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 64 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			activeGranule = activeGranule.withPrefix(tenant.get()->prefix());
															#line 118 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		}
															#line 67 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		fmt::print("Active granule: [{0} - {1})\n", activeGranule.begin.printable(), activeGranule.end.printable());
															#line 70 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		tr2 = Transaction(db);
															#line 71 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		history = GranuleHistory();
															#line 72 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		;
															#line 128 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 51 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = tr.getBlobGranuleRanges(queryRange, 2);
															#line 51 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 60 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 1, Void >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 194 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 52 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (granules.empty())
															#line 209 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("No active granule for {0}\n", key.printable());
															#line 54 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (!static_cast<PrintBlobHistoryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~PrintBlobHistoryActorState(); static_cast<PrintBlobHistoryActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			new (&static_cast<PrintBlobHistoryActor*>(this)->SAV< bool >::value()) bool(false);
			this->~PrintBlobHistoryActorState();
			static_cast<PrintBlobHistoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 56 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 57 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		activeGranule = granules[0];
															#line 225 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 52 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (granules.empty())
															#line 234 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("No active granule for {0}\n", key.printable());
															#line 54 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (!static_cast<PrintBlobHistoryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~PrintBlobHistoryActorState(); static_cast<PrintBlobHistoryActor*>(this)->destroy(); return 0; }
															#line 240 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			new (&static_cast<PrintBlobHistoryActor*>(this)->SAV< bool >::value()) bool(false);
			this->~PrintBlobHistoryActorState();
			static_cast<PrintBlobHistoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 56 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 57 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		activeGranule = granules[0];
															#line 250 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(granules, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 93 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		fmt::print("History:\n\n");
															#line 94 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		;
															#line 423 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 74 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr2.getRange(blobGranuleHistoryKeyRangeFor(activeGranule), 1, Snapshot::False, Reverse::True);
															#line 74 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 442 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 3;
															#line 74 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 2, RangeResult >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 447 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr2.onError(e);
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 484 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 4;
															#line 89 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 3, Void >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 489 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 78 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (result.empty())
															#line 506 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 79 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("No history entry found\n");
															#line 80 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (!static_cast<PrintBlobHistoryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~PrintBlobHistoryActorState(); static_cast<PrintBlobHistoryActor*>(this)->destroy(); return 0; }
															#line 512 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			new (&static_cast<PrintBlobHistoryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~PrintBlobHistoryActorState();
			static_cast<PrintBlobHistoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 83 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(result[0].key);
															#line 84 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(activeGranule == decodedKey.first);
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		history = GranuleHistory(activeGranule, decodedKey.second, decodeBlobGranuleHistoryValue(result[0].value));
															#line 524 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 78 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (result.empty())
															#line 535 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 79 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			fmt::print("No history entry found\n");
															#line 80 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (!static_cast<PrintBlobHistoryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~PrintBlobHistoryActorState(); static_cast<PrintBlobHistoryActor*>(this)->destroy(); return 0; }
															#line 541 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			new (&static_cast<PrintBlobHistoryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~PrintBlobHistoryActorState();
			static_cast<PrintBlobHistoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 83 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(result[0].key);
															#line 84 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(activeGranule == decodedKey.first);
															#line 85 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		history = GranuleHistory(activeGranule, decodedKey.second, decodeBlobGranuleHistoryValue(result[0].value));
															#line 553 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 148 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		fmt::print("Done\n");
															#line 149 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (!static_cast<PrintBlobHistoryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~PrintBlobHistoryActorState(); static_cast<PrintBlobHistoryActor*>(this)->destroy(); return 0; }
															#line 726 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		new (&static_cast<PrintBlobHistoryActor*>(this)->SAV< bool >::value()) bool(true);
		this->~PrintBlobHistoryActorState();
		static_cast<PrintBlobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 96 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		std::string boundaryChangeAction;
															#line 97 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (history.value.parentVersions.empty())
															#line 747 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			boundaryChangeAction = "root";
															#line 751 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		}
		else
		{
															#line 99 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (history.value.parentVersions.size() == 1)
															#line 757 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 100 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				boundaryChangeAction = "split";
															#line 761 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			}
			else
			{
															#line 102 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				boundaryChangeAction = "merge";
															#line 767 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			}
		}
															#line 104 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		fmt::print("{0}) {1}\n\t{2}\n\t{3}\n({4})\n\n", history.version, history.value.granuleID.toString(), history.range.begin.printable(), history.range.end.printable(), boundaryChangeAction);
															#line 112 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (history.value.parentVersions.empty() || (version.present() && history.version <= version.get()))
															#line 774 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 116 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		int i;
															#line 117 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		for(i = 0;i < history.value.parentBoundaries.size();i++) {
															#line 118 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (history.value.parentBoundaries[i] <= key)
															#line 784 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
				break;
			}
		}
															#line 123 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		ASSERT(i < history.value.parentBoundaries.size());
															#line 124 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		KeyRangeRef parentRange(history.value.parentBoundaries[i], history.value.parentBoundaries[i + 1]);
															#line 125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		Version parentVersion = history.value.parentVersions[i];
															#line 126 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		parentHistoryKey = blobGranuleHistoryKeyFor(parentRange, parentVersion);
															#line 127 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		foundParent = bool();
															#line 129 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		;
															#line 801 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 143 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (!foundParent)
															#line 823 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 131 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = tr2.get(parentHistoryKey);
															#line 131 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 845 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 5;
															#line 131 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 850 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr2.onError(e);
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 887 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont3loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 6;
															#line 140 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PrintBlobHistoryActor, 5, Void >*>(static_cast<PrintBlobHistoryActor*>(this)));
															#line 892 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2(Optional<Value> const& parentHistoryValue,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		foundParent = parentHistoryValue.present();
															#line 133 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (foundParent)
															#line 909 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(parentHistoryKey);
															#line 135 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			history = GranuleHistory( decodedKey.first, decodedKey.second, decodeBlobGranuleHistoryValue(parentHistoryValue.get()));
															#line 915 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		}
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2(Optional<Value> && parentHistoryValue,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		foundParent = parentHistoryValue.present();
															#line 133 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (foundParent)
															#line 927 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		{
															#line 134 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(parentHistoryKey);
															#line 135 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			history = GranuleHistory( decodedKey.first, decodedKey.second, decodeBlobGranuleHistoryValue(parentHistoryValue.get()));
															#line 933 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		}
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Optional<Value> const& parentHistoryValue,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont2(parentHistoryValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Optional<Value> && parentHistoryValue,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont2(std::move(parentHistoryValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state > 0) static_cast<PrintBlobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBlobHistoryActor*>(this)->ActorCallback< PrintBlobHistoryActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PrintBlobHistoryActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PrintBlobHistoryActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Database db;
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Optional<TenantMapEntry> tenantEntry;
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Key key;
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Optional<Version> version;
															#line 46 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Transaction tr;
															#line 47 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	KeyRange activeGranule;
															#line 48 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	KeyRange queryRange;
															#line 70 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Transaction tr2;
															#line 71 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	GranuleHistory history;
															#line 126 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Key parentHistoryKey;
															#line 127 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	bool foundParent;
															#line 1125 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
};
// This generated class is to be used only via printBlobHistory()
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
class PrintBlobHistoryActor final : public Actor<bool>, public ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< PrintBlobHistoryActor, 1, Void >, public ActorCallback< PrintBlobHistoryActor, 2, RangeResult >, public ActorCallback< PrintBlobHistoryActor, 3, Void >, public ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >, public ActorCallback< PrintBlobHistoryActor, 5, Void >, public FastAllocated<PrintBlobHistoryActor>, public PrintBlobHistoryActorState<PrintBlobHistoryActor> {
															#line 1130 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
public:
	using FastAllocated<PrintBlobHistoryActor>::operator new;
	using FastAllocated<PrintBlobHistoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8602085214729417472UL, 13163597109986206208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< PrintBlobHistoryActor, 1, Void >;
friend struct ActorCallback< PrintBlobHistoryActor, 2, RangeResult >;
friend struct ActorCallback< PrintBlobHistoryActor, 3, Void >;
friend struct ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >;
friend struct ActorCallback< PrintBlobHistoryActor, 5, Void >;
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	PrintBlobHistoryActor(Database const& db,Optional<Reference<Tenant>> const& tenant,Optional<TenantMapEntry> const& tenantEntry,Key const& key,Optional<Version> const& version) 
															#line 1152 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		 : Actor<bool>(),
		   PrintBlobHistoryActorState<PrintBlobHistoryActor>(db, tenant, tenantEntry, key, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printBlobHistory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12704384996154903808UL, 8171227610060282368UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBlobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printBlobHistory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printBlobHistory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< PrintBlobHistoryActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
[[nodiscard]] Future<bool> printBlobHistory( Database const& db, Optional<Reference<Tenant>> const& tenant, Optional<TenantMapEntry> const& tenantEntry, Key const& key, Optional<Version> const& version ) {
															#line 35 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	return Future<bool>(new PrintBlobHistoryActor(db, tenant, tenantEntry, key, version));
															#line 1189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
}

#line 151 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"

} // namespace

namespace fdb_cli {

															#line 1198 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
// This generated class is to be used only via blobKeyCommandActor()
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
template <class BlobKeyCommandActorActor>
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
class BlobKeyCommandActorActorState {
															#line 1204 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
public:
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	BlobKeyCommandActorActorState(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens) 
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		 : localDb(localDb),
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   tenantEntry(tenantEntry),
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		   tokens(tokens)
															#line 1215 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("blobKeyCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~BlobKeyCommandActorActorState() 
	{
		fdb_probe_actor_destroy("blobKeyCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (tokens.size() != 3 && tokens.size() != 4)
															#line 1230 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 161 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 162 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				if (!static_cast<BlobKeyCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobKeyCommandActorActorState(); static_cast<BlobKeyCommandActorActor*>(this)->destroy(); return 0; }
															#line 1236 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
				new (&static_cast<BlobKeyCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~BlobKeyCommandActorActorState();
				static_cast<BlobKeyCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 165 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			Optional<Reference<Tenant>> tenant;
															#line 166 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (tenantEntry.present())
															#line 1246 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 167 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				tenant = Reference<Tenant>(new Tenant(tenantEntry.get().id));
															#line 1250 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			ASSERT(tokens[1] == "history"_sr);
															#line 172 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			Key key = tokens[2];
															#line 173 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			Optional<Version> version;
															#line 174 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (tokens.size() > 3)
															#line 1260 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 175 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				Version v;
															#line 176 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				int n = 0;
															#line 177 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				if (sscanf(tokens[3].toString().c_str(), "%" PRId64 "%n", &v, &n) != 1 || n != tokens[3].size())
															#line 1268 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
				{
															#line 178 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 179 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
					if (!static_cast<BlobKeyCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobKeyCommandActorActorState(); static_cast<BlobKeyCommandActorActor*>(this)->destroy(); return 0; }
															#line 1274 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
					new (&static_cast<BlobKeyCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~BlobKeyCommandActorActorState();
					static_cast<BlobKeyCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 181 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				version = v;
															#line 1282 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			}
															#line 184 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
			if (key >= "\xff"_sr)
															#line 1286 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				fmt::print("No blob history for system keyspace\n", key.printable());
															#line 186 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				if (!static_cast<BlobKeyCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobKeyCommandActorActorState(); static_cast<BlobKeyCommandActorActor*>(this)->destroy(); return 0; }
															#line 1292 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
				new (&static_cast<BlobKeyCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~BlobKeyCommandActorActorState();
				static_cast<BlobKeyCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 188 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				StrictFuture<bool> __when_expr_0 = printBlobHistory(localDb, tenant, tenantEntry, key, version);
															#line 188 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				if (static_cast<BlobKeyCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1304 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BlobKeyCommandActorActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobKeyCommandActorActor, 0, bool >*>(static_cast<BlobKeyCommandActorActor*>(this)));
															#line 1309 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobKeyCommandActorActorState();
		static_cast<BlobKeyCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool const& result,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (!static_cast<BlobKeyCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~BlobKeyCommandActorActorState(); static_cast<BlobKeyCommandActorActor*>(this)->destroy(); return 0; }
															#line 1333 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		new (&static_cast<BlobKeyCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~BlobKeyCommandActorActorState();
		static_cast<BlobKeyCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(bool && result,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
		if (!static_cast<BlobKeyCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~BlobKeyCommandActorActorState(); static_cast<BlobKeyCommandActorActor*>(this)->destroy(); return 0; }
															#line 1345 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		new (&static_cast<BlobKeyCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~BlobKeyCommandActorActorState();
		static_cast<BlobKeyCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont7(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobKeyCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobKeyCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobKeyCommandActorActor*>(this)->ActorCallback< BlobKeyCommandActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobKeyCommandActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobKeyCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobKeyCommandActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobKeyCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobKeyCommandActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobKeyCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Database localDb;
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	Optional<TenantMapEntry> tenantEntry;
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 1434 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
};
// This generated class is to be used only via blobKeyCommandActor()
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
class BlobKeyCommandActorActor final : public Actor<bool>, public ActorCallback< BlobKeyCommandActorActor, 0, bool >, public FastAllocated<BlobKeyCommandActorActor>, public BlobKeyCommandActorActorState<BlobKeyCommandActorActor> {
															#line 1439 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
public:
	using FastAllocated<BlobKeyCommandActorActor>::operator new;
	using FastAllocated<BlobKeyCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12699438723839143424UL, 13288383198698244096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobKeyCommandActorActor, 0, bool >;
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	BlobKeyCommandActorActor(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens) 
															#line 1456 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
		 : Actor<bool>(),
		   BlobKeyCommandActorActorState<BlobKeyCommandActorActor>(localDb, tenantEntry, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18087124127165906432UL, 6482403313695857920UL);
		ActorExecutionContextHelper __helper(static_cast<BlobKeyCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobKeyCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobKeyCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobKeyCommandActorActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
[[nodiscard]] Future<bool> blobKeyCommandActor( Database const& localDb, Optional<TenantMapEntry> const& tenantEntry, std::vector<StringRef> const& tokens ) {
															#line 156 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"
	return Future<bool>(new BlobKeyCommandActorActor(localDb, tenantEntry, tokens));
															#line 1488 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/build_output/fdbcli/BlobKeyCommand.actor.g.cpp"
}

#line 192 "/codebuild/output/src2620178984/src/github.com/apple/foundationdb/fdbcli/BlobKeyCommand.actor.cpp"

// can extend to other blobkey commands later
CommandFactory blobKeyFactory("blobkey", CommandHelp("blobkey history <key> [version]", "", ""));
} // namespace fdb_cli
