/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.EventKeeper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class MapEventKeeper
implements EventKeeper {
    private final ConcurrentMap<EventKeeper.Event, Count> map = new ConcurrentHashMap<EventKeeper.Event, Count>();

    @Override
    public void count(EventKeeper.Event event2, long l) {
        Count count = this.map.computeIfAbsent(event2, event -> new Count());
        count.cnt.addAndGet(l);
    }

    @Override
    public void timeNanos(EventKeeper.Event event2, long l) {
        Count count = this.map.computeIfAbsent(event2, event -> new Count());
        count.cnt.incrementAndGet();
        count.duration.addAndGet(l);
    }

    @Override
    public long getCount(EventKeeper.Event event) {
        Count count = (Count)this.map.get(event);
        if (count == null) {
            return 0L;
        }
        return count.cnt.get();
    }

    @Override
    public long getTimeNanos(EventKeeper.Event event) {
        Count count = (Count)this.map.get(event);
        if (count == null) {
            return 0L;
        }
        return count.duration.get();
    }

    private static class Count {
        private final AtomicLong cnt = new AtomicLong(0L);
        private final AtomicLong duration = new AtomicLong(0L);

        Count() {
        }
    }
}

