#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
/*
 * BenchStream.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"

#include "fdbclient/FDBTypes.h"
#include "flow/flow.h"
#include "flow/TLSConfig.actor.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/network.h"
#include "flowbench/GlobalData.h"

#include <thread>

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 36 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via benchStreamActor()
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
template <class BenchStreamActorActor>
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
class BenchStreamActorActorState {
															#line 43 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
public:
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	BenchStreamActorActorState(benchmark::State* const& benchState) 
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		 : benchState(benchState),
															#line 35 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		   items(benchState->range(0))
															#line 52 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("benchStreamActor", reinterpret_cast<unsigned long>(this));

	}
	~BenchStreamActorActorState() 
	{
		fdb_probe_actor_destroy("benchStreamActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			size_t size = benchState->range(1);
															#line 37 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			key = getKey(size);
															#line 38 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			stream = PromiseStream<Key>();
															#line 39 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			i = int();
															#line 40 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			;
															#line 75 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchStreamActorActorState();
		static_cast<BenchStreamActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		benchState->SetItemsProcessed(items * static_cast<long>(benchState->iterations()));
															#line 50 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		if (!static_cast<BenchStreamActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchStreamActorActorState(); static_cast<BenchStreamActorActor*>(this)->destroy(); return 0; }
															#line 100 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		new (&static_cast<BenchStreamActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchStreamActorActorState();
		static_cast<BenchStreamActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 40 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 41 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		for(i = 0;i < items;++i) {
															#line 42 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
			stream.send(key);
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		}
															#line 44 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		i = 0;
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		if (!(i < items))
															#line 166 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 45 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		auto __when_expr_0 = stream.getFuture();
															#line 172 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Key>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Key>>::value, "invalid type");
															#line 45 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		if (static_cast<BenchStreamActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 176 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<BenchStreamActorActor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< BenchStreamActorActor, 0, Key >*>(static_cast<BenchStreamActorActor*>(this)));
															#line 181 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Key const& receivedKey,int loopDepth) 
	{
															#line 46 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		benchmark::DoNotOptimize(receivedKey);
															#line 44 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		++i;
															#line 205 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Key && receivedKey,int loopDepth) 
	{
															#line 46 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		benchmark::DoNotOptimize(receivedKey);
															#line 44 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
		++i;
															#line 216 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Key const& receivedKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(receivedKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Key && receivedKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(receivedKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchStreamActorActor*>(this)->actor_wait_state > 0) static_cast<BenchStreamActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchStreamActorActor*>(this)->ActorSingleCallback< BenchStreamActorActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorSingleCallback< BenchStreamActorActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchStreamActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< BenchStreamActorActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchStreamActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< BenchStreamActorActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchStreamActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchStreamActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	benchmark::State* benchState;
															#line 35 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	size_t items;
															#line 37 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	KeyRef key;
															#line 38 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	PromiseStream<Key> stream;
															#line 39 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	int i;
															#line 306 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
};
// This generated class is to be used only via benchStreamActor()
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
class BenchStreamActorActor final : public Actor<Void>, public ActorSingleCallback< BenchStreamActorActor, 0, Key >, public FastAllocated<BenchStreamActorActor>, public BenchStreamActorActorState<BenchStreamActorActor> {
															#line 311 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
public:
	using FastAllocated<BenchStreamActorActor>::operator new;
	using FastAllocated<BenchStreamActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5796995827690773504UL, 13571622937978593024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< BenchStreamActorActor, 0, Key >;
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	BenchStreamActorActor(benchmark::State* const& benchState) 
															#line 328 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BenchStreamActorActorState<BenchStreamActorActor>(benchState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("benchStreamActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(847470563431043072UL, 11082721302974898432UL);
		ActorExecutionContextHelper __helper(static_cast<BenchStreamActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchStreamActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchStreamActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< BenchStreamActorActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
[[nodiscard]] static Future<Void> benchStreamActor( benchmark::State* const& benchState ) {
															#line 34 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"
	return Future<Void>(new BenchStreamActorActor(benchState));
															#line 361 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/flowbench/BenchStream.actor.g.cpp.py_gen"
}

#line 52 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/flowbench/BenchStream.actor.cpp"

static void bench_stream(benchmark::State& benchState) {
	onMainThread([&benchState]() { return benchStreamActor(&benchState); }).blockUntilReady();
}

BENCHMARK(bench_stream)->Ranges({ { 1, 1 << 16 }, { 1, 1 << 16 } })->ReportAggregatesOnly(true);
