#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
/*
 * RyowCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <vector>

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/MemoryKeyValueStore.h"
#include "fdbserver/workloads/ApiWorkload.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define TRACE_TRANSACTION 0

#if TRACE_TRANSACTION
StringRef debugKey = "0000000000uldlamzpspf"_sr;
#endif

// A struct representing an operation to be performed on a transaction
struct Operation {

	// An enum of API operation types to perform in a transaction
	enum OperationType { SET, GET, GET_RANGE, GET_RANGE_SELECTOR, GET_KEY, CLEAR, CLEAR_RANGE };

	OperationType type;

	Key beginKey;
	Key endKey;

	KeySelector beginSelector;
	KeySelector endSelector;

	Value value;

	int limit;
	Reverse reverse{ Reverse::False };
};

// A workload which executes random sequences of operations on RYOW transactions and confirms the results
struct RyowCorrectnessWorkload : ApiWorkload {
	static constexpr auto NAME = "RyowCorrectness";

	// How long the test should run
	int duration;

	// The number of operations to perform on a transaction in between commits
	int opsPerTransaction;

	RyowCorrectnessWorkload(WorkloadContext const& wcx) : ApiWorkload(wcx, 1) {
		duration = getOption(options, "duration"_sr, 60);
		opsPerTransaction = getOption(options, "opsPerTransaction"_sr, 50);
	}

																#line 72 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via performSetup()
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
template <class PerformSetupActor>
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class PerformSetupActorState {
															#line 78 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	PerformSetupActorState(Database const& cx,RyowCorrectnessWorkload* const& self) 
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		 : cx(cx),
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   self(self)
															#line 87 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("performSetup", reinterpret_cast<unsigned long>(this));

	}
	~PerformSetupActorState() 
	{
		fdb_probe_actor_destroy("performSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			std::vector<TransactionType> types;
															#line 72 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			types.push_back(READ_YOUR_WRITES);
															#line 74 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->chooseTransactionFactory(cx, types);
															#line 74 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 108 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformSetupActor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 0, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 113 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 136 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 148 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Database cx;
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	RyowCorrectnessWorkload* self;
															#line 235 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via performSetup()
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class PerformSetupActor final : public Actor<Void>, public ActorCallback< PerformSetupActor, 0, Void >, public FastAllocated<PerformSetupActor>, public PerformSetupActorState<PerformSetupActor> {
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerformSetupActor>::operator new;
	using FastAllocated<PerformSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5720763758039770880UL, 3748732883725069824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformSetupActor, 0, Void >;
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	PerformSetupActor(Database const& cx,RyowCorrectnessWorkload* const& self) 
															#line 257 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerformSetupActorState<PerformSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(908050500225728256UL, 2892666575110672640UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformSetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performSetup( Database const& cx, RyowCorrectnessWorkload* const& self ) {
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	return Future<Void>(new PerformSetupActor(cx, self));
															#line 289 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
}

#line 77 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"

	Future<Void> performSetup(Database const& cx) override { return performSetup(cx, this); }

	// Generates a random sequence of operations to perform in a single transaction
	std::vector<Operation> generateOperationSequence(Standalone<VectorRef<KeyValueRef>> const& data) {
		std::vector<Operation> sequence;

		int pdfArray[] = { 0, 100, 100, 50, 50, 20, 100, 5 };
		std::vector<int> pdf = std::vector<int>(pdfArray, pdfArray + 8);

		// Choose a random operation type (SET, GET, GET_RANGE, GET_RANGE_SELECTOR, GET_KEY, CLEAR, CLEAR_RANGE).
		int totalDensity = 0;
		for (int i = 0; i < pdf.size(); i++)
			totalDensity += pdf[i];

		for (int i = 0; i < opsPerTransaction; ++i) {
			int cumulativeDensity = 0;
			int random = deterministicRandom()->randomInt(0, totalDensity);
			for (int i = 0; i < pdf.size() - 1; i++) {
				if (cumulativeDensity + pdf[i] <= random && random < cumulativeDensity + pdf[i] + pdf[i + 1]) {
					Operation info;
					info.type = (Operation::OperationType)i;

					switch (info.type) {
					case Operation::GET:
					case Operation::CLEAR:
						info.beginKey = selectRandomKey(data, .8);
						break;
					case Operation::SET:
						info.beginKey = selectRandomKey(data, .5);
						info.value = generateValue();
						break;
					case Operation::GET_RANGE:
					case Operation::CLEAR_RANGE:
						info.beginKey = selectRandomKey(data, .8);
						info.endKey = selectRandomKey(data, .8);
						info.limit = deterministicRandom()->randomInt(0, 1000);
						info.reverse.set(deterministicRandom()->coinflip());

						if (info.beginKey > info.endKey)
							std::swap(info.beginKey, info.endKey);

						break;
					case Operation::GET_RANGE_SELECTOR:
					case Operation::GET_KEY:
						info.beginSelector = generateKeySelector(data, 1000);
						info.endSelector = generateKeySelector(data, 1000);
						info.limit = deterministicRandom()->randomInt(0, 1000);
						info.reverse.set(deterministicRandom()->coinflip());
						break;
					}

					sequence.push_back(info);
					break;
				}

				cumulativeDensity += pdf[i];
			}
		}

		return sequence;
	}

	// Adds a single KV-pair to the list of results
	void pushKVPair(std::vector<RangeResult>& results, Key const& key, Optional<Value> const& value) {
		RangeResult result;
		if (!value.present())
			result.push_back_deep(result.arena(), KeyValueRef(key, "VALUE_NOT_PRESENT"_sr));
		else
			result.push_back_deep(result.arena(), KeyValueRef(key, value.get()));

		results.push_back(result);
	}

	// Applies a sequence of operations to the memory store and returns the results
	std::vector<RangeResult> applySequenceToStore(std::vector<Operation> sequence) {
		std::vector<RangeResult> results;
		Key key;

#if TRACE_TRANSACTION
		printf("NEW_TRANSACTION\n");
#endif

		for (auto op : sequence) {
			switch (op.type) {
			case Operation::SET:
				store.set(op.beginKey, op.value);
#if TRACE_TRANSACTION
				if (op.beginKey == debugKey)
					printf("SET: %s = %d\n", printable(op.beginKey).c_str(), op.value.size());
#endif
				break;
			case Operation::GET:
				pushKVPair(results, op.beginKey, store.get(op.beginKey));
#if TRACE_TRANSACTION && 0
				if (op.beginKey == debugKey)
					printf("GET: %s\n", printable(op.beginKey).c_str());
#endif
				break;
			case Operation::GET_RANGE_SELECTOR:
				op.beginKey = store.getKey(op.beginSelector);
				op.endKey = store.getKey(op.endSelector);

				if (op.beginKey > op.endKey)
					op.endKey = op.beginKey;
				// Fall-through
			case Operation::GET_RANGE:
				results.push_back(store.getRange(KeyRangeRef(op.beginKey, op.endKey), op.limit, op.reverse));
#if TRACE_TRANSACTION
				if (op.beginKey <= debugKey && debugKey < op.endKey)
					printf("%s: %s - %s (limit=%d, reverse=%d)\n",
					       op.type == Operation::GET_RANGE ? "GET_RANGE" : "GET_RANGE_SELECTOR",
					       printable(op.beginKey).c_str(),
					       printable(op.endKey).c_str(),
					       op.limit,
					       op.reverse);
#endif
				break;
			case Operation::GET_KEY:
				key = store.getKey(op.beginSelector);
				pushKVPair(results, key, Value());
#if TRACE_TRANSACTION
				if (key == debugKey)
					printf("GET_KEY: %s = %s\n", op.beginSelector.toString().c_str(), printable(key).c_str());
#endif
				break;
			case Operation::CLEAR:
				store.clear(op.beginKey);
#if TRACE_TRANSACTION
				if (op.beginKey == debugKey)
					printf("CLEAR: %s\n", printable(op.beginKey).c_str());
#endif
				break;
			case Operation::CLEAR_RANGE:
				store.clear(KeyRangeRef(op.beginKey, op.endKey));
#if TRACE_TRANSACTION
				if (op.beginKey <= debugKey && debugKey < op.endKey)
					printf("CLEAR_RANGE: %s - %s\n", printable(op.beginKey).c_str(), printable(op.endKey).c_str());
#endif
				break;
			}
		}

		return results;
	}

	// Applies a sequence of operations to the database and returns the results
																#line 440 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via applySequenceToDatabase()
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
template <class ApplySequenceToDatabaseActor>
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class ApplySequenceToDatabaseActorState {
															#line 446 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	ApplySequenceToDatabaseActorState(Reference<TransactionWrapper> const& transaction,std::vector<Operation> const& sequence,RyowCorrectnessWorkload* const& self) 
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		 : transaction(transaction),
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   sequence(sequence),
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   self(self),
															#line 227 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   dontUpdateResults(false),
															#line 228 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   results()
															#line 461 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applySequenceToDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ApplySequenceToDatabaseActorState() 
	{
		fdb_probe_actor_destroy("applySequenceToDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			;
															#line 476 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplySequenceToDatabaseActorState();
		static_cast<ApplySequenceToDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			i = int();
															#line 232 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			i = 0;
															#line 509 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 268 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (e.code() == error_code_commit_unknown_result)
															#line 531 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			{
															#line 269 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				dontUpdateResults = true;
															#line 535 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				if (!dontUpdateResults)
															#line 541 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
				{
															#line 271 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					results.clear();
															#line 545 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
				}
			}
															#line 273 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = transaction->onError(e);
															#line 273 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 552 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 6;
															#line 273 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 5, Void >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 557 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 263 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = transaction->commit();
															#line 263 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 574 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 5;
															#line 263 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 4, Void >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 579 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!(i < sequence.size()))
															#line 595 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 233 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		op = sequence[i];
															#line 235 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (op.type == Operation::SET)
															#line 603 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			transaction->set(op.beginKey, op.value);
															#line 607 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 237 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (op.type == Operation::GET)
															#line 614 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			{
															#line 238 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(op.beginKey);
															#line 238 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 620 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 1;
															#line 238 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 625 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 241 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
				if (op.type == Operation::GET_RANGE)
															#line 632 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
				{
															#line 242 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					KeyRangeRef range(op.beginKey, op.endKey);
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(range, op.limit, op.reverse);
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 640 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 2;
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 645 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 246 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
					if (op.type == Operation::GET_RANGE_SELECTOR)
															#line 652 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
					{
															#line 247 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
						StrictFuture<RangeResult> __when_expr_2 = transaction->getRange(op.beginSelector, op.endSelector, op.limit, op.reverse);
															#line 247 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
						if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 658 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
						static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 3;
															#line 247 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 663 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
						if (op.type == Operation::GET_KEY)
															#line 670 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
						{
															#line 252 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
							StrictFuture<Key> __when_expr_3 = transaction->getKey(op.beginSelector);
															#line 252 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
							if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 676 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
							if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when4(__when_expr_3.get(), loopDepth); };
							static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 4;
															#line 252 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
							__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ApplySequenceToDatabaseActor, 3, Key >*>(static_cast<ApplySequenceToDatabaseActor*>(this)));
															#line 681 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 255 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
							if (op.type == Operation::CLEAR)
															#line 688 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
							{
															#line 256 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
								transaction->clear(op.beginKey);
															#line 692 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
							}
							else
							{
															#line 257 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
								if (op.type == Operation::CLEAR_RANGE)
															#line 698 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
								{
															#line 258 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
									KeyRangeRef range(op.beginKey, op.endKey);
															#line 259 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
									transaction->clear(range);
															#line 704 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
								}
							}
							loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		++i;
															#line 733 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Optional<Value> const& val,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 748 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->pushKVPair(results, op.beginKey, val);
															#line 752 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Optional<Value> && val,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 762 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->pushKVPair(results, op.beginKey, val);
															#line 766 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(RangeResult const& result,int loopDepth) 
	{
															#line 244 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 857 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 245 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			results.push_back((RangeResultRef)result);
															#line 861 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(RangeResult && result,int loopDepth) 
	{
															#line 244 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 871 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 245 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			results.push_back((RangeResultRef)result);
															#line 875 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(RangeResult const& result,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 966 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 250 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			results.push_back((RangeResultRef)result);
															#line 970 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(RangeResult && result,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 980 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 250 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			results.push_back((RangeResultRef)result);
															#line 984 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont15(Key const& key,int loopDepth) 
	{
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 1075 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->pushKVPair(results, key, Value());
															#line 1079 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont15(Key && key,int loopDepth) 
	{
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!dontUpdateResults)
															#line 1089 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->pushKVPair(results, key, Value());
															#line 1093 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont15(key, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(Key && key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont15(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 3, Key >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 3, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 3, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 3, Key >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!static_cast<ApplySequenceToDatabaseActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(results); this->~ApplySequenceToDatabaseActorState(); static_cast<ApplySequenceToDatabaseActor*>(this)->destroy(); return 0; }
															#line 1178 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ApplySequenceToDatabaseActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(std::move(results)); // state_var_RVO
		this->~ApplySequenceToDatabaseActorState();
		static_cast<ApplySequenceToDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!static_cast<ApplySequenceToDatabaseActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(results); this->~ApplySequenceToDatabaseActorState(); static_cast<ApplySequenceToDatabaseActor*>(this)->destroy(); return 0; }
															#line 1190 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ApplySequenceToDatabaseActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(std::move(results)); // state_var_RVO
		this->~ApplySequenceToDatabaseActorState();
		static_cast<ApplySequenceToDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ApplySequenceToDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ApplySequenceToDatabaseActor*>(this)->ActorCallback< ApplySequenceToDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ApplySequenceToDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ApplySequenceToDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	std::vector<Operation> sequence;
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	RyowCorrectnessWorkload* self;
															#line 227 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	bool dontUpdateResults;
															#line 228 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	std::vector<RangeResult> results;
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	int i;
															#line 233 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Operation op;
															#line 1374 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applySequenceToDatabase()
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class ApplySequenceToDatabaseActor final : public Actor<std::vector<RangeResult>>, public ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >, public ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >, public ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >, public ActorCallback< ApplySequenceToDatabaseActor, 3, Key >, public ActorCallback< ApplySequenceToDatabaseActor, 4, Void >, public ActorCallback< ApplySequenceToDatabaseActor, 5, Void >, public FastAllocated<ApplySequenceToDatabaseActor>, public ApplySequenceToDatabaseActorState<ApplySequenceToDatabaseActor> {
															#line 1379 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplySequenceToDatabaseActor>::operator new;
	using FastAllocated<ApplySequenceToDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8884088979696394240UL, 1291996762413212160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<RangeResult>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >;
friend struct ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >;
friend struct ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >;
friend struct ActorCallback< ApplySequenceToDatabaseActor, 3, Key >;
friend struct ActorCallback< ApplySequenceToDatabaseActor, 4, Void >;
friend struct ActorCallback< ApplySequenceToDatabaseActor, 5, Void >;
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	ApplySequenceToDatabaseActor(Reference<TransactionWrapper> const& transaction,std::vector<Operation> const& sequence,RyowCorrectnessWorkload* const& self) 
															#line 1401 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		 : Actor<std::vector<RangeResult>>(),
		   ApplySequenceToDatabaseActorState<ApplySequenceToDatabaseActor>(transaction, sequence, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3227297391149720320UL, 17139433447721414912UL);
		ActorExecutionContextHelper __helper(static_cast<ApplySequenceToDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applySequenceToDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applySequenceToDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 3, Key >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ApplySequenceToDatabaseActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
[[nodiscard]] Future<std::vector<RangeResult>> applySequenceToDatabase( Reference<TransactionWrapper> const& transaction, std::vector<Operation> const& sequence, RyowCorrectnessWorkload* const& self ) {
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	return Future<std::vector<RangeResult>>(new ApplySequenceToDatabaseActor(transaction, sequence, self));
															#line 1438 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
}

#line 277 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"

	// Compares a sequence of results from the database and the memory store
	bool compareResults(std::vector<RangeResult> dbResults,
	                    std::vector<RangeResult> storeResults,
	                    std::vector<Operation> sequence,
	                    Version readVersion) {
		ASSERT(storeResults.size() == dbResults.size());

		int currentResult = 0;
		for (int i = 0; i < sequence.size(); ++i) {
			Operation op = sequence[i];
			if (op.type == Operation::SET || op.type == Operation::CLEAR || op.type == Operation::CLEAR_RANGE)
				continue;

			if (!ApiWorkload::compareResults(dbResults[currentResult], storeResults[currentResult], readVersion)) {
				switch (op.type) {
				case Operation::GET:
					printf("Operation GET failed: key = %s\n", printable(op.beginKey).c_str());
					break;
				case Operation::GET_RANGE:
					printf("Operation GET_RANGE failed: begin = %s, end = %s, limit = %d, reverse = %d\n",
					       printable(op.beginKey).c_str(),
					       printable(op.endKey).c_str(),
					       op.limit,
					       static_cast<bool>(op.reverse));
					break;
				case Operation::GET_RANGE_SELECTOR:
					printf("Operation GET_RANGE_SELECTOR failed: begin = %s, end = %s, limit = %d, reverse = %d\n",
					       op.beginSelector.toString().c_str(),
					       op.endSelector.toString().c_str(),
					       op.limit,
					       static_cast<bool>(op.reverse));
					break;
				case Operation::GET_KEY:
					printf("Operation GET_KEY failed: selector = %s\n", op.beginSelector.toString().c_str());
					break;
				default:
					break;
				}

				return false;
			}

			++currentResult;
		}

		ASSERT(currentResult == storeResults.size());

		return true;
	}

	// Execute transactions with multiple random operations each
																#line 1494 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via performTest()
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
template <class PerformTestActor>
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class PerformTestActorState {
															#line 1500 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	PerformTestActorState(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,RyowCorrectnessWorkload* const& self) 
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		 : cx(cx),
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   data(data),
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		   self(self)
															#line 1511 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("performTest", reinterpret_cast<unsigned long>(this));

	}
	~PerformTestActorState() 
	{
		fdb_probe_actor_destroy("performTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 332 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			;
															#line 1526 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformTestActorState();
		static_cast<PerformTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 333 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 334 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		sequence = self->generateOperationSequence(data);
															#line 335 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		storeResults = self->applySequenceToStore(sequence);
															#line 336 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_0 = self->applySequenceToDatabase(transaction, sequence, self);
															#line 336 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1564 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 1;
															#line 336 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >*>(static_cast<PerformTestActor*>(this)));
															#line 1569 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 338 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		StrictFuture<Version> __when_expr_1 = transaction->getReadVersion();
															#line 338 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1580 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 2;
															#line 338 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 1, Version >*>(static_cast<PerformTestActor*>(this)));
															#line 1585 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<RangeResult> const& __dbResults,int loopDepth) 
	{
															#line 336 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		dbResults = __dbResults;
															#line 1594 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<RangeResult> && __dbResults,int loopDepth) 
	{
		dbResults = std::move(__dbResults);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 340 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		result = self->compareResults(dbResults, storeResults, sequence, readVersion);
															#line 341 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!result)
															#line 1675 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->testFailure("Transaction results did not match");
															#line 1679 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_2 = self->compareDatabaseToMemory();
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1685 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 3;
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 2, bool >*>(static_cast<PerformTestActor*>(this)));
															#line 1690 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 340 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		result = self->compareResults(dbResults, storeResults, sequence, readVersion);
															#line 341 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!result)
															#line 1701 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->testFailure("Transaction results did not match");
															#line 1705 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_2 = self->compareDatabaseToMemory();
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1711 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 3;
															#line 344 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 2, bool >*>(static_cast<PerformTestActor*>(this)));
															#line 1716 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(bool const& result2,int loopDepth) 
	{
															#line 345 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (result && !result2)
															#line 1800 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 346 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->testFailure("Database contents did not match");
															#line 1804 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
															#line 348 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!result || !result2)
															#line 1808 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 349 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 1812 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PerformTestActorState();
			static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(bool && result2,int loopDepth) 
	{
															#line 345 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (result && !result2)
															#line 1826 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 346 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			self->testFailure("Database contents did not match");
															#line 1830 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		}
															#line 348 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
		if (!result || !result2)
															#line 1834 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		{
															#line 349 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
			if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 1838 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PerformTestActorState();
			static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool const& result2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(result2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool && result2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(result2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Database cx;
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	RyowCorrectnessWorkload* self;
															#line 333 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 334 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	std::vector<Operation> sequence;
															#line 335 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	std::vector<RangeResult> storeResults;
															#line 336 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	std::vector<RangeResult> dbResults;
															#line 340 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	bool result;
															#line 1939 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via performTest()
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
class PerformTestActor final : public Actor<Void>, public ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >, public ActorCallback< PerformTestActor, 1, Version >, public ActorCallback< PerformTestActor, 2, bool >, public FastAllocated<PerformTestActor>, public PerformTestActorState<PerformTestActor> {
															#line 1944 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerformTestActor>::operator new;
	using FastAllocated<PerformTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9490493528765956352UL, 1762388358035475456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >;
friend struct ActorCallback< PerformTestActor, 1, Version >;
friend struct ActorCallback< PerformTestActor, 2, bool >;
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	PerformTestActor(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,RyowCorrectnessWorkload* const& self) 
															#line 1963 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerformTestActorState<PerformTestActor>(cx, data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6826498282132105984UL, 12962792935105555968UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformTestActor, 0, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformTestActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PerformTestActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performTest( Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data, RyowCorrectnessWorkload* const& self ) {
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"
	return Future<Void>(new PerformTestActor(cx, data, self));
															#line 1997 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RyowCorrectness.actor.g.cpp.py_gen"
}

#line 352 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RyowCorrectness.actor.cpp"

	Future<Void> performTest(Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data) override {
		return ::success(timeout(performTest(cx, data, this), duration));
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<RyowCorrectnessWorkload> RyowCorrectnessWorkloadFactory;
