#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
/*
 * RestoreBackup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain the purpose of this workload and how it different from the
// 20+ (literally) other backup/restore workloads.

struct RestoreBackupWorkload : TestWorkload {

	FileBackupAgent backupAgent;
	Reference<IBackupContainer> backupContainer;

	Standalone<StringRef> backupDir;
	Standalone<StringRef> tag;
	double delayFor;
	StopWhenDone stopWhenDone{ false };
	Optional<std::string> encryptionKeyFileName;

	RestoreBackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupDir = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
		tag = getOption(options, "tag"_sr, "default"_sr);
		delayFor = getOption(options, "delayFor"_sr, 10.0);
		stopWhenDone.set(getOption(options, "stopWhenDone"_sr, false));

		std::string keyFileName = "simfdb/" + getTestEncryptionFileName();
		// Only set encryptionKeyFileName if the encryption key file exists during backup.
		if (fileExists(keyFileName)) {
			encryptionKeyFileName = keyFileName;
		}
	}

	static constexpr auto NAME = "RestoreBackup";

																#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
// This generated class is to be used only via waitOnBackup()
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
template <class WaitOnBackupActor>
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class WaitOnBackupActorState {
															#line 71 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	WaitOnBackupActorState(RestoreBackupWorkload* const& self,Database const& cx) 
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		 : self(self),
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   cx(cx),
															#line 64 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   waitForVersion(),
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   backupUID(),
															#line 66 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   tr(cx)
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitOnBackup", reinterpret_cast<unsigned long>(this));

	}
	~WaitOnBackupActorState() 
	{
		fdb_probe_actor_destroy("waitOnBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			;
															#line 101 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitOnBackupActorState();
		static_cast<WaitOnBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<EBackupState> __when_expr_2 = self->backupAgent.waitBackup( cx, self->tag.toString(), self->stopWhenDone, &self->backupContainer, &backupUID);
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 126 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 3;
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 2, EBackupState >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 69 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 69 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 0, Version >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 155 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 192 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 1, Void >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 197 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		waitForVersion = v;
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		waitForVersion = v;
															#line 221 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(EBackupState const& backupState,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (backupState == EBackupState::STATE_COMPLETED)
															#line 392 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		{
															#line 79 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (!static_cast<WaitOnBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnBackupActorState(); static_cast<WaitOnBackupActor*>(this)->destroy(); return 0; }
															#line 396 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			new (&static_cast<WaitOnBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitOnBackupActorState();
			static_cast<WaitOnBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (backupState == EBackupState::STATE_RUNNING_DIFFERENTIAL)
															#line 406 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			{
															#line 81 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				ASSERT(!self->stopWhenDone);
															#line 82 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				;
															#line 412 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				loopDepth = a_body1cont2loopHead1(loopDepth);
			}
			else
			{
															#line 104 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				TraceEvent(SevError, "BadBackupState").detail("BackupState", BackupAgentBase::getStateText(backupState));
															#line 105 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				ASSERT(false);
															#line 106 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				if (!static_cast<WaitOnBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnBackupActorState(); static_cast<WaitOnBackupActor*>(this)->destroy(); return 0; }
															#line 423 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				new (&static_cast<WaitOnBackupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitOnBackupActorState();
				static_cast<WaitOnBackupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont2(EBackupState && backupState,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (backupState == EBackupState::STATE_COMPLETED)
															#line 437 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		{
															#line 79 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (!static_cast<WaitOnBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnBackupActorState(); static_cast<WaitOnBackupActor*>(this)->destroy(); return 0; }
															#line 441 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			new (&static_cast<WaitOnBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitOnBackupActorState();
			static_cast<WaitOnBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (backupState == EBackupState::STATE_RUNNING_DIFFERENTIAL)
															#line 451 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			{
															#line 81 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				ASSERT(!self->stopWhenDone);
															#line 82 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				;
															#line 457 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				loopDepth = a_body1cont2loopHead1(loopDepth);
			}
			else
			{
															#line 104 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				TraceEvent(SevError, "BadBackupState").detail("BackupState", BackupAgentBase::getStateText(backupState));
															#line 105 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				ASSERT(false);
															#line 106 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				if (!static_cast<WaitOnBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnBackupActorState(); static_cast<WaitOnBackupActor*>(this)->destroy(); return 0; }
															#line 468 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				new (&static_cast<WaitOnBackupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitOnBackupActorState();
				static_cast<WaitOnBackupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& backupState,int loopDepth) 
	{
		loopDepth = a_body1cont2(backupState, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && backupState,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(backupState), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 2, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 2, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 2, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 2, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_3 = self->backupContainer->describeBackup(true);
															#line 83 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 566 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 4;
															#line 83 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 3, BackupDescription >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 571 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(BackupDescription const& desc,int loopDepth) 
	{
															#line 84 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		TraceEvent("BackupVersionGate") .detail("MaxLogEndVersion", desc.maxLogEnd.present() ? desc.maxLogEnd.get() : invalidVersion) .detail("ContiguousLogEndVersion", desc.contiguousLogEnd.present() ? desc.contiguousLogEnd.get() : invalidVersion) .detail("TargetVersion", waitForVersion);
															#line 89 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() >= waitForVersion)
															#line 582 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		{
			try {
															#line 91 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				TraceEvent("DiscontinuingBackup").log();
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				StrictFuture<Void> __when_expr_4 = self->backupAgent.discontinueBackup(cx, self->tag);
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 591 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
				static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 5;
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 4, Void >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 596 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(BackupDescription && desc,int loopDepth) 
	{
															#line 84 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		TraceEvent("BackupVersionGate") .detail("MaxLogEndVersion", desc.maxLogEnd.present() ? desc.maxLogEnd.get() : invalidVersion) .detail("ContiguousLogEndVersion", desc.contiguousLogEnd.present() ? desc.contiguousLogEnd.get() : invalidVersion) .detail("TargetVersion", waitForVersion);
															#line 89 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() >= waitForVersion)
															#line 618 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		{
			try {
															#line 91 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				TraceEvent("DiscontinuingBackup").log();
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				StrictFuture<Void> __when_expr_4 = self->backupAgent.discontinueBackup(cx, self->tag);
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 627 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
				static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 5;
															#line 92 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 4, Void >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 632 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 3, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 3, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 3, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 3, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 101 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(5.0);
															#line 101 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 729 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 6;
															#line 101 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WaitOnBackupActor, 5, Void >*>(static_cast<WaitOnBackupActor*>(this)));
															#line 734 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 99 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (!static_cast<WaitOnBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnBackupActorState(); static_cast<WaitOnBackupActor*>(this)->destroy(); return 0; }
															#line 743 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		new (&static_cast<WaitOnBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitOnBackupActorState();
		static_cast<WaitOnBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			TraceEvent("ErrorDiscontinuingBackup").error(e);
															#line 95 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 758 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			{
															#line 96 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 762 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WaitOnBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitOnBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnBackupActor*>(this)->ActorCallback< WaitOnBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WaitOnBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WaitOnBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	RestoreBackupWorkload* self;
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Database cx;
															#line 64 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Version waitForVersion;
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	UID backupUID;
															#line 66 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Transaction tr;
															#line 971 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitOnBackup()
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class WaitOnBackupActor final : public Actor<Void>, public ActorCallback< WaitOnBackupActor, 0, Version >, public ActorCallback< WaitOnBackupActor, 1, Void >, public ActorCallback< WaitOnBackupActor, 2, EBackupState >, public ActorCallback< WaitOnBackupActor, 3, BackupDescription >, public ActorCallback< WaitOnBackupActor, 4, Void >, public ActorCallback< WaitOnBackupActor, 5, Void >, public FastAllocated<WaitOnBackupActor>, public WaitOnBackupActorState<WaitOnBackupActor> {
															#line 976 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitOnBackupActor>::operator new;
	using FastAllocated<WaitOnBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17073701880718472704UL, 7224235835890706944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitOnBackupActor, 0, Version >;
friend struct ActorCallback< WaitOnBackupActor, 1, Void >;
friend struct ActorCallback< WaitOnBackupActor, 2, EBackupState >;
friend struct ActorCallback< WaitOnBackupActor, 3, BackupDescription >;
friend struct ActorCallback< WaitOnBackupActor, 4, Void >;
friend struct ActorCallback< WaitOnBackupActor, 5, Void >;
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	WaitOnBackupActor(RestoreBackupWorkload* const& self,Database const& cx) 
															#line 998 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitOnBackupActorState<WaitOnBackupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitOnBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10920215433394544128UL, 14009170969253586176UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitOnBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitOnBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitOnBackupActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitOnBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitOnBackupActor, 2, EBackupState >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitOnBackupActor, 3, BackupDescription >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitOnBackupActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WaitOnBackupActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
[[nodiscard]] static Future<Void> waitOnBackup( RestoreBackupWorkload* const& self, Database const& cx ) {
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	return Future<Void>(new WaitOnBackupActor(self, cx));
															#line 1035 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
}

#line 109 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"

																#line 1040 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
// This generated class is to be used only via clearDatabase()
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
template <class ClearDatabaseActor>
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class ClearDatabaseActorState {
															#line 1046 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	ClearDatabaseActorState(Database const& cx) 
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		 : cx(cx),
															#line 111 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   tr(cx)
															#line 1055 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClearDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			;
															#line 1070 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			tr.clear(normalKeys);
															#line 116 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			for( auto& r : getSystemBackupRanges() ) {
															#line 117 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
				tr.clear(r);
															#line 1107 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			}
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1113 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 0, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1118 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1142 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 1, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 1162 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 1174 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Database cx;
															#line 111 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Transaction tr;
															#line 1348 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearDatabase()
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class ClearDatabaseActor final : public Actor<Void>, public ActorCallback< ClearDatabaseActor, 0, Void >, public ActorCallback< ClearDatabaseActor, 1, Void >, public FastAllocated<ClearDatabaseActor>, public ClearDatabaseActorState<ClearDatabaseActor> {
															#line 1353 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearDatabaseActor>::operator new;
	using FastAllocated<ClearDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16707859539218925056UL, 3632954387049133568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDatabaseActor, 0, Void >;
friend struct ActorCallback< ClearDatabaseActor, 1, Void >;
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	ClearDatabaseActor(Database const& cx) 
															#line 1371 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearDatabaseActorState<ClearDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2535882093937434112UL, 5291521835449874944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
[[nodiscard]] static Future<Void> clearDatabase( Database const& cx ) {
															#line 110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	return Future<Void>(new ClearDatabaseActor(cx));
															#line 1404 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
}

#line 126 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"

																#line 1409 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
template <class _startActor>
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class _startActorState {
															#line 1415 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	_startActorState(RestoreBackupWorkload* const& self,Database const& cx) 
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		 : self(self),
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		   cx(cx)
															#line 1424 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1441 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 1446 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->delayFor);
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1471 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1476 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		config = __config;
															#line 1485 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitOnBackup(self, cx);
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1566 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1571 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitOnBackup(self, cx);
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1582 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1587 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clearDatabase(cx);
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1673 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1678 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clearDatabase(cx);
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1689 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1694 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(self->backupAgent.restore(cx, cx, self->tag, Key(self->backupContainer->getURL()), self->backupContainer->getProxy(), WaitForComplete::True, ::invalidVersion, Verbose::True, KeyRange(), Key(), Key(), LockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1780 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1785 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(self->backupAgent.restore(cx, cx, self->tag, Key(self->backupContainer->getURL()), self->backupContainer->getProxy(), WaitForComplete::True, ::invalidVersion, Verbose::True, KeyRange(), Key(), Key(), LockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1796 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1801 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1885 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1897 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	RestoreBackupWorkload* self;
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	Database cx;
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	DatabaseConfiguration config;
															#line 1986 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1991 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10477890522068161792UL, 731250117558461696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	_startActor(RestoreBackupWorkload* const& self,Database const& cx) 
															#line 2012 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
[[nodiscard]] static Future<Void> _start( RestoreBackupWorkload* const& self, Database const& cx ) {
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 2048 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreBackup.actor.g.cpp.py_gen"
}

#line 151 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreBackup.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return clientId ? Void() : _start(this, cx); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<RestoreBackupWorkload> RestoreBackupWorkloadFactory;
