#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
/*
 * RandomMoveKeys.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/DeterministicRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MoveKeysWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "RandomMoveKeys";

	bool enabled;
	double testDuration = 10.0, meanDelay = 0.05;
	double maxKeyspace = 0.1;
	DatabaseConfiguration configuration;

	MoveKeysWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {
		enabled = !clientId && g_network->isSimulated(); // only do this on the "first" client
	}

	MoveKeysWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		enabled = !clientId && g_network->isSimulated(); // only do this on the "first" client
		meanDelay = getOption(options, "meanDelay"_sr, meanDelay);
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		maxKeyspace = getOption(options, "maxKeyspace"_sr, maxKeyspace);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	bool shouldInject(DeterministicRandom& random,
	                  const WorkloadRequest& work,
	                  const unsigned alreadyAdded) const override {
		return alreadyAdded < 1 && work.useDatabase && 0.1 / (1 + alreadyAdded) > random.random01();
	}

																#line 64 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
template <class _startActor>
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class _startActorState {
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	_startActorState(Database const& cx,MoveKeysWorkload* const& self) 
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		 : cx(cx),
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   self(self)
															#line 79 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (self->enabled)
															#line 94 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				tr = Transaction(cx);
															#line 66 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				;
															#line 100 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 89 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<int> __when_expr_2 = setDDMode(cx, 0);
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 142 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, int >*>(static_cast<_startActor*>(this)));
															#line 147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 68 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 165 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		try {
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, 1000);
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 171 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 176 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 213 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 218 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		ASSERT(res.size() < 1000);
															#line 72 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			self->configuration.set(res[i].key, res[i].value);
															#line 237 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		ASSERT(res.size() < 1000);
															#line 72 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			self->configuration.set(res[i].key, res[i].value);
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 81 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent("RMKStartModeSetting").log();
															#line 82 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeout( reportErrors(self->worker(cx, self), "MoveKeysWorkloadWorkerError"), self->testDuration, Void());
															#line 82 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 427 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 82 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 432 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& __oldMode,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		oldMode = __oldMode;
															#line 441 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && __oldMode,int loopDepth) 
	{
		oldMode = std::move(__oldMode);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent("RMKDoneMoving").log();
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(setDDMode(cx, oldMode));
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 524 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 529 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent("RMKDoneMoving").log();
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(setDDMode(cx, oldMode));
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 542 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 86 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 547 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent("RMKDoneModeSetting").log();
															#line 631 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent("RMKDoneModeSetting").log();
															#line 640 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Database cx;
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysWorkload* self;
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Transaction tr;
															#line 80 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	int oldMode;
															#line 728 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, RangeResult >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, int >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 733 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17665292355168777472UL, 1879261779636495104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, RangeResult >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, int >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	_startActor(Database const& cx,MoveKeysWorkload* const& self) 
															#line 754 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, MoveKeysWorkload* const& self ) {
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 790 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
}

#line 91 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"

	double getCheckTimeout() const override { return testDuration / 2 + 1; }
	Future<bool> check(Database const& cx) override {
		return tag(delay(testDuration / 2), true);
	} // Give the database time to recover from our damage
	void getMetrics(std::vector<PerfMetric>& m) override {}

	KeyRange getRandomKeys() const {
		double len = deterministicRandom()->random01() * this->maxKeyspace;
		double pos = deterministicRandom()->random01() * (1.0 - len);
		return KeyRangeRef(doubleToTestKey(pos), doubleToTestKey(pos + len));
	}

	std::vector<StorageServerInterface> getRandomTeam(std::vector<StorageServerInterface> storageServers,
	                                                  int teamSize) {
		if (storageServers.size() < teamSize) {
			TraceEvent(SevWarnAlways, "LessThanThreeStorageServers").log();
			throw operation_failed();
		}

		deterministicRandom()->randomShuffle(storageServers);

		std::set<StorageServerInterface> t;
		std::set<Optional<Standalone<StringRef>>> machines;
		std::set<Optional<Standalone<StringRef>>> dataHalls;
		while (t.size() < teamSize && storageServers.size()) {
			auto s = storageServers.back();
			storageServers.pop_back();
			if (!machines.contains(s.locality.zoneId()) &&
			    (!s.locality.dataHallId().present() || !dataHalls.contains(s.locality.dataHallId()))) {
				machines.insert(s.locality.zoneId());
				dataHalls.insert(s.locality.dataHallId());
				t.insert(s);
			}
		}

		if (t.size() < teamSize) {
			TraceEvent(SevWarnAlways, "LessThanUniqueMachines")
			    .detail("TargetTeamSize", teamSize)
			    .detail("TeamSelected", t.size());
			throw operation_failed();
		}

		return std::vector<StorageServerInterface>(t.begin(), t.end());
	}

																#line 840 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via doMoveKeys()
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
template <class DoMoveKeysActor>
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class DoMoveKeysActorState {
															#line 846 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	DoMoveKeysActorState(Database const& cx,MoveKeysWorkload* const& self,KeyRange const& keys,std::vector<StorageServerInterface> const& destinationTeam,MoveKeysLock const& lock) 
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		 : cx(cx),
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   self(self),
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   keys(keys),
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   destinationTeam(destinationTeam),
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   lock(lock),
															#line 142 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   relocateShardInterval("RelocateShard"),
															#line 143 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   fl1(1),
															#line 144 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   fl2(1)
															#line 867 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~DoMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("doMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			std::string desc;
															#line 146 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			for(int s = 0;s < destinationTeam.size();s++) {
															#line 147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				desc += format("%s (%llx),", destinationTeam[s].address().toString().c_str(), destinationTeam[s].id().first());
															#line 886 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			}
															#line 149 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			std::vector<UID> destinationTeamIDs;
															#line 150 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			destinationTeamIDs.reserve(destinationTeam.size());
															#line 151 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			for(int s = 0;s < destinationTeam.size();s++) {
															#line 152 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				destinationTeamIDs.push_back(destinationTeam[s].id());
															#line 896 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			}
															#line 154 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			TraceEvent(relocateShardInterval.begin()) .detail("KeyBegin", printable(keys.begin)) .detail("KeyEnd", printable(keys.end)) .detail("Priority", 0) .detail("Source", "RandomMoveKeys") .detail("DestinationTeam", desc);
															#line 900 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			try {
															#line 162 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				signal = Promise<Void>();
															#line 163 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				ddEnabledState = DDEnabledState();
															#line 164 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				std::unique_ptr<MoveKeysParams> params;
															#line 165 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 910 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				{
															#line 166 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
					UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 174 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
					params = std::make_unique<MoveKeysParams>(dataMoveId, std::vector<KeyRange>{ keys }, destinationTeamIDs, destinationTeamIDs, lock, signal, &fl1, &fl2, false, relocateShardInterval.pairID, &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 916 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				}
				else
				{
															#line 188 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
					UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 193 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
					params = std::make_unique<MoveKeysParams>(dataMoveId, keys, destinationTeamIDs, destinationTeamIDs, lock, signal, &fl1, &fl2, false, relocateShardInterval.pairID, &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 924 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				}
															#line 207 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = moveKeys(cx, *params);
															#line 207 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				if (static_cast<DoMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 930 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 207 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoMoveKeysActor, 0, Void >*>(static_cast<DoMoveKeysActor*>(this)));
															#line 935 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoMoveKeysActorState();
		static_cast<DoMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			TraceEvent(relocateShardInterval.end(), self->dbInfo->get().master.id()).errorUnsuppressed(e);
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 967 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent(relocateShardInterval.end()).detail("Result", "Success");
															#line 209 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (!static_cast<DoMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoMoveKeysActorState(); static_cast<DoMoveKeysActor*>(this)->destroy(); return 0; }
															#line 983 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		new (&static_cast<DoMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoMoveKeysActorState();
		static_cast<DoMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		TraceEvent(relocateShardInterval.end()).detail("Result", "Success");
															#line 209 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (!static_cast<DoMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoMoveKeysActorState(); static_cast<DoMoveKeysActor*>(this)->destroy(); return 0; }
															#line 997 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		new (&static_cast<DoMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoMoveKeysActorState();
		static_cast<DoMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<DoMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<DoMoveKeysActor*>(this)->ActorCallback< DoMoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoMoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoMoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoMoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Database cx;
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysWorkload* self;
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	KeyRange keys;
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	std::vector<StorageServerInterface> destinationTeam;
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 142 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	TraceInterval relocateShardInterval;
															#line 143 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	FlowLock fl1;
															#line 144 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	FlowLock fl2;
															#line 162 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Promise<Void> signal;
															#line 163 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	DDEnabledState ddEnabledState;
															#line 1100 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doMoveKeys()
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class DoMoveKeysActor final : public Actor<Void>, public ActorCallback< DoMoveKeysActor, 0, Void >, public FastAllocated<DoMoveKeysActor>, public DoMoveKeysActorState<DoMoveKeysActor> {
															#line 1105 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoMoveKeysActor>::operator new;
	using FastAllocated<DoMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14135374732502046464UL, 3365301521899351808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoMoveKeysActor, 0, Void >;
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	DoMoveKeysActor(Database const& cx,MoveKeysWorkload* const& self,KeyRange const& keys,std::vector<StorageServerInterface> const& destinationTeam,MoveKeysLock const& lock) 
															#line 1122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoMoveKeysActorState<DoMoveKeysActor>(cx, self, keys, destinationTeam, lock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4446690079883309056UL, 2833590648757559552UL);
		ActorExecutionContextHelper __helper(static_cast<DoMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoMoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
[[nodiscard]] Future<Void> doMoveKeys( Database const& cx, MoveKeysWorkload* const& self, KeyRange const& keys, std::vector<StorageServerInterface> const& destinationTeam, MoveKeysLock const& lock ) {
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	return Future<Void>(new DoMoveKeysActor(cx, self, keys, destinationTeam, lock));
															#line 1154 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
}

#line 215 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"

	static void eliminateDuplicates(std::vector<StorageServerInterface>& servers) {
		// The real data distribution algorithm doesn't want to deal with multiple servers
		// with the same address having keys.  So if there are two servers with the same address,
		// don't use either one (so we don't have to find out which of them, if any, already has keys).
		// Also get rid of tss since we don't want to move a shard to a tss.
		std::map<NetworkAddress, int> count;
		for (int s = 0; s < servers.size(); s++)
			count[servers[s].address()]++;
		int o = 0;
		for (int s = 0; s < servers.size(); s++)
			if (count[servers[s].address()] == 1 && !servers[s].isTss())
				servers[o++] = servers[s];
		servers.resize(o);
	}

																#line 1174 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via forceMasterFailure()
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
template <class ForceMasterFailureActor>
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class ForceMasterFailureActorState {
															#line 1180 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	ForceMasterFailureActorState(Database const& cx,MoveKeysWorkload* const& self) 
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		 : cx(cx),
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   self(self)
															#line 1189 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("forceMasterFailure", reinterpret_cast<unsigned long>(this));

	}
	~ForceMasterFailureActorState() 
	{
		fdb_probe_actor_destroy("forceMasterFailure", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 232 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 233 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			;
															#line 1206 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForceMasterFailureActorState();
		static_cast<ForceMasterFailureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (g_simulator->killZone(self->dbInfo->get().master.locality.zoneId(), ISimulator::KillType::Reboot, true))
															#line 1236 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		{
															#line 235 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (!static_cast<ForceMasterFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForceMasterFailureActorState(); static_cast<ForceMasterFailureActor*>(this)->destroy(); return 0; }
															#line 1240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			new (&static_cast<ForceMasterFailureActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForceMasterFailureActorState();
			static_cast<ForceMasterFailureActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 236 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 236 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<ForceMasterFailureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1250 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ForceMasterFailureActor*>(this)->actor_wait_state = 1;
															#line 236 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForceMasterFailureActor, 0, Void >*>(static_cast<ForceMasterFailureActor*>(this)));
															#line 1255 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForceMasterFailureActor*>(this)->actor_wait_state > 0) static_cast<ForceMasterFailureActor*>(this)->actor_wait_state = 0;
		static_cast<ForceMasterFailureActor*>(this)->ActorCallback< ForceMasterFailureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForceMasterFailureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMasterFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForceMasterFailureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMasterFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForceMasterFailureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMasterFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMasterFailure", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Database cx;
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysWorkload* self;
															#line 1351 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via forceMasterFailure()
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class ForceMasterFailureActor final : public Actor<Void>, public ActorCallback< ForceMasterFailureActor, 0, Void >, public FastAllocated<ForceMasterFailureActor>, public ForceMasterFailureActorState<ForceMasterFailureActor> {
															#line 1356 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<ForceMasterFailureActor>::operator new;
	using FastAllocated<ForceMasterFailureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4595006699399309824UL, 15354556244541993472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForceMasterFailureActor, 0, Void >;
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	ForceMasterFailureActor(Database const& cx,MoveKeysWorkload* const& self) 
															#line 1373 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ForceMasterFailureActorState<ForceMasterFailureActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forceMasterFailure", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17427374142584052992UL, 6573441870990801664UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMasterFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forceMasterFailure");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forceMasterFailure", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForceMasterFailureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
[[nodiscard]] Future<Void> forceMasterFailure( Database const& cx, MoveKeysWorkload* const& self ) {
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	return Future<Void>(new ForceMasterFailureActor(cx, self));
															#line 1405 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
}

#line 239 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"

																#line 1410 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via worker()
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
template <class WorkerActor>
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class WorkerActorState {
															#line 1416 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	WorkerActorState(Database const& cx,MoveKeysWorkload* const& self) 
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		 : cx(cx),
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   self(self),
															#line 241 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   inFlight(),
															#line 242 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   inFlightActors(),
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		   lastTime(now())
															#line 1431 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("worker", reinterpret_cast<unsigned long>(this));

	}
	~WorkerActorState() 
	{
		fdb_probe_actor_destroy("worker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			ASSERT(self->configuration.storageTeamSize > 0);
															#line 247 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (self->configuration.usableRegions > 1)
															#line 1448 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			{
															#line 248 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				if (!static_cast<WorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerActorState(); static_cast<WorkerActor*>(this)->destroy(); return 0; }
															#line 1452 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
				new (&static_cast<WorkerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WorkerActorState();
				static_cast<WorkerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			;
															#line 1460 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			StrictFuture<MoveKeysLock> __when_expr_0 = takeMoveKeysLock(cx, UID());
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1493 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 0, MoveKeysLock >*>(static_cast<WorkerActor*>(this)));
															#line 1498 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 275 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (e.code() != error_code_movekeys_conflict && e.code() != error_code_operation_failed)
															#line 1520 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			{
															#line 276 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1524 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			}
															#line 277 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 277 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1530 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WorkerActor*>(this)->actor_wait_state = 4;
															#line 277 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 3, Void >*>(static_cast<WorkerActor*>(this)));
															#line 1535 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1552 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 2;
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >*>(static_cast<WorkerActor*>(this)));
															#line 1557 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(MoveKeysLock const& __lock,int loopDepth) 
	{
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		lock = __lock;
															#line 1566 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MoveKeysLock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 0, MoveKeysLock >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, MoveKeysLock >*,MoveKeysLock const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, MoveKeysLock >*,MoveKeysLock && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerActor, 0, MoveKeysLock >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 255 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		eliminateDuplicates(storageServers);
															#line 257 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		;
															#line 1647 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		storageServers = __storageServers;
															#line 1656 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 258 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_2 = poisson(&lastTime, self->meanDelay);
															#line 258 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1744 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 3;
															#line 258 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 2, Void >*>(static_cast<WorkerActor*>(this)));
															#line 1749 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		KeyRange keys = self->getRandomKeys();
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		std::vector<StorageServerInterface> team = self->getRandomTeam(storageServers, self->configuration.storageTeamSize);
															#line 265 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		std::vector<KeyRange> ranges;
															#line 266 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlightActors.getRangesAffectedByInsertion(keys, ranges);
															#line 267 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlightActors.cancel(KeyRangeRef(ranges.front().begin, ranges.back().end));
															#line 268 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlight.insert(keys, team);
															#line 269 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		for(int r = 0;r < ranges.size();r++) {
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			auto& rTeam = inFlight.rangeContaining(ranges[r].begin)->value();
															#line 271 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			inFlightActors.insert(ranges[r], self->doMoveKeys(cx, self, ranges[r], rTeam, lock));
															#line 1774 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		KeyRange keys = self->getRandomKeys();
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		std::vector<StorageServerInterface> team = self->getRandomTeam(storageServers, self->configuration.storageTeamSize);
															#line 265 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		std::vector<KeyRange> ranges;
															#line 266 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlightActors.getRangesAffectedByInsertion(keys, ranges);
															#line 267 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlightActors.cancel(KeyRangeRef(ranges.front().begin, ranges.back().end));
															#line 268 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		inFlight.insert(keys, team);
															#line 269 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
		for(int r = 0;r < ranges.size();r++) {
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			auto& rTeam = inFlight.rangeContaining(ranges[r].begin)->value();
															#line 271 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
			inFlightActors.insert(ranges[r], self->doMoveKeys(cx, self, ranges[r], rTeam, lock));
															#line 1800 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	Database cx;
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysWorkload* self;
															#line 241 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	KeyRangeMap<std::vector<StorageServerInterface>> inFlight;
															#line 242 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	KeyRangeActorMap inFlightActors;
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	double lastTime;
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 254 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 1982 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via worker()
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
class WorkerActor final : public Actor<Void>, public ActorCallback< WorkerActor, 0, MoveKeysLock >, public ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< WorkerActor, 2, Void >, public ActorCallback< WorkerActor, 3, Void >, public FastAllocated<WorkerActor>, public WorkerActorState<WorkerActor> {
															#line 1987 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerActor>::operator new;
	using FastAllocated<WorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9299545021648918528UL, 13070985984006385408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerActor, 0, MoveKeysLock >;
friend struct ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< WorkerActor, 2, Void >;
friend struct ActorCallback< WorkerActor, 3, Void >;
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	WorkerActor(Database const& cx,MoveKeysWorkload* const& self) 
															#line 2007 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerActorState<WorkerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9305151550442981632UL, 410782307204870400UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("worker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerActor, 0, MoveKeysLock >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
[[nodiscard]] Future<Void> worker( Database const& cx, MoveKeysWorkload* const& self ) {
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
	return Future<Void>(new WorkerActor(cx, self));
															#line 2042 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomMoveKeys.actor.g.cpp.py_gen"
}

#line 282 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/RandomMoveKeys.actor.cpp"
};

WorkloadFactory<MoveKeysWorkload> MoveKeysWorkloadFactory;
FailureInjectorFactory<MoveKeysWorkload> MoveKeysFailureInjectionFactory;
