#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
/*
 * PrivateEndpoints.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace {

struct PrivateEndpoints : TestWorkload {
	static constexpr auto NAME = "PrivateEndpoints";

	bool success = true;
	int numSuccesses = 0;
	double startAfter;
	double runFor;

	std::vector<std::function<Future<Void>(Reference<AsyncVar<ClientDBInfo>> const&)>> testFunctions;

	template <class T>
	static Optional<T> getRandom(std::vector<T> const& v) {
		if (v.empty()) {
			return Optional<T>();
		} else {
			return deterministicRandom()->randomChoice(v);
		}
	}

	template <class T>
	static Optional<T> getInterface(Reference<AsyncVar<ClientDBInfo>> const& clientDBInfo) {
		if constexpr (std::is_same_v<T, GrvProxyInterface>) {
			return getRandom(clientDBInfo->get().grvProxies);
		} else if constexpr (std::is_same_v<T, CommitProxyInterface>) {
			return getRandom(clientDBInfo->get().commitProxies);
		} else {
			ASSERT(false); // don't know how to handle this type
		}
	}

																#line 59 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
// This generated class is to be used only via assumeFailure()
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
template <class T, class AssumeFailureActor>
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
class AssumeFailureActorState {
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
public:
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	AssumeFailureActorState(Future<T> const& f) 
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		 : f(f)
															#line 72 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("assumeFailure", reinterpret_cast<unsigned long>(this));

	}
	~AssumeFailureActorState() 
	{
		fdb_probe_actor_destroy("assumeFailure", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 60 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
				StrictFuture<T> __when_expr_0 = f;
															#line 60 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
				if (static_cast<AssumeFailureActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 90 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AssumeFailureActor*>(this)->actor_wait_state = 1;
															#line 60 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssumeFailureActor, 0, T >*>(static_cast<AssumeFailureActor*>(this)));
															#line 95 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssumeFailureActorState();
		static_cast<AssumeFailureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 76 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (!static_cast<AssumeFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssumeFailureActorState(); static_cast<AssumeFailureActor*>(this)->destroy(); return 0; }
															#line 124 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		new (&static_cast<AssumeFailureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssumeFailureActorState();
		static_cast<AssumeFailureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 64 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 141 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			}
			else
			{
															#line 66 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
				if (e.code() == error_code_unauthorized_attempt)
															#line 147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
				{
															#line 67 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
					TraceEvent("SuccessPrivateEndpoint").log();
															#line 151 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
				}
				else
				{
															#line 68 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
					if (e.code() == error_code_request_maybe_delivered)
															#line 157 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
					{
															#line 71 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
						TraceEvent("SuccessRequestMaybeDelivered").log();
															#line 161 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
					}
					else
					{
															#line 73 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
						TraceEvent(SevError, "WrongErrorCode").error(e);
															#line 167 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
					}
				}
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 61 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		(void)t;
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		ASSERT(false);
															#line 187 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 61 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		(void)t;
															#line 62 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		ASSERT(false);
															#line 198 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssumeFailureActor*>(this)->actor_wait_state > 0) static_cast<AssumeFailureActor*>(this)->actor_wait_state = 0;
		static_cast<AssumeFailureActor*>(this)->ActorCallback< AssumeFailureActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< AssumeFailureActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("assumeFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssumeFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assumeFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssumeFailureActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("assumeFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssumeFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assumeFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssumeFailureActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("assumeFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssumeFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assumeFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	Future<T> f;
															#line 293 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
};
// This generated class is to be used only via assumeFailure()
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
template <class T>
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
class AssumeFailureActor final : public Actor<Void>, public ActorCallback< AssumeFailureActor<T>, 0, T >, public FastAllocated<AssumeFailureActor<T>>, public AssumeFailureActorState<T, AssumeFailureActor<T>> {
															#line 300 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
public:
	using FastAllocated<AssumeFailureActor<T>>::operator new;
	using FastAllocated<AssumeFailureActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7198980690859164672UL, 6057177127574534912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssumeFailureActor<T>, 0, T >;
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	AssumeFailureActor(Future<T> const& f) 
															#line 317 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AssumeFailureActorState<T, AssumeFailureActor<T>>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assumeFailure", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4402581257245715968UL, 2660334323062738176UL);
		ActorExecutionContextHelper __helper(static_cast<AssumeFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assumeFailure");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assumeFailure", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssumeFailureActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
template <class T>
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
[[nodiscard]] static Future<Void> assumeFailure( Future<T> const& f ) {
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	return Future<Void>(new AssumeFailureActor<T>(f));
															#line 351 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
}

#line 78 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"

	template <class I, class RT>
	void addTestFor(RequestStream<RT, false> I::* channel) {
		testFunctions.push_back([channel](Reference<AsyncVar<ClientDBInfo>> const& clientDBInfo) {
			auto optintf = getInterface<I>(clientDBInfo);
			if (!optintf.present()) {
				return clientDBInfo->onChange();
			}
			RequestStream<RT> s = optintf.get().*channel;
			RT req;
			return assumeFailure(deterministicRandom()->coinflip() ? throwErrorOr(s.tryGetReply(req))
			                                                       : s.getReply(req));
		});
	}

	explicit PrivateEndpoints(WorkloadContext const& wcx) : TestWorkload(wcx) {
		// The commented out request streams below can't be default initialized properly
		// as they won't initialize all of their memory which causes valgrind to complain.
		startAfter = getOption(options, "startAfter"_sr, 10.0);
		runFor = getOption(options, "runFor"_sr, 10.0);
		addTestFor(&GrvProxyInterface::waitFailure);
		addTestFor(&GrvProxyInterface::getHealthMetrics);
		// addTestFor(&CommitProxyInterface::getStorageServerRejoinInfo);
		addTestFor(&CommitProxyInterface::waitFailure);
		// addTestFor(&CommitProxyInterface::txnState);
		// addTestFor(&CommitProxyInterface::getHealthMetrics);
		// addTestFor(&CommitProxyInterface::proxySnapReq);
		addTestFor(&CommitProxyInterface::exclusionSafetyCheckReq);
		// addTestFor(&CommitProxyInterface::getDDMetrics);
	}
	Future<Void> start(Database const& cx) override { return _start(this, cx); }
	Future<bool> check(Database const& cx) override { return success; }
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Successes", double(numSuccesses), Averaged::True);
	}

																#line 391 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
template <class _startActor>
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
class _startActorState {
															#line 397 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
public:
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	_startActorState(PrivateEndpoints* const& self,Database const& cx) 
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		 : self(self),
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		   cx(cx),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		   clientInfo(cx->clientInfo),
															#line 116 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		   end()
															#line 410 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			TraceEvent("PrivateEndpointTestStartWait").detail("WaitTime", self->startAfter).log();
															#line 118 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startAfter);
															#line 118 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 429 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 434 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		TraceEvent("PrivateEndpointTestStart").detail("RunFor", self->runFor).log();
															#line 120 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		end = delay(self->runFor);
															#line 459 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		try {
															#line 122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			;
															#line 463 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 119 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		TraceEvent("PrivateEndpointTestStart").detail("RunFor", self->runFor).log();
															#line 120 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		end = delay(self->runFor);
															#line 480 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		try {
															#line 122 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			;
															#line 484 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 139 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		UNREACHABLE();
															#line 140 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 576 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 136 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			TraceEvent(SevError, "PrivateEndpointTestError").errorUnsuppressed(e);
															#line 137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
			ASSERT(false);
															#line 591 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		auto testFuture = deterministicRandom()->randomChoice(self->testFunctions)(cx->clientInfo);
															#line 125 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		StrictFuture<Void> __when_expr_1 = end;
															#line 124 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 617 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		StrictFuture<Void> __when_expr_2 = testFuture;
															#line 621 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 628 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.2);
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 639 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 644 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		TraceEvent("PrivateEndpointTestDone").log();
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 655 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		TraceEvent("PrivateEndpointTestDone").log();
															#line 127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 669 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		++self->numSuccesses;
															#line 681 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
		++self->numSuccesses;
															#line 690 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	PrivateEndpoints* self;
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	Database cx;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	Reference<AsyncVar<ClientDBInfo>> clientInfo;
															#line 116 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	Future<Void> end;
															#line 911 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 916 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18388511472059542528UL, 7374648057037212160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	_startActor(PrivateEndpoints* const& self,Database const& cx) 
															#line 936 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
[[nodiscard]] static Future<Void> _start( PrivateEndpoints* const& self, Database const& cx ) {
															#line 114 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 970 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PrivateEndpoints.actor.g.cpp.py_gen"
}

#line 142 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/PrivateEndpoints.actor.cpp"
};

} // namespace

WorkloadFactory<PrivateEndpoints> PrivateEndpointsFactory(UntrustedMode::True);
