#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
/*
 * ExternalWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/ThreadHelper.actor.h"
#include "flow/Platform.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "foundationdb/CppWorkload.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // has to be last include

extern void flushTraceFileVoid();

namespace {

template <class T>
struct FDBPromiseImpl : FDBPromise {
	Promise<T> impl;
	FDBPromiseImpl(Promise<T> impl) : impl(impl) {}
	void send(void* value) override {
		if (g_network->isOnMainThread()) {
			impl.send(*reinterpret_cast<T*>(value));
		} else {
			onMainThreadVoid([impl = impl, val = *reinterpret_cast<T*>(value)]() -> Future<Void> {
				impl.send(val);
				return Void();
			});
		}
	}
};

															#line 51 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via keepAlive()
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
template <class F, class T, class KeepAliveActor>
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
class KeepAliveActorState {
															#line 57 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
public:
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	KeepAliveActorState(F const& until,T const& db) 
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		 : until(until),
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		   db(db)
															#line 66 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("keepAlive", reinterpret_cast<unsigned long>(this));

	}
	~KeepAliveActorState() 
	{
		fdb_probe_actor_destroy("keepAlive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 52 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(until);
															#line 52 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 84 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
				static_cast<KeepAliveActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KeepAliveActor, 0, Void >*>(static_cast<KeepAliveActor*>(this)));
															#line 88 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<KeepAliveActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KeepAliveActor*>(this)->actor_wait_state > 0) static_cast<KeepAliveActor*>(this)->actor_wait_state = 0;
		static_cast<KeepAliveActor*>(this)->ActorCallback< KeepAliveActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KeepAliveActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("keepAlive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeepAliveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keepAlive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KeepAliveActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("keepAlive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeepAliveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keepAlive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KeepAliveActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("keepAlive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KeepAliveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keepAlive", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		delete static_cast<KeepAliveActor*>(this);
															#line 235 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	F until;
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	T db;
															#line 244 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via keepAlive()
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
template <class F, class T>
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
class KeepAliveActor final : public Actor<void>, public ActorCallback< KeepAliveActor<F, T>, 0, Void >, public FastAllocated<KeepAliveActor<F, T>>, public KeepAliveActorState<F, T, KeepAliveActor<F, T>> {
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<KeepAliveActor<F, T>>::operator new;
	using FastAllocated<KeepAliveActor<F, T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16012433241009059584UL, 4543665086035078912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< KeepAliveActor<F, T>, 0, Void >;
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	KeepAliveActor(F const& until,T const& db) 
															#line 268 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   KeepAliveActorState<F, T, KeepAliveActor<F, T>>(until, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("keepAlive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13122599547470274560UL, 12690242981619364608UL);
		ActorExecutionContextHelper __helper(static_cast<KeepAliveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("keepAlive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("keepAlive", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
template <class F, class T>
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
void keepAlive( F const& until, T const& db ) {
															#line 49 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	new KeepAliveActor<F, T>(until, db);
															#line 293 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
}

#line 56 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"

struct FDBLoggerImpl : FDBLogger {
	static FDBLogger* instance() {
		static FDBLoggerImpl impl;
		return &impl;
	}
	void trace(FDBSeverity sev,
	           const std::string& name,
	           const std::vector<std::pair<std::string, std::string>>& details) override {
		auto traceFun = [=]() -> Future<Void> {
			Severity severity;
			switch (sev) {
			case FDBSeverity::Debug:
				severity = SevDebug;
				break;
			case FDBSeverity::Info:
				severity = SevInfo;
				break;
			case FDBSeverity::Warn:
				severity = SevWarn;
				break;
			case FDBSeverity::WarnAlways:
				severity = SevWarnAlways;
				break;
			case FDBSeverity::Error:
				severity = SevError;
				break;
			}
			TraceEvent evt(severity, name.c_str());
			for (const auto& p : details) {
				evt.detail(p.first.c_str(), p.second);
			}
			return Void();
		};
		if (g_network->isOnMainThread()) {
			traceFun();
			flushTraceFileVoid();
		} else {
			onMainThreadVoid([traceFun]() -> Future<Void> {
				traceFun();
				flushTraceFileVoid();
				return Void();
			});
		}
	}
};

namespace capi {
#include "foundationdb/CWorkload.h"
}
namespace translator {
template <typename T>
struct Wrapper {
	T inner;
};

namespace metrics {
void reserve(capi::OpaqueMetrics* c_metrics, int n) {
	auto metrics = (std::vector<FDBPerfMetric>*)c_metrics;
	metrics->reserve(metrics->size() + n);
}
void push(capi::OpaqueMetrics* c_metrics, capi::FDBMetric c_metric) {
	auto metrics = (std::vector<FDBPerfMetric>*)c_metrics;
	auto fmt = c_metric.fmt ? c_metric.fmt : "%.3g";
	auto metric = FDBPerfMetric{
		.name = std::string(c_metric.key),
		.value = c_metric.val,
		.averaged = c_metric.avg,
		.format_code = std::string(fmt),
	};
	metrics->emplace_back(metric);
}
capi::FDBMetrics wrap(std::vector<FDBPerfMetric>* metrics) {
	static capi::FDBMetrics::FDBMetrics_VT vt = {
		.reserve = reserve,
		.push = push,
	};
	return capi::FDBMetrics{
		.inner = (capi::OpaqueMetrics*)metrics,
		.vt = &vt,
	};
}
} // namespace metrics

namespace promise {
void send(capi::OpaquePromise* c_promise, bool value) {
	auto promise = (Wrapper<GenericPromise<bool>>*)c_promise;
	promise->inner.send(value);
}
void free(capi::OpaquePromise* c_promise) {
	auto promise = (Wrapper<GenericPromise<bool>>*)c_promise;
	delete promise;
}
capi::FDBPromise wrap(GenericPromise<bool> promise) {
	static capi::FDBPromise::FDBPromise_VT vt{
		.free = free,
		.send = send,
	};
	auto wrapped = new Wrapper<GenericPromise<bool>>{ promise };
	return capi::FDBPromise{
		.inner = (capi::OpaquePromise*)wrapped,
		.vt = &vt,
	};
}
} // namespace promise

namespace context {
void trace(capi::OpaqueWorkloadContext* c_context,
           capi::FDBSeverity c_severity,
           const char* name,
           const capi::FDBStringPair* c_details,
           int n) {
	auto context = (FDBWorkloadContext*)c_context;
	FDBSeverity severity;
	switch (c_severity) {
	case capi::FDBSeverity_Debug:
		severity = FDBSeverity::Debug;
		break;
	case capi::FDBSeverity_Info:
		severity = FDBSeverity::Info;
		break;
	case capi::FDBSeverity_Warn:
		severity = FDBSeverity::Warn;
		break;
	case capi::FDBSeverity_WarnAlways:
		severity = FDBSeverity::WarnAlways;
		break;
	case capi::FDBSeverity_Error:
		severity = FDBSeverity::Error;
		break;
	}
	std::vector<std::pair<std::string, std::string>> details;
	details.reserve(n);
	for (int i = 0; i < n; i++) {
		details.emplace_back(std::pair<std::string, std::string>(c_details[i].key, c_details[i].val));
	}
	context->trace(severity, name, details);
}
uint64_t getProcessID(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->getProcessID();
}
void setProcessID(capi::OpaqueWorkloadContext* c_context, uint64_t processID) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->setProcessID(processID);
}
double now(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->now();
}
uint32_t rnd(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->rnd();
}
capi::FDBString getOption(capi::OpaqueWorkloadContext* c_context, const char* name, const char* defaultValue) {
	static capi::FDBString::FDBString_VT vt{
		.free = (void (*)(const char*))free,
	};
	auto context = (FDBWorkloadContext*)c_context;
	std::string value = context->getOption(name, std::string(defaultValue));
	size_t len = value.length() + 1;
	char* c_value = (char*)malloc(len);
	memcpy(c_value, value.c_str(), len);
	return capi::FDBString{
		.inner = c_value,
		.vt = &vt,
	};
}
int clientId(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->clientId();
}
int clientCount(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->clientCount();
}
int64_t sharedRandomNumber(capi::OpaqueWorkloadContext* c_context) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->sharedRandomNumber();
}
FDBFuture* delay(capi::OpaqueWorkloadContext* c_context, double seconds) {
	auto context = (FDBWorkloadContext*)c_context;
	return context->delay(seconds);
}
capi::FDBWorkloadContext wrap(FDBWorkloadContext* context) {
	static capi::FDBWorkloadContext::FDBWorkloadContext_VT vt{
		.trace = trace,
		.getProcessID = getProcessID,
		.setProcessID = setProcessID,
		.now = now,
		.rnd = rnd,
		.getOption = getOption,
		.clientId = clientId,
		.clientCount = clientCount,
		.sharedRandomNumber = sharedRandomNumber,
		.delay = delay,
	};
	return capi::FDBWorkloadContext{
		.api_version = FDB_WORKLOAD_API_VERSION,
		.inner = (capi::OpaqueWorkloadContext*)context,
		.vt = &vt,
	};
}
} // namespace context

class Workload : public FDBWorkload {
private:
	capi::OpaqueWorkload* inner;
	capi::FDBWorkload::FDBWorkload_VT* vt;

public:
	Workload(capi::FDBWorkload c_workload) : inner(c_workload.inner), vt(c_workload.vt) {}
	~Workload() { this->vt->free(this->inner); }

	virtual bool init(FDBWorkloadContext* context) override { return true; }
	virtual void setup(FDBDatabase* db, GenericPromise<bool> done) override {
		return this->vt->setup(this->inner, (capi::FDBDatabase*)db, promise::wrap(done));
	}
	virtual void start(FDBDatabase* db, GenericPromise<bool> done) override {
		return this->vt->start(this->inner, (capi::FDBDatabase*)db, promise::wrap(done));
	}
	virtual void check(FDBDatabase* db, GenericPromise<bool> done) override {
		return this->vt->check(this->inner, (capi::FDBDatabase*)db, promise::wrap(done));
	}
	virtual void getMetrics(std::vector<FDBPerfMetric>& out) const override {
		this->vt->getMetrics(this->inner, metrics::wrap(&out));
	}
	virtual double getCheckTimeout() override { return this->vt->getCheckTimeout(this->inner); }
};
} // namespace translator

struct ExternalWorkload : TestWorkload, FDBWorkloadContext {
	std::string libraryName, libraryPath;
	bool success = true;
	void* library = nullptr;
	std::shared_ptr<FDBWorkload> workloadImpl;

	constexpr static auto NAME = "External";

	static std::string getDefaultLibraryPath() {
		auto self = exePath();
		// we try to resolve self/../../share/foundationdb/libame.so
		return abspath(joinPath(joinPath(popPath(popPath(self)), "share"), "foundationdb"));
	}

	static std::string toLibName(const std::string& name) {
#if defined(__unixish__) && !defined(__APPLE__)
		return format("lib%s.so", name.c_str());
#elif defined(__APPLE__)
		return format("lib%s.dylib", name.c_str());
#elif defined(_WIN32)
		return format("lib%s.dll", name.c_str());
#else
#error Port me!
#endif
	}

	explicit ExternalWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		bool useCAPI = ::getOption(options, "useCAPI"_sr, false);
		libraryName = ::getOption(options, "libraryName"_sr, ""_sr).toString();
		libraryPath = ::getOption(options, "libraryPath"_sr, Value(getDefaultLibraryPath())).toString();
		auto wName = ::getOption(options, "workloadName"_sr, ""_sr);
		auto fullPath = joinPath(libraryPath, toLibName(libraryName));
		TraceEvent("ExternalWorkloadLoad")
		    .detail("LibraryName", libraryName)
		    .detail("LibraryPath", fullPath)
		    .detail("WorkloadName", wName);
		library = loadLibrary(fullPath.c_str());
		if (library == nullptr) {
			TraceEvent(SevError, "ExternalWorkloadLoadError").log();
			success = false;
			return;
		}

		if (useCAPI) {
			capi::FDBWorkload (*workloadCFactory)(const char*, capi::FDBWorkloadContext);
			workloadCFactory = reinterpret_cast<decltype(workloadCFactory)>(loadFunction(library, "workloadCFactory"));
			if (workloadCFactory == nullptr) {
				TraceEvent(SevError, "ExternalCFactoryNotFound").log();
				success = false;
				return;
			}
			auto name = wName.toString();
			capi::FDBWorkload c_workload = (*workloadCFactory)(name.c_str(), translator::context::wrap(this));
			workloadImpl = std::make_shared<translator::Workload>(c_workload);
		} else {
			FDBWorkloadFactory* (*workloadFactory)(FDBLogger*);
			workloadFactory = reinterpret_cast<decltype(workloadFactory)>(loadFunction(library, "workloadFactory"));
			if (workloadFactory == nullptr) {
				TraceEvent(SevError, "ExternalFactoryNotFound").log();
				success = false;
				return;
			}
			workloadImpl = (*workloadFactory)(FDBLoggerImpl::instance())->create(wName.toString());
			if (!workloadImpl) {
				TraceEvent(SevError, "WorkloadNotFound").log();
				success = false;
				return;
			}
		}
		workloadImpl->init(this);
	}

	~ExternalWorkload() override {
		workloadImpl = nullptr;
		if (library) {
			closeLibrary(library);
		}
	}

																#line 607 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via assertTrue()
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
template <class AssertTrueActor>
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
class AssertTrueActorState {
															#line 613 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
public:
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	AssertTrueActorState(StringRef const& stage,Future<bool> const& f) 
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		 : stage(stage),
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		   f(f)
															#line 622 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("assertTrue", reinterpret_cast<unsigned long>(this));

	}
	~AssertTrueActorState() 
	{
		fdb_probe_actor_destroy("assertTrue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 367 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = f;
															#line 367 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
			if (static_cast<AssertTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 639 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AssertTrueActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssertTrueActor, 0, bool >*>(static_cast<AssertTrueActor*>(this)));
															#line 644 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssertTrueActorState();
		static_cast<AssertTrueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& res,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		if (!res)
															#line 667 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
			TraceEvent(SevError, "ExternalWorkloadFailure").detail("Stage", stage);
															#line 671 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		}
															#line 371 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		if (!static_cast<AssertTrueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssertTrueActorState(); static_cast<AssertTrueActor*>(this)->destroy(); return 0; }
															#line 675 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		new (&static_cast<AssertTrueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssertTrueActorState();
		static_cast<AssertTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && res,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		if (!res)
															#line 687 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
			TraceEvent(SevError, "ExternalWorkloadFailure").detail("Stage", stage);
															#line 691 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		}
															#line 371 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
		if (!static_cast<AssertTrueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssertTrueActorState(); static_cast<AssertTrueActor*>(this)->destroy(); return 0; }
															#line 695 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		new (&static_cast<AssertTrueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssertTrueActorState();
		static_cast<AssertTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssertTrueActor*>(this)->actor_wait_state > 0) static_cast<AssertTrueActor*>(this)->actor_wait_state = 0;
		static_cast<AssertTrueActor*>(this)->ActorCallback< AssertTrueActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AssertTrueActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("assertTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssertTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assertTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssertTrueActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("assertTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssertTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assertTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssertTrueActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("assertTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssertTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assertTrue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	StringRef stage;
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	Future<bool> f;
															#line 782 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via assertTrue()
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
class AssertTrueActor final : public Actor<Void>, public ActorCallback< AssertTrueActor, 0, bool >, public FastAllocated<AssertTrueActor>, public AssertTrueActorState<AssertTrueActor> {
															#line 787 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<AssertTrueActor>::operator new;
	using FastAllocated<AssertTrueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7752675872097761280UL, 6158008332345691136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssertTrueActor, 0, bool >;
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	AssertTrueActor(StringRef const& stage,Future<bool> const& f) 
															#line 804 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AssertTrueActorState<AssertTrueActor>(stage, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assertTrue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17804193500216049920UL, 7388334800986372096UL);
		ActorExecutionContextHelper __helper(static_cast<AssertTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assertTrue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assertTrue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssertTrueActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
[[nodiscard]] Future<Void> assertTrue( StringRef const& stage, Future<bool> const& f ) {
															#line 366 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"
	return Future<Void>(new AssertTrueActor(stage, f));
															#line 836 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExternalWorkload.actor.g.cpp.py_gen"
}

#line 373 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/workloads/ExternalWorkload.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (!success) {
			return Void();
		}
		auto db = cx.getPtr();
		db->addref();
		Reference<IDatabase> database(new ThreadSafeDatabase(db));
		Promise<bool> promise;
		auto f = promise.getFuture();
		keepAlive(f, database);
		workloadImpl->setup(reinterpret_cast<FDBDatabase*>(database.getPtr()),
		                    GenericPromise<bool>(new FDBPromiseImpl(promise)));
		return assertTrue("setup"_sr, f);
	}

	Future<Void> start(Database const& cx) override {
		if (!success) {
			return Void();
		}
		auto db = cx.getPtr();
		db->addref();
		Reference<IDatabase> database(new ThreadSafeDatabase(db));
		Promise<bool> promise;
		auto f = promise.getFuture();
		keepAlive(f, database);
		workloadImpl->start(reinterpret_cast<FDBDatabase*>(database.getPtr()),
		                    GenericPromise<bool>(new FDBPromiseImpl(promise)));
		return assertTrue("start"_sr, f);
	}
	Future<bool> check(Database const& cx) override {
		if (!success) {
			return false;
		}
		auto db = cx.getPtr();
		db->addref();
		Reference<IDatabase> database(new ThreadSafeDatabase(db));
		Promise<bool> promise;
		auto f = promise.getFuture();
		keepAlive(f, database);
		workloadImpl->check(reinterpret_cast<FDBDatabase*>(database.getPtr()),
		                    GenericPromise<bool>(new FDBPromiseImpl(promise)));
		return f;
	}
	void getMetrics(std::vector<PerfMetric>& out) override {
		if (!success) {
			return;
		}
		std::vector<FDBPerfMetric> metrics;
		workloadImpl->getMetrics(metrics);
		for (const auto& m : metrics) {
			out.emplace_back(m.name, m.value, Averaged{ m.averaged }, m.format_code);
		}
	}

	double getCheckTimeout() const override {
		if (!success) {
			return 3000;
		}
		return workloadImpl->getCheckTimeout();
	}

	// context implementation
	void trace(FDBSeverity sev,
	           const std::string& name,
	           const std::vector<std::pair<std::string, std::string>>& details) override {
		return FDBLoggerImpl::instance()->trace(sev, name, details);
	}
	uint64_t getProcessID() const override {
		if (g_network->isSimulated()) {
			return reinterpret_cast<uint64_t>(g_simulator->getCurrentProcess());
		} else {
			return 0ul;
		}
	}
	void setProcessID(uint64_t processID) override {
		if (g_network->isSimulated()) {
			g_simulator->currentProcess = reinterpret_cast<ISimulator::ProcessInfo*>(processID);
		}
	}
	double now() const override { return g_network->now(); }
	uint32_t rnd() const override { return deterministicRandom()->randomUInt32(); }
	bool getOption(const std::string& name, bool defaultValue) override {
		return ::getOption(options, Value(name), defaultValue);
	}
	long getOption(const std::string& name, long defaultValue) override {
		return ::getOption(options, Value(name), int64_t(defaultValue));
	}
	unsigned long getOption(const std::string& name, unsigned long defaultValue) override {
		return ::getOption(options, Value(name), uint64_t(defaultValue));
	}
	double getOption(const std::string& name, double defaultValue) override {
		return ::getOption(options, Value(name), defaultValue);
	}
	std::string getOption(const std::string& name, std::string defaultValue) override {
		return ::getOption(options, Value(name), Value(defaultValue)).toString();
	}

	int clientId() const override { return WorkloadContext::clientId; }

	int clientCount() const override { return WorkloadContext::clientCount; }

	int64_t sharedRandomNumber() const override { return WorkloadContext::sharedRandomNumber; }

	FDBFuture* delay(double seconds) const override {
		ThreadFuture<Void> future =
		    onMainThread([seconds]() -> Future<Void> { return g_network->delay(seconds, TaskPriority::DefaultDelay); });
		return (capi::FDBFuture*)future.extractPtr();
	}
};
} // namespace

WorkloadFactory<ExternalWorkload> CycleWorkloadFactory;
