#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
/*
 * BulkDumpUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/S3Client.actor.h"
#include "fdbserver/BulkDumpUtil.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "flow/actorcompiler.h" // has to be last include

SSBulkDumpTask getSSBulkDumpTask(const std::map<std::string, std::vector<StorageServerInterface>>& locations,
                                 const BulkDumpState& bulkDumpState) {
	StorageServerInterface targetServer;
	std::vector<UID> checksumServers;
	int dcid = 0;
	for (const auto& [_, dcServers] : locations) {
		if (dcid == 0) {
			const int idx = deterministicRandom()->randomInt(0, dcServers.size());
			targetServer = dcServers[idx];
		}
		for (int i = 0; i < dcServers.size(); i++) {
			if (dcServers[i].id() == targetServer.id()) {
				ASSERT_WE_THINK(dcid == 0);
			} else {
				checksumServers.push_back(dcServers[i].id());
			}
		}
		dcid++;
	}
	return SSBulkDumpTask(targetServer, checksumServers, bulkDumpState);
}

std::string generateBulkDumpManifestFileName(Version version) {
	return std::to_string(version) + "-manifest.txt";
}

std::string generateBulkDumpDataFileName(Version version) {
	return std::to_string(version) + "-data.sst";
}

std::string generateBulkDumpByteSampleFileName(Version version) {
	return std::to_string(version) + "-sample.sst";
}

std::string getBulkDumpJobTaskFolder(const UID& jobId, const UID& taskId) {
	return joinPath(jobId.toString(), taskId.toString());
}

std::pair<BulkLoadFileSet, BulkLoadFileSet> getLocalRemoteFileSetSetting(Version dumpVersion,
                                                                         const std::string& relativeFolder,
                                                                         const std::string& rootLocal,
                                                                         const std::string& rootRemote) {
	// Generate file names based on data version
	const std::string manifestFileName = generateBulkDumpManifestFileName(dumpVersion);
	const std::string dataFileName = generateBulkDumpDataFileName(dumpVersion);
	const std::string byteSampleFileName = generateBulkDumpByteSampleFileName(dumpVersion);
	BulkLoadFileSet fileSetLocal(
	    rootLocal, relativeFolder, manifestFileName, dataFileName, byteSampleFileName, BulkLoadChecksum());
	BulkLoadFileSet fileSetRemote(
	    rootRemote, relativeFolder, manifestFileName, dataFileName, byteSampleFileName, BulkLoadChecksum());
	return std::make_pair(fileSetLocal, fileSetRemote);
}

// Generate SST file given the input sortedKVS to the input filePath.
// TODO(BulkDump): This copy of sortedKVS can be a slow task if data is large.
void writeKVSToSSTFile(std::string filePath, std::map<Key, Value>& sortedKVS, UID logId) {
	const std::string absFilePath = abspath(filePath);
	// Check file
	if (fileExists(absFilePath)) {
		TraceEvent(SevWarn, "SSBulkDumpRetriableError", logId)
		    .detail("Reason", "exist old File when writeKVSToSSTFile")
		    .detail("DataFilePathLocal", absFilePath);
		ASSERT_WE_THINK(false);
		throw retry();
	}
	// Dump data to file
	std::unique_ptr<IRocksDBSstFileWriter> sstWriter = newRocksDBSstFileWriter();
	sstWriter->open(absFilePath);
	for (const auto& [key, value] : sortedKVS) {
		sstWriter->write(key, value); // assuming sorted
	}
	if (!sstWriter->finish()) {
		// Unexpected: having data but failed to finish
		TraceEvent(SevWarn, "SSBulkDumpRetriableError", logId)
		    .detail("Reason", "failed to finish data sst writer when writeKVSToSSTFile")
		    .detail("DataFilePath", absFilePath);
		ASSERT_WE_THINK(false);
		throw retry();
	}
	return;
}

															#line 117 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via dumpDataFileToLocalDirectory()
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class DumpDataFileToLocalDirectoryActor>
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class DumpDataFileToLocalDirectoryActorState {
															#line 124 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	DumpDataFileToLocalDirectoryActorState(UID const& logId,std::shared_ptr<RangeDumpRawData> const& rangeDumpRawData,BulkLoadFileSet const& localFileSet,BulkLoadFileSet const& remoteFileSet,BulkLoadByteSampleSetting const& byteSampleSetting,Version const& dumpVersion,KeyRange const& dumpRange,BulkLoadType const& dumpType,BulkLoadTransportMethod const& transportMethod) 
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : logId(logId),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   rangeDumpRawData(rangeDumpRawData),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   localFileSet(localFileSet),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   remoteFileSet(remoteFileSet),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   byteSampleSetting(byteSampleSetting),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   dumpVersion(dumpVersion),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   dumpRange(dumpRange),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   dumpType(dumpType),
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   transportMethod(transportMethod)
															#line 147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this));

	}
	~DumpDataFileToLocalDirectoryActorState() 
	{
		fdb_probe_actor_destroy("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			resetFileFolder((abspath(localFileSet.getFolder())));
															#line 128 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			bool containDataFile = false;
															#line 129 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (rangeDumpRawData->kvs.size() > 0)
															#line 166 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 130 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				writeKVSToSSTFile(abspath(localFileSet.getDataFileFullPath()), rangeDumpRawData->kvs, logId);
															#line 131 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				containDataFile = true;
															#line 172 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
			else
			{
															#line 133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				ASSERT(rangeDumpRawData->sampled.empty());
															#line 134 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				containDataFile = false;
															#line 180 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 138 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			bool containByteSampleFile = false;
															#line 139 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (rangeDumpRawData->sampled.size() > 0)
															#line 186 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 140 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				writeKVSToSSTFile(abspath(localFileSet.getBytesSampleFileFullPath()), rangeDumpRawData->sampled, logId);
															#line 141 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				containByteSampleFile = true;
															#line 192 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
			else
			{
															#line 143 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				containByteSampleFile = false;
															#line 198 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (fileExists(abspath(localFileSet.getManifestFileFullPath())))
															#line 202 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 148 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				TraceEvent(SevWarn, "SSBulkDumpRetriableError", logId) .detail("Reason", "exist old manifestFile") .detail("ManifestFilePathLocal", abspath(localFileSet.getManifestFileFullPath()));
															#line 151 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				ASSERT_WE_THINK(false);
															#line 152 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1Catch1(retry(), loopDepth);
															#line 210 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 154 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			BulkLoadFileSet fileSetRemote(remoteFileSet.getRootPath(), remoteFileSet.getRelativePath(), remoteFileSet.getManifestFileName(), containDataFile ? remoteFileSet.getDataFileName() : std::string(), containByteSampleFile ? remoteFileSet.getByteSampleFileName() : std::string(), BulkLoadChecksum());
															#line 160 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			manifestMetadata = BulkLoadManifest(fileSetRemote, dumpRange.begin, dumpRange.end, dumpVersion, rangeDumpRawData->kvsBytes, rangeDumpRawData->kvs.size(), byteSampleSetting, dumpType, transportMethod);
															#line 169 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			manifestStr = manifestMetadata.toString();
															#line 170 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			manifest = std::make_shared<std::string>(std::move(manifestStr));
															#line 171 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = writeBulkFileBytes(abspath(localFileSet.getManifestFileFullPath()), manifest);
															#line 171 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<DumpDataFileToLocalDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 224 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpDataFileToLocalDirectoryActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >*>(static_cast<DumpDataFileToLocalDirectoryActor*>(this)));
															#line 229 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpDataFileToLocalDirectoryActorState();
		static_cast<DumpDataFileToLocalDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<DumpDataFileToLocalDirectoryActor*>(this)->SAV<BulkLoadManifest>::futures) { (void)(manifestMetadata); this->~DumpDataFileToLocalDirectoryActorState(); static_cast<DumpDataFileToLocalDirectoryActor*>(this)->destroy(); return 0; }
															#line 252 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<DumpDataFileToLocalDirectoryActor*>(this)->SAV< BulkLoadManifest >::value()) BulkLoadManifest(std::move(manifestMetadata)); // state_var_RVO
		this->~DumpDataFileToLocalDirectoryActorState();
		static_cast<DumpDataFileToLocalDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<DumpDataFileToLocalDirectoryActor*>(this)->SAV<BulkLoadManifest>::futures) { (void)(manifestMetadata); this->~DumpDataFileToLocalDirectoryActorState(); static_cast<DumpDataFileToLocalDirectoryActor*>(this)->destroy(); return 0; }
															#line 264 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<DumpDataFileToLocalDirectoryActor*>(this)->SAV< BulkLoadManifest >::value()) BulkLoadManifest(std::move(manifestMetadata)); // state_var_RVO
		this->~DumpDataFileToLocalDirectoryActorState();
		static_cast<DumpDataFileToLocalDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpDataFileToLocalDirectoryActor*>(this)->actor_wait_state > 0) static_cast<DumpDataFileToLocalDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataFileToLocalDirectoryActor*>(this)->ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataFileToLocalDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataFileToLocalDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataFileToLocalDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UID logId;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::shared_ptr<RangeDumpRawData> rangeDumpRawData;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet localFileSet;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet remoteFileSet;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadByteSampleSetting byteSampleSetting;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	Version dumpVersion;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	KeyRange dumpRange;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadType dumpType;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 160 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadManifest manifestMetadata;
															#line 169 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::string manifestStr;
															#line 170 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::shared_ptr<std::string> manifest;
															#line 371 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via dumpDataFileToLocalDirectory()
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class DumpDataFileToLocalDirectoryActor final : public Actor<BulkLoadManifest>, public ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >, public FastAllocated<DumpDataFileToLocalDirectoryActor>, public DumpDataFileToLocalDirectoryActorState<DumpDataFileToLocalDirectoryActor> {
															#line 376 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<DumpDataFileToLocalDirectoryActor>::operator new;
	using FastAllocated<DumpDataFileToLocalDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7428343742026836992UL, 10576176552766846208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadManifest>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >;
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	DumpDataFileToLocalDirectoryActor(UID const& logId,std::shared_ptr<RangeDumpRawData> const& rangeDumpRawData,BulkLoadFileSet const& localFileSet,BulkLoadFileSet const& remoteFileSet,BulkLoadByteSampleSetting const& byteSampleSetting,Version const& dumpVersion,KeyRange const& dumpRange,BulkLoadType const& dumpType,BulkLoadTransportMethod const& transportMethod) 
															#line 393 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<BulkLoadManifest>(),
		   DumpDataFileToLocalDirectoryActorState<DumpDataFileToLocalDirectoryActor>(logId, rangeDumpRawData, localFileSet, remoteFileSet, byteSampleSetting, dumpVersion, dumpRange, dumpType, transportMethod),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3782295262414965760UL, 2220969379707641856UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataFileToLocalDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpDataFileToLocalDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpDataFileToLocalDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpDataFileToLocalDirectoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadManifest> dumpDataFileToLocalDirectory( UID const& logId, std::shared_ptr<RangeDumpRawData> const& rangeDumpRawData, BulkLoadFileSet const& localFileSet, BulkLoadFileSet const& remoteFileSet, BulkLoadByteSampleSetting const& byteSampleSetting, Version const& dumpVersion, KeyRange const& dumpRange, BulkLoadType const& dumpType, BulkLoadTransportMethod const& transportMethod ) {
															#line 115 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<BulkLoadManifest>(new DumpDataFileToLocalDirectoryActor(logId, rangeDumpRawData, localFileSet, remoteFileSet, byteSampleSetting, dumpVersion, dumpRange, dumpType, transportMethod));
															#line 426 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

#line 174 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"

// Validate the invariant of filenames. Source is the file stored locally. Destination is the file going to move to.
bool validateSourceDestinationFileSets(const BulkLoadFileSet& source, const BulkLoadFileSet& destination) {
	// Manifest file must be present
	if (!source.hasManifestFile() || !destination.hasManifestFile()) {
		return false;
	}
	// Source data file and destination data file must present at same time
	// If data file not present, byte sampling file must not present
	if (!source.hasDataFile() && (destination.hasDataFile() || source.hasByteSampleFile())) {
		return false;
	}
	if (!destination.hasDataFile() && (source.hasDataFile() || destination.hasByteSampleFile())) {
		return false;
	}
	// Data file path and byte sampling file path must have the same basename between source and destination
	if (source.hasDataFile() && source.getDataFileName() != destination.getDataFileName()) {
		return false;
	}
	if (source.hasByteSampleFile() && source.getByteSampleFileName() != destination.getByteSampleFileName()) {
		return false;
	}
	return true;
}

// Copy files between local file folders, used to mock blobstore in the test.
															#line 456 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkDumpTransportCP_impl()
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class BulkDumpTransportCP_implActor>
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class BulkDumpTransportCP_implActorState {
															#line 463 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkDumpTransportCP_implActorState(BulkLoadFileSet const& srcFileSet,BulkLoadFileSet const& destFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : srcFileSet(srcFileSet),
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   destFileSet(destFileSet),
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   logId(logId)
															#line 476 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkDumpTransportCP_implActorState() 
	{
		fdb_probe_actor_destroy("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 205 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			resetFileFolder(abspath(destFileSet.getFolder()));
															#line 207 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(srcFileSet.hasManifestFile() && destFileSet.hasManifestFile());
															#line 208 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyBulkFile( abspath(srcFileSet.getManifestFileFullPath()), abspath(destFileSet.getManifestFileFullPath()), fileBytesMax);
															#line 208 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 497 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 1;
															#line 208 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkDumpTransportCP_implActor, 0, Void >*>(static_cast<BulkDumpTransportCP_implActor*>(this)));
															#line 502 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkDumpTransportCP_implActorState();
		static_cast<BulkDumpTransportCP_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (srcFileSet.hasDataFile())
															#line 525 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
															#line 211 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(destFileSet.hasDataFile());
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile( abspath(srcFileSet.getDataFileFullPath()), abspath(destFileSet.getDataFileFullPath()), fileBytesMax);
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 533 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*>(static_cast<BulkDumpTransportCP_implActor*>(this)));
															#line 538 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (srcFileSet.hasDataFile())
															#line 552 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
															#line 211 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(destFileSet.hasDataFile());
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile( abspath(srcFileSet.getDataFileFullPath()), abspath(destFileSet.getDataFileFullPath()), fileBytesMax);
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 560 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 212 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*>(static_cast<BulkDumpTransportCP_implActor*>(this)));
															#line 565 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpTransportCP_implActor*>(this)->ActorCallback< BulkDumpTransportCP_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkDumpTransportCP_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 215 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (srcFileSet.hasByteSampleFile())
															#line 654 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
															#line 216 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(srcFileSet.hasDataFile() && destFileSet.hasByteSampleFile());
															#line 217 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_2 = copyBulkFile(abspath(srcFileSet.getBytesSampleFileFullPath()), abspath(destFileSet.getBytesSampleFileFullPath()), fileBytesMax);
															#line 217 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 662 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 3;
															#line 217 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkDumpTransportCP_implActor, 2, Void >*>(static_cast<BulkDumpTransportCP_implActor*>(this)));
															#line 667 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpTransportCP_implActor*>(this)->ActorCallback< BulkDumpTransportCP_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 221 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<BulkDumpTransportCP_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkDumpTransportCP_implActorState(); static_cast<BulkDumpTransportCP_implActor*>(this)->destroy(); return 0; }
															#line 768 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkDumpTransportCP_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkDumpTransportCP_implActorState();
		static_cast<BulkDumpTransportCP_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpTransportCP_implActor*>(this)->ActorCallback< BulkDumpTransportCP_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportCP_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkDumpTransportCP_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet srcFileSet;
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet destFileSet;
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	size_t fileBytesMax;
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UID logId;
															#line 871 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkDumpTransportCP_impl()
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class BulkDumpTransportCP_implActor final : public Actor<Void>, public ActorCallback< BulkDumpTransportCP_implActor, 0, Void >, public ActorCallback< BulkDumpTransportCP_implActor, 1, Void >, public ActorCallback< BulkDumpTransportCP_implActor, 2, Void >, public FastAllocated<BulkDumpTransportCP_implActor>, public BulkDumpTransportCP_implActorState<BulkDumpTransportCP_implActor> {
															#line 876 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkDumpTransportCP_implActor>::operator new;
	using FastAllocated<BulkDumpTransportCP_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1810138075691681792UL, 1337076461346990336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkDumpTransportCP_implActor, 0, Void >;
friend struct ActorCallback< BulkDumpTransportCP_implActor, 1, Void >;
friend struct ActorCallback< BulkDumpTransportCP_implActor, 2, Void >;
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkDumpTransportCP_implActor(BulkLoadFileSet const& srcFileSet,BulkLoadFileSet const& destFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 895 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BulkDumpTransportCP_implActorState<BulkDumpTransportCP_implActor>(srcFileSet, destFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12171796906223876352UL, 15517238434435286784UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkDumpTransportCP_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkDumpTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkDumpTransportCP_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkDumpTransportCP_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkDumpTransportCP_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkDumpTransportCP_impl( BulkLoadFileSet const& srcFileSet, BulkLoadFileSet const& destFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 200 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<Void>(new BulkDumpTransportCP_implActor(srcFileSet, destFileSet, fileBytesMax, logId));
															#line 930 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

#line 223 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"

// Dump files to blobstore.
															#line 936 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkDumpTransportBlobstore_impl()
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class BulkDumpTransportBlobstore_implActor>
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class BulkDumpTransportBlobstore_implActorState {
															#line 943 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkDumpTransportBlobstore_implActorState(BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : sourceFileSet(sourceFileSet),
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   logId(logId)
															#line 956 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkDumpTransportBlobstore_implActorState() 
	{
		fdb_probe_actor_destroy("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpBulkDumpFileSet(destinationFileSet.getRootPath(), sourceFileSet, destinationFileSet);
															#line 230 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<BulkDumpTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkDumpTransportBlobstore_implActor*>(this)->actor_wait_state = 1;
															#line 230 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >*>(static_cast<BulkDumpTransportBlobstore_implActor*>(this)));
															#line 978 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkDumpTransportBlobstore_implActorState();
		static_cast<BulkDumpTransportBlobstore_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<BulkDumpTransportBlobstore_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkDumpTransportBlobstore_implActorState(); static_cast<BulkDumpTransportBlobstore_implActor*>(this)->destroy(); return 0; }
															#line 1001 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkDumpTransportBlobstore_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkDumpTransportBlobstore_implActorState();
		static_cast<BulkDumpTransportBlobstore_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<BulkDumpTransportBlobstore_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkDumpTransportBlobstore_implActorState(); static_cast<BulkDumpTransportBlobstore_implActor*>(this)->destroy(); return 0; }
															#line 1013 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkDumpTransportBlobstore_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkDumpTransportBlobstore_implActorState();
		static_cast<BulkDumpTransportBlobstore_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkDumpTransportBlobstore_implActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpTransportBlobstore_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpTransportBlobstore_implActor*>(this)->ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	size_t fileBytesMax;
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UID logId;
															#line 1104 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkDumpTransportBlobstore_impl()
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class BulkDumpTransportBlobstore_implActor final : public Actor<Void>, public ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >, public FastAllocated<BulkDumpTransportBlobstore_implActor>, public BulkDumpTransportBlobstore_implActorState<BulkDumpTransportBlobstore_implActor> {
															#line 1109 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkDumpTransportBlobstore_implActor>::operator new;
	using FastAllocated<BulkDumpTransportBlobstore_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16818633567563476480UL, 12023334693129804288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >;
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkDumpTransportBlobstore_implActor(BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 1126 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BulkDumpTransportBlobstore_implActorState<BulkDumpTransportBlobstore_implActor>(sourceFileSet, destinationFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6757812270509496064UL, 1447533694993911040UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkDumpTransportBlobstore_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkDumpTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkDumpTransportBlobstore_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkDumpTransportBlobstore_impl( BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 225 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<Void>(new BulkDumpTransportBlobstore_implActor(sourceFileSet, destinationFileSet, fileBytesMax, logId));
															#line 1159 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

#line 233 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"

															#line 1164 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via uploadBulkDumpFileSet()
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class UploadBulkDumpFileSetActor>
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class UploadBulkDumpFileSetActorState {
															#line 1171 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UploadBulkDumpFileSetActorState(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet,UID const& logId) 
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   sourceFileSet(sourceFileSet),
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   logId(logId)
															#line 1184 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	~UploadBulkDumpFileSetActorState() 
	{
		fdb_probe_actor_destroy("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 239 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (!validateSourceDestinationFileSets(sourceFileSet, destinationFileSet))
															#line 1199 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				TraceEvent(SevWarnAlways, "SSBulkDumpUploadFilesError", logId) .detail("SourceFileSet", sourceFileSet.toString()) .detail("DestinationFileSet", destinationFileSet.toString());
															#line 243 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				ASSERT_WE_THINK(false);
															#line 244 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1Catch1(bulkdump_task_failed(), loopDepth);
															#line 1207 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 247 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 1211 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 248 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = bulkDumpTransportBlobstore_impl( sourceFileSet, destinationFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 248 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				if (static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1217 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadBulkDumpFileSetActor, 0, Void >*>(static_cast<UploadBulkDumpFileSetActor*>(this)));
															#line 1222 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 250 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::CP)
															#line 1229 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				{
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					StrictFuture<Void> __when_expr_1 = bulkDumpTransportCP_impl(sourceFileSet, destinationFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					if (static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1235 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 251 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadBulkDumpFileSetActor, 1, Void >*>(static_cast<UploadBulkDumpFileSetActor*>(this)));
															#line 1240 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 253 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					TraceEvent(SevError, "SSBulkDumpUploadFilesError", logId) .detail("Reason", "Transport method is not implemented") .detail("TransportMethod", transportMethod);
															#line 256 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					ASSERT(false);
															#line 1249 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					loopDepth = a_body1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadBulkDumpFileSetActorState();
		static_cast<UploadBulkDumpFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 258 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<UploadBulkDumpFileSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UploadBulkDumpFileSetActorState(); static_cast<UploadBulkDumpFileSetActor*>(this)->destroy(); return 0; }
															#line 1274 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<UploadBulkDumpFileSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UploadBulkDumpFileSetActorState();
		static_cast<UploadBulkDumpFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<UploadBulkDumpFileSetActor*>(this)->ActorCallback< UploadBulkDumpFileSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpFileSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpFileSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadBulkDumpFileSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<UploadBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<UploadBulkDumpFileSetActor*>(this)->ActorCallback< UploadBulkDumpFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadBulkDumpFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UID logId;
															#line 1470 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via uploadBulkDumpFileSet()
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class UploadBulkDumpFileSetActor final : public Actor<Void>, public ActorCallback< UploadBulkDumpFileSetActor, 0, Void >, public ActorCallback< UploadBulkDumpFileSetActor, 1, Void >, public FastAllocated<UploadBulkDumpFileSetActor>, public UploadBulkDumpFileSetActorState<UploadBulkDumpFileSetActor> {
															#line 1475 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<UploadBulkDumpFileSetActor>::operator new;
	using FastAllocated<UploadBulkDumpFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13972537467932152064UL, 7849326191321988608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadBulkDumpFileSetActor, 0, Void >;
friend struct ActorCallback< UploadBulkDumpFileSetActor, 1, Void >;
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UploadBulkDumpFileSetActor(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet,UID const& logId) 
															#line 1493 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UploadBulkDumpFileSetActorState<UploadBulkDumpFileSetActor>(transportMethod, sourceFileSet, destinationFileSet, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3837351010683622400UL, 17645621756462880512UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadBulkDumpFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadBulkDumpFileSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadBulkDumpFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<Void> uploadBulkDumpFileSet( BulkLoadTransportMethod const& transportMethod, BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet, UID const& logId ) {
															#line 234 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<Void>(new UploadBulkDumpFileSetActor(transportMethod, sourceFileSet, destinationFileSet, logId));
															#line 1527 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

#line 260 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"

															#line 1532 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via uploadBulkDumpJobManifestFile()
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class UploadBulkDumpJobManifestFileActor>
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class UploadBulkDumpJobManifestFileActorState {
															#line 1539 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UploadBulkDumpJobManifestFileActorState(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteFolder,std::string const& remoteJobManifestFileName,UID const& logId) 
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   localJobManifestFilePath(localJobManifestFilePath),
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   remoteFolder(remoteFolder),
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   remoteJobManifestFileName(remoteJobManifestFileName),
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   logId(logId)
															#line 1554 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~UploadBulkDumpJobManifestFileActorState() 
	{
		fdb_probe_actor_destroy("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			auto remoteJobManifestFilePath = appendToPath(remoteFolder, remoteJobManifestFileName);
															#line 267 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			TraceEvent(SevInfo, "UploadBulkDumpJobManifest", logId) .detail("RemoteJobManifestFilePath", remoteJobManifestFilePath);
															#line 269 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 1573 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = copyUpFile(localJobManifestFilePath, remoteJobManifestFilePath);
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				if (static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1579 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state = 1;
															#line 270 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >*>(static_cast<UploadBulkDumpJobManifestFileActor*>(this)));
															#line 1584 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 271 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::CP)
															#line 1591 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
				{
															#line 272 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					StrictFuture<Void> __when_expr_1 = copyBulkFile(abspath(localJobManifestFilePath), abspath(remoteJobManifestFilePath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX);
															#line 272 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					if (static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1597 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state = 2;
															#line 272 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >*>(static_cast<UploadBulkDumpJobManifestFileActor*>(this)));
															#line 1602 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 276 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					TraceEvent(SevError, "UploadBulkDumpJobManifestFileError", logId) .detail("Reason", "Transport method is not implemented") .detail("TransportMethod", transportMethod);
															#line 279 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
					ASSERT(false);
															#line 1611 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadBulkDumpJobManifestFileActorState();
		static_cast<UploadBulkDumpJobManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 282 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<UploadBulkDumpJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UploadBulkDumpJobManifestFileActorState(); static_cast<UploadBulkDumpJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 1636 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<UploadBulkDumpJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UploadBulkDumpJobManifestFileActorState();
		static_cast<UploadBulkDumpJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<UploadBulkDumpJobManifestFileActor*>(this)->ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<UploadBulkDumpJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<UploadBulkDumpJobManifestFileActor*>(this)->ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::string localJobManifestFilePath;
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::string remoteFolder;
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	std::string remoteJobManifestFileName;
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UID logId;
															#line 1834 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via uploadBulkDumpJobManifestFile()
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class UploadBulkDumpJobManifestFileActor final : public Actor<Void>, public ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >, public ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >, public FastAllocated<UploadBulkDumpJobManifestFileActor>, public UploadBulkDumpJobManifestFileActorState<UploadBulkDumpJobManifestFileActor> {
															#line 1839 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<UploadBulkDumpJobManifestFileActor>::operator new;
	using FastAllocated<UploadBulkDumpJobManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8434861220760432640UL, 7669161884979147520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >;
friend struct ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >;
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	UploadBulkDumpJobManifestFileActor(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteFolder,std::string const& remoteJobManifestFileName,UID const& logId) 
															#line 1857 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UploadBulkDumpJobManifestFileActorState<UploadBulkDumpJobManifestFileActor>(transportMethod, localJobManifestFilePath, remoteFolder, remoteJobManifestFileName, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2812117559081920000UL, 4485999242702016512UL);
		ActorExecutionContextHelper __helper(static_cast<UploadBulkDumpJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadBulkDumpJobManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadBulkDumpJobManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadBulkDumpJobManifestFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadBulkDumpJobManifestFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<Void> uploadBulkDumpJobManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& localJobManifestFilePath, std::string const& remoteFolder, std::string const& remoteJobManifestFileName, UID const& logId ) {
															#line 261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<Void>(new UploadBulkDumpJobManifestFileActor(transportMethod, localJobManifestFilePath, remoteFolder, remoteJobManifestFileName, logId));
															#line 1891 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

#line 284 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"

															#line 1896 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistCompleteBulkDumpRange()
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
template <class PersistCompleteBulkDumpRangeActor>
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class PersistCompleteBulkDumpRangeActorState {
															#line 1903 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	PersistCompleteBulkDumpRangeActorState(Database const& cx,BulkDumpState const& bulkDumpState) 
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		 : cx(cx),
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   bulkDumpState(bulkDumpState),
															#line 286 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		   tr(cx)
															#line 1914 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this));

	}
	~PersistCompleteBulkDumpRangeActorState() 
	{
		fdb_probe_actor_destroy("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 287 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(bulkDumpState.isMetadataValid());
															#line 288 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			beginKey = bulkDumpState.getRange().begin;
															#line 289 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			endKey = bulkDumpState.getRange().end;
															#line 290 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			rangeToPersist = KeyRange();
															#line 291 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			result = RangeResult();
															#line 292 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			;
															#line 1939 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistCompleteBulkDumpRangeActorState();
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 332 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!static_cast<PersistCompleteBulkDumpRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistCompleteBulkDumpRangeActorState(); static_cast<PersistCompleteBulkDumpRangeActor*>(this)->destroy(); return 0; }
															#line 1962 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		new (&static_cast<PersistCompleteBulkDumpRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistCompleteBulkDumpRangeActorState();
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 294 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 295 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 296 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 297 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			rangeToPersist = Standalone(KeyRangeRef(beginKey, endKey));
															#line 298 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(result, krmGetRanges(&tr, bulkDumpPrefix, rangeToPersist));
															#line 298 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1992 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 1997 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2034 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 4;
															#line 329 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 2039 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		bool anyNew = false;
															#line 300 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		for(int i = 0;i < result.size() - 1;i++) {
															#line 301 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (result[i].value.empty())
															#line 2058 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 302 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2062 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 304 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			BulkDumpState currentBulkDumpState = decodeBulkDumpState(result[i].value);
															#line 305 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (currentBulkDumpState.getJobId() != bulkDumpState.getJobId())
															#line 2068 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 306 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2072 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 308 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(bulkDumpState.getTaskId().present());
															#line 309 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (currentBulkDumpState.getTaskId().present() && currentBulkDumpState.getTaskId().get() != bulkDumpState.getTaskId().get())
															#line 2078 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 311 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2082 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 313 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (!anyNew && currentBulkDumpState.getPhase() == BulkDumpPhase::Submitted)
															#line 2086 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 314 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				anyNew = true;
															#line 2090 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
		}
															#line 317 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!anyNew)
															#line 2095 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
															#line 318 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2099 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		}
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, bulkDumpPrefix, bulkDumpState.getRange(), bulkDumpStateValue(bulkDumpState));
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2105 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 2;
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 2110 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		bool anyNew = false;
															#line 300 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		for(int i = 0;i < result.size() - 1;i++) {
															#line 301 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (result[i].value.empty())
															#line 2123 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 302 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2127 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 304 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			BulkDumpState currentBulkDumpState = decodeBulkDumpState(result[i].value);
															#line 305 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (currentBulkDumpState.getJobId() != bulkDumpState.getJobId())
															#line 2133 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 306 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2137 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 308 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			ASSERT(bulkDumpState.getTaskId().present());
															#line 309 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (currentBulkDumpState.getTaskId().present() && currentBulkDumpState.getTaskId().get() != bulkDumpState.getTaskId().get())
															#line 2143 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 311 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2147 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
															#line 313 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			if (!anyNew && currentBulkDumpState.getPhase() == BulkDumpPhase::Submitted)
															#line 2151 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			{
															#line 314 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
				anyNew = true;
															#line 2155 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
			}
		}
															#line 317 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (!anyNew)
															#line 2160 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
															#line 318 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			return a_body1loopBody1Catch1(bulkdump_task_outdated(), loopDepth);
															#line 2164 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		}
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, bulkDumpPrefix, bulkDumpState.getRange(), bulkDumpStateValue(bulkDumpState));
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2170 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 2;
															#line 320 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 2175 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2261 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 3;
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 2266 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2277 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 3;
															#line 321 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*>(static_cast<PersistCompleteBulkDumpRangeActor*>(this)));
															#line 2282 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		beginKey = result[result.size() - 1].key;
															#line 323 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (beginKey >= endKey)
															#line 2368 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 326 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			tr.reset();
															#line 2376 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		beginKey = result[result.size() - 1].key;
															#line 323 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
		if (beginKey >= endKey)
															#line 2388 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 326 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
			tr.reset();
															#line 2396 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistCompleteBulkDumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistCompleteBulkDumpRangeActor*>(this)->ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	Database cx;
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	BulkDumpState bulkDumpState;
															#line 286 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	Transaction tr;
															#line 288 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	Key beginKey;
															#line 289 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	Key endKey;
															#line 290 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	KeyRange rangeToPersist;
															#line 291 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	RangeResult result;
															#line 2591 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistCompleteBulkDumpRange()
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
class PersistCompleteBulkDumpRangeActor final : public Actor<Void>, public ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >, public ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >, public ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >, public ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >, public FastAllocated<PersistCompleteBulkDumpRangeActor>, public PersistCompleteBulkDumpRangeActorState<PersistCompleteBulkDumpRangeActor> {
															#line 2596 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistCompleteBulkDumpRangeActor>::operator new;
	using FastAllocated<PersistCompleteBulkDumpRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9814881007139165440UL, 9475557283908047104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >;
friend struct ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >;
friend struct ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >;
friend struct ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >;
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	PersistCompleteBulkDumpRangeActor(Database const& cx,BulkDumpState const& bulkDumpState) 
															#line 2616 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistCompleteBulkDumpRangeActorState<PersistCompleteBulkDumpRangeActor>(cx, bulkDumpState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15093582491792763648UL, 1392059538506076416UL);
		ActorExecutionContextHelper __helper(static_cast<PersistCompleteBulkDumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistCompleteBulkDumpRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistCompleteBulkDumpRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistCompleteBulkDumpRangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistCompleteBulkDumpRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistCompleteBulkDumpRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistCompleteBulkDumpRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
[[nodiscard]] Future<Void> persistCompleteBulkDumpRange( Database const& cx, BulkDumpState const& bulkDumpState ) {
															#line 285 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/fdbserver/BulkDumpUtil.actor.cpp"
	return Future<Void>(new PersistCompleteBulkDumpRangeActor(cx, bulkDumpState));
															#line 2652 "/codebuild/output/src1493722952/src/github.com/apple/foundationdb/build_output/fdbserver/BulkDumpUtil.actor.g.cpp.py_gen"
}

