#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
/*
 * WriteThrottling.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TagThrottle.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// workload description:
// This workload aims to test whether we can throttling some bad clients that doing penetrating write on write hot-spot
// range. There are several good clientActor just randomly do read and write ops in transaction. Also, some bad
// clientActor has high probability to read and write a particular hot-spot. If the tag-based throttling works right on
// write-heavy tags, it will only limit the bad clientActor without influence other normal actors. This workload also
// output TPS and latency of read/set/clear operations to do eyeball check. We want this new feature would not cause
// more load to the cluster (Maybe some visualization tools is needed to show the trend of metrics)
struct WriteTagThrottlingWorkload : KVWorkload {

	// Performance metrics
	int goodActorTrNum = 0, goodActorRetries = 0, goodActorTooOldRetries = 0, goodActorCommitFailedRetries = 0;
	int badActorTrNum = 0, badActorRetries = 0, badActorTooOldRetries = 0, badActorCommitFailedRetries = 0;
	int goodActorThrottleRetries = 0, badActorThrottleRetries = 0;
	double badActorTotalLatency = 0.0, goodActorTotalLatency = 0.0;
	DDSketch<double> badActorReadLatency, goodActorReadLatency;
	DDSketch<double> badActorCommitLatency, goodActorCommitLatency;
	// Test configuration
	// KVWorkload::actorCount
	int goodActorPerClient, badActorPerClient;
	int numWritePerTr, numReadPerTr, numClearPerTr;
	int keyCount;
	double badOpRate, hotRangeRate;
	double testDuration;
	bool writeThrottle;
	bool populateData;

	// internal states
	double trInterval;
	TransactionTag badTag, goodTag;
	bool fastSuccess = false;
	int rangeEachBadActor = 0;
	std::set<std::string> throttledTags;
	static constexpr auto NAME = "WriteTagThrottling";
	static constexpr int MIN_TAGS_PER_TRANSACTION = 1;
	static constexpr int MIN_TRANSACTION_TAG_LENGTH = 2;

	WriteTagThrottlingWorkload(WorkloadContext const& wcx)
	  : KVWorkload(wcx), badActorReadLatency(), goodActorReadLatency(), badActorCommitLatency(),
	    goodActorCommitLatency() {
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		badOpRate = getOption(options, "badOpRate"_sr, 0.9);
		numWritePerTr = getOption(options, "numWritePerTr"_sr, 1);
		numReadPerTr = getOption(options, "numReadPerTr"_sr, 1);
		numClearPerTr = getOption(options, "numClearPerTr"_sr, 1);
		hotRangeRate = getOption(options, "hotRangeRate"_sr, 0.1);
		populateData = getOption(options, "populateData"_sr, true);

		writeThrottle = getOption(options, "writeThrottle"_sr, false);
		badActorPerClient = getOption(options, "badActorPerClient"_sr, 1);
		goodActorPerClient = getOption(options, "goodActorPerClient"_sr, 1);
		actorCount = goodActorPerClient + badActorPerClient;

		keyCount = getOption(options,
		                     "keyCount"_sr,
		                     std::max(3000, clientCount * actorCount * 3)); // enough keys to avoid too many conflicts
		trInterval = actorCount * 1.0 / getOption(options, "trPerSecond"_sr, 1000);
		if (badActorPerClient > 0) {
			rangeEachBadActor = keyCount / (clientCount * badActorPerClient);
		}

		badTag = TransactionTag(std::string("bT"));
		goodTag = TransactionTag(std::string("gT"));
	}

																#line 95 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
template <class _setupActor>
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class _setupActorState {
															#line 101 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	_setupActorState(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		 : cx(cx),
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   self(self)
															#line 110 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			ASSERT(CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION >= MIN_TAGS_PER_TRANSACTION && CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH >= MIN_TRANSACTION_TAG_LENGTH);
															#line 96 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (self->populateData)
															#line 127 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			{
															#line 97 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				StrictFuture<Void> __when_expr_0 = bulkSetup(cx, self, self->keyCount, Promise<double>());
															#line 97 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 133 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 138 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 99 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (self->clientId == 0)
															#line 166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			StrictFuture<Void> __when_expr_1 = ThrottleApi::enableAuto(cx.getReference(), true);
															#line 100 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 172 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 100 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 177 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 102 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 278 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Database cx;
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	WriteTagThrottlingWorkload* self;
															#line 377 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 382 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4484694166177192960UL, 16494510952452341504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	_setupActor(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 400 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, WriteTagThrottlingWorkload* const& self ) {
															#line 93 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 433 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
}

#line 104 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Future<Void> setup(const Database& cx) override {
		if (CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION < MIN_TAGS_PER_TRANSACTION ||
		    CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH < MIN_TRANSACTION_TAG_LENGTH) {
			fastSuccess = true;
			return Void();
		}
		return _setup(cx, this);
	}
																#line 445 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
template <class _startActor>
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class _startActorState {
															#line 451 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	_startActorState(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		 : cx(cx),
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   self(self)
															#line 460 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			std::vector<Future<Void>> clientActors;
															#line 114 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			int actorId;
															#line 115 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			for(actorId = 0;actorId < self->goodActorPerClient;++actorId) {
															#line 116 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				clientActors.push_back(clientActor(false, actorId, 0, cx, self));
															#line 481 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
															#line 118 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			for(actorId = 0;actorId < self->badActorPerClient;++actorId) {
															#line 119 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				clientActors.push_back(clientActor(true, actorId, self->badOpRate, cx, self));
															#line 487 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
															#line 121 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			clientActors.push_back(throttledTagUpdater(cx, self));
															#line 122 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(waitForAll(clientActors), self->testDuration, Void());
															#line 122 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 495 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 500 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 523 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Database cx;
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	WriteTagThrottlingWorkload* self;
															#line 622 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 627 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10971451743589344512UL, 5779686631975804416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	_startActor(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 644 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, WriteTagThrottlingWorkload* const& self ) {
															#line 112 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 676 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
}

#line 125 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Future<Void> start(Database const& cx) override {
		if (fastSuccess)
			return Void();
		return _start(cx, this);
	}
	Future<bool> check(Database const& cx) override {
		if (fastSuccess)
			return true;
		if (writeThrottle) {
			if (!badActorThrottleRetries && !goodActorThrottleRetries) {
				TraceEvent(SevWarn, "NoThrottleTriggered").log();
			}
			if (badActorThrottleRetries < goodActorThrottleRetries) {
				TraceEvent(SevWarnAlways, "IncorrectThrottle")
				    .detail("BadActorThrottleRetries", badActorThrottleRetries)
				    .detail("GoodActorThrottleRetries", goodActorThrottleRetries);
			}
			if (!throttledTags.empty() && !throttledTags.contains(badTag.toString())) {
				TraceEvent(SevWarnAlways, "IncorrectThrottle")
				    .detail("ThrottledTagNumber", throttledTags.size())
				    .detail("ThrottledTags", setToString(throttledTags));
				return false;
			}
			// NOTE also do eyeball check of Retries.throttle and Avg Latency
		}
		return true;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Transactions (badActor)", badActorTrNum, Averaged::False);
		m.emplace_back("Transactions (goodActor)", goodActorTrNum, Averaged::False);
		m.emplace_back("Avg Latency (ms, badActor)", 1000 * badActorTotalLatency / badActorTrNum, Averaged::True);
		m.emplace_back("Avg Latency (ms, goodActor)", 1000 * goodActorTotalLatency / goodActorTrNum, Averaged::True);

		m.emplace_back("Retries (badActor)", badActorRetries, Averaged::False);
		m.emplace_back("Retries (goodActor)", goodActorRetries, Averaged::False);

		m.emplace_back("Retries.throttle (badActor)", badActorThrottleRetries, Averaged::False);
		m.emplace_back("Retries.throttle (goodActor)", goodActorThrottleRetries, Averaged::False);

		m.emplace_back("Retries.too_old (badActor)", badActorTooOldRetries, Averaged::False);
		m.emplace_back("Retries.too_old (goodActor)", goodActorTooOldRetries, Averaged::False);

		m.emplace_back("Retries.commit_failed (badActor)", badActorCommitFailedRetries, Averaged::False);
		m.emplace_back("Retries.commit_failed (goodActor)", goodActorCommitFailedRetries, Averaged::False);

		// Read Sampling
		m.emplace_back("Avg Read Latency (ms, badActor)", 1000 * badActorReadLatency.mean(), Averaged::True);
		m.emplace_back("Avg Read Latency (ms, goodActor)", 1000 * goodActorReadLatency.mean(), Averaged::True);
		m.emplace_back("95% Read Latency (ms, badActor)", 1000 * badActorReadLatency.percentile(0.95), Averaged::True);
		m.emplace_back(
		    "95% Read Latency (ms, goodActor)", 1000 * goodActorReadLatency.percentile(0.95), Averaged::True);
		m.emplace_back("50% Read Latency (ms, badActor)", 1000 * badActorReadLatency.median(), Averaged::True);
		m.emplace_back("50% Read Latency (ms, goodActor)", 1000 * goodActorReadLatency.median(), Averaged::True);

		// Commit Sampling
		m.emplace_back("Avg Commit Latency (ms, badActor)", 1000 * badActorCommitLatency.mean(), Averaged::True);
		m.emplace_back("Avg Commit Latency (ms, goodActor)", 1000 * goodActorCommitLatency.mean(), Averaged::True);
		m.emplace_back(
		    "95% Commit Latency (ms, badActor)", 1000 * badActorCommitLatency.percentile(0.95), Averaged::True);
		m.emplace_back(
		    "95% Commit Latency (ms, goodActor)", 1000 * goodActorCommitLatency.percentile(0.95), Averaged::True);
		m.emplace_back("50% Commit Latency (ms, badActor)", 1000 * badActorCommitLatency.median(), Averaged::True);
		m.emplace_back("50% Commit Latency (ms, goodActor)", 1000 * goodActorCommitLatency.median(), Averaged::True);
	}

	Standalone<KeyValueRef> operator()(uint64_t n) { return KeyValueRef(keyForIndex(n), generateVal()); }
	// return a key based on useReadKey
	Key generateKey(bool useReadKey, int startIdx, int availableRange) {
		if (useReadKey) {
			return keyForIndex(startIdx + deterministicRandom()->randomInt(0, availableRange), false);
		}
		return getRandomKey();
	}
	// return a range based on useClearKey
	KeyRange generateRange(bool useClearKey, int startIdx, int availableRange) {
		int a, b;
		if (useClearKey) {
			a = deterministicRandom()->randomInt(startIdx, availableRange + startIdx);
			b = deterministicRandom()->randomInt(startIdx, availableRange + startIdx);
		} else {
			a = deterministicRandom()->randomInt(0, keyCount);
			b = deterministicRandom()->randomInt(0, keyCount);
		}
		if (a > b)
			std::swap(a, b);
		if (a == b)
			return singleKeyRange(keyForIndex(a, false));
		return KeyRange(KeyRangeRef(keyForIndex(a, false), keyForIndex(b, false)));
	}
	Value generateVal() { return Value(deterministicRandom()->randomAlphaNumeric(maxValueBytes)); }

	// read and write value on particular/random Key
																#line 772 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
// This generated class is to be used only via clientActor()
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
template <class ClientActorActor>
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class ClientActorActorState {
															#line 778 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	ClientActorActorState(bool const& isBadActor,int const& actorId,double const& badOpRate,Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		 : isBadActor(isBadActor),
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   actorId(actorId),
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   badOpRate(badOpRate),
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   cx(cx),
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   self(self),
															#line 222 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   startIdx((self->clientId * self->badActorPerClient + actorId) * self->rangeEachBadActor),
															#line 223 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   availableRange(std::max(int(self->rangeEachBadActor * self->hotRangeRate), 1)),
															#line 224 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   lastTime(now()),
															#line 225 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   opStart(),
															#line 226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   key()
															#line 803 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
	{
		fdb_probe_actor_create("clientActor", reinterpret_cast<unsigned long>(this));

	}
	~ClientActorActorState() 
	{
		fdb_probe_actor_destroy("clientActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 228 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				;
															#line 819 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClientActorActorState();
		static_cast<ClientActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			TraceEvent(SevError, "WriteThrottling").error(e);
															#line 296 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 851 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 229 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, self->trInterval);
															#line 229 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 874 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 1;
															#line 229 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 0, Void >*>(static_cast<ClientActorActor*>(this)));
															#line 879 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		trStart = double();
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		tr = Transaction(cx);
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		i = int();
															#line 234 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (self->writeThrottle)
															#line 894 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			ASSERT(CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION >= MIN_TAGS_PER_TRANSACTION);
															#line 236 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			tr.trState->options.tags.clear();
															#line 237 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			tr.trState->options.readTags.clear();
															#line 238 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (isBadActor)
															#line 904 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, self->badTag);
															#line 908 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
			else
			{
															#line 240 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 914 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				{
															#line 241 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
					tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, self->goodTag);
															#line 918 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				}
			}
		}
															#line 245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		trStart = now();
															#line 246 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		;
															#line 926 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		trStart = double();
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		tr = Transaction(cx);
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		i = int();
															#line 234 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (self->writeThrottle)
															#line 941 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			ASSERT(CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION >= MIN_TAGS_PER_TRANSACTION);
															#line 236 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			tr.trState->options.tags.clear();
															#line 237 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			tr.trState->options.readTags.clear();
															#line 238 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (isBadActor)
															#line 951 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, self->badTag);
															#line 955 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
			else
			{
															#line 240 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 961 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				{
															#line 241 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
					tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, self->goodTag);
															#line 965 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				}
			}
		}
															#line 245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		trStart = now();
															#line 246 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		;
															#line 973 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 285 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		double duration = now() - trStart;
															#line 286 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (isBadActor)
															#line 1059 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		{
															#line 287 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			++self->badActorTrNum;
															#line 288 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			self->badActorTotalLatency += duration;
															#line 1065 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		}
		else
		{
															#line 290 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			++self->goodActorTrNum;
															#line 291 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			self->goodActorTotalLatency += duration;
															#line 1073 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 248 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			for(i = 0;i < self->numClearPerTr;++i) {
															#line 249 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				bool useClearKey = deterministicRandom()->random01() < badOpRate;
															#line 250 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				tr.clear(self->generateRange(useClearKey, startIdx, availableRange));
															#line 1095 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			for(i = 0;i < self->numWritePerTr;++i) {
															#line 253 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				bool useReadKey = deterministicRandom()->random01() < badOpRate;
															#line 254 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				key = self->generateKey(useReadKey, startIdx, availableRange);
															#line 255 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				tr.set(key, self->generateVal());
															#line 1105 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
															#line 257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			i = 0;
															#line 1109 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 283 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		isBadActor ? ++self->badActorRetries : ++self->goodActorRetries;
															#line 1137 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 274 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 1147 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				isBadActor ? ++self->badActorTooOldRetries : ++self->goodActorTooOldRetries;
															#line 1151 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			}
			else
			{
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
				if (e.code() == error_code_not_committed)
															#line 1157 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				{
															#line 277 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
					isBadActor ? ++self->badActorCommitFailedRetries : ++self->goodActorCommitFailedRetries;
															#line 1161 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
				}
				else
				{
															#line 278 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
					if (e.code() == error_code_tag_throttled)
															#line 1167 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
					{
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
						isBadActor ? ++self->badActorThrottleRetries : ++self->goodActorThrottleRetries;
															#line 1171 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
					}
				}
			}
															#line 281 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 281 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1179 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClientActorActor*>(this)->actor_wait_state = 4;
															#line 281 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 3, Void >*>(static_cast<ClientActorActor*>(this)));
															#line 1184 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		opStart = now();
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1203 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 3;
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 2, Void >*>(static_cast<ClientActorActor*>(this)));
															#line 1208 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (!(i < self->numReadPerTr))
															#line 1224 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 258 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		bool useReadKey = deterministicRandom()->random01() < badOpRate;
															#line 259 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		ASSERT(self->keyCount >= actorId);
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		key = self->generateKey(useReadKey, startIdx, availableRange);
															#line 261 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		opStart = now();
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(key);
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1240 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 2;
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 1, Optional<Value> >*>(static_cast<ClientActorActor*>(this)));
															#line 1245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		double duration = now() - opStart;
															#line 264 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		isBadActor ? self->badActorReadLatency.addSample(duration) : self->goodActorReadLatency.addSample(duration);
															#line 257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		++i;
															#line 1271 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		double duration = now() - opStart;
															#line 264 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		isBadActor ? self->badActorReadLatency.addSample(duration) : self->goodActorReadLatency.addSample(duration);
															#line 257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		++i;
															#line 1284 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		double duration = now() - opStart;
															#line 270 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		isBadActor ? self->badActorCommitLatency.addSample(duration) : self->goodActorCommitLatency.addSample(duration);
															#line 1370 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		double duration = now() - opStart;
															#line 270 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		isBadActor ? self->badActorCommitLatency.addSample(duration) : self->goodActorCommitLatency.addSample(duration);
															#line 1381 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	bool isBadActor;
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	int actorId;
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	double badOpRate;
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Database cx;
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	WriteTagThrottlingWorkload* self;
															#line 222 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	int startIdx;
															#line 223 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	int availableRange;
															#line 224 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	double lastTime;
															#line 225 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	double opStart;
															#line 226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Key key;
															#line 230 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	double trStart;
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Transaction tr;
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	int i;
															#line 1574 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
};
// This generated class is to be used only via clientActor()
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class ClientActorActor final : public Actor<Void>, public ActorCallback< ClientActorActor, 0, Void >, public ActorCallback< ClientActorActor, 1, Optional<Value> >, public ActorCallback< ClientActorActor, 2, Void >, public ActorCallback< ClientActorActor, 3, Void >, public FastAllocated<ClientActorActor>, public ClientActorActorState<ClientActorActor> {
															#line 1579 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
	using FastAllocated<ClientActorActor>::operator new;
	using FastAllocated<ClientActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11874991111922984192UL, 14598522394155012864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClientActorActor, 0, Void >;
friend struct ActorCallback< ClientActorActor, 1, Optional<Value> >;
friend struct ActorCallback< ClientActorActor, 2, Void >;
friend struct ActorCallback< ClientActorActor, 3, Void >;
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	ClientActorActor(bool const& isBadActor,int const& actorId,double const& badOpRate,Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 1599 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		 : Actor<Void>(),
		   ClientActorActorState<ClientActorActor>(isBadActor, actorId, badOpRate, cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6021943787349627904UL, 14719853726392556032UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clientActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClientActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClientActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClientActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClientActorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
[[nodiscard]] static Future<Void> clientActor( bool const& isBadActor, int const& actorId, double const& badOpRate, Database const& cx, WriteTagThrottlingWorkload* const& self ) {
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	return Future<Void>(new ClientActorActor(isBadActor, actorId, badOpRate, cx, self));
															#line 1634 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
}

#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"

	void recordThrottledTags(std::vector<TagThrottleInfo>& tags) {
		for (auto& tag : tags) {
			throttledTags.insert(tag.tag.toString());
		}
	}
																#line 1644 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
// This generated class is to be used only via throttledTagUpdater()
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
template <class ThrottledTagUpdaterActor>
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class ThrottledTagUpdaterActorState {
															#line 1650 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	ThrottledTagUpdaterActorState(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		 : cx(cx),
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   self(self),
															#line 306 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   tags(),
															#line 307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		   db(cx.getReference())
															#line 1663 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
	{
		fdb_probe_actor_create("throttledTagUpdater", reinterpret_cast<unsigned long>(this));

	}
	~ThrottledTagUpdaterActorState() 
	{
		fdb_probe_actor_destroy("throttledTagUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
			;
															#line 1678 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThrottledTagUpdaterActorState();
		static_cast<ThrottledTagUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1710 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state = 1;
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThrottledTagUpdaterActor, 0, Void >*>(static_cast<ThrottledTagUpdaterActor*>(this)));
															#line 1715 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(tags, ThrottleApi::getThrottledTags(db, CLIENT_KNOBS->TOO_MANY, ContainsRecommended::True));
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1726 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state = 2;
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ThrottledTagUpdaterActor, 1, Void >*>(static_cast<ThrottledTagUpdaterActor*>(this)));
															#line 1731 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(tags, ThrottleApi::getThrottledTags(db, CLIENT_KNOBS->TOO_MANY, ContainsRecommended::True));
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		if (static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1742 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state = 2;
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ThrottledTagUpdaterActor, 1, Void >*>(static_cast<ThrottledTagUpdaterActor*>(this)));
															#line 1747 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state > 0) static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottledTagUpdaterActor*>(this)->ActorCallback< ThrottledTagUpdaterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottledTagUpdaterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThrottledTagUpdaterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThrottledTagUpdaterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		self->recordThrottledTags(tags);
															#line 1831 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
		self->recordThrottledTags(tags);
															#line 1840 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state > 0) static_cast<ThrottledTagUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottledTagUpdaterActor*>(this)->ActorCallback< ThrottledTagUpdaterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottledTagUpdaterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ThrottledTagUpdaterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ThrottledTagUpdaterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Database cx;
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	WriteTagThrottlingWorkload* self;
															#line 306 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	std::vector<TagThrottleInfo> tags;
															#line 307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	Reference<DatabaseContext> db;
															#line 1928 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
};
// This generated class is to be used only via throttledTagUpdater()
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
class ThrottledTagUpdaterActor final : public Actor<Void>, public ActorCallback< ThrottledTagUpdaterActor, 0, Void >, public ActorCallback< ThrottledTagUpdaterActor, 1, Void >, public FastAllocated<ThrottledTagUpdaterActor>, public ThrottledTagUpdaterActorState<ThrottledTagUpdaterActor> {
															#line 1933 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
public:
	using FastAllocated<ThrottledTagUpdaterActor>::operator new;
	using FastAllocated<ThrottledTagUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6754724910719538432UL, 10264084688167113728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThrottledTagUpdaterActor, 0, Void >;
friend struct ActorCallback< ThrottledTagUpdaterActor, 1, Void >;
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	ThrottledTagUpdaterActor(Database const& cx,WriteTagThrottlingWorkload* const& self) 
															#line 1951 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
		 : Actor<Void>(),
		   ThrottledTagUpdaterActorState<ThrottledTagUpdaterActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throttledTagUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5715779645321887488UL, 3311014435581973504UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottledTagUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throttledTagUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throttledTagUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThrottledTagUpdaterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ThrottledTagUpdaterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
[[nodiscard]] static Future<Void> throttledTagUpdater( Database const& cx, WriteTagThrottlingWorkload* const& self ) {
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"
	return Future<Void>(new ThrottledTagUpdaterActor(cx, self));
															#line 1984 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteTagThrottling.actor.g.cpp"
}

#line 314 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WriteTagThrottling.actor.cpp"

	static std::string setToString(const std::set<std::string>& myset) {
		std::string res;
		for (auto& s : myset) {
			res.append(s).push_back(' ');
		}
		return res;
	}
};

WorkloadFactory<WriteTagThrottlingWorkload> WriteTagThrottlingWorkloadFactory;
