#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
/*
 * WorkerErrors.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/ActorCollection.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/ServerDBInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WorkerErrorsWorkload : TestWorkload {
	static constexpr auto NAME = "WorkerErrors";

	WorkerErrorsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 41 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
// This generated class is to be used only via latestEventOnWorkers()
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
template <class LatestEventOnWorkersActor>
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
class LatestEventOnWorkersActorState {
															#line 47 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
public:
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	LatestEventOnWorkersActorState(std::vector<WorkerDetails> const& workers) 
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		 : workers(workers),
															#line 40 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		   eventTraces()
															#line 56 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
	{
		fdb_probe_actor_create("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkersActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			eventTraces.reserve(workers.size());
															#line 42 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			for(int c = 0;c < workers.size();c++) {
															#line 43 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
				eventTraces.push_back(workers[c].interf.eventLogRequest.getReply(EventLogRequest()));
															#line 75 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
			}
															#line 46 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(waitForAll(eventTraces), 2.0);
															#line 46 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 81 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkersActor, 0, Void >*>(static_cast<LatestEventOnWorkersActor*>(this)));
															#line 86 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		std::vector<TraceEventFields> results;
															#line 49 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		results.reserve(eventTraces.size());
															#line 50 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 51 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			results.push_back(eventTraces[i].get());
															#line 115 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		}
															#line 54 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<std::vector<TraceEventFields>>::futures) { (void)(results); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< std::vector<TraceEventFields> >::value()) std::vector<TraceEventFields>(results);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		std::vector<TraceEventFields> results;
															#line 49 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		results.reserve(eventTraces.size());
															#line 50 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 51 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			results.push_back(eventTraces[i].get());
															#line 137 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		}
															#line 54 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<std::vector<TraceEventFields>>::futures) { (void)(results); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< std::vector<TraceEventFields> >::value()) std::vector<TraceEventFields>(results);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkersActor*>(this)->ActorCallback< LatestEventOnWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 40 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	std::vector<Future<TraceEventFields>> eventTraces;
															#line 228 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
};
// This generated class is to be used only via latestEventOnWorkers()
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
class LatestEventOnWorkersActor final : public Actor<std::vector<TraceEventFields>>, public ActorCallback< LatestEventOnWorkersActor, 0, Void >, public FastAllocated<LatestEventOnWorkersActor>, public LatestEventOnWorkersActorState<LatestEventOnWorkersActor> {
															#line 233 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
public:
	using FastAllocated<LatestEventOnWorkersActor>::operator new;
	using FastAllocated<LatestEventOnWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16463502267529855488UL, 11275254707074130944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TraceEventFields>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkersActor, 0, Void >;
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	LatestEventOnWorkersActor(std::vector<WorkerDetails> const& workers) 
															#line 250 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		 : Actor<std::vector<TraceEventFields>>(),
		   LatestEventOnWorkersActorState<LatestEventOnWorkersActor>(workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17131304875114139904UL, 5790865631530653952UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
[[nodiscard]] Future<std::vector<TraceEventFields>> latestEventOnWorkers( std::vector<WorkerDetails> const& workers ) {
															#line 39 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	return Future<std::vector<TraceEventFields>>(new LatestEventOnWorkersActor(workers));
															#line 282 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
}

#line 56 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"

																#line 287 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
template <class _startActor>
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
class _startActorState {
															#line 293 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
public:
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	_startActorState(Database const& cx,WorkerErrorsWorkload* const& self) 
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		 : cx(cx),
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		   self(self)
															#line 302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 58 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 319 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 58 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, std::vector<WorkerDetails> >*>(static_cast<_startActor*>(this)));
															#line 324 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 59 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		StrictFuture<std::vector<TraceEventFields>> __when_expr_1 = self->latestEventOnWorkers(workers);
															#line 59 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 349 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, std::vector<TraceEventFields> >*>(static_cast<_startActor*>(this)));
															#line 354 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		workers = __workers;
															#line 363 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<TraceEventFields> const& errors,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		for( auto e : errors ) {
															#line 61 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			printf("%s\n", e.toString().c_str());
															#line 444 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		}
															#line 63 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> && errors,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		for( auto e : errors ) {
															#line 61 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
			printf("%s\n", e.toString().c_str());
															#line 462 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		}
															#line 63 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 466 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<TraceEventFields> const& errors,int loopDepth) 
	{
		loopDepth = a_body1cont2(errors, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<TraceEventFields> && errors,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(errors), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	Database cx;
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	WorkerErrorsWorkload* self;
															#line 58 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 555 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, std::vector<WorkerDetails> >, public ActorCallback< _startActor, 1, std::vector<TraceEventFields> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 560 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14530716661105172480UL, 6811380608616076288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< _startActor, 1, std::vector<TraceEventFields> >;
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	_startActor(Database const& cx,WorkerErrorsWorkload* const& self) 
															#line 578 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, WorkerErrorsWorkload* const& self ) {
															#line 57 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 611 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WorkerErrors.actor.g.cpp"
}

#line 65 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/WorkerErrors.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
};

WorkloadFactory<WorkerErrorsWorkload> WorkerErrorsWorkloadFactory;
