#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
/*
 * SubmitBackup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SubmitBackupWorkload : TestWorkload {
	static constexpr auto NAME = "SubmitBackup";

	FileBackupAgent backupAgent;

	Standalone<StringRef> backupDir;
	Standalone<StringRef> tag;
	double delayFor;
	int initSnapshotInterval;
	int snapshotInterval;
	StopWhenDone stopWhenDone{ false };
	IncrementalBackupOnly incremental{ false };
	Optional<std::string> encryptionKeyFileName;

	SubmitBackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupDir = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
		tag = getOption(options, "tag"_sr, "default"_sr);
		delayFor = getOption(options, "delayFor"_sr, 10.0);
		initSnapshotInterval = getOption(options, "initSnapshotInterval"_sr, 0);
		snapshotInterval = getOption(options, "snapshotInterval"_sr, 1e8);
		stopWhenDone.set(getOption(options, "stopWhenDone"_sr, true));
		incremental.set(getOption(options, "incremental"_sr, false));

		if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}
	}

																#line 62 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
template <class _startActor>
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
class _startActorState {
															#line 68 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
public:
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	_startActorState(SubmitBackupWorkload* const& self,Database const& cx) 
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		 : self(self),
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		   cx(cx)
															#line 77 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->delayFor);
															#line 61 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 94 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 99 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		backupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 63 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		addDefaultBackupRanges(backupRanges);
															#line 65 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 126 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
		{
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 137 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		backupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 63 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		addDefaultBackupRanges(backupRanges);
															#line 65 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 155 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
		{
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 161 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 66 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 70 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->backupAgent.submitBackup(cx, self->backupDir, {}, self->initSnapshotInterval, self->snapshotInterval, self->tag.toString(), backupRanges, true, self->stopWhenDone, UsePartitionedLog::False, self->incremental, self->encryptionKeyFileName);
															#line 70 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 258 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 70 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 263 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 88 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 365 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 83 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			TraceEvent("BackupSubmitError").error(e);
															#line 84 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 380 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			{
															#line 85 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 384 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
			}
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	SubmitBackupWorkload* self;
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	Database cx;
															#line 62 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18042231018675389952UL, 18073966275317680128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	_startActor(SubmitBackupWorkload* const& self,Database const& cx) 
															#line 526 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
[[nodiscard]] static Future<Void> _start( SubmitBackupWorkload* const& self, Database const& cx ) {
															#line 60 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 560 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SubmitBackup.actor.g.cpp"
}

#line 90 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/SubmitBackup.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return clientId ? Void() : _start(this, cx); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<SubmitBackupWorkload> SubmitBackupWorkloadFactory;
