#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
/*
 * BulkDumping.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/MockS3Server.h"
#include "fdbserver/MockS3ServerChaos.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"
#include "fdbrpc/simulator.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const std::string simulationBulkDumpFolder = joinPath("simfdb", "bulkdump");

struct BulkDumping : TestWorkload {
	static constexpr auto NAME = "BulkDumpingWorkload";
	const bool enabled = true;
	bool pass = true;
	int cancelTimes = 0;
	int maxCancelTimes = 0;
	int bulkLoadTransportMethod = 1; // Default to CP method
	std::string jobRoot = "";

	// Chaos injection options
	bool enableChaos = false;
	double errorRate = 0.1;
	double throttleRate = 0.05;
	double delayRate = 0.1;
	double corruptionRate = 0.01;
	double maxDelay = 2.0;

	// This workload is not compatible with following workload because they will race in changing the DD mode
	// This workload is not compatible with RandomRangeLock for the conflict in range lock
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "ValidateStorage",
		             "RandomRangeLock",
		             "BulkLoading" });
	}

	BulkDumping(WorkloadContext const& wcx)
	  : TestWorkload(wcx), enabled(true), pass(true), cancelTimes(0),
	    maxCancelTimes(getOption(options, "maxCancelTimes"_sr, deterministicRandom()->randomInt(0, 2))),
	    bulkLoadTransportMethod(getOption(options, "bulkLoadTransportMethod"_sr, 1)),
	    jobRoot(getOption(options, "jobRoot"_sr, ""_sr).toString()) {
		maxCancelTimes = 0; // TODO(BulkLoad): allow to cancel job when job ID randomly generated.

		// Initialize chaos options
		enableChaos = getOption(options, "enableChaos"_sr, false);
		errorRate = getOption(options, "errorRate"_sr, 0.1);
		throttleRate = getOption(options, "throttleRate"_sr, 0.05);
		delayRate = getOption(options, "delayRate"_sr, 0.1);
		corruptionRate = getOption(options, "corruptionRate"_sr, 0.01);
		maxDelay = getOption(options, "maxDelay"_sr, 2.0);
	}

	Future<Void> setup(Database const& cx) override { return _setup(this, cx); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(BulkDumping* self, KeyRange maxRange) const {
		loop {
			Standalone<StringRef> keyA = self->getRandomStringRef();
			Standalone<StringRef> keyB = self->getRandomStringRef();
			if (!maxRange.contains(keyA) || !maxRange.contains(keyB)) {
				continue;
			}
			KeyRange range = keyA < keyB ? KeyRangeRef(keyA, keyB) : KeyRangeRef(keyB, keyA);
			if (range.empty() || range.singleKeyRange()) {
				continue;
			}
			return range;
		}
	}

	std::map<Key, Value> generateOrderedKVS(BulkDumping* self, KeyRange maxRange, size_t count) {
		std::map<Key, Value> kvs; // ordered
		while (kvs.size() < count) {
			Key key = self->getRandomStringRef();
			if (!maxRange.contains(key)) {
				continue;
			}
			Value val = self->getRandomStringRef();
			auto res = kvs.insert({ key, val });
			if (!res.second) {
				continue;
			}
		}
		return kvs; // ordered
	}

																#line 134 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via setKeys()
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class SetKeysActor>
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActorState {
															#line 140 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActorState(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs(kvs),
															#line 133 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 151 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetKeysActorState() 
	{
		fdb_probe_actor_destroy("setKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 136 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			for( const auto& [key, value] : kvs ) {
															#line 137 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				tr.set(key, value);
															#line 199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 139 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 139 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 205 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 0, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 210 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 145 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 234 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 1, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 143 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 256 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 143 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 270 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 133 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 446 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via setKeys()
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActor final : public Actor<Void>, public ActorCallback< SetKeysActor, 0, Void >, public ActorCallback< SetKeysActor, 1, Void >, public FastAllocated<SetKeysActor>, public SetKeysActorState<SetKeysActor> {
															#line 451 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<SetKeysActor>::operator new;
	using FastAllocated<SetKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4432564511318356224UL, 3021066935887837696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeysActor, 0, Void >;
friend struct ActorCallback< SetKeysActor, 1, Void >;
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActor(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 469 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeysActorState<SetKeysActor>(cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13837835877790460416UL, 6372757415257859072UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> setKeys( Database const& cx, std::map<Key, Value> const& kvs ) {
															#line 132 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new SetKeysActor(cx, kvs));
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 149 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilDumpJobCompleteActor>
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActorState {
															#line 513 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActorState(Database const& cx) 
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 151 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 522 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilDumpJobCompleteActorState() 
	{
		fdb_probe_actor_destroy("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 152 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 537 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitUntilDumpJobCompleteActorState(); static_cast<WaitUntilDumpJobCompleteActor*>(this)->destroy(); return 0; }
															#line 560 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 154 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 155 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 156 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 156 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 586 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 591 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 168 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 168 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 621 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 3;
															#line 168 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 626 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 636 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 640 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 164 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 164 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 646 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 651 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 666 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 678 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(aliveJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(aliveJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 151 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 952 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActor final : public Actor<Void>, public ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >, public ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >, public ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >, public FastAllocated<WaitUntilDumpJobCompleteActor>, public WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor> {
															#line 957 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator new;
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12872471726242177024UL, 10778216316326800128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >;
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActor(Database const& cx) 
															#line 976 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14347013697826418176UL, 10344504171819541760UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilDumpJobComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> waitUntilDumpJobComplete( Database const& cx ) {
															#line 150 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new WaitUntilDumpJobCompleteActor(cx));
															#line 1010 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 172 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 1015 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via clearDatabase()
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ClearDatabaseActor>
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActorState {
															#line 1021 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActorState(Database const& cx) 
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 174 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 1030 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClearDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1045 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 1068 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 177 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 179 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(normalKeys);
															#line 180 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkDumpKeys);
															#line 181 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadJobKeys);
															#line 182 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadTaskKeys);
															#line 183 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadJobHistoryKeys);
															#line 184 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 184 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1104 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 0, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1109 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 187 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1146 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 2;
															#line 187 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 1, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1151 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 174 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 1340 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via clearDatabase()
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActor final : public Actor<Void>, public ActorCallback< ClearDatabaseActor, 0, Void >, public ActorCallback< ClearDatabaseActor, 1, Void >, public FastAllocated<ClearDatabaseActor>, public ClearDatabaseActorState<ClearDatabaseActor> {
															#line 1345 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ClearDatabaseActor>::operator new;
	using FastAllocated<ClearDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5869981156591439104UL, 9631549743649886976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDatabaseActor, 0, Void >;
friend struct ActorCallback< ClearDatabaseActor, 1, Void >;
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActor(Database const& cx) 
															#line 1363 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ClearDatabaseActorState<ClearDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2535882093937434112UL, 5291521835449874944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> clearDatabase( Database const& cx ) {
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ClearDatabaseActor(cx));
															#line 1396 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 192 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 1401 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via clearRangeData()
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ClearRangeDataActor>
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearRangeDataActorState {
															#line 1407 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearRangeDataActorState(Database const& cx,KeyRange const& range) 
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   range(range),
															#line 194 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 1418 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("clearRangeData", reinterpret_cast<unsigned long>(this));

	}
	~ClearRangeDataActorState() 
	{
		fdb_probe_actor_destroy("clearRangeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1433 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearRangeDataActorState();
		static_cast<ClearRangeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 205 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ClearRangeDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearRangeDataActorState(); static_cast<ClearRangeDataActor*>(this)->destroy(); return 0; }
															#line 1456 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ClearRangeDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearRangeDataActorState();
		static_cast<ClearRangeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 197 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 198 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(range);
															#line 199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1482 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 1;
															#line 199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearRangeDataActor, 0, Void >*>(static_cast<ClearRangeDataActor*>(this)));
															#line 1487 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 202 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1524 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearRangeDataActor, 1, Void >*>(static_cast<ClearRangeDataActor*>(this)));
															#line 1529 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeDataActor*>(this)->ActorCallback< ClearRangeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearRangeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeDataActor*>(this)->ActorCallback< ClearRangeDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearRangeDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange range;
															#line 194 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 1720 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via clearRangeData()
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearRangeDataActor final : public Actor<Void>, public ActorCallback< ClearRangeDataActor, 0, Void >, public ActorCallback< ClearRangeDataActor, 1, Void >, public FastAllocated<ClearRangeDataActor>, public ClearRangeDataActorState<ClearRangeDataActor> {
															#line 1725 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ClearRangeDataActor>::operator new;
	using FastAllocated<ClearRangeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15439107894043627264UL, 7191614441070289664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearRangeDataActor, 0, Void >;
friend struct ActorCallback< ClearRangeDataActor, 1, Void >;
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearRangeDataActor(Database const& cx,KeyRange const& range) 
															#line 1743 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ClearRangeDataActorState<ClearRangeDataActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18334867820139837184UL, 17574362521324748544UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearRangeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearRangeDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearRangeDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> clearRangeData( Database const& cx, KeyRange const& range ) {
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ClearRangeDataActor(cx, range));
															#line 1776 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 207 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	// Return error tasks
																#line 1782 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState {
															#line 1788 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange),
															#line 212 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   rangeResult(),
															#line 213 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   beginKey(jobRange.begin),
															#line 214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   endKey(jobRange.end),
															#line 215 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 216 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   errorTasks()
															#line 1809 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState() 
	{
		fdb_probe_actor_destroy("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "ValidateAllBulkLoadTaskAcknowledgedOrError") .detail("Job", jobId.toString()) .detail("Range", jobRange);
															#line 221 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1826 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 259 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(); static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->destroy(); return 0; }
															#line 1849 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::move(errorTasks)); // state_var_RVO
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!(beginKey < endKey))
															#line 1868 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 223 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 224 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 225 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			rangeResult.clear();
															#line 226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rangeResult, krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(beginKey, endKey)));
															#line 226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1883 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1888 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 256 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1925 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1930 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 228 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 1947 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 1955 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 1961 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 236 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 1965 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 238 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 1969 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 243 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 1975 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 1979 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 247 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 251 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 1985 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 254 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 1990 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 228 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 2001 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 2009 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 2015 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 236 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 2019 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 238 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2023 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 243 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 2029 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2033 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 247 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 251 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 2039 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 254 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 2044 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 212 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	RangeResult rangeResult;
															#line 213 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key beginKey;
															#line 214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key endKey;
															#line 215 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 216 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 2240 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >, public FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>, public ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor> {
															#line 2245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator new;
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14839418024798360576UL, 4551555151212468736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >;
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >;
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 2263 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>(cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11830555534422417920UL, 14829119776246766336UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateAllBulkLoadTaskAcknowledgedOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> validateAllBulkLoadTaskAcknowledgedOrError( Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(cx, jobId, jobRange));
															#line 2296 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 261 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 2301 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilLoadJobCompleteOrErrorActor>
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActorState {
															#line 2307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActorState(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx),
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange)
															#line 2320 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilLoadJobCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 2335 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Optional<BulkLoadJobState>> __when_expr_0 = getRunningBulkLoadJob(cx);
															#line 267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2367 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2372 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 2381 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 269 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 274 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 2387 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2393 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2398 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 2417 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 269 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 274 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 2423 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2429 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 276 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2434 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(runningJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(runningJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 289 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_4 = self->validateAllBulkLoadTaskAcknowledgedOrError(cx, jobId, jobRange);
															#line 289 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2530 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 5;
															#line 289 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 286 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 286 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2546 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 4;
															#line 286 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2551 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 277 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 278 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->clearRangeData(cx, jobRange);
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2566 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 3;
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2571 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 277 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 278 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->clearRangeData(cx, jobRange);
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2586 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 3;
															#line 279 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2591 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Data Cleared") .detail("Job", jobId.toString()) .detail("JobRange", jobRange);
															#line 284 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2677 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Data Cleared") .detail("Job", jobId.toString()) .detail("JobRange", jobRange);
															#line 284 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2691 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2865 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2877 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 2968 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >, public FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>, public WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor> {
															#line 2973 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator new;
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8593435669156933376UL, 1802401471225144576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >;
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActor(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 2994 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor>(self, cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16253690126426733056UL, 3412635736290458112UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilLoadJobCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> waitUntilLoadJobCompleteOrError( BulkDumping* const& self, Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new WaitUntilLoadJobCompleteOrErrorActor(self, cx, jobId, jobRange));
															#line 3030 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 294 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 3035 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateBulkLoadJobHistoryActor>
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActorState {
															#line 3041 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActorState(Database const& cx,UID const& jobId,bool const& hasError,bool const& bulkDumpRangeContainBulkLoadRange) 
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   hasError(hasError),
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   bulkDumpRangeContainBulkLoadRange(bulkDumpRangeContainBulkLoadRange)
															#line 3054 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	~ValidateBulkLoadJobHistoryActorState() 
	{
		fdb_probe_actor_destroy("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<std::vector<BulkLoadJobState>> __when_expr_0 = getBulkLoadJobFromHistory(cx);
															#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3071 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 1;
															#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*>(static_cast<ValidateBulkLoadJobHistoryActor*>(this)));
															#line 3076 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 301 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 303 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 304 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 3109 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError || !bulkDumpRangeContainBulkLoadRange)
															#line 3115 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getErrorMessage().present());
															#line 311 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (jobInHistory.get().getErrorMessage().get().find( std::to_string(bulkload_dataset_not_cover_required_range().code())) != std::string::npos)
															#line 3123 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(!bulkDumpRangeContainBulkLoadRange);
															#line 3127 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
		else
		{
															#line 316 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 3134 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 3138 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 301 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 303 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 304 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 3160 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError || !bulkDumpRangeContainBulkLoadRange)
															#line 3166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getErrorMessage().present());
															#line 311 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (jobInHistory.get().getErrorMessage().get().find( std::to_string(bulkload_dataset_not_cover_required_range().code())) != std::string::npos)
															#line 3174 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(!bulkDumpRangeContainBulkLoadRange);
															#line 3178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
		else
		{
															#line 316 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 3185 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 3189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(jobHistory, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(jobHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state > 0) static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool bulkDumpRangeContainBulkLoadRange;
															#line 3280 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActor final : public Actor<Void>, public ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >, public FastAllocated<ValidateBulkLoadJobHistoryActor>, public ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor> {
															#line 3285 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator new;
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3451732295577917952UL, 882099176764345344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >;
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActor(Database const& cx,UID const& jobId,bool const& hasError,bool const& bulkDumpRangeContainBulkLoadRange) 
															#line 3302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor>(cx, jobId, hasError, bulkDumpRangeContainBulkLoadRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460049204226600192UL, 15679977865403206656UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateBulkLoadJobHistory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> validateBulkLoadJobHistory( Database const& cx, UID const& jobId, bool const& hasError, bool const& bulkDumpRangeContainBulkLoadRange ) {
															#line 295 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ValidateBulkLoadJobHistoryActor(cx, jobId, hasError, bulkDumpRangeContainBulkLoadRange));
															#line 3334 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 320 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 3339 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via getAllKVSFromDB()
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class GetAllKVSFromDBActor>
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActorState {
															#line 3345 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActorState(Database const& cx) 
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 322 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 323 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs()
															#line 3356 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetAllKVSFromDBActorState() 
	{
		fdb_probe_actor_destroy("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 324 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 3371 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 338 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<GetAllKVSFromDBActor*>(this)->SAV<std::map<Key, Value>>::futures) { (void)(kvs); this->~GetAllKVSFromDBActorState(); static_cast<GetAllKVSFromDBActor*>(this)->destroy(); return 0; }
															#line 3394 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<GetAllKVSFromDBActor*>(this)->SAV< std::map<Key, Value> >::value()) std::map<Key, Value>(std::move(kvs)); // state_var_RVO
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 326 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 326 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3416 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 1;
															#line 326 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 3421 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 335 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 335 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3458 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 2;
															#line 335 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 1, Void >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 3463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvsRes,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 328 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 329 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 330 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 331 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 3486 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvsRes,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 328 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 329 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 330 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 331 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 3504 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvsRes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvsRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 322 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 323 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 3678 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via getAllKVSFromDB()
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActor final : public Actor<std::map<Key, Value>>, public ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >, public ActorCallback< GetAllKVSFromDBActor, 1, Void >, public FastAllocated<GetAllKVSFromDBActor>, public GetAllKVSFromDBActorState<GetAllKVSFromDBActor> {
															#line 3683 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<GetAllKVSFromDBActor>::operator new;
	using FastAllocated<GetAllKVSFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2465076235865994496UL, 15958049401465559552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<Key, Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetAllKVSFromDBActor, 1, Void >;
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActor(Database const& cx) 
															#line 3701 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::map<Key, Value>>(),
		   GetAllKVSFromDBActorState<GetAllKVSFromDBActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17382421922843443968UL, 2360388894854266368UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAllKVSFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::map<Key, Value>> getAllKVSFromDB( Database const& cx ) {
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::map<Key, Value>>(new GetAllKVSFromDBActor(cx));
															#line 3734 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 340 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	bool keyContainedInRanges(const Key& key, const std::vector<KeyRange>& ranges) {
		for (const auto& range : ranges) {
			if (range.contains(key)) {
				return true;
			}
		}
		return false;
	}

	// kvs is the key value pairs generated initially in the database.
	// newKvs is the key value pairs loaded by the bulk loading job.
	// The workload first does bulkdump which only dumps the data within the bulkDumpJobRange.
	// The workload then does bulkload which loads the data within the bulkLoadJobRange.
	// The bulkLoadJob may be failed with unretryable error. So, some ranges (i.e. ignoreRanges) is not loaded.
	// This function compares the consistency between kvs and newKvs within bulkLoadJobRange and bulkDumpJobRange and
	// outside ignoreRanges. If a key in kvs is outside the bulkDumpJobRange, the newKvs should not contain the key.
	void processCheck(BulkDumping* self,
	                  std::map<Key, Value> kvs,
	                  std::map<Key, Value> newKvs,
	                  KeyRange bulkLoadJobRange,
	                  KeyRange bulkDumpJobRange,
	                  std::vector<KeyRange> ignoreRanges) {
		std::vector<KeyValue> kvsToCheck;
		std::vector<KeyValue> newKvsToCheck;
		std::unordered_set<Key> keyOutsideDumpData;
		for (const auto& [key, value] : kvs) {
			if (!bulkDumpJobRange.contains(key)) {
				keyOutsideDumpData.insert(key);
				continue; // kvs may contain keys outside the bulkDumpJobRange
			}
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			if (!bulkLoadJobRange.contains(key)) {
				continue; // kvs may contain keys outside the bulkLoadJobRange
			}
			kvsToCheck.push_back(KeyValueRef(key, value));
		}
		for (const auto& [key, value] : newKvs) {
			// newKvs should not contain keys outside the bulkDumpJobRange
			ASSERT(keyOutsideDumpData.find(key) == keyOutsideDumpData.end() && bulkDumpJobRange.contains(key));
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			// newKvs should not contain keys outside the bulkLoadJobRange nor bulkDumpJobRange
			ASSERT(bulkLoadJobRange.contains(key));
			ASSERT(bulkDumpJobRange.contains(key));
			newKvsToCheck.push_back(KeyValueRef(key, value));
		}
		if (kvsToCheck != newKvsToCheck) {
			TraceEvent(SevError, "BulkDumpingWorkLoadError")
			    .detail("KVS", kvsToCheck.size())
			    .detail("NewKVS", newKvsToCheck.size());
			ASSERT(false);
		}
	}

	// This workload does following:
	// (1) Generate 1000 key value pairs in normalKey space;
	// (2) Randomly select a key range from normalKey space;
	// (3) Submit a bulk dump job with the selected key range;
	// (4) Wait until the bulk dump job completes;
	// (5) Clear the database;
	// (6) Randomly select a key range from normalKey space;
	// (7) Submit a bulk load job with the selected key range;
	// (8) Wait until the bulk load job completes;
	// (9) Validate the loaded data in DB is same as the data in DB before dumping within the bulkdump job range and
	// bulkload job range. Note that the bulkload job can be unretriable error. In this case, we ignore the error range;
	// (10) Validate the bulk load job history.
																#line 3808 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class _startActor>
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActorState {
															#line 3814 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActorState(BulkDumping* const& self,Database const& cx) 
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx)
															#line 3823 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 411 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->clientId != 0)
															#line 3838 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 412 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3842 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 417 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->bulkLoadTransportMethod == 2 && g_network->isSimulated())
															#line 3850 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 419 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				clearMockS3Storage();
															#line 3854 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 422 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (g_network->isSimulated())
															#line 3858 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 426 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				disableConnectionFailures("BulkDumping");
															#line 3862 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 429 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpJobRange = deterministicRandom()->coinflip() ? normalKeys : self->getRandomRange(self, normalKeys);
															#line 432 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 437 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			kvs = self->generateOrderedKVS(self, normalKeys, 1000);
															#line 438 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->setKeys(cx, kvs);
															#line 438 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3874 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 438 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3879 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3904 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3909 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3920 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 441 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3925 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4011 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 4016 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4027 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 4032 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
															#line 444 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 447 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4122 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4127 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
															#line 444 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 447 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4142 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 448 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4147 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont6(lockOwners, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(lockOwners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 449 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dumpFolder = self->jobRoot.empty() ? simulationBulkDumpFolder : self->jobRoot;
															#line 450 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkDumpJob = createBulkDumpJob(bulkDumpJobRange, dumpFolder, BulkLoadType::SST, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4237 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4242 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 449 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dumpFolder = self->jobRoot.empty() ? simulationBulkDumpFolder : self->jobRoot;
															#line 450 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkDumpJob = createBulkDumpJob(bulkDumpJobRange, dumpFolder, BulkLoadType::SST, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 455 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4262 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 456 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Dump Job Submitted") .detail("TransportMethod", self->bulkLoadTransportMethod) .detail("JobRoot", dumpFolder) .detail("Job", bulkDumpJob.toString());
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4350 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 4355 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 456 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Dump Job Submitted") .detail("TransportMethod", self->bulkLoadTransportMethod) .detail("JobRoot", dumpFolder) .detail("Job", bulkDumpJob.toString());
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4368 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 463 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 4373 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 464 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", bulkDumpJob.toString());
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4461 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 4466 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 464 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", bulkDumpJob.toString());
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4479 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 467 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 4484 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", bulkDumpJob.toString());
															#line 471 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4574 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4579 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", bulkDumpJob.toString());
															#line 471 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4594 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 472 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4599 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4683 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4692 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 541 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_14 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockNameForBulkLoad);
															#line 541 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4778 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 541 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<_startActor*>(this)));
															#line 4783 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 476 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		hasError = false;
															#line 477 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldCancelTimes = self->cancelTimes;
															#line 478 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkLoadJobRange = deterministicRandom()->coinflip() ? bulkDumpJob.getJobRange() : self->getRandomRange(self, deterministicRandom()->coinflip() ? normalKeys : bulkDumpJobRange);
															#line 482 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dataSourceId = bulkDumpJob.getJobId();
															#line 483 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dataSourceRoot = bulkDumpJob.getJobRoot();
															#line 484 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkLoadJob = createBulkLoadJob(dataSourceId, bulkLoadJobRange, dataSourceRoot, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 489 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_8 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 489 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4813 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 489 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4818 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Submitted") .detail("JobId", dataSourceId) .detail("JobRange", bulkLoadJobRange) .detail("JobRoot", dataSourceRoot) .detail("TransportMethod", bulkLoadJob.getTransportMethod());
															#line 498 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4846 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4851 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Submitted") .detail("JobId", dataSourceId) .detail("JobRange", bulkLoadJobRange) .detail("JobRoot", dataSourceRoot) .detail("TransportMethod", bulkLoadJob.getTransportMethod());
															#line 498 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4866 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4871 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1loopBody1cont2(int loopDepth) 
	{
															#line 503 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(self->cancelTimes >= oldCancelTimes);
															#line 504 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (self->cancelTimes > oldCancelTimes)
															#line 4957 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 506 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(deterministicRandom()->random01() * 10.0);
															#line 506 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4963 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont2when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 506 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4968 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> const& __errorTasks,int loopDepth) 
	{
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorTasks = __errorTasks;
															#line 4982 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> && __errorTasks,int loopDepth) 
	{
		errorTasks = std::move(__errorTasks);
		loopDepth = a_body1cont10cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1loopBody1cont3(int loopDepth) 
	{
															#line 509 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 510 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 511 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			hasError = true;
															#line 5065 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 513 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Complete") .detail("BulkLoadJobId", dataSourceId) .detail("BulkLoadJobRange", bulkLoadJobRange) .detail("BulkLoadJobRoot", dataSourceRoot) .detail("BulkLoadTransportMethod", bulkLoadJob.getTransportMethod());
															#line 521 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::map<Key, Value>> __when_expr_11 = self->getAllKVSFromDB(cx);
															#line 521 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5073 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 521 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, std::map<Key, Value> >*>(static_cast<_startActor*>(this)));
															#line 5078 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont10cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont10cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont1loopBody1cont6(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
															#line 522 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (bulkDumpJobRange.contains(bulkLoadJobRange))
															#line 5174 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 523 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			self->processCheck(self, kvs, newKvs, bulkLoadJobRange, bulkDumpJobRange, errorRanges);
															#line 524 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 5180 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 526 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkDumpingWorkLoad") .detail("Phase", "SkippedCheck") .detail("BulkDumpJobRange", bulkDumpJobRange) .detail("BulkLoadJobRange", bulkLoadJobRange);
															#line 530 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = false;
															#line 5188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5194 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6(std::map<Key, Value> && newKvs,int loopDepth) 
	{
															#line 522 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (bulkDumpJobRange.contains(bulkLoadJobRange))
															#line 5208 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 523 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			self->processCheck(self, kvs, newKvs, bulkLoadJobRange, bulkDumpJobRange, errorRanges);
															#line 524 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 5214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 526 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkDumpingWorkLoad") .detail("Phase", "SkippedCheck") .detail("BulkDumpJobRange", bulkDumpJobRange) .detail("BulkLoadJobRange", bulkLoadJobRange);
															#line 530 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = false;
															#line 5222 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5228 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 534 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5233 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3when1(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(newKvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3when1(std::map<Key, Value> && newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(std::move(newKvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, std::map<Key, Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, std::map<Key, Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory( cx, bulkLoadJob.getJobId(), hasError, bulkDumpRangeContainBulkLoadRange);
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5319 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5324 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory( cx, bulkLoadJob.getJobId(), hasError, bulkDumpRangeContainBulkLoadRange);
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5335 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 535 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5340 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont3(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5515 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5520 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5533 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5538 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5624 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 5629 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5640 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 547 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 5645 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont5(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 550 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5731 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont5(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 550 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5745 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(lockOwnersAfterRemove, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(lockOwnersAfterRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 429 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange bulkDumpJobRange;
															#line 432 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool bulkDumpRangeContainBulkLoadRange;
															#line 437 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 447 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkDumpMode;
															#line 449 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::string dumpFolder;
															#line 450 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumpState bulkDumpJob;
															#line 471 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkLoadMode;
															#line 476 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 477 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldCancelTimes;
															#line 478 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange bulkLoadJobRange;
															#line 482 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID dataSourceId;
															#line 483 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::string dataSourceRoot;
															#line 484 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkLoadJobState bulkLoadJob;
															#line 498 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 5862 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, std::map<Key, Value> >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5867 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17519339641783424000UL, 8240090921083047936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, std::map<Key, Value> >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >;
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActor(BulkDumping* const& self,Database const& cx) 
															#line 5900 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, std::map<Key, Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> _start( BulkDumping* const& self, Database const& cx ) {
															#line 410 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 5948 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 552 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 5953 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class _setupActor>
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _setupActorState {
															#line 5959 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_setupActorState(BulkDumping* const& self,Database const& cx) 
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx)
															#line 5968 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 555 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->clientId == 0 && self->bulkLoadTransportMethod == 2)
															#line 5983 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 557 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				bool useMockS3 = self->jobRoot.find("127.0.0.1") != std::string::npos || self->jobRoot.find("localhost") != std::string::npos || self->jobRoot.find("mock-s3-server") != std::string::npos;
															#line 561 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (useMockS3 && g_network->isSimulated())
															#line 5989 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				{
															#line 563 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					std::string serverKey = "127.0.0.1:8080";
															#line 564 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					bool alreadyRegistered = g_simulator->httpHandlers.count(serverKey) > 0;
															#line 566 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					if (alreadyRegistered)
															#line 5997 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
					{
															#line 567 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
						TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3Server Already Registered") .detail("Address", serverKey) .detail("ChaosRequested", self->enableChaos) .detail("Reason", "Reusing existing HTTP handler from previous test");
															#line 6001 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
						loopDepth = a_body1cont3(loopDepth);
					}
					else
					{
															#line 572 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
						if (self->enableChaos)
															#line 6008 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
						{
															#line 573 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							TraceEvent("BulkDumpingWorkload") .detail("Phase", "Starting MockS3ServerChaos") .detail("JobRoot", self->jobRoot);
															#line 578 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							NetworkAddress listenAddress(IPAddress(0x7f000001), 8080);
															#line 579 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							StrictFuture<Void> __when_expr_0 = startMockS3ServerChaos(listenAddress);
															#line 579 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6018 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
							if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
							static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 579 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 6023 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 585 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							TraceEvent("BulkDumpingWorkload") .detail("Phase", "Registering MockS3Server") .detail("JobRoot", self->jobRoot);
															#line 590 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							StrictFuture<Void> __when_expr_1 = registerMockS3Server("127.0.0.1", "8080");
															#line 590 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6034 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 590 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 6039 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
							loopDepth = 0;
						}
					}
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 601 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (self->enableChaos && g_network->isSimulated())
															#line 6074 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 602 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto injector = S3FaultInjector::injector();
															#line 603 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			injector->setErrorRate(self->errorRate);
															#line 604 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			injector->setThrottleRate(self->throttleRate);
															#line 605 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			injector->setDelayRate(self->delayRate);
															#line 606 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			injector->setCorruptionRate(self->corruptionRate);
															#line 607 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			injector->setMaxDelay(self->maxDelay);
															#line 609 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent("BulkDumpingWorkload") .detail("Phase", "Chaos Configured") .detail("ClientID", self->clientId) .detail("ErrorRate", self->errorRate) .detail("ThrottleRate", self->throttleRate) .detail("DelayRate", self->delayRate) .detail("CorruptionRate", self->corruptionRate);
															#line 6090 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 618 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 6094 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3ServerChaos Started") .detail("Address", "127.0.0.1:8080");
															#line 6124 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3ServerChaos Started") .detail("Address", "127.0.0.1:8080");
															#line 6133 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 6217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 6226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 6310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 6315 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(69532071507573760UL, 11578610421344918016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_setupActor(BulkDumping* const& self,Database const& cx) 
															#line 6333 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> _setup( BulkDumping* const& self, Database const& cx ) {
															#line 553 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 6366 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 620 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
};

WorkloadFactory<BulkDumping> BulkDumpingFactory;
