#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
/*
 * LocalConfiguration.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/IKnobCollection.h"
#include "fdbrpc/Stats.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbserver/OnDemandStore.h"
#include "flow/UnitTest.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

const KeyRef configPathKey = "configPath"_sr;
const KeyRef lastSeenVersionKey = "lastSeenVersion"_sr;
const KeyRangeRef knobOverrideKeys = KeyRangeRef("knobOverride/"_sr, "knobOverride0"_sr);

KeyRef stringToKeyRef(std::string const& s) {
	return StringRef(reinterpret_cast<uint8_t const*>(s.c_str()), s.size());
}

} // namespace

class LocalConfigurationImpl {
	UID id;
	OnDemandStore kvStore;
	Version lastSeenVersion{ 0 };
	std::unique_ptr<IKnobCollection> testKnobCollection;
	Future<Void> initFuture;

	class ConfigKnobOverrides {
		Standalone<VectorRef<KeyRef>> configPath;
		std::map<Optional<Key>, std::map<Key, KnobValue>> configClassToKnobToValue;

	public:
		ConfigKnobOverrides() = default;
		explicit ConfigKnobOverrides(std::string const& paramString) {
			configClassToKnobToValue[{}] = {};
			if (std::all_of(paramString.begin(), paramString.end(), [](char c) {
				    return isalpha(c) || isdigit(c) || c == '/' || c == '-';
			    })) {
				StringRef s = stringToKeyRef(paramString);
				while (s.size()) {
					configPath.push_back_deep(configPath.arena(), s.eat("/"_sr));
					configClassToKnobToValue[configPath.back()] = {};
				}
			} else {
				CODE_PROBE(true, "Invalid configuration path");
				if (!g_network->isSimulated()) {
					fprintf(stderr, "WARNING: Invalid configuration path: `%s'\n", paramString.c_str());
				}
				throw invalid_config_path();
			}
		}
		ConfigClassSet getConfigClassSet() const { return ConfigClassSet(configPath); }
		void set(Optional<KeyRef> configClass, KeyRef knobName, KnobValueRef value) {
			configClassToKnobToValue[configClass.castTo<Key>()][knobName] = value;
		}
		void remove(Optional<KeyRef> configClass, KeyRef knobName) {
			configClassToKnobToValue[configClass.castTo<Key>()].erase(knobName);
		}

		void update(IKnobCollection& knobCollection) const {
			// Apply global overrides
			const auto& knobToValue = configClassToKnobToValue.at({});
			for (const auto& [knobName, knobValue] : knobToValue) {
				try {
					knobCollection.setKnob(knobName.toString(), knobValue);
				} catch (Error& e) {
					if (e.code() == error_code_invalid_option_value) {
						CODE_PROBE(true, "invalid knob in configuration database");
						TraceEvent(SevWarnAlways, "InvalidKnobOptionValue")
						    .detail("KnobName", knobName)
						    .detail("KnobValue", knobValue.toString());
					} else {
						throw e;
					}
				}
			}
			// Apply specific overrides
			for (const auto& configClass : configPath) {
				const auto& knobToValue = configClassToKnobToValue.at(configClass);
				for (const auto& [knobName, knobValue] : knobToValue) {
					knobCollection.setKnob(knobName.toString(), knobValue);
				}
			}
		}

		bool hasSameConfigPath(ConfigKnobOverrides const& other) const { return configPath == other.configPath; }

		template <class Ar>
		void serialize(Ar& ar) {
			serializer(ar, configPath);
		}
	} configKnobOverrides;

	class ManualKnobOverrides {
		std::map<Key, KnobValue> overrides;

	public:
		explicit ManualKnobOverrides(std::map<std::string, std::string> const& overrides) {
			for (const auto& [knobName, knobValueString] : overrides) {
				try {
					auto knobValue =
					    IKnobCollection::parseKnobValue(knobName, knobValueString, IKnobCollection::Type::TEST);
					this->overrides[stringToKeyRef(knobName)] = knobValue;
				} catch (Error& e) {
					if (e.code() == error_code_invalid_option) {
						CODE_PROBE(true, "Attempted to manually set invalid knob option");
						TraceEvent(SevWarnAlways, "UnrecognizedKnobOption").detail("Knob", printable(knobName));
					} else if (e.code() == error_code_invalid_option_value) {
						CODE_PROBE(true, "Invalid manually set knob value");
						TraceEvent(SevWarnAlways, "InvalidKnobValue")
						    .detail("Knob", printable(knobName))
						    .detail("Value", printable(knobValueString));
					} else {
						throw e;
					}
				}
			}
		}

		void update(IKnobCollection& knobCollection) {
			for (const auto& [knobName, knobValue] : overrides) {
				knobCollection.setKnob(knobName.toString(), knobValue);
			}
		}
	} manualKnobOverrides;

	IKnobCollection& getKnobs() {
		return testKnobCollection ? *testKnobCollection : IKnobCollection::getMutableGlobalKnobCollection();
	}

	IKnobCollection const& getKnobs() const {
		return testKnobCollection ? *testKnobCollection : IKnobCollection::getGlobalKnobCollection();
	}

	CounterCollection cc;
	Counter snapshots;
	Counter changeRequestsFetched;
	Counter mutations;
	Future<Void> logger;

																#line 164 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via saveConfigPath()
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class SaveConfigPathActor>
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class SaveConfigPathActorState {
															#line 170 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	SaveConfigPathActorState(LocalConfigurationImpl* const& self) 
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self)
															#line 177 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("saveConfigPath", reinterpret_cast<unsigned long>(this));

	}
	~SaveConfigPathActorState() 
	{
		fdb_probe_actor_destroy("saveConfigPath", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 163 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->set( KeyValueRef(configPathKey, BinaryWriter::toValue(self->configKnobOverrides, IncludeVersion())));
															#line 165 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->kvStore->commit();
															#line 165 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<SaveConfigPathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 196 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SaveConfigPathActor*>(this)->actor_wait_state = 1;
															#line 165 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SaveConfigPathActor, 0, Void >*>(static_cast<SaveConfigPathActor*>(this)));
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SaveConfigPathActorState();
		static_cast<SaveConfigPathActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<SaveConfigPathActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveConfigPathActorState(); static_cast<SaveConfigPathActor*>(this)->destroy(); return 0; }
															#line 224 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<SaveConfigPathActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveConfigPathActorState();
		static_cast<SaveConfigPathActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<SaveConfigPathActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveConfigPathActorState(); static_cast<SaveConfigPathActor*>(this)->destroy(); return 0; }
															#line 236 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<SaveConfigPathActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveConfigPathActorState();
		static_cast<SaveConfigPathActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SaveConfigPathActor*>(this)->actor_wait_state > 0) static_cast<SaveConfigPathActor*>(this)->actor_wait_state = 0;
		static_cast<SaveConfigPathActor*>(this)->ActorCallback< SaveConfigPathActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveConfigPathActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveConfigPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SaveConfigPathActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveConfigPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SaveConfigPathActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveConfigPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveConfigPath", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via saveConfigPath()
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class SaveConfigPathActor final : public Actor<Void>, public ActorCallback< SaveConfigPathActor, 0, Void >, public FastAllocated<SaveConfigPathActor>, public SaveConfigPathActorState<SaveConfigPathActor> {
															#line 326 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<SaveConfigPathActor>::operator new;
	using FastAllocated<SaveConfigPathActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13090070267601939456UL, 15153184864457209088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SaveConfigPathActor, 0, Void >;
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	SaveConfigPathActor(LocalConfigurationImpl* const& self) 
															#line 343 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   SaveConfigPathActorState<SaveConfigPathActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("saveConfigPath", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1612848299379943424UL, 9025030512938815488UL);
		ActorExecutionContextHelper __helper(static_cast<SaveConfigPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("saveConfigPath");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("saveConfigPath", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SaveConfigPathActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> saveConfigPath( LocalConfigurationImpl* const& self ) {
															#line 162 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new SaveConfigPathActor(self));
															#line 375 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 168 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 380 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via clearKVStore()
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class ClearKVStoreActor>
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ClearKVStoreActorState {
															#line 386 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ClearKVStoreActorState(LocalConfigurationImpl* const& self) 
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self)
															#line 393 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("clearKVStore", reinterpret_cast<unsigned long>(this));

	}
	~ClearKVStoreActorState() 
	{
		fdb_probe_actor_destroy("clearKVStore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->clear(singleKeyRange(configPathKey));
															#line 171 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->clear(knobOverrideKeys);
															#line 172 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->kvStore->commit();
															#line 172 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<ClearKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 414 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearKVStoreActor*>(this)->actor_wait_state = 1;
															#line 172 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearKVStoreActor, 0, Void >*>(static_cast<ClearKVStoreActor*>(this)));
															#line 419 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearKVStoreActorState();
		static_cast<ClearKVStoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<ClearKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKVStoreActorState(); static_cast<ClearKVStoreActor*>(this)->destroy(); return 0; }
															#line 442 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<ClearKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKVStoreActorState();
		static_cast<ClearKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<ClearKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKVStoreActorState(); static_cast<ClearKVStoreActor*>(this)->destroy(); return 0; }
															#line 454 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<ClearKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKVStoreActorState();
		static_cast<ClearKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearKVStoreActor*>(this)->actor_wait_state > 0) static_cast<ClearKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClearKVStoreActor*>(this)->ActorCallback< ClearKVStoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearKVStoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearKVStoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearKVStoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 539 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via clearKVStore()
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ClearKVStoreActor final : public Actor<Void>, public ActorCallback< ClearKVStoreActor, 0, Void >, public FastAllocated<ClearKVStoreActor>, public ClearKVStoreActorState<ClearKVStoreActor> {
															#line 544 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<ClearKVStoreActor>::operator new;
	using FastAllocated<ClearKVStoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10186368528725380352UL, 11071042972735486976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearKVStoreActor, 0, Void >;
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ClearKVStoreActor(LocalConfigurationImpl* const& self) 
															#line 561 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   ClearKVStoreActorState<ClearKVStoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearKVStore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(909084975253004544UL, 12819903736942572544UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearKVStore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearKVStore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearKVStoreActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> clearKVStore( LocalConfigurationImpl* const& self ) {
															#line 169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new ClearKVStoreActor(self));
															#line 593 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 175 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 598 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via getLastSeenVersion()
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class GetLastSeenVersionActor>
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class GetLastSeenVersionActorState {
															#line 604 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	GetLastSeenVersionActorState(LocalConfigurationImpl* const& self) 
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self),
															#line 177 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   result(0)
															#line 613 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("getLastSeenVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLastSeenVersionActorState() 
	{
		fdb_probe_actor_destroy("getLastSeenVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(lastSeenVersionKey);
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 630 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >*>(static_cast<GetLastSeenVersionActor*>(this)));
															#line 635 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLastSeenVersionActorState();
		static_cast<GetLastSeenVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!lastSeenVersionValue.present())
															#line 658 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 180 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->set(KeyValueRef(lastSeenVersionKey, BinaryWriter::toValue(result, IncludeVersion())));
															#line 181 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 181 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 666 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLastSeenVersionActor, 1, Void >*>(static_cast<GetLastSeenVersionActor*>(this)));
															#line 671 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 183 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			result = BinaryReader::fromStringRef<Version>(lastSeenVersionValue.get(), IncludeVersion());
															#line 678 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& __lastSeenVersionValue,int loopDepth) 
	{
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		lastSeenVersionValue = __lastSeenVersionValue;
															#line 688 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && __lastSeenVersionValue,int loopDepth) 
	{
		lastSeenVersionValue = std::move(__lastSeenVersionValue);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastSeenVersionActor*>(this)->ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 185 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<GetLastSeenVersionActor*>(this)->SAV<Version>::futures) { (void)(result); this->~GetLastSeenVersionActorState(); static_cast<GetLastSeenVersionActor*>(this)->destroy(); return 0; }
															#line 767 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<GetLastSeenVersionActor*>(this)->SAV< Version >::value()) Version(std::move(result)); // state_var_RVO
		this->~GetLastSeenVersionActorState();
		static_cast<GetLastSeenVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLastSeenVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastSeenVersionActor*>(this)->ActorCallback< GetLastSeenVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastSeenVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLastSeenVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLastSeenVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 177 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Version result;
															#line 178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Optional<Value> lastSeenVersionValue;
															#line 868 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via getLastSeenVersion()
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class GetLastSeenVersionActor final : public Actor<Version>, public ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >, public ActorCallback< GetLastSeenVersionActor, 1, Void >, public FastAllocated<GetLastSeenVersionActor>, public GetLastSeenVersionActorState<GetLastSeenVersionActor> {
															#line 873 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<GetLastSeenVersionActor>::operator new;
	using FastAllocated<GetLastSeenVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1172335661978921728UL, 2343131112478809344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< GetLastSeenVersionActor, 1, Void >;
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	GetLastSeenVersionActor(LocalConfigurationImpl* const& self) 
															#line 891 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Version>(),
		   GetLastSeenVersionActorState<GetLastSeenVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLastSeenVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17221711862908601088UL, 3277205647693454336UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastSeenVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLastSeenVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLastSeenVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLastSeenVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLastSeenVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Version> getLastSeenVersion( LocalConfigurationImpl* const& self ) {
															#line 176 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Version>(new GetLastSeenVersionActor(self));
															#line 924 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 187 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 929 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via initialize()
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class InitializeActor>
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class InitializeActorState {
															#line 935 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	InitializeActorState(LocalConfigurationImpl* const& self) 
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self)
															#line 942 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("initialize", reinterpret_cast<unsigned long>(this));

	}
	~InitializeActorState() 
	{
		fdb_probe_actor_destroy("initialize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getLastSeenVersion(self);
															#line 189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 959 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 0, Version >*>(static_cast<InitializeActor*>(this)));
															#line 964 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = self->kvStore->readValue(configPathKey);
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 989 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 2;
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 1, Optional<Value> >*>(static_cast<InitializeActor*>(this)));
															#line 994 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __lastSeenVersion,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		lastSeenVersion = __lastSeenVersion;
															#line 1003 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __lastSeenVersion,int loopDepth) 
	{
		lastSeenVersion = std::move(__lastSeenVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 191 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!storedConfigPathValue.present())
															#line 1082 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 192 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_2 = saveConfigPath(self);
															#line 192 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1088 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 3;
															#line 192 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 2, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1093 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& __storedConfigPathValue,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		storedConfigPathValue = __storedConfigPathValue;
															#line 1107 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && __storedConfigPathValue,int loopDepth) 
	{
		storedConfigPathValue = std::move(__storedConfigPathValue);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 196 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		storedConfigPath = BinaryReader::fromStringRef<ConfigKnobOverrides>(storedConfigPathValue.get(), IncludeVersion());
															#line 198 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!storedConfigPath.hasSameConfigPath(self->configKnobOverrides))
															#line 1188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 199 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			CODE_PROBE(true, "All local information is outdated");
															#line 200 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_3 = clearKVStore(self);
															#line 200 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1196 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 4;
															#line 200 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 3, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 194 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1217 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 194 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InitializeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 205 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = self->kvStore->readRange(knobOverrideKeys);
															#line 205 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1320 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 6;
															#line 205 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 5, RangeResult >*>(static_cast<InitializeActor*>(this)));
															#line 1325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_4 = saveConfigPath(self);
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1336 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 4, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1341 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_4 = saveConfigPath(self);
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1352 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 4, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1357 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< InitializeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 203 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1443 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 203 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1457 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< InitializeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(RangeResult const& range,int loopDepth) 
	{
															#line 206 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		for( const auto& kv : range ) {
															#line 207 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			auto configKey = BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(knobOverrideKeys.begin), IncludeVersion());
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->configKnobOverrides.set(configKey.configClass, configKey.knobName, ObjectReader::fromStringRef<KnobValue>(kv.value, IncludeVersion()));
															#line 1548 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		}
															#line 213 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1554 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(RangeResult && range,int loopDepth) 
	{
															#line 206 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		for( const auto& kv : range ) {
															#line 207 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			auto configKey = BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(knobOverrideKeys.begin), IncludeVersion());
															#line 209 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->configKnobOverrides.set(configKey.configClass, configKey.knobName, ObjectReader::fromStringRef<KnobValue>(kv.value, IncludeVersion()));
															#line 1570 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		}
															#line 213 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(lastSeenVersion);
															#line 214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1576 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont10(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< InitializeActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 189 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Version lastSeenVersion;
															#line 190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Optional<Value> storedConfigPathValue;
															#line 196 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConfigKnobOverrides storedConfigPath;
															#line 1667 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via initialize()
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class InitializeActor final : public Actor<Void>, public ActorCallback< InitializeActor, 0, Version >, public ActorCallback< InitializeActor, 1, Optional<Value> >, public ActorCallback< InitializeActor, 2, Void >, public ActorCallback< InitializeActor, 3, Void >, public ActorCallback< InitializeActor, 4, Void >, public ActorCallback< InitializeActor, 5, RangeResult >, public FastAllocated<InitializeActor>, public InitializeActorState<InitializeActor> {
															#line 1672 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<InitializeActor>::operator new;
	using FastAllocated<InitializeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12411184759444169472UL, 17109124679177992704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeActor, 0, Version >;
friend struct ActorCallback< InitializeActor, 1, Optional<Value> >;
friend struct ActorCallback< InitializeActor, 2, Void >;
friend struct ActorCallback< InitializeActor, 3, Void >;
friend struct ActorCallback< InitializeActor, 4, Void >;
friend struct ActorCallback< InitializeActor, 5, RangeResult >;
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	InitializeActor(LocalConfigurationImpl* const& self) 
															#line 1694 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   InitializeActorState<InitializeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(377676441043239424UL, 4804261275250009856UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initialize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< InitializeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< InitializeActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< InitializeActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< InitializeActor, 5, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> initialize( LocalConfigurationImpl* const& self ) {
															#line 188 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new InitializeActor(self));
															#line 1731 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 216 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

	void updateInMemoryState(Version lastSeenVersion) {
		this->lastSeenVersion = lastSeenVersion;
		if (g_network->isSimulated()) {
			getKnobs().clearTestKnobs();
		}
		configKnobOverrides.update(getKnobs());
		manualKnobOverrides.update(getKnobs());
		// FIXME: Reinitialize in order to update dependent knobs?
	}

																#line 1746 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via setSnapshot()
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class SetSnapshotActor>
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class SetSnapshotActorState {
															#line 1752 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	SetSnapshotActorState(LocalConfigurationImpl* const& self,std::map<ConfigKey, KnobValue> const& snapshot,Version const& snapshotVersion,double const& restartDelay) 
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self),
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   snapshot(snapshot),
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   snapshotVersion(snapshotVersion),
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   restartDelay(restartDelay)
															#line 1765 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("setSnapshot", reinterpret_cast<unsigned long>(this));

	}
	~SetSnapshotActorState() 
	{
		fdb_probe_actor_destroy("setSnapshot", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (snapshotVersion <= self->lastSeenVersion)
															#line 1780 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			{
															#line 232 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				TraceEvent(SevWarnAlways, "LocalConfigGotOldSnapshot", self->id) .detail("NewSnapshotVersion", snapshotVersion) .detail("LastSeenVersion", self->lastSeenVersion);
															#line 235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (!static_cast<SetSnapshotActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetSnapshotActorState(); static_cast<SetSnapshotActor*>(this)->destroy(); return 0; }
															#line 1786 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				new (&static_cast<SetSnapshotActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~SetSnapshotActorState();
				static_cast<SetSnapshotActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 237 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			++self->snapshots;
															#line 238 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->clear(knobOverrideKeys);
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			restartRequired = false;
															#line 240 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			for( const auto& [configKey, knobValue] : snapshot ) {
															#line 241 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				self->configKnobOverrides.set(configKey.configClass, configKey.knobName, knobValue);
															#line 242 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				self->kvStore->set( KeyValueRef(BinaryWriter::toValue(configKey, IncludeVersion()).withPrefix(knobOverrideKeys.begin), ObjectWriter::toValue(knobValue, IncludeVersion())));
															#line 245 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				restartRequired |= self->getKnobs().isAtomic(configKey.knobName.toString());
															#line 1806 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			}
															#line 247 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			ASSERT_GE(snapshotVersion, self->lastSeenVersion);
															#line 248 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->set(KeyValueRef(lastSeenVersionKey, BinaryWriter::toValue(snapshotVersion, IncludeVersion())));
															#line 249 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->kvStore->commit();
															#line 249 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<SetSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1816 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetSnapshotActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetSnapshotActor, 0, Void >*>(static_cast<SetSnapshotActor*>(this)));
															#line 1821 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetSnapshotActorState();
		static_cast<SetSnapshotActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (restartRequired)
															#line 1844 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (restartDelay > 0)
															#line 1848 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			{
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(restartDelay);
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (static_cast<SetSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1854 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<SetSnapshotActor*>(this)->actor_wait_state = 2;
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetSnapshotActor, 1, Void >*>(static_cast<SetSnapshotActor*>(this)));
															#line 1859 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (restartRequired)
															#line 1878 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (restartDelay > 0)
															#line 1882 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			{
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(restartDelay);
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (static_cast<SetSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1888 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<SetSnapshotActor*>(this)->actor_wait_state = 2;
															#line 252 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetSnapshotActor, 1, Void >*>(static_cast<SetSnapshotActor*>(this)));
															#line 1893 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetSnapshotActor*>(this)->actor_wait_state > 0) static_cast<SetSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<SetSnapshotActor*>(this)->ActorCallback< SetSnapshotActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetSnapshotActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetSnapshotActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetSnapshotActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 256 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(snapshotVersion);
															#line 257 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<SetSnapshotActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetSnapshotActorState(); static_cast<SetSnapshotActor*>(this)->destroy(); return 0; }
															#line 1989 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<SetSnapshotActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetSnapshotActorState();
		static_cast<SetSnapshotActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 254 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		return a_body1Catch1(local_config_changed(), loopDepth);
															#line 2001 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetSnapshotActor*>(this)->actor_wait_state > 0) static_cast<SetSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<SetSnapshotActor*>(this)->ActorCallback< SetSnapshotActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetSnapshotActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetSnapshotActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetSnapshotActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	std::map<ConfigKey, KnobValue> snapshot;
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Version snapshotVersion;
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	double restartDelay;
															#line 239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	bool restartRequired;
															#line 2102 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via setSnapshot()
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class SetSnapshotActor final : public Actor<Void>, public ActorCallback< SetSnapshotActor, 0, Void >, public ActorCallback< SetSnapshotActor, 1, Void >, public FastAllocated<SetSnapshotActor>, public SetSnapshotActorState<SetSnapshotActor> {
															#line 2107 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<SetSnapshotActor>::operator new;
	using FastAllocated<SetSnapshotActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7004743564160646912UL, 6332937234495969024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetSnapshotActor, 0, Void >;
friend struct ActorCallback< SetSnapshotActor, 1, Void >;
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	SetSnapshotActor(LocalConfigurationImpl* const& self,std::map<ConfigKey, KnobValue> const& snapshot,Version const& snapshotVersion,double const& restartDelay) 
															#line 2125 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   SetSnapshotActorState<SetSnapshotActor>(self, snapshot, snapshotVersion, restartDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setSnapshot", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4310863571811654144UL, 1189008995598805248UL);
		ActorExecutionContextHelper __helper(static_cast<SetSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setSnapshot");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setSnapshot", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetSnapshotActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetSnapshotActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> setSnapshot( LocalConfigurationImpl* const& self, std::map<ConfigKey, KnobValue> const& snapshot, Version const& snapshotVersion, double const& restartDelay ) {
															#line 227 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new SetSnapshotActor(self, snapshot, snapshotVersion, restartDelay));
															#line 2158 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 259 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 2163 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via addChanges()
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class AddChangesActor>
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class AddChangesActorState {
															#line 2169 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	AddChangesActorState(LocalConfigurationImpl* const& self,Standalone<VectorRef<VersionedConfigMutationRef>> const& changes,Version const& mostRecentVersion,double const& restartDelay) 
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self),
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   changes(changes),
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   mostRecentVersion(mostRecentVersion),
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   restartDelay(restartDelay)
															#line 2182 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("addChanges", reinterpret_cast<unsigned long>(this));

	}
	~AddChangesActorState() 
	{
		fdb_probe_actor_destroy("addChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			++self->changeRequestsFetched;
															#line 266 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			restartRequired = false;
															#line 267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			for( const auto& versionedMutation : changes ) {
															#line 268 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (versionedMutation.version <= self->lastSeenVersion)
															#line 2203 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				{
															#line 269 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					TraceEvent(SevWarnAlways, "LocalConfigGotRepeatedChange") .detail("NewChangeVersion", versionedMutation.version) .detail("LastSeenVersion", self->lastSeenVersion);
															#line 2207 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
					continue;
				}
															#line 274 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				++self->mutations;
															#line 275 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				const auto& mutation = versionedMutation.mutation;
															#line 2214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				{
															#line 277 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					TraceEvent te(SevInfo, "LocalConfigAddingChange", self->id);
															#line 278 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					te.detail("ConfigClass", mutation.getConfigClass()) .detail("Version", versionedMutation.version) .detail("KnobName", mutation.getKnobName());
															#line 281 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					if (mutation.isSet())
															#line 2222 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
					{
															#line 282 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
						te.detail("Op", "Set").detail("KnobValue", mutation.getValue().toString());
															#line 2226 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
					}
				}
															#line 285 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				auto serializedKey = BinaryWriter::toValue(mutation.getKey(), IncludeVersion());
															#line 286 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (mutation.isSet())
															#line 2233 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				{
															#line 287 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					self->kvStore->set(KeyValueRef(serializedKey.withPrefix(knobOverrideKeys.begin), ObjectWriter::toValue(mutation.getValue(), IncludeVersion())));
															#line 289 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					self->configKnobOverrides.set(mutation.getConfigClass(), mutation.getKnobName(), mutation.getValue());
															#line 2239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				}
				else
				{
															#line 291 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					self->kvStore->clear(singleKeyRange(serializedKey.withPrefix(knobOverrideKeys.begin)));
															#line 292 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
					self->configKnobOverrides.remove(mutation.getConfigClass(), mutation.getKnobName());
															#line 2247 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				}
															#line 294 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				restartRequired |= self->getKnobs().isAtomic(mutation.getKnobName().toString());
															#line 2251 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			}
															#line 296 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			self->kvStore->set(KeyValueRef(lastSeenVersionKey, BinaryWriter::toValue(mostRecentVersion, IncludeVersion())));
															#line 297 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->kvStore->commit();
															#line 297 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<AddChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2259 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddChangesActor*>(this)->actor_wait_state = 1;
															#line 297 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddChangesActor, 0, Void >*>(static_cast<AddChangesActor*>(this)));
															#line 2264 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddChangesActorState();
		static_cast<AddChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (restartRequired)
															#line 2287 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (restartDelay > 0)
															#line 2291 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			{
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(restartDelay);
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (static_cast<AddChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2297 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<AddChangesActor*>(this)->actor_wait_state = 2;
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddChangesActor, 1, Void >*>(static_cast<AddChangesActor*>(this)));
															#line 2302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont9(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (restartRequired)
															#line 2321 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		{
															#line 299 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (restartDelay > 0)
															#line 2325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			{
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(restartDelay);
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				if (static_cast<AddChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2331 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<AddChangesActor*>(this)->actor_wait_state = 2;
															#line 300 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddChangesActor, 1, Void >*>(static_cast<AddChangesActor*>(this)));
															#line 2336 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont9(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddChangesActor*>(this)->actor_wait_state > 0) static_cast<AddChangesActor*>(this)->actor_wait_state = 0;
		static_cast<AddChangesActor*>(this)->ActorCallback< AddChangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 304 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		self->updateInMemoryState(mostRecentVersion);
															#line 305 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (!static_cast<AddChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddChangesActorState(); static_cast<AddChangesActor*>(this)->destroy(); return 0; }
															#line 2432 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		new (&static_cast<AddChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddChangesActorState();
		static_cast<AddChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 302 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		return a_body1Catch1(local_config_changed(), loopDepth);
															#line 2444 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddChangesActor*>(this)->actor_wait_state > 0) static_cast<AddChangesActor*>(this)->actor_wait_state = 0;
		static_cast<AddChangesActor*>(this)->ActorCallback< AddChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Standalone<VectorRef<VersionedConfigMutationRef>> changes;
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	Version mostRecentVersion;
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	double restartDelay;
															#line 266 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	bool restartRequired;
															#line 2545 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via addChanges()
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class AddChangesActor final : public Actor<Void>, public ActorCallback< AddChangesActor, 0, Void >, public ActorCallback< AddChangesActor, 1, Void >, public FastAllocated<AddChangesActor>, public AddChangesActorState<AddChangesActor> {
															#line 2550 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<AddChangesActor>::operator new;
	using FastAllocated<AddChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8218201200048985088UL, 17931715728352778240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddChangesActor, 0, Void >;
friend struct ActorCallback< AddChangesActor, 1, Void >;
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	AddChangesActor(LocalConfigurationImpl* const& self,Standalone<VectorRef<VersionedConfigMutationRef>> const& changes,Version const& mostRecentVersion,double const& restartDelay) 
															#line 2568 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   AddChangesActorState<AddChangesActor>(self, changes, mostRecentVersion, restartDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11934639023418119680UL, 4473731652225763072UL);
		ActorExecutionContextHelper __helper(static_cast<AddChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddChangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddChangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> addChanges( LocalConfigurationImpl* const& self, Standalone<VectorRef<VersionedConfigMutationRef>> const& changes, Version const& mostRecentVersion, double const& restartDelay ) {
															#line 260 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new AddChangesActor(self, changes, mostRecentVersion, restartDelay));
															#line 2601 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 307 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 2606 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via consumeInternal()
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class ConsumeInternalActor>
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ConsumeInternalActorState {
															#line 2612 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConsumeInternalActorState(LocalConfigurationImpl* const& self,ConfigBroadcastInterface const& broadcaster) 
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self),
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   broadcaster(broadcaster)
															#line 2621 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("consumeInternal", reinterpret_cast<unsigned long>(this));

	}
	~ConsumeInternalActorState() 
	{
		fdb_probe_actor_destroy("consumeInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->initialize();
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2638 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 1;
															#line 309 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsumeInternalActor, 0, Void >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2643 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsumeInternalActorState();
		static_cast<ConsumeInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		;
															#line 2666 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		;
															#line 2675 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state > 0) static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeInternalActor*>(this)->ActorCallback< ConsumeInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsumeInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		auto __when_expr_1 = broadcaster.snapshot.getFuture();
															#line 2766 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ConfigBroadcastSnapshotRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ConfigBroadcastSnapshotRequest>>::value, "invalid type");
															#line 311 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2770 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 317 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		auto __when_expr_2 = broadcaster.changes.getFuture();
															#line 2774 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ConfigBroadcastChangesRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ConfigBroadcastChangesRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.pop(), loopDepth); };
		static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 2;
															#line 312 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 317 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2782 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConfigBroadcastSnapshotRequest const& __snapshotReq,int loopDepth) 
	{
															#line 312 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		snapshotReq = __snapshotReq;
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setSnapshot( self, std::move(snapshotReq.snapshot), snapshotReq.version, snapshotReq.restartDelay);
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2801 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 3;
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConsumeInternalActor, 3, Void >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2806 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConfigBroadcastSnapshotRequest && __snapshotReq,int loopDepth) 
	{
		snapshotReq = std::move(__snapshotReq);
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setSnapshot( self, std::move(snapshotReq.snapshot), snapshotReq.version, snapshotReq.restartDelay);
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2818 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 3;
															#line 313 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConsumeInternalActor, 3, Void >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2823 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(ConfigBroadcastChangesRequest const& __req,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		req = __req;
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->addChanges(req.changes, req.mostRecentVersion, req.restartDelay);
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2836 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 4;
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsumeInternalActor, 4, Void >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2841 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(ConfigBroadcastChangesRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->addChanges(req.changes, req.mostRecentVersion, req.restartDelay);
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2853 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 4;
															#line 318 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsumeInternalActor, 4, Void >*>(static_cast<ConsumeInternalActor*>(this)));
															#line 2858 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state > 0) static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeInternalActor*>(this)->ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >::remove();
		static_cast<ConsumeInternalActor*>(this)->ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >::remove();

	}
	int a_body1cont1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		snapshotReq.reply.send(ConfigBroadcastSnapshotReply{});
															#line 2874 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1cont1(Void && _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		snapshotReq.reply.send(ConfigBroadcastSnapshotReply{});
															#line 2883 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state > 0) static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeInternalActor*>(this)->ActorCallback< ConsumeInternalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConsumeInternalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >*,ConfigBroadcastSnapshotRequest const& value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >*,ConfigBroadcastSnapshotRequest && value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >*,Error err) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		req.reply.send(ConfigBroadcastChangesReply{});
															#line 3024 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2cont1(Void && _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		req.reply.send(ConfigBroadcastChangesReply{});
															#line 3033 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConsumeInternalActor*>(this)->actor_wait_state > 0) static_cast<ConsumeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeInternalActor*>(this)->ActorCallback< ConsumeInternalActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConsumeInternalActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConsumeInternalActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >*,ConfigBroadcastChangesRequest const& value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >*,ConfigBroadcastChangesRequest && value) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConfigBroadcastInterface broadcaster;
															#line 312 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConfigBroadcastSnapshotRequest snapshotReq;
															#line 317 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConfigBroadcastChangesRequest req;
															#line 3178 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via consumeInternal()
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ConsumeInternalActor final : public Actor<Void>, public ActorCallback< ConsumeInternalActor, 0, Void >, public ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >, public ActorCallback< ConsumeInternalActor, 3, Void >, public ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >, public ActorCallback< ConsumeInternalActor, 4, Void >, public FastAllocated<ConsumeInternalActor>, public ConsumeInternalActorState<ConsumeInternalActor> {
															#line 3183 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<ConsumeInternalActor>::operator new;
	using FastAllocated<ConsumeInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17225577826436238080UL, 14273721900280974080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsumeInternalActor, 0, Void >;
friend struct ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >;
friend struct ActorCallback< ConsumeInternalActor, 3, Void >;
friend struct ActorSingleCallback< ConsumeInternalActor, 2, ConfigBroadcastChangesRequest >;
friend struct ActorCallback< ConsumeInternalActor, 4, Void >;
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConsumeInternalActor(LocalConfigurationImpl* const& self,ConfigBroadcastInterface const& broadcaster) 
															#line 3204 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   ConsumeInternalActorState<ConsumeInternalActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14924690150401283840UL, 2334858894535565568UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsumeInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< ConsumeInternalActor, 1, ConfigBroadcastSnapshotRequest >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConsumeInternalActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConsumeInternalActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> consumeInternal( LocalConfigurationImpl* const& self, ConfigBroadcastInterface const& broadcaster ) {
															#line 308 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new ConsumeInternalActor(self, broadcaster));
															#line 3239 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 324 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

																#line 3244 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
// This generated class is to be used only via consume()
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class ConsumeActor>
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ConsumeActorState {
															#line 3250 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConsumeActorState(LocalConfigurationImpl* const& self,ConfigBroadcastInterface const& broadcaster) 
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : self(self),
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		   broadcaster(broadcaster)
															#line 3259 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("consume", reinterpret_cast<unsigned long>(this));

	}
	~ConsumeActorState() 
	{
		fdb_probe_actor_destroy("consume", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			;
															#line 3274 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsumeActorState();
		static_cast<ConsumeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 328 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_0 = consumeInternal(self, broadcaster);
															#line 327 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		if (static_cast<ConsumeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3306 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 331 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->kvStore->getError();
															#line 3310 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ConsumeActor*>(this)->actor_wait_state = 1;
															#line 328 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsumeActor, 0, Void >*>(static_cast<ConsumeActor*>(this)));
															#line 331 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsumeActor, 1, Void >*>(static_cast<ConsumeActor*>(this)));
															#line 3317 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		ASSERT(false);
															#line 3332 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		ASSERT(false);
															#line 3341 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		ASSERT(false);
															#line 3350 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		ASSERT(false);
															#line 3359 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsumeActor*>(this)->actor_wait_state > 0) static_cast<ConsumeActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeActor*>(this)->ActorCallback< ConsumeActor, 0, Void >::remove();
		static_cast<ConsumeActor*>(this)->ActorCallback< ConsumeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsumeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsumeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsumeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsumeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsumeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsumeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	LocalConfigurationImpl* self;
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConfigBroadcastInterface broadcaster;
															#line 3489 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via consume()
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class ConsumeActor final : public Actor<Void>, public ActorCallback< ConsumeActor, 0, Void >, public ActorCallback< ConsumeActor, 1, Void >, public FastAllocated<ConsumeActor>, public ConsumeActorState<ConsumeActor> {
															#line 3494 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<ConsumeActor>::operator new;
	using FastAllocated<ConsumeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4365956339534919424UL, 2328401715125146624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsumeActor, 0, Void >;
friend struct ActorCallback< ConsumeActor, 1, Void >;
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	ConsumeActor(LocalConfigurationImpl* const& self,ConfigBroadcastInterface const& broadcaster) 
															#line 3512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   ConsumeActorState<ConsumeActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consume", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6685628109243024640UL, 10825668136790029056UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consume");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consume", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsumeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
[[nodiscard]] static Future<Void> consume( LocalConfigurationImpl* const& self, ConfigBroadcastInterface const& broadcaster ) {
															#line 325 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new ConsumeActor(self, broadcaster));
															#line 3544 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}

#line 337 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

public:
	LocalConfigurationImpl(std::string const& dataFolder,
	                       std::string const& configPath,
	                       std::map<std::string, std::string> const& manualKnobOverrides,
	                       IsTest isTest)
	  : id(deterministicRandom()->randomUniqueID()), kvStore(dataFolder, id, "localconf-"),
	    configKnobOverrides(configPath), manualKnobOverrides(manualKnobOverrides), cc("LocalConfiguration"),
	    snapshots("Snapshots", cc), changeRequestsFetched("ChangeRequestsFetched", cc), mutations("Mutations", cc) {
		if (isTest) {
			testKnobCollection =
			    IKnobCollection::create(IKnobCollection::Type::TEST,
			                            Randomize::False,
			                            g_network->isSimulated() ? IsSimulated::True : IsSimulated::False);
		}
		logger = cc.traceCounters(
		    "LocalConfigurationMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "LocalConfigurationMetrics");
	}

	Future<Void> addChanges(Standalone<VectorRef<VersionedConfigMutationRef>> changes,
	                        Version mostRecentVersion,
	                        double restartDelay) {
		return addChanges(this, changes, mostRecentVersion, restartDelay);
	}

	FlowKnobs const& getFlowKnobs() const { return getKnobs().getFlowKnobs(); }

	ClientKnobs const& getClientKnobs() const { return getKnobs().getClientKnobs(); }

	ServerKnobs const& getServerKnobs() const { return getKnobs().getServerKnobs(); }

	TestKnobs const& getTestKnobs() const { return getKnobs().getTestKnobs(); }

	Future<Void> consume(ConfigBroadcastInterface const& broadcastInterface) {
		return consume(this, broadcastInterface);
	}

	UID getID() const { return id; }

	Version getLastSeenVersion() const { return lastSeenVersion; }

	ConfigClassSet configClassSet() const { return configKnobOverrides.getConfigClassSet(); }

	Future<Void> initialize() {
		if (!initFuture.isValid()) {
			initFuture = initialize(this);
		}
		return initFuture;
	}

	void close() { kvStore.close(); }

	Future<Void> onClosed() { return kvStore.onClosed(); }

	static void testManualKnobOverridesInvalidName() {
		std::map<std::string, std::string> invalidOverrides;
		invalidOverrides["knob_name_that_does_not_exist"] = "";
		// Should only trace and not throw an error:
		ManualKnobOverrides manualKnobOverrides(invalidOverrides);
	}

	static void testManualKnobOverridesInvalidValue() {
		std::map<std::string, std::string> invalidOverrides;
		invalidOverrides["test_int"] = "not_an_int";
		// Should only trace and not throw an error:
		ManualKnobOverrides manualKnobOverrides(invalidOverrides);
	}

	static void testConfigKnobOverridesInvalidConfigPath() {
		try {
			ConfigKnobOverrides configKnobOverrides("#invalid_config_path");
			ASSERT(false);
		} catch (Error& e) {
			ASSERT_EQ(e.code(), error_code_invalid_config_path);
		}
	}

	static void testConfigKnobOverridesInvalidName() {
		ConfigKnobOverrides configKnobOverrides;
		configKnobOverrides.set(
		    {}, "knob_name_that_does_not_exist"_sr, KnobValueRef::create(ParsedKnobValue(int{ 1 })));
		auto testKnobCollection =
		    IKnobCollection::create(IKnobCollection::Type::TEST, Randomize::False, IsSimulated::False);
		// Should only trace and not throw an error:
		configKnobOverrides.update(*testKnobCollection);
	}

	static void testConfigKnobOverridesInvalidValue() {
		ConfigKnobOverrides configKnobOverrides;
		configKnobOverrides.set({}, "test_int"_sr, KnobValueRef::create(ParsedKnobValue("not_an_int")));
		auto testKnobCollection =
		    IKnobCollection::create(IKnobCollection::Type::TEST, Randomize::False, IsSimulated::False);
		// Should only trace and not throw an error:
		configKnobOverrides.update(*testKnobCollection);
	}
};

LocalConfiguration::LocalConfiguration(std::string const& dataFolder,
                                       std::string const& configPath,
                                       std::map<std::string, std::string> const& manualKnobOverrides,
                                       IsTest isTest)
  : impl(PImpl<LocalConfigurationImpl>::create(dataFolder, configPath, manualKnobOverrides, isTest)) {}

LocalConfiguration::~LocalConfiguration() = default;

FlowKnobs const& LocalConfiguration::getFlowKnobs() const {
	return impl->getFlowKnobs();
}

ClientKnobs const& LocalConfiguration::getClientKnobs() const {
	return impl->getClientKnobs();
}

ServerKnobs const& LocalConfiguration::getServerKnobs() const {
	return impl->getServerKnobs();
}

TestKnobs const& LocalConfiguration::getTestKnobs() const {
	return impl->getTestKnobs();
}

Future<Void> LocalConfiguration::consume(ConfigBroadcastInterface const& broadcaster) {
	return impl->consume(broadcaster);
}

Future<Void> LocalConfiguration::addChanges(Standalone<VectorRef<VersionedConfigMutationRef>> changes,
                                            Version mostRecentVersion,
                                            double restartDelay) {
	return impl->addChanges(changes, mostRecentVersion, restartDelay);
}

void LocalConfiguration::close() {
	impl->close();
}

Future<Void> LocalConfiguration::onClosed() {
	return impl->onClosed();
}

UID LocalConfiguration::getID() const {
	return impl->getID();
}

Version LocalConfiguration::lastSeenVersion() const {
	return impl->getLastSeenVersion();
}

ConfigClassSet LocalConfiguration::configClassSet() const {
	return impl->configClassSet();
}

Future<Void> LocalConfiguration::initialize() {
	return impl->initialize();
}

															#line 3703 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase492()
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class FlowTestCase492Actor>
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase492ActorState {
															#line 3710 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase492ActorState(UnitTestParameters const& params) 
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : params(params)
															#line 3717 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase492", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase492ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase492", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 493 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			LocalConfigurationImpl::testManualKnobOverridesInvalidName();
															#line 494 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (!static_cast<FlowTestCase492Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase492ActorState(); static_cast<FlowTestCase492Actor*>(this)->destroy(); return 0; }
															#line 3734 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			new (&static_cast<FlowTestCase492Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase492ActorState();
			static_cast<FlowTestCase492Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase492ActorState();
		static_cast<FlowTestCase492Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	UnitTestParameters params;
															#line 3758 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase492()
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase492Actor final : public Actor<Void>, public FastAllocated<FlowTestCase492Actor>, public FlowTestCase492ActorState<FlowTestCase492Actor> {
															#line 3763 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase492Actor>::operator new;
	using FastAllocated<FlowTestCase492Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15299006056474039552UL, 8528906347666314752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase492Actor(UnitTestParameters const& params) 
															#line 3779 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase492ActorState<FlowTestCase492Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase492", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4911558423057086720UL, 3207708519932616448UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase492Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase492");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase492", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
static Future<Void> flowTestCase492( UnitTestParameters const& params ) {
															#line 492 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new FlowTestCase492Actor(params));
															#line 3811 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase492, "/fdbserver/ConfigDB/ManualKnobOverrides/InvalidName")

#line 496 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

															#line 3817 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase497()
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class FlowTestCase497Actor>
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase497ActorState {
															#line 3824 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase497ActorState(UnitTestParameters const& params) 
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : params(params)
															#line 3831 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase497", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase497ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase497", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 498 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			LocalConfigurationImpl::testManualKnobOverridesInvalidValue();
															#line 499 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (!static_cast<FlowTestCase497Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase497ActorState(); static_cast<FlowTestCase497Actor*>(this)->destroy(); return 0; }
															#line 3848 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			new (&static_cast<FlowTestCase497Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase497ActorState();
			static_cast<FlowTestCase497Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase497ActorState();
		static_cast<FlowTestCase497Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	UnitTestParameters params;
															#line 3872 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase497()
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase497Actor final : public Actor<Void>, public FastAllocated<FlowTestCase497Actor>, public FlowTestCase497ActorState<FlowTestCase497Actor> {
															#line 3877 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase497Actor>::operator new;
	using FastAllocated<FlowTestCase497Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8134597745195920128UL, 8179490520480980224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase497Actor(UnitTestParameters const& params) 
															#line 3893 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase497ActorState<FlowTestCase497Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase497", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11357162549333756160UL, 10127493874485394432UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase497Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase497");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase497", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
static Future<Void> flowTestCase497( UnitTestParameters const& params ) {
															#line 497 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new FlowTestCase497Actor(params));
															#line 3925 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase497, "/fdbserver/ConfigDB/ManualKnobOverrides/InvalidValue")

#line 501 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

															#line 3931 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase502()
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class FlowTestCase502Actor>
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase502ActorState {
															#line 3938 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase502ActorState(UnitTestParameters const& params) 
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : params(params)
															#line 3945 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase502", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase502ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase502", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 503 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			LocalConfigurationImpl::testConfigKnobOverridesInvalidConfigPath();
															#line 504 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (!static_cast<FlowTestCase502Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase502ActorState(); static_cast<FlowTestCase502Actor*>(this)->destroy(); return 0; }
															#line 3962 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			new (&static_cast<FlowTestCase502Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase502ActorState();
			static_cast<FlowTestCase502Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase502ActorState();
		static_cast<FlowTestCase502Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	UnitTestParameters params;
															#line 3986 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase502()
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase502Actor final : public Actor<Void>, public FastAllocated<FlowTestCase502Actor>, public FlowTestCase502ActorState<FlowTestCase502Actor> {
															#line 3991 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase502Actor>::operator new;
	using FastAllocated<FlowTestCase502Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9718196844793757696UL, 17560031393838319872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase502Actor(UnitTestParameters const& params) 
															#line 4007 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase502ActorState<FlowTestCase502Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase502", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5598694465102074624UL, 17772046775789698560UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase502Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase502");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase502", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
static Future<Void> flowTestCase502( UnitTestParameters const& params ) {
															#line 502 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new FlowTestCase502Actor(params));
															#line 4039 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase502, "/fdbserver/ConfigDB/ConfigKnobOverrides/InvalidConfigPath")

#line 506 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

															#line 4045 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase507()
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class FlowTestCase507Actor>
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase507ActorState {
															#line 4052 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase507ActorState(UnitTestParameters const& params) 
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : params(params)
															#line 4059 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase507", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase507ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase507", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 508 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			LocalConfigurationImpl::testConfigKnobOverridesInvalidName();
															#line 509 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (!static_cast<FlowTestCase507Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase507ActorState(); static_cast<FlowTestCase507Actor*>(this)->destroy(); return 0; }
															#line 4076 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			new (&static_cast<FlowTestCase507Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase507ActorState();
			static_cast<FlowTestCase507Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase507ActorState();
		static_cast<FlowTestCase507Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	UnitTestParameters params;
															#line 4100 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase507()
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase507Actor final : public Actor<Void>, public FastAllocated<FlowTestCase507Actor>, public FlowTestCase507ActorState<FlowTestCase507Actor> {
															#line 4105 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase507Actor>::operator new;
	using FastAllocated<FlowTestCase507Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12489149712437790720UL, 10820347352461121792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase507Actor(UnitTestParameters const& params) 
															#line 4121 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase507ActorState<FlowTestCase507Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase507", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(470415674590290688UL, 17138875077585223424UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase507Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase507");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase507", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
static Future<Void> flowTestCase507( UnitTestParameters const& params ) {
															#line 507 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new FlowTestCase507Actor(params));
															#line 4153 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase507, "/fdbserver/ConfigDB/ConfigKnobOverrides/InvalidName")

#line 511 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"

															#line 4159 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase512()
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
template <class FlowTestCase512Actor>
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase512ActorState {
															#line 4166 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase512ActorState(UnitTestParameters const& params) 
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
		 : params(params)
															#line 4173 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase512", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase512ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase512", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 513 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			LocalConfigurationImpl::testConfigKnobOverridesInvalidValue();
															#line 514 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
			if (!static_cast<FlowTestCase512Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase512ActorState(); static_cast<FlowTestCase512Actor*>(this)->destroy(); return 0; }
															#line 4190 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
			new (&static_cast<FlowTestCase512Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase512ActorState();
			static_cast<FlowTestCase512Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase512ActorState();
		static_cast<FlowTestCase512Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	UnitTestParameters params;
															#line 4214 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase512()
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
class FlowTestCase512Actor final : public Actor<Void>, public FastAllocated<FlowTestCase512Actor>, public FlowTestCase512ActorState<FlowTestCase512Actor> {
															#line 4219 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase512Actor>::operator new;
	using FastAllocated<FlowTestCase512Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12723874981181430272UL, 7227401028923192064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	FlowTestCase512Actor(UnitTestParameters const& params) 
															#line 4235 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase512ActorState<FlowTestCase512Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase512", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12902070157549671424UL, 1094079253467354112UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase512Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase512");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase512", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
static Future<Void> flowTestCase512( UnitTestParameters const& params ) {
															#line 512 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
	return Future<Void>(new FlowTestCase512Actor(params));
															#line 4267 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/build_output/fdbserver/LocalConfiguration.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase512, "/fdbserver/ConfigDB/ConfigKnobOverrides/InvalidValue")

#line 516 "/codebuild/output/src2085254572/src/github.com/apple/foundationdb/fdbserver/LocalConfiguration.actor.cpp"
