#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
/*
 * IncrementalBackup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Arena.h"
#include "flow/Platform.h"
#include "flow/Trace.h"
#include "flow/serialize.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain the purpose of this workload and how it different from the
// 20+ (literally) other backup/restore workloads.

struct IncrementalBackupWorkload : TestWorkload {
	static constexpr auto NAME = "IncrementalBackup";

	Standalone<StringRef> backupDir;
	Standalone<StringRef> tag;
	FileBackupAgent backupAgent;
	bool submitOnly;
	bool restoreOnly;
	bool waitForBackup;
	int waitRetries;
	bool stopBackup;
	bool checkBeginVersion;
	bool clearBackupAgentKeys;
	Standalone<StringRef> blobManifestUrl;
	Optional<std::string> encryptionKeyFileName;

	IncrementalBackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupDir = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
		tag = getOption(options, "tag"_sr, "default"_sr);
		submitOnly = getOption(options, "submitOnly"_sr, false);
		restoreOnly = getOption(options, "restoreOnly"_sr, false);
		waitForBackup = getOption(options, "waitForBackup"_sr, false);
		waitRetries = getOption(options, "waitRetries"_sr, -1);
		stopBackup = getOption(options, "stopBackup"_sr, false);
		checkBeginVersion = getOption(options, "checkBeginVersion"_sr, false);
		clearBackupAgentKeys = getOption(options, "clearBackupAgentKeys"_sr, false);
		blobManifestUrl = getOption(options, "blobManifestUrl"_sr, ""_sr);

		if (restoreOnly) {
			// During restore, the encryption key file depends on whether the backup was encrypted or not.
			std::string temp_encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
			if (fileExists(temp_encryptionKeyFileName)) {
				encryptionKeyFileName = temp_encryptionKeyFileName;
			}
		} else if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId) {
			return Void();
		}
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId) {
			return true;
		}
		return _check(cx, this);
	}

																#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _checkActor>
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActorState {
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
public:
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self)
															#line 114 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->waitForBackup)
															#line 129 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->backupAgent.changePause(cx, false);
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 135 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->stopBackup)
															#line 168 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
			try {
															#line 166 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				TraceEvent("IBackupDiscontinueBackup").log();
															#line 167 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_10 = self->backupAgent.discontinueBackup(cx, self->tag);
															#line 167 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 177 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1when1(__when_expr_10.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 11;
															#line 167 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 10, Void >*>(static_cast<_checkActor*>(this)));
															#line 182 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 103 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 106 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 210 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 103 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 106 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 227 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 114 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 311 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(v, tr.getReadVersion());
															#line 108 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 330 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 108 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 335 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 372 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 377 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 142 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries = 0;
															#line 143 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 568 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupWaitContainer").log();
															#line 117 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 117 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 588 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 117 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 593 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 121 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 617 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 122 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 621 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
															#line 125 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 625 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 633 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 638 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 121 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 654 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 122 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 658 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
															#line 125 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 662 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 670 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 675 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont2(int loopDepth) 
	{
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<bool> __when_expr_5 = backupContainer->exists();
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 766 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, bool >*>(static_cast<_checkActor*>(this)));
															#line 771 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(int loopDepth) 
	{
															#line 129 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 132 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (containers.size())
															#line 782 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 133 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			backupContainer = IBackupContainer::openContainer(containers.front(), {}, restoreEncryptionKeyFileName);
															#line 786 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 796 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont7(int loopDepth) 
	{
															#line 138 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (e)
															#line 875 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(5.0);
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 883 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 888 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool const& __e,int loopDepth) 
	{
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		e = __e;
															#line 897 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 144 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries++;
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_7 = backupContainer->describeBackup(true);
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1080 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, BackupDescription >*>(static_cast<_checkActor*>(this)));
															#line 1085 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupVersionGate") .detail("MaxLogEndVersion", desc.maxLogEnd.present() ? desc.maxLogEnd.get() : invalidVersion) .detail("ContiguousLogEndVersion", desc.contiguousLogEnd.present() ? desc.contiguousLogEnd.get() : invalidVersion) .detail("TargetVersion", v);
															#line 152 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 1109 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 153 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(5.0);
															#line 153 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1115 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 9;
															#line 153 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 8, Void >*>(static_cast<_checkActor*>(this)));
															#line 1120 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		desc = __desc;
															#line 1134 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4loopBody1cont2(int loopDepth) 
	{
															#line 156 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (desc.contiguousLogEnd.get() >= v)
															#line 1213 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 158 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->waitRetries != -1 && tries > self->waitRetries)
															#line 1219 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 161 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(5.0);
															#line 161 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1227 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 161 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Void >*>(static_cast<_checkActor*>(this)));
															#line 1232 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _checkActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont4loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _checkActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 175 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1415 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupDiscontinueBackupException").error(e);
															#line 170 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1436 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 171 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1440 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _checkActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 102 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 103 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version v;
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction tr;
															#line 120 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<std::string> restoreEncryptionKeyFileName;
															#line 127 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	bool e;
															#line 142 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	int tries;
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	BackupDescription desc;
															#line 1574 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Void >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, std::vector<std::string> >, public ActorCallback< _checkActor, 5, bool >, public ActorCallback< _checkActor, 6, Void >, public ActorCallback< _checkActor, 7, BackupDescription >, public ActorCallback< _checkActor, 8, Void >, public ActorCallback< _checkActor, 9, Void >, public ActorCallback< _checkActor, 10, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1579 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7181034822191414016UL, 10638358347789046016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Void >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, std::vector<std::string> >;
friend struct ActorCallback< _checkActor, 5, bool >;
friend struct ActorCallback< _checkActor, 6, Void >;
friend struct ActorCallback< _checkActor, 7, BackupDescription >;
friend struct ActorCallback< _checkActor, 8, Void >;
friend struct ActorCallback< _checkActor, 9, Void >;
friend struct ActorCallback< _checkActor, 10, Void >;
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 1606 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, BackupDescription >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _checkActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _checkActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _checkActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1648 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
}

#line 177 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

																#line 1653 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _startActor>
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActorState {
															#line 1659 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
public:
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self),
															#line 179 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   backupRanges()
															#line 1670 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1687 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 1692 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 181 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		addDefaultBackupRanges(backupRanges);
															#line 183 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->submitOnly)
															#line 1717 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 184 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->encryptionKeyFileName.present())
															#line 1721 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 185 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 185 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1727 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 185 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1732 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		config = __config;
															#line 1751 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 214 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->restoreOnly)
															#line 1830 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 215 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->clearBackupAgentKeys)
															#line 1834 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 216 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				clearTr = Transaction(cx);
															#line 218 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				;
															#line 1840 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				loopDepth = a_body1cont2loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 188 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupSubmitAttempt").log();
															#line 1859 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		try {
															#line 190 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			Optional<std::string> blobManifestUrl;
															#line 191 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (!self->blobManifestUrl.empty())
															#line 1865 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 192 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				blobManifestUrl = self->blobManifestUrl.toString();
															#line 1869 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			}
															#line 194 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->backupAgent.submitBackup(cx, self->backupDir, {}, 0, 1e8, self->tag.toString(), backupRanges, true, StopWhenDone::False, UsePartitionedLog::False, IncrementalBackupOnly::True, self->encryptionKeyFileName);
															#line 194 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 1875 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1880 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 212 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupSubmitSuccess").log();
															#line 1982 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSubmitError").error(e);
															#line 208 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 1994 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 209 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1998 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 334 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2114 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 230 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 231 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 232 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = invalidVersion;
															#line 233 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 233 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2134 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 233 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2139 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 220 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 222 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.clear(fileBackupPrefixRange);
															#line 223 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = clearTr.commit();
															#line 223 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2170 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 223 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2175 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = clearTr.onError(e);
															#line 226 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2212 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 226 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2217 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 237 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 2408 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 238 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 2412 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
															#line 241 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2416 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 242 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 243 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 244 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2424 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 237 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 2440 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 238 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 2444 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
															#line 241 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2448 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 242 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 243 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 244 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2456 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 270 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersAttempt").log();
															#line 271 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_9 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 271 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2549 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 271 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<std::string> >*>(static_cast<_startActor*>(this)));
															#line 2554 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4(int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1(int loopDepth) 
	{
		try {
															#line 246 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 247 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 248 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_6 = tr->get(writeRecoveryKey);
															#line 248 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2583 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 248 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2588 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 262 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeysError").error(e);
															#line 263 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() == error_code_key_not_found)
															#line 2625 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 264 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2629 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			}
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2635 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2640 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2(int loopDepth) 
	{
															#line 249 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = tr->get(snapshotEndVersionKey);
															#line 249 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2657 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 249 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2662 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Optional<Value> const& __writeFlag,int loopDepth) 
	{
															#line 248 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		writeFlag = __writeFlag;
															#line 2671 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Optional<Value> && __writeFlag,int loopDepth) 
	{
		writeFlag = std::move(__writeFlag);
		loopDepth = a_body1cont11cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont1loopBody1cont3(int loopDepth) 
	{
															#line 250 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckSpecialKeys") .detail("WriteRecoveryValue", writeFlag.present() ? writeFlag.get().toString() : "N/A") .detail("EndVersionValue", versionValue.present() ? versionValue.get().toString() : "N/A");
															#line 253 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!versionValue.present())
															#line 2752 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 254 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckSpecialKeysFailure").log();
															#line 256 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			return a_body1cont11cont1loopBody1Catch1(key_not_found(), loopDepth);
															#line 2758 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		}
															#line 258 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(versionValue.get(), Unversioned());
															#line 259 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckBeginVersion").detail("Version", beginVersion);
															#line 2764 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		return a_body1cont11cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Optional<Value> const& __versionValue,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		versionValue = __versionValue;
															#line 2773 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Optional<Value> && __versionValue,int loopDepth) 
	{
		versionValue = std::move(__versionValue);
		loopDepth = a_body1cont11cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont5(int loopDepth) 
	{
															#line 273 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupURL = Key(containers.front());
															#line 278 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 279 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 280 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		for( auto r : backupRanges ) {
															#line 281 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (!r.intersects(getSystemBackupRanges()))
															#line 2949 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			{
															#line 282 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				restoreRange.push_back_deep(restoreRange.arena(), r);
															#line 2953 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			}
			else
			{
															#line 284 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef normalKeyRange = r & normalKeys;
															#line 285 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef systemKeyRange = r & systemKeys;
															#line 286 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!normalKeyRange.empty())
															#line 2963 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				{
															#line 287 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					restoreRange.push_back_deep(restoreRange.arena(), normalKeyRange);
															#line 2967 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				}
															#line 289 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!systemKeyRange.empty())
															#line 2971 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				{
															#line 290 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 2975 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
				}
			}
		}
															#line 294 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!systemRestoreRange.empty())
															#line 2981 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		{
															#line 295 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSystemRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 296 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_10 = success(self->backupAgent.restore(cx, cx, "system_restore"_sr, backupURL, {}, systemRestoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion, restoreEncryptionKeyFileName));
															#line 296 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2989 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 296 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2994 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 271 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 3008 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont11cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont6(int loopDepth) 
	{
															#line 314 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 315 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_11 = success(self->backupAgent.restore(cx, cx, Key(self->tag.toString()), backupURL, {}, restoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion, restoreEncryptionKeyFileName));
															#line 315 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3091 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont6when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 315 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 3096 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont13(Void const& _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3192 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13(Void && _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3201 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 179 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	DatabaseConfiguration config;
															#line 216 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction clearTr;
															#line 230 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 231 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 232 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version beginVersion;
															#line 236 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<std::string> restoreEncryptionKeyFileName;
															#line 243 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 248 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> writeFlag;
															#line 249 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> versionValue;
															#line 271 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Key backupURL;
															#line 278 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRange;
															#line 279 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRange;
															#line 3313 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Optional<Value> >, public ActorCallback< _startActor, 7, Optional<Value> >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, std::vector<std::string> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3318 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7432222489067106304UL, 15606931004162587648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Optional<Value> >;
friend struct ActorCallback< _startActor, 7, Optional<Value> >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, std::vector<std::string> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 3346 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3389 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp.py_gen"
}

#line 336 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<IncrementalBackupWorkload> IncrementalBackupWorkloadFactory;
