#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
/*
 * MockS3ServerChaos.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Design: design/mocks3server_chaos_design.md

#include "fdbserver/MockS3ServerChaos.h"
#include "fdbserver/MockS3Server.h"
#include "flow/ChaosMetrics.h"
#include "fdbrpc/simulator.h"
#include "flow/Trace.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h"

// Clear the chaos server registry (for testing/debugging only)
// NOTE: In production simulation tests, the registry should NOT be cleared between tests,
// as it must stay in sync with the simulator's persistent httpHandlers map to prevent
// duplicate registration attempts that would trigger assertions.
void clearMockS3ChaosRegistry() {
	if (g_network && g_simulator) {
		size_t previousSize = g_simulator->registeredMockS3ChaosServers.size();
		g_simulator->registeredMockS3ChaosServers.clear();
		TraceEvent("MockS3ChaosRegistryCleared").detail("PreviousSize", previousSize);
	}
}

// Helper function to classify S3 operations
S3Operation classifyS3Operation(const std::string& method, const std::string& resource) {
	if (method == "GET" || method == "HEAD") {
		return S3Operation::READ;
	} else if (method == "PUT") {
		if (resource.find("uploads") != std::string::npos) {
			return S3Operation::MULTIPART;
		}
		return S3Operation::WRITE;
	} else if (method == "DELETE") {
		return S3Operation::DELETE;
	} else if (method == "POST") {
		if (resource.find("uploads") != std::string::npos) {
			return S3Operation::MULTIPART;
		}
		return S3Operation::WRITE;
	} else {
		return S3Operation::READ; // Default fallback
	}
}

// Get operation-specific multiplier for chaos rates
double getOperationMultiplier(S3Operation op) {
	auto injector = S3FaultInjector::injector();
	switch (op) {
	case S3Operation::READ:
		return injector->getReadMultiplier();
	case S3Operation::WRITE:
		return injector->getWriteMultiplier();
	case S3Operation::DELETE:
		return injector->getDeleteMultiplier();
	case S3Operation::LIST:
		return injector->getListMultiplier();
	case S3Operation::MULTIPART:
		return injector->getWriteMultiplier(); // Use write multiplier for multipart
	default:
		return 1.0;
	}
}

// Generate S3-compatible error XML
std::string generateS3ErrorXML(const std::string& code, const std::string& message, const std::string& resource) {
	return format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
	              "<Error>\n"
	              "  <Code>%s</Code>\n"
	              "  <Message>%s</Message>\n"
	              "  <Resource>%s</Resource>\n"
	              "  <RequestId>%s</RequestId>\n"
	              "</Error>",
	              code.c_str(),
	              message.c_str(),
	              resource.c_str(),
	              deterministicRandom()->randomUniqueID().toString().c_str());
}

// Phase 1: Inject delay if configured
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via maybeInjectDelay()
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class MaybeInjectDelayActor>
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeInjectDelayActorState {
															#line 108 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeInjectDelayActorState(S3Operation const& op) 
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : op(op)
															#line 115 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("maybeInjectDelay", reinterpret_cast<unsigned long>(this));

	}
	~MaybeInjectDelayActorState() 
	{
		fdb_probe_actor_destroy("maybeInjectDelay", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 100 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			auto injector = S3FaultInjector::injector();
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			double delayRate = injector->getDelayRate() * getOperationMultiplier(op);
															#line 103 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (delayRate > 0.0 && deterministicRandom()->random01() < delayRate)
															#line 134 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				double maxDelay = injector->getMaxDelay();
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				double delayTime = deterministicRandom()->random01() * maxDelay;
															#line 107 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				TraceEvent("MockS3ChaosDelay") .detail("Operation", (int)op) .detail("Delay", delayTime) .detail("MaxDelay", maxDelay);
															#line 112 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(delayTime);
															#line 112 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (static_cast<MaybeInjectDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MaybeInjectDelayActor*>(this)->actor_wait_state = 1;
															#line 112 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaybeInjectDelayActor, 0, Void >*>(static_cast<MaybeInjectDelayActor*>(this)));
															#line 151 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaybeInjectDelayActorState();
		static_cast<MaybeInjectDelayActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 115 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<MaybeInjectDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MaybeInjectDelayActorState(); static_cast<MaybeInjectDelayActor*>(this)->destroy(); return 0; }
															#line 179 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<MaybeInjectDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MaybeInjectDelayActorState();
		static_cast<MaybeInjectDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaybeInjectDelayActor*>(this)->actor_wait_state > 0) static_cast<MaybeInjectDelayActor*>(this)->actor_wait_state = 0;
		static_cast<MaybeInjectDelayActor*>(this)->ActorCallback< MaybeInjectDelayActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MaybeInjectDelayActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeInjectDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaybeInjectDelayActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeInjectDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaybeInjectDelayActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeInjectDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maybeInjectDelay", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	S3Operation op;
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via maybeInjectDelay()
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeInjectDelayActor final : public Actor<Void>, public ActorCallback< MaybeInjectDelayActor, 0, Void >, public FastAllocated<MaybeInjectDelayActor>, public MaybeInjectDelayActorState<MaybeInjectDelayActor> {
															#line 281 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<MaybeInjectDelayActor>::operator new;
	using FastAllocated<MaybeInjectDelayActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13145010234036203264UL, 5486750437220163328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaybeInjectDelayActor, 0, Void >;
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeInjectDelayActor(S3Operation const& op) 
															#line 298 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MaybeInjectDelayActorState<MaybeInjectDelayActor>(op),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maybeInjectDelay", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16920948080833695744UL, 16787315299263966464UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeInjectDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maybeInjectDelay");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maybeInjectDelay", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaybeInjectDelayActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] Future<Void> maybeInjectDelay( S3Operation const& op ) {
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<Void>(new MaybeInjectDelayActor(op));
															#line 331 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 117 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"

// Phase 2: Inject errors if configured
															#line 337 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via maybeInjectError()
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class MaybeInjectErrorActor>
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeInjectErrorActorState {
															#line 344 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeInjectErrorActorState(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response,S3Operation const& op) 
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : req(req),
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   response(response),
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   op(op)
															#line 355 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("maybeInjectError", reinterpret_cast<unsigned long>(this));

	}
	~MaybeInjectErrorActorState() 
	{
		fdb_probe_actor_destroy("maybeInjectError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			auto injector = S3FaultInjector::injector();
															#line 123 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			double errorRate = injector->getErrorRate() * getOperationMultiplier(op);
															#line 125 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (errorRate <= 0.0 || deterministicRandom()->random01() >= errorRate)
															#line 374 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!static_cast<MaybeInjectErrorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MaybeInjectErrorActorState(); static_cast<MaybeInjectErrorActor*>(this)->destroy(); return 0; }
															#line 378 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				new (&static_cast<MaybeInjectErrorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MaybeInjectErrorActorState();
				static_cast<MaybeInjectErrorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 130 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			double throttleRate = injector->getThrottleRate() * getOperationMultiplier(op);
															#line 131 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (throttleRate > 0.0 && deterministicRandom()->random01() < throttleRate)
															#line 388 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 132 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->code = 429;
															#line 133 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.headers["Content-Type"] = "application/xml";
															#line 134 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.headers["Retry-After"] = "1";
															#line 136 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				std::string errorXML = generateS3ErrorXML("Throttling", "Request was throttled. Please retry.", req->resource);
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.content = new UnsentPacketQueue();
															#line 138 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.contentLen = errorXML.size();
															#line 139 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				PacketBuffer* buffer = response->data.content->getWriteBuffer(errorXML.size());
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				PacketWriter writer(buffer, nullptr, Unversioned());
															#line 141 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				writer.serializeBytes(errorXML);
															#line 142 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				writer.finish();
															#line 144 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				TraceEvent("MockS3ChaosThrottle").detail("Operation", (int)op).detail("Resource", req->resource);
															#line 147 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				auto metrics = g_network->global(INetwork::enChaosMetrics);
															#line 148 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (metrics)
															#line 416 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 149 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					static_cast<ChaosMetrics*>(metrics)->s3Throttles++;
															#line 420 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				}
															#line 152 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!static_cast<MaybeInjectErrorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MaybeInjectErrorActorState(); static_cast<MaybeInjectErrorActor*>(this)->destroy(); return 0; }
															#line 424 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				new (&static_cast<MaybeInjectErrorActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MaybeInjectErrorActorState();
				static_cast<MaybeInjectErrorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 156 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (deterministicRandom()->random01() < errorRate)
															#line 432 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 158 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				double errorType = deterministicRandom()->random01();
															#line 160 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				std::string errorXML;
															#line 161 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				std::string errorType_str;
															#line 162 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				int errorCode;
															#line 164 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (errorType < 0.4)
															#line 444 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 166 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					errorCode = 503;
															#line 167 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					errorType_str = "ServiceUnavailable";
															#line 168 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					errorXML = generateS3ErrorXML( "ServiceUnavailable", "The service is temporarily unavailable. Please retry.", req->resource);
															#line 452 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				}
				else
				{
															#line 170 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					if (errorType < 0.7)
															#line 458 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
					{
															#line 172 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
						errorCode = 500;
															#line 173 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
						errorType_str = "InternalError";
															#line 174 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
						errorXML = generateS3ErrorXML("InternalError", "We encountered an internal error. Please retry.", req->resource);
															#line 466 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
					}
					else
					{
															#line 176 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
						if (errorType < 0.85)
															#line 472 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
						{
															#line 178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
							errorCode = 502;
															#line 179 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
							errorType_str = "BadGateway";
															#line 180 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
							errorXML = generateS3ErrorXML("BadGateway", "Bad gateway error occurred.", req->resource);
															#line 480 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
						}
						else
						{
															#line 181 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
							if (errorType < 0.92)
															#line 486 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
							{
															#line 183 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorCode = 401;
															#line 184 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorType_str = "InvalidToken";
															#line 185 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorXML = generateS3ErrorXML("InvalidToken", "The provided token is invalid.", req->resource);
															#line 494 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
							}
							else
							{
															#line 188 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorCode = 406;
															#line 189 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorType_str = "ExpiredToken";
															#line 190 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
								errorXML = generateS3ErrorXML("ExpiredToken", "The provided token has expired.", req->resource);
															#line 504 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
							}
						}
					}
				}
															#line 193 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->code = errorCode;
															#line 194 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.headers["Content-Type"] = "application/xml";
															#line 195 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.content = new UnsentPacketQueue();
															#line 196 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				response->data.contentLen = errorXML.size();
															#line 197 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				PacketBuffer* buffer = response->data.content->getWriteBuffer(errorXML.size());
															#line 198 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				PacketWriter writer(buffer, nullptr, Unversioned());
															#line 199 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				writer.serializeBytes(errorXML);
															#line 200 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				writer.finish();
															#line 202 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				TraceEvent("MockS3ChaosError") .detail("Operation", (int)op) .detail("ErrorType", errorType_str) .detail("ErrorCode", errorCode) .detail("Resource", req->resource);
															#line 209 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				auto metrics = g_network->global(INetwork::enChaosMetrics);
															#line 210 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (metrics)
															#line 531 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 211 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					static_cast<ChaosMetrics*>(metrics)->s3Errors++;
															#line 535 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				}
															#line 214 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!static_cast<MaybeInjectErrorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MaybeInjectErrorActorState(); static_cast<MaybeInjectErrorActor*>(this)->destroy(); return 0; }
															#line 539 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				new (&static_cast<MaybeInjectErrorActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MaybeInjectErrorActorState();
				static_cast<MaybeInjectErrorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 217 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (!static_cast<MaybeInjectErrorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MaybeInjectErrorActorState(); static_cast<MaybeInjectErrorActor*>(this)->destroy(); return 0; }
															#line 547 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			new (&static_cast<MaybeInjectErrorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MaybeInjectErrorActorState();
			static_cast<MaybeInjectErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaybeInjectErrorActorState();
		static_cast<MaybeInjectErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	S3Operation op;
															#line 575 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via maybeInjectError()
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeInjectErrorActor final : public Actor<bool>, public FastAllocated<MaybeInjectErrorActor>, public MaybeInjectErrorActorState<MaybeInjectErrorActor> {
															#line 580 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<MaybeInjectErrorActor>::operator new;
	using FastAllocated<MaybeInjectErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3961752048750193920UL, 13763191048268652800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeInjectErrorActor(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response,S3Operation const& op) 
															#line 596 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MaybeInjectErrorActorState<MaybeInjectErrorActor>(req, response, op),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maybeInjectError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8335418808899265792UL, 1061059001604601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeInjectErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maybeInjectError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maybeInjectError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] Future<bool> maybeInjectError( Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response, S3Operation const& op ) {
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<bool>(new MaybeInjectErrorActor(req, response, op));
															#line 628 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 219 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"

// Phase 4: Corrupt response data if configured
															#line 634 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via maybeCorruptResponse()
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class MaybeCorruptResponseActor>
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeCorruptResponseActorState {
															#line 641 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeCorruptResponseActorState(Reference<HTTP::OutgoingResponse> const& response,S3Operation const& op) 
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : response(response),
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   op(op)
															#line 650 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("maybeCorruptResponse", reinterpret_cast<unsigned long>(this));

	}
	~MaybeCorruptResponseActorState() 
	{
		fdb_probe_actor_destroy("maybeCorruptResponse", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			auto injector = S3FaultInjector::injector();
															#line 223 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			double corruptionRate = injector->getCorruptionRate() * getOperationMultiplier(op);
															#line 225 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (corruptionRate <= 0.0 || deterministicRandom()->random01() >= corruptionRate)
															#line 669 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 226 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!static_cast<MaybeCorruptResponseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MaybeCorruptResponseActorState(); static_cast<MaybeCorruptResponseActor*>(this)->destroy(); return 0; }
															#line 673 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				new (&static_cast<MaybeCorruptResponseActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MaybeCorruptResponseActorState();
				static_cast<MaybeCorruptResponseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 230 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (response->code >= 200 && response->code < 300)
															#line 681 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 232 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (response->data.headers.find("ETag") != response->data.headers.end())
															#line 685 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 233 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					response->data.headers["ETag"] = "\"corrupted-" + deterministicRandom()->randomUniqueID().toString() + "\"";
															#line 689 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				}
															#line 236 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				TraceEvent("MockS3ChaosCorruption").detail("Operation", (int)op).detail("Resource", "response_data");
															#line 239 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				auto metrics = g_network->global(INetwork::enChaosMetrics);
															#line 240 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (metrics)
															#line 697 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 241 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					static_cast<ChaosMetrics*>(metrics)->s3Corruptions++;
															#line 701 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				}
			}
															#line 245 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (!static_cast<MaybeCorruptResponseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MaybeCorruptResponseActorState(); static_cast<MaybeCorruptResponseActor*>(this)->destroy(); return 0; }
															#line 706 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			new (&static_cast<MaybeCorruptResponseActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MaybeCorruptResponseActorState();
			static_cast<MaybeCorruptResponseActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaybeCorruptResponseActorState();
		static_cast<MaybeCorruptResponseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	S3Operation op;
															#line 732 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via maybeCorruptResponse()
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class MaybeCorruptResponseActor final : public Actor<Void>, public FastAllocated<MaybeCorruptResponseActor>, public MaybeCorruptResponseActorState<MaybeCorruptResponseActor> {
															#line 737 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<MaybeCorruptResponseActor>::operator new;
	using FastAllocated<MaybeCorruptResponseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6239427350644712192UL, 6779503320524953344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	MaybeCorruptResponseActor(Reference<HTTP::OutgoingResponse> const& response,S3Operation const& op) 
															#line 753 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MaybeCorruptResponseActorState<MaybeCorruptResponseActor>(response, op),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maybeCorruptResponse", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4839347907913359104UL, 9692759918776033792UL);
		ActorExecutionContextHelper __helper(static_cast<MaybeCorruptResponseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maybeCorruptResponse");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maybeCorruptResponse", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] Future<Void> maybeCorruptResponse( Reference<HTTP::OutgoingResponse> const& response, S3Operation const& op ) {
															#line 221 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<Void>(new MaybeCorruptResponseActor(response, op));
															#line 785 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 247 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"

// Core chaos server implementation
class MockS3ChaosServerImpl {
public:
																#line 793 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
// This generated class is to be used only via handleRequest()
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class HandleRequestActor>
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class HandleRequestActorState {
															#line 799 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	HandleRequestActorState(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : req(req),
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   response(response),
															#line 254 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   op(classifyS3Operation(req->verb, req->resource))
															#line 810 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleRequestActorState() 
	{
		fdb_probe_actor_destroy("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			TraceEvent("MockS3ChaosRequest") .detail("Method", req->verb) .detail("Resource", req->resource) .detail("Operation", (int)op) .detail("ContentLength", req->data.contentLen);
															#line 263 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			StrictFuture<Void> __when_expr_0 = maybeInjectDelay(op);
															#line 263 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 829 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleRequestActor*>(this)->actor_wait_state = 1;
															#line 263 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 0, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 834 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<bool> __when_expr_1 = maybeInjectError(req, response, op);
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 859 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleRequestActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 1, bool >*>(static_cast<HandleRequestActor*>(this)));
															#line 864 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<bool> __when_expr_1 = maybeInjectError(req, response, op);
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 875 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleRequestActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 1, bool >*>(static_cast<HandleRequestActor*>(this)));
															#line 880 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 267 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (errorInjected)
															#line 964 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		{
															#line 268 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (!static_cast<HandleRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleRequestActorState(); static_cast<HandleRequestActor*>(this)->destroy(); return 0; }
															#line 968 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			new (&static_cast<HandleRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleRequestActorState();
			static_cast<HandleRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 273 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_2 = processMockS3Request(req, response);
															#line 273 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 978 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<HandleRequestActor*>(this)->actor_wait_state = 3;
															#line 273 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 2, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 983 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& __errorInjected,int loopDepth) 
	{
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		errorInjected = __errorInjected;
															#line 992 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && __errorInjected,int loopDepth) 
	{
		errorInjected = std::move(__errorInjected);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_3 = maybeCorruptResponse(response, op);
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1073 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<HandleRequestActor*>(this)->actor_wait_state = 4;
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 3, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 1078 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_3 = maybeCorruptResponse(response, op);
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1089 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<HandleRequestActor*>(this)->actor_wait_state = 4;
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleRequestActor, 3, Void >*>(static_cast<HandleRequestActor*>(this)));
															#line 1094 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<HandleRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleRequestActorState(); static_cast<HandleRequestActor*>(this)->destroy(); return 0; }
															#line 1178 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<HandleRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<HandleRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleRequestActorState(); static_cast<HandleRequestActor*>(this)->destroy(); return 0; }
															#line 1190 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<HandleRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorCallback< HandleRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 254 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	S3Operation op;
															#line 266 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	bool errorInjected;
															#line 1281 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleRequest()
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class HandleRequestActor final : public Actor<Void>, public ActorCallback< HandleRequestActor, 0, Void >, public ActorCallback< HandleRequestActor, 1, bool >, public ActorCallback< HandleRequestActor, 2, Void >, public ActorCallback< HandleRequestActor, 3, Void >, public FastAllocated<HandleRequestActor>, public HandleRequestActorState<HandleRequestActor> {
															#line 1286 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleRequestActor>::operator new;
	using FastAllocated<HandleRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(953299979736437248UL, 16348581739747174144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleRequestActor, 0, Void >;
friend struct ActorCallback< HandleRequestActor, 1, bool >;
friend struct ActorCallback< HandleRequestActor, 2, Void >;
friend struct ActorCallback< HandleRequestActor, 3, Void >;
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	HandleRequestActor(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 1306 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleRequestActorState<HandleRequestActor>(req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3085149730912622080UL, 127431907239638784UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleRequestActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleRequestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< HandleRequestActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] static Future<Void> handleRequest( Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 251 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<Void>(new HandleRequestActor(req, response));
															#line 1341 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 280 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
};

// Public interface implementation
Future<Void> MockS3ChaosRequestHandler::handleRequest(Reference<HTTP::IncomingRequest> req,
                                                      Reference<HTTP::OutgoingResponse> response) {
	return MockS3ChaosServerImpl::handleRequest(req, response);
}

Reference<HTTP::IRequestHandler> MockS3ChaosRequestHandler::clone() {
	return makeReference<MockS3ChaosRequestHandler>();
}

// Safe server registration that prevents conflicts using truly simulator-global registry
															#line 1358 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerMockS3ChaosServer()
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class RegisterMockS3ChaosServerActor>
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class RegisterMockS3ChaosServerActorState {
															#line 1365 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	RegisterMockS3ChaosServerActorState(std::string const& ip,std::string const& port) 
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : ip(ip),
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   port(port),
															#line 294 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		   serverKey(ip + ":" + port)
															#line 1376 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this));

	}
	~RegisterMockS3ChaosServerActorState() 
	{
		fdb_probe_actor_destroy("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 295 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			ASSERT(g_simulator);
															#line 297 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			TraceEvent("MockS3ChaosServerRegistration") .detail("Phase", "Start") .detail("IP", ip) .detail("Port", port) .detail("ServerKey", serverKey) .detail("IsSimulated", g_network->isSimulated()) .detail("AlreadyRegistered", g_simulator->registeredMockS3ChaosServers.count(serverKey) > 0);
															#line 306 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (g_simulator->registeredMockS3ChaosServers.count(serverKey))
															#line 1395 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			{
															#line 307 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				TraceEvent(SevWarn, "MockS3ChaosServerAlreadyRegistered").detail("Address", serverKey);
															#line 308 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!static_cast<RegisterMockS3ChaosServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterMockS3ChaosServerActorState(); static_cast<RegisterMockS3ChaosServerActor*>(this)->destroy(); return 0; }
															#line 1401 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				new (&static_cast<RegisterMockS3ChaosServerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RegisterMockS3ChaosServerActorState();
				static_cast<RegisterMockS3ChaosServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 314 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
				if (!isMockS3PersistenceEnabled())
															#line 1410 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
				{
															#line 315 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					std::string persistenceDir = "simfdb/mocks3";
															#line 316 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					enableMockS3Persistence(persistenceDir);
															#line 317 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					TraceEvent("MockS3ChaosServerPersistenceEnabled") .detail("Address", serverKey) .detail("PersistenceDir", persistenceDir);
															#line 322 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					StrictFuture<Void> __when_expr_0 = loadMockS3PersistedStateFuture();
															#line 322 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1422 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >*>(static_cast<RegisterMockS3ChaosServerActor*>(this)));
															#line 1427 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterMockS3ChaosServerActorState();
		static_cast<RegisterMockS3ChaosServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 345 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<RegisterMockS3ChaosServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterMockS3ChaosServerActorState(); static_cast<RegisterMockS3ChaosServerActor*>(this)->destroy(); return 0; }
															#line 1461 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<RegisterMockS3ChaosServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterMockS3ChaosServerActorState();
		static_cast<RegisterMockS3ChaosServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 337 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			TraceEvent(SevError, "MockS3ChaosServerRegistrationFailed") .error(e) .detail("Address", serverKey) .detail("ErrorCode", e.code()) .detail("ErrorName", e.name());
															#line 342 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1476 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 325 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->registerSimHTTPServer(ip, port, makeReference<MockS3ChaosRequestHandler>());
															#line 325 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1492 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 2;
															#line 325 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >*>(static_cast<RegisterMockS3ChaosServerActor*>(this)));
															#line 1497 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state > 0) static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterMockS3ChaosServerActor*>(this)->ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		g_simulator->registeredMockS3ChaosServers.insert(serverKey);
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_2 = initializeMockS3Persistence(serverKey);
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1597 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 3;
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*>(static_cast<RegisterMockS3ChaosServerActor*>(this)));
															#line 1602 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		g_simulator->registeredMockS3ChaosServers.insert(serverKey);
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		StrictFuture<Void> __when_expr_2 = initializeMockS3Persistence(serverKey);
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1615 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 3;
															#line 329 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*>(static_cast<RegisterMockS3ChaosServerActor*>(this)));
															#line 1620 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state > 0) static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterMockS3ChaosServerActor*>(this)->ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		TraceEvent("MockS3ChaosServerRegistered") .detail("Address", serverKey) .detail("Success", true) .detail("TotalRegistered", g_simulator->registeredMockS3ChaosServers.size());
															#line 1704 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		TraceEvent("MockS3ChaosServerRegistered") .detail("Address", serverKey) .detail("Success", true) .detail("TotalRegistered", g_simulator->registeredMockS3ChaosServers.size());
															#line 1713 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state > 0) static_cast<RegisterMockS3ChaosServerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterMockS3ChaosServerActor*>(this)->ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	std::string ip;
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	std::string port;
															#line 294 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	std::string serverKey;
															#line 1812 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerMockS3ChaosServer()
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class RegisterMockS3ChaosServerActor final : public Actor<Void>, public ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >, public ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >, public ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >, public FastAllocated<RegisterMockS3ChaosServerActor>, public RegisterMockS3ChaosServerActorState<RegisterMockS3ChaosServerActor> {
															#line 1817 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterMockS3ChaosServerActor>::operator new;
	using FastAllocated<RegisterMockS3ChaosServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(784682556433681920UL, 17634348083803392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >;
friend struct ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >;
friend struct ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >;
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	RegisterMockS3ChaosServerActor(std::string const& ip,std::string const& port) 
															#line 1836 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterMockS3ChaosServerActorState<RegisterMockS3ChaosServerActor>(ip, port),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17838068988846746368UL, 6225627763031974144UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterMockS3ChaosServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerMockS3ChaosServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerMockS3ChaosServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterMockS3ChaosServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegisterMockS3ChaosServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RegisterMockS3ChaosServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] Future<Void> registerMockS3ChaosServer( std::string const& ip, std::string const& port ) {
															#line 293 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<Void>(new RegisterMockS3ChaosServerActor(ip, port));
															#line 1871 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 347 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"

// Public Interface Implementation
															#line 1877 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startMockS3ServerChaos()
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
template <class StartMockS3ServerChaosActor>
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class StartMockS3ServerChaosActorState {
															#line 1884 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	StartMockS3ServerChaosActorState(NetworkAddress const& listenAddress) 
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		 : listenAddress(listenAddress)
															#line 1891 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this));

	}
	~StartMockS3ServerChaosActorState() 
	{
		fdb_probe_actor_destroy("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 350 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 352 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			TraceEvent("MockS3ChaosServerStart") .detail("Address", listenAddress.toString()) .detail("IP", listenAddress.ip.toString()) .detail("Port", listenAddress.port);
															#line 358 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			StrictFuture<Void> __when_expr_0 = registerMockS3ChaosServer(listenAddress.ip.toString(), std::to_string(listenAddress.port));
															#line 358 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			if (static_cast<StartMockS3ServerChaosActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1912 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMockS3ServerChaosActor*>(this)->actor_wait_state = 1;
															#line 358 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMockS3ServerChaosActor, 0, Void >*>(static_cast<StartMockS3ServerChaosActor*>(this)));
															#line 1917 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMockS3ServerChaosActorState();
		static_cast<StartMockS3ServerChaosActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 360 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		TraceEvent("MockS3ChaosServerStarted").detail("Address", listenAddress.toString()).detail("Ready", true);
															#line 362 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<StartMockS3ServerChaosActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMockS3ServerChaosActorState(); static_cast<StartMockS3ServerChaosActor*>(this)->destroy(); return 0; }
															#line 1942 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<StartMockS3ServerChaosActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMockS3ServerChaosActorState();
		static_cast<StartMockS3ServerChaosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 360 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		TraceEvent("MockS3ChaosServerStarted").detail("Address", listenAddress.toString()).detail("Ready", true);
															#line 362 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
		if (!static_cast<StartMockS3ServerChaosActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMockS3ServerChaosActorState(); static_cast<StartMockS3ServerChaosActor*>(this)->destroy(); return 0; }
															#line 1956 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		new (&static_cast<StartMockS3ServerChaosActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMockS3ServerChaosActorState();
		static_cast<StartMockS3ServerChaosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMockS3ServerChaosActor*>(this)->actor_wait_state > 0) static_cast<StartMockS3ServerChaosActor*>(this)->actor_wait_state = 0;
		static_cast<StartMockS3ServerChaosActor*>(this)->ActorCallback< StartMockS3ServerChaosActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMockS3ServerChaosActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMockS3ServerChaosActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMockS3ServerChaosActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	NetworkAddress listenAddress;
															#line 2041 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startMockS3ServerChaos()
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
class StartMockS3ServerChaosActor final : public Actor<Void>, public ActorCallback< StartMockS3ServerChaosActor, 0, Void >, public FastAllocated<StartMockS3ServerChaosActor>, public StartMockS3ServerChaosActorState<StartMockS3ServerChaosActor> {
															#line 2046 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartMockS3ServerChaosActor>::operator new;
	using FastAllocated<StartMockS3ServerChaosActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(412329844264667904UL, 15865546400999938816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMockS3ServerChaosActor, 0, Void >;
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	StartMockS3ServerChaosActor(NetworkAddress const& listenAddress) 
															#line 2063 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartMockS3ServerChaosActorState<StartMockS3ServerChaosActor>(listenAddress),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10192931493606589696UL, 17221839075611792640UL);
		ActorExecutionContextHelper __helper(static_cast<StartMockS3ServerChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMockS3ServerChaos");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMockS3ServerChaos", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMockS3ServerChaosActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
[[nodiscard]] Future<Void> startMockS3ServerChaos( NetworkAddress const& listenAddress ) {
															#line 349 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"
	return Future<Void>(new StartMockS3ServerChaosActor(listenAddress));
															#line 2096 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/fdbserver/MockS3ServerChaos.actor.g.cpp.py_gen"
}

#line 364 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/fdbserver/MockS3ServerChaos.actor.cpp"

#include "flow/unactorcompiler.h"