#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
/*
 * play_network.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "flow/Arena.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h"

#include <iostream>
#include <vector>

/// This file has code similar to play.actor.cpp, but for client/server actors talking over a network
/// It's also similar to tutorial.actor.cpp but only has the minimal code needed for testing client/server actor
/// interactions over the network.
/// Use this file as means to play with flow code and test network behavior
/// The goal is to give you a starting point with a boilerplate template
/// Don't expect frequent changes to this file unless we want to change the base template
/// The use-case would be for people to have ephemeral code (on top of this template) that never gets checked in
/// An example use-case is in the description of https://github.com/apple/foundationdb/pull/12484

/// Usage below

/// Start server:
/// ~/c/bin $ ./play_network -s 6666 serverActor

/// Then client:
/// ~/c/bin $ ./play_network -c 127.0.0.1:6666 clientActor
/// req msg: Hello World
/// rsp msg: dlroW olleH

/// Now server prints:
/// ~/c/bin $ ./play_network -s 6666 serverActor
/// got interface request from client
/// sent interface back to client
/// got play request with msg: Hello World
/// sending this play response back: dlroW olleH
/// sent this play response back: dlroW olleH

NetworkAddress serverAddress;

enum TutorialWellKnownEndpoints { WLTOKEN_PLAY_SERVER = WLTOKEN_FIRST_AVAILABLE, WLTOKEN_COUNT_IN_TUTORIAL };

struct PlayServerInterface {
	constexpr static FileIdentifier file_identifier = 3152015;
	RequestStream<struct GetInterfaceRequest> getInterface;
	RequestStream<struct PlayRequest> play;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, getInterface, play);
	}
};

struct GetInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 12004156;
	ReplyPromise<PlayServerInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct PlayRequest {
	constexpr static FileIdentifier file_identifier = 10624019;
	std::string msg;
	// For now, returns a reverse of msg
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, msg, reply);
	}
};

															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via server()
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
template <class ServerActor>
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
class ServerActorState {
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
public:
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	ServerActorState() 
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		 : playServer()
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("server", reinterpret_cast<unsigned long>(this));

	}
	~ServerActorState() 
	{
		fdb_probe_actor_destroy("server", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			playServer.getInterface.makeWellKnownEndpoint(WLTOKEN_PLAY_SERVER, TaskPriority::DefaultEndpoint);
															#line 101 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			;
															#line 128 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerActorState();
		static_cast<ServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			auto __when_expr_0 = playServer.getInterface.getFuture();
															#line 159 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetInterfaceRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetInterfaceRequest>>::value, "invalid type");
															#line 103 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			if (static_cast<ServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 163 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 109 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			auto __when_expr_1 = playServer.play.getFuture();
															#line 167 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<PlayRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<PlayRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
			static_cast<ServerActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >*>(static_cast<ServerActor*>(this)));
															#line 109 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServerActor, 1, PlayRequest >*>(static_cast<ServerActor*>(this)));
															#line 175 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 197 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			{
															#line 119 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
				fprintf(stderr, "Error: %s\n", e.what());
															#line 120 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 203 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest const& req,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "got interface request from client" << std::endl;
															#line 106 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		req.reply.send(playServer);
															#line 107 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sent interface back to client" << std::endl;
															#line 229 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest && req,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "got interface request from client" << std::endl;
															#line 106 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		req.reply.send(playServer);
															#line 107 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sent interface back to client" << std::endl;
															#line 242 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(PlayRequest const& req,int loopDepth) 
	{
															#line 110 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "got play request with msg: " << req.msg << std::endl;
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::string rsp(req.msg.rbegin(), req.msg.rend());
															#line 112 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sending this play response back: " << rsp << std::endl;
															#line 113 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		req.reply.send(rsp);
															#line 114 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sent this play response back: " << rsp << std::endl;
															#line 259 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(PlayRequest && req,int loopDepth) 
	{
															#line 110 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "got play request with msg: " << req.msg << std::endl;
															#line 111 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::string rsp(req.msg.rbegin(), req.msg.rend());
															#line 112 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sending this play response back: " << rsp << std::endl;
															#line 113 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		req.reply.send(rsp);
															#line 114 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "sent this play response back: " << rsp << std::endl;
															#line 276 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerActor*>(this)->actor_wait_state > 0) static_cast<ServerActor*>(this)->actor_wait_state = 0;
		static_cast<ServerActor*>(this)->ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >::remove();
		static_cast<ServerActor*>(this)->ActorSingleCallback< ServerActor, 1, PlayRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest const& value) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest && value) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >*,Error err) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServerActor, 1, PlayRequest >*,PlayRequest const& value) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServerActor, 1, PlayRequest >*,PlayRequest && value) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServerActor, 1, PlayRequest >*,Error err) 
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 97 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	PlayServerInterface playServer;
															#line 417 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
};
// This generated class is to be used only via server()
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
class ServerActor final : public Actor<Void>, public ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >, public ActorSingleCallback< ServerActor, 1, PlayRequest >, public FastAllocated<ServerActor>, public ServerActorState<ServerActor> {
															#line 422 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServerActor>::operator new;
	using FastAllocated<ServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12638082679689515264UL, 14874803834354657792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >;
friend struct ActorSingleCallback< ServerActor, 1, PlayRequest >;
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	ServerActor() 
															#line 440 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServerActorState<ServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("server", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10990178576500354560UL, 628578272264624384UL);
		ActorExecutionContextHelper __helper(static_cast<ServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("server");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("server", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServerActor, 0, GetInterfaceRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
[[nodiscard]] Future<Void> server(  ) {
															#line 95 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	return Future<Void>(new ServerActor());
															#line 473 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
}

#line 125 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"

															#line 478 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via client()
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
template <class ClientActor>
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
class ClientActorState {
															#line 485 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
public:
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	ClientActorState() 
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
															#line 128 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		 : server()
															#line 492 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("client", reinterpret_cast<unsigned long>(this));

	}
	~ClientActorState() 
	{
		fdb_probe_actor_destroy("client", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			server.getInterface = RequestStream<GetInterfaceRequest>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_PLAY_SERVER));
															#line 131 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			StrictFuture<PlayServerInterface> __when_expr_0 = server.getInterface.getReply(GetInterfaceRequest());
															#line 131 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			if (static_cast<ClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 511 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClientActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClientActor, 0, PlayServerInterface >*>(static_cast<ClientActor*>(this)));
															#line 516 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClientActorState();
		static_cast<ClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(PlayServerInterface const& s,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		server = s;
															#line 135 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		PlayRequest playReq;
															#line 136 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		playReq.msg = "Hello World";
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "req msg: " << playReq.msg << std::endl;
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.play.getReply(playReq);
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		if (static_cast<ClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 549 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClientActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientActor, 1, std::string >*>(static_cast<ClientActor*>(this)));
															#line 554 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(PlayServerInterface && s,int loopDepth) 
	{
															#line 132 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		server = s;
															#line 135 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		PlayRequest playReq;
															#line 136 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		playReq.msg = "Hello World";
															#line 137 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "req msg: " << playReq.msg << std::endl;
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.play.getReply(playReq);
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		if (static_cast<ClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 573 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClientActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientActor, 1, std::string >*>(static_cast<ClientActor*>(this)));
															#line 578 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(PlayServerInterface const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(PlayServerInterface && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClientActor*>(this)->actor_wait_state > 0) static_cast<ClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActor*>(this)->ActorCallback< ClientActor, 0, PlayServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActor, 0, PlayServerInterface >*,PlayServerInterface const& value) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientActor, 0, PlayServerInterface >*,PlayServerInterface && value) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClientActor, 0, PlayServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::string const& playRsp,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "rsp msg: " << playRsp << std::endl;
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		if (!static_cast<ClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClientActorState(); static_cast<ClientActor*>(this)->destroy(); return 0; }
															#line 664 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		new (&static_cast<ClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClientActorState();
		static_cast<ClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && playRsp,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		std::cout << "rsp msg: " << playRsp << std::endl;
															#line 145 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
		if (!static_cast<ClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClientActorState(); static_cast<ClientActor*>(this)->destroy(); return 0; }
															#line 678 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		new (&static_cast<ClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClientActorState();
		static_cast<ClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& playRsp,int loopDepth) 
	{
		loopDepth = a_body1cont2(playRsp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && playRsp,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(playRsp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClientActor*>(this)->actor_wait_state > 0) static_cast<ClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActor*>(this)->ActorCallback< ClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 128 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	PlayServerInterface server;
															#line 763 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
};
// This generated class is to be used only via client()
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
class ClientActor final : public Actor<Void>, public ActorCallback< ClientActor, 0, PlayServerInterface >, public ActorCallback< ClientActor, 1, std::string >, public FastAllocated<ClientActor>, public ClientActorState<ClientActor> {
															#line 768 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClientActor>::operator new;
	using FastAllocated<ClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16875541116665845504UL, 17173643498298423296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClientActor, 0, PlayServerInterface >;
friend struct ActorCallback< ClientActor, 1, std::string >;
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	ClientActor() 
															#line 786 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClientActorState<ClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("client", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15302374491429075456UL, 14115929227161537792UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("client");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("client", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClientActor, 0, PlayServerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClientActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
[[nodiscard]] Future<Void> client(  ) {
															#line 126 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"
	return Future<Void>(new ClientActor());
															#line 820 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play_network.actor.g.cpp.py_gen"
}

#line 147 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play_network.actor.cpp"

std::unordered_map<std::string, std::function<Future<Void>()>> actors = {
	{ "serverActor", &server }, // ./play_network -s 6666 serverActor
	{ "clientActor", &client }, // ./play_network -c 127.0.0.1:6666 clientActor
};

int main(int argc, char* argv[]) {
	bool isServer = false;
	std::string port;
	std::vector<std::function<Future<Void>()>> toRun;

	// parse arguments
	for (int i = 1; i < argc; ++i) {
		std::string arg(argv[i]);
		if (arg == "-s") {
			isServer = true;
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -p\n";
				return 1;
			}
			port = std::string(argv[++i]);
			continue;
		} else if (arg == "-c") {
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -s\n";
				return 1;
			}
			serverAddress = NetworkAddress::parse(argv[++i]);
			continue;
		} else {
			assert(false);
		}

		auto actor = actors.find(arg);
		if (actor == actors.end()) {
			std::cout << format("Error: actor %s does not exist\n", arg.c_str());
			return 1;
		}
		toRun.push_back(actor->second);
	}

	// platform init
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);
	FlowTransport::createInstance(!isServer, 0, WLTOKEN_COUNT_IN_TUTORIAL);
	NetworkAddress publicAddress = NetworkAddress::parse("0.0.0.0:0");
	if (isServer) {
		publicAddress = NetworkAddress::parse("0.0.0.0:" + port);
	}

	try {
		if (isServer) {
			auto listenError = FlowTransport::transport().bind(publicAddress, publicAddress);
			if (listenError.isError()) {
				listenError.get();
			}
		}
	} catch (Error& e) {
		std::cout << format("Error while binding to address (%d): %s\n", e.code(), e.what());
	}

	// now we start the actors
	std::vector<Future<Void>> all;
	all.reserve(toRun.size());
	for (auto& f : toRun) {
		all.emplace_back(f());
	}

	auto f = stopAfter(waitForAll(all));

	g_network->run();

	return 0;
}