#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
/*
 * play.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "flow/Arena.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h"

#include <iostream>
#include <vector>

/// Use this file as means to play with flow code
/// The goal is to give you a starting point with a boilerplate template
/// Don't expect frequent changes to this file unless we want to change the base template
/// The use-case would be for people to have ephemeral code (on top of this template) that never gets checked in

															#line 38 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via foo()
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
template <class FooActor>
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
class FooActorState {
															#line 45 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
public:
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
	FooActorState() 
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
	{
															#line 51 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
		fdb_probe_actor_create("foo", reinterpret_cast<unsigned long>(this));

	}
	~FooActorState() 
	{
		fdb_probe_actor_destroy("foo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
			std::cout << "foo enter" << std::endl;
															#line 38 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(1);
															#line 38 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
			if (static_cast<FooActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 69 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FooActor*>(this)->actor_wait_state = 1;
															#line 38 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FooActor, 0, Void >*>(static_cast<FooActor*>(this)));
															#line 74 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FooActorState();
		static_cast<FooActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 39 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
		std::cout << "foo exit" << std::endl;
															#line 40 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
		if (!static_cast<FooActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FooActorState(); static_cast<FooActor*>(this)->destroy(); return 0; }
															#line 99 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
		new (&static_cast<FooActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FooActorState();
		static_cast<FooActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 39 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
		std::cout << "foo exit" << std::endl;
															#line 40 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
		if (!static_cast<FooActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FooActorState(); static_cast<FooActor*>(this)->destroy(); return 0; }
															#line 113 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
		new (&static_cast<FooActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FooActorState();
		static_cast<FooActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FooActor*>(this)->actor_wait_state > 0) static_cast<FooActor*>(this)->actor_wait_state = 0;
		static_cast<FooActor*>(this)->ActorCallback< FooActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FooActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("foo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FooActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("foo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FooActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("foo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FooActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("foo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FooActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("foo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FooActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("foo", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via foo()
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
class FooActor final : public Actor<Void>, public ActorCallback< FooActor, 0, Void >, public FastAllocated<FooActor>, public FooActorState<FooActor> {
															#line 200 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
public:
	using FastAllocated<FooActor>::operator new;
	using FastAllocated<FooActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3497927442781491200UL, 7644256029073082624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FooActor, 0, Void >;
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
	FooActor() 
															#line 217 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FooActorState<FooActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("foo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11477833932375782144UL, 6014218575318761216UL);
		ActorExecutionContextHelper __helper(static_cast<FooActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("foo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("foo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FooActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
[[nodiscard]] Future<Void> foo(  ) {
															#line 36 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"
	return Future<Void>(new FooActor());
															#line 250 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/build_output/documentation/tutorial/play.actor.g.cpp.py_gen"
}

#line 42 "/codebuild/output/src2236818296/src/github.com/apple/foundationdb/documentation/tutorial/play.actor.cpp"

int main(int argc, char** argv) {
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);

	std::vector<Future<Void>> all;
	all.emplace_back(foo());

	auto f = stopAfter(waitForAll(all));
	g_network->run();

	return 0;
}
