/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.MultiClientHelper;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;

public class CycleMultiClientIntegrationTest {
    public static final MultiClientHelper clientHelper = new MultiClientHelper();
    private static final int writeTxnCnt = 200;
    private static final int validateTxnCnt = 100;
    private static final int threadPerDB = 5;
    private static final int cycleLength = 4;
    private static List<String> expected = new ArrayList<String>(Arrays.asList("0", "1", "2", "3"));

    public static void main(String[] stringArray) throws Exception {
        FDB fDB = FDB.selectAPIVersion((int)800);
        CycleMultiClientIntegrationTest.setupThreads(fDB);
        Collection<Database> collection = clientHelper.openDatabases(fDB);
        System.out.println("Starting tests");
        CycleMultiClientIntegrationTest.setup(collection);
        System.out.println("Start processing and validating");
        CycleMultiClientIntegrationTest.process(collection);
        CycleMultiClientIntegrationTest.check(collection);
        System.out.println("Test finished");
    }

    private static synchronized void setupThreads(FDB fDB) {
        int n = clientHelper.readClusterFromEnv().length;
        fDB.options().setClientThreadsPerVersion((long)n);
        System.out.printf("thread per version is %d\n", n);
        fDB.options().setExternalClientDirectory("/var/dynamic-conf/lib");
        fDB.options().setTraceEnable("/tmp");
        fDB.options().setKnob("min_trace_severity=5");
    }

    private static void setup(Collection<Database> collection) {
        for (Database database : collection) {
            database.run(transaction -> {
                for (int i = 0; i < 4; ++i) {
                    String string = Integer.toString(i);
                    String string2 = Integer.toString((i + 1) % 4);
                    transaction.set(Tuple.from((Object[])new Object[]{string}).pack(), Tuple.from((Object[])new Object[]{string2}).pack());
                }
                return null;
            });
        }
    }

    private static void process(Collection<Database> collection) {
        for (Database database : collection) {
            for (int i = 0; i < 5; ++i) {
                Thread thread = new Thread(CycleWorkload.create(database));
                thread.start();
            }
        }
    }

    private static void check(Collection<Database> collection) throws InterruptedException {
        int n;
        HashMap<Thread, CycleChecker> hashMap = new HashMap<Thread, CycleChecker>();
        for (Database object : collection) {
            for (n = 0; n < 5; ++n) {
                CycleChecker cycleChecker = new CycleChecker(object);
                Thread thread = new Thread(cycleChecker);
                thread.start();
                hashMap.put(thread, cycleChecker);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((Thread)entry.getKey()).join();
            n = ((CycleChecker)entry.getValue()).succeed() ? 1 : 0;
            Assertions.assertTrue(n != 0, (String)"Cycle test failed");
        }
    }

    public static class CycleChecker
    implements Runnable {
        private final Database db;
        private boolean succeed;

        public CycleChecker(Database database) {
            this.db = database;
            this.succeed = true;
        }

        public static CycleChecker create(Database database) {
            return new CycleChecker(database);
        }

        @Override
        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.db.run(transaction -> {
                    int n = ThreadLocalRandom.current().nextInt(4);
                    String string = Integer.toString(n);
                    byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string}).pack()).join();
                    String string2 = Tuple.fromBytes((byte[])byArray).getString(0);
                    byte[] byArray2 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string2}).pack()).join();
                    String string3 = Tuple.fromBytes((byte[])byArray2).getString(0);
                    byte[] byArray3 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string3}).pack()).join();
                    String string4 = Tuple.fromBytes((byte[])byArray3).getString(0);
                    byte[] byArray4 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string4}).pack()).join();
                    String string5 = Tuple.fromBytes((byte[])byArray4).getString(0);
                    if (!string.equals(string5)) {
                        this.succeed = false;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string2, string3, string4, string5));
                    Collections.sort(arrayList);
                    if (!expected.equals(arrayList)) {
                        this.succeed = false;
                    }
                    return null;
                });
            }
        }

        public boolean succeed() {
            return this.succeed;
        }
    }

    public static class CycleWorkload
    implements Runnable {
        private final Database db;

        private CycleWorkload(Database database) {
            this.db = database;
        }

        public static CycleWorkload create(Database database) {
            return new CycleWorkload(database);
        }

        @Override
        public void run() {
            for (int i = 0; i < 200; ++i) {
                this.db.run(transaction -> {
                    int n = ThreadLocalRandom.current().nextInt(4);
                    String string = Integer.toString(n);
                    byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string}).pack()).join();
                    String string2 = Tuple.fromBytes((byte[])byArray).getString(0);
                    byte[] byArray2 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string2}).pack()).join();
                    String string3 = Tuple.fromBytes((byte[])byArray2).getString(0);
                    byte[] byArray3 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string3}).pack()).join();
                    String string4 = Tuple.fromBytes((byte[])byArray3).getString(0);
                    byte[] byArray4 = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string4}).pack()).join();
                    transaction.set(Tuple.from((Object[])new Object[]{string}).pack(), Tuple.from((Object[])new Object[]{string3}).pack());
                    transaction.set(Tuple.from((Object[])new Object[]{string3}).pack(), Tuple.from((Object[])new Object[]{string2}).pack());
                    transaction.set(Tuple.from((Object[])new Object[]{string2}).pack(), Tuple.from((Object[])new Object[]{string4}).pack());
                    return null;
                });
            }
        }
    }
}

