#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
/*
 * Cycle.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/UnitTest.h"
#include "flow/WipedString.h"
#include "flow/serialize.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct CycleWorkload : TestWorkload, Arena {
	static constexpr auto NAME = "Cycle";
	int actorCount, nodeCount;
	double testDuration, transactionsPerSecond, minExpectedTransactionsPerSecond, traceParentProbability;
	bool unseedCheck{ true };
	bool skipSetup{ false }; // Useful for restarting tests
	Key keyPrefix;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries, tooOldRetries, commitFailedRetries;
	PerfDoubleCounter totalLatency;

	CycleWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), tooOldRetries("Retries.too_old"),
	    commitFailedRetries("Retries.commit_failed"), totalLatency("Latency") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		nodeCount = getOption(options, "nodeCount"_sr, transactionsPerSecond * clientCount);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, ""_sr).toString());
		traceParentProbability = getOption(options, "traceParentProbability"_sr, 0.01);
		minExpectedTransactionsPerSecond = transactionsPerSecond * getOption(options, "expectedRate"_sr, 0.7);
		unseedCheck = getOption(options, "unseedCheck"_sr, true);
		skipSetup = getOption(options, "skipSetup"_sr, false);
	}

	Future<Void> setup(Database const& cx) override {
		if (!unseedCheck) {
			noUnseed = true;
		}
		if (skipSetup) {
			return Void();
		}
		// TODO(gglass): possible cleanup here.  Leftover tenant stuff.
		Future<Void> prepare = Void();
		return runAfter(prepare, [this, cx](Void) { return bulkSetup(cx, this, nodeCount, Promise<double>()); });
	}
	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++)
			clients.push_back(
			    timeout(cycleClient(cx->clone(), this, actorCount / transactionsPerSecond), testDuration, Void()));
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		int errors = 0;
		for (int c = 0; c < clients.size(); c++)
			errors += clients[c].isError();
		if (errors)
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were client errors.");
		clients.clear();
		return cycleCheck(cx->clone(), this, !errors);
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(tooOldRetries.getMetric());
		m.push_back(commitFailedRetries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
		m.emplace_back("Read rows/simsec (approx)", transactions.getValue() * 3 / testDuration, Averaged::False);
		m.emplace_back("Write rows/simsec (approx)", transactions.getValue() * 4 / testDuration, Averaged::False);
	}

	Key keyForIndex(int n) { return key(n); }
	Key key(int n) { return doubleToTestKey((double)n / nodeCount, keyPrefix); }
	Value value(int n) { return doubleToTestKey(n, keyPrefix); }
	KeyRange keyRange(int n) {
		Key beginKey = doubleToTestKey((double)n / nodeCount, keyPrefix);
		Key endKey = beginKey.withSuffix(" end"_sr);
		return KeyRangeRef(beginKey, endKey);
	}
	int fromValue(const ValueRef& v) { return testKeyToDouble(v, keyPrefix); }

	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(key(n), value((n + 1) % nodeCount)); }

	void badRead(const char* name, int r, Transaction& tr) {
		TraceEvent(SevError, "CycleBadRead")
		    .detail(name, r)
		    .detail("Key", printable(key(r)))
		    .detail("Version", tr.getReadVersion().get())
		    .detailf("From", "%016llx", debug_lastLoadBalanceResultEndpointToken);
	}

																#line 120 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
// This generated class is to be used only via cycleClient()
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
template <class CycleClientActor>
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleClientActorState {
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
public:
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleClientActorState(Database const& cx,CycleWorkload* const& self,double const& delay) 
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		 : cx(cx),
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   self(self),
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   delay(delay),
															#line 119 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   lastTime(now())
															#line 139 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	~CycleClientActorState() 
	{
		fdb_probe_actor_destroy("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleClientStart").log();
															#line 154 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			try {
															#line 122 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				;
															#line 158 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleClientActorState();
		static_cast<CycleClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent(SevError, "CycleClient").error(e);
															#line 185 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 190 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 123 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 213 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 0, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 218 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tstart = now();
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r = deterministicRandom()->randomInt(0, self->nodeCount);
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr = Transaction(cx);
															#line 128 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (deterministicRandom()->random01() <= self->traceParentProbability)
															#line 233 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			span = Span("CycleClient"_loc);
															#line 130 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleTracingTransaction", span.context.traceID).log();
															#line 131 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, IncludeVersion()));
															#line 241 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 134 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		;
															#line 245 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tstart = now();
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r = deterministicRandom()->randomInt(0, self->nodeCount);
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr = Transaction(cx);
															#line 128 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (deterministicRandom()->random01() <= self->traceParentProbability)
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			span = Span("CycleClient"_loc);
															#line 130 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleTracingTransaction", span.context.traceID).log();
															#line 131 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, IncludeVersion()));
															#line 268 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 134 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		;
															#line 272 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 180 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		++self->transactions;
															#line 181 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->totalLatency += now() - tstart;
															#line 358 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 137 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(self->key(r));
															#line 137 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 377 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 2;
															#line 137 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 1, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 382 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		++self->retries;
															#line 410 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 420 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			{
															#line 173 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				++self->tooOldRetries;
															#line 424 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			}
			else
			{
															#line 174 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				if (e.code() == error_code_not_committed)
															#line 430 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
				{
															#line 175 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
					++self->commitFailedRetries;
															#line 434 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
				}
			}
															#line 176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 441 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 6;
															#line 176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 5, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 446 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v.present())
															#line 461 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 139 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 465 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 141 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 473 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 478 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v.present())
															#line 487 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 139 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 491 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 141 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 499 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 504 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> const& v2,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v2.present())
															#line 588 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 144 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 592 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 145 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 605 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> && v2,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v2.present())
															#line 614 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 144 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 618 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 145 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 626 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 631 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> const& v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(v2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> && v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(v2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> const& v3,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v3.present())
															#line 715 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 719 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 149 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r4 = self->fromValue(v3.get());
															#line 153 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.clear( self->keyRange(r), AddConflictRange::True);
															#line 156 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 157 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 158 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 735 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 740 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> && v3,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v3.present())
															#line 749 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 753 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 149 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r4 = self->fromValue(v3.get());
															#line 153 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.clear( self->keyRange(r), AddConflictRange::True);
															#line 156 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 157 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 158 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 769 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 774 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> const& v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(v3, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> && v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(std::move(v3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Database cx;
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleWorkload* self;
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double delay;
															#line 119 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double lastTime;
															#line 125 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double tstart;
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r;
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Transaction tr;
															#line 129 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Span span;
															#line 141 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r2;
															#line 145 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r3;
															#line 149 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r4;
															#line 1050 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cycleClient()
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleClientActor final : public Actor<Void>, public ActorCallback< CycleClientActor, 0, Void >, public ActorCallback< CycleClientActor, 1, Optional<Value> >, public ActorCallback< CycleClientActor, 2, Optional<Value> >, public ActorCallback< CycleClientActor, 3, Optional<Value> >, public ActorCallback< CycleClientActor, 4, Void >, public ActorCallback< CycleClientActor, 5, Void >, public FastAllocated<CycleClientActor>, public CycleClientActorState<CycleClientActor> {
															#line 1055 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<CycleClientActor>::operator new;
	using FastAllocated<CycleClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11124629988649534208UL, 964844831065965824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleClientActor, 0, Void >;
friend struct ActorCallback< CycleClientActor, 1, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 2, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 3, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 4, Void >;
friend struct ActorCallback< CycleClientActor, 5, Void >;
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleClientActor(Database const& cx,CycleWorkload* const& self,double const& delay) 
															#line 1077 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CycleClientActorState<CycleClientActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8966781505302877440UL, 11126568448771745280UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleClientActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CycleClientActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CycleClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CycleClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
[[nodiscard]] Future<Void> cycleClient( Database const& cx, CycleWorkload* const& self, double const& delay ) {
															#line 118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	return Future<Void>(new CycleClientActor(cx, self, delay));
															#line 1114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
}

#line 188 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"

	void logTestData(const VectorRef<KeyValueRef>& data) {
		TraceEvent("TestFailureDetail").log();
		int index = 0;
		for (auto& entry : data) {
			TraceEvent("CurrentDataEntry")
			    .detail("Index", index)
			    .detail("Key", entry.key.toString())
			    .detail("Value", entry.value.toString());
			index++;
		}
	}

	bool cycleCheckData(const VectorRef<KeyValueRef>& data, Version v) {
		if (data.size() != nodeCount) {
			logTestData(data);
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Node count changed")
			    .detail("Before", nodeCount)
			    .detail("After", data.size())
			    .detail("Version", v)
			    .detail("KeyPrefix", keyPrefix.printable());
			TraceEvent(SevError, "TestFailureInfo")
			    .detail("DataSize", data.size())
			    .detail("NodeCount", nodeCount)
			    .detail("Workload", description());
			return false;
		}
		int i = 0;
		int iPrev = 0;
		double d;
		int c;
		for (c = 0; c < nodeCount; c++) {
			if (c && !i) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Cycle got shorter")
				    .detail("Before", nodeCount)
				    .detail("After", c)
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
			if (data[i].key != key(i)) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Key changed")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
			d = testKeyToDouble(data[i].value, keyPrefix);
			iPrev = i;
			i = (int)d;
			if (i != d || i < 0 || i >= nodeCount) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Invalid value")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
		}
		if (i != 0) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Cycle got longer")
			    .detail("KeyPrefix", keyPrefix.printable())
			    .detail("Key", key(i))
			    .detail("Value", data[i].value)
			    .detail("Iteration", c)
			    .detail("Nodecount", nodeCount)
			    .detail("Int", i)
			    .detail("Double", d)
			    .detail("ValuePrev", data[iPrev].value)
			    .detail("KeyPrev", data[iPrev].key);
			logTestData(data);
			return false;
		}
		return true;
	}

																#line 1196 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
// This generated class is to be used only via cycleCheck()
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
template <class CycleCheckActor>
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleCheckActorState {
															#line 1202 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
public:
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleCheckActorState(Database const& cx,CycleWorkload* const& self,bool const& ok) 
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		 : cx(cx),
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   self(self),
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   ok(ok)
															#line 1213 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cycleCheck", reinterpret_cast<unsigned long>(this));

	}
	~CycleCheckActorState() 
	{
		fdb_probe_actor_destroy("cycleCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 267 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (self->transactions.getMetric().value() < self->testDuration * self->minExpectedTransactionsPerSecond)
															#line 1228 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			{
															#line 268 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				TraceEvent(SevWarnAlways, "TestFailure") .detail("Reason", "Rate below desired rate") .detail("File", __FILE__) .detail( "Details", format("%.2f", self->transactions.getMetric().value() / (self->transactionsPerSecond * self->testDuration))) .detail("TransactionsAchieved", self->transactions.getMetric().value()) .detail("MinTransactionsExpected", self->testDuration * self->minExpectedTransactionsPerSecond) .detail("TransactionGoal", self->transactionsPerSecond * self->testDuration);
															#line 278 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				ok = false;
															#line 1234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			}
															#line 280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (!self->clientId)
															#line 1238 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			{
															#line 282 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				tr = Transaction(cx);
															#line 283 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				retryCount = 0;
															#line 284 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				;
															#line 1246 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleCheckActorState();
		static_cast<CycleCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 304 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!self->unseedCheck)
															#line 1274 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		{
															#line 305 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			ASSERT(noUnseed);
															#line 1278 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		}
															#line 307 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!static_cast<CycleCheckActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~CycleCheckActorState(); static_cast<CycleCheckActor*>(this)->destroy(); return 0; }
															#line 1282 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		new (&static_cast<CycleCheckActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~CycleCheckActorState();
		static_cast<CycleCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1310 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CycleCheckActor*>(this)->actor_wait_state = 1;
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 0, Version >*>(static_cast<CycleCheckActor*>(this)));
															#line 1315 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 293 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			retryCount++;
															#line 294 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent(retryCount > 20 ? SevWarnAlways : SevWarn, "CycleCheckError").error(e);
															#line 295 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (g_network->isSimulated() && retryCount > 50)
															#line 1354 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			{
															#line 296 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				CODE_PROBE(true, "Cycle check enable speedUpSimulation because too many transaction_too_old()");
															#line 298 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				g_simulator->speedUpSimulation = true;
															#line 1360 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			}
															#line 300 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 300 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1366 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CycleCheckActor*>(this)->actor_wait_state = 3;
															#line 300 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 2, Void >*>(static_cast<CycleCheckActor*>(this)));
															#line 1371 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 287 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(firstGreaterOrEqual(doubleToTestKey(0.0, self->keyPrefix)), firstGreaterOrEqual(doubleToTestKey(1.0, self->keyPrefix)), self->nodeCount + 1);
															#line 287 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1388 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CycleCheckActor*>(this)->actor_wait_state = 2;
															#line 287 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 1, RangeResult >*>(static_cast<CycleCheckActor*>(this)));
															#line 1393 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __v,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		v = __v;
															#line 1402 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& data,int loopDepth) 
	{
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ok = self->cycleCheckData(data, v) && ok;
															#line 1481 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && data,int loopDepth) 
	{
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ok = self->cycleCheckData(data, v) && ok;
															#line 1490 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Database cx;
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleWorkload* self;
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	bool ok;
															#line 282 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Transaction tr;
															#line 283 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int retryCount;
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Version v;
															#line 1669 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cycleCheck()
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleCheckActor final : public Actor<bool>, public ActorCallback< CycleCheckActor, 0, Version >, public ActorCallback< CycleCheckActor, 1, RangeResult >, public ActorCallback< CycleCheckActor, 2, Void >, public FastAllocated<CycleCheckActor>, public CycleCheckActorState<CycleCheckActor> {
															#line 1674 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<CycleCheckActor>::operator new;
	using FastAllocated<CycleCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6336448179473266176UL, 7823457008160745984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleCheckActor, 0, Version >;
friend struct ActorCallback< CycleCheckActor, 1, RangeResult >;
friend struct ActorCallback< CycleCheckActor, 2, Void >;
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleCheckActor(Database const& cx,CycleWorkload* const& self,bool const& ok) 
															#line 1693 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CycleCheckActorState<CycleCheckActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3005189881623422208UL, 7841844818168212480UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleCheckActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleCheckActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
[[nodiscard]] Future<bool> cycleCheck( Database const& cx, CycleWorkload* const& self, bool const& ok ) {
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	return Future<bool>(new CycleCheckActor(cx, self, ok));
															#line 1727 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp.py_gen"
}

#line 309 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
};

WorkloadFactory<CycleWorkload> CycleWorkloadFactory(UntrustedMode::False);
