#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
/*
 * genericactors.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FDBRPC_GENERICACTORS_ACTOR_G_H)
#define FDBRPC_GENERICACTORS_ACTOR_G_H
#include "fdbrpc/genericactors.actor.g.h"
#elif !defined(RPCGENERICACTORS_ACTOR_H)
#define RPCGENERICACTORS_ACTOR_H

#include "flow/genericactors.actor.h"
#include "flow/CodeProbe.h"
#include "flow/Hostname.h"

#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/WellKnownEndpoints.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// To avoid directly access INetworkConnection::net()->removeCachedDNS(), which will require heavy include budget, put
// the call to FlowTransport.actor.cpp as a external function.
extern void removeCachedDNS(const std::string& host, const std::string& service);

															#line 44 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via retryBrokenPromise()
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P, class RetryBrokenPromiseActor>
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryBrokenPromiseActorState {
															#line 51 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryBrokenPromiseActorState(RequestStream<Req, P> const& to,Req const& request) 
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : to(to),
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   request(request)
															#line 60 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("retryBrokenPromise", reinterpret_cast<unsigned long>(this));

	}
	~RetryBrokenPromiseActorState() 
	{
		fdb_probe_actor_destroy("retryBrokenPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 48 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 75 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RetryBrokenPromiseActorState();
		static_cast<RetryBrokenPromiseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 50 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<REPLY_TYPE(Req)> __when_expr_0 = to.getReply(request);
															#line 50 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 108 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state = 1;
															#line 50 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RetryBrokenPromiseActor, 0, REPLY_TYPE(Req) >*>(static_cast<RetryBrokenPromiseActor*>(this)));
															#line 113 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() != error_code_broken_promise)
															#line 135 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 54 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 139 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 55 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 56 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delayJittered(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 56 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 147 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state = 2;
															#line 56 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryBrokenPromiseActor, 1, Void >*>(static_cast<RetryBrokenPromiseActor*>(this)));
															#line 152 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLY_TYPE(Req) const& reply,int loopDepth) 
	{
															#line 51 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<RetryBrokenPromiseActor*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply); this->~RetryBrokenPromiseActorState(); static_cast<RetryBrokenPromiseActor*>(this)->destroy(); return 0; }
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<RetryBrokenPromiseActor*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply);
		this->~RetryBrokenPromiseActorState();
		static_cast<RetryBrokenPromiseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLY_TYPE(Req) && reply,int loopDepth) 
	{
															#line 51 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<RetryBrokenPromiseActor*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply); this->~RetryBrokenPromiseActorState(); static_cast<RetryBrokenPromiseActor*>(this)->destroy(); return 0; }
															#line 179 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<RetryBrokenPromiseActor*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply);
		this->~RetryBrokenPromiseActorState();
		static_cast<RetryBrokenPromiseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLY_TYPE(Req) const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLY_TYPE(Req) && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state > 0) static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state = 0;
		static_cast<RetryBrokenPromiseActor*>(this)->ActorCallback< RetryBrokenPromiseActor, 0, REPLY_TYPE(Req) >::remove();

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor, 0, REPLY_TYPE(Req) >*,REPLY_TYPE(Req) const& value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor, 0, REPLY_TYPE(Req) >*,REPLY_TYPE(Req) && value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RetryBrokenPromiseActor, 0, REPLY_TYPE(Req) >*,Error err) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		CODE_PROBE(true, "retryBrokenPromise");
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		CODE_PROBE(true, "retryBrokenPromise");
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state > 0) static_cast<RetryBrokenPromiseActor*>(this)->actor_wait_state = 0;
		static_cast<RetryBrokenPromiseActor*>(this)->ActorCallback< RetryBrokenPromiseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RetryBrokenPromiseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RequestStream<Req, P> to;
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 359 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via retryBrokenPromise()
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P>
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryBrokenPromiseActor final : public Actor<REPLY_TYPE(Req)>, public ActorCallback< RetryBrokenPromiseActor<Req, P>, 0, REPLY_TYPE(Req) >, public ActorCallback< RetryBrokenPromiseActor<Req, P>, 1, Void >, public FastAllocated<RetryBrokenPromiseActor<Req, P>>, public RetryBrokenPromiseActorState<Req, P, RetryBrokenPromiseActor<Req, P>> {
															#line 366 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<RetryBrokenPromiseActor<Req, P>>::operator new;
	using FastAllocated<RetryBrokenPromiseActor<Req, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5170111032480018176UL, 11458709937205275648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Req)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RetryBrokenPromiseActor<Req, P>, 0, REPLY_TYPE(Req) >;
friend struct ActorCallback< RetryBrokenPromiseActor<Req, P>, 1, Void >;
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryBrokenPromiseActor(RequestStream<Req, P> const& to,Req const& request) 
															#line 384 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<REPLY_TYPE(Req)>(),
		   RetryBrokenPromiseActorState<Req, P, RetryBrokenPromiseActor<Req, P>>(to, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1319033180585192448UL, 2205428165340483584UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("retryBrokenPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RetryBrokenPromiseActor<Req, P>, 0, REPLY_TYPE(Req) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RetryBrokenPromiseActor<Req, P>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P>
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Req)> retryBrokenPromise( RequestStream<Req, P> const& to, Req const& request ) {
															#line 42 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<REPLY_TYPE(Req)>(new RetryBrokenPromiseActor<Req, P>(to, request));
															#line 420 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 61 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 425 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via retryBrokenPromise()
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P, class RetryBrokenPromiseActor1>
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryBrokenPromiseActor1State {
															#line 432 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryBrokenPromiseActor1State(RequestStream<Req, P> const& to,Req const& request,TaskPriority const& taskID) 
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : to(to),
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   request(request),
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   taskID(taskID)
															#line 443 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("retryBrokenPromise", reinterpret_cast<unsigned long>(this));

	}
	~RetryBrokenPromiseActor1State() 
	{
		fdb_probe_actor_destroy("retryBrokenPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 458 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RetryBrokenPromiseActor1State();
		static_cast<RetryBrokenPromiseActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 70 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<REPLY_TYPE(Req)> __when_expr_0 = to.getReply(request, taskID);
															#line 70 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 491 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RetryBrokenPromiseActor1, 0, REPLY_TYPE(Req) >*>(static_cast<RetryBrokenPromiseActor1*>(this)));
															#line 496 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() != error_code_broken_promise)
															#line 518 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 74 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 522 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 75 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 76 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delayJittered(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY, taskID);
															#line 76 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 530 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state = 2;
															#line 76 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryBrokenPromiseActor1, 1, Void >*>(static_cast<RetryBrokenPromiseActor1*>(this)));
															#line 535 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLY_TYPE(Req) const& reply,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<RetryBrokenPromiseActor1*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply); this->~RetryBrokenPromiseActor1State(); static_cast<RetryBrokenPromiseActor1*>(this)->destroy(); return 0; }
															#line 550 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<RetryBrokenPromiseActor1*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply);
		this->~RetryBrokenPromiseActor1State();
		static_cast<RetryBrokenPromiseActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLY_TYPE(Req) && reply,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<RetryBrokenPromiseActor1*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply); this->~RetryBrokenPromiseActor1State(); static_cast<RetryBrokenPromiseActor1*>(this)->destroy(); return 0; }
															#line 562 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<RetryBrokenPromiseActor1*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply);
		this->~RetryBrokenPromiseActor1State();
		static_cast<RetryBrokenPromiseActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLY_TYPE(Req) const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLY_TYPE(Req) && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state > 0) static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state = 0;
		static_cast<RetryBrokenPromiseActor1*>(this)->ActorCallback< RetryBrokenPromiseActor1, 0, REPLY_TYPE(Req) >::remove();

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor1, 0, REPLY_TYPE(Req) >*,REPLY_TYPE(Req) const& value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor1, 0, REPLY_TYPE(Req) >*,REPLY_TYPE(Req) && value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RetryBrokenPromiseActor1, 0, REPLY_TYPE(Req) >*,Error err) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		CODE_PROBE(true, "retryBrokenPromise with taskID");
															#line 649 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		CODE_PROBE(true, "retryBrokenPromise with taskID");
															#line 658 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state > 0) static_cast<RetryBrokenPromiseActor1*>(this)->actor_wait_state = 0;
		static_cast<RetryBrokenPromiseActor1*>(this)->ActorCallback< RetryBrokenPromiseActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RetryBrokenPromiseActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RetryBrokenPromiseActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RequestStream<Req, P> to;
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TaskPriority taskID;
															#line 744 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via retryBrokenPromise()
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P>
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryBrokenPromiseActor1 final : public Actor<REPLY_TYPE(Req)>, public ActorCallback< RetryBrokenPromiseActor1<Req, P>, 0, REPLY_TYPE(Req) >, public ActorCallback< RetryBrokenPromiseActor1<Req, P>, 1, Void >, public FastAllocated<RetryBrokenPromiseActor1<Req, P>>, public RetryBrokenPromiseActor1State<Req, P, RetryBrokenPromiseActor1<Req, P>> {
															#line 751 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<RetryBrokenPromiseActor1<Req, P>>::operator new;
	using FastAllocated<RetryBrokenPromiseActor1<Req, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5170111032480018176UL, 11458709937205275648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Req)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RetryBrokenPromiseActor1<Req, P>, 0, REPLY_TYPE(Req) >;
friend struct ActorCallback< RetryBrokenPromiseActor1<Req, P>, 1, Void >;
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryBrokenPromiseActor1(RequestStream<Req, P> const& to,Req const& request,TaskPriority const& taskID) 
															#line 769 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<REPLY_TYPE(Req)>(),
		   RetryBrokenPromiseActor1State<Req, P, RetryBrokenPromiseActor1<Req, P>>(to, request, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("retryBrokenPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6570520380275648512UL, 15966776091354598656UL);
		ActorExecutionContextHelper __helper(static_cast<RetryBrokenPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("retryBrokenPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("retryBrokenPromise", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RetryBrokenPromiseActor1<Req, P>, 0, REPLY_TYPE(Req) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RetryBrokenPromiseActor1<Req, P>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, bool P>
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Req)> retryBrokenPromise( RequestStream<Req, P> const& to, Req const& request, TaskPriority const& taskID ) {
															#line 62 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<REPLY_TYPE(Req)>(new RetryBrokenPromiseActor1<Req, P>(to, request, taskID));
															#line 805 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 81 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 810 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via tryInitializeRequestStream()
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, class TryInitializeRequestStreamActor>
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryInitializeRequestStreamActorState {
															#line 817 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryInitializeRequestStreamActorState(RequestStream<Req>* const& stream,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : stream(stream),
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   hostname(hostname),
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   token(token)
															#line 828 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this));

	}
	~TryInitializeRequestStreamActorState() 
	{
		fdb_probe_actor_destroy("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Optional<NetworkAddress>> __when_expr_0 = hostname.resolve();
															#line 84 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<TryInitializeRequestStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 845 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryInitializeRequestStreamActor*>(this)->actor_wait_state = 1;
															#line 84 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryInitializeRequestStreamActor, 0, Optional<NetworkAddress> >*>(static_cast<TryInitializeRequestStreamActor*>(this)));
															#line 850 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryInitializeRequestStreamActorState();
		static_cast<TryInitializeRequestStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 873 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 86 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryInitializeRequestStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryInitializeRequestStreamActorState(); static_cast<TryInitializeRequestStreamActor*>(this)->destroy(); return 0; }
															#line 877 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryInitializeRequestStreamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TryInitializeRequestStreamActorState();
			static_cast<TryInitializeRequestStreamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 88 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		ASSERT(stream != nullptr);
															#line 89 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		*stream = RequestStream<Req>(Endpoint::wellKnown({ address.get() }, token));
															#line 90 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TryInitializeRequestStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryInitializeRequestStreamActorState(); static_cast<TryInitializeRequestStreamActor*>(this)->destroy(); return 0; }
															#line 889 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TryInitializeRequestStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TryInitializeRequestStreamActorState();
		static_cast<TryInitializeRequestStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> && address,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 901 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 86 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryInitializeRequestStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryInitializeRequestStreamActorState(); static_cast<TryInitializeRequestStreamActor*>(this)->destroy(); return 0; }
															#line 905 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryInitializeRequestStreamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TryInitializeRequestStreamActorState();
			static_cast<TryInitializeRequestStreamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 88 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		ASSERT(stream != nullptr);
															#line 89 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		*stream = RequestStream<Req>(Endpoint::wellKnown({ address.get() }, token));
															#line 90 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TryInitializeRequestStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryInitializeRequestStreamActorState(); static_cast<TryInitializeRequestStreamActor*>(this)->destroy(); return 0; }
															#line 917 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TryInitializeRequestStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TryInitializeRequestStreamActorState();
		static_cast<TryInitializeRequestStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
		loopDepth = a_body1cont1(address, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> && address,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(address), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryInitializeRequestStreamActor*>(this)->actor_wait_state > 0) static_cast<TryInitializeRequestStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TryInitializeRequestStreamActor*>(this)->ActorCallback< TryInitializeRequestStreamActor, 0, Optional<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< TryInitializeRequestStreamActor, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryInitializeRequestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryInitializeRequestStreamActor, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryInitializeRequestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryInitializeRequestStreamActor, 0, Optional<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryInitializeRequestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RequestStream<Req>* stream;
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Hostname hostname;
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WellKnownEndpoints token;
															#line 1006 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via tryInitializeRequestStream()
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryInitializeRequestStreamActor final : public Actor<Void>, public ActorCallback< TryInitializeRequestStreamActor<Req>, 0, Optional<NetworkAddress> >, public FastAllocated<TryInitializeRequestStreamActor<Req>>, public TryInitializeRequestStreamActorState<Req, TryInitializeRequestStreamActor<Req>> {
															#line 1013 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<TryInitializeRequestStreamActor<Req>>::operator new;
	using FastAllocated<TryInitializeRequestStreamActor<Req>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13429019749924299776UL, 3044898582355307776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryInitializeRequestStreamActor<Req>, 0, Optional<NetworkAddress> >;
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryInitializeRequestStreamActor(RequestStream<Req>* const& stream,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 1030 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   TryInitializeRequestStreamActorState<Req, TryInitializeRequestStreamActor<Req>>(stream, hostname, token),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11987049042958738176UL, 7713147327583174656UL);
		ActorExecutionContextHelper __helper(static_cast<TryInitializeRequestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryInitializeRequestStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryInitializeRequestStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryInitializeRequestStreamActor<Req>, 0, Optional<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> tryInitializeRequestStream( RequestStream<Req>* const& stream, Hostname const& hostname, WellKnownEndpoints const& token ) {
															#line 82 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new TryInitializeRequestStreamActor<Req>(stream, hostname, token));
															#line 1065 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 92 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 1070 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via tryGetReplyFromHostname()
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, class TryGetReplyFromHostnameActor>
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryGetReplyFromHostnameActorState {
															#line 1077 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryGetReplyFromHostnameActorState(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : request(request),
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   hostname(hostname),
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   token(token)
															#line 1088 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	~TryGetReplyFromHostnameActorState() 
	{
		fdb_probe_actor_destroy("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Optional<NetworkAddress>> __when_expr_0 = hostname.resolve();
															#line 98 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1105 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor, 0, Optional<NetworkAddress> >*>(static_cast<TryGetReplyFromHostnameActor*>(this)));
															#line 1110 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetReplyFromHostnameActorState();
		static_cast<TryGetReplyFromHostnameActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
															#line 99 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 1133 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 100 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryGetReplyFromHostnameActor*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(ErrorOr<REPLY_TYPE(Req)>(lookup_failed())); this->~TryGetReplyFromHostnameActorState(); static_cast<TryGetReplyFromHostnameActor*>(this)->destroy(); return 0; }
															#line 1137 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryGetReplyFromHostnameActor*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(ErrorOr<REPLY_TYPE(Req)>(lookup_failed()));
			this->~TryGetReplyFromHostnameActorState();
			static_cast<TryGetReplyFromHostnameActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 102 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		RequestStream<Req> to(Endpoint::wellKnown({ address.get() }, token));
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to.tryGetReply(request);
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1149 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<TryGetReplyFromHostnameActor*>(this)));
															#line 1154 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> && address,int loopDepth) 
	{
															#line 99 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 1163 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 100 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryGetReplyFromHostnameActor*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(ErrorOr<REPLY_TYPE(Req)>(lookup_failed())); this->~TryGetReplyFromHostnameActorState(); static_cast<TryGetReplyFromHostnameActor*>(this)->destroy(); return 0; }
															#line 1167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryGetReplyFromHostnameActor*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(ErrorOr<REPLY_TYPE(Req)>(lookup_failed()));
			this->~TryGetReplyFromHostnameActorState();
			static_cast<TryGetReplyFromHostnameActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 102 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		RequestStream<Req> to(Endpoint::wellKnown({ address.get() }, token));
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to.tryGetReply(request);
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1179 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<TryGetReplyFromHostnameActor*>(this)));
															#line 1184 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
		loopDepth = a_body1cont1(address, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> && address,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(address), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state > 0) static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetReplyFromHostnameActor*>(this)->ActorCallback< TryGetReplyFromHostnameActor, 0, Optional<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetReplyFromHostnameActor, 0, Optional<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (reply.isError())
															#line 1268 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 105 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 106 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (reply.getError().code() == error_code_request_maybe_delivered)
															#line 1274 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 108 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				removeCachedDNS(hostname.host, hostname.service);
															#line 1278 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
		}
															#line 111 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TryGetReplyFromHostnameActor*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(reply); this->~TryGetReplyFromHostnameActorState(); static_cast<TryGetReplyFromHostnameActor*>(this)->destroy(); return 0; }
															#line 1283 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TryGetReplyFromHostnameActor*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(std::move(reply)); // state_var_RVO
		this->~TryGetReplyFromHostnameActorState();
		static_cast<TryGetReplyFromHostnameActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<REPLY_TYPE(Req)> const& __reply,int loopDepth) 
	{
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reply = __reply;
															#line 1295 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<REPLY_TYPE(Req)> && __reply,int loopDepth) 
	{
		reply = std::move(__reply);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state > 0) static_cast<TryGetReplyFromHostnameActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetReplyFromHostnameActor*>(this)->ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> const& value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> && value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Hostname hostname;
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WellKnownEndpoints token;
															#line 103 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ErrorOr<REPLY_TYPE(Req)> reply;
															#line 1378 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via tryGetReplyFromHostname()
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryGetReplyFromHostnameActor final : public Actor<ErrorOr<REPLY_TYPE(Req)>>, public ActorCallback< TryGetReplyFromHostnameActor<Req>, 0, Optional<NetworkAddress> >, public ActorCallback< TryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >, public FastAllocated<TryGetReplyFromHostnameActor<Req>>, public TryGetReplyFromHostnameActorState<Req, TryGetReplyFromHostnameActor<Req>> {
															#line 1385 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<TryGetReplyFromHostnameActor<Req>>::operator new;
	using FastAllocated<TryGetReplyFromHostnameActor<Req>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13699092582038297344UL, 5541065155591997440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ErrorOr<REPLY_TYPE(Req)>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetReplyFromHostnameActor<Req>, 0, Optional<NetworkAddress> >;
friend struct ActorCallback< TryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >;
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryGetReplyFromHostnameActor(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 1403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<ErrorOr<REPLY_TYPE(Req)>>(),
		   TryGetReplyFromHostnameActorState<Req, TryGetReplyFromHostnameActor<Req>>(request, hostname, token),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15864352401317259008UL, 17495629469512462336UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetReplyFromHostname");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetReplyFromHostnameActor<Req>, 0, Optional<NetworkAddress> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<ErrorOr<REPLY_TYPE(Req)>> tryGetReplyFromHostname( Req const& request, Hostname const& hostname, WellKnownEndpoints const& token ) {
															#line 93 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<ErrorOr<REPLY_TYPE(Req)>>(new TryGetReplyFromHostnameActor<Req>(request, hostname, token));
															#line 1439 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 113 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 1444 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via tryGetReplyFromHostname()
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, class TryGetReplyFromHostnameActor1>
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryGetReplyFromHostnameActor1State {
															#line 1451 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryGetReplyFromHostnameActor1State(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token,TaskPriority const& taskID) 
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : request(request),
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   hostname(hostname),
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   token(token),
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   taskID(taskID)
															#line 1464 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	~TryGetReplyFromHostnameActor1State() 
	{
		fdb_probe_actor_destroy("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Optional<NetworkAddress>> __when_expr_0 = hostname.resolve();
															#line 122 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1481 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor1, 0, Optional<NetworkAddress> >*>(static_cast<TryGetReplyFromHostnameActor1*>(this)));
															#line 1486 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetReplyFromHostnameActor1State();
		static_cast<TryGetReplyFromHostnameActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 1509 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 124 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(ErrorOr<REPLY_TYPE(Req)>(lookup_failed())); this->~TryGetReplyFromHostnameActor1State(); static_cast<TryGetReplyFromHostnameActor1*>(this)->destroy(); return 0; }
															#line 1513 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(ErrorOr<REPLY_TYPE(Req)>(lookup_failed()));
			this->~TryGetReplyFromHostnameActor1State();
			static_cast<TryGetReplyFromHostnameActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		RequestStream<Req> to(Endpoint::wellKnown({ address.get() }, token));
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to.tryGetReply(request, taskID);
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1525 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<TryGetReplyFromHostnameActor1*>(this)));
															#line 1530 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<NetworkAddress> && address,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!address.present())
															#line 1539 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 124 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(ErrorOr<REPLY_TYPE(Req)>(lookup_failed())); this->~TryGetReplyFromHostnameActor1State(); static_cast<TryGetReplyFromHostnameActor1*>(this)->destroy(); return 0; }
															#line 1543 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(ErrorOr<REPLY_TYPE(Req)>(lookup_failed()));
			this->~TryGetReplyFromHostnameActor1State();
			static_cast<TryGetReplyFromHostnameActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 126 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		RequestStream<Req> to(Endpoint::wellKnown({ address.get() }, token));
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to.tryGetReply(request, taskID);
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1555 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<TryGetReplyFromHostnameActor1*>(this)));
															#line 1560 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> const& address,int loopDepth) 
	{
		loopDepth = a_body1cont1(address, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<NetworkAddress> && address,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(address), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state > 0) static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 0;
		static_cast<TryGetReplyFromHostnameActor1*>(this)->ActorCallback< TryGetReplyFromHostnameActor1, 0, Optional<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor1, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor1, 0, Optional<NetworkAddress> >*,Optional<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetReplyFromHostnameActor1, 0, Optional<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 128 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (reply.isError())
															#line 1644 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 129 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 130 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (reply.getError().code() == error_code_request_maybe_delivered)
															#line 1650 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 132 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				removeCachedDNS(hostname.host, hostname.service);
															#line 1654 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
		}
															#line 135 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV<ErrorOr<REPLY_TYPE(Req)>>::futures) { (void)(reply); this->~TryGetReplyFromHostnameActor1State(); static_cast<TryGetReplyFromHostnameActor1*>(this)->destroy(); return 0; }
															#line 1659 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TryGetReplyFromHostnameActor1*>(this)->SAV< ErrorOr<REPLY_TYPE(Req)> >::value()) ErrorOr<REPLY_TYPE(Req)>(std::move(reply)); // state_var_RVO
		this->~TryGetReplyFromHostnameActor1State();
		static_cast<TryGetReplyFromHostnameActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<REPLY_TYPE(Req)> const& __reply,int loopDepth) 
	{
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reply = __reply;
															#line 1671 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<REPLY_TYPE(Req)> && __reply,int loopDepth) 
	{
		reply = std::move(__reply);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state > 0) static_cast<TryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 0;
		static_cast<TryGetReplyFromHostnameActor1*>(this)->ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> const& value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> && value) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Hostname hostname;
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WellKnownEndpoints token;
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TaskPriority taskID;
															#line 127 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ErrorOr<REPLY_TYPE(Req)> reply;
															#line 1756 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via tryGetReplyFromHostname()
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TryGetReplyFromHostnameActor1 final : public Actor<ErrorOr<REPLY_TYPE(Req)>>, public ActorCallback< TryGetReplyFromHostnameActor1<Req>, 0, Optional<NetworkAddress> >, public ActorCallback< TryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >, public FastAllocated<TryGetReplyFromHostnameActor1<Req>>, public TryGetReplyFromHostnameActor1State<Req, TryGetReplyFromHostnameActor1<Req>> {
															#line 1763 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<TryGetReplyFromHostnameActor1<Req>>::operator new;
	using FastAllocated<TryGetReplyFromHostnameActor1<Req>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13699092582038297344UL, 5541065155591997440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ErrorOr<REPLY_TYPE(Req)>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetReplyFromHostnameActor1<Req>, 0, Optional<NetworkAddress> >;
friend struct ActorCallback< TryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >;
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TryGetReplyFromHostnameActor1(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token,TaskPriority const& taskID) 
															#line 1781 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<ErrorOr<REPLY_TYPE(Req)>>(),
		   TryGetReplyFromHostnameActor1State<Req, TryGetReplyFromHostnameActor1<Req>>(request, hostname, token, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7327004164435705600UL, 9362516771815281408UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetReplyFromHostname");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetReplyFromHostnameActor1<Req>, 0, Optional<NetworkAddress> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<ErrorOr<REPLY_TYPE(Req)>> tryGetReplyFromHostname( Req const& request, Hostname const& hostname, WellKnownEndpoints const& token, TaskPriority const& taskID ) {
															#line 114 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<ErrorOr<REPLY_TYPE(Req)>>(new TryGetReplyFromHostnameActor1<Req>(request, hostname, token, taskID));
															#line 1817 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 137 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 1822 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via retryGetReplyFromHostname()
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, class RetryGetReplyFromHostnameActor>
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryGetReplyFromHostnameActorState {
															#line 1829 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryGetReplyFromHostnameActorState(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : request(request),
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   hostname(hostname),
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   token(token),
															#line 143 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   reconnectInterval(FLOW_KNOBS->HOSTNAME_RECONNECT_INIT_INTERVAL),
															#line 144 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   to()
															#line 1844 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	~RetryGetReplyFromHostnameActorState() 
	{
		fdb_probe_actor_destroy("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 1859 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RetryGetReplyFromHostnameActorState();
		static_cast<RetryGetReplyFromHostnameActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<NetworkAddress> __when_expr_0 = hostname.resolveWithRetry();
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1891 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor, 0, NetworkAddress >*>(static_cast<RetryGetReplyFromHostnameActor*>(this)));
															#line 1896 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkAddress const& address,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (to == nullptr || to->getEndpoint().getPrimaryAddress() != address)
															#line 1905 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 148 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			to = std::make_unique<RequestStream<Req>>(Endpoint::wellKnown({ address }, token));
															#line 1909 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to->tryGetReply(request);
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1915 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 2;
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<RetryGetReplyFromHostnameActor*>(this)));
															#line 1920 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkAddress && address,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (to == nullptr || to->getEndpoint().getPrimaryAddress() != address)
															#line 1929 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 148 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			to = std::make_unique<RequestStream<Req>>(Endpoint::wellKnown({ address }, token));
															#line 1933 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to->tryGetReply(request);
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1939 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 2;
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<RetryGetReplyFromHostnameActor*>(this)));
															#line 1944 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkAddress const& address,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(address, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkAddress && address,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(address), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor*>(this)->ActorCallback< RetryGetReplyFromHostnameActor, 0, NetworkAddress >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 0, NetworkAddress >*,NetworkAddress const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 0, NetworkAddress >*,NetworkAddress && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor, 0, NetworkAddress >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 151 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (reply.isError())
															#line 2028 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 152 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 153 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (reply.getError().code() == error_code_request_maybe_delivered)
															#line 2034 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 155 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_2 = delay(reconnectInterval);
															#line 155 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2040 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 3;
															#line 155 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor, 2, Void >*>(static_cast<RetryGetReplyFromHostnameActor*>(this)));
															#line 2045 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 159 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(reply.getError(), std::max(0, loopDepth - 1));
															#line 2052 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
		}
		else
		{
															#line 162 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<RetryGetReplyFromHostnameActor*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply.get()); this->~RetryGetReplyFromHostnameActorState(); static_cast<RetryGetReplyFromHostnameActor*>(this)->destroy(); return 0; }
															#line 2059 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<RetryGetReplyFromHostnameActor*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply.get());
			this->~RetryGetReplyFromHostnameActorState();
			static_cast<RetryGetReplyFromHostnameActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<REPLY_TYPE(Req)> const& __reply,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reply = __reply;
															#line 2072 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<REPLY_TYPE(Req)> && __reply,int loopDepth) 
	{
		reply = std::move(__reply);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor*>(this)->ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor, 1, ErrorOr<REPLY_TYPE(Req)> >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reconnectInterval = std::min(2 * reconnectInterval, FLOW_KNOBS->HOSTNAME_RECONNECT_MAX_INTERVAL);
															#line 157 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		removeCachedDNS(hostname.host, hostname.service);
															#line 2165 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reconnectInterval = std::min(2 * reconnectInterval, FLOW_KNOBS->HOSTNAME_RECONNECT_MAX_INTERVAL);
															#line 157 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		removeCachedDNS(hostname.host, hostname.service);
															#line 2176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor*>(this)->ActorCallback< RetryGetReplyFromHostnameActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Hostname hostname;
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WellKnownEndpoints token;
															#line 143 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	double reconnectInterval;
															#line 144 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::unique_ptr<RequestStream<Req>> to;
															#line 150 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ErrorOr<REPLY_TYPE(Req)> reply;
															#line 2268 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via retryGetReplyFromHostname()
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryGetReplyFromHostnameActor final : public Actor<REPLY_TYPE(Req)>, public ActorCallback< RetryGetReplyFromHostnameActor<Req>, 0, NetworkAddress >, public ActorCallback< RetryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >, public ActorCallback< RetryGetReplyFromHostnameActor<Req>, 2, Void >, public FastAllocated<RetryGetReplyFromHostnameActor<Req>>, public RetryGetReplyFromHostnameActorState<Req, RetryGetReplyFromHostnameActor<Req>> {
															#line 2275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<RetryGetReplyFromHostnameActor<Req>>::operator new;
	using FastAllocated<RetryGetReplyFromHostnameActor<Req>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9552946820221116672UL, 10314908923238201088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Req)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RetryGetReplyFromHostnameActor<Req>, 0, NetworkAddress >;
friend struct ActorCallback< RetryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >;
friend struct ActorCallback< RetryGetReplyFromHostnameActor<Req>, 2, Void >;
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryGetReplyFromHostnameActor(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token) 
															#line 2294 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<REPLY_TYPE(Req)>(),
		   RetryGetReplyFromHostnameActorState<Req, RetryGetReplyFromHostnameActor<Req>>(request, hostname, token),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8105731838203262464UL, 6747209311745633280UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("retryGetReplyFromHostname");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor<Req>, 0, NetworkAddress >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor<Req>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Req)> retryGetReplyFromHostname( Req const& request, Hostname const& hostname, WellKnownEndpoints const& token ) {
															#line 138 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<REPLY_TYPE(Req)>(new RetryGetReplyFromHostnameActor<Req>(request, hostname, token));
															#line 2331 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 166 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 2336 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via retryGetReplyFromHostname()
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req, class RetryGetReplyFromHostnameActor1>
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryGetReplyFromHostnameActor1State {
															#line 2343 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryGetReplyFromHostnameActor1State(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token,TaskPriority const& taskID) 
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : request(request),
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   hostname(hostname),
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   token(token),
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   taskID(taskID),
															#line 175 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   reconnectInitInterval(FLOW_KNOBS->HOSTNAME_RECONNECT_INIT_INTERVAL),
															#line 176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   to()
															#line 2360 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	~RetryGetReplyFromHostnameActor1State() 
	{
		fdb_probe_actor_destroy("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 2375 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RetryGetReplyFromHostnameActor1State();
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<NetworkAddress> __when_expr_0 = hostname.resolveWithRetry();
															#line 178 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2407 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor1, 0, NetworkAddress >*>(static_cast<RetryGetReplyFromHostnameActor1*>(this)));
															#line 2412 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkAddress const& address,int loopDepth) 
	{
															#line 179 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (to == nullptr || to->getEndpoint().getPrimaryAddress() != address)
															#line 2421 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 180 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			to = std::make_unique<RequestStream<Req>>(Endpoint::wellKnown({ address }, token));
															#line 2425 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to->tryGetReply(request, taskID);
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2431 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<RetryGetReplyFromHostnameActor1*>(this)));
															#line 2436 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkAddress && address,int loopDepth) 
	{
															#line 179 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (to == nullptr || to->getEndpoint().getPrimaryAddress() != address)
															#line 2445 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 180 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			to = std::make_unique<RequestStream<Req>>(Endpoint::wellKnown({ address }, token));
															#line 2449 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Req)>> __when_expr_1 = to->tryGetReply(request, taskID);
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2455 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*>(static_cast<RetryGetReplyFromHostnameActor1*>(this)));
															#line 2460 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkAddress const& address,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(address, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkAddress && address,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(address), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->ActorCallback< RetryGetReplyFromHostnameActor1, 0, NetworkAddress >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 0, NetworkAddress >*,NetworkAddress const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 0, NetworkAddress >*,NetworkAddress && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor1, 0, NetworkAddress >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 183 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (reply.isError())
															#line 2544 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 184 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			resetReply(request);
															#line 185 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (reply.getError().code() == error_code_request_maybe_delivered)
															#line 2550 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 187 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_2 = delay(reconnectInitInterval);
															#line 187 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2556 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 3;
															#line 187 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RetryGetReplyFromHostnameActor1, 2, Void >*>(static_cast<RetryGetReplyFromHostnameActor1*>(this)));
															#line 2561 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 192 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(reply.getError(), std::max(0, loopDepth - 1));
															#line 2568 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
		}
		else
		{
															#line 195 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!static_cast<RetryGetReplyFromHostnameActor1*>(this)->SAV<REPLY_TYPE(Req)>::futures) { (void)(reply.get()); this->~RetryGetReplyFromHostnameActor1State(); static_cast<RetryGetReplyFromHostnameActor1*>(this)->destroy(); return 0; }
															#line 2575 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			new (&static_cast<RetryGetReplyFromHostnameActor1*>(this)->SAV< REPLY_TYPE(Req) >::value()) REPLY_TYPE(Req)(reply.get());
			this->~RetryGetReplyFromHostnameActor1State();
			static_cast<RetryGetReplyFromHostnameActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<REPLY_TYPE(Req)> const& __reply,int loopDepth) 
	{
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reply = __reply;
															#line 2588 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(ErrorOr<REPLY_TYPE(Req)> && __reply,int loopDepth) 
	{
		reply = std::move(__reply);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,ErrorOr<REPLY_TYPE(Req)> && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor1, 1, ErrorOr<REPLY_TYPE(Req)> >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reconnectInitInterval = std::min(2 * reconnectInitInterval, FLOW_KNOBS->HOSTNAME_RECONNECT_MAX_INTERVAL);
															#line 190 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		removeCachedDNS(hostname.host, hostname.service);
															#line 2681 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		reconnectInitInterval = std::min(2 * reconnectInitInterval, FLOW_KNOBS->HOSTNAME_RECONNECT_MAX_INTERVAL);
															#line 190 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		removeCachedDNS(hostname.host, hostname.service);
															#line 2692 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state > 0) static_cast<RetryGetReplyFromHostnameActor1*>(this)->actor_wait_state = 0;
		static_cast<RetryGetReplyFromHostnameActor1*>(this)->ActorCallback< RetryGetReplyFromHostnameActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RetryGetReplyFromHostnameActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RetryGetReplyFromHostnameActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Req request;
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Hostname hostname;
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WellKnownEndpoints token;
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TaskPriority taskID;
															#line 175 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	double reconnectInitInterval;
															#line 176 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::unique_ptr<RequestStream<Req>> to;
															#line 182 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ErrorOr<REPLY_TYPE(Req)> reply;
															#line 2786 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via retryGetReplyFromHostname()
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class RetryGetReplyFromHostnameActor1 final : public Actor<REPLY_TYPE(Req)>, public ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 0, NetworkAddress >, public ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >, public ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 2, Void >, public FastAllocated<RetryGetReplyFromHostnameActor1<Req>>, public RetryGetReplyFromHostnameActor1State<Req, RetryGetReplyFromHostnameActor1<Req>> {
															#line 2793 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<RetryGetReplyFromHostnameActor1<Req>>::operator new;
	using FastAllocated<RetryGetReplyFromHostnameActor1<Req>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9552946820221116672UL, 10314908923238201088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Req)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 0, NetworkAddress >;
friend struct ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >;
friend struct ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 2, Void >;
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	RetryGetReplyFromHostnameActor1(Req const& request,Hostname const& hostname,WellKnownEndpoints const& token,TaskPriority const& taskID) 
															#line 2812 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<REPLY_TYPE(Req)>(),
		   RetryGetReplyFromHostnameActor1State<Req, RetryGetReplyFromHostnameActor1<Req>>(request, hostname, token, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17472137469036657408UL, 14566631732372783360UL);
		ActorExecutionContextHelper __helper(static_cast<RetryGetReplyFromHostnameActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("retryGetReplyFromHostname");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("retryGetReplyFromHostname", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 0, NetworkAddress >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 1, ErrorOr<REPLY_TYPE(Req)> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RetryGetReplyFromHostnameActor1<Req>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class Req>
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Req)> retryGetReplyFromHostname( Req const& request, Hostname const& hostname, WellKnownEndpoints const& token, TaskPriority const& taskID ) {
															#line 167 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<REPLY_TYPE(Req)>(new RetryGetReplyFromHostnameActor1<Req>(request, hostname, token, taskID));
															#line 2849 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 199 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 2854 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via timeoutWarning()
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class TimeoutWarningActor>
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TimeoutWarningActorState {
															#line 2861 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TimeoutWarningActorState(Future<T> const& what,double const& time,PromiseStream<Void> const& output) 
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : what(what),
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   time(time),
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output),
															#line 202 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   end(delay(time))
															#line 2874 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("timeoutWarning", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutWarningActorState() 
	{
		fdb_probe_actor_destroy("timeoutWarning", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 2889 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutWarningActorState();
		static_cast<TimeoutWarningActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<T> __when_expr_0 = what;
															#line 203 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<TimeoutWarningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2921 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 207 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = end;
															#line 2925 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TimeoutWarningActor*>(this)->actor_wait_state = 1;
															#line 204 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutWarningActor, 0, T >*>(static_cast<TimeoutWarningActor*>(this)));
															#line 207 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutWarningActor, 1, Void >*>(static_cast<TimeoutWarningActor*>(this)));
															#line 2932 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& t,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TimeoutWarningActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutWarningActorState(); static_cast<TimeoutWarningActor*>(this)->destroy(); return 0; }
															#line 2947 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TimeoutWarningActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutWarningActorState();
		static_cast<TimeoutWarningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(T && t,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<TimeoutWarningActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutWarningActorState(); static_cast<TimeoutWarningActor*>(this)->destroy(); return 0; }
															#line 2959 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<TimeoutWarningActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutWarningActorState();
		static_cast<TimeoutWarningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(Void());
															#line 209 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		end = delay(time);
															#line 2973 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(Void());
															#line 209 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		end = delay(time);
															#line 2984 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutWarningActor*>(this)->actor_wait_state > 0) static_cast<TimeoutWarningActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutWarningActor*>(this)->ActorCallback< TimeoutWarningActor, 0, T >::remove();
		static_cast<TimeoutWarningActor*>(this)->ActorCallback< TimeoutWarningActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutWarningActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutWarningActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutWarningActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutWarningActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutWarningActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutWarningActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> what;
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	double time;
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	PromiseStream<Void> output;
															#line 202 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<Void> end;
															#line 3118 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via timeoutWarning()
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class TimeoutWarningActor final : public Actor<T>, public ActorCallback< TimeoutWarningActor<T>, 0, T >, public ActorCallback< TimeoutWarningActor<T>, 1, Void >, public FastAllocated<TimeoutWarningActor<T>>, public TimeoutWarningActorState<T, TimeoutWarningActor<T>> {
															#line 3125 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<TimeoutWarningActor<T>>::operator new;
	using FastAllocated<TimeoutWarningActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7178174406351857152UL, 13134278980538903040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutWarningActor<T>, 0, T >;
friend struct ActorCallback< TimeoutWarningActor<T>, 1, Void >;
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	TimeoutWarningActor(Future<T> const& what,double const& time,PromiseStream<Void> const& output) 
															#line 3143 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<T>(),
		   TimeoutWarningActorState<T, TimeoutWarningActor<T>>(what, time, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeoutWarning", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15138501800934750976UL, 17855053322769819392UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeoutWarning");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeoutWarning", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutWarningActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<T> timeoutWarning( Future<T> const& what, double const& time, PromiseStream<Void> const& output ) {
															#line 200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<T>(new TimeoutWarningActor<T>(what, time, output));
															#line 3178 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 213 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 3183 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via forwardPromise()
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class ForwardPromiseActor>
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActorState {
															#line 3190 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActorState(Promise<T> const& output,Future<T> const& input) 
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : output(output),
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   input(input)
															#line 3199 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	~ForwardPromiseActorState() 
	{
		fdb_probe_actor_destroy("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 217 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 217 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3217 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				static_cast<ForwardPromiseActor*>(this)->actor_wait_state = 1;
															#line 217 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardPromiseActor, 0, T >*>(static_cast<ForwardPromiseActor*>(this)));
															#line 3221 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardPromiseActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output.sendError(err);
															#line 3256 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 218 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3271 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 218 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardPromiseActor*>(this)->actor_wait_state > 0) static_cast<ForwardPromiseActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardPromiseActor*>(this)->ActorCallback< ForwardPromiseActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardPromiseActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		delete static_cast<ForwardPromiseActor*>(this);
															#line 3377 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		return 0;

		return loopDepth;
	}
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Promise<T> output;
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 3386 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via forwardPromise()
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActor final : public Actor<void>, public ActorCallback< ForwardPromiseActor<T>, 0, T >, public FastAllocated<ForwardPromiseActor<T>>, public ForwardPromiseActorState<T, ForwardPromiseActor<T>> {
															#line 3393 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<ForwardPromiseActor<T>>::operator new;
	using FastAllocated<ForwardPromiseActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18403622271463428096UL, 17749308575979476224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardPromiseActor<T>, 0, T >;
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActor(Promise<T> const& output,Future<T> const& input) 
															#line 3410 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<void>(),
		   ForwardPromiseActorState<T, ForwardPromiseActor<T>>(output, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7843831184336454144UL, 11100125588628783360UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
void forwardPromise( Promise<T> const& output, Future<T> const& input ) {
															#line 214 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	new ForwardPromiseActor<T>(output, input);
															#line 3436 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 223 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 3441 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via forwardPromise()
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class ForwardPromiseActor1>
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActor1State {
															#line 3448 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActor1State(ReplyPromise<T> const& output,Future<T> const& input) 
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : output(output),
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   input(input)
															#line 3457 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	~ForwardPromiseActor1State() 
	{
		fdb_probe_actor_destroy("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 227 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 227 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3475 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				static_cast<ForwardPromiseActor1*>(this)->actor_wait_state = 1;
															#line 227 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardPromiseActor1, 0, T >*>(static_cast<ForwardPromiseActor1*>(this)));
															#line 3479 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardPromiseActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output.sendError(err);
															#line 3514 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3529 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3538 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardPromiseActor1*>(this)->actor_wait_state > 0) static_cast<ForwardPromiseActor1*>(this)->actor_wait_state = 0;
		static_cast<ForwardPromiseActor1*>(this)->ActorCallback< ForwardPromiseActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardPromiseActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		delete static_cast<ForwardPromiseActor1*>(this);
															#line 3635 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		return 0;

		return loopDepth;
	}
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReplyPromise<T> output;
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 3644 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via forwardPromise()
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActor1 final : public Actor<void>, public ActorCallback< ForwardPromiseActor1<T>, 0, T >, public FastAllocated<ForwardPromiseActor1<T>>, public ForwardPromiseActor1State<T, ForwardPromiseActor1<T>> {
															#line 3651 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<ForwardPromiseActor1<T>>::operator new;
	using FastAllocated<ForwardPromiseActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18403622271463428096UL, 17749308575979476224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardPromiseActor1<T>, 0, T >;
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActor1(ReplyPromise<T> const& output,Future<T> const& input) 
															#line 3668 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<void>(),
		   ForwardPromiseActor1State<T, ForwardPromiseActor1<T>>(output, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2116168105338813184UL, 9531603158096391936UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
void forwardPromise( ReplyPromise<T> const& output, Future<T> const& input ) {
															#line 224 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	new ForwardPromiseActor1<T>(output, input);
															#line 3694 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 233 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 3699 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via forwardPromise()
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class ForwardPromiseActor2>
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActor2State {
															#line 3706 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActor2State(PromiseStream<T> const& output,Future<T> const& input) 
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : output(output),
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   input(input)
															#line 3715 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	~ForwardPromiseActor2State() 
	{
		fdb_probe_actor_destroy("forwardPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 237 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 237 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3733 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				static_cast<ForwardPromiseActor2*>(this)->actor_wait_state = 1;
															#line 237 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardPromiseActor2, 0, T >*>(static_cast<ForwardPromiseActor2*>(this)));
															#line 3737 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardPromiseActor2*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 240 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output.sendError(e);
															#line 3772 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3787 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output.send(value);
															#line 3796 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardPromiseActor2*>(this)->actor_wait_state > 0) static_cast<ForwardPromiseActor2*>(this)->actor_wait_state = 0;
		static_cast<ForwardPromiseActor2*>(this)->ActorCallback< ForwardPromiseActor2, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor2, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardPromiseActor2, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardPromiseActor2, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		delete static_cast<ForwardPromiseActor2*>(this);
															#line 3893 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		return 0;

		return loopDepth;
	}
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	PromiseStream<T> output;
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 3902 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via forwardPromise()
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ForwardPromiseActor2 final : public Actor<void>, public ActorCallback< ForwardPromiseActor2<T>, 0, T >, public FastAllocated<ForwardPromiseActor2<T>>, public ForwardPromiseActor2State<T, ForwardPromiseActor2<T>> {
															#line 3909 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<ForwardPromiseActor2<T>>::operator new;
	using FastAllocated<ForwardPromiseActor2<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18403622271463428096UL, 17749308575979476224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardPromiseActor2<T>, 0, T >;
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ForwardPromiseActor2(PromiseStream<T> const& output,Future<T> const& input) 
															#line 3926 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<void>(),
		   ForwardPromiseActor2State<T, ForwardPromiseActor2<T>>(output, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2946058180034076160UL, 9151250485096794880UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardPromiseActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardPromise", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
void forwardPromise( PromiseStream<T> const& output, Future<T> const& input ) {
															#line 234 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	new ForwardPromiseActor2<T>(output, input);
															#line 3952 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 243 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 3957 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via broadcast()
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class BroadcastActor>
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class BroadcastActorState {
															#line 3964 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	BroadcastActorState(Future<T> const& input,std::vector<Promise<T>> const& output) 
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : input(input),
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output)
															#line 3973 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("broadcast", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastActorState() 
	{
		fdb_probe_actor_destroy("broadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 246 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = input;
															#line 246 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<BroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3990 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastActor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastActor, 0, T >*>(static_cast<BroadcastActor*>(this)));
															#line 3995 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastActorState();
		static_cast<BroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& value,int loopDepth) 
	{
															#line 247 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		for(int i = 0;i < output.size();i++) {
															#line 248 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output[i].send(value);
															#line 4020 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 249 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<BroadcastActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastActorState(); static_cast<BroadcastActor*>(this)->destroy(); return 0; }
															#line 4024 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<BroadcastActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastActorState();
		static_cast<BroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && value,int loopDepth) 
	{
															#line 247 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		for(int i = 0;i < output.size();i++) {
															#line 248 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output[i].send(value);
															#line 4038 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 249 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<BroadcastActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastActorState(); static_cast<BroadcastActor*>(this)->destroy(); return 0; }
															#line 4042 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<BroadcastActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastActorState();
		static_cast<BroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastActor*>(this)->actor_wait_state > 0) static_cast<BroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastActor*>(this)->ActorCallback< BroadcastActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::vector<Promise<T>> output;
															#line 4129 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via broadcast()
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class BroadcastActor final : public Actor<Void>, public ActorCallback< BroadcastActor<T>, 0, T >, public FastAllocated<BroadcastActor<T>>, public BroadcastActorState<T, BroadcastActor<T>> {
															#line 4136 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<BroadcastActor<T>>::operator new;
	using FastAllocated<BroadcastActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15949685253354930432UL, 15510410618396854784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastActor<T>, 0, T >;
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	BroadcastActor(Future<T> const& input,std::vector<Promise<T>> const& output) 
															#line 4153 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   BroadcastActorState<T, BroadcastActor<T>>(input, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10055547700014470400UL, 5083019977608030976UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> broadcast( Future<T> const& input, std::vector<Promise<T>> const& output ) {
															#line 244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new BroadcastActor<T>(input, output));
															#line 4188 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 251 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 4193 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via broadcast()
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class BroadcastActor1>
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class BroadcastActor1State {
															#line 4200 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	BroadcastActor1State(Future<T> const& input,std::vector<ReplyPromise<T>> const& output) 
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : input(input),
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output)
															#line 4209 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("broadcast", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastActor1State() 
	{
		fdb_probe_actor_destroy("broadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = input;
															#line 254 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<BroadcastActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4226 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastActor1*>(this)->actor_wait_state = 1;
															#line 254 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastActor1, 0, T >*>(static_cast<BroadcastActor1*>(this)));
															#line 4231 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastActor1State();
		static_cast<BroadcastActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& value,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		for(int i = 0;i < output.size();i++) {
															#line 256 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output[i].send(value);
															#line 4256 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 257 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<BroadcastActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastActor1State(); static_cast<BroadcastActor1*>(this)->destroy(); return 0; }
															#line 4260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<BroadcastActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastActor1State();
		static_cast<BroadcastActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && value,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		for(int i = 0;i < output.size();i++) {
															#line 256 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			output[i].send(value);
															#line 4274 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
															#line 257 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<BroadcastActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastActor1State(); static_cast<BroadcastActor1*>(this)->destroy(); return 0; }
															#line 4278 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<BroadcastActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastActor1State();
		static_cast<BroadcastActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastActor1*>(this)->actor_wait_state > 0) static_cast<BroadcastActor1*>(this)->actor_wait_state = 0;
		static_cast<BroadcastActor1*>(this)->ActorCallback< BroadcastActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::vector<ReplyPromise<T>> output;
															#line 4365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via broadcast()
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class BroadcastActor1 final : public Actor<Void>, public ActorCallback< BroadcastActor1<T>, 0, T >, public FastAllocated<BroadcastActor1<T>>, public BroadcastActor1State<T, BroadcastActor1<T>> {
															#line 4372 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<BroadcastActor1<T>>::operator new;
	using FastAllocated<BroadcastActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15949685253354930432UL, 15510410618396854784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastActor1<T>, 0, T >;
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	BroadcastActor1(Future<T> const& input,std::vector<ReplyPromise<T>> const& output) 
															#line 4389 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   BroadcastActor1State<T, BroadcastActor1<T>>(input, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6044184165491527168UL, 6125521375055677184UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastActor1<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> broadcast( Future<T> const& input, std::vector<ReplyPromise<T>> const& output ) {
															#line 252 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new BroadcastActor1<T>(input, output));
															#line 4424 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 259 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 4429 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via incrementalBroadcast()
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class IncrementalBroadcastActor>
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastActorState {
															#line 4436 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastActorState(Future<T> const& input,std::vector<Promise<T>> const& output,int const& batchSize) 
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : input(input),
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output),
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   batchSize(batchSize)
															#line 4447 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("incrementalBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalBroadcastActorState() 
	{
		fdb_probe_actor_destroy("incrementalBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 262 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = input;
															#line 262 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4464 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state = 1;
															#line 262 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastActor, 0, T >*>(static_cast<IncrementalBroadcastActor*>(this)));
															#line 4469 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementalBroadcastActorState();
		static_cast<IncrementalBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 263 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i = 0;
															#line 264 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		;
															#line 4494 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& __value,int loopDepth) 
	{
															#line 262 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		value = __value;
															#line 4503 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastActor*>(this)->ActorCallback< IncrementalBroadcastActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 270 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<IncrementalBroadcastActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementalBroadcastActorState(); static_cast<IncrementalBroadcastActor*>(this)->destroy(); return 0; }
															#line 4582 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<IncrementalBroadcastActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementalBroadcastActorState();
		static_cast<IncrementalBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 264 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!(i < output.size()))
															#line 4601 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 265 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output[i].send(value);
															#line 266 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if ((i + 1) % batchSize == 0)
															#line 4609 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 267 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(0);
															#line 267 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4615 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state = 2;
															#line 267 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastActor, 1, Void >*>(static_cast<IncrementalBroadcastActor*>(this)));
															#line 4620 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 264 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i++;
															#line 4647 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastActor*>(this)->ActorCallback< IncrementalBroadcastActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::vector<Promise<T>> output;
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int batchSize;
															#line 262 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	T value;
															#line 263 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int i;
															#line 4749 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via incrementalBroadcast()
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastActor final : public Actor<Void>, public ActorCallback< IncrementalBroadcastActor<T>, 0, T >, public ActorCallback< IncrementalBroadcastActor<T>, 1, Void >, public FastAllocated<IncrementalBroadcastActor<T>>, public IncrementalBroadcastActorState<T, IncrementalBroadcastActor<T>> {
															#line 4756 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<IncrementalBroadcastActor<T>>::operator new;
	using FastAllocated<IncrementalBroadcastActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(318279151902932224UL, 9034152405460466432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalBroadcastActor<T>, 0, T >;
friend struct ActorCallback< IncrementalBroadcastActor<T>, 1, Void >;
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastActor(Future<T> const& input,std::vector<Promise<T>> const& output,int const& batchSize) 
															#line 4774 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   IncrementalBroadcastActorState<T, IncrementalBroadcastActor<T>>(input, output, batchSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4812002838856963328UL, 13434094745575330304UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementalBroadcastActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementalBroadcastActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> incrementalBroadcast( Future<T> const& input, std::vector<Promise<T>> const& output, int const& batchSize ) {
															#line 260 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new IncrementalBroadcastActor<T>(input, output, batchSize));
															#line 4810 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 272 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 4815 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via incrementalBroadcast()
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class IncrementalBroadcastActor1>
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastActor1State {
															#line 4822 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastActor1State(Future<T> const& input,std::vector<ReplyPromise<T>> const& output,int const& batchSize) 
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : input(input),
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output),
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   batchSize(batchSize)
															#line 4833 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("incrementalBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalBroadcastActor1State() 
	{
		fdb_probe_actor_destroy("incrementalBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = input;
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4850 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state = 1;
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastActor1, 0, T >*>(static_cast<IncrementalBroadcastActor1*>(this)));
															#line 4855 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementalBroadcastActor1State();
		static_cast<IncrementalBroadcastActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 276 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i = 0;
															#line 277 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		;
															#line 4880 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& __value,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		value = __value;
															#line 4889 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastActor1*>(this)->ActorCallback< IncrementalBroadcastActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 283 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<IncrementalBroadcastActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementalBroadcastActor1State(); static_cast<IncrementalBroadcastActor1*>(this)->destroy(); return 0; }
															#line 4968 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<IncrementalBroadcastActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementalBroadcastActor1State();
		static_cast<IncrementalBroadcastActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 277 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!(i < output.size()))
															#line 4987 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 278 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output[i].send(value);
															#line 279 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if ((i + 1) % batchSize == 0)
															#line 4995 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(0);
															#line 280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5001 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state = 2;
															#line 280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastActor1, 1, Void >*>(static_cast<IncrementalBroadcastActor1*>(this)));
															#line 5006 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 277 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i++;
															#line 5033 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastActor1*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastActor1*>(this)->ActorCallback< IncrementalBroadcastActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::vector<ReplyPromise<T>> output;
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int batchSize;
															#line 275 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	T value;
															#line 276 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int i;
															#line 5135 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via incrementalBroadcast()
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastActor1 final : public Actor<Void>, public ActorCallback< IncrementalBroadcastActor1<T>, 0, T >, public ActorCallback< IncrementalBroadcastActor1<T>, 1, Void >, public FastAllocated<IncrementalBroadcastActor1<T>>, public IncrementalBroadcastActor1State<T, IncrementalBroadcastActor1<T>> {
															#line 5142 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<IncrementalBroadcastActor1<T>>::operator new;
	using FastAllocated<IncrementalBroadcastActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(318279151902932224UL, 9034152405460466432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalBroadcastActor1<T>, 0, T >;
friend struct ActorCallback< IncrementalBroadcastActor1<T>, 1, Void >;
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastActor1(Future<T> const& input,std::vector<ReplyPromise<T>> const& output,int const& batchSize) 
															#line 5160 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   IncrementalBroadcastActor1State<T, IncrementalBroadcastActor1<T>>(input, output, batchSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementalBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4281544153242063104UL, 8050982773658596352UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementalBroadcastActor1<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementalBroadcastActor1<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> incrementalBroadcast( Future<T> const& input, std::vector<ReplyPromise<T>> const& output, int const& batchSize ) {
															#line 273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new IncrementalBroadcastActor1<T>(input, output, batchSize));
															#line 5196 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 285 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 5201 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via incrementalBroadcastWithError()
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class IncrementalBroadcastWithErrorActor>
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastWithErrorActorState {
															#line 5208 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastWithErrorActorState(Future<T> const& input,std::vector<Promise<T>> const& output,int const& batchSize) 
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : input(input),
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   output(output),
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   batchSize(batchSize),
															#line 288 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   i(0)
															#line 5221 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalBroadcastWithErrorActorState() 
	{
		fdb_probe_actor_destroy("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5239 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 1;
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastWithErrorActor, 0, T >*>(static_cast<IncrementalBroadcastWithErrorActor*>(this)));
															#line 5244 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementalBroadcastWithErrorActorState();
		static_cast<IncrementalBroadcastWithErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 309 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<IncrementalBroadcastWithErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementalBroadcastWithErrorActorState(); static_cast<IncrementalBroadcastWithErrorActor*>(this)->destroy(); return 0; }
															#line 5273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<IncrementalBroadcastWithErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementalBroadcastWithErrorActorState();
		static_cast<IncrementalBroadcastWithErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& _e,int loopDepth=0) 
	{
		try {
															#line 298 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (_e.code() == error_code_operation_cancelled)
															#line 5286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 299 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(_e, loopDepth);
															#line 5290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 301 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			e = _e;
															#line 302 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 5296 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1Catch2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		;
															#line 5311 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& __value,int loopDepth) 
	{
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		value = __value;
															#line 5320 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastWithErrorActor*>(this)->ActorCallback< IncrementalBroadcastWithErrorActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastWithErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!(i < output.size()))
															#line 5412 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 292 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output[i].send(value);
															#line 293 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if ((i + 1) % batchSize == 0)
															#line 5420 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 294 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(0);
															#line 294 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5426 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 2;
															#line 294 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastWithErrorActor, 1, Void >*>(static_cast<IncrementalBroadcastWithErrorActor*>(this)));
															#line 5431 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i++;
															#line 5458 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastWithErrorActor*>(this)->ActorCallback< IncrementalBroadcastWithErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastWithErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1Catch2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2loopBody1(int loopDepth) 
	{
															#line 302 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!(i < output.size()))
															#line 5580 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
			return a_body1Catch2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 303 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		output[i].sendError(e);
															#line 304 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if ((i + 1) % batchSize == 0)
															#line 5588 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 305 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delay(0);
															#line 305 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5594 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1Catch2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 3;
															#line 305 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementalBroadcastWithErrorActor, 2, Void >*>(static_cast<IncrementalBroadcastWithErrorActor*>(this)));
															#line 5599 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1Catch2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2break1(int loopDepth) 
	{
		try {
			return a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2loopBody1cont1(int loopDepth) 
	{
															#line 302 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		i++;
															#line 5626 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (loopDepth == 0) return a_body1Catch2loopHead1(0);

		return loopDepth;
	}
	int a_body1Catch2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state > 0) static_cast<IncrementalBroadcastWithErrorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalBroadcastWithErrorActor*>(this)->ActorCallback< IncrementalBroadcastWithErrorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementalBroadcastWithErrorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementalBroadcastWithErrorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<T> input;
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	std::vector<Promise<T>> output;
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int batchSize;
															#line 288 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	int i;
															#line 290 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	T value;
															#line 301 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Error e;
															#line 5730 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via incrementalBroadcastWithError()
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class IncrementalBroadcastWithErrorActor final : public Actor<Void>, public ActorCallback< IncrementalBroadcastWithErrorActor<T>, 0, T >, public ActorCallback< IncrementalBroadcastWithErrorActor<T>, 1, Void >, public ActorCallback< IncrementalBroadcastWithErrorActor<T>, 2, Void >, public FastAllocated<IncrementalBroadcastWithErrorActor<T>>, public IncrementalBroadcastWithErrorActorState<T, IncrementalBroadcastWithErrorActor<T>> {
															#line 5737 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<IncrementalBroadcastWithErrorActor<T>>::operator new;
	using FastAllocated<IncrementalBroadcastWithErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(769037520842958080UL, 3192956047699498752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalBroadcastWithErrorActor<T>, 0, T >;
friend struct ActorCallback< IncrementalBroadcastWithErrorActor<T>, 1, Void >;
friend struct ActorCallback< IncrementalBroadcastWithErrorActor<T>, 2, Void >;
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	IncrementalBroadcastWithErrorActor(Future<T> const& input,std::vector<Promise<T>> const& output,int const& batchSize) 
															#line 5756 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<Void>(),
		   IncrementalBroadcastWithErrorActorState<T, IncrementalBroadcastWithErrorActor<T>>(input, output, batchSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1390551743455648768UL, 13225986501383641088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalBroadcastWithErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalBroadcastWithError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalBroadcastWithError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementalBroadcastWithErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementalBroadcastWithErrorActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementalBroadcastWithErrorActor<T>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<Void> incrementalBroadcastWithError( Future<T> const& input, std::vector<Promise<T>> const& output, int const& batchSize ) {
															#line 286 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<Void>(new IncrementalBroadcastWithErrorActor<T>(input, output, batchSize));
															#line 5793 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 311 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

// Needed for the call to endpointNotFound()
#include "fdbrpc/FailureMonitor.h"

struct PeerHolder {
	Reference<Peer> peer;
	explicit PeerHolder(Reference<Peer> peer) : peer(peer) {
		if (peer) {
			peer->outstandingReplies++;
		}
	}
	~PeerHolder() {
		if (peer) {
			peer->outstandingReplies--;
		}
	}
};

// Implements getReplyStream, this a void actor with the same lifetime as the input ReplyPromiseStream.
// Because this actor holds a reference to the stream, normally it would be impossible to know when there are no other
// references. To get around this, there is a SAV inside the stream that has one less promise reference than it should
// (caused by getErrorFutureAndDelPromiseRef()). When that SAV gets a broken promise because no one besides this void
// actor is referencing it, this void actor will get a broken_promise dropping the final reference to the full
// ReplyPromiseStream
															#line 5821 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via endStreamOnDisconnect()
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X, class EndStreamOnDisconnectActor>
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class EndStreamOnDisconnectActorState {
															#line 5828 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	EndStreamOnDisconnectActorState(Future<Void> const& signal,ReplyPromiseStream<X> const& stream,Endpoint const& endpoint,Reference<Peer> const& peer = Reference<Peer>()) 
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : signal(signal),
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   stream(stream),
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   endpoint(endpoint),
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   peer(peer),
															#line 340 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   holder(PeerHolder(peer))
															#line 5843 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this));

	}
	~EndStreamOnDisconnectActorState() 
	{
		fdb_probe_actor_destroy("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			stream.setRequestStreamEndpoint(endpoint);
															#line 5858 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			try {
															#line 344 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = signal;
															#line 343 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 347 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_1 = peer.isValid() ? peer->disconnect.getFuture() : Never();
															#line 5866 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
															#line 350 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_2 = stream.getErrorFutureAndDelPromiseRef();
															#line 5870 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
				static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state = 1;
															#line 344 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EndStreamOnDisconnectActor, 0, Void >*>(static_cast<EndStreamOnDisconnectActor*>(this)));
															#line 347 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EndStreamOnDisconnectActor, 1, Void >*>(static_cast<EndStreamOnDisconnectActor*>(this)));
															#line 350 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EndStreamOnDisconnectActor, 2, Void >*>(static_cast<EndStreamOnDisconnectActor*>(this)));
															#line 5879 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<EndStreamOnDisconnectActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 353 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 5914 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 355 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (!stream.connected())
															#line 5918 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				{
															#line 356 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
					StrictFuture<Void> __when_expr_3 = signal || stream.onConnected();
															#line 356 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_3.get(), loopDepth); };
															#line 5924 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
					static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state = 2;
															#line 356 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< EndStreamOnDisconnectActor, 3, Void >*>(static_cast<EndStreamOnDisconnectActor*>(this)));
															#line 5928 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1Catch2cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		stream.sendError(connection_failed());
															#line 5959 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		stream.sendError(connection_failed());
															#line 5968 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		stream.sendError(connection_failed());
															#line 5977 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		stream.sendError(connection_failed());
															#line 5986 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state > 0) static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state = 0;
		static_cast<EndStreamOnDisconnectActor*>(this)->ActorCallback< EndStreamOnDisconnectActor, 0, Void >::remove();
		static_cast<EndStreamOnDisconnectActor*>(this)->ActorCallback< EndStreamOnDisconnectActor, 1, Void >::remove();
		static_cast<EndStreamOnDisconnectActor*>(this)->ActorCallback< EndStreamOnDisconnectActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EndStreamOnDisconnectActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EndStreamOnDisconnectActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EndStreamOnDisconnectActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 360 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		stream.notifyFailed();
															#line 6199 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state > 0) static_cast<EndStreamOnDisconnectActor*>(this)->actor_wait_state = 0;
		static_cast<EndStreamOnDisconnectActor*>(this)->ActorCallback< EndStreamOnDisconnectActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< EndStreamOnDisconnectActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< EndStreamOnDisconnectActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		delete static_cast<EndStreamOnDisconnectActor*>(this);
															#line 6301 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		return 0;

		return loopDepth;
	}
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<Void> signal;
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReplyPromiseStream<X> stream;
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Endpoint endpoint;
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Reference<Peer> peer;
															#line 340 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	PeerHolder holder;
															#line 6316 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via endStreamOnDisconnect()
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class EndStreamOnDisconnectActor final : public Actor<void>, public ActorCallback< EndStreamOnDisconnectActor<X>, 0, Void >, public ActorCallback< EndStreamOnDisconnectActor<X>, 1, Void >, public ActorCallback< EndStreamOnDisconnectActor<X>, 2, Void >, public ActorCallback< EndStreamOnDisconnectActor<X>, 3, Void >, public FastAllocated<EndStreamOnDisconnectActor<X>>, public EndStreamOnDisconnectActorState<X, EndStreamOnDisconnectActor<X>> {
															#line 6323 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<EndStreamOnDisconnectActor<X>>::operator new;
	using FastAllocated<EndStreamOnDisconnectActor<X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(459691088143773184UL, 5083399345666460672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< EndStreamOnDisconnectActor<X>, 0, Void >;
friend struct ActorCallback< EndStreamOnDisconnectActor<X>, 1, Void >;
friend struct ActorCallback< EndStreamOnDisconnectActor<X>, 2, Void >;
friend struct ActorCallback< EndStreamOnDisconnectActor<X>, 3, Void >;
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	EndStreamOnDisconnectActor(Future<Void> const& signal,ReplyPromiseStream<X> const& stream,Endpoint const& endpoint,Reference<Peer> const& peer = Reference<Peer>()) 
															#line 6343 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<void>(),
		   EndStreamOnDisconnectActorState<X, EndStreamOnDisconnectActor<X>>(signal, stream, endpoint, peer),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8081630550668594688UL, 16244017713865151488UL);
		ActorExecutionContextHelper __helper(static_cast<EndStreamOnDisconnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("endStreamOnDisconnect");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("endStreamOnDisconnect", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
void endStreamOnDisconnect( Future<Void> const& signal, ReplyPromiseStream<X> const& stream, Endpoint const& endpoint, Reference<Peer> const& peer = Reference<Peer>() ) {
															#line 335 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	new EndStreamOnDisconnectActor<X>(signal, stream, endpoint, peer);
															#line 6369 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 363 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

// Implements tryGetReply, getReplyUnlessFailedFor
															#line 6375 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via waitValueOrSignal()
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X, class WaitValueOrSignalActor>
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class WaitValueOrSignalActorState {
															#line 6382 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WaitValueOrSignalActorState(Future<X> const& value,Future<Void> const& signal,Endpoint const& endpoint,ReplyPromise<X> const& holdme = ReplyPromise<X>(),Reference<Peer> const& peer = Reference<Peer>()) 
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : value(value),
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   signal(signal),
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   endpoint(endpoint),
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   holdme(holdme),
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   peer(peer),
															#line 371 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   holder(PeerHolder(peer))
															#line 6399 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("waitValueOrSignal", reinterpret_cast<unsigned long>(this));

	}
	~WaitValueOrSignalActorState() 
	{
		fdb_probe_actor_destroy("waitValueOrSignal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 372 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			;
															#line 6414 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitValueOrSignalActorState();
		static_cast<WaitValueOrSignalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 375 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<X> __when_expr_0 = value;
															#line 374 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (static_cast<WaitValueOrSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6447 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 378 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = signal;
															#line 6451 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitValueOrSignalActor*>(this)->actor_wait_state = 1;
															#line 375 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitValueOrSignalActor, 0, X >*>(static_cast<WaitValueOrSignalActor*>(this)));
															#line 378 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitValueOrSignalActor, 1, Void >*>(static_cast<WaitValueOrSignalActor*>(this)));
															#line 6458 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 385 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (signal.isError())
															#line 6480 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 386 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				TraceEvent(SevError, "WaitValueOrSignalError").error(signal.getError());
															#line 387 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(ErrorOr<X>(internal_error())); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6486 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(ErrorOr<X>(internal_error()));
				this->~WaitValueOrSignalActorState();
				static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 390 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 6494 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 391 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6498 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 395 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() != error_code_broken_promise || signal.isError())
															#line 6502 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 396 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(ErrorOr<X>(e)); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6506 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(ErrorOr<X>(e));
				this->~WaitValueOrSignalActorState();
				static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 397 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			IFailureMonitor::failureMonitor().endpointNotFound(endpoint);
															#line 398 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			value = Never();
															#line 6516 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(X const& x,int loopDepth) 
	{
															#line 376 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(x); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6531 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(x);
		this->~WaitValueOrSignalActorState();
		static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(X && x,int loopDepth) 
	{
															#line 376 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(x); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6543 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(x);
		this->~WaitValueOrSignalActorState();
		static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 379 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(ErrorOr<X>(IFailureMonitor::failureMonitor().knownUnauthorized(endpoint) ? unauthorized_attempt() : request_maybe_delivered())); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6555 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(ErrorOr<X>(IFailureMonitor::failureMonitor().knownUnauthorized(endpoint) ? unauthorized_attempt() : request_maybe_delivered()));
		this->~WaitValueOrSignalActorState();
		static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 379 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<WaitValueOrSignalActor*>(this)->SAV<ErrorOr<X>>::futures) { (void)(ErrorOr<X>(IFailureMonitor::failureMonitor().knownUnauthorized(endpoint) ? unauthorized_attempt() : request_maybe_delivered())); this->~WaitValueOrSignalActorState(); static_cast<WaitValueOrSignalActor*>(this)->destroy(); return 0; }
															#line 6567 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<WaitValueOrSignalActor*>(this)->SAV< ErrorOr<X> >::value()) ErrorOr<X>(ErrorOr<X>(IFailureMonitor::failureMonitor().knownUnauthorized(endpoint) ? unauthorized_attempt() : request_maybe_delivered()));
		this->~WaitValueOrSignalActorState();
		static_cast<WaitValueOrSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitValueOrSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitValueOrSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitValueOrSignalActor*>(this)->ActorCallback< WaitValueOrSignalActor, 0, X >::remove();
		static_cast<WaitValueOrSignalActor*>(this)->ActorCallback< WaitValueOrSignalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitValueOrSignalActor, 0, X >*,X const& value) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitValueOrSignalActor, 0, X >*,X && value) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitValueOrSignalActor, 0, X >*,Error err) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitValueOrSignalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitValueOrSignalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitValueOrSignalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<X> value;
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<Void> signal;
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Endpoint endpoint;
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReplyPromise<X> holdme;
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Reference<Peer> peer;
															#line 371 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	PeerHolder holder;
															#line 6708 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via waitValueOrSignal()
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class WaitValueOrSignalActor final : public Actor<ErrorOr<X>>, public ActorCallback< WaitValueOrSignalActor<X>, 0, X >, public ActorCallback< WaitValueOrSignalActor<X>, 1, Void >, public FastAllocated<WaitValueOrSignalActor<X>>, public WaitValueOrSignalActorState<X, WaitValueOrSignalActor<X>> {
															#line 6715 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<WaitValueOrSignalActor<X>>::operator new;
	using FastAllocated<WaitValueOrSignalActor<X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3007224992398636800UL, 8845955219305204480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ErrorOr<X>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitValueOrSignalActor<X>, 0, X >;
friend struct ActorCallback< WaitValueOrSignalActor<X>, 1, Void >;
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	WaitValueOrSignalActor(Future<X> const& value,Future<Void> const& signal,Endpoint const& endpoint,ReplyPromise<X> const& holdme = ReplyPromise<X>(),Reference<Peer> const& peer = Reference<Peer>()) 
															#line 6733 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<ErrorOr<X>>(),
		   WaitValueOrSignalActorState<X, WaitValueOrSignalActor<X>>(value, signal, endpoint, holdme, peer),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitValueOrSignal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10394841400439412224UL, 14551502886970699264UL);
		ActorExecutionContextHelper __helper(static_cast<WaitValueOrSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitValueOrSignal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitValueOrSignal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitValueOrSignalActor<X>, 0, X >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<ErrorOr<X>> waitValueOrSignal( Future<X> const& value, Future<Void> const& signal, Endpoint const& endpoint, ReplyPromise<X> const& holdme = ReplyPromise<X>(), Reference<Peer> const& peer = Reference<Peer>() ) {
															#line 365 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<ErrorOr<X>>(new WaitValueOrSignalActor<X>(value, signal, endpoint, holdme, peer));
															#line 6768 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 402 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 6773 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via sendCanceler()
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T, class SendCancelerActor>
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class SendCancelerActorState {
															#line 6780 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	SendCancelerActorState(ReplyPromise<T> const& reply,ReliablePacket* const& send,Endpoint const& endpoint) 
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : reply(reply),
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   send(send),
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   endpoint(endpoint),
															#line 405 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   didCancelReliable(false)
															#line 6793 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("sendCanceler", reinterpret_cast<unsigned long>(this));

	}
	~SendCancelerActorState() 
	{
		fdb_probe_actor_destroy("sendCanceler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 407 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				;
															#line 6809 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendCancelerActorState();
		static_cast<SendCancelerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 427 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (!didCancelReliable)
															#line 6839 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 428 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				FlowTransport::transport().cancelReliable(send);
															#line 6843 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 430 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 6847 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 431 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				IFailureMonitor::failureMonitor().endpointNotFound(endpoint);
															#line 6851 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 433 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 6855 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 408 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (IFailureMonitor::failureMonitor().permanentlyFailed(endpoint))
															#line 6876 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		{
															#line 409 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			FlowTransport::transport().cancelReliable(send);
															#line 410 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			didCancelReliable = true;
															#line 411 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (IFailureMonitor::failureMonitor().knownUnauthorized(endpoint))
															#line 6884 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 412 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				return a_body1Catch2(unauthorized_attempt(), std::max(0, loopDepth - 1));
															#line 6888 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
			else
			{
															#line 414 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 414 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (static_cast<SendCancelerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6896 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SendCancelerActor*>(this)->actor_wait_state = 1;
															#line 414 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendCancelerActor, 0, Void >*>(static_cast<SendCancelerActor*>(this)));
															#line 6901 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 418 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = reply.getFuture();
															#line 417 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (static_cast<SendCancelerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6918 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 423 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = IFailureMonitor::failureMonitor().onStateChanged(endpoint);
															#line 6922 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<SendCancelerActor*>(this)->actor_wait_state = 2;
															#line 418 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendCancelerActor, 1, T >*>(static_cast<SendCancelerActor*>(this)));
															#line 423 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SendCancelerActor, 2, Void >*>(static_cast<SendCancelerActor*>(this)));
															#line 6929 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendCancelerActor*>(this)->actor_wait_state > 0) static_cast<SendCancelerActor*>(this)->actor_wait_state = 0;
		static_cast<SendCancelerActor*>(this)->ActorCallback< SendCancelerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendCancelerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(T const& t,int loopDepth) 
	{
															#line 419 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		FlowTransport::transport().cancelReliable(send);
															#line 420 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		didCancelReliable = true;
															#line 421 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<SendCancelerActor*>(this)->SAV<T>::futures) { (void)(t); this->~SendCancelerActorState(); static_cast<SendCancelerActor*>(this)->destroy(); return 0; }
															#line 7041 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<SendCancelerActor*>(this)->SAV< T >::value()) T(t);
		this->~SendCancelerActorState();
		static_cast<SendCancelerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(T && t,int loopDepth) 
	{
															#line 419 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		FlowTransport::transport().cancelReliable(send);
															#line 420 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		didCancelReliable = true;
															#line 421 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<SendCancelerActor*>(this)->SAV<T>::futures) { (void)(t); this->~SendCancelerActorState(); static_cast<SendCancelerActor*>(this)->destroy(); return 0; }
															#line 7057 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<SendCancelerActor*>(this)->SAV< T >::value()) T(t);
		this->~SendCancelerActorState();
		static_cast<SendCancelerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SendCancelerActor*>(this)->actor_wait_state > 0) static_cast<SendCancelerActor*>(this)->actor_wait_state = 0;
		static_cast<SendCancelerActor*>(this)->ActorCallback< SendCancelerActor, 1, T >::remove();
		static_cast<SendCancelerActor*>(this)->ActorCallback< SendCancelerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendCancelerActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SendCancelerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SendCancelerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReplyPromise<T> reply;
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReliablePacket* send;
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Endpoint endpoint;
															#line 405 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	bool didCancelReliable;
															#line 7206 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via sendCanceler()
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class SendCancelerActor final : public Actor<T>, public ActorCallback< SendCancelerActor<T>, 0, Void >, public ActorCallback< SendCancelerActor<T>, 1, T >, public ActorCallback< SendCancelerActor<T>, 2, Void >, public FastAllocated<SendCancelerActor<T>>, public SendCancelerActorState<T, SendCancelerActor<T>> {
															#line 7213 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<SendCancelerActor<T>>::operator new;
	using FastAllocated<SendCancelerActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10708209974255478016UL, 13988988533968526336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendCancelerActor<T>, 0, Void >;
friend struct ActorCallback< SendCancelerActor<T>, 1, T >;
friend struct ActorCallback< SendCancelerActor<T>, 2, Void >;
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	SendCancelerActor(ReplyPromise<T> const& reply,ReliablePacket* const& send,Endpoint const& endpoint) 
															#line 7232 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<T>(),
		   SendCancelerActorState<T, SendCancelerActor<T>>(reply, send, endpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendCanceler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14794441375181495296UL, 11283513300419985664UL);
		ActorExecutionContextHelper __helper(static_cast<SendCancelerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendCanceler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendCanceler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendCancelerActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SendCancelerActor<T>, 1, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class T>
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<T> sendCanceler( ReplyPromise<T> const& reply, ReliablePacket* const& send, Endpoint const& endpoint ) {
															#line 403 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<T>(new SendCancelerActor<T>(reply, send, endpoint));
															#line 7268 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 436 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

															#line 7273 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via reportEndpointFailure()
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X, class ReportEndpointFailureActor>
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ReportEndpointFailureActorState {
															#line 7280 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReportEndpointFailureActorState(Future<X> const& value,Endpoint const& endpoint) 
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		 : value(value),
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		   endpoint(endpoint)
															#line 7289 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("reportEndpointFailure", reinterpret_cast<unsigned long>(this));

	}
	~ReportEndpointFailureActorState() 
	{
		fdb_probe_actor_destroy("reportEndpointFailure", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 440 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				StrictFuture<X> __when_expr_0 = value;
															#line 440 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				if (static_cast<ReportEndpointFailureActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7307 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReportEndpointFailureActor*>(this)->actor_wait_state = 1;
															#line 440 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportEndpointFailureActor, 0, X >*>(static_cast<ReportEndpointFailureActor*>(this)));
															#line 7312 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportEndpointFailureActorState();
		static_cast<ReportEndpointFailureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 443 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 7342 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			{
															#line 444 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
				IFailureMonitor::failureMonitor().endpointNotFound(endpoint);
															#line 7346 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
			}
															#line 446 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 7350 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(X const& x,int loopDepth) 
	{
															#line 441 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<ReportEndpointFailureActor*>(this)->SAV<X>::futures) { (void)(x); this->~ReportEndpointFailureActorState(); static_cast<ReportEndpointFailureActor*>(this)->destroy(); return 0; }
															#line 7364 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<ReportEndpointFailureActor*>(this)->SAV< X >::value()) X(x);
		this->~ReportEndpointFailureActorState();
		static_cast<ReportEndpointFailureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(X && x,int loopDepth) 
	{
															#line 441 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
		if (!static_cast<ReportEndpointFailureActor*>(this)->SAV<X>::futures) { (void)(x); this->~ReportEndpointFailureActorState(); static_cast<ReportEndpointFailureActor*>(this)->destroy(); return 0; }
															#line 7376 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		new (&static_cast<ReportEndpointFailureActor*>(this)->SAV< X >::value()) X(x);
		this->~ReportEndpointFailureActorState();
		static_cast<ReportEndpointFailureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(X const& x,int loopDepth) 
	{
		loopDepth = a_body1cont2(x, loopDepth);

		return loopDepth;
	}
	int a_body1when1(X && x,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportEndpointFailureActor*>(this)->actor_wait_state > 0) static_cast<ReportEndpointFailureActor*>(this)->actor_wait_state = 0;
		static_cast<ReportEndpointFailureActor*>(this)->ActorCallback< ReportEndpointFailureActor, 0, X >::remove();

	}
	void a_callback_fire(ActorCallback< ReportEndpointFailureActor, 0, X >*,X const& value) 
	{
		fdb_probe_actor_enter("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportEndpointFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportEndpointFailureActor, 0, X >*,X && value) 
	{
		fdb_probe_actor_enter("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportEndpointFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportEndpointFailureActor, 0, X >*,Error err) 
	{
		fdb_probe_actor_enter("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportEndpointFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportEndpointFailure", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Future<X> value;
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	Endpoint endpoint;
															#line 7463 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
};
// This generated class is to be used only via reportEndpointFailure()
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
class ReportEndpointFailureActor final : public Actor<X>, public ActorCallback< ReportEndpointFailureActor<X>, 0, X >, public FastAllocated<ReportEndpointFailureActor<X>>, public ReportEndpointFailureActorState<X, ReportEndpointFailureActor<X>> {
															#line 7470 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
public:
	using FastAllocated<ReportEndpointFailureActor<X>>::operator new;
	using FastAllocated<ReportEndpointFailureActor<X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15640292981821204736UL, 9106540325785292032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<X>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportEndpointFailureActor<X>, 0, X >;
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	ReportEndpointFailureActor(Future<X> const& value,Endpoint const& endpoint) 
															#line 7487 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
		 : Actor<X>(),
		   ReportEndpointFailureActorState<X, ReportEndpointFailureActor<X>>(value, endpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reportEndpointFailure", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13580180669355110656UL, 12552375509477596672UL);
		ActorExecutionContextHelper __helper(static_cast<ReportEndpointFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportEndpointFailure");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportEndpointFailure", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportEndpointFailureActor<X>, 0, X >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
template <class X>
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
[[nodiscard]] Future<X> reportEndpointFailure( Future<X> const& value, Endpoint const& endpoint ) {
															#line 437 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"
	return Future<X>(new ReportEndpointFailureActor<X>(value, endpoint));
															#line 7522 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/genericactors.actor.g.h.py_gen"
}

#line 449 "/codebuild/output/src2000075677/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/genericactors.actor.h"

#include "flow/unactorcompiler.h"

#endif
